package com.intellij.thymeleaf.spring.security;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.thymeleaf.lang.ThymeleafExpressionsFileType;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import com.intellij.thymeleaf.lang.ThymeleafParserDefinition;
import com.intellij.thymeleaf.lang.ThymeleafPsiFile;
import org.jetbrains.annotations.NotNull;

public final class SpringSecurityExpressions extends ThymeleafParserDefinition {
  @Override
  public @NotNull IFileElementType getFileNodeType() {
    return THYMES_SPRING_SECURITY_TYPE;
  }

  @Override
  public @NotNull PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
    return new ThymeleafPsiFile(fileViewProvider, ThymeleafLanguage.SPRING_SECURITY_EXPRESSIONS) {

      @Override
      public @NotNull FileType getFileType() {
        return ThymeleafExpressionsFileType.SPRING_SECURITY_EXPRESSIONS;
      }
    };
  }
}
