// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/model.proto

package automl

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Deployment state of the model.
type Model_DeploymentState int32

const (
	// Should not be used, an un-set enum has this value by default.
	Model_DEPLOYMENT_STATE_UNSPECIFIED Model_DeploymentState = 0
	// Model is deployed.
	Model_DEPLOYED Model_DeploymentState = 1
	// Model is not deployed.
	Model_UNDEPLOYED Model_DeploymentState = 2
)

var Model_DeploymentState_name = map[int32]string{
	0: "DEPLOYMENT_STATE_UNSPECIFIED",
	1: "DEPLOYED",
	2: "UNDEPLOYED",
}

var Model_DeploymentState_value = map[string]int32{
	"DEPLOYMENT_STATE_UNSPECIFIED": 0,
	"DEPLOYED":                     1,
	"UNDEPLOYED":                   2,
}

func (x Model_DeploymentState) String() string {
	return proto.EnumName(Model_DeploymentState_name, int32(x))
}

func (Model_DeploymentState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_452845e4ed6fce9d, []int{0, 0}
}

// API proto representing a trained machine learning model.
type Model struct {
	// Required.
	// The model metadata that is specific to the problem type.
	// Must match the metadata type of the dataset used to train the model.
	//
	// Types that are valid to be assigned to ModelMetadata:
	//	*Model_TranslationModelMetadata
	//	*Model_ImageClassificationModelMetadata
	//	*Model_TextClassificationModelMetadata
	//	*Model_ImageObjectDetectionModelMetadata
	//	*Model_TextExtractionModelMetadata
	//	*Model_TextSentimentModelMetadata
	ModelMetadata isModel_ModelMetadata `protobuf_oneof:"model_metadata"`
	// Output only. Resource name of the model.
	// Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the model to show in the interface. The name can be
	// up to 32 characters long and can consist only of ASCII Latin letters A-Z
	// and a-z, underscores
	// (_), and ASCII digits 0-9. It must start with a letter.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The resource ID of the dataset used to create the model. The dataset must
	// come from the same ancestor project and location.
	DatasetId string `protobuf:"bytes,3,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Output only. Timestamp when the model training finished  and can be used for prediction.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this model was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Deployment state of the model. A model can only serve
	// prediction requests after it gets deployed.
	DeploymentState Model_DeploymentState `protobuf:"varint,8,opt,name=deployment_state,json=deploymentState,proto3,enum=google.cloud.automl.v1.Model_DeploymentState" json:"deployment_state,omitempty"`
	// Used to perform a consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. The labels with user-defined metadata to organize your model.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels               map[string]string `protobuf:"bytes,34,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Model) Reset()         { *m = Model{} }
func (m *Model) String() string { return proto.CompactTextString(m) }
func (*Model) ProtoMessage()    {}
func (*Model) Descriptor() ([]byte, []int) {
	return fileDescriptor_452845e4ed6fce9d, []int{0}
}

func (m *Model) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model.Unmarshal(m, b)
}
func (m *Model) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model.Marshal(b, m, deterministic)
}
func (m *Model) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model.Merge(m, src)
}
func (m *Model) XXX_Size() int {
	return xxx_messageInfo_Model.Size(m)
}
func (m *Model) XXX_DiscardUnknown() {
	xxx_messageInfo_Model.DiscardUnknown(m)
}

var xxx_messageInfo_Model proto.InternalMessageInfo

type isModel_ModelMetadata interface {
	isModel_ModelMetadata()
}

type Model_TranslationModelMetadata struct {
	TranslationModelMetadata *TranslationModelMetadata `protobuf:"bytes,15,opt,name=translation_model_metadata,json=translationModelMetadata,proto3,oneof"`
}

type Model_ImageClassificationModelMetadata struct {
	ImageClassificationModelMetadata *ImageClassificationModelMetadata `protobuf:"bytes,13,opt,name=image_classification_model_metadata,json=imageClassificationModelMetadata,proto3,oneof"`
}

type Model_TextClassificationModelMetadata struct {
	TextClassificationModelMetadata *TextClassificationModelMetadata `protobuf:"bytes,14,opt,name=text_classification_model_metadata,json=textClassificationModelMetadata,proto3,oneof"`
}

type Model_ImageObjectDetectionModelMetadata struct {
	ImageObjectDetectionModelMetadata *ImageObjectDetectionModelMetadata `protobuf:"bytes,20,opt,name=image_object_detection_model_metadata,json=imageObjectDetectionModelMetadata,proto3,oneof"`
}

type Model_TextExtractionModelMetadata struct {
	TextExtractionModelMetadata *TextExtractionModelMetadata `protobuf:"bytes,19,opt,name=text_extraction_model_metadata,json=textExtractionModelMetadata,proto3,oneof"`
}

type Model_TextSentimentModelMetadata struct {
	TextSentimentModelMetadata *TextSentimentModelMetadata `protobuf:"bytes,22,opt,name=text_sentiment_model_metadata,json=textSentimentModelMetadata,proto3,oneof"`
}

func (*Model_TranslationModelMetadata) isModel_ModelMetadata() {}

func (*Model_ImageClassificationModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextClassificationModelMetadata) isModel_ModelMetadata() {}

func (*Model_ImageObjectDetectionModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextExtractionModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextSentimentModelMetadata) isModel_ModelMetadata() {}

func (m *Model) GetModelMetadata() isModel_ModelMetadata {
	if m != nil {
		return m.ModelMetadata
	}
	return nil
}

func (m *Model) GetTranslationModelMetadata() *TranslationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TranslationModelMetadata); ok {
		return x.TranslationModelMetadata
	}
	return nil
}

func (m *Model) GetImageClassificationModelMetadata() *ImageClassificationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_ImageClassificationModelMetadata); ok {
		return x.ImageClassificationModelMetadata
	}
	return nil
}

func (m *Model) GetTextClassificationModelMetadata() *TextClassificationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextClassificationModelMetadata); ok {
		return x.TextClassificationModelMetadata
	}
	return nil
}

func (m *Model) GetImageObjectDetectionModelMetadata() *ImageObjectDetectionModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_ImageObjectDetectionModelMetadata); ok {
		return x.ImageObjectDetectionModelMetadata
	}
	return nil
}

func (m *Model) GetTextExtractionModelMetadata() *TextExtractionModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextExtractionModelMetadata); ok {
		return x.TextExtractionModelMetadata
	}
	return nil
}

func (m *Model) GetTextSentimentModelMetadata() *TextSentimentModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextSentimentModelMetadata); ok {
		return x.TextSentimentModelMetadata
	}
	return nil
}

func (m *Model) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Model) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Model) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *Model) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Model) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Model) GetDeploymentState() Model_DeploymentState {
	if m != nil {
		return m.DeploymentState
	}
	return Model_DEPLOYMENT_STATE_UNSPECIFIED
}

func (m *Model) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Model) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Model) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Model_TranslationModelMetadata)(nil),
		(*Model_ImageClassificationModelMetadata)(nil),
		(*Model_TextClassificationModelMetadata)(nil),
		(*Model_ImageObjectDetectionModelMetadata)(nil),
		(*Model_TextExtractionModelMetadata)(nil),
		(*Model_TextSentimentModelMetadata)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.automl.v1.Model_DeploymentState", Model_DeploymentState_name, Model_DeploymentState_value)
	proto.RegisterType((*Model)(nil), "google.cloud.automl.v1.Model")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.Model.LabelsEntry")
}

func init() { proto.RegisterFile("google/cloud/automl/v1/model.proto", fileDescriptor_452845e4ed6fce9d) }

var fileDescriptor_452845e4ed6fce9d = []byte{
	// 765 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x55, 0xd1, 0x4e, 0xe3, 0x46,
	0x14, 0xc5, 0xa1, 0x50, 0x98, 0xd0, 0x10, 0x4d, 0x11, 0x32, 0x01, 0x4a, 0x48, 0x55, 0x29, 0x7d,
	0xa8, 0xdd, 0x84, 0x87, 0x82, 0xa9, 0x54, 0x05, 0xe2, 0xb6, 0x91, 0x48, 0xa0, 0x49, 0x40, 0x6d,
	0x85, 0x6a, 0x4d, 0xec, 0xc1, 0x72, 0xd7, 0xf6, 0x58, 0xf6, 0x84, 0x25, 0x8b, 0x78, 0x5d, 0x69,
	0x1f, 0xf6, 0x79, 0xff, 0x81, 0x4f, 0xd9, 0x4f, 0xe1, 0x2b, 0x56, 0xbe, 0x63, 0x07, 0x88, 0xe2,
	0xe4, 0xed, 0xfa, 0x9e, 0x73, 0xee, 0x3d, 0x3e, 0x9e, 0x49, 0x50, 0xc5, 0x66, 0xcc, 0x76, 0xa9,
	0x6a, 0xba, 0x6c, 0x68, 0xa9, 0x64, 0xc8, 0x99, 0xe7, 0xaa, 0xb7, 0x35, 0xd5, 0x63, 0x16, 0x75,
	0x95, 0x20, 0x64, 0x9c, 0xe1, 0x4d, 0xc1, 0x51, 0x80, 0xa3, 0x08, 0x8e, 0x72, 0x5b, 0x2b, 0x6d,
	0x25, 0x5a, 0x12, 0x38, 0x6a, 0x48, 0x23, 0x36, 0x0c, 0x4d, 0x2a, 0x24, 0xa5, 0xac, 0xb1, 0x8e,
	0x47, 0xec, 0x94, 0xb3, 0x9f, 0xc1, 0xe1, 0xf4, 0x8e, 0x27, 0x94, 0x6a, 0x16, 0x25, 0x24, 0x7e,
	0xe4, 0x12, 0xee, 0x30, 0x3f, 0x61, 0xee, 0x25, 0x4c, 0x78, 0x1a, 0x0c, 0x6f, 0x54, 0xee, 0x78,
	0x34, 0xe2, 0xc4, 0x0b, 0x12, 0xc2, 0xce, 0x0b, 0xb3, 0xc4, 0xf7, 0x19, 0x07, 0x75, 0x24, 0xd0,
	0xca, 0xa7, 0x3c, 0x5a, 0x6a, 0xc7, 0xaf, 0x8c, 0x03, 0x54, 0x7a, 0x31, 0xdd, 0x80, 0x1c, 0x0c,
	0x8f, 0x72, 0x62, 0x11, 0x4e, 0xe4, 0xf5, 0xb2, 0x54, 0xcd, 0xd7, 0x7f, 0x56, 0xa6, 0x27, 0xa2,
	0xf4, 0x9f, 0x95, 0x30, 0xad, 0x9d, 0xe8, 0xfe, 0x5c, 0xe8, 0xca, 0x3c, 0x03, 0xc3, 0x1f, 0x24,
	0xf4, 0x3d, 0xe4, 0x62, 0x98, 0x2e, 0x89, 0x22, 0xe7, 0xc6, 0x31, 0xa7, 0xee, 0xfe, 0x06, 0x76,
	0x1f, 0x66, 0xed, 0x6e, 0xc5, 0x23, 0x4e, 0x5f, 0x4d, 0x98, 0xf4, 0x50, 0x76, 0xe6, 0x70, 0xf0,
	0x7b, 0x09, 0x55, 0xe2, 0xfc, 0xe7, 0x58, 0x29, 0x80, 0x95, 0x5f, 0x32, 0x63, 0xa0, 0x77, 0x7c,
	0xb6, 0x93, 0x3d, 0x3e, 0x9b, 0x82, 0x3f, 0x4a, 0xe8, 0x07, 0x11, 0x0a, 0x1b, 0xfc, 0x4f, 0x4d,
	0x6e, 0x58, 0x94, 0x53, 0x73, 0x9a, 0x97, 0x0d, 0xf0, 0x72, 0x34, 0x33, 0x96, 0x73, 0x98, 0xd1,
	0x4c, 0x47, 0x4c, 0xba, 0xd9, 0x77, 0xe6, 0x91, 0xf0, 0x3b, 0xf4, 0x1d, 0xe4, 0x42, 0xef, 0x78,
	0x48, 0xa6, 0xfa, 0xf8, 0x16, 0x7c, 0x1c, 0xcc, 0xca, 0x44, 0x1f, 0x8b, 0x27, 0x1d, 0x6c, 0xf3,
	0x6c, 0x18, 0xbf, 0x45, 0xbb, 0xb0, 0x3b, 0xa2, 0x7e, 0x7c, 0xaa, 0x7d, 0x3e, 0xb9, 0x7a, 0x13,
	0x56, 0xd7, 0x67, 0xad, 0xee, 0xa5, 0xda, 0xc9, 0xcd, 0x25, 0x9e, 0x89, 0x62, 0x8c, 0xbe, 0xf2,
	0x89, 0x47, 0x65, 0xa9, 0x2c, 0x55, 0x57, 0xbb, 0x50, 0xe3, 0x7d, 0xb4, 0x66, 0x39, 0x51, 0xe0,
	0x92, 0x91, 0x01, 0x58, 0x0e, 0xb0, 0x7c, 0xd2, 0xeb, 0xc4, 0x94, 0x5d, 0x84, 0x62, 0x79, 0x44,
	0xb9, 0xe1, 0x58, 0xf2, 0x22, 0x10, 0x56, 0x93, 0x4e, 0xcb, 0xc2, 0xc7, 0x28, 0x6f, 0x86, 0x94,
	0x70, 0x6a, 0xc4, 0x3b, 0xe5, 0xaf, 0xc1, 0x7c, 0x29, 0x35, 0x9f, 0x5e, 0x60, 0xa5, 0x9f, 0x5e,
	0xe0, 0x2e, 0x12, 0xf4, 0xb8, 0x11, 0x8b, 0x87, 0x81, 0x35, 0x16, 0xe7, 0xe7, 0x8b, 0x05, 0x1d,
	0xc4, 0x7f, 0xa3, 0xa2, 0x45, 0x03, 0x97, 0x8d, 0x20, 0xc4, 0x88, 0x13, 0x4e, 0xe5, 0x95, 0xb2,
	0x54, 0x2d, 0xd4, 0x7f, 0xca, 0xca, 0x0e, 0x02, 0x51, 0x9a, 0x63, 0x55, 0x2f, 0x16, 0x75, 0xd7,
	0xad, 0xd7, 0x8d, 0x38, 0x29, 0xca, 0x89, 0x2d, 0x23, 0x91, 0x54, 0x5c, 0xe3, 0x06, 0x5a, 0x76,
	0xc9, 0x80, 0xba, 0x91, 0x5c, 0x29, 0x2f, 0x56, 0xf3, 0xf5, 0x1f, 0x67, 0xef, 0x38, 0x03, 0xae,
	0xee, 0xf3, 0x70, 0xd4, 0x4d, 0x84, 0xa5, 0x23, 0x94, 0x7f, 0xd1, 0xc6, 0x45, 0xb4, 0xf8, 0x86,
	0x8e, 0x92, 0xcf, 0x11, 0x97, 0x78, 0x03, 0x2d, 0xdd, 0x12, 0x77, 0x98, 0x7e, 0x06, 0xf1, 0xa0,
	0xe5, 0x0e, 0xa5, 0xca, 0x5f, 0x68, 0x7d, 0xc2, 0x35, 0x2e, 0xa3, 0x9d, 0xa6, 0x7e, 0x71, 0x76,
	0xfe, 0x4f, 0x5b, 0xef, 0xf4, 0x8d, 0x5e, 0xbf, 0xd1, 0xd7, 0x8d, 0xcb, 0x4e, 0xef, 0x42, 0x3f,
	0x6d, 0xfd, 0xde, 0xd2, 0x9b, 0xc5, 0x05, 0xbc, 0x86, 0x56, 0x04, 0x43, 0x6f, 0x16, 0x25, 0x5c,
	0x40, 0xe8, 0xb2, 0x33, 0x7e, 0xce, 0x69, 0xe4, 0xa9, 0xf1, 0x1f, 0xda, 0x4e, 0x7c, 0x8b, 0x77,
	0x21, 0x81, 0x13, 0x29, 0x26, 0xf3, 0x54, 0xf1, 0xe3, 0xf9, 0x5b, 0x10, 0xb2, 0xf8, 0x12, 0x45,
	0xea, 0x7d, 0x52, 0x19, 0x8e, 0xf5, 0xa0, 0xba, 0x4c, 0x5c, 0xf1, 0x48, 0xbd, 0x4f, 0x4b, 0xe8,
	0xc3, 0x31, 0x8e, 0xd4, 0x7b, 0x71, 0x9c, 0x1d, 0xeb, 0xe1, 0xa4, 0x88, 0x0a, 0xaf, 0xcf, 0xf6,
	0xc9, 0xa3, 0x84, 0x4a, 0x26, 0xf3, 0x32, 0xb2, 0xbb, 0x90, 0xfe, 0xfd, 0x35, 0x41, 0x6c, 0xe6,
	0x12, 0xdf, 0x56, 0x58, 0x68, 0xab, 0x36, 0xf5, 0xe1, 0x24, 0xa8, 0xcf, 0x26, 0x27, 0xff, 0x42,
	0x8e, 0x45, 0xf5, 0x98, 0xdb, 0xfc, 0x43, 0xc8, 0x4f, 0x61, 0x70, 0x63, 0xc8, 0x59, 0xfb, 0x4c,
	0xb9, 0xaa, 0x7d, 0x4e, 0x81, 0x6b, 0x00, 0xae, 0x01, 0x70, 0xaf, 0xaf, 0x6a, 0x4f, 0xb9, 0x2d,
	0x01, 0x68, 0x1a, 0x20, 0x9a, 0x26, 0x34, 0x9a, 0x76, 0x55, 0x1b, 0x2c, 0xc3, 0xda, 0x83, 0x2f,
	0x01, 0x00, 0x00, 0xff, 0xff, 0x26, 0x0a, 0x02, 0xde, 0x56, 0x07, 0x00, 0x00,
}
