! $CLASSHG/codes/lapack/random/randomsys1.f90

program randomsys1
implicit none
integer, parameter :: nmax=1000
real(kind=8), dimension(nmax) :: b, x
real(kind=8), dimension(nmax,nmax) :: a
real(kind=8) :: err
integer :: i, info, lda, ldb, nrhs, n,iter
integer, dimension(nmax) :: ipiv

real(kind=8), dimension(84) :: z

z(1:84) = (/2.3962280929192509D-01, &
6.4346010490580374D-01, &
5.4886677265274941D-01, &
1.8435046456575191D-01, &
4.2690013698472401D-01, &
6.2760930131666248D-01, &
8.7243363936287288D-02, &
5.3710399529030350D-01, &
8.4474604576675638D-01, &
4.0947669295022632D-01, &
2.0315141244999760D-01, &
8.2714283129979482D-01, &
9.6582843029739029D-01, &
3.7773539690481128D-01, &
6.4713340225873406D-01, &
6.7774351756798612D-01, &
4.4568905572928591D-01, &
1.7208265726837521D-01, &
3.5202074329011412D-01, &
3.2913965083413110D-01, &
7.4682622623737438D-01, &
2.7151044969605542D-01, &
5.6129178633962351D-01, &
1.3244294692867761D-01, &
7.9837660640147112D-01, &
2.0595995860196409D-01, &
2.6555102564257749D-02, &
1.9623902644848701D-01, &
7.8452468963715605D-03, &
8.2177375597112101D-01, &
9.4444982187044924D-01, &
4.6799576958310329D-01, &
1.1359180530395520D-01, &
1.6049482525711320D-01, &
8.4523811016138373D-01, &
8.5370708147160490D-01, &
3.0139325968162661D-01, &
2.5117154067021252D-01, &
2.0086476380364379D-01, &
2.6078975734443288D-01, &
2.5710509100784901D-01, &
6.2861740244633146D-01, &
4.7397018497236110D-01, &
8.6989475348440182D-01, &
6.4860795895959611D-01, &
8.8943219043019872D-01, &
7.9524758401855578D-01, &
8.8016617212154102D-01, &
2.1472721943810300D-01, &
9.5183566464760194D-01, &
7.1911522894148772D-01, &
1.1065249711733080D-01, &
9.5745872307341484D-01, &
6.4694742306793951D-01, &
5.8182607574435841D-01, &
1.2922028370755401D-02, &
2.7617229134380777D-01, &
8.0045359255855852D-01, &
3.2789738555900377D-01, &
5.7940374386642890D-01, &
2.3961554431041750D-02, &
6.6990484757537938D-01, &
1.8144929371280860D-01, &
2.8661849362222419D-01, &
6.5845572125062690D-01, &
5.8896512277754309D-01, &
6.3697665190607378D-02, &
1.3281935295985961D-01, &
7.4166314172628711D-01, &
5.0033182787066932D-01, &
3.1440772963953763D-02, &
9.9073931564031925D-01, &
3.4236965949145941D-03, &
6.9929220728508257D-01, &
7.5905196170645428D-01, &
2.5421825141163590D-01, &
3.3146571845550887D-01, &
5.7286596840196446D-01, &
9.9158547964144228D-01, &
4.8967497301052382D-01, &
5.6113697207961410D-01, &
6.0641422150435165D-01, &
8.5675901647669139D-02, &
2.5817319326781851D-01/)
n =  21
info = 0

open(unit = 2,STATUS='REPLACE', file = "gen2tests.txt")
open(unit = 4, STATUS='REPLACE', file = "gen4tests.txt")
open(unit = 3,STATUS='REPLACE', file = "gen3tests.txt")
open(unit = 5,STATUS='REPLACE', file = "gen5tests.txt")

write(2,*) "{"
write(2,'(9999(g0))',advance="no") "z: []float64{"
do i = 1, 4*n
write (2,'(99999(e24.16,a))',advance="no") z(i), ","
end do
write (2,*) "},"
write(2,*) "n: " ,n,","


call dlasq2(n, z, info)

write(2,'(9999(g0))', advance="no") "zOut: []float64{"
do i = 1, 4*n
write (2,'(99999(e24.16,a))', advance="no") z(i), ","
end do
write (2,*) "},"
write(2,*) "info:", info, ","
write(2,*) "},"

print *, "Done fixed dlasq2"

close(5)
close(3)
close(4)
close(2)

! For random tests
n =  21

open(unit = 2, STATUS='REPLACE', file = "gen2tests.txt")
open(unit = 4, STATUS='REPLACE', file = "gen4tests.txt")
open(unit = 3, STATUS='REPLACE', file = "gen3tests.txt")
open(unit = 5, STATUS='REPLACE', file = "gen5tests.txt")

do iter = 1, 2

call random_number(z(1:4*n))

write(2,*) "{"
write(2,'(9999(g0))', advance="no") "z: []float64{"
do i = 1, 4*n
write (2,'(99999(e24.16,a))', advance="no") z(i), ","
end do
write (2,*) "},"
write(2,*) "n: " ,n,","

call dlasq2(n, z, info)

write(2,'(9999(g0))', advance="no") "zOut: []float64{"
do i = 1, 4*n
  write (2,'(99999(e24.16,a))', advance="no") z(i), ","
end do
write (2,*) "},"
write(2,*) "info:", info, ","
write(2,*) "},"

print *, "Done with dlasq2"

end do

close(5)
close(3)
close(4)
close(2)

end program randomsys1