#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_HFLAG_ATAPI_DMA_QUIRK = 536870912,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_EXPIRE_MULTI_CMD = 102,
	AUTOFS_IOC_PROTOSUBVER_CMD = 103,
	AUTOFS_IOC_ASKUMOUNT_CMD = 112,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_MAX_VALUES = 13,
};

enum {
	AXP15060_DCDC1 = 0,
	AXP15060_DCDC2 = 1,
	AXP15060_DCDC3 = 2,
	AXP15060_DCDC4 = 3,
	AXP15060_DCDC5 = 4,
	AXP15060_DCDC6 = 5,
	AXP15060_ALDO1 = 6,
	AXP15060_ALDO2 = 7,
	AXP15060_ALDO3 = 8,
	AXP15060_ALDO4 = 9,
	AXP15060_ALDO5 = 10,
	AXP15060_BLDO1 = 11,
	AXP15060_BLDO2 = 12,
	AXP15060_BLDO3 = 13,
	AXP15060_BLDO4 = 14,
	AXP15060_BLDO5 = 15,
	AXP15060_CLDO1 = 16,
	AXP15060_CLDO2 = 17,
	AXP15060_CLDO3 = 18,
	AXP15060_CLDO4 = 19,
	AXP15060_CPUSLDO = 20,
	AXP15060_SW = 21,
	AXP15060_RTC_LDO = 22,
	AXP15060_REG_ID_MAX = 23,
};

enum {
	AXP152_IRQ_LDO0IN_CONNECT = 1,
	AXP152_IRQ_LDO0IN_REMOVAL = 2,
	AXP152_IRQ_ALDO0IN_CONNECT = 3,
	AXP152_IRQ_ALDO0IN_REMOVAL = 4,
	AXP152_IRQ_DCDC1_V_LOW = 5,
	AXP152_IRQ_DCDC2_V_LOW = 6,
	AXP152_IRQ_DCDC3_V_LOW = 7,
	AXP152_IRQ_DCDC4_V_LOW = 8,
	AXP152_IRQ_PEK_SHORT = 9,
	AXP152_IRQ_PEK_LONG = 10,
	AXP152_IRQ_TIMER = 11,
	AXP152_IRQ_PEK_FAL_EDGE = 12,
	AXP152_IRQ_PEK_RIS_EDGE = 13,
	AXP152_IRQ_GPIO3_INPUT = 14,
	AXP152_IRQ_GPIO2_INPUT = 15,
	AXP152_IRQ_GPIO1_INPUT = 16,
	AXP152_IRQ_GPIO0_INPUT = 17,
};

enum {
	AXP20X_IRQ_ACIN_OVER_V = 1,
	AXP20X_IRQ_ACIN_PLUGIN = 2,
	AXP20X_IRQ_ACIN_REMOVAL = 3,
	AXP20X_IRQ_VBUS_OVER_V = 4,
	AXP20X_IRQ_VBUS_PLUGIN = 5,
	AXP20X_IRQ_VBUS_REMOVAL = 6,
	AXP20X_IRQ_VBUS_V_LOW = 7,
	AXP20X_IRQ_BATT_PLUGIN = 8,
	AXP20X_IRQ_BATT_REMOVAL = 9,
	AXP20X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP20X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP20X_IRQ_CHARG = 12,
	AXP20X_IRQ_CHARG_DONE = 13,
	AXP20X_IRQ_BATT_TEMP_HIGH = 14,
	AXP20X_IRQ_BATT_TEMP_LOW = 15,
	AXP20X_IRQ_DIE_TEMP_HIGH = 16,
	AXP20X_IRQ_CHARG_I_LOW = 17,
	AXP20X_IRQ_DCDC1_V_LONG = 18,
	AXP20X_IRQ_DCDC2_V_LONG = 19,
	AXP20X_IRQ_DCDC3_V_LONG = 20,
	AXP20X_IRQ_PEK_SHORT = 22,
	AXP20X_IRQ_PEK_LONG = 23,
	AXP20X_IRQ_N_OE_PWR_ON = 24,
	AXP20X_IRQ_N_OE_PWR_OFF = 25,
	AXP20X_IRQ_VBUS_VALID = 26,
	AXP20X_IRQ_VBUS_NOT_VALID = 27,
	AXP20X_IRQ_VBUS_SESS_VALID = 28,
	AXP20X_IRQ_VBUS_SESS_END = 29,
	AXP20X_IRQ_LOW_PWR_LVL1 = 30,
	AXP20X_IRQ_LOW_PWR_LVL2 = 31,
	AXP20X_IRQ_TIMER = 32,
	AXP20X_IRQ_PEK_FAL_EDGE = 33,
	AXP20X_IRQ_PEK_RIS_EDGE = 34,
	AXP20X_IRQ_GPIO3_INPUT = 35,
	AXP20X_IRQ_GPIO2_INPUT = 36,
	AXP20X_IRQ_GPIO1_INPUT = 37,
	AXP20X_IRQ_GPIO0_INPUT = 38,
};

enum {
	AXP20X_LDO1 = 0,
	AXP20X_LDO2 = 1,
	AXP20X_LDO3 = 2,
	AXP20X_LDO4 = 3,
	AXP20X_LDO5 = 4,
	AXP20X_DCDC2 = 5,
	AXP20X_DCDC3 = 6,
	AXP20X_REG_ID_MAX = 7,
};

enum {
	AXP22X_DCDC1 = 0,
	AXP22X_DCDC2 = 1,
	AXP22X_DCDC3 = 2,
	AXP22X_DCDC4 = 3,
	AXP22X_DCDC5 = 4,
	AXP22X_DC1SW = 5,
	AXP22X_DC5LDO = 6,
	AXP22X_ALDO1 = 7,
	AXP22X_ALDO2 = 8,
	AXP22X_ALDO3 = 9,
	AXP22X_ELDO1 = 10,
	AXP22X_ELDO2 = 11,
	AXP22X_ELDO3 = 12,
	AXP22X_DLDO1 = 13,
	AXP22X_DLDO2 = 14,
	AXP22X_DLDO3 = 15,
	AXP22X_DLDO4 = 16,
	AXP22X_RTC_LDO = 17,
	AXP22X_LDO_IO0 = 18,
	AXP22X_LDO_IO1 = 19,
	AXP22X_REG_ID_MAX = 20,
};

enum {
	AXP313A_DCDC1 = 0,
	AXP313A_DCDC2 = 1,
	AXP313A_DCDC3 = 2,
	AXP313A_ALDO1 = 3,
	AXP313A_DLDO1 = 4,
	AXP313A_RTC_LDO = 5,
	AXP313A_REG_ID_MAX = 6,
};

enum {
	AXP717_DCDC1 = 0,
	AXP717_DCDC2 = 1,
	AXP717_DCDC3 = 2,
	AXP717_DCDC4 = 3,
	AXP717_ALDO1 = 4,
	AXP717_ALDO2 = 5,
	AXP717_ALDO3 = 6,
	AXP717_ALDO4 = 7,
	AXP717_BLDO1 = 8,
	AXP717_BLDO2 = 9,
	AXP717_BLDO3 = 10,
	AXP717_BLDO4 = 11,
	AXP717_CLDO1 = 12,
	AXP717_CLDO2 = 13,
	AXP717_CLDO3 = 14,
	AXP717_CLDO4 = 15,
	AXP717_CPUSLDO = 16,
	AXP717_BOOST = 17,
	AXP717_REG_ID_MAX = 18,
};

enum {
	AXP803_DCDC1 = 0,
	AXP803_DCDC2 = 1,
	AXP803_DCDC3 = 2,
	AXP803_DCDC4 = 3,
	AXP803_DCDC5 = 4,
	AXP803_DCDC6 = 5,
	AXP803_DC1SW = 6,
	AXP803_ALDO1 = 7,
	AXP803_ALDO2 = 8,
	AXP803_ALDO3 = 9,
	AXP803_DLDO1 = 10,
	AXP803_DLDO2 = 11,
	AXP803_DLDO3 = 12,
	AXP803_DLDO4 = 13,
	AXP803_ELDO1 = 14,
	AXP803_ELDO2 = 15,
	AXP803_ELDO3 = 16,
	AXP803_FLDO1 = 17,
	AXP803_FLDO2 = 18,
	AXP803_RTC_LDO = 19,
	AXP803_LDO_IO0 = 20,
	AXP803_LDO_IO1 = 21,
	AXP803_REG_ID_MAX = 22,
};

enum {
	AXP806_DCDCA = 0,
	AXP806_DCDCB = 1,
	AXP806_DCDCC = 2,
	AXP806_DCDCD = 3,
	AXP806_DCDCE = 4,
	AXP806_ALDO1 = 5,
	AXP806_ALDO2 = 6,
	AXP806_ALDO3 = 7,
	AXP806_BLDO1 = 8,
	AXP806_BLDO2 = 9,
	AXP806_BLDO3 = 10,
	AXP806_BLDO4 = 11,
	AXP806_CLDO1 = 12,
	AXP806_CLDO2 = 13,
	AXP806_CLDO3 = 14,
	AXP806_SW = 15,
	AXP806_REG_ID_MAX = 16,
};

enum {
	AXP809_DCDC1 = 0,
	AXP809_DCDC2 = 1,
	AXP809_DCDC3 = 2,
	AXP809_DCDC4 = 3,
	AXP809_DCDC5 = 4,
	AXP809_DC1SW = 5,
	AXP809_DC5LDO = 6,
	AXP809_ALDO1 = 7,
	AXP809_ALDO2 = 8,
	AXP809_ALDO3 = 9,
	AXP809_ELDO1 = 10,
	AXP809_ELDO2 = 11,
	AXP809_ELDO3 = 12,
	AXP809_DLDO1 = 13,
	AXP809_DLDO2 = 14,
	AXP809_RTC_LDO = 15,
	AXP809_LDO_IO0 = 16,
	AXP809_LDO_IO1 = 17,
	AXP809_SW = 18,
	AXP809_REG_ID_MAX = 19,
};

enum {
	AXP813_DCDC1 = 0,
	AXP813_DCDC2 = 1,
	AXP813_DCDC3 = 2,
	AXP813_DCDC4 = 3,
	AXP813_DCDC5 = 4,
	AXP813_DCDC6 = 5,
	AXP813_DCDC7 = 6,
	AXP813_ALDO1 = 7,
	AXP813_ALDO2 = 8,
	AXP813_ALDO3 = 9,
	AXP813_DLDO1 = 10,
	AXP813_DLDO2 = 11,
	AXP813_DLDO3 = 12,
	AXP813_DLDO4 = 13,
	AXP813_ELDO1 = 14,
	AXP813_ELDO2 = 15,
	AXP813_ELDO3 = 16,
	AXP813_FLDO1 = 17,
	AXP813_FLDO2 = 18,
	AXP813_FLDO3 = 19,
	AXP813_RTC_LDO = 20,
	AXP813_LDO_IO0 = 21,
	AXP813_LDO_IO1 = 22,
	AXP813_SW = 23,
	AXP813_REG_ID_MAX = 24,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	B28_DPT_INI = 3584,
	B28_DPT_VAL = 3588,
	B28_DPT_CTRL = 3592,
	B28_DPT_TST = 3594,
};

enum {
	B28_Y2_SMB_CONFIG = 3648,
	B28_Y2_SMB_CSD_REG = 3652,
	B28_Y2_ASF_IRQ_V_BASE = 3680,
	B28_Y2_ASF_STAT_CMD = 3688,
	B28_Y2_ASF_HOST_COM = 3692,
	B28_Y2_DATA_REG_1 = 3696,
	B28_Y2_DATA_REG_2 = 3700,
	B28_Y2_DATA_REG_3 = 3704,
	B28_Y2_DATA_REG_4 = 3708,
};

enum {
	B6_EXT_REG = 768,
	B7_CFG_SPC = 896,
	B8_RQ1_REGS = 1024,
	B8_RQ2_REGS = 1152,
	B8_TS1_REGS = 1536,
	B8_TA1_REGS = 1664,
	B8_TS2_REGS = 1792,
	B8_TA2_REGS = 1920,
	B16_RAM_REGS = 2048,
};

enum {
	B8_Q_REGS = 1024,
	Q_D = 0,
	Q_VLAN = 32,
	Q_DONE = 36,
	Q_AC_L = 40,
	Q_AC_H = 44,
	Q_BC = 48,
	Q_CSR = 52,
	Q_TEST = 56,
	Q_WM = 64,
	Q_AL = 66,
	Q_RSP = 68,
	Q_RSL = 70,
	Q_RP = 72,
	Q_RL = 74,
	Q_WP = 76,
	Q_WSP = 77,
	Q_WL = 78,
	Q_WSL = 79,
};

enum {
	BASE_GMAC_1 = 10240,
	BASE_GMAC_2 = 14336,
};

enum {
	BD71837_REG_BUCK3_CTRL = 7,
	BD71837_REG_BUCK4_CTRL = 8,
	BD71837_REG_BUCK3_VOLT_RUN = 18,
	BD71837_REG_BUCK4_VOLT_RUN = 19,
	BD71837_REG_LDO7_VOLT = 30,
};

enum {
	BD718XX_BUCK1 = 0,
	BD718XX_BUCK2 = 1,
	BD718XX_BUCK3 = 2,
	BD718XX_BUCK4 = 3,
	BD718XX_BUCK5 = 4,
	BD718XX_BUCK6 = 5,
	BD718XX_BUCK7 = 6,
	BD718XX_BUCK8 = 7,
	BD718XX_LDO1 = 8,
	BD718XX_LDO2 = 9,
	BD718XX_LDO3 = 10,
	BD718XX_LDO4 = 11,
	BD718XX_LDO5 = 12,
	BD718XX_LDO6 = 13,
	BD718XX_LDO7 = 14,
	BD718XX_REGULATOR_AMOUNT = 15,
};

enum {
	BD718XX_INT_STBY_REQ = 0,
	BD718XX_INT_ON_REQ = 1,
	BD718XX_INT_WDOG = 2,
	BD718XX_INT_PWRBTN = 3,
	BD718XX_INT_PWRBTN_L = 4,
	BD718XX_INT_PWRBTN_S = 5,
	BD718XX_INT_SWRST = 6,
};

enum {
	BD718XX_REG_REV = 0,
	BD718XX_REG_SWRESET = 1,
	BD718XX_REG_I2C_DEV = 2,
	BD718XX_REG_PWRCTRL0 = 3,
	BD718XX_REG_PWRCTRL1 = 4,
	BD718XX_REG_BUCK1_CTRL = 5,
	BD718XX_REG_BUCK2_CTRL = 6,
	BD718XX_REG_1ST_NODVS_BUCK_CTRL = 9,
	BD718XX_REG_2ND_NODVS_BUCK_CTRL = 10,
	BD718XX_REG_3RD_NODVS_BUCK_CTRL = 11,
	BD718XX_REG_4TH_NODVS_BUCK_CTRL = 12,
	BD718XX_REG_BUCK1_VOLT_RUN = 13,
	BD718XX_REG_BUCK1_VOLT_IDLE = 14,
	BD718XX_REG_BUCK1_VOLT_SUSP = 15,
	BD718XX_REG_BUCK2_VOLT_RUN = 16,
	BD718XX_REG_BUCK2_VOLT_IDLE = 17,
	BD718XX_REG_1ST_NODVS_BUCK_VOLT = 20,
	BD718XX_REG_2ND_NODVS_BUCK_VOLT = 21,
	BD718XX_REG_3RD_NODVS_BUCK_VOLT = 22,
	BD718XX_REG_4TH_NODVS_BUCK_VOLT = 23,
	BD718XX_REG_LDO1_VOLT = 24,
	BD718XX_REG_LDO2_VOLT = 25,
	BD718XX_REG_LDO3_VOLT = 26,
	BD718XX_REG_LDO4_VOLT = 27,
	BD718XX_REG_LDO5_VOLT = 28,
	BD718XX_REG_LDO6_VOLT = 29,
	BD718XX_REG_TRANS_COND0 = 31,
	BD718XX_REG_TRANS_COND1 = 32,
	BD718XX_REG_VRFAULTEN = 33,
	BD718XX_REG_MVRFLTMASK0 = 34,
	BD718XX_REG_MVRFLTMASK1 = 35,
	BD718XX_REG_MVRFLTMASK2 = 36,
	BD718XX_REG_RCVCFG = 37,
	BD718XX_REG_RCVNUM = 38,
	BD718XX_REG_PWRONCONFIG0 = 39,
	BD718XX_REG_PWRONCONFIG1 = 40,
	BD718XX_REG_RESETSRC = 41,
	BD718XX_REG_MIRQ = 42,
	BD718XX_REG_IRQ = 43,
	BD718XX_REG_IN_MON = 44,
	BD718XX_REG_POW_STATE = 45,
	BD718XX_REG_OUT32K = 46,
	BD718XX_REG_REGLOCK = 47,
	BD718XX_REG_OTPVER = 255,
	BD718XX_MAX_REGISTER = 256,
};

enum {
	BIAS = 2147483648,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_QUIET = 2,
	BIO_CHAIN = 3,
	BIO_REFFED = 4,
	BIO_BPS_THROTTLED = 5,
	BIO_TRACE_COMPLETION = 6,
	BIO_CGROUP_ACCT = 7,
	BIO_QOS_THROTTLED = 8,
	BIO_TG_BPS_THROTTLED = 8,
	BIO_QOS_MERGED = 9,
	BIO_REMAPPED = 10,
	BIO_ZONE_WRITE_PLUGGING = 11,
	BIO_EMULATES_ZONE_APPEND = 12,
	BIO_FLAG_LAST = 13,
};

enum {
	BLINK_42MS = 0,
	BLINK_84MS = 1,
	BLINK_170MS = 2,
	BLINK_340MS = 3,
	BLINK_670MS = 4,
};

enum {
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_TAG_RR = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_MAX = 128,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BMU_IDLE = -2147483648,
	BMU_RX_TCP_PKT = 1073741824,
	BMU_RX_IP_PKT = 536870912,
	BMU_ENA_RX_RSS_HASH = 32768,
	BMU_DIS_RX_RSS_HASH = 16384,
	BMU_ENA_RX_CHKSUM = 8192,
	BMU_DIS_RX_CHKSUM = 4096,
	BMU_CLR_IRQ_PAR = 2048,
	BMU_CLR_IRQ_TCP = 2048,
	BMU_CLR_IRQ_CHK = 1024,
	BMU_STOP = 512,
	BMU_START = 256,
	BMU_FIFO_OP_ON = 128,
	BMU_FIFO_OP_OFF = 64,
	BMU_FIFO_ENA = 32,
	BMU_FIFO_RST = 16,
	BMU_OP_ON = 8,
	BMU_OP_OFF = 4,
	BMU_RST_CLR = 2,
	BMU_RST_SET = 1,
	BMU_CLR_RESET = 22,
	BMU_OPER_INIT = 3368,
	BMU_WM_DEFAULT = 1536,
	BMU_WM_PEX = 128,
};

enum {
	BOOST_ILMIN_75MA = 0,
	BOOST_ILMIN_100MA = 1,
	BOOST_ILMIN_125MA = 2,
	BOOST_ILMIN_150MA = 3,
	BOOST_ILMIN_175MA = 4,
	BOOST_ILMIN_200MA = 5,
	BOOST_ILMIN_225MA = 6,
	BOOST_ILMIN_250MA = 7,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
	BPF_F_IPV6 = 128,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
	BPF_MAX_TIMED_LOOPS = 65535,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
	BPF_SOCK_OPS_TSTAMP_SCHED_CB = 16,
	BPF_SOCK_OPS_TSTAMP_SND_SW_CB = 17,
	BPF_SOCK_OPS_TSTAMP_SND_HW_CB = 18,
	BPF_SOCK_OPS_TSTAMP_ACK_CB = 19,
	BPF_SOCK_OPS_TSTAMP_SENDMSG_CB = 20,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BUCK_ILMIN_50MA = 0,
	BUCK_ILMIN_100MA = 1,
	BUCK_ILMIN_150MA = 2,
	BUCK_ILMIN_200MA = 3,
	BUCK_ILMIN_250MA = 4,
	BUCK_ILMIN_300MA = 5,
	BUCK_ILMIN_350MA = 6,
	BUCK_ILMIN_400MA = 7,
};

enum {
	CACHE_VALID = 0,
	CACHE_NEGATIVE = 1,
	CACHE_PENDING = 2,
	CACHE_CLEANED = 3,
};

enum {
	CFG_CHIP_R_MSK = 240,
	CFG_DIS_M2_CLK = 2,
	CFG_SNG_MAC = 1,
};

enum {
	CFG_LED_MODE_MSK = 28,
	CFG_LINK_2_AVAIL = 2,
	CFG_LINK_1_AVAIL = 1,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CHIP_ID_YUKON_XL = 179,
	CHIP_ID_YUKON_EC_U = 180,
	CHIP_ID_YUKON_EX = 181,
	CHIP_ID_YUKON_EC = 182,
	CHIP_ID_YUKON_FE = 183,
	CHIP_ID_YUKON_FE_P = 184,
	CHIP_ID_YUKON_SUPR = 185,
	CHIP_ID_YUKON_UL_2 = 186,
	CHIP_ID_YUKON_OPT = 188,
	CHIP_ID_YUKON_PRM = 189,
	CHIP_ID_YUKON_OP_2 = 190,
};

enum {
	CLK_QSPI_APB = 0,
	CLK_QSPI_AHB = 1,
	CLK_QSPI_NUM = 2,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	CPU_WDOG = 3656,
	CPU_CNTR = 3660,
	CPU_TIM = 3664,
	CPU_AHB_ADDR = 3668,
	CPU_AHB_WDATA = 3672,
	CPU_AHB_RDATA = 3676,
	HCU_MAP_BASE = 3680,
	CPU_AHB_CTRL = 3684,
	HCU_CCSR = 3688,
	HCU_HCSR = 3692,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 250,
	CRNG_RESEED_INTERVAL = 15000,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CRYPTO_MSG_BASE = 16,
	CRYPTO_MSG_NEWALG = 16,
	CRYPTO_MSG_DELALG = 17,
	CRYPTO_MSG_UPDATEALG = 18,
	CRYPTO_MSG_GETALG = 19,
	CRYPTO_MSG_DELRNG = 20,
	CRYPTO_MSG_GETSTAT = 21,
	__CRYPTO_MSG_MAX = 22,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
	CSI_DEC_hl_BRACKETED_PASTE = 2004,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_FIRST = 2,
	DIR_OFFSET_EOD = 2147483647,
};

enum {
	DIR_OFFSET_MIN = 3,
	DIR_OFFSET_MAX = 2147483646,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DP83867_PORT_MIRROING_KEEP = 0,
	DP83867_PORT_MIRROING_EN = 1,
	DP83867_PORT_MIRROING_DIS = 2,
};

enum {
	DPT_START = 2,
	DPT_STOP = 1,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_CNT = 3,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_CODE_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_CODE_OK = 1,
	ETHTOOL_A_CABLE_RESULT_CODE_OPEN = 2,
	ETHTOOL_A_CABLE_RESULT_CODE_SAME_SHORT = 3,
	ETHTOOL_A_CABLE_RESULT_CODE_CROSS_SHORT = 4,
	ETHTOOL_A_CABLE_RESULT_CODE_IMPEDANCE_MISMATCH = 5,
	ETHTOOL_A_CABLE_RESULT_CODE_NOISE = 6,
	ETHTOOL_A_CABLE_RESULT_CODE_RESOLUTION_NOT_POSSIBLE = 7,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	__ETHTOOL_A_PSE_CNT = 14,
	ETHTOOL_A_PSE_MAX = 13,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	ETHTOOL_A_RINGS_HDS_THRESH = 17,
	ETHTOOL_A_RINGS_HDS_THRESH_MAX = 18,
	__ETHTOOL_A_RINGS_CNT = 19,
	ETHTOOL_A_RINGS_MAX = 18,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	__ETHTOOL_A_RSS_CNT = 8,
	ETHTOOL_A_RSS_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_PHY_RX_PKTS = 0,
	ETHTOOL_A_STATS_PHY_RX_BYTES = 1,
	ETHTOOL_A_STATS_PHY_RX_ERRORS = 2,
	ETHTOOL_A_STATS_PHY_TX_PKTS = 3,
	ETHTOOL_A_STATS_PHY_TX_BYTES = 4,
	ETHTOOL_A_STATS_PHY_TX_ERRORS = 5,
	__ETHTOOL_A_STATS_PHY_CNT = 6,
	ETHTOOL_A_STATS_PHY_MAX = 5,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSCONFIG_UNSPEC = 0,
	ETHTOOL_A_TSCONFIG_HEADER = 1,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_PROVIDER = 2,
	ETHTOOL_A_TSCONFIG_TX_TYPES = 3,
	ETHTOOL_A_TSCONFIG_RX_FILTERS = 4,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_FLAGS = 5,
	__ETHTOOL_A_TSCONFIG_CNT = 6,
	ETHTOOL_A_TSCONFIG_MAX = 5,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	ETHTOOL_A_TSINFO_HWTSTAMP_PROVIDER = 7,
	ETHTOOL_A_TSINFO_HWTSTAMP_SOURCE = 8,
	ETHTOOL_A_TSINFO_HWTSTAMP_PHYINDEX = 9,
	__ETHTOOL_A_TSINFO_CNT = 10,
	ETHTOOL_A_TSINFO_MAX = 9,
};

enum {
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_UNSPEC = 0,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_INDEX = 1,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_QUALIFIER = 2,
	__ETHTOOL_A_TS_HWTSTAMP_PROVIDER_CNT = 3,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_MAX = 2,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	ETHTOOL_A_TS_STAT_TX_ONESTEP_PKTS_UNCONFIRMED = 4,
	__ETHTOOL_A_TS_STAT_CNT = 5,
	ETHTOOL_A_TS_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	ETHTOOL_MSG_TSCONFIG_GET_REPLY = 47,
	ETHTOOL_MSG_TSCONFIG_SET_REPLY = 48,
	__ETHTOOL_MSG_KERNEL_CNT = 49,
	ETHTOOL_MSG_KERNEL_MAX = 48,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_ACT = 44,
	ETHTOOL_MSG_PHY_GET = 45,
	ETHTOOL_MSG_TSCONFIG_GET = 46,
	ETHTOOL_MSG_TSCONFIG_SET = 47,
	__ETHTOOL_MSG_USER_CNT = 48,
	ETHTOOL_MSG_USER_MAX = 47,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	ETHTOOL_STATS_PHY = 4,
	__ETHTOOL_STATS_CNT = 5,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
	ETHTOOL_UDP_TUNNEL_TYPE_MAX = 2,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_CMD_COMPLETE = 0,
	EVENT_XFER_COMPLETE = 1,
	EVENT_DATA_COMPLETE = 2,
	EVENT_DATA_ERROR = 3,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
	EVENT_FILE_FL_FREED = 2048,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_FLAGS_RESIZING = 0,
	EXT4_FLAGS_SHUTDOWN = 1,
	EXT4_FLAGS_BDEV_IS_DAX = 2,
	EXT4_FLAGS_EMERGENCY_RO = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
	EXT4_MF_JOURNAL_DESTROY = 2,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_FC_FLUSHING_DATA = 11,
	EXT4_STATE_ORPHAN_FILE = 12,
};

enum {
	FAN53526_CHIP_ID_01 = 1,
};

enum {
	FAN53526_CHIP_REV_08 = 8,
};

enum {
	FAN53555_CHIP_ID_00 = 0,
	FAN53555_CHIP_ID_01 = 1,
	FAN53555_CHIP_ID_02 = 2,
	FAN53555_CHIP_ID_03 = 3,
	FAN53555_CHIP_ID_04 = 4,
	FAN53555_CHIP_ID_05 = 5,
	FAN53555_CHIP_ID_08 = 8,
};

enum {
	FAN53555_CHIP_REV_00 = 3,
	FAN53555_CHIP_REV_13 = 15,
};

enum {
	FAN53555_VSEL_ID_0 = 0,
	FAN53555_VSEL_ID_1 = 1,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FATTR4_CLONE_BLKSIZE = 77,
	FATTR4_SPACE_FREED = 78,
	FATTR4_CHANGE_ATTR_TYPE = 79,
	FATTR4_SEC_LABEL = 80,
};

enum {
	FATTR4_DIR_NOTIF_DELAY = 56,
	FATTR4_DIRENT_NOTIF_DELAY = 57,
	FATTR4_DACL = 58,
	FATTR4_SACL = 59,
	FATTR4_CHANGE_POLICY = 60,
	FATTR4_FS_STATUS = 61,
	FATTR4_FS_LAYOUT_TYPES = 62,
	FATTR4_LAYOUT_HINT = 63,
	FATTR4_LAYOUT_TYPES = 64,
	FATTR4_LAYOUT_BLKSIZE = 65,
	FATTR4_LAYOUT_ALIGNMENT = 66,
	FATTR4_FS_LOCATIONS_INFO = 67,
	FATTR4_MDSTHRESHOLD = 68,
	FATTR4_RETENTION_GET = 69,
	FATTR4_RETENTION_SET = 70,
	FATTR4_RETENTEVT_GET = 71,
	FATTR4_RETENTEVT_SET = 72,
	FATTR4_RETENTION_HOLD = 73,
	FATTR4_MODE_SET_MASKED = 74,
	FATTR4_SUPPATTR_EXCLCREAT = 75,
	FATTR4_FS_CHARSET_CAP = 76,
};

enum {
	FATTR4_MODE_UMASK = 81,
};

enum {
	FATTR4_OPEN_ARGUMENTS = 86,
};

enum {
	FATTR4_SUPPORTED_ATTRS = 0,
	FATTR4_TYPE = 1,
	FATTR4_FH_EXPIRE_TYPE = 2,
	FATTR4_CHANGE = 3,
	FATTR4_SIZE = 4,
	FATTR4_LINK_SUPPORT = 5,
	FATTR4_SYMLINK_SUPPORT = 6,
	FATTR4_NAMED_ATTR = 7,
	FATTR4_FSID = 8,
	FATTR4_UNIQUE_HANDLES = 9,
	FATTR4_LEASE_TIME = 10,
	FATTR4_RDATTR_ERROR = 11,
	FATTR4_ACL = 12,
	FATTR4_ACLSUPPORT = 13,
	FATTR4_ARCHIVE = 14,
	FATTR4_CANSETTIME = 15,
	FATTR4_CASE_INSENSITIVE = 16,
	FATTR4_CASE_PRESERVING = 17,
	FATTR4_CHOWN_RESTRICTED = 18,
	FATTR4_FILEHANDLE = 19,
	FATTR4_FILEID = 20,
	FATTR4_FILES_AVAIL = 21,
	FATTR4_FILES_FREE = 22,
	FATTR4_FILES_TOTAL = 23,
	FATTR4_FS_LOCATIONS = 24,
	FATTR4_HIDDEN = 25,
	FATTR4_HOMOGENEOUS = 26,
	FATTR4_MAXFILESIZE = 27,
	FATTR4_MAXLINK = 28,
	FATTR4_MAXNAME = 29,
	FATTR4_MAXREAD = 30,
	FATTR4_MAXWRITE = 31,
	FATTR4_MIMETYPE = 32,
	FATTR4_MODE = 33,
	FATTR4_NO_TRUNC = 34,
	FATTR4_NUMLINKS = 35,
	FATTR4_OWNER = 36,
	FATTR4_OWNER_GROUP = 37,
	FATTR4_QUOTA_AVAIL_HARD = 38,
	FATTR4_QUOTA_AVAIL_SOFT = 39,
	FATTR4_QUOTA_USED = 40,
	FATTR4_RAWDEV = 41,
	FATTR4_SPACE_AVAIL = 42,
	FATTR4_SPACE_FREE = 43,
	FATTR4_SPACE_TOTAL = 44,
	FATTR4_SPACE_USED = 45,
	FATTR4_SYSTEM = 46,
	FATTR4_TIME_ACCESS = 47,
	FATTR4_TIME_ACCESS_SET = 48,
	FATTR4_TIME_BACKUP = 49,
	FATTR4_TIME_CREATE = 50,
	FATTR4_TIME_DELTA = 51,
	FATTR4_TIME_METADATA = 52,
	FATTR4_TIME_MODIFY = 53,
	FATTR4_TIME_MODIFY_SET = 54,
	FATTR4_MOUNTED_ON_FILEID = 55,
};

enum {
	FATTR4_TIME_DELEG_ACCESS = 84,
};

enum {
	FATTR4_TIME_DELEG_MODIFY = 85,
};

enum {
	FATTR4_XATTR_SUPPORT = 82,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FILEID_HIGH_OFF = 0,
	FILEID_LOW_OFF = 1,
	FILE_I_TYPE_OFF = 2,
	EMBED_FH_OFF = 3,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FP_FRE = 0,
	FP_FR0 = 1,
	FP_FR1 = 2,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	F_TX_CHK_AUTO_OFF = -2147483648,
	F_TX_CHK_AUTO_ON = 1073741824,
	F_M_RX_RAM_DIS = 16777216,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GLB_GPIO_CLK_DEB_ENA = -2147483648,
	GLB_GPIO_CLK_DBG_MSK = 1006632960,
	GLB_GPIO_INT_RST_D3_DIS = 32768,
	GLB_GPIO_LED_PAD_SPEED_UP = 16384,
	GLB_GPIO_STAT_RACE_DIS = 8192,
	GLB_GPIO_TEST_SEL_MSK = 6144,
	GLB_GPIO_TEST_SEL_BASE = 2048,
	GLB_GPIO_RAND_ENA = 1024,
	GLB_GPIO_RAND_BIT_1 = 512,
};

enum {
	GMAC_CTRL = 3840,
	GPHY_CTRL = 3844,
	GMAC_IRQ_SRC = 3848,
	GMAC_IRQ_MSK = 3852,
	GMAC_LINK_CTRL = 3856,
	WOL_CTRL_STAT = 3872,
	WOL_MATCH_CTL = 3874,
	WOL_MATCH_RES = 3875,
	WOL_MAC_ADDR = 3876,
	WOL_PATT_RPTR = 3884,
	WOL_PATT_LEN_LO = 3888,
	WOL_PATT_LEN_HI = 3892,
	WOL_PATT_CNT_0 = 3896,
	WOL_PATT_CNT_4 = 3900,
};

enum {
	GMAC_TI_ST_VAL = 3604,
	GMAC_TI_ST_CTRL = 3608,
	GMAC_TI_ST_TST = 3610,
};

enum {
	GMC_SET_RST = 32768,
	GMC_SEC_RST_OFF = 16384,
	GMC_BYP_MACSECRX_ON = 8192,
	GMC_BYP_MACSECRX_OFF = 4096,
	GMC_BYP_MACSECTX_ON = 2048,
	GMC_BYP_MACSECTX_OFF = 1024,
	GMC_BYP_RETR_ON = 512,
	GMC_BYP_RETR_OFF = 256,
	GMC_H_BURST_ON = 128,
	GMC_H_BURST_OFF = 64,
	GMC_F_LOOPB_ON = 32,
	GMC_F_LOOPB_OFF = 16,
	GMC_PAUSE_ON = 8,
	GMC_PAUSE_OFF = 4,
	GMC_RST_CLR = 2,
	GMC_RST_SET = 1,
};

enum {
	GMLC_RST_CLR = 2,
	GMLC_RST_SET = 1,
};

enum {
	GMR_FS_LEN = 2147418112,
	GMR_FS_VLAN = 8192,
	GMR_FS_JABBER = 4096,
	GMR_FS_UN_SIZE = 2048,
	GMR_FS_MC = 1024,
	GMR_FS_BC = 512,
	GMR_FS_RX_OK = 256,
	GMR_FS_GOOD_FC = 128,
	GMR_FS_BAD_FC = 64,
	GMR_FS_MII_ERR = 32,
	GMR_FS_LONG_ERR = 16,
	GMR_FS_FRAGMENT = 8,
	GMR_FS_CRC_ERR = 2,
	GMR_FS_RX_FF_OV = 1,
	GMR_FS_ANY_ERR = 6267,
};

enum {
	GMT_ST_START = 4,
	GMT_ST_STOP = 2,
	GMT_ST_CLR_IRQ = 1,
};

enum {
	GM_GPCR_PROM_ENA = 16384,
	GM_GPCR_FC_TX_DIS = 8192,
	GM_GPCR_TX_ENA = 4096,
	GM_GPCR_RX_ENA = 2048,
	GM_GPCR_BURST_ENA = 1024,
	GM_GPCR_LOOP_ENA = 512,
	GM_GPCR_PART_ENA = 256,
	GM_GPCR_GIGS_ENA = 128,
	GM_GPCR_FL_PASS = 64,
	GM_GPCR_DUP_FULL = 32,
	GM_GPCR_FC_RX_DIS = 16,
	GM_GPCR_SPEED_100 = 8,
	GM_GPCR_AU_DUP_DIS = 4,
	GM_GPCR_AU_FCT_DIS = 2,
	GM_GPCR_AU_SPD_DIS = 1,
};

enum {
	GM_GP_STAT = 0,
	GM_GP_CTRL = 4,
	GM_TX_CTRL = 8,
	GM_RX_CTRL = 12,
	GM_TX_FLOW_CTRL = 16,
	GM_TX_PARAM = 20,
	GM_SERIAL_MODE = 24,
	GM_SRC_ADDR_1L = 28,
	GM_SRC_ADDR_1M = 32,
	GM_SRC_ADDR_1H = 36,
	GM_SRC_ADDR_2L = 40,
	GM_SRC_ADDR_2M = 44,
	GM_SRC_ADDR_2H = 48,
	GM_MC_ADDR_H1 = 52,
	GM_MC_ADDR_H2 = 56,
	GM_MC_ADDR_H3 = 60,
	GM_MC_ADDR_H4 = 64,
	GM_TX_IRQ_SRC = 68,
	GM_RX_IRQ_SRC = 72,
	GM_TR_IRQ_SRC = 76,
	GM_TX_IRQ_MSK = 80,
	GM_RX_IRQ_MSK = 84,
	GM_TR_IRQ_MSK = 88,
	GM_SMI_CTRL = 128,
	GM_SMI_DATA = 132,
	GM_PHY_ADDR = 136,
	GM_MIB_CNT_BASE = 256,
	GM_MIB_CNT_END = 604,
};

enum {
	GM_IS_TX_CO_OV = 32,
	GM_IS_RX_CO_OV = 16,
	GM_IS_TX_FF_UR = 8,
	GM_IS_TX_COMPL = 4,
	GM_IS_RX_FF_OR = 2,
	GM_IS_RX_COMPL = 1,
};

enum {
	GM_PAR_MIB_CLR = 32,
	GM_PAR_MIB_TST = 16,
};

enum {
	GM_RXCR_UCF_ENA = 32768,
	GM_RXCR_MCF_ENA = 16384,
	GM_RXCR_CRC_DIS = 8192,
	GM_RXCR_PASS_FC = 4096,
};

enum {
	GM_RXF_UC_OK = 256,
	GM_RXF_BC_OK = 264,
	GM_RXF_MPAUSE = 272,
	GM_RXF_MC_OK = 280,
	GM_RXF_FCS_ERR = 288,
	GM_RXO_OK_LO = 304,
	GM_RXO_OK_HI = 312,
	GM_RXO_ERR_LO = 320,
	GM_RXO_ERR_HI = 328,
	GM_RXF_SHT = 336,
	GM_RXE_FRAG = 344,
	GM_RXF_64B = 352,
	GM_RXF_127B = 360,
	GM_RXF_255B = 368,
	GM_RXF_511B = 376,
	GM_RXF_1023B = 384,
	GM_RXF_1518B = 392,
	GM_RXF_MAX_SZ = 400,
	GM_RXF_LNG_ERR = 408,
	GM_RXF_JAB_PKT = 416,
	GM_RXE_FIFO_OV = 432,
	GM_TXF_UC_OK = 448,
	GM_TXF_BC_OK = 456,
	GM_TXF_MPAUSE = 464,
	GM_TXF_MC_OK = 472,
	GM_TXO_OK_LO = 480,
	GM_TXO_OK_HI = 488,
	GM_TXF_64B = 496,
	GM_TXF_127B = 504,
	GM_TXF_255B = 512,
	GM_TXF_511B = 520,
	GM_TXF_1023B = 528,
	GM_TXF_1518B = 536,
	GM_TXF_MAX_SZ = 544,
	GM_TXF_COL = 560,
	GM_TXF_LAT_COL = 568,
	GM_TXF_ABO_COL = 576,
	GM_TXF_MUL_COL = 584,
	GM_TXF_SNG_COL = 592,
	GM_TXE_FIFO_UR = 600,
};

enum {
	GM_SMI_CT_PHY_A_MSK = 63488,
	GM_SMI_CT_REG_A_MSK = 1984,
	GM_SMI_CT_OP_RD = 32,
	GM_SMI_CT_RD_VAL = 16,
	GM_SMI_CT_BUSY = 8,
};

enum {
	GM_SMOD_DATABL_MSK = 63488,
	GM_SMOD_LIMIT_4 = 1024,
	GM_SMOD_VLAN_ENA = 512,
	GM_SMOD_JUMBO_ENA = 256,
	GM_NEW_FLOW_CTRL = 64,
	GM_SMOD_IPG_MSK = 31,
};

enum {
	GM_TXCR_FORCE_JAM = 32768,
	GM_TXCR_CRC_DIS = 16384,
	GM_TXCR_PAD_DIS = 8192,
	GM_TXCR_COL_THR_MSK = 7168,
};

enum {
	GM_TXPA_JAMLEN_MSK = 49152,
	GM_TXPA_JAMIPG_MSK = 15872,
	GM_TXPA_JAMDAT_MSK = 496,
	GM_TXPA_BO_LIM_MSK = 15,
	TX_JAM_LEN_DEF = 3,
	TX_JAM_IPG_DEF = 11,
	TX_IPG_JAM_DEF = 28,
	TX_BOF_LIM_DEF = 4,
};

enum {
	GPC_TX_PAUSE = 1073741824,
	GPC_RX_PAUSE = 536870912,
	GPC_SPEED = 402653184,
	GPC_LINK = 67108864,
	GPC_DUPLEX = 33554432,
	GPC_CLOCK = 16777216,
	GPC_PDOWN = 8388608,
	GPC_TSTMODE = 4194304,
	GPC_REG18 = 2097152,
	GPC_REG12SEL = 1572864,
	GPC_REG18SEL = 393216,
	GPC_SPILOCK = 65536,
	GPC_LEDMUX = 49152,
	GPC_INTPOL = 8192,
	GPC_DETECT = 4096,
	GPC_1000HD = 2048,
	GPC_SLAVE = 1024,
	GPC_PAUSE = 512,
	GPC_LEDCTL = 192,
	GPC_RST_CLR = 2,
	GPC_RST_SET = 1,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	GSSX_NULL = 0,
	GSSX_INDICATE_MECHS = 1,
	GSSX_GET_CALL_CONTEXT = 2,
	GSSX_IMPORT_AND_CANON_NAME = 3,
	GSSX_EXPORT_CRED = 4,
	GSSX_IMPORT_CRED = 5,
	GSSX_ACQUIRE_CRED = 6,
	GSSX_STORE_CRED = 7,
	GSSX_INIT_SEC_CONTEXT = 8,
	GSSX_ACCEPT_SEC_CONTEXT = 9,
	GSSX_RELEASE_HANDLE = 10,
	GSSX_GET_MIC = 11,
	GSSX_VERIFY = 12,
	GSSX_WRAP = 13,
	GSSX_UNWRAP = 14,
	GSSX_WRAP_SIZE_LIMIT = 15,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	__HANDSHAKE_A_ACCEPT_MAX = 9,
	HANDSHAKE_A_ACCEPT_MAX = 8,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_TCP_IPV6_EX_CTRL = 32,
	HASH_IPV6_EX_CTRL = 16,
	HASH_TCP_IPV6_CTRL = 8,
	HASH_IPV6_CTRL = 4,
	HASH_TCP_IPV4_CTRL = 2,
	HASH_IPV4_CTRL = 1,
	HASH_ALL = 63,
};

enum {
	HAS_READ = 1,
	HAS_WRITE = 2,
	HAS_LSEEK = 4,
	HAS_POLL = 8,
	HAS_IOCTL = 16,
};

enum {
	HCU_CCSR_SMBALERT_MONITOR = 134217728,
	HCU_CCSR_CPU_SLEEP = 67108864,
	HCU_CCSR_CS_TO = 33554432,
	HCU_CCSR_WDOG = 16777216,
	HCU_CCSR_CLR_IRQ_HOST = 131072,
	HCU_CCSR_SET_IRQ_HCU = 65536,
	HCU_CCSR_AHB_RST = 512,
	HCU_CCSR_CPU_RST_MODE = 256,
	HCU_CCSR_SET_SYNC_CPU = 32,
	HCU_CCSR_CPU_CLK_DIVIDE_MSK = 24,
	HCU_CCSR_CPU_CLK_DIVIDE_BASE = 8,
	HCU_CCSR_OS_PRSNT = 4,
	HCU_CCSR_UC_STATE_MSK = 3,
	HCU_CCSR_UC_STATE_BASE = 1,
	HCU_CCSR_ASF_RESET = 0,
	HCU_CCSR_ASF_HALTED = 2,
	HCU_CCSR_ASF_RUNNING = 1,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HTE_TS_REGISTERED = 0,
	HTE_TS_REQ = 1,
	HTE_TS_DISABLE = 2,
	HTE_TS_QUEUE_WK = 3,
};

enum {
	HUF_flags_bmi2 = 1,
	HUF_flags_optimalDepth = 2,
	HUF_flags_preferRepeat = 4,
	HUF_flags_suspectUncompressible = 8,
	HUF_flags_disableAsm = 16,
	HUF_flags_disableFast = 32,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_OWNER = 128,
	OP_TCPWRITE = 17,
	OP_TCPSTART = 18,
	OP_TCPINIT = 20,
	OP_TCPLCK = 24,
	OP_TCPCHKSUM = 18,
	OP_TCPIS = 22,
	OP_TCPLW = 25,
	OP_TCPLSW = 27,
	OP_TCPLISW = 31,
	OP_ADDR64 = 33,
	OP_VLAN = 34,
	OP_ADDR64VLAN = 35,
	OP_LRGLEN = 36,
	OP_LRGLENVLAN = 38,
	OP_MSS = 40,
	OP_MSSVLAN = 42,
	OP_BUFFER = 64,
	OP_PACKET = 65,
	OP_LARGESEND = 67,
	OP_LSOV2 = 69,
	OP_RXSTAT = 96,
	OP_RXTIMESTAMP = 97,
	OP_RXVLAN = 98,
	OP_RXCHKS = 100,
	OP_RXCHKSVLAN = 102,
	OP_RXTIMEVLAN = 99,
	OP_RSS_HASH = 101,
	OP_TXINDEXLE = 104,
	OP_MACSEC = 108,
	OP_PUTIDX = 112,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IEEE754_CLASS_NORM = 0,
	IEEE754_CLASS_ZERO = 1,
	IEEE754_CLASS_DNORM = 2,
	IEEE754_CLASS_INF = 3,
	IEEE754_CLASS_SNAN = 4,
	IEEE754_CLASS_QNAN = 5,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_TUN_UNSPEC = 0,
	IFLA_TUN_OWNER = 1,
	IFLA_TUN_GROUP = 2,
	IFLA_TUN_TYPE = 3,
	IFLA_TUN_PI = 4,
	IFLA_TUN_VNET_HDR = 5,
	IFLA_TUN_PERSIST = 6,
	IFLA_TUN_MULTI_QUEUE = 7,
	IFLA_TUN_NUM_QUEUES = 8,
	IFLA_TUN_NUM_DISABLED_QUEUES = 9,
	__IFLA_TUN_MAX = 10,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	IFLA_NETNS_IMMUTABLE = 67,
	__IFLA_MAX = 68,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	INBAND_CISCO_SGMII = 0,
	INBAND_BASEX = 1,
};

enum {
	INET_DIAG_BC_NOP = 0,
	INET_DIAG_BC_JMP = 1,
	INET_DIAG_BC_S_GE = 2,
	INET_DIAG_BC_S_LE = 3,
	INET_DIAG_BC_D_GE = 4,
	INET_DIAG_BC_D_LE = 5,
	INET_DIAG_BC_AUTO = 6,
	INET_DIAG_BC_S_COND = 7,
	INET_DIAG_BC_D_COND = 8,
	INET_DIAG_BC_DEV_COND = 9,
	INET_DIAG_BC_MARK_COND = 10,
	INET_DIAG_BC_S_EQ = 11,
	INET_DIAG_BC_D_EQ = 12,
	INET_DIAG_BC_CGROUP_COND = 13,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
	INSN_F_DST_REG_STACK = 1024,
	INSN_F_SRC_REG_STACK = 2048,
};

enum {
	INTERRUPT_MASK_ALL_VER_11 = 204799,
	INTERRUPT_MASK_ALL_VER_21 = 466943,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_INC = 2,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMUFD_ACCESS_RW_READ = 0,
	IOMMUFD_ACCESS_RW_WRITE = 1,
	IOMMUFD_ACCESS_RW_KTHREAD = 2,
	__IOMMUFD_ACCESS_RW_SLOW_PATH = 4,
};

enum {
	IOMMU_PASID_ARRAY_DOMAIN = 0,
	IOMMU_PASID_ARRAY_HANDLE = 1,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_COMPLETE = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_RETRY = -11,
	IOU_REQUEUE = -3072,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_IMU_DEST = 1,
	IO_IMU_SOURCE = 2,
};

enum {
	IO_REGION_F_VMAP = 1,
	IO_REGION_F_USER_PROVIDED = 2,
	IO_REGION_F_SINGLE_REF = 4,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_AGGFRAG = 144,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_NOECTPKTS = 4,
	IPSTATS_MIB_ECT1PKTS = 5,
	IPSTATS_MIB_ECT0PKTS = 6,
	IPSTATS_MIB_CEPKTS = 7,
	IPSTATS_MIB_OUTREQUESTS = 8,
	IPSTATS_MIB_OUTPKTS = 9,
	IPSTATS_MIB_OUTOCTETS = 10,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 11,
	IPSTATS_MIB_INHDRERRORS = 12,
	IPSTATS_MIB_INTOOBIGERRORS = 13,
	IPSTATS_MIB_INNOROUTES = 14,
	IPSTATS_MIB_INADDRERRORS = 15,
	IPSTATS_MIB_INUNKNOWNPROTOS = 16,
	IPSTATS_MIB_INTRUNCATEDPKTS = 17,
	IPSTATS_MIB_INDISCARDS = 18,
	IPSTATS_MIB_OUTDISCARDS = 19,
	IPSTATS_MIB_OUTNOROUTES = 20,
	IPSTATS_MIB_REASMTIMEOUT = 21,
	IPSTATS_MIB_REASMREQDS = 22,
	IPSTATS_MIB_REASMOKS = 23,
	IPSTATS_MIB_REASMFAILS = 24,
	IPSTATS_MIB_FRAGOKS = 25,
	IPSTATS_MIB_FRAGFAILS = 26,
	IPSTATS_MIB_FRAGCREATES = 27,
	IPSTATS_MIB_INMCASTPKTS = 28,
	IPSTATS_MIB_OUTMCASTPKTS = 29,
	IPSTATS_MIB_INBCASTPKTS = 30,
	IPSTATS_MIB_OUTBCASTPKTS = 31,
	IPSTATS_MIB_INMCASTOCTETS = 32,
	IPSTATS_MIB_OUTMCASTOCTETS = 33,
	IPSTATS_MIB_INBCASTOCTETS = 34,
	IPSTATS_MIB_OUTBCASTOCTETS = 35,
	IPSTATS_MIB_CSUMERRORS = 36,
	IPSTATS_MIB_REASM_OVERLAPS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
	IRQCHIP_MOVE_DEFERRED = 4096,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_MSI_IMMUTABLE = 2048,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
	KF_ARG_RES_SPIN_LOCK_ID = 6,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LED_PAR_CTRL_COLX = 0,
	LED_PAR_CTRL_ERROR = 1,
	LED_PAR_CTRL_DUPLEX = 2,
	LED_PAR_CTRL_DP_COL = 3,
	LED_PAR_CTRL_SPEED = 4,
	LED_PAR_CTRL_LINK = 5,
	LED_PAR_CTRL_TX = 6,
	LED_PAR_CTRL_RX = 7,
	LED_PAR_CTRL_ACT = 8,
	LED_PAR_CTRL_LNK_RX = 9,
	LED_PAR_CTRL_LNK_AC = 10,
	LED_PAR_CTRL_ACT_BL = 11,
	LED_PAR_CTRL_TX_BL = 12,
	LED_PAR_CTRL_RX_BL = 13,
	LED_PAR_CTRL_COL_BL = 14,
	LED_PAR_CTRL_INACT = 15,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_LPM_ON_ATI = 134217728,
	ATA_QUIRK_NO_ID_DEV_LOG = 268435456,
	ATA_QUIRK_NO_LOG_DIR = 536870912,
	ATA_QUIRK_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINKLED_OFF = 1,
	LINKLED_ON = 2,
	LINKLED_LINKSYNC_OFF = 4,
	LINKLED_LINKSYNC_ON = 8,
	LINKLED_BLINK_OFF = 16,
	LINKLED_BLINK_ON = 32,
};

enum {
	LINK_CAPA_10HD = 0,
	LINK_CAPA_10FD = 1,
	LINK_CAPA_100HD = 2,
	LINK_CAPA_100FD = 3,
	LINK_CAPA_1000HD = 4,
	LINK_CAPA_1000FD = 5,
	LINK_CAPA_2500FD = 6,
	LINK_CAPA_5000FD = 7,
	LINK_CAPA_10000FD = 8,
	LINK_CAPA_20000FD = 9,
	LINK_CAPA_25000FD = 10,
	LINK_CAPA_40000FD = 11,
	LINK_CAPA_50000FD = 12,
	LINK_CAPA_56000FD = 13,
	LINK_CAPA_100000FD = 14,
	LINK_CAPA_200000FD = 15,
	LINK_CAPA_400000FD = 16,
	LINK_CAPA_800000FD = 17,
	__LINK_CAPA_MAX = 18,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_TSECRREJECTED = 16,
	LINUX_MIB_PAWS_OLD_ACK = 17,
	LINUX_MIB_PAWS_TW_REJECTED = 18,
	LINUX_MIB_DELAYEDACKS = 19,
	LINUX_MIB_DELAYEDACKLOCKED = 20,
	LINUX_MIB_DELAYEDACKLOST = 21,
	LINUX_MIB_LISTENOVERFLOWS = 22,
	LINUX_MIB_LISTENDROPS = 23,
	LINUX_MIB_TCPHPHITS = 24,
	LINUX_MIB_TCPPUREACKS = 25,
	LINUX_MIB_TCPHPACKS = 26,
	LINUX_MIB_TCPRENORECOVERY = 27,
	LINUX_MIB_TCPSACKRECOVERY = 28,
	LINUX_MIB_TCPSACKRENEGING = 29,
	LINUX_MIB_TCPSACKREORDER = 30,
	LINUX_MIB_TCPRENOREORDER = 31,
	LINUX_MIB_TCPTSREORDER = 32,
	LINUX_MIB_TCPFULLUNDO = 33,
	LINUX_MIB_TCPPARTIALUNDO = 34,
	LINUX_MIB_TCPDSACKUNDO = 35,
	LINUX_MIB_TCPLOSSUNDO = 36,
	LINUX_MIB_TCPLOSTRETRANSMIT = 37,
	LINUX_MIB_TCPRENOFAILURES = 38,
	LINUX_MIB_TCPSACKFAILURES = 39,
	LINUX_MIB_TCPLOSSFAILURES = 40,
	LINUX_MIB_TCPFASTRETRANS = 41,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 42,
	LINUX_MIB_TCPTIMEOUTS = 43,
	LINUX_MIB_TCPLOSSPROBES = 44,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 45,
	LINUX_MIB_TCPRENORECOVERYFAIL = 46,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 47,
	LINUX_MIB_TCPRCVCOLLAPSED = 48,
	LINUX_MIB_TCPDSACKOLDSENT = 49,
	LINUX_MIB_TCPDSACKOFOSENT = 50,
	LINUX_MIB_TCPDSACKRECV = 51,
	LINUX_MIB_TCPDSACKOFORECV = 52,
	LINUX_MIB_TCPABORTONDATA = 53,
	LINUX_MIB_TCPABORTONCLOSE = 54,
	LINUX_MIB_TCPABORTONMEMORY = 55,
	LINUX_MIB_TCPABORTONTIMEOUT = 56,
	LINUX_MIB_TCPABORTONLINGER = 57,
	LINUX_MIB_TCPABORTFAILED = 58,
	LINUX_MIB_TCPMEMORYPRESSURES = 59,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 60,
	LINUX_MIB_TCPSACKDISCARD = 61,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 62,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 63,
	LINUX_MIB_TCPSPURIOUSRTOS = 64,
	LINUX_MIB_TCPMD5NOTFOUND = 65,
	LINUX_MIB_TCPMD5UNEXPECTED = 66,
	LINUX_MIB_TCPMD5FAILURE = 67,
	LINUX_MIB_SACKSHIFTED = 68,
	LINUX_MIB_SACKMERGED = 69,
	LINUX_MIB_SACKSHIFTFALLBACK = 70,
	LINUX_MIB_TCPBACKLOGDROP = 71,
	LINUX_MIB_PFMEMALLOCDROP = 72,
	LINUX_MIB_TCPMINTTLDROP = 73,
	LINUX_MIB_TCPDEFERACCEPTDROP = 74,
	LINUX_MIB_IPRPFILTER = 75,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 76,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 77,
	LINUX_MIB_TCPREQQFULLDROP = 78,
	LINUX_MIB_TCPRETRANSFAIL = 79,
	LINUX_MIB_TCPRCVCOALESCE = 80,
	LINUX_MIB_TCPBACKLOGCOALESCE = 81,
	LINUX_MIB_TCPOFOQUEUE = 82,
	LINUX_MIB_TCPOFODROP = 83,
	LINUX_MIB_TCPOFOMERGE = 84,
	LINUX_MIB_TCPCHALLENGEACK = 85,
	LINUX_MIB_TCPSYNCHALLENGE = 86,
	LINUX_MIB_TCPFASTOPENACTIVE = 87,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 88,
	LINUX_MIB_TCPFASTOPENPASSIVE = 89,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 90,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 91,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 92,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 93,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 94,
	LINUX_MIB_BUSYPOLLRXPACKETS = 95,
	LINUX_MIB_TCPAUTOCORKING = 96,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 97,
	LINUX_MIB_TCPTOZEROWINDOWADV = 98,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 99,
	LINUX_MIB_TCPSYNRETRANS = 100,
	LINUX_MIB_TCPORIGDATASENT = 101,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 102,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 103,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 104,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 105,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 106,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 107,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 108,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 109,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 110,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 111,
	LINUX_MIB_TCPWINPROBE = 112,
	LINUX_MIB_TCPKEEPALIVE = 113,
	LINUX_MIB_TCPMTUPFAIL = 114,
	LINUX_MIB_TCPMTUPSUCCESS = 115,
	LINUX_MIB_TCPDELIVERED = 116,
	LINUX_MIB_TCPDELIVEREDCE = 117,
	LINUX_MIB_TCPACKCOMPRESSED = 118,
	LINUX_MIB_TCPZEROWINDOWDROP = 119,
	LINUX_MIB_TCPRCVQDROP = 120,
	LINUX_MIB_TCPWQUEUETOOBIG = 121,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 122,
	LINUX_MIB_TCPTIMEOUTREHASH = 123,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 124,
	LINUX_MIB_TCPDSACKRECVSEGS = 125,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 126,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 127,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 128,
	LINUX_MIB_TCPPLBREHASH = 129,
	LINUX_MIB_TCPAOREQUIRED = 130,
	LINUX_MIB_TCPAOBAD = 131,
	LINUX_MIB_TCPAOKEYNOTFOUND = 132,
	LINUX_MIB_TCPAOGOOD = 133,
	LINUX_MIB_TCPAODROPPEDICMPS = 134,
	__LINUX_MIB_MAX = 135,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	LINUX_MIB_TLSRXREKEYOK = 13,
	LINUX_MIB_TLSRXREKEYERROR = 14,
	LINUX_MIB_TLSTXREKEYOK = 15,
	LINUX_MIB_TLSTXREKEYERROR = 16,
	LINUX_MIB_TLSRXREKEYRECEIVED = 17,
	__LINUX_MIB_TLSMAX = 18,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	LINUX_MIB_XFRMINIPTFSERROR = 31,
	LINUX_MIB_XFRMOUTNOQSPACE = 32,
	__LINUX_MIB_XFRMMAX = 33,
};

enum {
	LK_STATE_IN_USE = 0,
	NFS_DELEGATED_STATE = 1,
	NFS_OPEN_STATE = 2,
	NFS_O_RDONLY_STATE = 3,
	NFS_O_WRONLY_STATE = 4,
	NFS_O_RDWR_STATE = 5,
	NFS_STATE_RECLAIM_REBOOT = 6,
	NFS_STATE_RECLAIM_NOGRACE = 7,
	NFS_STATE_POSIX_LOCKS = 8,
	NFS_STATE_RECOVERY_FAILED = 9,
	NFS_STATE_MAY_NOTIFY_LOCK = 10,
	NFS_STATE_CHANGE_WAIT = 11,
	NFS_CLNT_DST_SSC_COPY_STATE = 12,
	NFS_CLNT_SRC_SSC_COPY_STATE = 13,
	NFS_SRV_SSC_COPY_STATE = 14,
};

enum {
	LNK_SYNC_INI = 3120,
	LNK_SYNC_VAL = 3124,
	LNK_SYNC_CTRL = 3128,
	LNK_SYNC_TST = 3129,
	LNK_LED_REG = 3132,
	RX_GMF_EA = 3136,
	RX_GMF_AF_THR = 3140,
	RX_GMF_CTRL_T = 3144,
	RX_GMF_FL_MSK = 3148,
	RX_GMF_FL_THR = 3152,
	RX_GMF_FL_CTRL = 3154,
	RX_GMF_TR_THR = 3156,
	RX_GMF_UP_THR = 3160,
	RX_GMF_LP_THR = 3162,
	RX_GMF_VLAN = 3164,
	RX_GMF_WP = 3168,
	RX_GMF_WLEV = 3176,
	RX_GMF_RP = 3184,
	RX_GMF_RLEV = 3192,
};

enum {
	LOCKD_A_SERVER_GRACETIME = 1,
	LOCKD_A_SERVER_TCP_PORT = 2,
	LOCKD_A_SERVER_UDP_PORT = 3,
	__LOCKD_A_SERVER_MAX = 4,
	LOCKD_A_SERVER_MAX = 3,
};

enum {
	LOCKD_CMD_SERVER_SET = 1,
	LOCKD_CMD_SERVER_GET = 2,
	__LOCKD_CMD_MAX = 3,
	LOCKD_CMD_MAX = 2,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LO_FLAGS_READ_ONLY = 1,
	LO_FLAGS_AUTOCLEAR = 4,
	LO_FLAGS_PARTSCAN = 8,
	LO_FLAGS_DIRECT_IO = 16,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	Lo_unbound = 0,
	Lo_bound = 1,
	Lo_rundown = 2,
	Lo_deleting = 3,
};

enum {
	MAC_TX_CLK_0_MHZ = 2,
	MAC_TX_CLK_2_5_MHZ = 6,
	MAC_TX_CLK_25_MHZ = 7,
};

enum {
	MAGNITUDE_STRONG = 2,
	MAGNITUDE_WEAK = 3,
	MAGNITUDE_NUM = 4,
};

enum {
	MASK_EE_STATUS = 65535,
	MASK_EE_DYNCAP_EVENT = 1,
	MASK_EE_SYSPOOL_EVENT = 2,
	MASK_EE_URGENT_BKOPS = 4,
	MASK_EE_TOO_HIGH_TEMP = 8,
	MASK_EE_TOO_LOW_TEMP = 16,
	MASK_EE_WRITEBOOSTER_EVENT = 32,
	MASK_EE_PERFORMANCE_THROTTLING = 64,
	MASK_EE_DEV_LVL_EXCEPTION = 128,
	MASK_EE_HEALTH_CRITICAL = 512,
};

enum {
	MASK_OCS = 15,
};

enum {
	MASK_TM_SERVICE_RESP = 255,
};

enum {
	MASK_TRANSFER_REQUESTS_SLOTS_SDB = 31,
	MASK_TRANSFER_REQUESTS_SLOTS_MCQ = 255,
	MASK_NUMBER_OUTSTANDING_RTT = 65280,
	MASK_TASK_MANAGEMENT_REQUEST_SLOTS = 458752,
	MASK_EHSLUTRD_SUPPORTED = 4194304,
	MASK_AUTO_HIBERN8_SUPPORT = 8388608,
	MASK_64_ADDRESSING_SUPPORT = 16777216,
	MASK_OUT_OF_ORDER_DATA_DELIVERY_SUPPORT = 33554432,
	MASK_UIC_DME_TEST_MODE_SUPPORT = 67108864,
	MASK_CRYPTO_SUPPORT = 268435456,
	MASK_LSDB_SUPPORT = 536870912,
	MASK_MCQ_SUPPORT = 1073741824,
};

enum {
	MAX7319 = 0,
	MAX7320 = 1,
	MAX7321 = 2,
	MAX7322 = 3,
	MAX7323 = 4,
	MAX7324 = 5,
	MAX7325 = 6,
	MAX7326 = 7,
	MAX7327 = 8,
};

enum {
	MAX77620_GPIO0 = 0,
	MAX77620_GPIO1 = 1,
	MAX77620_GPIO2 = 2,
	MAX77620_GPIO3 = 3,
	MAX77620_GPIO4 = 4,
	MAX77620_GPIO5 = 5,
	MAX77620_GPIO6 = 6,
	MAX77620_GPIO7 = 7,
	MAX77620_GPIO_NR = 8,
};

enum {
	MAX77620_IRQ_TOP_GLBL = 0,
	MAX77620_IRQ_TOP_SD = 1,
	MAX77620_IRQ_TOP_LDO = 2,
	MAX77620_IRQ_TOP_GPIO = 3,
	MAX77620_IRQ_TOP_RTC = 4,
	MAX77620_IRQ_TOP_32K = 5,
	MAX77620_IRQ_TOP_ONOFF = 6,
	MAX77620_IRQ_LBT_MBATLOW = 7,
	MAX77620_IRQ_LBT_TJALRM1 = 8,
	MAX77620_IRQ_LBT_TJALRM2 = 9,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MEGASAS_HBA_OPERATIONAL = 0,
	MEGASAS_ADPRESET_SM_INFAULT = 1,
	MEGASAS_ADPRESET_SM_FW_RESET_SUCCESS = 2,
	MEGASAS_ADPRESET_SM_OPERATIONAL = 3,
	MEGASAS_HW_CRITICAL_ERROR = 4,
	MEGASAS_ADPRESET_SM_POLLING = 5,
	MEGASAS_ADPRESET_INPROG_SIGN = 3735936685,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_SWAPPINESS_MAX = 1,
	MEMORY_RECLAIM_NULL = 2,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MICRON_ON_DIE_UNSUPPORTED = 0,
	MICRON_ON_DIE_SUPPORTED = 1,
	MICRON_ON_DIE_MANDATORY = 2,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLO_PAUSE_NONE = 0,
	MLO_PAUSE_RX = 1,
	MLO_PAUSE_TX = 2,
	MLO_PAUSE_TXRX_MASK = 3,
	MLO_PAUSE_AN = 4,
	MLO_AN_PHY = 0,
	MLO_AN_FIXED = 1,
	MLO_AN_INBAND = 2,
	PHYLINK_PCS_NEG_NONE = 0,
	PHYLINK_PCS_NEG_ENABLED = 16,
	PHYLINK_PCS_NEG_OUTBAND = 32,
	PHYLINK_PCS_NEG_INBAND = 64,
	PHYLINK_PCS_NEG_INBAND_DISABLED = 64,
	PHYLINK_PCS_NEG_INBAND_ENABLED = 80,
	MAC_SYM_PAUSE = 1,
	MAC_ASYM_PAUSE = 2,
	MAC_10HD = 4,
	MAC_10FD = 8,
	MAC_10 = 12,
	MAC_100HD = 16,
	MAC_100FD = 32,
	MAC_100 = 48,
	MAC_1000HD = 64,
	MAC_1000FD = 128,
	MAC_1000 = 192,
	MAC_2500FD = 256,
	MAC_5000FD = 512,
	MAC_10000FD = 1024,
	MAC_20000FD = 2048,
	MAC_25000FD = 4096,
	MAC_40000FD = 8192,
	MAC_50000FD = 16384,
	MAC_56000FD = 32768,
	MAC_100000FD = 65536,
	MAC_200000FD = 131072,
	MAC_400000FD = 262144,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MOUNTPROC3_NULL = 0,
	MOUNTPROC3_MNT = 1,
	MOUNTPROC3_DUMP = 2,
	MOUNTPROC3_UMNT = 3,
	MOUNTPROC3_UMNTALL = 4,
	MOUNTPROC3_EXPORT = 5,
};

enum {
	MOUNTPROC_NULL = 0,
	MOUNTPROC_MNT = 1,
	MOUNTPROC_DUMP = 2,
	MOUNTPROC_UMNT = 3,
	MOUNTPROC_UMNTALL = 4,
	MOUNTPROC_EXPORT = 5,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
	MSI_FLAG_NO_MASK = 4194304,
};

enum {
	MT6357_ID_VCORE = 0,
	MT6357_ID_VMODEM = 1,
	MT6357_ID_VPA = 2,
	MT6357_ID_VPROC = 3,
	MT6357_ID_VS1 = 4,
	MT6357_ID_VAUX18 = 5,
	MT6357_ID_VAUD28 = 6,
	MT6357_ID_VCAMA = 7,
	MT6357_ID_VCAMD = 8,
	MT6357_ID_VCAMIO = 9,
	MT6357_ID_VCN18 = 10,
	MT6357_ID_VCN28 = 11,
	MT6357_ID_VCN33_BT = 12,
	MT6357_ID_VCN33_WIFI = 13,
	MT6357_ID_VDRAM = 14,
	MT6357_ID_VEFUSE = 15,
	MT6357_ID_VEMC = 16,
	MT6357_ID_VFE28 = 17,
	MT6357_ID_VIBR = 18,
	MT6357_ID_VIO18 = 19,
	MT6357_ID_VIO28 = 20,
	MT6357_ID_VLDO28 = 21,
	MT6357_ID_VMC = 22,
	MT6357_ID_VMCH = 23,
	MT6357_ID_VRF12 = 24,
	MT6357_ID_VRF18 = 25,
	MT6357_ID_VSIM1 = 26,
	MT6357_ID_VSIM2 = 27,
	MT6357_ID_VSRAM_OTHERS = 28,
	MT6357_ID_VSRAM_PROC = 29,
	MT6357_ID_VUSB33 = 30,
	MT6357_ID_VXO22 = 31,
	MT6357_ID_RG_MAX = 32,
};

enum {
	MT6358_ID_VDRAM1 = 0,
	MT6358_ID_VCORE = 1,
	MT6358_ID_VPA = 2,
	MT6358_ID_VPROC11 = 3,
	MT6358_ID_VPROC12 = 4,
	MT6358_ID_VGPU = 5,
	MT6358_ID_VS2 = 6,
	MT6358_ID_VMODEM = 7,
	MT6358_ID_VS1 = 8,
	MT6358_ID_VDRAM2 = 9,
	MT6358_ID_VSIM1 = 10,
	MT6358_ID_VIBR = 11,
	MT6358_ID_VRF12 = 12,
	MT6358_ID_VIO18 = 13,
	MT6358_ID_VUSB = 14,
	MT6358_ID_VCAMIO = 15,
	MT6358_ID_VCAMD = 16,
	MT6358_ID_VCN18 = 17,
	MT6358_ID_VFE28 = 18,
	MT6358_ID_VSRAM_PROC11 = 19,
	MT6358_ID_VCN28 = 20,
	MT6358_ID_VSRAM_OTHERS = 21,
	MT6358_ID_VSRAM_GPU = 22,
	MT6358_ID_VXO22 = 23,
	MT6358_ID_VEFUSE = 24,
	MT6358_ID_VAUX18 = 25,
	MT6358_ID_VMCH = 26,
	MT6358_ID_VBIF28 = 27,
	MT6358_ID_VSRAM_PROC12 = 28,
	MT6358_ID_VCAMA1 = 29,
	MT6358_ID_VEMC = 30,
	MT6358_ID_VIO28 = 31,
	MT6358_ID_VA12 = 32,
	MT6358_ID_VRF18 = 33,
	MT6358_ID_VCN33 = 34,
	MT6358_ID_VCAMA2 = 35,
	MT6358_ID_VMC = 36,
	MT6358_ID_VLDO28 = 37,
	MT6358_ID_VAUD28 = 38,
	MT6358_ID_VSIM2 = 39,
	MT6358_ID_RG_MAX = 40,
};

enum {
	MT6359_ID_VS1 = 0,
	MT6359_ID_VGPU11 = 1,
	MT6359_ID_VMODEM = 2,
	MT6359_ID_VPU = 3,
	MT6359_ID_VCORE = 4,
	MT6359_ID_VS2 = 5,
	MT6359_ID_VPA = 6,
	MT6359_ID_VPROC2 = 7,
	MT6359_ID_VPROC1 = 8,
	MT6359_ID_VCORE_SSHUB = 9,
	MT6359_ID_VGPU11_SSHUB = 9,
	MT6359_ID_VAUD18 = 10,
	MT6359_ID_VSIM1 = 11,
	MT6359_ID_VIBR = 12,
	MT6359_ID_VRF12 = 13,
	MT6359_ID_VUSB = 14,
	MT6359_ID_VSRAM_PROC2 = 15,
	MT6359_ID_VIO18 = 16,
	MT6359_ID_VCAMIO = 17,
	MT6359_ID_VCN18 = 18,
	MT6359_ID_VFE28 = 19,
	MT6359_ID_VCN13 = 20,
	MT6359_ID_VCN33_1_BT = 21,
	MT6359_ID_VCN33_1_WIFI = 22,
	MT6359_ID_VAUX18 = 23,
	MT6359_ID_VSRAM_OTHERS = 24,
	MT6359_ID_VEFUSE = 25,
	MT6359_ID_VXO22 = 26,
	MT6359_ID_VRFCK = 27,
	MT6359_ID_VBIF28 = 28,
	MT6359_ID_VIO28 = 29,
	MT6359_ID_VEMC = 30,
	MT6359_ID_VCN33_2_BT = 31,
	MT6359_ID_VCN33_2_WIFI = 32,
	MT6359_ID_VA12 = 33,
	MT6359_ID_VA09 = 34,
	MT6359_ID_VRF18 = 35,
	MT6359_ID_VSRAM_MD = 36,
	MT6359_ID_VUFS = 37,
	MT6359_ID_VM18 = 38,
	MT6359_ID_VBBCK = 39,
	MT6359_ID_VSRAM_PROC1 = 40,
	MT6359_ID_VSIM2 = 41,
	MT6359_ID_VSRAM_OTHERS_SSHUB = 42,
	MT6359_ID_RG_MAX = 43,
};

enum {
	MT6360_REGULATOR_BUCK1 = 0,
	MT6360_REGULATOR_BUCK2 = 1,
	MT6360_REGULATOR_LDO6 = 2,
	MT6360_REGULATOR_LDO7 = 3,
	MT6360_REGULATOR_LDO1 = 4,
	MT6360_REGULATOR_LDO2 = 5,
	MT6360_REGULATOR_LDO3 = 6,
	MT6360_REGULATOR_LDO5 = 7,
	MT6360_REGULATOR_MAX = 8,
};

enum {
	MT6360_SLAVE_TCPC = 0,
	MT6360_SLAVE_PMIC = 1,
	MT6360_SLAVE_LDO = 2,
	MT6360_SLAVE_PMU = 3,
	MT6360_SLAVE_MAX = 4,
};

enum {
	MT6366_ID_VDRAM1 = 0,
	MT6366_ID_VCORE = 1,
	MT6366_ID_VPA = 2,
	MT6366_ID_VPROC11 = 3,
	MT6366_ID_VPROC12 = 4,
	MT6366_ID_VGPU = 5,
	MT6366_ID_VS2 = 6,
	MT6366_ID_VMODEM = 7,
	MT6366_ID_VS1 = 8,
	MT6366_ID_VDRAM2 = 9,
	MT6366_ID_VSIM1 = 10,
	MT6366_ID_VIBR = 11,
	MT6366_ID_VRF12 = 12,
	MT6366_ID_VIO18 = 13,
	MT6366_ID_VUSB = 14,
	MT6366_ID_VCN18 = 15,
	MT6366_ID_VFE28 = 16,
	MT6366_ID_VSRAM_PROC11 = 17,
	MT6366_ID_VCN28 = 18,
	MT6366_ID_VSRAM_OTHERS = 19,
	MT6366_ID_VSRAM_GPU = 20,
	MT6366_ID_VXO22 = 21,
	MT6366_ID_VEFUSE = 22,
	MT6366_ID_VAUX18 = 23,
	MT6366_ID_VMCH = 24,
	MT6366_ID_VBIF28 = 25,
	MT6366_ID_VSRAM_PROC12 = 26,
	MT6366_ID_VEMC = 27,
	MT6366_ID_VIO28 = 28,
	MT6366_ID_VA12 = 29,
	MT6366_ID_VRF18 = 30,
	MT6366_ID_VCN33 = 31,
	MT6366_ID_VMC = 32,
	MT6366_ID_VAUD28 = 33,
	MT6366_ID_VSIM2 = 34,
	MT6366_ID_VM18 = 35,
	MT6366_ID_VMDDR = 36,
	MT6366_ID_VSRAM_CORE = 37,
	MT6366_ID_RG_MAX = 38,
};

enum {
	MT6397_ID_VPCA15 = 0,
	MT6397_ID_VPCA7 = 1,
	MT6397_ID_VSRAMCA15 = 2,
	MT6397_ID_VSRAMCA7 = 3,
	MT6397_ID_VCORE = 4,
	MT6397_ID_VGPU = 5,
	MT6397_ID_VDRM = 6,
	MT6397_ID_VIO18 = 7,
	MT6397_ID_VTCXO = 8,
	MT6397_ID_VA28 = 9,
	MT6397_ID_VCAMA = 10,
	MT6397_ID_VIO28 = 11,
	MT6397_ID_VUSB = 12,
	MT6397_ID_VMC = 13,
	MT6397_ID_VMCH = 14,
	MT6397_ID_VEMC3V3 = 15,
	MT6397_ID_VGP1 = 16,
	MT6397_ID_VGP2 = 17,
	MT6397_ID_VGP3 = 18,
	MT6397_ID_VGP4 = 19,
	MT6397_ID_VGP5 = 20,
	MT6397_ID_VGP6 = 21,
	MT6397_ID_VIBR = 22,
	MT6397_ID_RG_MAX = 23,
};

enum {
	MTD_OPS_PLACE_OOB = 0,
	MTD_OPS_AUTO_OOB = 1,
	MTD_OPS_RAW = 2,
};

enum {
	MUSB_CONTROLLER_MHDRC = 0,
	MUSB_CONTROLLER_HDRC = 1,
};

enum {
	MV_PMA_FW_VER0 = 49169,
	MV_PMA_FW_VER1 = 49170,
	MV_PMA_21X0_PORT_CTRL = 49226,
	MV_PMA_21X0_PORT_CTRL_SWRST = 32768,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_USXGMII = 0,
	MV_PMA_2180_PORT_CTRL_MACTYPE_DXGMII = 1,
	MV_PMA_2180_PORT_CTRL_MACTYPE_QXGMII = 2,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER = 4,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER_NO_SGMII_AN = 5,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_PMA_BOOT = 49232,
	MV_PMA_BOOT_FATAL = 1,
	MV_PCS_BASE_T = 0,
	MV_PCS_BASE_R = 4096,
	MV_PCS_1000BASEX = 8192,
	MV_PCS_CSCR1 = 32768,
	MV_PCS_CSCR1_ED_MASK = 768,
	MV_PCS_CSCR1_ED_OFF = 0,
	MV_PCS_CSCR1_ED_RX = 512,
	MV_PCS_CSCR1_ED_NLP = 768,
	MV_PCS_CSCR1_MDIX_MASK = 96,
	MV_PCS_CSCR1_MDIX_MDI = 0,
	MV_PCS_CSCR1_MDIX_MDIX = 32,
	MV_PCS_CSCR1_MDIX_AUTO = 96,
	MV_PCS_DSC1 = 32771,
	MV_PCS_DSC1_ENABLE = 512,
	MV_PCS_DSC1_10GBT = 448,
	MV_PCS_DSC1_1GBR = 56,
	MV_PCS_DSC1_100BTX = 7,
	MV_PCS_DSC2 = 32772,
	MV_PCS_DSC2_2P5G = 61440,
	MV_PCS_DSC2_5G = 3840,
	MV_PCS_CSSR1 = 32776,
	MV_PCS_CSSR1_SPD1_MASK = 49152,
	MV_PCS_CSSR1_SPD1_SPD2 = 49152,
	MV_PCS_CSSR1_SPD1_1000 = 32768,
	MV_PCS_CSSR1_SPD1_100 = 16384,
	MV_PCS_CSSR1_SPD1_10 = 0,
	MV_PCS_CSSR1_DUPLEX_FULL = 8192,
	MV_PCS_CSSR1_RESOLVED = 2048,
	MV_PCS_CSSR1_MDIX = 64,
	MV_PCS_CSSR1_SPD2_MASK = 12,
	MV_PCS_CSSR1_SPD2_5000 = 8,
	MV_PCS_CSSR1_SPD2_2500 = 4,
	MV_PCS_CSSR1_SPD2_10000 = 0,
	MV_PCS_TEMP = 32834,
	MV_PCS_PORT_INFO = 53261,
	MV_PCS_PORT_INFO_NPORTS_MASK = 896,
	MV_PCS_PORT_INFO_NPORTS_SHIFT = 7,
	MV_AN_21X0_SERDES_CTRL2 = 32783,
	MV_AN_21X0_SERDES_CTRL2_AUTO_INIT_DIS = 8192,
	MV_AN_21X0_SERDES_CTRL2_RUN_INIT = 32768,
	MV_AN_CTRL1000 = 32768,
	MV_AN_STAT1000 = 32769,
	MV_V2_PORT_CTRL = 61441,
	MV_V2_PORT_CTRL_PWRDOWN = 2048,
	MV_V2_33X0_PORT_CTRL_SWRST = 32768,
	MV_V2_33X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI = 0,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI_RATE_MATCH = 1,
	MV_V2_3340_PORT_CTRL_MACTYPE_RXAUI_NO_SGMII_AN = 1,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI_RATE_MATCH = 2,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI = 3,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER = 4,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_NO_SGMII_AN = 5,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_V2_33X0_PORT_CTRL_MACTYPE_USXGMII = 7,
	MV_V2_PORT_INTR_STS = 61504,
	MV_V2_PORT_INTR_MASK = 61507,
	MV_V2_PORT_INTR_STS_WOL_EN = 256,
	MV_V2_MAGIC_PKT_WORD0 = 61547,
	MV_V2_MAGIC_PKT_WORD1 = 61548,
	MV_V2_MAGIC_PKT_WORD2 = 61549,
	MV_V2_WOL_CTRL = 61550,
	MV_V2_WOL_CTRL_CLEAR_STS = 32768,
	MV_V2_WOL_CTRL_MAGIC_PKT_EN = 1,
	MV_V2_TEMP_CTRL = 61578,
	MV_V2_TEMP_CTRL_MASK = 49152,
	MV_V2_TEMP_CTRL_SAMPLE = 0,
	MV_V2_TEMP_CTRL_DISABLE = 49152,
	MV_V2_TEMP = 61580,
	MV_V2_TEMP_UNKNOWN = 38400,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
	NAPIF_STATE_HAS_NOTIFIER = 1024,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
	NAPI_STATE_HAS_NOTIFIER = 10,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	__NETDEV_A_NAPI_MAX = 8,
	NETDEV_A_NAPI_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	NETDEV_A_PAGE_POOL_IO_URING = 8,
	__NETDEV_A_PAGE_POOL_MAX = 9,
	NETDEV_A_PAGE_POOL_MAX = 8,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	NETDEV_A_QUEUE_IO_URING = 6,
	NETDEV_A_QUEUE_XSK = 7,
	__NETDEV_A_QUEUE_MAX = 8,
	NETDEV_A_QUEUE_MAX = 7,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	NETDEV_CMD_BIND_TX = 15,
	__NETDEV_CMD_MAX = 16,
	NETDEV_CMD_MAX = 15,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETDEV_STATS = 0,
	E1000_STATS = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_ACCECN_BIT = 35,
	NETIF_F_GSO_LAST = 35,
	NETIF_F_FCOE_CRC_BIT = 36,
	NETIF_F_SCTP_CRC_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NFSPROC4_CLNT_NULL = 0,
	NFSPROC4_CLNT_READ = 1,
	NFSPROC4_CLNT_WRITE = 2,
	NFSPROC4_CLNT_COMMIT = 3,
	NFSPROC4_CLNT_OPEN = 4,
	NFSPROC4_CLNT_OPEN_CONFIRM = 5,
	NFSPROC4_CLNT_OPEN_NOATTR = 6,
	NFSPROC4_CLNT_OPEN_DOWNGRADE = 7,
	NFSPROC4_CLNT_CLOSE = 8,
	NFSPROC4_CLNT_SETATTR = 9,
	NFSPROC4_CLNT_FSINFO = 10,
	NFSPROC4_CLNT_RENEW = 11,
	NFSPROC4_CLNT_SETCLIENTID = 12,
	NFSPROC4_CLNT_SETCLIENTID_CONFIRM = 13,
	NFSPROC4_CLNT_LOCK = 14,
	NFSPROC4_CLNT_LOCKT = 15,
	NFSPROC4_CLNT_LOCKU = 16,
	NFSPROC4_CLNT_ACCESS = 17,
	NFSPROC4_CLNT_GETATTR = 18,
	NFSPROC4_CLNT_LOOKUP = 19,
	NFSPROC4_CLNT_LOOKUP_ROOT = 20,
	NFSPROC4_CLNT_REMOVE = 21,
	NFSPROC4_CLNT_RENAME = 22,
	NFSPROC4_CLNT_LINK = 23,
	NFSPROC4_CLNT_SYMLINK = 24,
	NFSPROC4_CLNT_CREATE = 25,
	NFSPROC4_CLNT_PATHCONF = 26,
	NFSPROC4_CLNT_STATFS = 27,
	NFSPROC4_CLNT_READLINK = 28,
	NFSPROC4_CLNT_READDIR = 29,
	NFSPROC4_CLNT_SERVER_CAPS = 30,
	NFSPROC4_CLNT_DELEGRETURN = 31,
	NFSPROC4_CLNT_GETACL = 32,
	NFSPROC4_CLNT_SETACL = 33,
	NFSPROC4_CLNT_FS_LOCATIONS = 34,
	NFSPROC4_CLNT_RELEASE_LOCKOWNER = 35,
	NFSPROC4_CLNT_SECINFO = 36,
	NFSPROC4_CLNT_FSID_PRESENT = 37,
	NFSPROC4_CLNT_EXCHANGE_ID = 38,
	NFSPROC4_CLNT_CREATE_SESSION = 39,
	NFSPROC4_CLNT_DESTROY_SESSION = 40,
	NFSPROC4_CLNT_SEQUENCE = 41,
	NFSPROC4_CLNT_GET_LEASE_TIME = 42,
	NFSPROC4_CLNT_RECLAIM_COMPLETE = 43,
	NFSPROC4_CLNT_LAYOUTGET = 44,
	NFSPROC4_CLNT_GETDEVICEINFO = 45,
	NFSPROC4_CLNT_LAYOUTCOMMIT = 46,
	NFSPROC4_CLNT_LAYOUTRETURN = 47,
	NFSPROC4_CLNT_SECINFO_NO_NAME = 48,
	NFSPROC4_CLNT_TEST_STATEID = 49,
	NFSPROC4_CLNT_FREE_STATEID = 50,
	NFSPROC4_CLNT_GETDEVICELIST = 51,
	NFSPROC4_CLNT_BIND_CONN_TO_SESSION = 52,
	NFSPROC4_CLNT_DESTROY_CLIENTID = 53,
	NFSPROC4_CLNT_SEEK = 54,
	NFSPROC4_CLNT_ALLOCATE = 55,
	NFSPROC4_CLNT_DEALLOCATE = 56,
	NFSPROC4_CLNT_ZERO_RANGE = 57,
	NFSPROC4_CLNT_LAYOUTSTATS = 58,
	NFSPROC4_CLNT_CLONE = 59,
	NFSPROC4_CLNT_COPY = 60,
	NFSPROC4_CLNT_OFFLOAD_CANCEL = 61,
	NFSPROC4_CLNT_LOOKUPP = 62,
	NFSPROC4_CLNT_LAYOUTERROR = 63,
	NFSPROC4_CLNT_COPY_NOTIFY = 64,
	NFSPROC4_CLNT_GETXATTR = 65,
	NFSPROC4_CLNT_SETXATTR = 66,
	NFSPROC4_CLNT_LISTXATTRS = 67,
	NFSPROC4_CLNT_REMOVEXATTR = 68,
	NFSPROC4_CLNT_READ_PLUS = 69,
	NFSPROC4_CLNT_OFFLOAD_STATUS = 70,
};

enum {
	NFS_DELEGATION_NEED_RECLAIM = 0,
	NFS_DELEGATION_RETURN = 1,
	NFS_DELEGATION_RETURN_IF_CLOSED = 2,
	NFS_DELEGATION_REFERENCED = 3,
	NFS_DELEGATION_RETURNING = 4,
	NFS_DELEGATION_REVOKED = 5,
	NFS_DELEGATION_TEST_EXPIRED = 6,
	NFS_DELEGATION_INODE_FREEING = 7,
	NFS_DELEGATION_RETURN_DELAYED = 8,
	NFS_DELEGATION_DELEGTIME = 9,
};

enum {
	NFS_DEVICEID_INVALID = 0,
	NFS_DEVICEID_UNAVAILABLE = 1,
	NFS_DEVICEID_NOCACHE = 2,
};

enum {
	NFS_IOHDR_ERROR = 0,
	NFS_IOHDR_EOF = 1,
	NFS_IOHDR_REDO = 2,
	NFS_IOHDR_STAT = 3,
	NFS_IOHDR_RESEND_PNFS = 4,
	NFS_IOHDR_RESEND_MDS = 5,
	NFS_IOHDR_UNSTABLE_WRITES = 6,
	NFS_IOHDR_ODIRECT = 7,
};

enum {
	NFS_LAYOUT_RO_FAILED = 0,
	NFS_LAYOUT_RW_FAILED = 1,
	NFS_LAYOUT_BULK_RECALL = 2,
	NFS_LAYOUT_RETURN = 3,
	NFS_LAYOUT_RETURN_LOCK = 4,
	NFS_LAYOUT_RETURN_REQUESTED = 5,
	NFS_LAYOUT_INVALID_STID = 6,
	NFS_LAYOUT_FIRST_LAYOUTGET = 7,
	NFS_LAYOUT_INODE_FREEING = 8,
	NFS_LAYOUT_HASHED = 9,
	NFS_LAYOUT_DRAIN = 10,
};

enum {
	NFS_LSEG_VALID = 0,
	NFS_LSEG_ROC = 1,
	NFS_LSEG_LAYOUTCOMMIT = 2,
	NFS_LSEG_LAYOUTRETURN = 3,
	NFS_LSEG_UNAVAILABLE = 4,
};

enum {
	NFS_OWNER_RECLAIM_REBOOT = 0,
	NFS_OWNER_RECLAIM_NOGRACE = 1,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLM_LCK_GRANTED = 0,
	NLM_LCK_DENIED = 1,
	NLM_LCK_DENIED_NOLOCKS = 2,
	NLM_LCK_BLOCKED = 3,
	NLM_LCK_DENIED_GRACE_PERIOD = 4,
	NLM_DEADLCK = 5,
	NLM_ROFS = 6,
	NLM_STALE_FH = 7,
	NLM_FBIG = 8,
	NLM_FAILED = 9,
};

enum {
	NSMPROC_NULL = 0,
	NSMPROC_STAT = 1,
	NSMPROC_MON = 2,
	NSMPROC_UNMON = 3,
	NSMPROC_UNMON_ALL = 4,
	NSMPROC_SIMU_CRASH = 5,
	NSMPROC_NOTIFY = 6,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 16,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_BIT_NS_ATTR = 8,
	NVME_AEN_BIT_FW_ACT = 9,
	NVME_AEN_BIT_ANA_CHANGE = 11,
	NVME_AEN_BIT_DISC_CHANGE = 31,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_MPS_MASK = 1920,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_AMS_MASK = 14336,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOSQES_MASK = 983040,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_IOCQES_MASK = 15728640,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier = 34,
	Opt_nobarrier = 35,
	Opt_err = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_check = 0,
	Opt_uid = 1,
	Opt_gid = 2,
	Opt_umask = 3,
	Opt_dmask = 4,
	Opt_fmask = 5,
	Opt_allow_utime = 6,
	Opt_codepage = 7,
	Opt_usefree = 8,
	Opt_nocase = 9,
	Opt_quiet = 10,
	Opt_showexec = 11,
	Opt_debug___2 = 12,
	Opt_immutable = 13,
	Opt_dots = 14,
	Opt_dotsOK = 15,
	Opt_charset = 16,
	Opt_shortname = 17,
	Opt_utf8 = 18,
	Opt_utf8_bool = 19,
	Opt_uni_xl = 20,
	Opt_uni_xl_bool = 21,
	Opt_nonumtail = 22,
	Opt_nonumtail_bool = 23,
	Opt_obsolete = 24,
	Opt_flush = 25,
	Opt_tz = 26,
	Opt_rodir = 27,
	Opt_errors___2 = 28,
	Opt_discard___2 = 29,
	Opt_nfs = 30,
	Opt_nfs_enum = 31,
	Opt_time_offset = 32,
	Opt_dos1xfloppy = 33,
};

enum {
	Opt_debug___3 = 0,
	Opt_dfltuid = 1,
	Opt_dfltgid = 2,
	Opt_afid = 3,
	Opt_uname = 4,
	Opt_remotename = 5,
	Opt_cache = 6,
	Opt_cachetag = 7,
	Opt_nodevmap = 8,
	Opt_noxattr = 9,
	Opt_directio = 10,
	Opt_ignoreqv = 11,
	Opt_access = 12,
	Opt_posixacl = 13,
	Opt_locktimeout = 14,
	Opt_err___2 = 15,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid___2 = 2,
	Opt_ignore = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid___2 = 10,
};

enum {
	Opt_err___3 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_fatal_neterrors_default = 0,
	Opt_fatal_neterrors_enetunreach = 1,
	Opt_fatal_neterrors_none = 2,
};

enum {
	Opt_find_uid = 0,
	Opt_find_gid = 1,
	Opt_find_user = 2,
	Opt_find_group = 3,
	Opt_find_err = 4,
};

enum {
	Opt_kmsg_bytes = 0,
};

enum {
	Opt_local_lock_all = 0,
	Opt_local_lock_flock = 1,
	Opt_local_lock_none = 2,
	Opt_local_lock_posix = 3,
};

enum {
	Opt_lookupcache_all = 0,
	Opt_lookupcache_none = 1,
	Opt_lookupcache_positive = 2,
};

enum {
	Opt_msize = 0,
	Opt_trans = 1,
	Opt_legacy = 2,
	Opt_version = 3,
	Opt_err___4 = 4,
};

enum {
	Opt_port = 0,
	Opt_rfdno = 1,
	Opt_wfdno = 2,
	Opt_err___5 = 3,
	Opt_privport = 4,
};

enum {
	Opt_sec_krb5 = 0,
	Opt_sec_krb5i = 1,
	Opt_sec_krb5p = 2,
	Opt_sec_lkey = 3,
	Opt_sec_lkeyi = 4,
	Opt_sec_lkeyp = 5,
	Opt_sec_none = 6,
	Opt_sec_spkm = 7,
	Opt_sec_spkmi = 8,
	Opt_sec_spkmp = 9,
	Opt_sec_sys = 10,
	nr__Opt_sec = 11,
};

enum {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
	Opt_mode = 2,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode___2 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___3 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___6 = 6,
};

enum {
	Opt_vers_2 = 0,
	Opt_vers_3 = 1,
	Opt_vers_4 = 2,
	Opt_vers_4_0 = 3,
	Opt_vers_4_1 = 4,
	Opt_vers_4_2 = 5,
};

enum {
	Opt_write_lazy = 0,
	Opt_write_eager = 1,
	Opt_write_wait = 2,
};

enum {
	Opt_xprt_rdma = 0,
	Opt_xprt_rdma6 = 1,
	Opt_xprt_tcp = 2,
	Opt_xprt_tcp6 = 3,
	Opt_xprt_udp = 4,
	Opt_xprt_udp6 = 5,
	nr__Opt_xprt = 6,
};

enum {
	Opt_xprtsec_none = 0,
	Opt_xprtsec_tls = 1,
	Opt_xprtsec_mtls = 2,
	nr__Opt_xprtsec = 3,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PARSE_INVALID = 1,
	PARSE_NOT_LONGNAME = 2,
	PARSE_EOF = 3,
};

enum {
	PCA9450_BUCK1 = 0,
	PCA9450_BUCK2 = 1,
	PCA9450_BUCK3 = 2,
	PCA9450_BUCK4 = 3,
	PCA9450_BUCK5 = 4,
	PCA9450_BUCK6 = 5,
	PCA9450_LDO1 = 6,
	PCA9450_LDO2 = 7,
	PCA9450_LDO3 = 8,
	PCA9450_LDO4 = 9,
	PCA9450_LDO5 = 10,
	PCA9450_REGULATOR_CNT = 11,
};

enum {
	PCA9450_DVS_LEVEL_RUN = 0,
	PCA9450_DVS_LEVEL_STANDBY = 1,
	PCA9450_DVS_LEVEL_MAX = 2,
};

enum {
	PCA9450_REG_DEV_ID = 0,
	PCA9450_REG_INT1 = 1,
	PCA9450_REG_INT1_MSK = 2,
	PCA9450_REG_STATUS1 = 3,
	PCA9450_REG_STATUS2 = 4,
	PCA9450_REG_PWRON_STAT = 5,
	PCA9450_REG_SWRST = 6,
	PCA9450_REG_PWRCTRL = 7,
	PCA9450_REG_RESET_CTRL = 8,
	PCA9450_REG_CONFIG1 = 9,
	PCA9450_REG_CONFIG2 = 10,
	PCA9450_REG_BUCK123_DVS = 12,
	PCA9450_REG_BUCK1OUT_LIMIT = 13,
	PCA9450_REG_BUCK2OUT_LIMIT = 14,
	PCA9450_REG_BUCK3OUT_LIMIT = 15,
	PCA9450_REG_BUCK1CTRL = 16,
	PCA9450_REG_BUCK1OUT_DVS0 = 17,
	PCA9450_REG_BUCK1OUT_DVS1 = 18,
	PCA9450_REG_BUCK2CTRL = 19,
	PCA9450_REG_BUCK2OUT_DVS0 = 20,
	PCA9450_REG_BUCK2OUT_DVS1 = 21,
	PCA9450_REG_BUCK3CTRL = 22,
	PCA9450_REG_BUCK3OUT_DVS0 = 23,
	PCA9450_REG_BUCK3OUT_DVS1 = 24,
	PCA9450_REG_BUCK4CTRL = 25,
	PCA9450_REG_BUCK4OUT = 26,
	PCA9450_REG_BUCK5CTRL = 27,
	PCA9450_REG_BUCK5OUT = 28,
	PCA9450_REG_BUCK6CTRL = 29,
	PCA9450_REG_BUCK6OUT = 30,
	PCA9450_REG_LDO_AD_CTRL = 32,
	PCA9450_REG_LDO1CTRL = 33,
	PCA9450_REG_LDO2CTRL = 34,
	PCA9450_REG_LDO3CTRL = 35,
	PCA9450_REG_LDO4CTRL = 36,
	PCA9450_REG_LDO5CTRL_L = 37,
	PCA9450_REG_LDO5CTRL_H = 38,
	PCA9450_REG_LOADSW_CTRL = 42,
	PCA9450_REG_VRFLT1_STS = 43,
	PCA9450_REG_VRFLT2_STS = 44,
	PCA9450_REG_VRFLT1_MASK = 45,
	PCA9450_REG_VRFLT2_MASK = 46,
	PCA9450_MAX_REGISTER = 47,
};

enum {
	PCI_DEV_REG1 = 64,
	PCI_DEV_REG2 = 68,
	PCI_DEV_STATUS = 124,
	PCI_DEV_REG3 = 128,
	PCI_DEV_REG4 = 132,
	PCI_DEV_REG5 = 136,
	PCI_CFG_REG_0 = 144,
	PCI_CFG_REG_1 = 148,
	PSM_CONFIG_REG0 = 152,
	PSM_CONFIG_REG1 = 156,
	PSM_CONFIG_REG2 = 352,
	PSM_CONFIG_REG3 = 356,
	PSM_CONFIG_REG4 = 360,
	PCI_LDO_CTRL = 188,
};

enum {
	PCI_ID_F_VFIO_DRIVER_OVERRIDE = 1,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PC_VAUX_ENA = 128,
	PC_VAUX_DIS = 64,
	PC_VCC_ENA = 32,
	PC_VCC_DIS = 16,
	PC_VAUX_ON = 8,
	PC_VAUX_OFF = 4,
	PC_VCC_ON = 2,
	PC_VCC_OFF = 1,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PEX_RD_ACCESS = -2147483648,
	PEX_DB_ACCESS = 1073741824,
};

enum {
	PG_BUSY = 0,
	PG_MAPPED = 1,
	PG_FOLIO = 2,
	PG_CLEAN = 3,
	PG_COMMIT_TO_DS = 4,
	PG_INODE_REF = 5,
	PG_HEADLOCK = 6,
	PG_TEARDOWN = 7,
	PG_UNLOCKPAGE = 8,
	PG_UPTODATE = 9,
	PG_WB_END = 10,
	PG_REMOVE = 11,
	PG_CONTENDED1 = 12,
	PG_CONTENDED2 = 13,
};

enum {
	PHYLINK_DISABLE_STOPPED = 0,
	PHYLINK_DISABLE_LINK = 1,
	PHYLINK_DISABLE_MAC_WOL = 2,
	PCS_STATE_DOWN = 0,
	PCS_STATE_STARTING = 1,
	PCS_STATE_STARTED = 2,
};

enum {
	PHY_ADDR_MARV = 0,
};

enum {
	PHY_AN_NXT_PG = 32768,
	PHY_AN_ACK = 16384,
	PHY_AN_RF = 8192,
	PHY_AN_PAUSE_ASYM = 2048,
	PHY_AN_PAUSE_CAP = 1024,
	PHY_AN_100BASE4 = 512,
	PHY_AN_100FULL = 256,
	PHY_AN_100HALF = 128,
	PHY_AN_10FULL = 64,
	PHY_AN_10HALF = 32,
	PHY_AN_CSMA = 1,
	PHY_AN_SEL = 31,
	PHY_AN_FULL = 321,
	PHY_AN_ALL = 480,
};

enum {
	PHY_CT_RESET = 32768,
	PHY_CT_LOOP = 16384,
	PHY_CT_SPS_LSB = 8192,
	PHY_CT_ANE = 4096,
	PHY_CT_PDOWN = 2048,
	PHY_CT_ISOL = 1024,
	PHY_CT_RE_CFG = 512,
	PHY_CT_DUP_MD = 256,
	PHY_CT_COL_TST = 128,
	PHY_CT_SPS_MSB = 64,
};

enum {
	PHY_CT_SP1000 = 64,
	PHY_CT_SP100 = 8192,
	PHY_CT_SP10 = 0,
};

enum {
	PHY_MARV_CTRL = 0,
	PHY_MARV_STAT = 1,
	PHY_MARV_ID0 = 2,
	PHY_MARV_ID1 = 3,
	PHY_MARV_AUNE_ADV = 4,
	PHY_MARV_AUNE_LP = 5,
	PHY_MARV_AUNE_EXP = 6,
	PHY_MARV_NEPG = 7,
	PHY_MARV_NEPG_LP = 8,
	PHY_MARV_1000T_CTRL = 9,
	PHY_MARV_1000T_STAT = 10,
	PHY_MARV_EXT_STAT = 15,
	PHY_MARV_PHY_CTRL = 16,
	PHY_MARV_PHY_STAT = 17,
	PHY_MARV_INT_MASK = 18,
	PHY_MARV_INT_STAT = 19,
	PHY_MARV_EXT_CTRL = 20,
	PHY_MARV_RXE_CNT = 21,
	PHY_MARV_EXT_ADR = 22,
	PHY_MARV_PORT_IRQ = 23,
	PHY_MARV_LED_CTRL = 24,
	PHY_MARV_LED_OVER = 25,
	PHY_MARV_EXT_CTRL_2 = 26,
	PHY_MARV_EXT_P_STAT = 27,
	PHY_MARV_CABLE_DIAG = 28,
	PHY_MARV_PAGE_ADDR = 29,
	PHY_MARV_PAGE_DATA = 30,
	PHY_MARV_FE_LED_PAR = 22,
	PHY_MARV_FE_LED_SER = 23,
	PHY_MARV_FE_VCT_TX = 26,
	PHY_MARV_FE_VCT_RX = 27,
	PHY_MARV_FE_SPEC_2 = 28,
};

enum {
	PHY_MARV_ID0_VAL = 321,
	PHY_BCOM_ID1_A1 = 24641,
	PHY_BCOM_ID1_B2 = 24643,
	PHY_BCOM_ID1_C0 = 24644,
	PHY_BCOM_ID1_C5 = 24647,
	PHY_MARV_ID1_B0 = 3107,
	PHY_MARV_ID1_B2 = 3109,
	PHY_MARV_ID1_C2 = 3266,
	PHY_MARV_ID1_Y2 = 3217,
	PHY_MARV_ID1_FE = 3203,
	PHY_MARV_ID1_ECU = 3248,
};

enum {
	PHY_M_1000C_TEST = 57344,
	PHY_M_1000C_MSE = 4096,
	PHY_M_1000C_MSC = 2048,
	PHY_M_1000C_MPD = 1024,
	PHY_M_1000C_AFD = 512,
	PHY_M_1000C_AHD = 256,
};

enum {
	PHY_M_AN_ASP_X = 256,
	PHY_M_AN_PC_X = 128,
	PHY_M_AN_1000X_AHD = 64,
	PHY_M_AN_1000X_AFD = 32,
};

enum {
	PHY_M_AN_NXT_PG = 32768,
	PHY_M_AN_ACK = 16384,
	PHY_M_AN_RF = 8192,
	PHY_M_AN_ASP = 2048,
	PHY_M_AN_PC = 1024,
	PHY_M_AN_100_T4 = 512,
	PHY_M_AN_100_FD = 256,
	PHY_M_AN_100_HD = 128,
	PHY_M_AN_10_FD = 64,
	PHY_M_AN_10_HD = 32,
	PHY_M_AN_SEL_MSK = 496,
};

enum {
	PHY_M_EC_ENA_BC_EXT = 32768,
	PHY_M_EC_ENA_LIN_LB = 16384,
	PHY_M_EC_DIS_LINK_P = 4096,
	PHY_M_EC_M_DSC_MSK = 3072,
	PHY_M_EC_S_DSC_MSK = 768,
	PHY_M_EC_M_DSC_MSK2 = 3584,
	PHY_M_EC_DOWN_S_ENA = 256,
	PHY_M_EC_RX_TIM_CT = 128,
	PHY_M_EC_MAC_S_MSK = 112,
	PHY_M_EC_FIB_AN_ENA = 8,
	PHY_M_EC_DTE_D_ENA = 4,
	PHY_M_EC_TX_TIM_CT = 2,
	PHY_M_EC_TRANS_DIS = 1,
	PHY_M_10B_TE_ENABLE = 128,
};

enum {
	PHY_M_FC_AUTO_SEL = 32768,
	PHY_M_FC_AN_REG_ACC = 16384,
	PHY_M_FC_RESOLUTION = 8192,
	PHY_M_SER_IF_AN_BP = 4096,
	PHY_M_SER_IF_BP_ST = 2048,
	PHY_M_IRQ_POLARITY = 1024,
	PHY_M_DIS_AUT_MED = 512,
	PHY_M_UNDOC1 = 128,
	PHY_M_DTE_POW_STAT = 16,
	PHY_M_MODE_MASK = 15,
};

enum {
	PHY_M_FELP_LED2_MSK = 3840,
	PHY_M_FELP_LED1_MSK = 240,
	PHY_M_FELP_LED0_MSK = 15,
};

enum {
	PHY_M_FESC_DIS_WAIT = 4,
	PHY_M_FESC_ENA_MCLK = 2,
	PHY_M_FESC_SEL_CL_A = 1,
};

enum {
	PHY_M_FIB_FORCE_LNK = 1024,
	PHY_M_FIB_SIGD_POL = 512,
	PHY_M_FIB_TX_DIS = 8,
};

enum {
	PHY_M_IS_AN_ERROR = 32768,
	PHY_M_IS_LSP_CHANGE = 16384,
	PHY_M_IS_DUP_CHANGE = 8192,
	PHY_M_IS_AN_PR = 4096,
	PHY_M_IS_AN_COMPL = 2048,
	PHY_M_IS_LST_CHANGE = 1024,
	PHY_M_IS_SYMB_ERROR = 512,
	PHY_M_IS_FALSE_CARR = 256,
	PHY_M_IS_FIFO_ERROR = 128,
	PHY_M_IS_MDI_CHANGE = 64,
	PHY_M_IS_DOWNSH_DET = 32,
	PHY_M_IS_END_CHANGE = 16,
	PHY_M_IS_DTE_CHANGE = 4,
	PHY_M_IS_POL_CHANGE = 2,
	PHY_M_IS_JABBER = 1,
	PHY_M_DEF_MSK = 25600,
	PHY_M_AN_MSK = 34816,
};

enum {
	PHY_M_LEDC_DIS_LED = 32768,
	PHY_M_LEDC_PULS_MSK = 28672,
	PHY_M_LEDC_F_INT = 2048,
	PHY_M_LEDC_BL_R_MSK = 1792,
	PHY_M_LEDC_DP_C_LSB = 128,
	PHY_M_LEDC_TX_C_LSB = 64,
	PHY_M_LEDC_LK_C_MSK = 56,
};

enum {
	PHY_M_LEDC_LINK_MSK = 24,
	PHY_M_LEDC_DP_CTRL = 4,
	PHY_M_LEDC_DP_C_MSB = 4,
	PHY_M_LEDC_RX_CTRL = 2,
	PHY_M_LEDC_TX_CTRL = 1,
	PHY_M_LEDC_TX_C_MSB = 1,
};

enum {
	PHY_M_LEDC_LOS_MSK = 61440,
	PHY_M_LEDC_INIT_MSK = 3840,
	PHY_M_LEDC_STA1_MSK = 240,
	PHY_M_LEDC_STA0_MSK = 15,
};

enum {
	PHY_M_MAC_MD_MSK = 896,
	PHY_M_MAC_GMIF_PUP = 8,
	PHY_M_MAC_MD_AUTO = 3,
	PHY_M_MAC_MD_COPPER = 5,
	PHY_M_MAC_MD_1000BX = 7,
};

enum {
	PHY_M_PC_COP_TX_DIS = 8,
	PHY_M_PC_POW_D_ENA = 4,
};

enum {
	PHY_M_PC_DIS_LINK_Pa = 32768,
	PHY_M_PC_DSC_MSK = 28672,
	PHY_M_PC_DOWN_S_ENA = 2048,
};

enum {
	PHY_M_PC_ENA_DTE_DT = 32768,
	PHY_M_PC_ENA_ENE_DT = 16384,
	PHY_M_PC_DIS_NLP_CK = 8192,
	PHY_M_PC_ENA_LIP_NP = 4096,
	PHY_M_PC_DIS_NLP_GN = 2048,
	PHY_M_PC_DIS_SCRAMB = 512,
	PHY_M_PC_DIS_FEFI = 256,
	PHY_M_PC_SH_TP_SEL = 64,
	PHY_M_PC_RX_FD_MSK = 12,
};

enum {
	PHY_M_PC_MAN_MDI = 0,
	PHY_M_PC_MAN_MDIX = 1,
	PHY_M_PC_ENA_AUTO = 3,
};

enum {
	PHY_M_PC_TX_FFD_MSK = 49152,
	PHY_M_PC_RX_FFD_MSK = 12288,
	PHY_M_PC_ASS_CRS_TX = 2048,
	PHY_M_PC_FL_GOOD = 1024,
	PHY_M_PC_EN_DET_MSK = 768,
	PHY_M_PC_ENA_EXT_D = 128,
	PHY_M_PC_MDIX_MSK = 96,
	PHY_M_PC_DIS_125CLK = 16,
	PHY_M_PC_MAC_POW_UP = 8,
	PHY_M_PC_SQE_T_ENA = 4,
	PHY_M_PC_POL_R_DIS = 2,
	PHY_M_PC_DIS_JABBER = 1,
};

enum {
	PHY_M_POLC_LS1M_MSK = 61440,
	PHY_M_POLC_IS0M_MSK = 3840,
	PHY_M_POLC_LOS_MSK = 192,
	PHY_M_POLC_INIT_MSK = 48,
	PHY_M_POLC_STA1_MSK = 12,
	PHY_M_POLC_STA0_MSK = 3,
};

enum {
	PHY_M_PS_SPEED_MSK = 49152,
	PHY_M_PS_SPEED_1000 = 32768,
	PHY_M_PS_SPEED_100 = 16384,
	PHY_M_PS_SPEED_10 = 0,
	PHY_M_PS_FULL_DUP = 8192,
	PHY_M_PS_PAGE_REC = 4096,
	PHY_M_PS_SPDUP_RES = 2048,
	PHY_M_PS_LINK_UP = 1024,
	PHY_M_PS_CABLE_MSK = 896,
	PHY_M_PS_MDI_X_STAT = 64,
	PHY_M_PS_DOWNS_STAT = 32,
	PHY_M_PS_ENDET_STAT = 16,
	PHY_M_PS_TX_P_EN = 8,
	PHY_M_PS_RX_P_EN = 4,
	PHY_M_PS_POL_REV = 2,
	PHY_M_PS_JABBER = 1,
};

enum {
	PHY_M_P_NO_PAUSE_X = 0,
	PHY_M_P_SYM_MD_X = 128,
	PHY_M_P_ASYM_MD_X = 256,
	PHY_M_P_BOTH_MD_X = 384,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNDERVOLTAGE = 5,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 6,
	POWER_SUPPLY_HEALTH_COLD = 7,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 9,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 10,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 11,
	POWER_SUPPLY_HEALTH_WARM = 12,
	POWER_SUPPLY_HEALTH_COOL = 13,
	POWER_SUPPLY_HEALTH_HOT = 14,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 15,
	POWER_SUPPLY_HEALTH_BLOWN_FUSE = 16,
	POWER_SUPPLY_HEALTH_CELL_IMBALANCE = 17,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREF_UNIT_OP_ON = 8,
	PREF_UNIT_OP_OFF = 4,
	PREF_UNIT_RST_CLR = 2,
	PREF_UNIT_RST_SET = 1,
};

enum {
	PROCESS_SPIN_LOCK = 1,
	PROCESS_RES_LOCK = 2,
	PROCESS_LOCK_IRQ = 4,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
	PROC_ENTRY_proc_read_iter = 2,
	PROC_ENTRY_proc_compat_ioctl = 4,
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

enum {
	PSM_CONFIG_REG4_TIMER_PHY_LINK_DETECT_MSK = 240,
	PSM_CONFIG_REG4_TIMER_PHY_LINK_DETECT_BASE = 4,
	PSM_CONFIG_REG4_DEBUG_TIMER = 2,
	PSM_CONFIG_REG4_RST_PHY_LINK_DETECT = 1,
};

enum {
	PULS_NO_STR = 0,
	PULS_21MS = 1,
	PULS_42MS = 2,
	PULS_84MS = 3,
	PULS_170MS = 4,
	PULS_340MS = 5,
	PULS_670MS = 6,
	PULS_1300MS = 7,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	PWR_OK = 0,
	PWR_LOCAL = 1,
	PWR_REMOTE = 2,
	PWR_BUSY = 3,
	PWR_ERROR_CAP = 4,
	PWR_FATAL_ERROR = 5,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QUERY_REQ_TIMEOUT_MIN = 1,
	QUERY_REQ_TIMEOUT_DEFAULT = 1500,
	QUERY_REQ_TIMEOUT_MAX = 30000,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_DISABLE_WBT_DEF = 13,
	QUEUE_FLAG_NO_ELV_SWITCH = 14,
	QUEUE_FLAG_MAX = 15,
};

enum {
	Q_R1 = 0,
	Q_R2 = 128,
	Q_XS1 = 512,
	Q_XA1 = 640,
	Q_XS2 = 768,
	Q_XA2 = 896,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_ENA_STFWD = 32,
	RB_DIS_STFWD = 16,
	RB_ENA_OP_MD = 8,
	RB_DIS_OP_MD = 4,
	RB_RST_CLR = 2,
	RB_RST_SET = 1,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	RB_START = 0,
	RB_END = 4,
	RB_WP = 8,
	RB_RP = 12,
	RB_RX_UTPP = 16,
	RB_RX_LTPP = 20,
	RB_RX_UTHP = 24,
	RB_RX_LTHP = 28,
	RB_PC = 32,
	RB_LEV = 36,
	RB_CTRL = 40,
	RB_TST1 = 41,
	RB_TST2 = 42,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_CONTROLLER_CAPABILITIES = 0,
	REG_MCQCAP = 4,
	REG_UFS_VERSION = 8,
	REG_EXT_CONTROLLER_CAPABILITIES = 12,
	REG_CONTROLLER_PID = 16,
	REG_CONTROLLER_MID = 20,
	REG_AUTO_HIBERNATE_IDLE_TIMER = 24,
	REG_INTERRUPT_STATUS = 32,
	REG_INTERRUPT_ENABLE = 36,
	REG_CONTROLLER_STATUS = 48,
	REG_CONTROLLER_ENABLE = 52,
	REG_UIC_ERROR_CODE_PHY_ADAPTER_LAYER = 56,
	REG_UIC_ERROR_CODE_DATA_LINK_LAYER = 60,
	REG_UIC_ERROR_CODE_NETWORK_LAYER = 64,
	REG_UIC_ERROR_CODE_TRANSPORT_LAYER = 68,
	REG_UIC_ERROR_CODE_DME = 72,
	REG_UTP_TRANSFER_REQ_INT_AGG_CONTROL = 76,
	REG_UTP_TRANSFER_REQ_LIST_BASE_L = 80,
	REG_UTP_TRANSFER_REQ_LIST_BASE_H = 84,
	REG_UTP_TRANSFER_REQ_DOOR_BELL = 88,
	REG_UTP_TRANSFER_REQ_LIST_CLEAR = 92,
	REG_UTP_TRANSFER_REQ_LIST_RUN_STOP = 96,
	REG_UTP_TASK_REQ_LIST_BASE_L = 112,
	REG_UTP_TASK_REQ_LIST_BASE_H = 116,
	REG_UTP_TASK_REQ_DOOR_BELL = 120,
	REG_UTP_TASK_REQ_LIST_CLEAR = 124,
	REG_UTP_TASK_REQ_LIST_RUN_STOP = 128,
	REG_UIC_COMMAND = 144,
	REG_UIC_COMMAND_ARG_1 = 148,
	REG_UIC_COMMAND_ARG_2 = 152,
	REG_UIC_COMMAND_ARG_3 = 156,
	UFSHCI_REG_SPACE_SIZE = 160,
	REG_UFS_CCAP = 256,
	REG_UFS_CRYPTOCAP = 260,
	REG_UFS_MEM_CFG = 768,
	REG_UFS_MCQ_CFG = 896,
	REG_UFS_ESILBA = 900,
	REG_UFS_ESIUBA = 904,
	UFSHCI_CRYPTO_REG_SPACE_SIZE = 1024,
};

enum {
	REG_CON_MOD_TX = 0,
	REG_CON_MOD_REGISTER_TX = 1,
	REG_CON_MOD_RX = 2,
	REG_CON_MOD_REGISTER_RX = 3,
};

enum {
	REG_CQHP = 0,
	REG_CQTP = 4,
};

enum {
	REG_CQIS = 0,
	REG_CQIE = 4,
};

enum {
	REG_SQATTR = 0,
	REG_SQLBA = 4,
	REG_SQUBA = 8,
	REG_SQDAO = 12,
	REG_SQISAO = 16,
	REG_CQATTR = 32,
	REG_CQLBA = 36,
	REG_CQUBA = 40,
	REG_CQDAO = 44,
	REG_CQISAO = 48,
};

enum {
	REG_SQHP = 0,
	REG_SQTP = 4,
	REG_SQRTC = 8,
	REG_SQCTI = 12,
	REG_SQRTS = 16,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 1250,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 536870912ULL,
	REQ_F_ISREG = 1073741824ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_MULTISHOT = 67108864ULL,
	REQ_F_APOLL_MULTISHOT = 134217728ULL,
	REQ_F_CLEAR_POLLIN = 268435456ULL,
	REQ_F_POLL_NO_LAZY = 2147483648ULL,
	REQ_F_CAN_POLL = 4294967296ULL,
	REQ_F_BL_EMPTY = 8589934592ULL,
	REQ_F_BL_NO_RECYCLE = 17179869184ULL,
	REQ_F_BUFFERS_COMMIT = 34359738368ULL,
	REQ_F_BUF_NODE = 68719476736ULL,
	REQ_F_HAS_METADATA = 137438953472ULL,
	REQ_F_IMPORT_BUFFER = 274877906944ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_MULTISHOT_BIT = 26,
	REQ_F_APOLL_MULTISHOT_BIT = 27,
	REQ_F_CLEAR_POLLIN_BIT = 28,
	REQ_F_SUPPORT_NOWAIT_BIT = 29,
	REQ_F_ISREG_BIT = 30,
	REQ_F_POLL_NO_LAZY_BIT = 31,
	REQ_F_CAN_POLL_BIT = 32,
	REQ_F_BL_EMPTY_BIT = 33,
	REQ_F_BL_NO_RECYCLE_BIT = 34,
	REQ_F_BUFFERS_COMMIT_BIT = 35,
	REQ_F_BUF_NODE_BIT = 36,
	REQ_F_HAS_METADATA_BIT = 37,
	REQ_F_IMPORT_BUFFER_BIT = 38,
	__REQ_F_LAST_BIT = 39,
};

enum {
	RI_CLR_RD_PERR = 512,
	RI_CLR_WR_PERR = 256,
	RI_RST_CLR = 2,
	RI_RST_SET = 1,
};

enum {
	RK805_BUCK1_2_ILMAX_2500MA = 0,
	RK805_BUCK1_2_ILMAX_3000MA = 1,
	RK805_BUCK1_2_ILMAX_3500MA = 2,
	RK805_BUCK1_2_ILMAX_4000MA = 3,
};

enum {
	RK805_BUCK3_ILMAX_1500MA = 0,
	RK805_BUCK3_ILMAX_2000MA = 1,
	RK805_BUCK3_ILMAX_2500MA = 2,
	RK805_BUCK3_ILMAX_3000MA = 3,
};

enum {
	RK805_BUCK4_ILMAX_2000MA = 0,
	RK805_BUCK4_ILMAX_2500MA = 1,
	RK805_BUCK4_ILMAX_3000MA = 2,
	RK805_BUCK4_ILMAX_3500MA = 3,
};

enum {
	RK805_ID = 32848,
	RK806_ID = 32864,
	RK808_ID = 0,
	RK809_ID = 32912,
	RK816_ID = 33120,
	RK817_ID = 33136,
	RK818_ID = 33152,
};

enum {
	RK8600_CHIP_ID_08 = 8,
};

enum {
	RK8602_CHIP_ID_10 = 10,
};

enum {
	RPCAUTH_info = 0,
	RPCAUTH_EOF = 1,
};

enum {
	RPCAUTH_lockd = 0,
	RPCAUTH_mount = 1,
	RPCAUTH_nfs = 2,
	RPCAUTH_portmap = 3,
	RPCAUTH_statd = 4,
	RPCAUTH_nfsd4_cb = 5,
	RPCAUTH_cache = 6,
	RPCAUTH_nfsd = 7,
	RPCAUTH_gssd = 8,
	RPCAUTH_RootEOF = 9,
};

enum {
	RPCBPROC_NULL = 0,
	RPCBPROC_SET = 1,
	RPCBPROC_UNSET = 2,
	RPCBPROC_GETPORT = 3,
	RPCBPROC_GETADDR = 3,
	RPCBPROC_DUMP = 4,
	RPCBPROC_CALLIT = 5,
	RPCBPROC_BCAST = 5,
	RPCBPROC_GETTIME = 6,
	RPCBPROC_UADDR2TADDR = 7,
	RPCBPROC_TADDR2UADDR = 8,
	RPCBPROC_GETVERSADDR = 9,
	RPCBPROC_INDIRECT = 10,
	RPCBPROC_GETADDRLIST = 11,
	RPCBPROC_GETSTAT = 12,
};

enum {
	RPCSVC_MAXPAYLOAD = 4194304,
	RPCSVC_MAXPAYLOAD_TCP = 4194304,
	RPCSVC_MAXPAYLOAD_UDP = 32768,
};

enum {
	RPC_PIPEFS_MOUNT = 0,
	RPC_PIPEFS_UMOUNT = 1,
};

enum {
	RPC_TASK_RUNNING = 0,
	RPC_TASK_QUEUED = 1,
	RPC_TASK_ACTIVE = 2,
	RPC_TASK_NEED_XMIT = 3,
	RPC_TASK_NEED_RECV = 4,
	RPC_TASK_MSG_PIN_WAIT = 5,
};

enum {
	RQ_SECURE = 0,
	RQ_LOCAL = 1,
	RQ_USEDEFERRAL = 2,
	RQ_DROPME = 3,
	RQ_VICTIM = 4,
	RQ_DATA = 5,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTC_SEC = 0,
	RTC_MIN = 1,
	RTC_HOUR = 2,
	RTC_WEEKDAY = 3,
	RTC_MONTH = 4,
	RTC_YEAR = 5,
	RTC_MONTHDAY = 6,
	RTC_NR_TIME = 7,
};

enum {
	RTC_SEC___2 = 0,
	RTC_MIN___2 = 1,
	RTC_HOUR___2 = 2,
	RTC_WEEKDAY___2 = 3,
	RTC_DATE = 4,
	RTC_MONTH___2 = 5,
	RTC_YEAR1 = 6,
	RTC_YEAR2 = 7,
	RTC_MAX_NUM_TIME_REGS = 8,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_NEWMULTICAST = 56,
	RTM_DELMULTICAST = 57,
	RTM_GETMULTICAST = 58,
	RTM_NEWANYCAST = 60,
	RTM_DELANYCAST = 61,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RX_GCLKMAC_ENA = -2147483648,
	RX_GCLKMAC_OFF = 1073741824,
	RX_STFW_DIS = 536870912,
	RX_STFW_ENA = 268435456,
	RX_TRUNC_ON = 134217728,
	RX_TRUNC_OFF = 67108864,
	RX_VLAN_STRIP_ON = 33554432,
	RX_VLAN_STRIP_OFF = 16777216,
	RX_MACSEC_FLUSH_ON = 8388608,
	RX_MACSEC_FLUSH_OFF = 4194304,
	RX_MACSEC_ASF_FLUSH_ON = 2097152,
	RX_MACSEC_ASF_FLUSH_OFF = 1048576,
	GMF_RX_OVER_ON = 524288,
	GMF_RX_OVER_OFF = 262144,
	GMF_ASF_RX_OVER_ON = 131072,
	GMF_ASF_RX_OVER_OFF = 65536,
	GMF_WP_TST_ON = 16384,
	GMF_WP_TST_OFF = 8192,
	GMF_WP_STEP = 4096,
	GMF_RP_TST_ON = 1024,
	GMF_RP_TST_OFF = 512,
	GMF_RP_STEP = 256,
	GMF_RX_F_FL_ON = 128,
	GMF_RX_F_FL_OFF = 64,
	GMF_CLI_RX_FO = 32,
	GMF_CLI_RX_C = 16,
	GMF_OPER_ON = 8,
	GMF_OPER_OFF = 4,
	GMF_RST_CLR = 2,
	GMF_RST_SET = 1,
	RX_GMF_FL_THR_DEF = 10,
	GMF_RX_CTRL_DEF = 136,
};

enum {
	RX_IPV6_SA_MOB_ENA = 512,
	RX_IPV6_SA_MOB_DIS = 256,
	RX_IPV6_DA_MOB_ENA = 128,
	RX_IPV6_DA_MOB_DIS = 64,
	RX_PTR_SYNCDLY_ENA = 32,
	RX_PTR_SYNCDLY_DIS = 16,
	RX_ASF_NEWFLAG_ENA = 8,
	RX_ASF_NEWFLAG_DIS = 4,
	RX_FLSH_MISSPKT_ENA = 2,
	RX_FLSH_MISSPKT_DIS = 1,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	Rworksched = 1,
	Rpending = 2,
	Wworksched = 4,
	Wpending = 8,
};

enum {
	SAS_DATAPRES_NO_DATA = 0,
	SAS_DATAPRES_RESPONSE_DATA = 1,
	SAS_DATAPRES_SENSE_DATA = 2,
};

enum {
	SAS_DEV_GONE = 0,
	SAS_DEV_FOUND = 1,
	SAS_DEV_DESTROY = 2,
	SAS_DEV_EH_PENDING = 3,
	SAS_DEV_LU_RESET = 4,
	SAS_DEV_RESET = 5,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
	SCM_TSTAMP_COMPLETION = 3,
};

enum {
	SC_STAT_CLR_IRQ = 16,
	SC_STAT_OP_ON = 8,
	SC_STAT_OP_OFF = 4,
	SC_STAT_RST_CLR = 2,
	SC_STAT_RST_SET = 1,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SIL24_HOST_BAR = 0,
	SIL24_PORT_BAR = 2,
	SIL24_PRB_SZ = 64,
	SIL24_MAX_SGT = 63,
	SIL24_MAX_SGE = 253,
	HOST_SLOT_STAT = 0,
	HOST_CTRL = 64,
	HOST_IRQ_STAT___2 = 68,
	HOST_PHY_CFG = 72,
	HOST_BIST_CTRL = 80,
	HOST_BIST_PTRN = 84,
	HOST_BIST_STAT = 88,
	HOST_MEM_BIST_STAT = 92,
	HOST_FLASH_CMD = 112,
	HOST_FLASH_DATA = 116,
	HOST_TRANSITION_DETECT = 117,
	HOST_GPIO_CTRL = 118,
	HOST_I2C_ADDR = 120,
	HOST_I2C_DATA = 124,
	HOST_I2C_XFER_CNT = 126,
	HOST_I2C_CTRL = 127,
	HOST_SSTAT_ATTN = -2147483648,
	HOST_CTRL_M66EN = 65536,
	HOST_CTRL_TRDY = 131072,
	HOST_CTRL_STOP = 262144,
	HOST_CTRL_DEVSEL = 524288,
	HOST_CTRL_REQ64 = 1048576,
	HOST_CTRL_GLOBAL_RST = -2147483648,
	PORT_REGS_SIZE = 8192,
	PORT_LRAM = 0,
	PORT_LRAM_SLOT_SZ = 128,
	PORT_PMP = 3968,
	PORT_PMP_STATUS = 0,
	PORT_PMP_QACTIVE = 4,
	PORT_PMP_SIZE = 8,
	PORT_CTRL_STAT = 4096,
	PORT_CTRL_CLR = 4100,
	PORT_IRQ_STAT___2 = 4104,
	PORT_IRQ_ENABLE_SET = 4112,
	PORT_IRQ_ENABLE_CLR = 4116,
	PORT_ACTIVATE_UPPER_ADDR = 4124,
	PORT_EXEC_FIFO = 4128,
	PORT_CMD_ERR = 4132,
	PORT_FIS_CFG = 4136,
	PORT_FIFO_THRES = 4140,
	PORT_DECODE_ERR_CNT = 4160,
	PORT_DECODE_ERR_THRESH = 4162,
	PORT_CRC_ERR_CNT = 4164,
	PORT_CRC_ERR_THRESH = 4166,
	PORT_HSHK_ERR_CNT = 4168,
	PORT_HSHK_ERR_THRESH = 4170,
	PORT_PHY_CFG = 4176,
	PORT_SLOT_STAT = 6144,
	PORT_CMD_ACTIVATE = 7168,
	PORT_CONTEXT = 7684,
	PORT_EXEC_DIAG = 7680,
	PORT_PSD_DIAG = 7744,
	PORT_SCONTROL = 7936,
	PORT_SSTATUS = 7940,
	PORT_SERROR = 7944,
	PORT_SACTIVE = 7948,
	PORT_CS_PORT_RST = 1,
	PORT_CS_DEV_RST = 2,
	PORT_CS_INIT = 4,
	PORT_CS_IRQ_WOC = 8,
	PORT_CS_CDB16 = 32,
	PORT_CS_PMP_RESUME = 64,
	PORT_CS_32BIT_ACTV = 1024,
	PORT_CS_PMP_EN = 8192,
	PORT_CS_RDY = -2147483648,
	PORT_IRQ_COMPLETE = 1,
	PORT_IRQ_ERROR___2 = 2,
	PORT_IRQ_PORTRDY_CHG = 4,
	PORT_IRQ_PWR_CHG = 8,
	PORT_IRQ_PHYRDY_CHG = 16,
	PORT_IRQ_COMWAKE = 32,
	PORT_IRQ_UNK_FIS___2 = 64,
	PORT_IRQ_DEV_XCHG = 128,
	PORT_IRQ_8B10B = 256,
	PORT_IRQ_CRC = 512,
	PORT_IRQ_HANDSHAKE = 1024,
	PORT_IRQ_SDB_NOTIFY = 2048,
	DEF_PORT_IRQ___2 = 2259,
	PORT_IRQ_RAW_SHIFT = 16,
	PORT_IRQ_MASKED_MASK = 2047,
	PORT_IRQ_RAW_MASK = 134152192,
	PORT_IRQ_STEER_SHIFT = 30,
	PORT_IRQ_STEER_MASK = -1073741824,
	PORT_CERR_DEV = 1,
	PORT_CERR_SDB = 2,
	PORT_CERR_DATA = 3,
	PORT_CERR_SEND = 4,
	PORT_CERR_INCONSISTENT = 5,
	PORT_CERR_DIRECTION = 6,
	PORT_CERR_UNDERRUN = 7,
	PORT_CERR_OVERRUN = 8,
	PORT_CERR_PKT_PROT = 11,
	PORT_CERR_SGT_BOUNDARY = 16,
	PORT_CERR_SGT_TGTABRT = 17,
	PORT_CERR_SGT_MSTABRT = 18,
	PORT_CERR_SGT_PCIPERR = 19,
	PORT_CERR_CMD_BOUNDARY = 24,
	PORT_CERR_CMD_TGTABRT = 25,
	PORT_CERR_CMD_MSTABRT = 26,
	PORT_CERR_CMD_PCIPERR = 27,
	PORT_CERR_XFR_UNDEF = 32,
	PORT_CERR_XFR_TGTABRT = 33,
	PORT_CERR_XFR_MSTABRT = 34,
	PORT_CERR_XFR_PCIPERR = 35,
	PORT_CERR_SENDSERVICE = 36,
	PRB_CTRL_PROTOCOL = 1,
	PRB_CTRL_PACKET_READ = 16,
	PRB_CTRL_PACKET_WRITE = 32,
	PRB_CTRL_NIEN = 64,
	PRB_CTRL_SRST = 128,
	PRB_PROT_PACKET = 1,
	PRB_PROT_TCQ = 2,
	PRB_PROT_NCQ = 4,
	PRB_PROT_READ = 8,
	PRB_PROT_WRITE = 16,
	PRB_PROT_TRANSPARENT = 32,
	SGE_TRM = -2147483648,
	SGE_LNK = 1073741824,
	SGE_DRD = 536870912,
	SIL24_MAX_CMDS = 31,
	BID_SIL3124 = 0,
	BID_SIL3132 = 1,
	BID_SIL3131 = 2,
	SIL24_COMMON_FLAGS = 918658,
	SIL24_FLAG_PCIX_IRQ_WOC = 16777216,
	IRQ_STAT_4PORTS = 15,
};

enum {
	SILERGY_SYR82X = 8,
	SILERGY_SYR83X = 9,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP_NOBPF = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_COMPLETION_TSTAMP = 8,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
	SKBTX_BPF = 128,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
	SKB_GSO_TCP_ACCECN = 524288,
};

enum {
	SKCIPHER_WALK_SLOW = 1,
	SKCIPHER_WALK_COPY = 2,
	SKCIPHER_WALK_DIFF = 4,
	SKCIPHER_WALK_SLEEP = 8,
};

enum {
	SK_BPF_CB_TX_TIMESTAMPING = 1,
	SK_BPF_CB_MASK = 1,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SNDRV_CHMAP_UNKNOWN = 0,
	SNDRV_CHMAP_NA = 1,
	SNDRV_CHMAP_MONO = 2,
	SNDRV_CHMAP_FL = 3,
	SNDRV_CHMAP_FR = 4,
	SNDRV_CHMAP_RL = 5,
	SNDRV_CHMAP_RR = 6,
	SNDRV_CHMAP_FC = 7,
	SNDRV_CHMAP_LFE = 8,
	SNDRV_CHMAP_SL = 9,
	SNDRV_CHMAP_SR = 10,
	SNDRV_CHMAP_RC = 11,
	SNDRV_CHMAP_FLC = 12,
	SNDRV_CHMAP_FRC = 13,
	SNDRV_CHMAP_RLC = 14,
	SNDRV_CHMAP_RRC = 15,
	SNDRV_CHMAP_FLW = 16,
	SNDRV_CHMAP_FRW = 17,
	SNDRV_CHMAP_FLH = 18,
	SNDRV_CHMAP_FCH = 19,
	SNDRV_CHMAP_FRH = 20,
	SNDRV_CHMAP_TC = 21,
	SNDRV_CHMAP_TFL = 22,
	SNDRV_CHMAP_TFR = 23,
	SNDRV_CHMAP_TFC = 24,
	SNDRV_CHMAP_TRL = 25,
	SNDRV_CHMAP_TRR = 26,
	SNDRV_CHMAP_TRC = 27,
	SNDRV_CHMAP_TFLC = 28,
	SNDRV_CHMAP_TFRC = 29,
	SNDRV_CHMAP_TSL = 30,
	SNDRV_CHMAP_TSR = 31,
	SNDRV_CHMAP_LLFE = 32,
	SNDRV_CHMAP_RLFE = 33,
	SNDRV_CHMAP_BC = 34,
	SNDRV_CHMAP_BLC = 35,
	SNDRV_CHMAP_BRC = 36,
	SNDRV_CHMAP_LAST = 36,
};

enum {
	SNDRV_CTL_TLV_OP_READ = 0,
	SNDRV_CTL_TLV_OP_WRITE = 1,
	SNDRV_CTL_TLV_OP_CMD = -1,
};

enum {
	SNDRV_DEVICE_TYPE_CONTROL = 0,
	SNDRV_DEVICE_TYPE_SEQUENCER = 1,
	SNDRV_DEVICE_TYPE_TIMER = 2,
	SNDRV_DEVICE_TYPE_HWDEP = 3,
	SNDRV_DEVICE_TYPE_RAWMIDI = 4,
	SNDRV_DEVICE_TYPE_PCM_PLAYBACK = 5,
	SNDRV_DEVICE_TYPE_PCM_CAPTURE = 6,
	SNDRV_DEVICE_TYPE_COMPRESS = 7,
};

enum {
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_COMPAT = 0,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_DEFAULT = 1,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK = 2,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ABSOLUTE = 3,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ESTIMATED = 4,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED = 5,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LAST = 5,
};

enum {
	SNDRV_PCM_CLASS_GENERIC = 0,
	SNDRV_PCM_CLASS_MULTI = 1,
	SNDRV_PCM_CLASS_MODEM = 2,
	SNDRV_PCM_CLASS_DIGITIZER = 3,
	SNDRV_PCM_CLASS_LAST = 3,
};

enum {
	SNDRV_PCM_MMAP_OFFSET_DATA = 0,
	SNDRV_PCM_MMAP_OFFSET_STATUS_OLD = 2147483648,
	SNDRV_PCM_MMAP_OFFSET_CONTROL_OLD = 2164260864,
	SNDRV_PCM_MMAP_OFFSET_STATUS_NEW = 2181038080,
	SNDRV_PCM_MMAP_OFFSET_CONTROL_NEW = 2197815296,
	SNDRV_PCM_MMAP_OFFSET_STATUS = 2181038080,
	SNDRV_PCM_MMAP_OFFSET_CONTROL = 2197815296,
};

enum {
	SNDRV_PCM_STREAM_PLAYBACK = 0,
	SNDRV_PCM_STREAM_CAPTURE = 1,
	SNDRV_PCM_STREAM_LAST = 1,
};

enum {
	SNDRV_PCM_TSTAMP_NONE = 0,
	SNDRV_PCM_TSTAMP_ENABLE = 1,
	SNDRV_PCM_TSTAMP_LAST = 1,
};

enum {
	SNDRV_PCM_TSTAMP_TYPE_GETTIMEOFDAY = 0,
	SNDRV_PCM_TSTAMP_TYPE_MONOTONIC = 1,
	SNDRV_PCM_TSTAMP_TYPE_MONOTONIC_RAW = 2,
	SNDRV_PCM_TSTAMP_TYPE_LAST = 2,
};

enum {
	SNDRV_TIMER_CLASS_NONE = -1,
	SNDRV_TIMER_CLASS_SLAVE = 0,
	SNDRV_TIMER_CLASS_GLOBAL = 1,
	SNDRV_TIMER_CLASS_CARD = 2,
	SNDRV_TIMER_CLASS_PCM = 3,
	SNDRV_TIMER_CLASS_LAST = 3,
};

enum {
	SNDRV_TIMER_EVENT_RESOLUTION = 0,
	SNDRV_TIMER_EVENT_TICK = 1,
	SNDRV_TIMER_EVENT_START = 2,
	SNDRV_TIMER_EVENT_STOP = 3,
	SNDRV_TIMER_EVENT_CONTINUE = 4,
	SNDRV_TIMER_EVENT_PAUSE = 5,
	SNDRV_TIMER_EVENT_EARLY = 6,
	SNDRV_TIMER_EVENT_SUSPEND = 7,
	SNDRV_TIMER_EVENT_RESUME = 8,
	SNDRV_TIMER_EVENT_MSTART = 12,
	SNDRV_TIMER_EVENT_MSTOP = 13,
	SNDRV_TIMER_EVENT_MCONTINUE = 14,
	SNDRV_TIMER_EVENT_MPAUSE = 15,
	SNDRV_TIMER_EVENT_MSUSPEND = 17,
	SNDRV_TIMER_EVENT_MRESUME = 18,
};

enum {
	SNDRV_TIMER_IOCTL_START_OLD = 536892448,
	SNDRV_TIMER_IOCTL_STOP_OLD = 536892449,
	SNDRV_TIMER_IOCTL_CONTINUE_OLD = 536892450,
	SNDRV_TIMER_IOCTL_PAUSE_OLD = 536892451,
};

enum {
	SNDRV_TIMER_SCLASS_NONE = 0,
	SNDRV_TIMER_SCLASS_APPLICATION = 1,
	SNDRV_TIMER_SCLASS_SEQUENCER = 2,
	SNDRV_TIMER_SCLASS_OSS_SEQUENCER = 3,
	SNDRV_TIMER_SCLASS_LAST = 3,
};

enum {
	SND_CTL_SUBDEV_PCM = 0,
	SND_CTL_SUBDEV_RAWMIDI = 1,
	SND_CTL_SUBDEV_ITEMS = 2,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_TX_COMPLETION = 262144,
	SOF_TIMESTAMPING_LAST = 262144,
	SOF_TIMESTAMPING_MASK = 524287,
};

enum {
	SP_TASK_PENDING = 0,
	SP_NEED_VICTIM = 1,
	SP_VICTIM_REMAINS = 2,
};

enum {
	SQ_START = 0,
	SQ_STOP = 1,
	SQ_ICU = 2,
};

enum {
	SQ_STS = 1,
	SQ_CUS = 2,
};

enum {
	STAT_CTRL = 3712,
	STAT_LAST_IDX = 3716,
	STAT_LIST_ADDR_LO = 3720,
	STAT_LIST_ADDR_HI = 3724,
	STAT_TXA1_RIDX = 3728,
	STAT_TXS1_RIDX = 3730,
	STAT_TXA2_RIDX = 3732,
	STAT_TXS2_RIDX = 3734,
	STAT_TX_IDX_TH = 3736,
	STAT_PUT_IDX = 3740,
	STAT_FIFO_WP = 3744,
	STAT_FIFO_RP = 3748,
	STAT_FIFO_RSP = 3750,
	STAT_FIFO_LEVEL = 3752,
	STAT_FIFO_SHLVL = 3754,
	STAT_FIFO_WM = 3756,
	STAT_FIFO_ISR_WM = 3757,
	STAT_LEV_TIMER_INI = 3760,
	STAT_LEV_TIMER_CNT = 3764,
	STAT_LEV_TIMER_CTRL = 3768,
	STAT_LEV_TIMER_TEST = 3769,
	STAT_TX_TIMER_INI = 3776,
	STAT_TX_TIMER_CNT = 3780,
	STAT_TX_TIMER_CTRL = 3784,
	STAT_TX_TIMER_TEST = 3785,
	STAT_ISR_TIMER_INI = 3792,
	STAT_ISR_TIMER_CNT = 3796,
	STAT_ISR_TIMER_CTRL = 3800,
	STAT_ISR_TIMER_TEST = 3801,
};

enum {
	STRICT = 0,
	EMULATED = 1,
	LEGACY = 2,
	STD2008 = 3,
	RELAXED = 4,
};

enum {
	SUNRPC_PIPEFS_NFS_PRIO = 0,
	SUNRPC_PIPEFS_RPC_PRIO = 1,
};

enum {
	SVC_HANDSHAKE_TO = 1250,
};

enum {
	SVC_POOL_AUTO = -1,
	SVC_POOL_GLOBAL = 0,
	SVC_POOL_PERCPU = 1,
	SVC_POOL_PERNODE = 2,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
};

enum {
	SYNAPTICS_INTERTOUCH_NOT_SET = -1,
	SYNAPTICS_INTERTOUCH_OFF = 0,
	SYNAPTICS_INTERTOUCH_ON = 1,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TASK_REQ_UPIU_SIZE_DWORDS = 8,
	TASK_RSP_UPIU_SIZE_DWORDS = 8,
	ALIGNED_UPIU_SIZE = 512,
};

enum {
	TBMU_TEST_BMU_TX_CHK_AUTO_OFF = -2147483648,
	TBMU_TEST_BMU_TX_CHK_AUTO_ON = 1073741824,
	TBMU_TEST_HOME_ADD_PAD_FIX1_EN = 536870912,
	TBMU_TEST_HOME_ADD_PAD_FIX1_DIS = 268435456,
	TBMU_TEST_ROUTING_ADD_FIX_EN = 134217728,
	TBMU_TEST_ROUTING_ADD_FIX_DIS = 67108864,
	TBMU_TEST_HOME_ADD_FIX_EN = 33554432,
	TBMU_TEST_HOME_ADD_FIX_DIS = 16777216,
	TBMU_TEST_TEST_RSPTR_ON = 4194304,
	TBMU_TEST_TEST_RSPTR_OFF = 2097152,
	TBMU_TEST_TESTSTEP_RSPTR = 1048576,
	TBMU_TEST_TEST_RPTR_ON = 262144,
	TBMU_TEST_TEST_RPTR_OFF = 131072,
	TBMU_TEST_TESTSTEP_RPTR = 65536,
	TBMU_TEST_TEST_WSPTR_ON = 16384,
	TBMU_TEST_TEST_WSPTR_OFF = 8192,
	TBMU_TEST_TESTSTEP_WSPTR = 4096,
	TBMU_TEST_TEST_WPTR_ON = 1024,
	TBMU_TEST_TEST_WPTR_OFF = 512,
	TBMU_TEST_TESTSTEP_WPTR = 256,
	TBMU_TEST_TEST_REQ_NB_ON = 64,
	TBMU_TEST_TEST_REQ_NB_OFF = 32,
	TBMU_TEST_TESTSTEP_REQ_NB = 16,
	TBMU_TEST_TEST_DONE_IDX_ON = 4,
	TBMU_TEST_TEST_DONE_IDX_OFF = 2,
	TBMU_TEST_TESTSTEP_DONE_IDX = 1,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_FLOWER_KEY_FLAGS_IS_FRAGMENT = 1,
	TCA_FLOWER_KEY_FLAGS_FRAG_IS_FIRST = 2,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CSUM = 4,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_DONT_FRAGMENT = 8,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_OAM = 16,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CRIT_OPT = 32,
	__TCA_FLOWER_KEY_FLAGS_MAX = 33,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
	SK_BPF_CB_FLAGS = 1009,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_AE = 1,
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 14,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TCP_V4_FLOW = 1,
	UDP_V4_FLOW = 2,
	SCTP_V4_FLOW = 3,
	AH_ESP_V4_FLOW = 4,
	TCP_V6_FLOW = 5,
	UDP_V6_FLOW = 6,
	SCTP_V6_FLOW = 7,
	AH_ESP_V6_FLOW = 8,
	AH_V4_FLOW = 9,
	ESP_V4_FLOW = 10,
	AH_V6_FLOW = 11,
	ESP_V6_FLOW = 12,
	IPV4_USER_FLOW = 13,
	IP_USER_FLOW = 13,
	IPV6_USER_FLOW = 14,
	IPV4_FLOW = 16,
	IPV6_FLOW = 17,
	ETHER_FLOW = 18,
	GTPU_V4_FLOW = 19,
	GTPU_V6_FLOW = 20,
	GTPC_V4_FLOW = 21,
	GTPC_V6_FLOW = 22,
	GTPC_TEID_V4_FLOW = 23,
	GTPC_TEID_V6_FLOW = 24,
	GTPU_EH_V4_FLOW = 25,
	GTPU_EH_V6_FLOW = 26,
	GTPU_UL_V4_FLOW = 27,
	GTPU_UL_V6_FLOW = 28,
	GTPU_DL_V4_FLOW = 29,
	GTPU_DL_V6_FLOW = 30,
	__FLOW_TYPE_COUNT = 31,
};

enum {
	TCS4525_CHIP_ID_12 = 12,
};

enum {
	TCS4526_CHIP_ID_00 = 0,
};

enum {
	TIM_START = 4,
	TIM_STOP = 2,
	TIM_CLR_IRQ = 1,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TPS65219_INT_LDO3_SCG = 0,
	TPS65219_INT_LDO3_OC = 1,
	TPS65219_INT_LDO3_UV = 2,
	TPS65219_INT_LDO4_SCG = 3,
	TPS65219_INT_LDO4_OC = 4,
	TPS65219_INT_LDO4_UV = 5,
	TPS65215_INT_LDO1_SCG = 6,
	TPS65215_INT_LDO1_OC = 7,
	TPS65215_INT_LDO1_UV = 8,
	TPS65215_INT_LDO2_SCG = 9,
	TPS65215_INT_LDO2_OC = 10,
	TPS65215_INT_LDO2_UV = 11,
	TPS65219_INT_LDO1_SCG = 12,
	TPS65219_INT_LDO1_OC = 13,
	TPS65219_INT_LDO1_UV = 14,
	TPS65219_INT_LDO2_SCG = 15,
	TPS65219_INT_LDO2_OC = 16,
	TPS65219_INT_LDO2_UV = 17,
	TPS65219_INT_BUCK3_SCG = 18,
	TPS65219_INT_BUCK3_OC = 19,
	TPS65219_INT_BUCK3_NEG_OC = 20,
	TPS65219_INT_BUCK3_UV = 21,
	TPS65219_INT_BUCK1_SCG = 22,
	TPS65219_INT_BUCK1_OC = 23,
	TPS65219_INT_BUCK1_NEG_OC = 24,
	TPS65219_INT_BUCK1_UV = 25,
	TPS65219_INT_BUCK2_SCG = 26,
	TPS65219_INT_BUCK2_OC = 27,
	TPS65219_INT_BUCK2_NEG_OC = 28,
	TPS65219_INT_BUCK2_UV = 29,
	TPS65219_INT_SENSOR_3_WARM = 30,
	TPS65219_INT_SENSOR_2_WARM = 31,
	TPS65219_INT_SENSOR_1_WARM = 32,
	TPS65219_INT_SENSOR_0_WARM = 33,
	TPS65219_INT_SENSOR_3_HOT = 34,
	TPS65219_INT_SENSOR_2_HOT = 35,
	TPS65219_INT_SENSOR_1_HOT = 36,
	TPS65219_INT_SENSOR_0_HOT = 37,
	TPS65219_INT_BUCK1_RV = 38,
	TPS65219_INT_BUCK2_RV = 39,
	TPS65219_INT_BUCK3_RV = 40,
	TPS65219_INT_LDO1_RV = 41,
	TPS65219_INT_LDO2_RV = 42,
	TPS65215_INT_LDO2_RV = 43,
	TPS65214_INT_LDO2_RV = 44,
	TPS65219_INT_LDO3_RV = 45,
	TPS65219_INT_LDO4_RV = 46,
	TPS65219_INT_BUCK1_RV_SD = 47,
	TPS65219_INT_BUCK2_RV_SD = 48,
	TPS65219_INT_BUCK3_RV_SD = 49,
	TPS65219_INT_LDO1_RV_SD = 50,
	TPS65214_INT_LDO1_RV_SD = 51,
	TPS65215_INT_LDO2_RV_SD = 52,
	TPS65219_INT_LDO2_RV_SD = 53,
	TPS65219_INT_LDO3_RV_SD = 54,
	TPS65219_INT_LDO4_RV_SD = 55,
	TPS65219_INT_TIMEOUT = 56,
	TPS65219_INT_PB_FALLING_EDGE_DETECT = 57,
	TPS65219_INT_PB_RISING_EDGE_DETECT = 58,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_TP_NAME = 13,
	TP_ERR_BAD_ADDR_SUFFIX = 14,
	TP_ERR_NO_GROUP_NAME = 15,
	TP_ERR_GROUP_TOO_LONG = 16,
	TP_ERR_BAD_GROUP_NAME = 17,
	TP_ERR_NO_EVENT_NAME = 18,
	TP_ERR_EVENT_TOO_LONG = 19,
	TP_ERR_BAD_EVENT_NAME = 20,
	TP_ERR_EVENT_EXIST = 21,
	TP_ERR_RETVAL_ON_PROBE = 22,
	TP_ERR_NO_RETVAL = 23,
	TP_ERR_BAD_STACK_NUM = 24,
	TP_ERR_BAD_ARG_NUM = 25,
	TP_ERR_BAD_VAR = 26,
	TP_ERR_BAD_REG_NAME = 27,
	TP_ERR_BAD_MEM_ADDR = 28,
	TP_ERR_BAD_IMM = 29,
	TP_ERR_IMMSTR_NO_CLOSE = 30,
	TP_ERR_FILE_ON_KPROBE = 31,
	TP_ERR_BAD_FILE_OFFS = 32,
	TP_ERR_SYM_ON_UPROBE = 33,
	TP_ERR_TOO_MANY_OPS = 34,
	TP_ERR_DEREF_NEED_BRACE = 35,
	TP_ERR_BAD_DEREF_OFFS = 36,
	TP_ERR_DEREF_OPEN_BRACE = 37,
	TP_ERR_COMM_CANT_DEREF = 38,
	TP_ERR_BAD_FETCH_ARG = 39,
	TP_ERR_ARRAY_NO_CLOSE = 40,
	TP_ERR_BAD_ARRAY_SUFFIX = 41,
	TP_ERR_BAD_ARRAY_NUM = 42,
	TP_ERR_ARRAY_TOO_BIG = 43,
	TP_ERR_BAD_TYPE = 44,
	TP_ERR_BAD_STRING = 45,
	TP_ERR_BAD_SYMSTRING = 46,
	TP_ERR_BAD_BITFIELD = 47,
	TP_ERR_ARG_NAME_TOO_LONG = 48,
	TP_ERR_NO_ARG_NAME = 49,
	TP_ERR_BAD_ARG_NAME = 50,
	TP_ERR_USED_ARG_NAME = 51,
	TP_ERR_ARG_TOO_LONG = 52,
	TP_ERR_NO_ARG_BODY = 53,
	TP_ERR_BAD_INSN_BNDRY = 54,
	TP_ERR_FAIL_REG_PROBE = 55,
	TP_ERR_DIFF_PROBE_TYPE = 56,
	TP_ERR_DIFF_ARG_TYPE = 57,
	TP_ERR_SAME_PROBE = 58,
	TP_ERR_NO_EVENT_INFO = 59,
	TP_ERR_BAD_ATTACH_EVENT = 60,
	TP_ERR_BAD_ATTACH_ARG = 61,
	TP_ERR_NO_EP_FILTER = 62,
	TP_ERR_NOSUP_BTFARG = 63,
	TP_ERR_NO_BTFARG = 64,
	TP_ERR_NO_BTF_ENTRY = 65,
	TP_ERR_BAD_VAR_ARGS = 66,
	TP_ERR_NOFENTRY_ARGS = 67,
	TP_ERR_DOUBLE_ARGS = 68,
	TP_ERR_ARGS_2LONG = 69,
	TP_ERR_ARGIDX_2BIG = 70,
	TP_ERR_NO_PTR_STRCT = 71,
	TP_ERR_NOSUP_DAT_ARG = 72,
	TP_ERR_BAD_HYPHEN = 73,
	TP_ERR_NO_BTF_FIELD = 74,
	TP_ERR_BAD_BTF_TID = 75,
	TP_ERR_BAD_TYPE4STR = 76,
	TP_ERR_NEED_STRING_TYPE = 77,
	TP_ERR_TOO_MANY_ARGS = 78,
	TP_ERR_TOO_MANY_EARGS = 79,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
	TRACE_ARRAY_FL_BOOT = 2,
	TRACE_ARRAY_FL_LAST_BOOT = 4,
	TRACE_ARRAY_FL_MOD_INIT = 8,
	TRACE_ARRAY_FL_MEMMAP = 16,
};

enum {
	TRACE_EVENT_FL_CAP_ANY = 1,
	TRACE_EVENT_FL_NO_SET_FILTER = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE = 4,
	TRACE_EVENT_FL_TRACEPOINT = 8,
	TRACE_EVENT_FL_DYNAMIC = 16,
	TRACE_EVENT_FL_KPROBE = 32,
	TRACE_EVENT_FL_UPROBE = 64,
	TRACE_EVENT_FL_EPROBE = 128,
	TRACE_EVENT_FL_FPROBE = 256,
	TRACE_EVENT_FL_CUSTOM = 512,
	TRACE_EVENT_FL_TEST_STR = 1024,
};

enum {
	TRACE_EVENT_FL_CAP_ANY_BIT = 0,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 1,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 2,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 3,
	TRACE_EVENT_FL_DYNAMIC_BIT = 4,
	TRACE_EVENT_FL_KPROBE_BIT = 5,
	TRACE_EVENT_FL_UPROBE_BIT = 6,
	TRACE_EVENT_FL_EPROBE_BIT = 7,
	TRACE_EVENT_FL_FPROBE_BIT = 8,
	TRACE_EVENT_FL_CUSTOM_BIT = 9,
	TRACE_EVENT_FL_TEST_STR_BIT = 10,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	TRANS_MODE_PIO = 0,
	TRANS_MODE_IDMAC = 1,
	TRANS_MODE_EDMAC = 2,
};

enum {
	TST_FRC_DPERR_MR = 128,
	TST_FRC_DPERR_MW = 64,
	TST_FRC_DPERR_TR = 32,
	TST_FRC_DPERR_TW = 16,
	TST_FRC_APERR_M = 8,
	TST_FRC_APERR_T = 4,
	TST_CFG_WRITE_ON = 2,
	TST_CFG_WRITE_OFF = 1,
};

enum {
	TXA_ENA_FSYNC = 128,
	TXA_DIS_FSYNC = 64,
	TXA_ENA_ALLOC = 32,
	TXA_DIS_ALLOC = 16,
	TXA_START_RC = 8,
	TXA_STOP_RC = 4,
	TXA_ENA_ARB = 2,
	TXA_DIS_ARB = 1,
};

enum {
	TXA_ITI_INI = 512,
	TXA_ITI_VAL = 516,
	TXA_LIM_INI = 520,
	TXA_LIM_VAL = 524,
	TXA_CTRL = 528,
	TXA_TEST = 529,
	TXA_STAT = 530,
	RSS_KEY = 544,
	RSS_CFG = 584,
};

enum {
	TX_DYN_WM_ENA = 3,
};

enum {
	TX_GMF_EA = 3392,
	TX_GMF_AE_THR = 3396,
	TX_GMF_CTRL_T = 3400,
	TX_GMF_WP = 3424,
	TX_GMF_WSP = 3428,
	TX_GMF_WLEV = 3432,
	TX_GMF_RP = 3440,
	TX_GMF_RSTP = 3444,
	TX_GMF_RLEV = 3448,
	ECU_AE_THR = 112,
	ECU_TXFF_LEV = 416,
	ECU_JUMBO_WM = 128,
};

enum {
	TX_STFW_DIS = -2147483648,
	TX_STFW_ENA = 1073741824,
	TX_VLAN_TAG_ON = 33554432,
	TX_VLAN_TAG_OFF = 16777216,
	TX_PCI_JUM_ENA = 8388608,
	TX_PCI_JUM_DIS = 4194304,
	GMF_WSP_TST_ON = 262144,
	GMF_WSP_TST_OFF = 131072,
	GMF_WSP_STEP = 65536,
	GMF_CLI_TX_FU = 64,
	GMF_CLI_TX_FC = 32,
	GMF_CLI_TX_PE = 16,
};

enum {
	UDPTCP = 1,
	CALSUM = 2,
	WR_SUM = 4,
	INIT_SUM = 8,
	LOCK_SUM = 16,
	INS_VLAN = 32,
	EOP = 128,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UFSHCD_EH_IN_PROGRESS = 1,
};

enum {
	UFSHCD_MAX_CHANNEL = 0,
	UFSHCD_MAX_ID = 1,
};

enum {
	UFSHCD_NANO_AMP = 0,
	UFSHCD_MICRO_AMP = 1,
	UFSHCD_MILI_AMP = 2,
	UFSHCD_AMP = 3,
};

enum {
	UFSHCD_POLL_FROM_INTERRUPT_CONTEXT = -1,
};

enum {
	UFSHCD_UIC_DL_PA_INIT_ERROR = 1,
	UFSHCD_UIC_DL_NAC_RECEIVED_ERROR = 2,
	UFSHCD_UIC_DL_TCx_REPLAY_ERROR = 4,
	UFSHCD_UIC_NL_ERROR = 8,
	UFSHCD_UIC_TL_ERROR = 16,
	UFSHCD_UIC_DME_ERROR = 32,
	UFSHCD_UIC_PA_GENERIC_ERROR = 64,
};

enum {
	UFS_ABORT_TASK = 1,
	UFS_ABORT_TASK_SET = 2,
	UFS_CLEAR_TASK_SET = 4,
	UFS_LOGICAL_RESET = 8,
	UFS_QUERY_TASK = 128,
	UFS_QUERY_TASK_SET = 129,
};

enum {
	UFS_DEV_HIGH_TEMP_NOTIF = 16,
	UFS_DEV_LOW_TEMP_NOTIF = 32,
	UFS_DEV_EXT_TEMP_NOTIF = 64,
	UFS_DEV_HPB_SUPPORT = 128,
	UFS_DEV_WRITE_BOOSTER_SUP = 256,
	UFS_DEV_LVL_EXCEPTION_SUP = 4096,
};

enum {
	UFS_DEV_WB_BUF_RESIZE = 1,
};

enum {
	UFS_UPIU_REPORT_LUNS_WLUN = 129,
	UFS_UPIU_UFS_DEVICE_WLUN = 208,
	UFS_UPIU_BOOT_WLUN = 176,
	UFS_UPIU_RPMB_WLUN = 196,
};

enum {
	UIC_CMD_TIMEOUT_DEFAULT = 500,
	UIC_CMD_TIMEOUT_MAX = 5000,
};

enum {
	UNALIGNED_ACTION_QUIET = 0,
	UNALIGNED_ACTION_SIGNAL = 1,
	UNALIGNED_ACTION_SHOW = 2,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	UPIU_CMD_FLAGS_NONE = 0,
	UPIU_CMD_FLAGS_CP = 4,
	UPIU_CMD_FLAGS_WRITE = 32,
	UPIU_CMD_FLAGS_READ = 64,
};

enum {
	UPIU_COMMAND_SET_TYPE_SCSI = 0,
	UPIU_COMMAND_SET_TYPE_UFS = 1,
	UPIU_COMMAND_SET_TYPE_QUERY = 2,
};

enum {
	UPIU_QUERY_FUNC_STANDARD_READ_REQUEST = 1,
	UPIU_QUERY_FUNC_STANDARD_WRITE_REQUEST = 129,
};

enum {
	UPIU_RSP_FLAG_UNDERFLOW = 32,
	UPIU_RSP_FLAG_OVERFLOW = 64,
};

enum {
	UPIU_TASK_MANAGEMENT_FUNC_COMPL = 0,
	UPIU_TASK_MANAGEMENT_FUNC_NOT_SUPPORTED = 4,
	UPIU_TASK_MANAGEMENT_FUNC_SUCCEEDED = 8,
	UPIU_TASK_MANAGEMENT_FUNC_FAILED = 5,
	UPIU_INCORRECT_LOGICAL_UNIT_NO = 9,
};

enum {
	US_FL_SINGLE_LUN = 1,
	US_FL_NEED_OVERRIDE = 2,
	US_FL_SCM_MULT_TARG = 4,
	US_FL_FIX_INQUIRY = 8,
	US_FL_FIX_CAPACITY = 16,
	US_FL_IGNORE_RESIDUE = 32,
	US_FL_BULK32 = 64,
	US_FL_NOT_LOCKABLE = 128,
	US_FL_GO_SLOW = 256,
	US_FL_NO_WP_DETECT = 512,
	US_FL_MAX_SECTORS_64 = 1024,
	US_FL_IGNORE_DEVICE = 2048,
	US_FL_CAPACITY_HEURISTICS = 4096,
	US_FL_MAX_SECTORS_MIN = 8192,
	US_FL_BULK_IGNORE_TAG = 16384,
	US_FL_SANE_SENSE = 32768,
	US_FL_CAPACITY_OK = 65536,
	US_FL_BAD_SENSE = 131072,
	US_FL_NO_READ_DISC_INFO = 262144,
	US_FL_NO_READ_CAPACITY_16 = 524288,
	US_FL_INITIAL_READ10 = 1048576,
	US_FL_WRITE_CACHE = 2097152,
	US_FL_NEEDS_CAP16 = 4194304,
	US_FL_IGNORE_UAS = 8388608,
	US_FL_BROKEN_FUA = 16777216,
	US_FL_NO_ATA_1X = 33554432,
	US_FL_NO_REPORT_OPCODES = 67108864,
	US_FL_MAX_SECTORS_240 = 134217728,
	US_FL_NO_REPORT_LUNS = 268435456,
	US_FL_ALWAYS_SYNC = 536870912,
	US_FL_NO_SAME = 1073741824,
	US_FL_SENSE_AFTER_SYNC = 2147483648,
};

enum {
	UTP_CMD_TYPE_UFS_STORAGE = 1,
};

enum {
	VFIO_DEVICE_NUM_STATES = 8,
};

enum {
	VFIO_PCI_BAR0_REGION_INDEX = 0,
	VFIO_PCI_BAR1_REGION_INDEX = 1,
	VFIO_PCI_BAR2_REGION_INDEX = 2,
	VFIO_PCI_BAR3_REGION_INDEX = 3,
	VFIO_PCI_BAR4_REGION_INDEX = 4,
	VFIO_PCI_BAR5_REGION_INDEX = 5,
	VFIO_PCI_ROM_REGION_INDEX = 6,
	VFIO_PCI_CONFIG_REGION_INDEX = 7,
	VFIO_PCI_VGA_REGION_INDEX = 8,
	VFIO_PCI_NUM_REGIONS = 9,
};

enum {
	VFIO_PCI_INTX_IRQ_INDEX = 0,
	VFIO_PCI_MSI_IRQ_INDEX = 1,
	VFIO_PCI_MSIX_IRQ_INDEX = 2,
	VFIO_PCI_ERR_IRQ_INDEX = 3,
	VFIO_PCI_REQ_IRQ_INDEX = 4,
	VFIO_PCI_NUM_IRQS = 5,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WB_BUF_MODE_LU_DEDICATED = 0,
	WB_BUF_MODE_SHARED = 1,
};

enum {
	WOL_CTL_LINK_CHG_OCC = 32768,
	WOL_CTL_MAGIC_PKT_OCC = 16384,
	WOL_CTL_PATTERN_OCC = 8192,
	WOL_CTL_CLEAR_RESULT = 4096,
	WOL_CTL_ENA_PME_ON_LINK_CHG = 2048,
	WOL_CTL_DIS_PME_ON_LINK_CHG = 1024,
	WOL_CTL_ENA_PME_ON_MAGIC_PKT = 512,
	WOL_CTL_DIS_PME_ON_MAGIC_PKT = 256,
	WOL_CTL_ENA_PME_ON_PATTERN = 128,
	WOL_CTL_DIS_PME_ON_PATTERN = 64,
	WOL_CTL_ENA_LINK_CHG_UNIT = 32,
	WOL_CTL_DIS_LINK_CHG_UNIT = 16,
	WOL_CTL_ENA_MAGIC_PKT_UNIT = 8,
	WOL_CTL_DIS_MAGIC_PKT_UNIT = 4,
	WOL_CTL_ENA_PATTERN_UNIT = 2,
	WOL_CTL_DIS_PATTERN_UNIT = 1,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XPT_BUSY = 0,
	XPT_CONN = 1,
	XPT_CLOSE = 2,
	XPT_DATA = 3,
	XPT_TEMP = 4,
	XPT_DEAD = 5,
	XPT_CHNGBUF = 6,
	XPT_DEFERRED = 7,
	XPT_OLD = 8,
	XPT_LISTENER = 9,
	XPT_CACHE_AUTH = 10,
	XPT_LOCAL = 11,
	XPT_KILL_TEMP = 12,
	XPT_CONG_CTRL = 13,
	XPT_HANDSHAKE = 14,
	XPT_TLS_SESSION = 15,
	XPT_PEER_AUTH = 16,
	XPT_PEER_VALID = 17,
};

enum {
	Y2_ASF_OS_PRES = 16,
	Y2_ASF_RESET = 8,
	Y2_ASF_RUNNING = 4,
	Y2_ASF_CLR_HSTI = 2,
	Y2_ASF_IRQ = 1,
	Y2_ASF_UC_STATE = 12,
	Y2_ASF_CLK_HALT = 0,
};

enum {
	Y2_B8_PREF_REGS = 1104,
	PREF_UNIT_CTRL = 0,
	PREF_UNIT_LAST_IDX = 4,
	PREF_UNIT_ADDR_LO = 8,
	PREF_UNIT_ADDR_HI = 12,
	PREF_UNIT_GET_IDX = 16,
	PREF_UNIT_PUT_IDX = 20,
	PREF_UNIT_FIFO_WP = 32,
	PREF_UNIT_FIFO_RP = 36,
	PREF_UNIT_FIFO_WM = 40,
	PREF_UNIT_FIFO_LEV = 44,
	PREF_UNIT_MASK_IDX = 4095,
};

enum {
	Y2_CLK_DIV_VAL_MSK = 16711680,
	Y2_CLK_DIV_VAL2_MSK = 14680064,
	Y2_CLK_SELECT2_MSK = 2031616,
	Y2_CLK_DIV_ENA = 2,
	Y2_CLK_DIV_DIS = 1,
};

enum {
	Y2_IS_HW_ERR = -2147483648,
	Y2_IS_STAT_BMU = 1073741824,
	Y2_IS_ASF = 536870912,
	Y2_IS_CPU_TO = 268435456,
	Y2_IS_POLL_CHK = 134217728,
	Y2_IS_TWSI_RDY = 67108864,
	Y2_IS_IRQ_SW = 33554432,
	Y2_IS_TIMINT = 16777216,
	Y2_IS_IRQ_PHY2 = 4096,
	Y2_IS_IRQ_MAC2 = 2048,
	Y2_IS_CHK_RX2 = 1024,
	Y2_IS_CHK_TXS2 = 512,
	Y2_IS_CHK_TXA2 = 256,
	Y2_IS_PSM_ACK = 128,
	Y2_IS_PTP_TIST = 64,
	Y2_IS_PHY_QLNK = 32,
	Y2_IS_IRQ_PHY1 = 16,
	Y2_IS_IRQ_MAC1 = 8,
	Y2_IS_CHK_RX1 = 4,
	Y2_IS_CHK_TXS1 = 2,
	Y2_IS_CHK_TXA1 = 1,
	Y2_IS_BASE = -1073741824,
	Y2_IS_PORT_1 = 29,
	Y2_IS_PORT_2 = 7424,
	Y2_IS_ERROR = -2147480307,
};

enum {
	Y2_IS_TIST_OV = 536870912,
	Y2_IS_SENSOR = 268435456,
	Y2_IS_MST_ERR = 134217728,
	Y2_IS_IRQ_STAT = 67108864,
	Y2_IS_PCI_EXP = 33554432,
	Y2_IS_PCI_NEXP = 16777216,
	Y2_IS_PAR_RD2 = 8192,
	Y2_IS_PAR_WR2 = 4096,
	Y2_IS_PAR_MAC2 = 2048,
	Y2_IS_PAR_RX2 = 1024,
	Y2_IS_TCP_TXS2 = 512,
	Y2_IS_TCP_TXA2 = 256,
	Y2_IS_PAR_RD1 = 32,
	Y2_IS_PAR_WR1 = 16,
	Y2_IS_PAR_MAC1 = 8,
	Y2_IS_PAR_RX1 = 4,
	Y2_IS_TCP_TXS1 = 2,
	Y2_IS_TCP_TXA1 = 1,
	Y2_HWE_L1_MASK = 63,
	Y2_HWE_L2_MASK = 16128,
	Y2_HWE_ALL_MASK = 738213695,
};

enum {
	Y2_STATUS_LNK2_INAC = 128,
	Y2_CLK_GAT_LNK2_DIS = 64,
	Y2_COR_CLK_LNK2_DIS = 32,
	Y2_PCI_CLK_LNK2_DIS = 16,
	Y2_STATUS_LNK1_INAC = 8,
	Y2_CLK_GAT_LNK1_DIS = 4,
	Y2_COR_CLK_LNK1_DIS = 2,
	Y2_PCI_CLK_LNK1_DIS = 1,
};

enum {
	Y2_VMAIN_AVAIL = 131072,
	Y2_VAUX_AVAIL = 65536,
	Y2_HW_WOL_ON = 32768,
	Y2_HW_WOL_OFF = 16384,
	Y2_ASF_ENABLE = 8192,
	Y2_ASF_DISABLE = 4096,
	Y2_CLK_RUN_ENA = 2048,
	Y2_CLK_RUN_DIS = 1024,
	Y2_LED_STAT_ON = 512,
	Y2_LED_STAT_OFF = 256,
	CS_ST_SW_IRQ = 128,
	CS_CL_SW_IRQ = 64,
	CS_STOP_DONE = 32,
	CS_STOP_MAST = 16,
	CS_MRST_CLR = 8,
	CS_MRST_SET = 4,
	CS_RST_CLR = 2,
	CS_RST_SET = 1,
};

enum {
	ZONELIST_FALLBACK = 0,
	MAX_ZONELISTS = 1,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 0,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2080527,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_PICK_BUDDY = 6,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 7,
	__SCHED_FEAT_DELAY_DEQUEUE = 8,
	__SCHED_FEAT_DELAY_ZERO = 9,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 10,
	__SCHED_FEAT_HRTICK = 11,
	__SCHED_FEAT_HRTICK_DL = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_KPROBE = 15,
	__ctx_convertBPF_PROG_TYPE_TRACEPOINT = 16,
	__ctx_convertBPF_PROG_TYPE_PERF_EVENT = 17,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT = 18,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 19,
	__ctx_convertBPF_PROG_TYPE_TRACING = 20,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 21,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 22,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 23,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 24,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 25,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 26,
	__ctx_convertBPF_PROG_TYPE_EXT = 27,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 28,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 29,
	__ctx_convert_unused = 30,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	dns_key_data = 0,
	dns_key_error = 1,
};

enum {
	e1000_10_half = 0,
	e1000_10_full = 1,
	e1000_100_half = 2,
	e1000_100_full = 3,
};

enum {
	e1000_igp_cable_length_10 = 10,
	e1000_igp_cable_length_20 = 20,
	e1000_igp_cable_length_30 = 30,
	e1000_igp_cable_length_40 = 40,
	e1000_igp_cable_length_50 = 50,
	e1000_igp_cable_length_60 = 60,
	e1000_igp_cable_length_70 = 70,
	e1000_igp_cable_length_80 = 80,
	e1000_igp_cable_length_90 = 90,
	e1000_igp_cable_length_100 = 100,
	e1000_igp_cable_length_110 = 110,
	e1000_igp_cable_length_115 = 115,
	e1000_igp_cable_length_120 = 120,
	e1000_igp_cable_length_130 = 130,
	e1000_igp_cable_length_140 = 140,
	e1000_igp_cable_length_150 = 150,
	e1000_igp_cable_length_160 = 160,
	e1000_igp_cable_length_170 = 170,
	e1000_igp_cable_length_180 = 180,
};

enum {
	false = 0,
	true = 1,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	sysctl_hung_task_timeout_secs = 0,
};

enum {
	vfio_noiommu = 0,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_literals_headerWrong = 24,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_combination_unsupported = 41,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_cannotProduce_uncompressedBlock = 49,
	ZSTD_error_stabilityCondition_notRespected = 50,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_noForwardProgress_destFull = 80,
	ZSTD_error_noForwardProgress_inputEmpty = 82,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_sequenceProducer_failed = 106,
	ZSTD_error_externalSequences_invalid = 107,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} SymbolEncodingType_e;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_FrameType_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
	ZSTD_d_experimentalParam5 = 1004,
	ZSTD_d_experimentalParam6 = 1005,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	e1000_1000t_rx_status_not_ok = 0,
	e1000_1000t_rx_status_ok = 1,
	e1000_1000t_rx_status_undefined = 255,
} e1000_1000t_rx_status;

typedef enum {
	e1000_10bt_ext_dist_enable_normal = 0,
	e1000_10bt_ext_dist_enable_lower = 1,
	e1000_10bt_ext_dist_enable_undefined = 255,
} e1000_10bt_ext_dist_enable;

typedef enum {
	e1000_auto_x_mode_manual_mdi = 0,
	e1000_auto_x_mode_manual_mdix = 1,
	e1000_auto_x_mode_auto1 = 2,
	e1000_auto_x_mode_auto2 = 3,
	e1000_auto_x_mode_undefined = 255,
} e1000_auto_x_mode;

typedef enum {
	e1000_bus_speed_unknown = 0,
	e1000_bus_speed_33 = 1,
	e1000_bus_speed_66 = 2,
	e1000_bus_speed_100 = 3,
	e1000_bus_speed_120 = 4,
	e1000_bus_speed_133 = 5,
	e1000_bus_speed_reserved = 6,
} e1000_bus_speed;

typedef enum {
	e1000_bus_type_unknown = 0,
	e1000_bus_type_pci = 1,
	e1000_bus_type_pcix = 2,
	e1000_bus_type_reserved = 3,
} e1000_bus_type;

typedef enum {
	e1000_bus_width_unknown = 0,
	e1000_bus_width_32 = 1,
	e1000_bus_width_64 = 2,
	e1000_bus_width_reserved = 3,
} e1000_bus_width;

typedef enum {
	e1000_cable_length_50 = 0,
	e1000_cable_length_50_80 = 1,
	e1000_cable_length_80_110 = 2,
	e1000_cable_length_110_140 = 3,
	e1000_cable_length_140 = 4,
	e1000_cable_length_undefined = 255,
} e1000_cable_length;

typedef enum {
	e1000_downshift_normal = 0,
	e1000_downshift_activated = 1,
	e1000_downshift_undefined = 255,
} e1000_downshift;

typedef enum {
	e1000_dsp_config_disabled = 0,
	e1000_dsp_config_enabled = 1,
	e1000_dsp_config_activated = 2,
	e1000_dsp_config_undefined = 255,
} e1000_dsp_config;

typedef enum {
	e1000_eeprom_uninitialized = 0,
	e1000_eeprom_spi = 1,
	e1000_eeprom_microwire = 2,
	e1000_eeprom_flash = 3,
	e1000_eeprom_none = 4,
	e1000_num_eeprom_types = 5,
} e1000_eeprom_type;

typedef enum {
	E1000_FC_NONE = 0,
	E1000_FC_RX_PAUSE = 1,
	E1000_FC_TX_PAUSE = 2,
	E1000_FC_FULL = 3,
	E1000_FC_DEFAULT = 255,
} e1000_fc_type;

typedef enum {
	e1000_ffe_config_enabled = 0,
	e1000_ffe_config_active = 1,
	e1000_ffe_config_blocked = 2,
} e1000_ffe_config;

typedef enum {
	e1000_undefined = 0,
	e1000_82542_rev2_0 = 1,
	e1000_82542_rev2_1 = 2,
	e1000_82543 = 3,
	e1000_82544 = 4,
	e1000_82540 = 5,
	e1000_82545 = 6,
	e1000_82545_rev_3 = 7,
	e1000_82546 = 8,
	e1000_ce4100 = 9,
	e1000_82546_rev_3 = 10,
	e1000_82541 = 11,
	e1000_82541_rev_2 = 12,
	e1000_82547 = 13,
	e1000_82547_rev_2 = 14,
	e1000_num_macs = 15,
} e1000_mac_type;

typedef enum {
	e1000_media_type_copper = 0,
	e1000_media_type_fiber = 1,
	e1000_media_type_internal_serdes = 2,
	e1000_num_media_types = 3,
} e1000_media_type;

typedef enum {
	e1000_ms_hw_default = 0,
	e1000_ms_force_master = 1,
	e1000_ms_force_slave = 2,
	e1000_ms_auto = 3,
} e1000_ms_type;

typedef enum {
	e1000_phy_m88 = 0,
	e1000_phy_igp = 1,
	e1000_phy_8211 = 2,
	e1000_phy_8201 = 3,
	e1000_phy_undefined = 255,
} e1000_phy_type;

typedef enum {
	e1000_polarity_reversal_enabled = 0,
	e1000_polarity_reversal_disabled = 1,
	e1000_polarity_reversal_undefined = 255,
} e1000_polarity_reversal;

typedef enum {
	e1000_rev_polarity_normal = 0,
	e1000_rev_polarity_reversed = 1,
	e1000_rev_polarity_undefined = 255,
} e1000_rev_polarity;

typedef enum {
	e1000_smart_speed_default = 0,
	e1000_smart_speed_on = 1,
	e1000_smart_speed_off = 2,
} e1000_smart_speed;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FL_READY = 0,
	FL_STATUS = 1,
	FL_CFI_QUERY = 2,
	FL_JEDEC_QUERY = 3,
	FL_ERASING = 4,
	FL_ERASE_SUSPENDING = 5,
	FL_ERASE_SUSPENDED = 6,
	FL_WRITING = 7,
	FL_WRITING_TO_BUFFER = 8,
	FL_OTP_WRITE = 9,
	FL_WRITE_SUSPENDING = 10,
	FL_WRITE_SUSPENDED = 11,
	FL_PM_SUSPENDED = 12,
	FL_SYNCING = 13,
	FL_UNLOADING = 14,
	FL_LOCKING = 15,
	FL_UNLOCKING = 16,
	FL_POINT = 17,
	FL_XIP_WHILE_ERASING = 18,
	FL_XIP_WHILE_WRITING = 19,
	FL_SHUTDOWN = 20,
	FL_READING = 21,
	FL_CACHEDPRG = 22,
	FL_RESETTING = 23,
	FL_OTPING = 24,
	FL_PREPARING_ERASE = 25,
	FL_VERIFYING_ERASE = 26,
	FL_UNKNOWN = 27,
} flstate_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_MAX = 34,
} phy_interface_t;

typedef enum {
	PSMOUSE_BAD_DATA = 0,
	PSMOUSE_GOOD_DATA = 1,
	PSMOUSE_FULL_PACKET = 2,
} psmouse_ret_t;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef ZSTD_ErrorCode zstd_error_code;

enum CMD_RET_VALUES {
	REFIRE_CMD = 1,
	COMPLETE_CMD = 2,
	RETURN_CMD = 3,
};

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum DCMD_RETURN_STATUS {
	DCMD_SUCCESS = 0,
	DCMD_TIMEOUT = 1,
	DCMD_FAILED = 2,
	DCMD_BUSY = 3,
	DCMD_INIT = 255,
};

enum DCMD_TIMEOUT_ACTION {
	INITIATE_OCR = 0,
	KILL_ADAPTER = 1,
	IGNORE_TIMEOUT = 2,
};

enum E1000_INVM_STRUCTURE_TYPE {
	E1000_INVM_UNINITIALIZED_STRUCTURE = 0,
	E1000_INVM_WORD_AUTOLOAD_STRUCTURE = 1,
	E1000_INVM_CSR_AUTOLOAD_STRUCTURE = 2,
	E1000_INVM_PHY_REGISTER_AUTOLOAD_STRUCTURE = 3,
	E1000_INVM_RSA_KEY_SHA256_STRUCTURE = 4,
	E1000_INVM_INVALIDATED_STRUCTURE = 15,
};

enum FW_BOOT_CONTEXT {
	PROBE_CONTEXT = 0,
	OCR_CONTEXT = 1,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum MAX77686_RTC_OP {
	MAX77686_RTC_WRITE = 0,
	MAX77686_RTC_READ = 1,
};

enum MEGASAS_LD_TARGET_ID_STATUS {
	LD_TARGET_ID_INITIAL = 0,
	LD_TARGET_ID_ACTIVE = 1,
	LD_TARGET_ID_DELETED = 2,
};

enum MEGASAS_OCR_CAUSE {
	FW_FAULT_OCR = 0,
	SCSIIO_TIMEOUT_OCR = 1,
	MFI_IO_TIMEOUT_OCR = 2,
};

enum MFI_CMD_OP {
	MFI_CMD_INIT = 0,
	MFI_CMD_LD_READ = 1,
	MFI_CMD_LD_WRITE = 2,
	MFI_CMD_LD_SCSI_IO = 3,
	MFI_CMD_PD_SCSI_IO = 4,
	MFI_CMD_DCMD = 5,
	MFI_CMD_ABORT = 6,
	MFI_CMD_SMP = 7,
	MFI_CMD_STP = 8,
	MFI_CMD_NVME = 9,
	MFI_CMD_TOOLBOX = 10,
	MFI_CMD_OP_COUNT = 11,
	MFI_CMD_INVALID = 255,
};

enum MFI_STAT {
	MFI_STAT_OK = 0,
	MFI_STAT_INVALID_CMD = 1,
	MFI_STAT_INVALID_DCMD = 2,
	MFI_STAT_INVALID_PARAMETER = 3,
	MFI_STAT_INVALID_SEQUENCE_NUMBER = 4,
	MFI_STAT_ABORT_NOT_POSSIBLE = 5,
	MFI_STAT_APP_HOST_CODE_NOT_FOUND = 6,
	MFI_STAT_APP_IN_USE = 7,
	MFI_STAT_APP_NOT_INITIALIZED = 8,
	MFI_STAT_ARRAY_INDEX_INVALID = 9,
	MFI_STAT_ARRAY_ROW_NOT_EMPTY = 10,
	MFI_STAT_CONFIG_RESOURCE_CONFLICT = 11,
	MFI_STAT_DEVICE_NOT_FOUND = 12,
	MFI_STAT_DRIVE_TOO_SMALL = 13,
	MFI_STAT_FLASH_ALLOC_FAIL = 14,
	MFI_STAT_FLASH_BUSY = 15,
	MFI_STAT_FLASH_ERROR = 16,
	MFI_STAT_FLASH_IMAGE_BAD = 17,
	MFI_STAT_FLASH_IMAGE_INCOMPLETE = 18,
	MFI_STAT_FLASH_NOT_OPEN = 19,
	MFI_STAT_FLASH_NOT_STARTED = 20,
	MFI_STAT_FLUSH_FAILED = 21,
	MFI_STAT_HOST_CODE_NOT_FOUNT = 22,
	MFI_STAT_LD_CC_IN_PROGRESS = 23,
	MFI_STAT_LD_INIT_IN_PROGRESS = 24,
	MFI_STAT_LD_LBA_OUT_OF_RANGE = 25,
	MFI_STAT_LD_MAX_CONFIGURED = 26,
	MFI_STAT_LD_NOT_OPTIMAL = 27,
	MFI_STAT_LD_RBLD_IN_PROGRESS = 28,
	MFI_STAT_LD_RECON_IN_PROGRESS = 29,
	MFI_STAT_LD_WRONG_RAID_LEVEL = 30,
	MFI_STAT_MAX_SPARES_EXCEEDED = 31,
	MFI_STAT_MEMORY_NOT_AVAILABLE = 32,
	MFI_STAT_MFC_HW_ERROR = 33,
	MFI_STAT_NO_HW_PRESENT = 34,
	MFI_STAT_NOT_FOUND = 35,
	MFI_STAT_NOT_IN_ENCL = 36,
	MFI_STAT_PD_CLEAR_IN_PROGRESS = 37,
	MFI_STAT_PD_TYPE_WRONG = 38,
	MFI_STAT_PR_DISABLED = 39,
	MFI_STAT_ROW_INDEX_INVALID = 40,
	MFI_STAT_SAS_CONFIG_INVALID_ACTION = 41,
	MFI_STAT_SAS_CONFIG_INVALID_DATA = 42,
	MFI_STAT_SAS_CONFIG_INVALID_PAGE = 43,
	MFI_STAT_SAS_CONFIG_INVALID_TYPE = 44,
	MFI_STAT_SCSI_DONE_WITH_ERROR = 45,
	MFI_STAT_SCSI_IO_FAILED = 46,
	MFI_STAT_SCSI_RESERVATION_CONFLICT = 47,
	MFI_STAT_SHUTDOWN_FAILED = 48,
	MFI_STAT_TIME_NOT_SET = 49,
	MFI_STAT_WRONG_STATE = 50,
	MFI_STAT_LD_OFFLINE = 51,
	MFI_STAT_PEER_NOTIFICATION_REJECTED = 52,
	MFI_STAT_PEER_NOTIFICATION_FAILED = 53,
	MFI_STAT_RESERVATION_IN_PROGRESS = 54,
	MFI_STAT_I2C_ERRORS_DETECTED = 55,
	MFI_STAT_PCI_ERRORS_DETECTED = 56,
	MFI_STAT_CONFIG_SEQ_MISMATCH = 103,
	MFI_STAT_INVALID_STATUS = 255,
};

enum MIPS16e_i64_func {
	MIPS16e_ldsp_func = 0,
	MIPS16e_sdsp_func = 1,
	MIPS16e_sdrasp_func = 2,
	MIPS16e_dadjsp_func = 3,
	MIPS16e_ldpc_func = 4,
};

enum MIPS16e_ops {
	MIPS16e_jal_op = 3,
	MIPS16e_ld_op = 7,
	MIPS16e_i8_op = 12,
	MIPS16e_sd_op = 15,
	MIPS16e_lb_op = 16,
	MIPS16e_lh_op = 17,
	MIPS16e_lwsp_op = 18,
	MIPS16e_lw_op = 19,
	MIPS16e_lbu_op = 20,
	MIPS16e_lhu_op = 21,
	MIPS16e_lwpc_op = 22,
	MIPS16e_lwu_op = 23,
	MIPS16e_sb_op = 24,
	MIPS16e_sh_op = 25,
	MIPS16e_swsp_op = 26,
	MIPS16e_sw_op = 27,
	MIPS16e_rr_op = 29,
	MIPS16e_extend_op = 30,
	MIPS16e_i64_op = 31,
};

enum MIPS16e_rr_func {
	MIPS16e_jr_func = 0,
};

enum MIPS6e_i8_func {
	MIPS16e_swrasp_func = 2,
};

enum MR_ADAPTER_TYPE {
	MFI_SERIES = 1,
	THUNDERBOLT_SERIES = 2,
	INVADER_SERIES = 3,
	VENTURA_SERIES = 4,
	AERO_SERIES = 5,
};

enum MR_EVT_CLASS {
	MR_EVT_CLASS_DEBUG = -2,
	MR_EVT_CLASS_PROGRESS = -1,
	MR_EVT_CLASS_INFO = 0,
	MR_EVT_CLASS_WARNING = 1,
	MR_EVT_CLASS_CRITICAL = 2,
	MR_EVT_CLASS_FATAL = 3,
	MR_EVT_CLASS_DEAD = 4,
};

enum MR_EVT_LOCALE {
	MR_EVT_LOCALE_LD = 1,
	MR_EVT_LOCALE_PD = 2,
	MR_EVT_LOCALE_ENCL = 4,
	MR_EVT_LOCALE_BBU = 8,
	MR_EVT_LOCALE_SAS = 16,
	MR_EVT_LOCALE_CTRL = 32,
	MR_EVT_LOCALE_CONFIG = 64,
	MR_EVT_LOCALE_CLUSTER = 128,
	MR_EVT_LOCALE_ALL = 65535,
};

enum MR_FW_CRASH_DUMP_STATE {
	UNAVAILABLE = 0,
	AVAILABLE = 1,
	COPYING = 2,
	COPIED = 3,
	COPY_ERROR = 4,
};

enum MR_LD_QUERY_TYPE {
	MR_LD_QUERY_TYPE_ALL = 0,
	MR_LD_QUERY_TYPE_EXPOSED_TO_HOST = 1,
	MR_LD_QUERY_TYPE_USED_TGT_IDS = 2,
	MR_LD_QUERY_TYPE_CLUSTER_ACCESS = 3,
	MR_LD_QUERY_TYPE_CLUSTER_LOCALE = 4,
};

enum MR_PD_QUERY_TYPE {
	MR_PD_QUERY_TYPE_ALL = 0,
	MR_PD_QUERY_TYPE_STATE = 1,
	MR_PD_QUERY_TYPE_POWER_STATE = 2,
	MR_PD_QUERY_TYPE_MEDIA_TYPE = 3,
	MR_PD_QUERY_TYPE_SPEED = 4,
	MR_PD_QUERY_TYPE_EXPOSED_TO_HOST = 5,
};

enum MR_PD_STATE {
	MR_PD_STATE_UNCONFIGURED_GOOD = 0,
	MR_PD_STATE_UNCONFIGURED_BAD = 1,
	MR_PD_STATE_HOT_SPARE = 2,
	MR_PD_STATE_OFFLINE = 16,
	MR_PD_STATE_FAILED = 17,
	MR_PD_STATE_REBUILD = 20,
	MR_PD_STATE_ONLINE = 24,
	MR_PD_STATE_COPYBACK = 32,
	MR_PD_STATE_SYSTEM = 64,
};

enum MR_PD_TYPE {
	UNKNOWN_DRIVE = 0,
	PARALLEL_SCSI = 1,
	SAS_PD = 2,
	SATA_PD = 3,
	FC_PD = 4,
	NVME_PD = 5,
};

enum MR_PERF_MODE {
	MR_BALANCED_PERF_MODE = 0,
	MR_IOPS_PERF_MODE = 1,
	MR_LATENCY_PERF_MODE = 2,
};

enum MR_RAID_FLAGS_IO_SUB_TYPE {
	MR_RAID_FLAGS_IO_SUB_TYPE_NONE = 0,
	MR_RAID_FLAGS_IO_SUB_TYPE_SYSTEM_PD = 1,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_DATA = 2,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_P = 3,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_Q = 4,
	MR_RAID_FLAGS_IO_SUB_TYPE_CACHE_BYPASS = 6,
	MR_RAID_FLAGS_IO_SUB_TYPE_LDIO_BW_LIMIT = 7,
	MR_RAID_FLAGS_IO_SUB_TYPE_R56_DIV_OFFLOAD = 8,
};

enum MR_RAID_MAP_DESC_TYPE {
	RAID_MAP_DESC_TYPE_DEVHDL_INFO = 0,
	RAID_MAP_DESC_TYPE_TGTID_INFO = 1,
	RAID_MAP_DESC_TYPE_ARRAY_INFO = 2,
	RAID_MAP_DESC_TYPE_SPAN_INFO = 3,
	RAID_MAP_DESC_TYPE_COUNT = 4,
};

enum MR_SCSI_CMD_TYPE {
	READ_WRITE_LDIO = 0,
	NON_READ_WRITE_LDIO = 1,
	READ_WRITE_SYSPDIO = 2,
	NON_READ_WRITE_SYSPDIO = 3,
};

enum MT6323_IRQ_STATUS_numbers {
	MT6323_IRQ_STATUS_SPKL_AB = 0,
	MT6323_IRQ_STATUS_SPKL = 1,
	MT6323_IRQ_STATUS_BAT_L = 2,
	MT6323_IRQ_STATUS_BAT_H = 3,
	MT6323_IRQ_STATUS_WATCHDOG = 4,
	MT6323_IRQ_STATUS_PWRKEY = 5,
	MT6323_IRQ_STATUS_THR_L = 6,
	MT6323_IRQ_STATUS_THR_H = 7,
	MT6323_IRQ_STATUS_VBATON_UNDET = 8,
	MT6323_IRQ_STATUS_BVALID_DET = 9,
	MT6323_IRQ_STATUS_CHRDET = 10,
	MT6323_IRQ_STATUS_OV = 11,
	MT6323_IRQ_STATUS_LDO = 16,
	MT6323_IRQ_STATUS_FCHRKEY = 17,
	MT6323_IRQ_STATUS_ACCDET = 18,
	MT6323_IRQ_STATUS_AUDIO = 19,
	MT6323_IRQ_STATUS_RTC = 20,
	MT6323_IRQ_STATUS_VPROC = 21,
	MT6323_IRQ_STATUS_VSYS = 22,
	MT6323_IRQ_STATUS_VPA = 23,
	MT6323_IRQ_STATUS_NR = 24,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum Opt_errors {
	Opt_errors_continue = 0,
	Opt_errors_panic = 1,
};

enum REGION_TYPE {
	REGION_TYPE_UNUSED = 0,
	REGION_TYPE_SHARED_READ = 1,
	REGION_TYPE_SHARED_WRITE = 2,
	REGION_TYPE_EXCLUSIVE = 3,
};

enum S2MPU02_reg {
	S2MPU02_REG_ID = 0,
	S2MPU02_REG_INT1 = 1,
	S2MPU02_REG_INT2 = 2,
	S2MPU02_REG_INT3 = 3,
	S2MPU02_REG_INT1M = 4,
	S2MPU02_REG_INT2M = 5,
	S2MPU02_REG_INT3M = 6,
	S2MPU02_REG_ST1 = 7,
	S2MPU02_REG_ST2 = 8,
	S2MPU02_REG_PWRONSRC = 9,
	S2MPU02_REG_OFFSRC = 10,
	S2MPU02_REG_BU_CHG = 11,
	S2MPU02_REG_RTCCTRL = 12,
	S2MPU02_REG_PMCTRL1 = 13,
	S2MPU02_REG_RSVD1 = 14,
	S2MPU02_REG_RSVD2 = 15,
	S2MPU02_REG_RSVD3 = 16,
	S2MPU02_REG_RSVD4 = 17,
	S2MPU02_REG_RSVD5 = 18,
	S2MPU02_REG_RSVD6 = 19,
	S2MPU02_REG_RSVD7 = 20,
	S2MPU02_REG_WRSTEN = 21,
	S2MPU02_REG_RSVD8 = 22,
	S2MPU02_REG_RSVD9 = 23,
	S2MPU02_REG_RSVD10 = 24,
	S2MPU02_REG_B1CTRL1 = 25,
	S2MPU02_REG_B1CTRL2 = 26,
	S2MPU02_REG_B2CTRL1 = 27,
	S2MPU02_REG_B2CTRL2 = 28,
	S2MPU02_REG_B3CTRL1 = 29,
	S2MPU02_REG_B3CTRL2 = 30,
	S2MPU02_REG_B4CTRL1 = 31,
	S2MPU02_REG_B4CTRL2 = 32,
	S2MPU02_REG_B5CTRL1 = 33,
	S2MPU02_REG_B5CTRL2 = 34,
	S2MPU02_REG_B5CTRL3 = 35,
	S2MPU02_REG_B5CTRL4 = 36,
	S2MPU02_REG_B5CTRL5 = 37,
	S2MPU02_REG_B6CTRL1 = 38,
	S2MPU02_REG_B6CTRL2 = 39,
	S2MPU02_REG_B7CTRL1 = 40,
	S2MPU02_REG_B7CTRL2 = 41,
	S2MPU02_REG_RAMP1 = 42,
	S2MPU02_REG_RAMP2 = 43,
	S2MPU02_REG_L1CTRL = 44,
	S2MPU02_REG_L2CTRL1 = 45,
	S2MPU02_REG_L2CTRL2 = 46,
	S2MPU02_REG_L2CTRL3 = 47,
	S2MPU02_REG_L2CTRL4 = 48,
	S2MPU02_REG_L3CTRL = 49,
	S2MPU02_REG_L4CTRL = 50,
	S2MPU02_REG_L5CTRL = 51,
	S2MPU02_REG_L6CTRL = 52,
	S2MPU02_REG_L7CTRL = 53,
	S2MPU02_REG_L8CTRL = 54,
	S2MPU02_REG_L9CTRL = 55,
	S2MPU02_REG_L10CTRL = 56,
	S2MPU02_REG_L11CTRL = 57,
	S2MPU02_REG_L12CTRL = 58,
	S2MPU02_REG_L13CTRL = 59,
	S2MPU02_REG_L14CTRL = 60,
	S2MPU02_REG_L15CTRL = 61,
	S2MPU02_REG_L16CTRL = 62,
	S2MPU02_REG_L17CTRL = 63,
	S2MPU02_REG_L18CTRL = 64,
	S2MPU02_REG_L19CTRL = 65,
	S2MPU02_REG_L20CTRL = 66,
	S2MPU02_REG_L21CTRL = 67,
	S2MPU02_REG_L22CTRL = 68,
	S2MPU02_REG_L23CTRL = 69,
	S2MPU02_REG_L24CTRL = 70,
	S2MPU02_REG_L25CTRL = 71,
	S2MPU02_REG_L26CTRL = 72,
	S2MPU02_REG_L27CTRL = 73,
	S2MPU02_REG_L28CTRL = 74,
	S2MPU02_REG_LDODSCH1 = 75,
	S2MPU02_REG_LDODSCH2 = 76,
	S2MPU02_REG_LDODSCH3 = 77,
	S2MPU02_REG_LDODSCH4 = 78,
	S2MPU02_REG_SELMIF = 79,
	S2MPU02_REG_RSVD11 = 80,
	S2MPU02_REG_RSVD12 = 81,
	S2MPU02_REG_RSVD13 = 82,
	S2MPU02_REG_DVSSEL = 83,
	S2MPU02_REG_DVSPTR = 84,
	S2MPU02_REG_DVSDATA = 85,
};

enum S2MPU02_regulators {
	S2MPU02_LDO1 = 0,
	S2MPU02_LDO2 = 1,
	S2MPU02_LDO3 = 2,
	S2MPU02_LDO4 = 3,
	S2MPU02_LDO5 = 4,
	S2MPU02_LDO6 = 5,
	S2MPU02_LDO7 = 6,
	S2MPU02_LDO8 = 7,
	S2MPU02_LDO9 = 8,
	S2MPU02_LDO10 = 9,
	S2MPU02_LDO11 = 10,
	S2MPU02_LDO12 = 11,
	S2MPU02_LDO13 = 12,
	S2MPU02_LDO14 = 13,
	S2MPU02_LDO15 = 14,
	S2MPU02_LDO16 = 15,
	S2MPU02_LDO17 = 16,
	S2MPU02_LDO18 = 17,
	S2MPU02_LDO19 = 18,
	S2MPU02_LDO20 = 19,
	S2MPU02_LDO21 = 20,
	S2MPU02_LDO22 = 21,
	S2MPU02_LDO23 = 22,
	S2MPU02_LDO24 = 23,
	S2MPU02_LDO25 = 24,
	S2MPU02_LDO26 = 25,
	S2MPU02_LDO27 = 26,
	S2MPU02_LDO28 = 27,
	S2MPU02_BUCK1 = 28,
	S2MPU02_BUCK2 = 29,
	S2MPU02_BUCK3 = 30,
	S2MPU02_BUCK4 = 31,
	S2MPU02_BUCK5 = 32,
	S2MPU02_BUCK6 = 33,
	S2MPU02_BUCK7 = 34,
	S2MPU02_REGULATOR_MAX = 35,
};

enum S2MPU05_reg {
	S2MPU05_REG_ID = 0,
	S2MPU05_REG_INT1 = 1,
	S2MPU05_REG_INT2 = 2,
	S2MPU05_REG_INT3 = 3,
	S2MPU05_REG_INT1M = 4,
	S2MPU05_REG_INT2M = 5,
	S2MPU05_REG_INT3M = 6,
	S2MPU05_REG_ST1 = 7,
	S2MPU05_REG_ST2 = 8,
	S2MPU05_REG_PWRONSRC = 9,
	S2MPU05_REG_OFFSRC = 10,
	S2MPU05_REG_BU_CHG = 11,
	S2MPU05_REG_RTC_BUF = 12,
	S2MPU05_REG_CTRL1 = 13,
	S2MPU05_REG_CTRL2 = 14,
	S2MPU05_REG_ETC_TEST = 15,
	S2MPU05_REG_OTP_ADRL = 16,
	S2MPU05_REG_OTP_ADRH = 17,
	S2MPU05_REG_OTP_DATA = 18,
	S2MPU05_REG_MON1SEL = 19,
	S2MPU05_REG_MON2SEL = 20,
	S2MPU05_REG_CTRL3 = 21,
	S2MPU05_REG_ETC_OTP = 22,
	S2MPU05_REG_UVLO = 23,
	S2MPU05_REG_TIME_CTRL1 = 24,
	S2MPU05_REG_TIME_CTRL2 = 25,
	S2MPU05_REG_B1CTRL1 = 26,
	S2MPU05_REG_B1CTRL2 = 27,
	S2MPU05_REG_B2CTRL1 = 28,
	S2MPU05_REG_B2CTRL2 = 29,
	S2MPU05_REG_B2CTRL3 = 30,
	S2MPU05_REG_B2CTRL4 = 31,
	S2MPU05_REG_B3CTRL1 = 32,
	S2MPU05_REG_B3CTRL2 = 33,
	S2MPU05_REG_B3CTRL3 = 34,
	S2MPU05_REG_B4CTRL1 = 35,
	S2MPU05_REG_B4CTRL2 = 36,
	S2MPU05_REG_B5CTRL1 = 37,
	S2MPU05_REG_B5CTRL2 = 38,
	S2MPU05_REG_BUCK_RAMP = 39,
	S2MPU05_REG_LDO_DVS1 = 40,
	S2MPU05_REG_LDO_DVS9 = 41,
	S2MPU05_REG_LDO_DVS10 = 42,
	S2MPU05_REG_L1CTRL = 43,
	S2MPU05_REG_L2CTRL = 44,
	S2MPU05_REG_L3CTRL = 45,
	S2MPU05_REG_L4CTRL = 46,
	S2MPU05_REG_L5CTRL = 47,
	S2MPU05_REG_L6CTRL = 48,
	S2MPU05_REG_L7CTRL = 49,
	S2MPU05_REG_L8CTRL = 50,
	S2MPU05_REG_L9CTRL1 = 51,
	S2MPU05_REG_L9CTRL2 = 52,
	S2MPU05_REG_L10CTRL = 53,
	S2MPU05_REG_L11CTRL1 = 54,
	S2MPU05_REG_L11CTRL2 = 55,
	S2MPU05_REG_L12CTRL = 56,
	S2MPU05_REG_L13CTRL = 57,
	S2MPU05_REG_L14CTRL = 58,
	S2MPU05_REG_L15CTRL = 59,
	S2MPU05_REG_L16CTRL = 60,
	S2MPU05_REG_L17CTRL1 = 61,
	S2MPU05_REG_L17CTRL2 = 62,
	S2MPU05_REG_L18CTRL1 = 63,
	S2MPU05_REG_L18CTRL2 = 64,
	S2MPU05_REG_L19CTRL = 65,
	S2MPU05_REG_L20CTRL = 66,
	S2MPU05_REG_L21CTRL = 67,
	S2MPU05_REG_L22CTRL = 68,
	S2MPU05_REG_L23CTRL = 69,
	S2MPU05_REG_L24CTRL = 70,
	S2MPU05_REG_L25CTRL = 71,
	S2MPU05_REG_L26CTRL = 72,
	S2MPU05_REG_L27CTRL = 73,
	S2MPU05_REG_L28CTRL = 74,
	S2MPU05_REG_L29CTRL = 75,
	S2MPU05_REG_L30CTRL = 76,
	S2MPU05_REG_L31CTRL = 77,
	S2MPU05_REG_L32CTRL = 78,
	S2MPU05_REG_L33CTRL = 79,
	S2MPU05_REG_L34CTRL = 80,
	S2MPU05_REG_L35CTRL = 81,
	S2MPU05_REG_LDO_DSCH1 = 82,
	S2MPU05_REG_LDO_DSCH2 = 83,
	S2MPU05_REG_LDO_DSCH3 = 84,
	S2MPU05_REG_LDO_DSCH4 = 85,
	S2MPU05_REG_LDO_DSCH5 = 86,
	S2MPU05_REG_LDO_CTRL1 = 87,
	S2MPU05_REG_LDO_CTRL2 = 88,
	S2MPU05_REG_TCXO_CTRL = 89,
	S2MPU05_REG_SELMIF = 90,
};

enum S2MPU05_regulators {
	S2MPU05_LDO1 = 0,
	S2MPU05_LDO2 = 1,
	S2MPU05_LDO3 = 2,
	S2MPU05_LDO4 = 3,
	S2MPU05_LDO5 = 4,
	S2MPU05_LDO6 = 5,
	S2MPU05_LDO7 = 6,
	S2MPU05_LDO8 = 7,
	S2MPU05_LDO9 = 8,
	S2MPU05_LDO10 = 9,
	S2MPU05_LDO11 = 10,
	S2MPU05_LDO12 = 11,
	S2MPU05_LDO13 = 12,
	S2MPU05_LDO14 = 13,
	S2MPU05_LDO15 = 14,
	S2MPU05_LDO16 = 15,
	S2MPU05_LDO17 = 16,
	S2MPU05_LDO18 = 17,
	S2MPU05_LDO19 = 18,
	S2MPU05_LDO20 = 19,
	S2MPU05_LDO21 = 20,
	S2MPU05_LDO22 = 21,
	S2MPU05_LDO23 = 22,
	S2MPU05_LDO24 = 23,
	S2MPU05_LDO25 = 24,
	S2MPU05_LDO26 = 25,
	S2MPU05_LDO27 = 26,
	S2MPU05_LDO28 = 27,
	S2MPU05_LDO29 = 28,
	S2MPU05_LDO30 = 29,
	S2MPU05_LDO31 = 30,
	S2MPU05_LDO32 = 31,
	S2MPU05_LDO33 = 32,
	S2MPU05_LDO34 = 33,
	S2MPU05_LDO35 = 34,
	S2MPU05_BUCK1 = 35,
	S2MPU05_BUCK2 = 36,
	S2MPU05_BUCK3 = 37,
	S2MPU05_BUCK4 = 38,
	S2MPU05_BUCK5 = 39,
	S2MPU05_REGULATOR_MAX = 40,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum SS4_PACKET_ID {
	SS4_PACKET_ID_IDLE = 0,
	SS4_PACKET_ID_ONE = 1,
	SS4_PACKET_ID_TWO = 2,
	SS4_PACKET_ID_MULTI = 3,
	SS4_PACKET_ID_STICK = 4,
};

enum TPM_OPS_FLAGS {
	TPM_OPS_AUTO_STARTUP = 1,
};

enum UART_TX_FLAGS {
	UART_TX_NOSTOP = 1,
};

enum V7_PACKET_ID {
	V7_PACKET_ID_IDLE = 0,
	V7_PACKET_ID_TWO = 1,
	V7_PACKET_ID_MULTI = 2,
	V7_PACKET_ID_NEW = 3,
	V7_PACKET_ID_UNKNOWN = 4,
};

enum _MR_CRASH_BUF_STATUS {
	MR_CRASH_BUF_TURN_OFF = 0,
	MR_CRASH_BUF_TURN_ON = 1,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_RECLAIM_ACCOUNT = 15,
	_SLAB_OBJECT_POISON = 16,
	_SLAB_CMPXCHG_DOUBLE = 17,
	_SLAB_NO_OBJ_EXT = 18,
	_SLAB_FLAGS_LAST_BIT = 19,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum aqr_fw_src {
	AQR_FW_SRC_NVMEM = 0,
	AQR_FW_SRC_FS = 1,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_quirks {
	__ATA_QUIRK_DIAGNOSTIC = 0,
	__ATA_QUIRK_NODMA = 1,
	__ATA_QUIRK_NONCQ = 2,
	__ATA_QUIRK_MAX_SEC_128 = 3,
	__ATA_QUIRK_BROKEN_HPA = 4,
	__ATA_QUIRK_DISABLE = 5,
	__ATA_QUIRK_HPA_SIZE = 6,
	__ATA_QUIRK_IVB = 7,
	__ATA_QUIRK_STUCK_ERR = 8,
	__ATA_QUIRK_BRIDGE_OK = 9,
	__ATA_QUIRK_ATAPI_MOD16_DMA = 10,
	__ATA_QUIRK_FIRMWARE_WARN = 11,
	__ATA_QUIRK_1_5_GBPS = 12,
	__ATA_QUIRK_NOSETXFER = 13,
	__ATA_QUIRK_BROKEN_FPDMA_AA = 14,
	__ATA_QUIRK_DUMP_ID = 15,
	__ATA_QUIRK_MAX_SEC_LBA48 = 16,
	__ATA_QUIRK_ATAPI_DMADIR = 17,
	__ATA_QUIRK_NO_NCQ_TRIM = 18,
	__ATA_QUIRK_NOLPM = 19,
	__ATA_QUIRK_WD_BROKEN_LPM = 20,
	__ATA_QUIRK_ZERO_AFTER_TRIM = 21,
	__ATA_QUIRK_NO_DMA_LOG = 22,
	__ATA_QUIRK_NOTRIM = 23,
	__ATA_QUIRK_MAX_SEC_1024 = 24,
	__ATA_QUIRK_MAX_TRIM_128M = 25,
	__ATA_QUIRK_NO_NCQ_ON_ATI = 26,
	__ATA_QUIRK_NO_LPM_ON_ATI = 27,
	__ATA_QUIRK_NO_ID_DEV_LOG = 28,
	__ATA_QUIRK_NO_LOG_DIR = 29,
	__ATA_QUIRK_NO_FUA = 30,
	__ATA_QUIRK_MAX = 31,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum attr_idn {
	QUERY_ATTR_IDN_BOOT_LU_EN = 0,
	QUERY_ATTR_IDN_MAX_HPB_SINGLE_CMD = 1,
	QUERY_ATTR_IDN_POWER_MODE = 2,
	QUERY_ATTR_IDN_ACTIVE_ICC_LVL = 3,
	QUERY_ATTR_IDN_OOO_DATA_EN = 4,
	QUERY_ATTR_IDN_BKOPS_STATUS = 5,
	QUERY_ATTR_IDN_PURGE_STATUS = 6,
	QUERY_ATTR_IDN_MAX_DATA_IN = 7,
	QUERY_ATTR_IDN_MAX_DATA_OUT = 8,
	QUERY_ATTR_IDN_DYN_CAP_NEEDED = 9,
	QUERY_ATTR_IDN_REF_CLK_FREQ = 10,
	QUERY_ATTR_IDN_CONF_DESC_LOCK = 11,
	QUERY_ATTR_IDN_MAX_NUM_OF_RTT = 12,
	QUERY_ATTR_IDN_EE_CONTROL = 13,
	QUERY_ATTR_IDN_EE_STATUS = 14,
	QUERY_ATTR_IDN_SECONDS_PASSED = 15,
	QUERY_ATTR_IDN_CNTX_CONF = 16,
	QUERY_ATTR_IDN_CORR_PRG_BLK_NUM = 17,
	QUERY_ATTR_IDN_RESERVED2 = 18,
	QUERY_ATTR_IDN_RESERVED3 = 19,
	QUERY_ATTR_IDN_FFU_STATUS = 20,
	QUERY_ATTR_IDN_PSA_STATE = 21,
	QUERY_ATTR_IDN_PSA_DATA_SIZE = 22,
	QUERY_ATTR_IDN_REF_CLK_GATING_WAIT_TIME = 23,
	QUERY_ATTR_IDN_CASE_ROUGH_TEMP = 24,
	QUERY_ATTR_IDN_HIGH_TEMP_BOUND = 25,
	QUERY_ATTR_IDN_LOW_TEMP_BOUND = 26,
	QUERY_ATTR_IDN_WB_FLUSH_STATUS = 28,
	QUERY_ATTR_IDN_AVAIL_WB_BUFF_SIZE = 29,
	QUERY_ATTR_IDN_WB_BUFF_LIFE_TIME_EST = 30,
	QUERY_ATTR_IDN_CURR_WB_BUFF_SIZE = 31,
	QUERY_ATTR_IDN_TIMESTAMP = 48,
	QUERY_ATTR_IDN_DEV_LVL_EXCEPTION_ID = 52,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_HINT = 60,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_EN = 61,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_STATUS = 62,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum axp15060_irqs {
	AXP15060_IRQ_DIE_TEMP_HIGH_LV1 = 1,
	AXP15060_IRQ_DIE_TEMP_HIGH_LV2 = 2,
	AXP15060_IRQ_DCDC1_V_LOW = 3,
	AXP15060_IRQ_DCDC2_V_LOW = 4,
	AXP15060_IRQ_DCDC3_V_LOW = 5,
	AXP15060_IRQ_DCDC4_V_LOW = 6,
	AXP15060_IRQ_DCDC5_V_LOW = 7,
	AXP15060_IRQ_DCDC6_V_LOW = 8,
	AXP15060_IRQ_PEK_LONG = 9,
	AXP15060_IRQ_PEK_SHORT = 10,
	AXP15060_IRQ_GPIO1_INPUT = 11,
	AXP15060_IRQ_PEK_FAL_EDGE = 12,
	AXP15060_IRQ_PEK_RIS_EDGE = 13,
	AXP15060_IRQ_GPIO2_INPUT = 14,
};

enum axp192_irqs {
	AXP192_IRQ_ACIN_OVER_V = 1,
	AXP192_IRQ_ACIN_PLUGIN = 2,
	AXP192_IRQ_ACIN_REMOVAL = 3,
	AXP192_IRQ_VBUS_OVER_V = 4,
	AXP192_IRQ_VBUS_PLUGIN = 5,
	AXP192_IRQ_VBUS_REMOVAL = 6,
	AXP192_IRQ_VBUS_V_LOW = 7,
	AXP192_IRQ_BATT_PLUGIN = 8,
	AXP192_IRQ_BATT_REMOVAL = 9,
	AXP192_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP192_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP192_IRQ_CHARG = 12,
	AXP192_IRQ_CHARG_DONE = 13,
	AXP192_IRQ_BATT_TEMP_HIGH = 14,
	AXP192_IRQ_BATT_TEMP_LOW = 15,
	AXP192_IRQ_DIE_TEMP_HIGH = 16,
	AXP192_IRQ_CHARG_I_LOW = 17,
	AXP192_IRQ_DCDC1_V_LONG = 18,
	AXP192_IRQ_DCDC2_V_LONG = 19,
	AXP192_IRQ_DCDC3_V_LONG = 20,
	AXP192_IRQ_PEK_SHORT = 22,
	AXP192_IRQ_PEK_LONG = 23,
	AXP192_IRQ_N_OE_PWR_ON = 24,
	AXP192_IRQ_N_OE_PWR_OFF = 25,
	AXP192_IRQ_VBUS_VALID = 26,
	AXP192_IRQ_VBUS_NOT_VALID = 27,
	AXP192_IRQ_VBUS_SESS_VALID = 28,
	AXP192_IRQ_VBUS_SESS_END = 29,
	AXP192_IRQ_LOW_PWR_LVL = 31,
	AXP192_IRQ_TIMER = 32,
	AXP192_IRQ_GPIO2_INPUT = 37,
	AXP192_IRQ_GPIO1_INPUT = 38,
	AXP192_IRQ_GPIO0_INPUT = 39,
};

enum axp20x_variants {
	AXP152_ID = 0,
	AXP192_ID = 1,
	AXP202_ID = 2,
	AXP209_ID = 3,
	AXP221_ID = 4,
	AXP223_ID = 5,
	AXP288_ID = 6,
	AXP313A_ID = 7,
	AXP323_ID = 8,
	AXP717_ID = 9,
	AXP803_ID = 10,
	AXP806_ID = 11,
	AXP809_ID = 12,
	AXP813_ID = 13,
	AXP15060_ID = 14,
	NR_AXP20X_VARIANTS = 15,
};

enum axp22x_irqs {
	AXP22X_IRQ_ACIN_OVER_V = 1,
	AXP22X_IRQ_ACIN_PLUGIN = 2,
	AXP22X_IRQ_ACIN_REMOVAL = 3,
	AXP22X_IRQ_VBUS_OVER_V = 4,
	AXP22X_IRQ_VBUS_PLUGIN = 5,
	AXP22X_IRQ_VBUS_REMOVAL = 6,
	AXP22X_IRQ_VBUS_V_LOW = 7,
	AXP22X_IRQ_BATT_PLUGIN = 8,
	AXP22X_IRQ_BATT_REMOVAL = 9,
	AXP22X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP22X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP22X_IRQ_CHARG = 12,
	AXP22X_IRQ_CHARG_DONE = 13,
	AXP22X_IRQ_BATT_TEMP_HIGH = 14,
	AXP22X_IRQ_BATT_TEMP_LOW = 15,
	AXP22X_IRQ_DIE_TEMP_HIGH = 16,
	AXP22X_IRQ_PEK_SHORT = 17,
	AXP22X_IRQ_PEK_LONG = 18,
	AXP22X_IRQ_LOW_PWR_LVL1 = 19,
	AXP22X_IRQ_LOW_PWR_LVL2 = 20,
	AXP22X_IRQ_TIMER = 21,
	AXP22X_IRQ_PEK_FAL_EDGE = 22,
	AXP22X_IRQ_PEK_RIS_EDGE = 23,
	AXP22X_IRQ_GPIO1_INPUT = 24,
	AXP22X_IRQ_GPIO0_INPUT = 25,
};

enum axp288_irqs {
	AXP288_IRQ_VBUS_FALL = 2,
	AXP288_IRQ_VBUS_RISE = 3,
	AXP288_IRQ_OV = 4,
	AXP288_IRQ_FALLING_ALT = 5,
	AXP288_IRQ_RISING_ALT = 6,
	AXP288_IRQ_OV_ALT = 7,
	AXP288_IRQ_DONE = 10,
	AXP288_IRQ_CHARGING = 11,
	AXP288_IRQ_SAFE_QUIT = 12,
	AXP288_IRQ_SAFE_ENTER = 13,
	AXP288_IRQ_ABSENT = 14,
	AXP288_IRQ_APPEND = 15,
	AXP288_IRQ_QWBTU = 16,
	AXP288_IRQ_WBTU = 17,
	AXP288_IRQ_QWBTO = 18,
	AXP288_IRQ_WBTO = 19,
	AXP288_IRQ_QCBTU = 20,
	AXP288_IRQ_CBTU = 21,
	AXP288_IRQ_QCBTO = 22,
	AXP288_IRQ_CBTO = 23,
	AXP288_IRQ_WL2 = 24,
	AXP288_IRQ_WL1 = 25,
	AXP288_IRQ_GPADC = 26,
	AXP288_IRQ_OT = 31,
	AXP288_IRQ_GPIO0 = 32,
	AXP288_IRQ_GPIO1 = 33,
	AXP288_IRQ_POKO = 34,
	AXP288_IRQ_POKL = 35,
	AXP288_IRQ_POKS = 36,
	AXP288_IRQ_POKN = 37,
	AXP288_IRQ_POKP = 38,
	AXP288_IRQ_TIMER = 39,
	AXP288_IRQ_MV_CHNG = 40,
	AXP288_IRQ_BC_USB_CHNG = 41,
};

enum axp313a_irqs {
	AXP313A_IRQ_DIE_TEMP_HIGH = 0,
	AXP313A_IRQ_DCDC2_V_LOW = 2,
	AXP313A_IRQ_DCDC3_V_LOW = 3,
	AXP313A_IRQ_PEK_LONG = 4,
	AXP313A_IRQ_PEK_SHORT = 5,
	AXP313A_IRQ_PEK_FAL_EDGE = 6,
	AXP313A_IRQ_PEK_RIS_EDGE = 7,
};

enum axp717_irqs {
	AXP717_IRQ_VBUS_FAULT = 0,
	AXP717_IRQ_VBUS_OVER_V = 1,
	AXP717_IRQ_BOOST_OVER_V = 2,
	AXP717_IRQ_GAUGE_NEW_SOC = 4,
	AXP717_IRQ_SOC_DROP_LVL1 = 6,
	AXP717_IRQ_SOC_DROP_LVL2 = 7,
	AXP717_IRQ_PEK_RIS_EDGE = 8,
	AXP717_IRQ_PEK_FAL_EDGE = 9,
	AXP717_IRQ_PEK_LONG = 10,
	AXP717_IRQ_PEK_SHORT = 11,
	AXP717_IRQ_BATT_REMOVAL = 12,
	AXP717_IRQ_BATT_PLUGIN = 13,
	AXP717_IRQ_VBUS_REMOVAL = 14,
	AXP717_IRQ_VBUS_PLUGIN = 15,
	AXP717_IRQ_BATT_OVER_V = 16,
	AXP717_IRQ_CHARG_TIMER = 17,
	AXP717_IRQ_DIE_TEMP_HIGH = 18,
	AXP717_IRQ_CHARG = 19,
	AXP717_IRQ_CHARG_DONE = 20,
	AXP717_IRQ_BATT_OVER_CURR = 21,
	AXP717_IRQ_LDO_OVER_CURR = 22,
	AXP717_IRQ_WDOG_EXPIRE = 23,
	AXP717_IRQ_BATT_ACT_TEMP_LOW = 24,
	AXP717_IRQ_BATT_ACT_TEMP_HIGH = 25,
	AXP717_IRQ_BATT_CHG_TEMP_LOW = 26,
	AXP717_IRQ_BATT_CHG_TEMP_HIGH = 27,
	AXP717_IRQ_BATT_QUIT_TEMP_HIGH = 28,
	AXP717_IRQ_BC_USB_CHNG = 30,
	AXP717_IRQ_BC_USB_DONE = 31,
	AXP717_IRQ_TYPEC_PLUGIN = 37,
	AXP717_IRQ_TYPEC_REMOVE = 38,
};

enum axp803_irqs {
	AXP803_IRQ_ACIN_OVER_V = 1,
	AXP803_IRQ_ACIN_PLUGIN = 2,
	AXP803_IRQ_ACIN_REMOVAL = 3,
	AXP803_IRQ_VBUS_OVER_V = 4,
	AXP803_IRQ_VBUS_PLUGIN = 5,
	AXP803_IRQ_VBUS_REMOVAL = 6,
	AXP803_IRQ_BATT_PLUGIN = 7,
	AXP803_IRQ_BATT_REMOVAL = 8,
	AXP803_IRQ_BATT_ENT_ACT_MODE = 9,
	AXP803_IRQ_BATT_EXIT_ACT_MODE = 10,
	AXP803_IRQ_CHARG = 11,
	AXP803_IRQ_CHARG_DONE = 12,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH = 13,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH_END = 14,
	AXP803_IRQ_BATT_CHG_TEMP_LOW = 15,
	AXP803_IRQ_BATT_CHG_TEMP_LOW_END = 16,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH = 17,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH_END = 18,
	AXP803_IRQ_BATT_ACT_TEMP_LOW = 19,
	AXP803_IRQ_BATT_ACT_TEMP_LOW_END = 20,
	AXP803_IRQ_DIE_TEMP_HIGH = 21,
	AXP803_IRQ_GPADC = 22,
	AXP803_IRQ_LOW_PWR_LVL1 = 23,
	AXP803_IRQ_LOW_PWR_LVL2 = 24,
	AXP803_IRQ_TIMER = 25,
	AXP803_IRQ_PEK_FAL_EDGE = 26,
	AXP803_IRQ_PEK_RIS_EDGE = 27,
	AXP803_IRQ_PEK_SHORT = 28,
	AXP803_IRQ_PEK_LONG = 29,
	AXP803_IRQ_PEK_OVER_OFF = 30,
	AXP803_IRQ_GPIO1_INPUT = 31,
	AXP803_IRQ_GPIO0_INPUT = 32,
	AXP803_IRQ_BC_USB_CHNG = 33,
	AXP803_IRQ_MV_CHNG = 34,
};

enum axp806_irqs {
	AXP806_IRQ_DIE_TEMP_HIGH_LV1 = 0,
	AXP806_IRQ_DIE_TEMP_HIGH_LV2 = 1,
	AXP806_IRQ_DCDCA_V_LOW = 2,
	AXP806_IRQ_DCDCB_V_LOW = 3,
	AXP806_IRQ_DCDCC_V_LOW = 4,
	AXP806_IRQ_DCDCD_V_LOW = 5,
	AXP806_IRQ_DCDCE_V_LOW = 6,
	AXP806_IRQ_POK_LONG = 7,
	AXP806_IRQ_POK_SHORT = 8,
	AXP806_IRQ_WAKEUP = 9,
	AXP806_IRQ_POK_FALL = 10,
	AXP806_IRQ_POK_RISE = 11,
};

enum axp809_irqs {
	AXP809_IRQ_ACIN_OVER_V = 1,
	AXP809_IRQ_ACIN_PLUGIN = 2,
	AXP809_IRQ_ACIN_REMOVAL = 3,
	AXP809_IRQ_VBUS_OVER_V = 4,
	AXP809_IRQ_VBUS_PLUGIN = 5,
	AXP809_IRQ_VBUS_REMOVAL = 6,
	AXP809_IRQ_VBUS_V_LOW = 7,
	AXP809_IRQ_BATT_PLUGIN = 8,
	AXP809_IRQ_BATT_REMOVAL = 9,
	AXP809_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP809_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP809_IRQ_CHARG = 12,
	AXP809_IRQ_CHARG_DONE = 13,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH = 14,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH_END = 15,
	AXP809_IRQ_BATT_CHG_TEMP_LOW = 16,
	AXP809_IRQ_BATT_CHG_TEMP_LOW_END = 17,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH = 18,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH_END = 19,
	AXP809_IRQ_BATT_ACT_TEMP_LOW = 20,
	AXP809_IRQ_BATT_ACT_TEMP_LOW_END = 21,
	AXP809_IRQ_DIE_TEMP_HIGH = 22,
	AXP809_IRQ_LOW_PWR_LVL1 = 23,
	AXP809_IRQ_LOW_PWR_LVL2 = 24,
	AXP809_IRQ_TIMER = 25,
	AXP809_IRQ_PEK_FAL_EDGE = 26,
	AXP809_IRQ_PEK_RIS_EDGE = 27,
	AXP809_IRQ_PEK_SHORT = 28,
	AXP809_IRQ_PEK_LONG = 29,
	AXP809_IRQ_PEK_OVER_OFF = 30,
	AXP809_IRQ_GPIO1_INPUT = 31,
	AXP809_IRQ_GPIO0_INPUT = 32,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bcop_op {
	bcf_op = 0,
	bct_op = 1,
	bcfl_op = 2,
	bctl_op = 3,
};

enum bd9571mwv_irqs {
	BD9571MWV_IRQ_MD1 = 0,
	BD9571MWV_IRQ_MD2_E1 = 1,
	BD9571MWV_IRQ_MD2_E2 = 2,
	BD9571MWV_IRQ_PROT_ERR = 3,
	BD9571MWV_IRQ_GP = 4,
	BD9571MWV_IRQ_128H_OF = 5,
	BD9571MWV_IRQ_WDT_OF = 6,
	BD9571MWV_IRQ_BKUP_TRG = 7,
};

enum bd9571mwv_regulators {
	VD09 = 0,
	VD18 = 1,
	VD25 = 2,
	VD33 = 3,
	DVFS = 4,
};

enum bdc_ep0_state {
	WAIT_FOR_SETUP = 0,
	WAIT_FOR_DATA_START = 1,
	WAIT_FOR_DATA_XMIT = 2,
	WAIT_FOR_STATUS_START = 3,
	WAIT_FOR_STATUS_XMIT = 4,
	STATUS_PENDING = 5,
};

enum bdc_link_state {
	BDC_LINK_STATE_U0 = 0,
	BDC_LINK_STATE_U3 = 3,
	BDC_LINK_STATE_RX_DET = 5,
	BDC_LINK_STATE_RESUME = 15,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_Migrate = 16,
	BH_PrivateStart = 17,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_DISK_NOCHECK = 4,
	BIP_IP_CHECKSUM = 8,
	BIP_COPY_USER = 16,
	BIP_CHECK_GUARD = 32,
	BIP_CHECK_REFTAG = 64,
	BIP_CHECK_APPTAG = 128,
};

enum bkops_status {
	BKOPS_STATUS_NO_OP = 0,
	BKOPS_STATUS_NON_CRITICAL = 1,
	BKOPS_STATUS_PERF_IMPACT = 2,
	BKOPS_STATUS_CRITICAL = 3,
	BKOPS_STATUS_MAX = 3,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_key_type {
	BLK_CRYPTO_KEY_TYPE_RAW = 1,
	BLK_CRYPTO_KEY_TYPE_HW_WRAPPED = 2,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_yes_fbs_atapi_dma = 9,
	board_ahci_al = 10,
	board_ahci_avn = 11,
	board_ahci_mcp65 = 12,
	board_ahci_mcp77 = 13,
	board_ahci_mcp89 = 14,
	board_ahci_mv = 15,
	board_ahci_sb600 = 16,
	board_ahci_sb700 = 17,
	board_ahci_vt8251 = 18,
	board_ahci_mcp_linux = 12,
	board_ahci_mcp67 = 12,
	board_ahci_mcp73 = 12,
	board_ahci_mcp79 = 13,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum bq27xxx_chip {
	BQ27000 = 1,
	BQ27010 = 2,
	BQ2750X = 3,
	BQ2751X = 4,
	BQ2752X = 5,
	BQ27500 = 6,
	BQ27510G1 = 7,
	BQ27510G2 = 8,
	BQ27510G3 = 9,
	BQ27520G1 = 10,
	BQ27520G2 = 11,
	BQ27520G3 = 12,
	BQ27520G4 = 13,
	BQ27521 = 14,
	BQ27530 = 15,
	BQ27531 = 16,
	BQ27541 = 17,
	BQ27542 = 18,
	BQ27546 = 19,
	BQ27742 = 20,
	BQ27545 = 21,
	BQ27411 = 22,
	BQ27421 = 23,
	BQ27425 = 24,
	BQ27426 = 25,
	BQ27441 = 26,
	BQ27621 = 27,
	BQ27Z561 = 28,
	BQ28Z610 = 29,
	BQ34Z100 = 30,
	BQ78Z100 = 31,
};

enum bq27xxx_dm_reg_id {
	BQ27XXX_DM_DESIGN_CAPACITY = 0,
	BQ27XXX_DM_DESIGN_ENERGY = 1,
	BQ27XXX_DM_TERMINATE_VOLTAGE = 2,
};

enum bq27xxx_reg_index {
	BQ27XXX_REG_CTRL = 0,
	BQ27XXX_REG_TEMP = 1,
	BQ27XXX_REG_INT_TEMP = 2,
	BQ27XXX_REG_VOLT = 3,
	BQ27XXX_REG_AI = 4,
	BQ27XXX_REG_FLAGS = 5,
	BQ27XXX_REG_TTE = 6,
	BQ27XXX_REG_TTF = 7,
	BQ27XXX_REG_TTES = 8,
	BQ27XXX_REG_TTECP = 9,
	BQ27XXX_REG_NAC = 10,
	BQ27XXX_REG_RC = 11,
	BQ27XXX_REG_FCC = 12,
	BQ27XXX_REG_CYCT = 13,
	BQ27XXX_REG_AE = 14,
	BQ27XXX_REG_SOC = 15,
	BQ27XXX_REG_DCAP = 16,
	BQ27XXX_REG_AP = 17,
	BQ27XXX_DM_CTRL = 18,
	BQ27XXX_DM_CLASS = 19,
	BQ27XXX_DM_BLOCK = 20,
	BQ27XXX_DM_DATA = 21,
	BQ27XXX_DM_CKSUM = 22,
	BQ27XXX_REG_SEDVF = 23,
	BQ27XXX_REG_PKCFG = 24,
	BQ27XXX_REG_MAX = 25,
};

enum bshfl_func {
	wsbh_op = 2,
	seb_op = 16,
	seh_op = 24,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
	BPF_RES_SPIN_LOCK = 4096,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum buffer_map_state {
	UN_MAPPED = 0,
	PRE_MAPPED = 1,
	MUSB_MAPPED = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_GUEST_SNP_SECURE_TSC = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
};

enum cea_audio_coding_types {
	AUDIO_CODING_TYPE_REF_STREAM_HEADER = 0,
	AUDIO_CODING_TYPE_LPCM = 1,
	AUDIO_CODING_TYPE_AC3 = 2,
	AUDIO_CODING_TYPE_MPEG1 = 3,
	AUDIO_CODING_TYPE_MP3 = 4,
	AUDIO_CODING_TYPE_MPEG2 = 5,
	AUDIO_CODING_TYPE_AACLC = 6,
	AUDIO_CODING_TYPE_DTS = 7,
	AUDIO_CODING_TYPE_ATRAC = 8,
	AUDIO_CODING_TYPE_SACD = 9,
	AUDIO_CODING_TYPE_EAC3 = 10,
	AUDIO_CODING_TYPE_DTS_HD = 11,
	AUDIO_CODING_TYPE_MLP = 12,
	AUDIO_CODING_TYPE_DST = 13,
	AUDIO_CODING_TYPE_WMAPRO = 14,
	AUDIO_CODING_TYPE_REF_CXT = 15,
	AUDIO_CODING_TYPE_HE_AAC = 15,
	AUDIO_CODING_TYPE_HE_AAC2 = 16,
	AUDIO_CODING_TYPE_MPEG_SURROUND = 17,
};

enum cea_audio_coding_xtypes {
	AUDIO_CODING_XTYPE_HE_REF_CT = 0,
	AUDIO_CODING_XTYPE_HE_AAC = 1,
	AUDIO_CODING_XTYPE_HE_AAC2 = 2,
	AUDIO_CODING_XTYPE_MPEG_SURROUND = 3,
	AUDIO_CODING_XTYPE_FIRST_RESERVED = 4,
};

enum cfi_quirks {
	CFI_QUIRK_DQ_TRUE_DATA = 1,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 27,
	MAX_CGROUP_BPF_ATTACH_TYPE = 28,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_lifetime_events {
	CGROUP_LIFETIME_ONLINE = 0,
	CGROUP_LIFETIME_OFFLINE = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_COUNT = 0,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	perf_event_cgrp_id = 7,
	pids_cgrp_id = 8,
	CGROUP_SUBSYS_COUNT = 9,
};

enum ch_command {
	HIDMA_CH_DISABLE = 0,
	HIDMA_CH_ENABLE = 1,
	HIDMA_CH_SUSPEND = 2,
	HIDMA_CH_RESET = 9,
};

enum ch_state {
	HIDMA_CH_DISABLED = 0,
	HIDMA_CH_ENABLED = 1,
	HIDMA_CH_RUNNING = 2,
	HIDMA_CH_SUSPENDED = 3,
	HIDMA_CH_STOPPED = 4,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum chip_id {
	MT6323_CHIP_ID = 35,
	MT6328_CHIP_ID = 48,
	MT6331_CHIP_ID = 32,
	MT6332_CHIP_ID = 32,
	MT6357_CHIP_ID = 87,
	MT6358_CHIP_ID = 88,
	MT6359_CHIP_ID = 89,
	MT6366_CHIP_ID = 102,
	MT6391_CHIP_ID = 145,
	MT6397_CHIP_ID = 151,
};

enum chips {
	PFUZE100 = 0,
	PFUZE200 = 1,
	PFUZE3000 = 3,
	PFUZE3001 = 49,
};

enum ci_hw_regs {
	CAP_CAPLENGTH = 0,
	CAP_HCCPARAMS = 1,
	CAP_DCCPARAMS = 2,
	CAP_TESTMODE = 3,
	CAP_LAST = 3,
	OP_USBCMD = 4,
	OP_USBSTS = 5,
	OP_USBINTR = 6,
	OP_FRINDEX = 7,
	OP_DEVICEADDR = 8,
	OP_ENDPTLISTADDR = 9,
	OP_TTCTRL = 10,
	OP_BURSTSIZE = 11,
	OP_ULPI_VIEWPORT = 12,
	OP_PORTSC = 13,
	OP_DEVLC = 14,
	OP_OTGSC = 15,
	OP_USBMODE = 16,
	OP_ENDPTSETUPSTAT = 17,
	OP_ENDPTPRIME = 18,
	OP_ENDPTFLUSH = 19,
	OP_ENDPTSTAT = 20,
	OP_ENDPTCOMPLETE = 21,
	OP_ENDPTCTRL = 22,
	OP_LAST = 38,
};

enum ci_revision {
	CI_REVISION_1X = 10,
	CI_REVISION_20 = 20,
	CI_REVISION_21 = 21,
	CI_REVISION_22 = 22,
	CI_REVISION_23 = 23,
	CI_REVISION_24 = 24,
	CI_REVISION_25 = 25,
	CI_REVISION_25_PLUS = 26,
	CI_REVISION_UNKNOWN = 99,
};

enum ci_role {
	CI_ROLE_HOST = 0,
	CI_ROLE_GADGET = 1,
	CI_ROLE_END = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clk_gating_state {
	CLKS_OFF = 0,
	CLKS_ON = 1,
	REQ_CLKS_OFF = 2,
	REQ_CLKS_ON = 3,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum cma_flags {
	CMA_RESERVE_PAGES_ON_ERROR = 0,
	CMA_ZONES_VALID = 1,
	CMA_ZONES_INVALID = 2,
	CMA_ACTIVATED = 3,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum cop0_coi_func {
	tlbr_op = 1,
	tlbwi_op = 2,
	tlbwr_op = 6,
	tlbp_op = 8,
	rfe_op = 16,
	eret_op = 24,
	wait_op = 32,
	hypcall_op = 40,
};

enum cop1_fmt {
	s_fmt = 0,
	d_fmt = 1,
	e_fmt = 2,
	q_fmt = 3,
	w_fmt = 4,
	l_fmt = 5,
};

enum cop1_sdw_func {
	fadd_op = 0,
	fsub_op = 1,
	fmul_op = 2,
	fdiv_op = 3,
	fsqrt_op = 4,
	fabs_op = 5,
	fmov_op = 6,
	fneg_op = 7,
	froundl_op = 8,
	ftruncl_op = 9,
	fceill_op = 10,
	ffloorl_op = 11,
	fround_op = 12,
	ftrunc_op = 13,
	fceil_op = 14,
	ffloor_op = 15,
	fsel_op = 16,
	fmovc_op = 17,
	fmovz_op = 18,
	fmovn_op = 19,
	fseleqz_op = 20,
	frecip_op = 21,
	frsqrt_op = 22,
	fselnez_op = 23,
	fmaddf_op = 24,
	fmsubf_op = 25,
	frint_op = 26,
	fclass_op = 27,
	fmin_op = 28,
	fmina_op = 29,
	fmax_op = 30,
	fmaxa_op = 31,
	fcvts_op = 32,
	fcvtd_op = 33,
	fcvte_op = 34,
	fcvtw_op = 36,
	fcvtl_op = 37,
	fcmp_op = 48,
};

enum cop1x_func {
	lwxc1_op = 0,
	ldxc1_op = 1,
	swxc1_op = 8,
	sdxc1_op = 9,
	pfetch_op = 15,
	madd_s_op = 32,
	madd_d_op = 33,
	madd_e_op = 34,
	msub_s_op = 40,
	msub_d_op = 41,
	msub_e_op = 42,
	nmadd_s_op = 48,
	nmadd_d_op = 49,
	nmadd_e_op = 50,
	nmsub_s_op = 56,
	nmsub_d_op = 57,
	nmsub_e_op = 58,
};

enum cop_op {
	mfc_op = 0,
	dmfc_op = 1,
	cfc_op = 2,
	mfhc0_op = 2,
	mfhc_op = 3,
	mtc_op = 4,
	dmtc_op = 5,
	ctc_op = 6,
	mthc0_op = 6,
	mthc_op = 7,
	bc_op = 8,
	bc1eqz_op = 9,
	mfmc0_op = 11,
	bc1nez_op = 13,
	wrpgpr_op = 14,
	cop_op = 16,
	copm_op = 24,
};

enum coredump_type_t {
	COREDUMP_FILE = 1,
	COREDUMP_PIPE = 2,
	COREDUMP_SOCK = 3,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_led_event {
	CPU_LED_IDLE_START = 0,
	CPU_LED_IDLE_END = 1,
	CPU_LED_START = 2,
	CPU_LED_STOP = 3,
	CPU_LED_HALTED = 4,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_pm_event {
	CPU_PM_ENTER = 0,
	CPU_PM_ENTER_FAILED = 1,
	CPU_PM_EXIT = 2,
	CPU_CLUSTER_PM_ENTER = 3,
	CPU_CLUSTER_PM_ENTER_FAILED = 4,
	CPU_CLUSTER_PM_EXIT = 5,
};

enum cpu_type_enum {
	CPU_UNKNOWN = 0,
	CPU_R2000 = 1,
	CPU_R3000 = 2,
	CPU_R3000A = 3,
	CPU_R3041 = 4,
	CPU_R3051 = 5,
	CPU_R3052 = 6,
	CPU_R3081 = 7,
	CPU_R3081E = 8,
	CPU_R4000PC = 9,
	CPU_R4000SC = 10,
	CPU_R4000MC = 11,
	CPU_R4200 = 12,
	CPU_R4300 = 13,
	CPU_R4310 = 14,
	CPU_R4400PC = 15,
	CPU_R4400SC = 16,
	CPU_R4400MC = 17,
	CPU_R4600 = 18,
	CPU_R4640 = 19,
	CPU_R4650 = 20,
	CPU_R4700 = 21,
	CPU_R5000 = 22,
	CPU_R5500 = 23,
	CPU_NEVADA = 24,
	CPU_R10000 = 25,
	CPU_R12000 = 26,
	CPU_R14000 = 27,
	CPU_R16000 = 28,
	CPU_RM7000 = 29,
	CPU_SR71000 = 30,
	CPU_TX49XX = 31,
	CPU_4KC = 32,
	CPU_4KEC = 33,
	CPU_4KSC = 34,
	CPU_24K = 35,
	CPU_34K = 36,
	CPU_1004K = 37,
	CPU_74K = 38,
	CPU_ALCHEMY = 39,
	CPU_PR4450 = 40,
	CPU_BMIPS32 = 41,
	CPU_BMIPS3300 = 42,
	CPU_BMIPS4350 = 43,
	CPU_BMIPS4380 = 44,
	CPU_BMIPS5000 = 45,
	CPU_XBURST = 46,
	CPU_LOONGSON32 = 47,
	CPU_M14KC = 48,
	CPU_M14KEC = 49,
	CPU_INTERAPTIV = 50,
	CPU_P5600 = 51,
	CPU_PROAPTIV = 52,
	CPU_1074K = 53,
	CPU_M5150 = 54,
	CPU_I6400 = 55,
	CPU_P6600 = 56,
	CPU_M6250 = 57,
	CPU_5KC = 58,
	CPU_5KE = 59,
	CPU_20KC = 60,
	CPU_25KF = 61,
	CPU_SB1 = 62,
	CPU_SB1A = 63,
	CPU_LOONGSON2EF = 64,
	CPU_LOONGSON64 = 65,
	CPU_CAVIUM_OCTEON = 66,
	CPU_CAVIUM_OCTEON_PLUS = 67,
	CPU_CAVIUM_OCTEON2 = 68,
	CPU_CAVIUM_OCTEON3 = 69,
	CPU_I6500 = 70,
	CPU_QEMU_GENERIC = 71,
	CPU_LAST = 72,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	NR_STATS = 10,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_X86_PREPARE = 2,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 3,
	CPUHP_PERF_POWER = 4,
	CPUHP_PERF_SUPERH = 5,
	CPUHP_X86_HPET_DEAD = 6,
	CPUHP_X86_MCE_DEAD = 7,
	CPUHP_VIRT_NET_DEAD = 8,
	CPUHP_IBMVNIC_DEAD = 9,
	CPUHP_SLUB_DEAD = 10,
	CPUHP_DEBUG_OBJ_DEAD = 11,
	CPUHP_MM_WRITEBACK_DEAD = 12,
	CPUHP_MM_VMSTAT_DEAD = 13,
	CPUHP_SOFTIRQ_DEAD = 14,
	CPUHP_NET_MVNETA_DEAD = 15,
	CPUHP_CPUIDLE_DEAD = 16,
	CPUHP_ARM64_FPSIMD_DEAD = 17,
	CPUHP_ARM_OMAP_WAKE_DEAD = 18,
	CPUHP_IRQ_POLL_DEAD = 19,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 20,
	CPUHP_BIO_DEAD = 21,
	CPUHP_ACPI_CPUDRV_DEAD = 22,
	CPUHP_S390_PFAULT_DEAD = 23,
	CPUHP_BLK_MQ_DEAD = 24,
	CPUHP_FS_BUFF_DEAD = 25,
	CPUHP_PRINTK_DEAD = 26,
	CPUHP_MM_MEMCQ_DEAD = 27,
	CPUHP_PERCPU_CNT_DEAD = 28,
	CPUHP_RADIX_DEAD = 29,
	CPUHP_PAGE_ALLOC = 30,
	CPUHP_NET_DEV_DEAD = 31,
	CPUHP_PCI_XGENE_DEAD = 32,
	CPUHP_IOMMU_IOVA_DEAD = 33,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 34,
	CPUHP_PADATA_DEAD = 35,
	CPUHP_AP_DTPM_CPU_DEAD = 36,
	CPUHP_RANDOM_PREPARE = 37,
	CPUHP_WORKQUEUE_PREP = 38,
	CPUHP_POWER_NUMA_PREPARE = 39,
	CPUHP_HRTIMERS_PREPARE = 40,
	CPUHP_X2APIC_PREPARE = 41,
	CPUHP_SMPCFD_PREPARE = 42,
	CPUHP_RELAY_PREPARE = 43,
	CPUHP_MD_RAID5_PREPARE = 44,
	CPUHP_RCUTREE_PREP = 45,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 46,
	CPUHP_POWERPC_PMAC_PREPARE = 47,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 48,
	CPUHP_XEN_PREPARE = 49,
	CPUHP_XEN_EVTCHN_PREPARE = 50,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 51,
	CPUHP_SH_SH3X_PREPARE = 52,
	CPUHP_TOPOLOGY_PREPARE = 53,
	CPUHP_NET_IUCV_PREPARE = 54,
	CPUHP_ARM_BL_PREPARE = 55,
	CPUHP_TRACE_RB_PREPARE = 56,
	CPUHP_MM_ZSWP_POOL_PREPARE = 57,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 58,
	CPUHP_ZCOMP_PREPARE = 59,
	CPUHP_TIMERS_PREPARE = 60,
	CPUHP_TMIGR_PREPARE = 61,
	CPUHP_MIPS_SOC_PREPARE = 62,
	CPUHP_BP_PREPARE_DYN = 63,
	CPUHP_BP_PREPARE_DYN_END = 83,
	CPUHP_BP_KICK_AP = 84,
	CPUHP_BRINGUP_CPU = 85,
	CPUHP_AP_IDLE_DEAD = 86,
	CPUHP_AP_OFFLINE = 87,
	CPUHP_AP_CACHECTRL_STARTING = 88,
	CPUHP_AP_SCHED_STARTING = 89,
	CPUHP_AP_RCUTREE_DYING = 90,
	CPUHP_AP_CPU_PM_STARTING = 91,
	CPUHP_AP_IRQ_GIC_STARTING = 92,
	CPUHP_AP_IRQ_HIP04_STARTING = 93,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 94,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 95,
	CPUHP_AP_IRQ_BCM2836_STARTING = 96,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 97,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 98,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 99,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 100,
	CPUHP_AP_IRQ_THEAD_ACLINT_SSWI_STARTING = 101,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 102,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 103,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 104,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 105,
	CPUHP_AP_PERF_X86_STARTING = 106,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 107,
	CPUHP_AP_PERF_XTENSA_STARTING = 108,
	CPUHP_AP_ARM_VFP_STARTING = 109,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 110,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 111,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 112,
	CPUHP_AP_PERF_ARM_STARTING = 113,
	CPUHP_AP_PERF_RISCV_STARTING = 114,
	CPUHP_AP_ARM_L2X0_STARTING = 115,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 116,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 117,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 118,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 119,
	CPUHP_AP_JCORE_TIMER_STARTING = 120,
	CPUHP_AP_ARM_TWD_STARTING = 121,
	CPUHP_AP_QCOM_TIMER_STARTING = 122,
	CPUHP_AP_TEGRA_TIMER_STARTING = 123,
	CPUHP_AP_ARMADA_TIMER_STARTING = 124,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 125,
	CPUHP_AP_ARC_TIMER_STARTING = 126,
	CPUHP_AP_REALTEK_TIMER_STARTING = 127,
	CPUHP_AP_RISCV_TIMER_STARTING = 128,
	CPUHP_AP_CLINT_TIMER_STARTING = 129,
	CPUHP_AP_CSKY_TIMER_STARTING = 130,
	CPUHP_AP_TI_GP_TIMER_STARTING = 131,
	CPUHP_AP_HYPERV_TIMER_STARTING = 132,
	CPUHP_AP_DUMMY_TIMER_STARTING = 133,
	CPUHP_AP_ARM_XEN_STARTING = 134,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 135,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 136,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 137,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 138,
	CPUHP_AP_SMPCFD_DYING = 139,
	CPUHP_AP_HRTIMERS_DYING = 140,
	CPUHP_AP_TICK_DYING = 141,
	CPUHP_AP_X86_TBOOT_DYING = 142,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 143,
	CPUHP_AP_ONLINE = 144,
	CPUHP_TEARDOWN_CPU = 145,
	CPUHP_AP_ONLINE_IDLE = 146,
	CPUHP_AP_HYPERV_ONLINE = 147,
	CPUHP_AP_KVM_ONLINE = 148,
	CPUHP_AP_SCHED_WAIT_EMPTY = 149,
	CPUHP_AP_SMPBOOT_THREADS = 150,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 151,
	CPUHP_AP_BLK_MQ_ONLINE = 152,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 153,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 154,
	CPUHP_AP_PERF_ONLINE = 155,
	CPUHP_AP_PERF_X86_ONLINE = 156,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 157,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 158,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 159,
	CPUHP_AP_PERF_S390_CF_ONLINE = 160,
	CPUHP_AP_PERF_S390_SF_ONLINE = 161,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 162,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 163,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 164,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 171,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 172,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 173,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 174,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 175,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 176,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 177,
	CPUHP_AP_PERF_ARM_MRVL_PEM_ONLINE = 178,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 179,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 184,
	CPUHP_AP_PERF_CSKY_ONLINE = 185,
	CPUHP_AP_TMIGR_ONLINE = 186,
	CPUHP_AP_WATCHDOG_ONLINE = 187,
	CPUHP_AP_WORKQUEUE_ONLINE = 188,
	CPUHP_AP_RANDOM_ONLINE = 189,
	CPUHP_AP_RCUTREE_ONLINE = 190,
	CPUHP_AP_KTHREADS_ONLINE = 191,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 192,
	CPUHP_AP_ONLINE_DYN = 193,
	CPUHP_AP_ONLINE_DYN_END = 233,
	CPUHP_AP_X86_HPET_ONLINE = 234,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 235,
	CPUHP_AP_ACTIVE = 236,
	CPUHP_ONLINE = 237,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum createmode4 {
	NFS4_CREATE_UNCHECKED = 0,
	NFS4_CREATE_GUARDED = 1,
	NFS4_CREATE_EXCLUSIVE = 2,
	NFS4_CREATE_EXCLUSIVE4_1 = 3,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	CRYPTOCFGA_REPORT_SIG = 22,
	__CRYPTOCFGA_MAX = 23,
};

enum csr_regs {
	B0_RAP = 0,
	B0_CTST = 4,
	B0_POWER_CTRL = 7,
	B0_ISRC = 8,
	B0_IMSK = 12,
	B0_HWE_ISRC = 16,
	B0_HWE_IMSK = 20,
	B0_Y2_SP_ISRC2 = 28,
	B0_Y2_SP_ISRC3 = 32,
	B0_Y2_SP_EISR = 36,
	B0_Y2_SP_LISR = 40,
	B0_Y2_SP_ICR = 44,
	B2_MAC_1 = 256,
	B2_MAC_2 = 264,
	B2_MAC_3 = 272,
	B2_CONN_TYP = 280,
	B2_PMD_TYP = 281,
	B2_MAC_CFG = 282,
	B2_CHIP_ID = 283,
	B2_E_0 = 284,
	B2_Y2_CLK_GATE = 285,
	B2_Y2_HW_RES = 286,
	B2_E_3 = 287,
	B2_Y2_CLK_CTRL = 288,
	B2_TI_INI = 304,
	B2_TI_VAL = 308,
	B2_TI_CTRL = 312,
	B2_TI_TEST = 313,
	B2_TST_CTRL1 = 344,
	B2_TST_CTRL2 = 345,
	B2_GP_IO = 348,
	B2_I2C_CTRL = 352,
	B2_I2C_DATA = 356,
	B2_I2C_IRQ = 360,
	B2_I2C_SW = 364,
	Y2_PEX_PHY_DATA = 368,
	Y2_PEX_PHY_ADDR = 370,
	B3_RAM_ADDR = 384,
	B3_RAM_DATA_LO = 388,
	B3_RAM_DATA_HI = 392,
	B3_RI_WTO_R1 = 400,
	B3_RI_WTO_XA1 = 401,
	B3_RI_WTO_XS1 = 402,
	B3_RI_RTO_R1 = 403,
	B3_RI_RTO_XA1 = 404,
	B3_RI_RTO_XS1 = 405,
	B3_RI_WTO_R2 = 406,
	B3_RI_WTO_XA2 = 407,
	B3_RI_WTO_XS2 = 408,
	B3_RI_RTO_R2 = 409,
	B3_RI_RTO_XA2 = 410,
	B3_RI_RTO_XS2 = 411,
	B3_RI_TO_VAL = 412,
	B3_RI_CTRL = 416,
	B3_RI_TEST = 418,
	B3_MA_TOINI_RX1 = 432,
	B3_MA_TOINI_RX2 = 433,
	B3_MA_TOINI_TX1 = 434,
	B3_MA_TOINI_TX2 = 435,
	B3_MA_TOVAL_RX1 = 436,
	B3_MA_TOVAL_RX2 = 437,
	B3_MA_TOVAL_TX1 = 438,
	B3_MA_TOVAL_TX2 = 439,
	B3_MA_TO_CTRL = 440,
	B3_MA_TO_TEST = 442,
	B3_MA_RCINI_RX1 = 448,
	B3_MA_RCINI_RX2 = 449,
	B3_MA_RCINI_TX1 = 450,
	B3_MA_RCINI_TX2 = 451,
	B3_MA_RCVAL_RX1 = 452,
	B3_MA_RCVAL_RX2 = 453,
	B3_MA_RCVAL_TX1 = 454,
	B3_MA_RCVAL_TX2 = 455,
	B3_MA_RC_CTRL = 456,
	B3_MA_RC_TEST = 458,
	B3_PA_TOINI_RX1 = 464,
	B3_PA_TOINI_RX2 = 468,
	B3_PA_TOINI_TX1 = 472,
	B3_PA_TOINI_TX2 = 476,
	B3_PA_TOVAL_RX1 = 480,
	B3_PA_TOVAL_RX2 = 484,
	B3_PA_TOVAL_TX1 = 488,
	B3_PA_TOVAL_TX2 = 492,
	B3_PA_CTRL = 496,
	B3_PA_TEST = 498,
	Y2_CFG_SPC = 7168,
	Y2_CFG_AER = 7424,
};

enum csr_target {
	MACRO_CTRL = 7,
};

enum css_task_iter_flags {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum ct_dccp_states {
	CT_DCCP_NONE = 0,
	CT_DCCP_REQUEST = 1,
	CT_DCCP_RESPOND = 2,
	CT_DCCP_PARTOPEN = 3,
	CT_DCCP_OPEN = 4,
	CT_DCCP_CLOSEREQ = 5,
	CT_DCCP_CLOSING = 6,
	CT_DCCP_TIMEWAIT = 7,
	CT_DCCP_IGNORE = 8,
	CT_DCCP_INVALID = 9,
	__CT_DCCP_MAX = 10,
};

enum cti_port_type {
	CTI_PORT_TYPE_NONE = 0,
	CTI_PORT_TYPE_RS232 = 1,
	CTI_PORT_TYPE_RS422_485 = 2,
	CTI_PORT_TYPE_RS232_422_485_HW = 3,
	CTI_PORT_TYPE_RS232_422_485_SW = 4,
	CTI_PORT_TYPE_RS232_422_485_4B = 5,
	CTI_PORT_TYPE_RS232_422_485_2B = 6,
	CTI_PORT_TYPE_MAX = 7,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum cu2_ops {
	CU2_EXCEPTION = 0,
	CU2_LWC2_OP = 1,
	CU2_LDC2_OP = 2,
	CU2_SWC2_OP = 3,
	CU2_SDC2_OP = 4,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum data_content4 {
	NFS4_CONTENT_DATA = 0,
	NFS4_CONTENT_HOLE = 1,
};

enum dbc_state {
	DS_DISABLED = 0,
	DS_INITIALIZED = 1,
	DS_ENABLED = 2,
	DS_CONNECTED = 3,
	DS_CONFIGURED = 4,
	DS_MAX = 5,
};

enum dbgfs_get_mode {
	DBGFS_GET_ALREADY = 0,
	DBGFS_GET_REGULAR = 1,
	DBGFS_GET_SHORT = 2,
};

enum dbshfl_func {
	dsbh_op = 2,
	dshd_op = 5,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum ddivu_op {
	ddivu_ddivu_op = 0,
	ddivu_ddivu6_op = 2,
	ddivu_dmodu_op = 3,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum dentry_flags {
	DCACHE_OP_HASH = 1,
	DCACHE_OP_COMPARE = 2,
	DCACHE_OP_REVALIDATE = 4,
	DCACHE_OP_DELETE = 8,
	DCACHE_OP_PRUNE = 16,
	DCACHE_DISCONNECTED = 32,
	DCACHE_REFERENCED = 64,
	DCACHE_DONTCACHE = 128,
	DCACHE_CANT_MOUNT = 256,
	DCACHE_GENOCIDE = 512,
	DCACHE_SHRINK_LIST = 1024,
	DCACHE_OP_WEAK_REVALIDATE = 2048,
	DCACHE_NFSFS_RENAMED = 4096,
	DCACHE_FSNOTIFY_PARENT_WATCHED = 8192,
	DCACHE_DENTRY_KILLED = 16384,
	DCACHE_MOUNTED = 32768,
	DCACHE_NEED_AUTOMOUNT = 65536,
	DCACHE_MANAGE_TRANSIT = 131072,
	DCACHE_LRU_LIST = 262144,
	DCACHE_ENTRY_TYPE = 3670016,
	DCACHE_MISS_TYPE = 0,
	DCACHE_WHITEOUT_TYPE = 524288,
	DCACHE_DIRECTORY_TYPE = 1048576,
	DCACHE_AUTODIR_TYPE = 1572864,
	DCACHE_REGULAR_TYPE = 2097152,
	DCACHE_SPECIAL_TYPE = 2621440,
	DCACHE_SYMLINK_TYPE = 3145728,
	DCACHE_NOKEY_NAME = 4194304,
	DCACHE_OP_REAL = 8388608,
	DCACHE_PAR_LOOKUP = 16777216,
	DCACHE_DENTRY_CURSOR = 33554432,
	DCACHE_NORCU = 67108864,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum desc_header_offset {
	QUERY_DESC_LENGTH_OFFSET = 0,
	QUERY_DESC_DESC_TYPE_OFFSET = 1,
};

enum desc_idn {
	QUERY_DESC_IDN_DEVICE = 0,
	QUERY_DESC_IDN_CONFIGURATION = 1,
	QUERY_DESC_IDN_UNIT = 2,
	QUERY_DESC_IDN_RFU_0 = 3,
	QUERY_DESC_IDN_INTERCONNECT = 4,
	QUERY_DESC_IDN_STRING = 5,
	QUERY_DESC_IDN_RFU_1 = 6,
	QUERY_DESC_IDN_GEOMETRY = 7,
	QUERY_DESC_IDN_POWER = 8,
	QUERY_DESC_IDN_HEALTH = 9,
	QUERY_DESC_IDN_MAX = 10,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum dev_cmd_type {
	DEV_CMD_TYPE_NOP = 0,
	DEV_CMD_TYPE_QUERY = 1,
	DEV_CMD_TYPE_RPMB = 2,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_parent_dev_type {
	DEVFREQ_PARENT_DEV = 0,
	CPUFREQ_PARENT_DEV = 1,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_desc_param {
	DEVICE_DESC_PARAM_LEN = 0,
	DEVICE_DESC_PARAM_TYPE = 1,
	DEVICE_DESC_PARAM_DEVICE_TYPE = 2,
	DEVICE_DESC_PARAM_DEVICE_CLASS = 3,
	DEVICE_DESC_PARAM_DEVICE_SUB_CLASS = 4,
	DEVICE_DESC_PARAM_PRTCL = 5,
	DEVICE_DESC_PARAM_NUM_LU = 6,
	DEVICE_DESC_PARAM_NUM_WLU = 7,
	DEVICE_DESC_PARAM_BOOT_ENBL = 8,
	DEVICE_DESC_PARAM_DESC_ACCSS_ENBL = 9,
	DEVICE_DESC_PARAM_INIT_PWR_MODE = 10,
	DEVICE_DESC_PARAM_HIGH_PR_LUN = 11,
	DEVICE_DESC_PARAM_SEC_RMV_TYPE = 12,
	DEVICE_DESC_PARAM_SEC_LU = 13,
	DEVICE_DESC_PARAM_BKOP_TERM_LT = 14,
	DEVICE_DESC_PARAM_ACTVE_ICC_LVL = 15,
	DEVICE_DESC_PARAM_SPEC_VER = 16,
	DEVICE_DESC_PARAM_MANF_DATE = 18,
	DEVICE_DESC_PARAM_MANF_NAME = 20,
	DEVICE_DESC_PARAM_PRDCT_NAME = 21,
	DEVICE_DESC_PARAM_SN = 22,
	DEVICE_DESC_PARAM_OEM_ID = 23,
	DEVICE_DESC_PARAM_MANF_ID = 24,
	DEVICE_DESC_PARAM_UD_OFFSET = 26,
	DEVICE_DESC_PARAM_UD_LEN = 27,
	DEVICE_DESC_PARAM_RTT_CAP = 28,
	DEVICE_DESC_PARAM_FRQ_RTC = 29,
	DEVICE_DESC_PARAM_UFS_FEAT = 31,
	DEVICE_DESC_PARAM_FFU_TMT = 32,
	DEVICE_DESC_PARAM_Q_DPTH = 33,
	DEVICE_DESC_PARAM_DEV_VER = 34,
	DEVICE_DESC_PARAM_NUM_SEC_WPA = 36,
	DEVICE_DESC_PARAM_PSA_MAX_DATA = 37,
	DEVICE_DESC_PARAM_PSA_TMT = 41,
	DEVICE_DESC_PARAM_PRDCT_REV = 42,
	DEVICE_DESC_PARAM_HPB_VER = 64,
	DEVICE_DESC_PARAM_HPB_CONTROL = 66,
	DEVICE_DESC_PARAM_EXT_WB_SUP = 77,
	DEVICE_DESC_PARAM_EXT_UFS_FEATURE_SUP = 79,
	DEVICE_DESC_PARAM_WB_PRESRV_USRSPC_EN = 83,
	DEVICE_DESC_PARAM_WB_TYPE = 84,
	DEVICE_DESC_PARAM_WB_SHARED_ALLOC_UNITS = 85,
};

enum device_id {
	MAX8973 = 0,
	MAX77621 = 1,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	__DEVLINK_ATTR_MAX = 180,
	DEVLINK_ATTR_MAX = 179,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_attr_selftest_result {
	DEVLINK_ATTR_SELFTEST_RESULT_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_RESULT = 1,
	DEVLINK_ATTR_SELFTEST_RESULT_ID = 2,
	DEVLINK_ATTR_SELFTEST_RESULT_STATUS = 3,
	__DEVLINK_ATTR_SELFTEST_RESULT_MAX = 4,
	DEVLINK_ATTR_SELFTEST_RESULT_MAX = 3,
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	DEVLINK_CMD_NOTIFY_FILTER_SET = 84,
	__DEVLINK_CMD_MAX = 85,
	DEVLINK_CMD_MAX = 84,
};

enum devlink_dpipe_action_type {
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY = 0,
};

enum devlink_dpipe_field_ethernet_id {
	DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC = 0,
};

enum devlink_dpipe_field_ipv4_id {
	DEVLINK_DPIPE_FIELD_IPV4_DST_IP = 0,
};

enum devlink_dpipe_field_ipv6_id {
	DEVLINK_DPIPE_FIELD_IPV6_DST_IP = 0,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_dpipe_header_id {
	DEVLINK_DPIPE_HEADER_ETHERNET = 0,
	DEVLINK_DPIPE_HEADER_IPV4 = 1,
	DEVLINK_DPIPE_HEADER_IPV6 = 2,
};

enum devlink_dpipe_match_type {
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT = 0,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_health_reporter_state {
	DEVLINK_HEALTH_REPORTER_STATE_HEALTHY = 0,
	DEVLINK_HEALTH_REPORTER_STATE_ERROR = 1,
};

enum devlink_info_version_type {
	DEVLINK_INFO_VERSION_TYPE_NONE = 0,
	DEVLINK_INFO_VERSION_TYPE_COMPONENT = 1,
};

enum devlink_linecard_state {
	DEVLINK_LINECARD_STATE_UNSPEC = 0,
	DEVLINK_LINECARD_STATE_UNPROVISIONED = 1,
	DEVLINK_LINECARD_STATE_UNPROVISIONING = 2,
	DEVLINK_LINECARD_STATE_PROVISIONING = 3,
	DEVLINK_LINECARD_STATE_PROVISIONING_FAILED = 4,
	DEVLINK_LINECARD_STATE_PROVISIONED = 5,
	DEVLINK_LINECARD_STATE_ACTIVE = 6,
	__DEVLINK_LINECARD_STATE_MAX = 7,
	DEVLINK_LINECARD_STATE_MAX = 6,
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

enum devlink_param_cmode {
	DEVLINK_PARAM_CMODE_RUNTIME = 0,
	DEVLINK_PARAM_CMODE_DRIVERINIT = 1,
	DEVLINK_PARAM_CMODE_PERMANENT = 2,
	__DEVLINK_PARAM_CMODE_MAX = 3,
	DEVLINK_PARAM_CMODE_MAX = 2,
};

enum devlink_param_generic_id {
	DEVLINK_PARAM_GENERIC_ID_INT_ERR_RESET = 0,
	DEVLINK_PARAM_GENERIC_ID_MAX_MACS = 1,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_SRIOV = 2,
	DEVLINK_PARAM_GENERIC_ID_REGION_SNAPSHOT = 3,
	DEVLINK_PARAM_GENERIC_ID_IGNORE_ARI = 4,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MAX = 5,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MIN = 6,
	DEVLINK_PARAM_GENERIC_ID_FW_LOAD_POLICY = 7,
	DEVLINK_PARAM_GENERIC_ID_RESET_DEV_ON_DRV_PROBE = 8,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ROCE = 9,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_REMOTE_DEV_RESET = 10,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ETH = 11,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_RDMA = 12,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_VNET = 13,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_IWARP = 14,
	DEVLINK_PARAM_GENERIC_ID_IO_EQ_SIZE = 15,
	DEVLINK_PARAM_GENERIC_ID_EVENT_EQ_SIZE = 16,
	__DEVLINK_PARAM_GENERIC_ID_MAX = 17,
	DEVLINK_PARAM_GENERIC_ID_MAX = 16,
};

enum devlink_param_type {
	DEVLINK_PARAM_TYPE_U8 = 1,
	DEVLINK_PARAM_TYPE_U16 = 2,
	DEVLINK_PARAM_TYPE_U32 = 3,
	DEVLINK_PARAM_TYPE_STRING = 5,
	DEVLINK_PARAM_TYPE_BOOL = 6,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_attr_cap {
	DEVLINK_PORT_FN_ATTR_CAP_ROCE_BIT = 0,
	DEVLINK_PORT_FN_ATTR_CAP_MIGRATABLE_BIT = 1,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_CRYPTO_BIT = 2,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_PACKET_BIT = 3,
	__DEVLINK_PORT_FN_ATTR_CAPS_MAX = 4,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	DEVLINK_PORT_FN_ATTR_MAX_IO_EQS = 6,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 7,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_resource_unit {
	DEVLINK_RESOURCE_UNIT_ENTRY = 0,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_generic_id {
	DEVLINK_TRAP_GENERIC_ID_SMAC_MC = 0,
	DEVLINK_TRAP_GENERIC_ID_VLAN_TAG_MISMATCH = 1,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_VLAN_FILTER = 2,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_STP_FILTER = 3,
	DEVLINK_TRAP_GENERIC_ID_EMPTY_TX_LIST = 4,
	DEVLINK_TRAP_GENERIC_ID_PORT_LOOPBACK_FILTER = 5,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_ROUTE = 6,
	DEVLINK_TRAP_GENERIC_ID_TTL_ERROR = 7,
	DEVLINK_TRAP_GENERIC_ID_TAIL_DROP = 8,
	DEVLINK_TRAP_GENERIC_ID_NON_IP_PACKET = 9,
	DEVLINK_TRAP_GENERIC_ID_UC_DIP_MC_DMAC = 10,
	DEVLINK_TRAP_GENERIC_ID_DIP_LB = 11,
	DEVLINK_TRAP_GENERIC_ID_SIP_MC = 12,
	DEVLINK_TRAP_GENERIC_ID_SIP_LB = 13,
	DEVLINK_TRAP_GENERIC_ID_CORRUPTED_IP_HDR = 14,
	DEVLINK_TRAP_GENERIC_ID_IPV4_SIP_BC = 15,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_RESERVED_SCOPE = 16,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_INTERFACE_LOCAL_SCOPE = 17,
	DEVLINK_TRAP_GENERIC_ID_MTU_ERROR = 18,
	DEVLINK_TRAP_GENERIC_ID_UNRESOLVED_NEIGH = 19,
	DEVLINK_TRAP_GENERIC_ID_RPF = 20,
	DEVLINK_TRAP_GENERIC_ID_REJECT_ROUTE = 21,
	DEVLINK_TRAP_GENERIC_ID_IPV4_LPM_UNICAST_MISS = 22,
	DEVLINK_TRAP_GENERIC_ID_IPV6_LPM_UNICAST_MISS = 23,
	DEVLINK_TRAP_GENERIC_ID_NON_ROUTABLE = 24,
	DEVLINK_TRAP_GENERIC_ID_DECAP_ERROR = 25,
	DEVLINK_TRAP_GENERIC_ID_OVERLAY_SMAC_MC = 26,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_FLOW_ACTION_DROP = 27,
	DEVLINK_TRAP_GENERIC_ID_EGRESS_FLOW_ACTION_DROP = 28,
	DEVLINK_TRAP_GENERIC_ID_STP = 29,
	DEVLINK_TRAP_GENERIC_ID_LACP = 30,
	DEVLINK_TRAP_GENERIC_ID_LLDP = 31,
	DEVLINK_TRAP_GENERIC_ID_IGMP_QUERY = 32,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V1_REPORT = 33,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_REPORT = 34,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V3_REPORT = 35,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_LEAVE = 36,
	DEVLINK_TRAP_GENERIC_ID_MLD_QUERY = 37,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_REPORT = 38,
	DEVLINK_TRAP_GENERIC_ID_MLD_V2_REPORT = 39,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_DONE = 40,
	DEVLINK_TRAP_GENERIC_ID_IPV4_DHCP = 41,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DHCP = 42,
	DEVLINK_TRAP_GENERIC_ID_ARP_REQUEST = 43,
	DEVLINK_TRAP_GENERIC_ID_ARP_RESPONSE = 44,
	DEVLINK_TRAP_GENERIC_ID_ARP_OVERLAY = 45,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_SOLICIT = 46,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_ADVERT = 47,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BFD = 48,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BFD = 49,
	DEVLINK_TRAP_GENERIC_ID_IPV4_OSPF = 50,
	DEVLINK_TRAP_GENERIC_ID_IPV6_OSPF = 51,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BGP = 52,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BGP = 53,
	DEVLINK_TRAP_GENERIC_ID_IPV4_VRRP = 54,
	DEVLINK_TRAP_GENERIC_ID_IPV6_VRRP = 55,
	DEVLINK_TRAP_GENERIC_ID_IPV4_PIM = 56,
	DEVLINK_TRAP_GENERIC_ID_IPV6_PIM = 57,
	DEVLINK_TRAP_GENERIC_ID_UC_LB = 58,
	DEVLINK_TRAP_GENERIC_ID_LOCAL_ROUTE = 59,
	DEVLINK_TRAP_GENERIC_ID_EXTERNAL_ROUTE = 60,
	DEVLINK_TRAP_GENERIC_ID_IPV6_UC_DIP_LINK_LOCAL_SCOPE = 61,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_NODES = 62,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_ROUTERS = 63,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_SOLICIT = 64,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ADVERT = 65,
	DEVLINK_TRAP_GENERIC_ID_IPV6_REDIRECT = 66,
	DEVLINK_TRAP_GENERIC_ID_IPV4_ROUTER_ALERT = 67,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ALERT = 68,
	DEVLINK_TRAP_GENERIC_ID_PTP_EVENT = 69,
	DEVLINK_TRAP_GENERIC_ID_PTP_GENERAL = 70,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_SAMPLE = 71,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_TRAP = 72,
	DEVLINK_TRAP_GENERIC_ID_EARLY_DROP = 73,
	DEVLINK_TRAP_GENERIC_ID_VXLAN_PARSING = 74,
	DEVLINK_TRAP_GENERIC_ID_LLC_SNAP_PARSING = 75,
	DEVLINK_TRAP_GENERIC_ID_VLAN_PARSING = 76,
	DEVLINK_TRAP_GENERIC_ID_PPPOE_PPP_PARSING = 77,
	DEVLINK_TRAP_GENERIC_ID_MPLS_PARSING = 78,
	DEVLINK_TRAP_GENERIC_ID_ARP_PARSING = 79,
	DEVLINK_TRAP_GENERIC_ID_IP_1_PARSING = 80,
	DEVLINK_TRAP_GENERIC_ID_IP_N_PARSING = 81,
	DEVLINK_TRAP_GENERIC_ID_GRE_PARSING = 82,
	DEVLINK_TRAP_GENERIC_ID_UDP_PARSING = 83,
	DEVLINK_TRAP_GENERIC_ID_TCP_PARSING = 84,
	DEVLINK_TRAP_GENERIC_ID_IPSEC_PARSING = 85,
	DEVLINK_TRAP_GENERIC_ID_SCTP_PARSING = 86,
	DEVLINK_TRAP_GENERIC_ID_DCCP_PARSING = 87,
	DEVLINK_TRAP_GENERIC_ID_GTP_PARSING = 88,
	DEVLINK_TRAP_GENERIC_ID_ESP_PARSING = 89,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_NEXTHOP = 90,
	DEVLINK_TRAP_GENERIC_ID_DMAC_FILTER = 91,
	DEVLINK_TRAP_GENERIC_ID_EAPOL = 92,
	DEVLINK_TRAP_GENERIC_ID_LOCKED_PORT = 93,
	__DEVLINK_TRAP_GENERIC_ID_MAX = 94,
	DEVLINK_TRAP_GENERIC_ID_MAX = 93,
};

enum devlink_trap_group_generic_id {
	DEVLINK_TRAP_GROUP_GENERIC_ID_L2_DROPS = 0,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_DROPS = 1,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_EXCEPTIONS = 2,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BUFFER_DROPS = 3,
	DEVLINK_TRAP_GROUP_GENERIC_ID_TUNNEL_DROPS = 4,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_DROPS = 5,
	DEVLINK_TRAP_GROUP_GENERIC_ID_STP = 6,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LACP = 7,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LLDP = 8,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MC_SNOOPING = 9,
	DEVLINK_TRAP_GROUP_GENERIC_ID_DHCP = 10,
	DEVLINK_TRAP_GROUP_GENERIC_ID_NEIGH_DISCOVERY = 11,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BFD = 12,
	DEVLINK_TRAP_GROUP_GENERIC_ID_OSPF = 13,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BGP = 14,
	DEVLINK_TRAP_GROUP_GENERIC_ID_VRRP = 15,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PIM = 16,
	DEVLINK_TRAP_GROUP_GENERIC_ID_UC_LB = 17,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LOCAL_DELIVERY = 18,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EXTERNAL_DELIVERY = 19,
	DEVLINK_TRAP_GROUP_GENERIC_ID_IPV6 = 20,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_EVENT = 21,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_GENERAL = 22,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_SAMPLE = 23,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_TRAP = 24,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PARSER_ERROR_DROPS = 25,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EAPOL = 26,
	__DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 27,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 26,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devlink_var_attr_type {
	DEVLINK_VAR_ATTR_TYPE_U8 = 1,
	DEVLINK_VAR_ATTR_TYPE_U16 = 2,
	DEVLINK_VAR_ATTR_TYPE_U32 = 3,
	DEVLINK_VAR_ATTR_TYPE_U64 = 4,
	DEVLINK_VAR_ATTR_TYPE_STRING = 5,
	DEVLINK_VAR_ATTR_TYPE_FLAG = 6,
	DEVLINK_VAR_ATTR_TYPE_NUL_STRING = 10,
	DEVLINK_VAR_ATTR_TYPE_BINARY = 11,
	__DEVLINK_VAR_ATTR_TYPE_CUSTOM_BASE = 128,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum die_val {
	DIE_OOPS = 1,
	DIE_FP = 2,
	DIE_TRAP = 3,
	DIE_RI = 4,
	DIE_PAGE_FAULT = 5,
	DIE_BREAK = 6,
	DIE_SSTEPBP = 7,
	DIE_MSAFP = 8,
	DIE_UPROBE = 9,
	DIE_UPROBE_XOL = 10,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum discover_event {
	DISCE_DISCOVER_DOMAIN = 0,
	DISCE_REVALIDATE_DOMAIN = 1,
	DISCE_SUSPEND = 2,
	DISCE_RESUME = 3,
	DISC_NUM_EVENTS = 4,
};

enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW = 1,
	DISPLAY_FLAGS_HSYNC_HIGH = 2,
	DISPLAY_FLAGS_VSYNC_LOW = 4,
	DISPLAY_FLAGS_VSYNC_HIGH = 8,
	DISPLAY_FLAGS_DE_LOW = 16,
	DISPLAY_FLAGS_DE_HIGH = 32,
	DISPLAY_FLAGS_PIXDATA_POSEDGE = 64,
	DISPLAY_FLAGS_PIXDATA_NEGEDGE = 128,
	DISPLAY_FLAGS_INTERLACED = 256,
	DISPLAY_FLAGS_DOUBLESCAN = 512,
	DISPLAY_FLAGS_DOUBLECLK = 1024,
	DISPLAY_FLAGS_SYNC_POSEDGE = 2048,
	DISPLAY_FLAGS_SYNC_NEGEDGE = 4096,
};

enum divu_op {
	divu_divu_op = 0,
	divu_divu6_op = 2,
	divu_modu_op = 3,
};

enum dl_bw_request {
	dl_bw_req_deactivate = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dl_param {
	DL_RUNTIME = 0,
	DL_PERIOD = 1,
};

enum dll_reset_type {
	PM_DLL_RESET_ASSERT = 0,
	PM_DLL_RESET_RELEASE = 1,
	PM_DLL_RESET_PULSE = 2,
};

enum dma_channel_status {
	MUSB_DMA_STATUS_UNKNOWN = 0,
	MUSB_DMA_STATUS_FREE = 1,
	MUSB_DMA_STATUS_BUSY = 2,
	MUSB_DMA_STATUS_BUS_ABORT = 3,
	MUSB_DMA_STATUS_CORE_ABORT = 4,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dmultu_op {
	dmultu_dmultu_op = 0,
	dmultu_dmulu_op = 2,
	dmultu_dmuhu_op = 3,
};

enum dns_lookup_status {
	DNS_LOOKUP_NOT_DONE = 0,
	DNS_LOOKUP_GOOD = 1,
	DNS_LOOKUP_GOOD_WITH_BAD = 2,
	DNS_LOOKUP_BAD = 3,
	DNS_LOOKUP_GOT_NOT_FOUND = 4,
	DNS_LOOKUP_GOT_LOCAL_FAILURE = 5,
	DNS_LOOKUP_GOT_TEMP_FAILURE = 6,
	DNS_LOOKUP_GOT_NS_FAILURE = 7,
	NR__dns_lookup_status = 8,
};

enum dns_payload_content_type {
	DNS_PAYLOAD_IS_SERVER_LIST = 0,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum dsa_db_type {
	DSA_DB_PORT = 0,
	DSA_DB_LAG = 1,
	DSA_DB_BRIDGE = 2,
};

enum dsa_tag_protocol {
	DSA_TAG_PROTO_NONE = 0,
	DSA_TAG_PROTO_BRCM = 1,
	DSA_TAG_PROTO_BRCM_LEGACY = 22,
	DSA_TAG_PROTO_BRCM_PREPEND = 2,
	DSA_TAG_PROTO_DSA = 3,
	DSA_TAG_PROTO_EDSA = 4,
	DSA_TAG_PROTO_GSWIP = 5,
	DSA_TAG_PROTO_KSZ9477 = 6,
	DSA_TAG_PROTO_KSZ9893 = 7,
	DSA_TAG_PROTO_LAN9303 = 8,
	DSA_TAG_PROTO_MTK = 9,
	DSA_TAG_PROTO_QCA = 10,
	DSA_TAG_PROTO_TRAILER = 11,
	DSA_TAG_PROTO_8021Q = 12,
	DSA_TAG_PROTO_SJA1105 = 13,
	DSA_TAG_PROTO_KSZ8795 = 14,
	DSA_TAG_PROTO_OCELOT = 15,
	DSA_TAG_PROTO_AR9331 = 16,
	DSA_TAG_PROTO_RTL4_A = 17,
	DSA_TAG_PROTO_HELLCREEK = 18,
	DSA_TAG_PROTO_XRS700X = 19,
	DSA_TAG_PROTO_OCELOT_8021Q = 20,
	DSA_TAG_PROTO_SEVILLE = 21,
	DSA_TAG_PROTO_SJA1110 = 23,
	DSA_TAG_PROTO_RTL8_4 = 24,
	DSA_TAG_PROTO_RTL8_4T = 25,
	DSA_TAG_PROTO_RZN1_A5PSW = 26,
	DSA_TAG_PROTO_LAN937X = 27,
	DSA_TAG_PROTO_VSC73XX_8021Q = 28,
};

enum dw_edma_chip_flags {
	DW_EDMA_CHIP_LOCAL = 1,
};

enum dw_edma_map_format {
	EDMA_MF_EDMA_LEGACY = 0,
	EDMA_MF_EDMA_UNROLL = 1,
	EDMA_MF_HDMA_COMPAT = 5,
	EDMA_MF_HDMA_NATIVE = 7,
};

enum dw_mci_cookie {
	COOKIE_UNMAPPED = 0,
	COOKIE_PRE_MAPPED = 1,
	COOKIE_MAPPED = 2,
};

enum dw_mci_exynos_type {
	DW_MCI_TYPE_EXYNOS4210 = 0,
	DW_MCI_TYPE_EXYNOS4412 = 1,
	DW_MCI_TYPE_EXYNOS5250 = 2,
	DW_MCI_TYPE_EXYNOS5420 = 3,
	DW_MCI_TYPE_EXYNOS5420_SMU = 4,
	DW_MCI_TYPE_EXYNOS7 = 5,
	DW_MCI_TYPE_EXYNOS7_SMU = 6,
	DW_MCI_TYPE_EXYNOS7870 = 7,
	DW_MCI_TYPE_EXYNOS7870_SMU = 8,
	DW_MCI_TYPE_ARTPEC8 = 9,
};

enum dw_mci_state {
	STATE_IDLE = 0,
	STATE_SENDING_CMD = 1,
	STATE_SENDING_DATA = 2,
	STATE_DATA_BUSY = 3,
	STATE_SENDING_STOP = 4,
	STATE_DATA_ERROR = 5,
	STATE_SENDING_CMD11 = 6,
	STATE_WAITING_CMD11_DONE = 7,
};

enum dw_pcie_app_clk {
	DW_PCIE_DBI_CLK = 0,
	DW_PCIE_MSTR_CLK = 1,
	DW_PCIE_SLV_CLK = 2,
	DW_PCIE_NUM_APP_CLKS = 3,
};

enum dw_pcie_app_rst {
	DW_PCIE_DBI_RST = 0,
	DW_PCIE_MSTR_RST = 1,
	DW_PCIE_SLV_RST = 2,
	DW_PCIE_NUM_APP_RSTS = 3,
};

enum dw_pcie_core_clk {
	DW_PCIE_PIPE_CLK = 0,
	DW_PCIE_CORE_CLK = 1,
	DW_PCIE_AUX_CLK = 2,
	DW_PCIE_REF_CLK = 3,
	DW_PCIE_NUM_CORE_CLKS = 4,
};

enum dw_pcie_core_rst {
	DW_PCIE_NON_STICKY_RST = 0,
	DW_PCIE_STICKY_RST = 1,
	DW_PCIE_CORE_RST = 2,
	DW_PCIE_PIPE_RST = 3,
	DW_PCIE_PHY_RST = 4,
	DW_PCIE_HOT_RST = 5,
	DW_PCIE_PWR_RST = 6,
	DW_PCIE_NUM_CORE_RSTS = 7,
};

enum dw_pcie_device_mode {
	DW_PCIE_UNKNOWN_TYPE = 0,
	DW_PCIE_EP_TYPE = 1,
	DW_PCIE_LEG_EP_TYPE = 2,
	DW_PCIE_RC_TYPE = 3,
};

enum dw_pcie_ltssm {
	DW_PCIE_LTSSM_DETECT_QUIET = 0,
	DW_PCIE_LTSSM_DETECT_ACT = 1,
	DW_PCIE_LTSSM_POLL_ACTIVE = 2,
	DW_PCIE_LTSSM_POLL_COMPLIANCE = 3,
	DW_PCIE_LTSSM_POLL_CONFIG = 4,
	DW_PCIE_LTSSM_PRE_DETECT_QUIET = 5,
	DW_PCIE_LTSSM_DETECT_WAIT = 6,
	DW_PCIE_LTSSM_CFG_LINKWD_START = 7,
	DW_PCIE_LTSSM_CFG_LINKWD_ACEPT = 8,
	DW_PCIE_LTSSM_CFG_LANENUM_WAI = 9,
	DW_PCIE_LTSSM_CFG_LANENUM_ACEPT = 10,
	DW_PCIE_LTSSM_CFG_COMPLETE = 11,
	DW_PCIE_LTSSM_CFG_IDLE = 12,
	DW_PCIE_LTSSM_RCVRY_LOCK = 13,
	DW_PCIE_LTSSM_RCVRY_SPEED = 14,
	DW_PCIE_LTSSM_RCVRY_RCVRCFG = 15,
	DW_PCIE_LTSSM_RCVRY_IDLE = 16,
	DW_PCIE_LTSSM_L0 = 17,
	DW_PCIE_LTSSM_L0S = 18,
	DW_PCIE_LTSSM_L123_SEND_EIDLE = 19,
	DW_PCIE_LTSSM_L1_IDLE = 20,
	DW_PCIE_LTSSM_L2_IDLE = 21,
	DW_PCIE_LTSSM_L2_WAKE = 22,
	DW_PCIE_LTSSM_DISABLED_ENTRY = 23,
	DW_PCIE_LTSSM_DISABLED_IDLE = 24,
	DW_PCIE_LTSSM_DISABLED = 25,
	DW_PCIE_LTSSM_LPBK_ENTRY = 26,
	DW_PCIE_LTSSM_LPBK_ACTIVE = 27,
	DW_PCIE_LTSSM_LPBK_EXIT = 28,
	DW_PCIE_LTSSM_LPBK_EXIT_TIMEOUT = 29,
	DW_PCIE_LTSSM_HOT_RESET_ENTRY = 30,
	DW_PCIE_LTSSM_HOT_RESET = 31,
	DW_PCIE_LTSSM_RCVRY_EQ0 = 32,
	DW_PCIE_LTSSM_RCVRY_EQ1 = 33,
	DW_PCIE_LTSSM_RCVRY_EQ2 = 34,
	DW_PCIE_LTSSM_RCVRY_EQ3 = 35,
	DW_PCIE_LTSSM_UNKNOWN = 4294967295,
};

enum dw_wdt_rmod {
	DW_WDT_RMOD_RESET = 1,
	DW_WDT_RMOD_IRQ = 2,
};

enum dwc2_control_phase {
	DWC2_CONTROL_SETUP = 0,
	DWC2_CONTROL_DATA = 1,
	DWC2_CONTROL_STATUS = 2,
};

enum dwc2_ep0_state {
	DWC2_EP0_SETUP = 0,
	DWC2_EP0_DATA_IN = 1,
	DWC2_EP0_DATA_OUT = 2,
	DWC2_EP0_STATUS_IN = 3,
	DWC2_EP0_STATUS_OUT = 4,
};

enum dwc2_halt_status {
	DWC2_HC_XFER_NO_HALT_STATUS = 0,
	DWC2_HC_XFER_COMPLETE = 1,
	DWC2_HC_XFER_URB_COMPLETE = 2,
	DWC2_HC_XFER_ACK = 3,
	DWC2_HC_XFER_NAK = 4,
	DWC2_HC_XFER_NYET = 5,
	DWC2_HC_XFER_STALL = 6,
	DWC2_HC_XFER_XACT_ERR = 7,
	DWC2_HC_XFER_FRAME_OVERRUN = 8,
	DWC2_HC_XFER_BABBLE_ERR = 9,
	DWC2_HC_XFER_DATA_TOGGLE_ERR = 10,
	DWC2_HC_XFER_AHB_ERR = 11,
	DWC2_HC_XFER_PERIODIC_INCOMPLETE = 12,
	DWC2_HC_XFER_URB_DEQUEUE = 13,
};

enum dwc2_hsotg_dmamode {
	S3C_HSOTG_DMA_NONE = 0,
	S3C_HSOTG_DMA_ONLY = 1,
	S3C_HSOTG_DMA_DRV = 2,
};

enum dwc2_lx_state {
	DWC2_L0 = 0,
	DWC2_L1 = 1,
	DWC2_L2 = 2,
	DWC2_L3 = 3,
};

enum dwc2_transaction_type {
	DWC2_TRANSACTION_NONE = 0,
	DWC2_TRANSACTION_PERIODIC = 1,
	DWC2_TRANSACTION_NON_PERIODIC = 2,
	DWC2_TRANSACTION_ALL = 3,
};

enum dwc3_ep0_next {
	DWC3_EP0_UNKNOWN = 0,
	DWC3_EP0_COMPLETE = 1,
	DWC3_EP0_NRDY_DATA = 2,
	DWC3_EP0_NRDY_STATUS = 3,
};

enum dwc3_ep0_state {
	EP0_UNCONNECTED = 0,
	EP0_SETUP_PHASE = 1,
	EP0_DATA_PHASE = 2,
	EP0_STATUS_PHASE = 3,
};

enum dwc3_link_state {
	DWC3_LINK_STATE_U0 = 0,
	DWC3_LINK_STATE_U1 = 1,
	DWC3_LINK_STATE_U2 = 2,
	DWC3_LINK_STATE_U3 = 3,
	DWC3_LINK_STATE_SS_DIS = 4,
	DWC3_LINK_STATE_RX_DET = 5,
	DWC3_LINK_STATE_SS_INACT = 6,
	DWC3_LINK_STATE_POLL = 7,
	DWC3_LINK_STATE_RECOV = 8,
	DWC3_LINK_STATE_HRESET = 9,
	DWC3_LINK_STATE_CMPLY = 10,
	DWC3_LINK_STATE_LPBK = 11,
	DWC3_LINK_STATE_RESET = 14,
	DWC3_LINK_STATE_RESUME = 15,
	DWC3_LINK_STATE_MASK = 15,
};

enum dwcmshc_rk_type {
	DWCMSHC_RK3568 = 0,
	DWCMSHC_RK3588 = 1,
};

enum dynevent_type {
	DYNEVENT_TYPE_SYNTH = 1,
	DYNEVENT_TYPE_KPROBE = 2,
	DYNEVENT_TYPE_NONE = 3,
};

enum e1000_1000t_rx_status {
	e1000_1000t_rx_status_not_ok___2 = 0,
	e1000_1000t_rx_status_ok___2 = 1,
	e1000_1000t_rx_status_undefined___2 = 255,
};

enum e1000_boards {
	board_82571 = 0,
	board_82572 = 1,
	board_82573 = 2,
	board_82574 = 3,
	board_82583 = 4,
	board_80003es2lan = 5,
	board_ich8lan = 6,
	board_ich9lan = 7,
	board_ich10lan = 8,
	board_pchlan = 9,
	board_pch2lan = 10,
	board_pch_lpt = 11,
	board_pch_spt = 12,
	board_pch_cnp = 13,
	board_pch_tgp = 14,
	board_pch_adp = 15,
	board_pch_mtp = 16,
};

enum e1000_bus_speed {
	e1000_bus_speed_unknown___2 = 0,
	e1000_bus_speed_33___2 = 1,
	e1000_bus_speed_66___2 = 2,
	e1000_bus_speed_100___2 = 3,
	e1000_bus_speed_120___2 = 4,
	e1000_bus_speed_133___2 = 5,
	e1000_bus_speed_2500 = 6,
	e1000_bus_speed_5000 = 7,
	e1000_bus_speed_reserved___2 = 8,
};

enum e1000_bus_type {
	e1000_bus_type_unknown___2 = 0,
	e1000_bus_type_pci___2 = 1,
	e1000_bus_type_pcix___2 = 2,
	e1000_bus_type_pci_express = 3,
	e1000_bus_type_reserved___2 = 4,
};

enum e1000_bus_width {
	e1000_bus_width_unknown___2 = 0,
	e1000_bus_width_pcie_x1 = 1,
	e1000_bus_width_pcie_x2 = 2,
	e1000_bus_width_pcie_x4 = 4,
	e1000_bus_width_pcie_x8 = 8,
	e1000_bus_width_32___2 = 9,
	e1000_bus_width_64___2 = 10,
	e1000_bus_width_reserved___2 = 11,
};

enum e1000_fc_mode {
	e1000_fc_none = 0,
	e1000_fc_rx_pause = 1,
	e1000_fc_tx_pause = 2,
	e1000_fc_full = 3,
	e1000_fc_default = 255,
};

enum e1000_mac_type {
	e1000_undefined___2 = 0,
	e1000_vfadapt = 1,
	e1000_vfadapt_i350 = 2,
	e1000_num_macs___2 = 3,
};

enum e1000_mac_type___2 {
	e1000_82571 = 0,
	e1000_82572 = 1,
	e1000_82573 = 2,
	e1000_82574 = 3,
	e1000_82583 = 4,
	e1000_80003es2lan = 5,
	e1000_ich8lan = 6,
	e1000_ich9lan = 7,
	e1000_ich10lan = 8,
	e1000_pchlan = 9,
	e1000_pch2lan = 10,
	e1000_pch_lpt = 11,
	e1000_pch_spt = 12,
	e1000_pch_cnp = 13,
	e1000_pch_tgp = 14,
	e1000_pch_adp = 15,
	e1000_pch_mtp = 16,
	e1000_pch_lnp = 17,
	e1000_pch_ptp = 18,
	e1000_pch_nvp = 19,
};

enum e1000_mac_type___3 {
	e1000_undefined___3 = 0,
	e1000_82575 = 1,
	e1000_82576 = 2,
	e1000_82580 = 3,
	e1000_i350 = 4,
	e1000_i354 = 5,
	e1000_i210 = 6,
	e1000_i211 = 7,
	e1000_num_macs___3 = 8,
};

enum e1000_media_type {
	e1000_media_type_unknown = 0,
	e1000_media_type_copper___2 = 1,
	e1000_media_type_fiber___2 = 2,
	e1000_media_type_internal_serdes___2 = 3,
	e1000_num_media_types___2 = 4,
};

enum e1000_mng_mode {
	e1000_mng_mode_none = 0,
	e1000_mng_mode_asf = 1,
	e1000_mng_mode_pt = 2,
	e1000_mng_mode_ipmi = 3,
	e1000_mng_mode_host_if_only = 4,
};

enum e1000_ms_type {
	e1000_ms_hw_default___2 = 0,
	e1000_ms_force_master___2 = 1,
	e1000_ms_force_slave___2 = 2,
	e1000_ms_auto___2 = 3,
};

enum e1000_nvm_override {
	e1000_nvm_override_none = 0,
	e1000_nvm_override_spi_small = 1,
	e1000_nvm_override_spi_large = 2,
};

enum e1000_nvm_type {
	e1000_nvm_unknown = 0,
	e1000_nvm_none = 1,
	e1000_nvm_eeprom_spi = 2,
	e1000_nvm_flash_hw = 3,
	e1000_nvm_invm = 4,
	e1000_nvm_flash_sw = 5,
};

enum e1000_nvm_type___2 {
	e1000_nvm_unknown___2 = 0,
	e1000_nvm_none___2 = 1,
	e1000_nvm_eeprom_spi___2 = 2,
	e1000_nvm_flash_hw___2 = 3,
	e1000_nvm_flash_sw___2 = 4,
};

enum e1000_phy_type {
	e1000_phy_unknown = 0,
	e1000_phy_none = 1,
	e1000_phy_m88___2 = 2,
	e1000_phy_igp___2 = 3,
	e1000_phy_igp_2 = 4,
	e1000_phy_gg82563 = 5,
	e1000_phy_igp_3 = 6,
	e1000_phy_ife = 7,
	e1000_phy_bm = 8,
	e1000_phy_82578 = 9,
	e1000_phy_82577 = 10,
	e1000_phy_82579 = 11,
	e1000_phy_i217 = 12,
};

enum e1000_phy_type___2 {
	e1000_phy_unknown___2 = 0,
	e1000_phy_none___2 = 1,
	e1000_phy_m88___3 = 2,
	e1000_phy_igp___3 = 3,
	e1000_phy_igp_2___2 = 4,
	e1000_phy_gg82563___2 = 5,
	e1000_phy_igp_3___2 = 6,
	e1000_phy_ife___2 = 7,
	e1000_phy_82580 = 8,
	e1000_phy_i210 = 9,
	e1000_phy_bcm54616 = 10,
};

enum e1000_rev_polarity {
	e1000_rev_polarity_normal___2 = 0,
	e1000_rev_polarity_reversed___2 = 1,
	e1000_rev_polarity_undefined___2 = 255,
};

enum e1000_ring_flags_t {
	IGB_RING_FLAG_RX_3K_BUFFER = 0,
	IGB_RING_FLAG_RX_BUILD_SKB_ENABLED = 1,
	IGB_RING_FLAG_RX_SCTP_CSUM = 2,
	IGB_RING_FLAG_RX_LB_VLAN_BSWAP = 3,
	IGB_RING_FLAG_TX_CTX_IDX = 4,
	IGB_RING_FLAG_TX_DETECT_HANG = 5,
	IGB_RING_FLAG_TX_DISABLED = 6,
	IGB_RING_FLAG_RX_ALLOC_FAILED = 7,
};

enum e1000_serdes_link_state {
	e1000_serdes_link_down = 0,
	e1000_serdes_link_autoneg_progress = 1,
	e1000_serdes_link_autoneg_complete = 2,
	e1000_serdes_link_forced_up = 3,
};

enum e1000_smart_speed {
	e1000_smart_speed_default___2 = 0,
	e1000_smart_speed_on___2 = 1,
	e1000_smart_speed_off___2 = 2,
};

enum e1000_state_t {
	__E1000_TESTING = 0,
	__E1000_RESETTING = 1,
	__E1000_ACCESS_SHARED_RESOURCE = 2,
	__E1000_DOWN = 3,
};

enum e1000_state_t___2 {
	__E1000_TESTING___2 = 0,
	__E1000_RESETTING___2 = 1,
	__E1000_DOWN___2 = 2,
	__E1000_DISABLED = 3,
};

enum e1000_state_t___3 {
	__IGB_TESTING = 0,
	__IGB_RESETTING = 1,
	__IGB_DOWN = 2,
	__IGB_PTP_TX_IN_PROGRESS = 3,
};

enum e1000_ulp_state {
	e1000_ulp_state_unknown = 0,
	e1000_ulp_state_off = 1,
	e1000_ulp_state_on = 2,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum eld_versions {
	ELD_VER_CEA_861D = 2,
	ELD_VER_PARTIAL = 31,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum equalization_preset_type {
	EQ_PRESET_TYPE_8GTS = 0,
	EQ_PRESET_TYPE_16GTS = 1,
	EQ_PRESET_TYPE_32GTS = 2,
	EQ_PRESET_TYPE_64GTS = 3,
	EQ_PRESET_TYPE_MAX = 4,
};

enum err_code {
	HIDMA_EVRE_STATUS_COMPLETE = 1,
	HIDMA_EVRE_STATUS_ERROR = 4,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_EPL = 260,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	ETHTOOL_LINK_MODE_200000baseCR_Full_BIT = 103,
	ETHTOOL_LINK_MODE_200000baseKR_Full_BIT = 104,
	ETHTOOL_LINK_MODE_200000baseDR_Full_BIT = 105,
	ETHTOOL_LINK_MODE_200000baseDR_2_Full_BIT = 106,
	ETHTOOL_LINK_MODE_200000baseSR_Full_BIT = 107,
	ETHTOOL_LINK_MODE_200000baseVR_Full_BIT = 108,
	ETHTOOL_LINK_MODE_400000baseCR2_Full_BIT = 109,
	ETHTOOL_LINK_MODE_400000baseKR2_Full_BIT = 110,
	ETHTOOL_LINK_MODE_400000baseDR2_Full_BIT = 111,
	ETHTOOL_LINK_MODE_400000baseDR2_2_Full_BIT = 112,
	ETHTOOL_LINK_MODE_400000baseSR2_Full_BIT = 113,
	ETHTOOL_LINK_MODE_400000baseVR2_Full_BIT = 114,
	ETHTOOL_LINK_MODE_800000baseCR4_Full_BIT = 115,
	ETHTOOL_LINK_MODE_800000baseKR4_Full_BIT = 116,
	ETHTOOL_LINK_MODE_800000baseDR4_Full_BIT = 117,
	ETHTOOL_LINK_MODE_800000baseDR4_2_Full_BIT = 118,
	ETHTOOL_LINK_MODE_800000baseSR4_Full_BIT = 119,
	ETHTOOL_LINK_MODE_800000baseVR4_Full_BIT = 120,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 121,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_mmsv_event {
	ETHTOOL_MMSV_LP_SENT_VERIFY_MPACKET = 0,
	ETHTOOL_MMSV_LD_SENT_VERIFY_MPACKET = 1,
	ETHTOOL_MMSV_LP_SENT_RESPONSE_MPACKET = 2,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_mpacket {
	ETHTOOL_MPACKET_VERIFY = 0,
	ETHTOOL_MPACKET_RESPONSE = 1,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_STATS_PHY = 21,
	ETH_SS_TS_FLAGS = 22,
	ETH_SS_COUNT = 23,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
	ETHTOOL_RING_USE_HDS_THRS = 64,
};

enum ethtool_tcp_data_split {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_command_flags {
	EVENT_CMD_FL_POST_TRIGGER = 1,
	EVENT_CMD_FL_NEEDS_REC = 2,
};

enum event_trigger_type {
	ETT_NONE = 0,
	ETT_TRACE_ONOFF = 1,
	ETT_SNAPSHOT = 2,
	ETT_STACKTRACE = 4,
	ETT_EVENT_ENABLE = 8,
	ETT_EVENT_HIST = 16,
	ETT_HIST_ENABLE = 32,
	ETT_EVENT_EPROBE = 64,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum ex_phy_state {
	PHY_EMPTY = 0,
	PHY_VACANT = 1,
	PHY_NOT_PRESENT = 2,
	PHY_DEVICE_DISCOVERED = 3,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exec_status {
	SAS_SAM_STAT_GOOD = 0,
	SAS_SAM_STAT_BUSY = 8,
	SAS_SAM_STAT_TASK_ABORTED = 64,
	SAS_SAM_STAT_CHECK_CONDITION = 2,
	SAS_DEV_NO_RESPONSE = 128,
	SAS_DATA_UNDERRUN = 129,
	SAS_DATA_OVERRUN = 130,
	SAS_INTERRUPTED = 131,
	SAS_QUEUE_FULL = 132,
	SAS_DEVICE_UNKNOWN = 133,
	SAS_OPEN_REJECT = 134,
	SAS_OPEN_TO = 135,
	SAS_PROTO_RESPONSE = 136,
	SAS_PHY_DOWN = 137,
	SAS_NAK_R_ERR = 138,
	SAS_PENDING = 139,
	SAS_ABORTED_TASK = 140,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
	EXECMEM_ROX_CACHE = 2,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fan53555_vendor {
	FAN53526_VENDOR_FAIRCHILD = 0,
	FAN53555_VENDOR_FAIRCHILD = 1,
	FAN53555_VENDOR_ROCKCHIP = 2,
	RK8602_VENDOR_ROCKCHIP = 3,
	FAN53555_VENDOR_SILERGY = 4,
	FAN53526_VENDOR_TCS = 5,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	FANOTIFY_EVENT_TYPE_MNT = 6,
	__FANOTIFY_EVENT_TYPE_NUM = 7,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_EDATA = 10,
	FETCH_OP_DEREF = 11,
	FETCH_OP_UDEREF = 12,
	FETCH_OP_ST_RAW = 13,
	FETCH_OP_ST_MEM = 14,
	FETCH_OP_ST_UMEM = 15,
	FETCH_OP_ST_STRING = 16,
	FETCH_OP_ST_USTRING = 17,
	FETCH_OP_ST_SYMSTR = 18,
	FETCH_OP_ST_EDATA = 19,
	FETCH_OP_MOD_BF = 20,
	FETCH_OP_LP_ARRAY = 21,
	FETCH_OP_TP_ARG = 22,
	FETCH_OP_END = 23,
	FETCH_NOP_SYMBOL = 24,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum fields {
	RS = 1,
	RT = 2,
	RD = 4,
	RE = 8,
	SIMM = 16,
	UIMM = 32,
	BIMM = 64,
	JIMM = 128,
	FUNC = 256,
	SET = 512,
	SCIMM = 1024,
	SIMM9 = 2048,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	FIX_CMAP_BEGIN = 0,
	FIX_CMAP_END = 16,
	__end_of_fixed_addresses = 17,
};

enum flag_idn {
	QUERY_FLAG_IDN_FDEVICEINIT = 1,
	QUERY_FLAG_IDN_PERMANENT_WPE = 2,
	QUERY_FLAG_IDN_PWR_ON_WPE = 3,
	QUERY_FLAG_IDN_BKOPS_EN = 4,
	QUERY_FLAG_IDN_LIFE_SPAN_MODE_ENABLE = 5,
	QUERY_FLAG_IDN_PURGE_ENABLE = 6,
	QUERY_FLAG_IDN_RESERVED2 = 7,
	QUERY_FLAG_IDN_FPHYRESOURCEREMOVAL = 8,
	QUERY_FLAG_IDN_BUSY_RTC = 9,
	QUERY_FLAG_IDN_RESERVED3 = 10,
	QUERY_FLAG_IDN_PERMANENTLY_DISABLE_FW_UPDATE = 11,
	QUERY_FLAG_IDN_WB_EN = 14,
	QUERY_FLAG_IDN_WB_BUFF_FLUSH_EN = 15,
	QUERY_FLAG_IDN_WB_BUFF_FLUSH_DURING_HIBERN8 = 16,
	QUERY_FLAG_IDN_HPB_RESET = 17,
	QUERY_FLAG_IDN_HPB_EN = 18,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_control {
	FC_NONE = 0,
	FC_TX = 1,
	FC_RX = 2,
	FC_BOTH = 3,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum folio_walk_level {
	FW_LEVEL_PTE = 0,
	FW_LEVEL_PMD = 1,
	FW_LEVEL_PUD = 2,
};

enum format_state {
	FORMAT_STATE_NONE = 0,
	FORMAT_STATE_NUM = 1,
	FORMAT_STATE_WIDTH = 2,
	FORMAT_STATE_PRECISION = 3,
	FORMAT_STATE_CHAR = 4,
	FORMAT_STATE_STR = 5,
	FORMAT_STATE_PTR = 6,
	FORMAT_STATE_PERCENT_CHAR = 7,
	FORMAT_STATE_INVALID = 8,
};

enum fpga_mgr_states {
	FPGA_MGR_STATE_UNKNOWN = 0,
	FPGA_MGR_STATE_POWER_OFF = 1,
	FPGA_MGR_STATE_POWER_UP = 2,
	FPGA_MGR_STATE_RESET = 3,
	FPGA_MGR_STATE_FIRMWARE_REQ = 4,
	FPGA_MGR_STATE_FIRMWARE_REQ_ERR = 5,
	FPGA_MGR_STATE_PARSE_HEADER = 6,
	FPGA_MGR_STATE_PARSE_HEADER_ERR = 7,
	FPGA_MGR_STATE_WRITE_INIT = 8,
	FPGA_MGR_STATE_WRITE_INIT_ERR = 9,
	FPGA_MGR_STATE_WRITE = 10,
	FPGA_MGR_STATE_WRITE_ERR = 11,
	FPGA_MGR_STATE_WRITE_COMPLETE = 12,
	FPGA_MGR_STATE_WRITE_COMPLETE_ERR = 13,
	FPGA_MGR_STATE_OPERATING = 14,
};

enum fpu_mode {
	FPU_32BIT = 0,
	FPU_64BIT = 1,
	FPU_AS_IS = 2,
	FPU_HYBRID = 3,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
	FREEZE_EXCL = 8,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fscache_cache_state {
	FSCACHE_CACHE_IS_NOT_PRESENT = 0,
	FSCACHE_CACHE_IS_PREPARING = 1,
	FSCACHE_CACHE_IS_ACTIVE = 2,
	FSCACHE_CACHE_GOT_IOERROR = 3,
	FSCACHE_CACHE_IS_WITHDRAWN = 4,
};

enum fscache_cookie_state {
	FSCACHE_COOKIE_STATE_QUIESCENT = 0,
	FSCACHE_COOKIE_STATE_LOOKING_UP = 1,
	FSCACHE_COOKIE_STATE_CREATING = 2,
	FSCACHE_COOKIE_STATE_ACTIVE = 3,
	FSCACHE_COOKIE_STATE_INVALIDATING = 4,
	FSCACHE_COOKIE_STATE_FAILED = 5,
	FSCACHE_COOKIE_STATE_LRU_DISCARDING = 6,
	FSCACHE_COOKIE_STATE_WITHDRAWING = 7,
	FSCACHE_COOKIE_STATE_RELINQUISHING = 8,
	FSCACHE_COOKIE_STATE_DROPPED = 9,
} __attribute__((mode(byte)));

enum fscache_want_state {
	FSCACHE_WANT_PARAMS = 0,
	FSCACHE_WANT_WRITE = 1,
	FSCACHE_WANT_READ = 2,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsl_edma_pm_state {
	RUNNING = 0,
	SUSPENDED = 1,
};

enum fsl_mc_pool_type {
	FSL_MC_POOL_DPMCP = 0,
	FSL_MC_POOL_DPBP = 1,
	FSL_MC_POOL_DPCON = 2,
	FSL_MC_POOL_IRQ = 3,
	FSL_MC_NUM_POOL_TYPES = 4,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_FILE_RANGE = 1,
	FSNOTIFY_EVENT_PATH = 2,
	FSNOTIFY_EVENT_INODE = 3,
	FSNOTIFY_EVENT_DENTRY = 4,
	FSNOTIFY_EVENT_MNT = 5,
	FSNOTIFY_EVENT_ERROR = 6,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_MNTNS = 5,
	FSNOTIFY_ITER_TYPE_COUNT = 6,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_MNTNS = 3,
	FSNOTIFY_OBJ_TYPE_COUNT = 4,
	FSNOTIFY_OBJ_TYPE_DETACHED = 4,
};

enum ftlb_flags {
	FTLB_EN = 1,
	FTLB_SET_PROB = 2,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_resource_type {
	RSC_CARVEOUT = 0,
	RSC_DEVMEM = 1,
	RSC_TRACE = 2,
	RSC_VDEV = 3,
	RSC_LAST = 4,
	RSC_VENDOR_START = 128,
	RSC_VENDOR_END = 512,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum fw_upload_err {
	FW_UPLOAD_ERR_NONE = 0,
	FW_UPLOAD_ERR_HW_ERROR = 1,
	FW_UPLOAD_ERR_TIMEOUT = 2,
	FW_UPLOAD_ERR_CANCELED = 3,
	FW_UPLOAD_ERR_BUSY = 4,
	FW_UPLOAD_ERR_INVALID_SIZE = 5,
	FW_UPLOAD_ERR_RW_ERROR = 6,
	FW_UPLOAD_ERR_WEAROUT = 7,
	FW_UPLOAD_ERR_FW_INVALID = 8,
	FW_UPLOAD_ERR_MAX = 9,
};

enum fw_upload_prog {
	FW_UPLOAD_PROG_IDLE = 0,
	FW_UPLOAD_PROG_RECEIVING = 1,
	FW_UPLOAD_PROG_PREPARING = 2,
	FW_UPLOAD_PROG_TRANSFERRING = 3,
	FW_UPLOAD_PROG_PROGRAMMING = 4,
	FW_UPLOAD_PROG_MAX = 5,
};

enum fwh_lock_state {
	FWH_UNLOCKED = 0,
	FWH_DENY_WRITE = 1,
	FWH_IMMUTABLE = 2,
	FWH_DENY_READ = 4,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum geometry_desc_param {
	GEOMETRY_DESC_PARAM_LEN = 0,
	GEOMETRY_DESC_PARAM_TYPE = 1,
	GEOMETRY_DESC_PARAM_DEV_CAP = 4,
	GEOMETRY_DESC_PARAM_MAX_NUM_LUN = 12,
	GEOMETRY_DESC_PARAM_SEG_SIZE = 13,
	GEOMETRY_DESC_PARAM_ALLOC_UNIT_SIZE = 17,
	GEOMETRY_DESC_PARAM_MIN_BLK_SIZE = 18,
	GEOMETRY_DESC_PARAM_OPT_RD_BLK_SIZE = 19,
	GEOMETRY_DESC_PARAM_OPT_WR_BLK_SIZE = 20,
	GEOMETRY_DESC_PARAM_MAX_IN_BUF_SIZE = 21,
	GEOMETRY_DESC_PARAM_MAX_OUT_BUF_SIZE = 22,
	GEOMETRY_DESC_PARAM_RPMB_RW_SIZE = 23,
	GEOMETRY_DESC_PARAM_DYN_CAP_RSRC_PLC = 24,
	GEOMETRY_DESC_PARAM_DATA_ORDER = 25,
	GEOMETRY_DESC_PARAM_MAX_NUM_CTX = 26,
	GEOMETRY_DESC_PARAM_TAG_UNIT_SIZE = 27,
	GEOMETRY_DESC_PARAM_TAG_RSRC_SIZE = 28,
	GEOMETRY_DESC_PARAM_SEC_RM_TYPES = 29,
	GEOMETRY_DESC_PARAM_MEM_TYPES = 30,
	GEOMETRY_DESC_PARAM_SCM_MAX_NUM_UNITS = 32,
	GEOMETRY_DESC_PARAM_SCM_CAP_ADJ_FCTR = 36,
	GEOMETRY_DESC_PARAM_NPM_MAX_NUM_UNITS = 38,
	GEOMETRY_DESC_PARAM_NPM_CAP_ADJ_FCTR = 42,
	GEOMETRY_DESC_PARAM_ENM1_MAX_NUM_UNITS = 44,
	GEOMETRY_DESC_PARAM_ENM1_CAP_ADJ_FCTR = 48,
	GEOMETRY_DESC_PARAM_ENM2_MAX_NUM_UNITS = 50,
	GEOMETRY_DESC_PARAM_ENM2_CAP_ADJ_FCTR = 54,
	GEOMETRY_DESC_PARAM_ENM3_MAX_NUM_UNITS = 56,
	GEOMETRY_DESC_PARAM_ENM3_CAP_ADJ_FCTR = 60,
	GEOMETRY_DESC_PARAM_ENM4_MAX_NUM_UNITS = 62,
	GEOMETRY_DESC_PARAM_ENM4_CAP_ADJ_FCTR = 66,
	GEOMETRY_DESC_PARAM_OPT_LOG_BLK_SIZE = 68,
	GEOMETRY_DESC_PARAM_HPB_REGION_SIZE = 72,
	GEOMETRY_DESC_PARAM_HPB_NUMBER_LU = 73,
	GEOMETRY_DESC_PARAM_HPB_SUBREGION_SIZE = 74,
	GEOMETRY_DESC_PARAM_HPB_MAX_ACTIVE_REGS = 75,
	GEOMETRY_DESC_PARAM_WB_MAX_ALLOC_UNITS = 79,
	GEOMETRY_DESC_PARAM_WB_MAX_WB_LUNS = 83,
	GEOMETRY_DESC_PARAM_WB_BUFF_CAP_ADJ = 84,
	GEOMETRY_DESC_PARAM_WB_SUP_RED_TYPE = 85,
	GEOMETRY_DESC_PARAM_WB_SUP_WB_TYPE = 86,
};

enum gpio_lookup_flags {
	GPIO_ACTIVE_HIGH = 0,
	GPIO_ACTIVE_LOW = 1,
	GPIO_OPEN_DRAIN = 2,
	GPIO_OPEN_SOURCE = 4,
	GPIO_PERSISTENT = 0,
	GPIO_TRANSITORY = 8,
	GPIO_PULL_UP = 16,
	GPIO_PULL_DOWN = 32,
	GPIO_PULL_DISABLE = 64,
	GPIO_LOOKUP_FLAGS_DEFAULT = 0,
};

enum gpio_v2_line_attr_id {
	GPIO_V2_LINE_ATTR_ID_FLAGS = 1,
	GPIO_V2_LINE_ATTR_ID_OUTPUT_VALUES = 2,
	GPIO_V2_LINE_ATTR_ID_DEBOUNCE = 3,
};

enum gpio_v2_line_changed_type {
	GPIO_V2_LINE_CHANGED_REQUESTED = 1,
	GPIO_V2_LINE_CHANGED_RELEASED = 2,
	GPIO_V2_LINE_CHANGED_CONFIG = 3,
};

enum gpio_v2_line_event_id {
	GPIO_V2_LINE_EVENT_RISING_EDGE = 1,
	GPIO_V2_LINE_EVENT_FALLING_EDGE = 2,
};

enum gpio_v2_line_flag {
	GPIO_V2_LINE_FLAG_USED = 1,
	GPIO_V2_LINE_FLAG_ACTIVE_LOW = 2,
	GPIO_V2_LINE_FLAG_INPUT = 4,
	GPIO_V2_LINE_FLAG_OUTPUT = 8,
	GPIO_V2_LINE_FLAG_EDGE_RISING = 16,
	GPIO_V2_LINE_FLAG_EDGE_FALLING = 32,
	GPIO_V2_LINE_FLAG_OPEN_DRAIN = 64,
	GPIO_V2_LINE_FLAG_OPEN_SOURCE = 128,
	GPIO_V2_LINE_FLAG_BIAS_PULL_UP = 256,
	GPIO_V2_LINE_FLAG_BIAS_PULL_DOWN = 512,
	GPIO_V2_LINE_FLAG_BIAS_DISABLED = 1024,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_REALTIME = 2048,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_HTE = 4096,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum handle_to_path_flags {
	HANDLE_CHECK_PERMS = 1,
	HANDLE_CHECK_SUBTREE = 2,
};

enum handshake_auth {
	HANDSHAKE_AUTH_UNSPEC = 0,
	HANDSHAKE_AUTH_UNAUTH = 1,
	HANDSHAKE_AUTH_PSK = 2,
	HANDSHAKE_AUTH_X509 = 3,
};

enum handshake_handler_class {
	HANDSHAKE_HANDLER_CLASS_NONE = 0,
	HANDSHAKE_HANDLER_CLASS_TLSHD = 1,
	HANDSHAKE_HANDLER_CLASS_MAX = 2,
};

enum handshake_msg_type {
	HANDSHAKE_MSG_TYPE_UNSPEC = 0,
	HANDSHAKE_MSG_TYPE_CLIENTHELLO = 1,
	HANDSHAKE_MSG_TYPE_SERVERHELLO = 2,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hdmi_3d_structure {
	HDMI_3D_STRUCTURE_INVALID = -1,
	HDMI_3D_STRUCTURE_FRAME_PACKING = 0,
	HDMI_3D_STRUCTURE_FIELD_ALTERNATIVE = 1,
	HDMI_3D_STRUCTURE_LINE_ALTERNATIVE = 2,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_FULL = 3,
	HDMI_3D_STRUCTURE_L_DEPTH = 4,
	HDMI_3D_STRUCTURE_L_DEPTH_GFX_GFX_DEPTH = 5,
	HDMI_3D_STRUCTURE_TOP_AND_BOTTOM = 6,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_HALF = 8,
};

enum hdmi_active_aspect {
	HDMI_ACTIVE_ASPECT_16_9_TOP = 2,
	HDMI_ACTIVE_ASPECT_14_9_TOP = 3,
	HDMI_ACTIVE_ASPECT_16_9_CENTER = 4,
	HDMI_ACTIVE_ASPECT_PICTURE = 8,
	HDMI_ACTIVE_ASPECT_4_3 = 9,
	HDMI_ACTIVE_ASPECT_16_9 = 10,
	HDMI_ACTIVE_ASPECT_14_9 = 11,
	HDMI_ACTIVE_ASPECT_4_3_SP_14_9 = 13,
	HDMI_ACTIVE_ASPECT_16_9_SP_14_9 = 14,
	HDMI_ACTIVE_ASPECT_16_9_SP_4_3 = 15,
};

enum hdmi_audio_coding_type {
	HDMI_AUDIO_CODING_TYPE_STREAM = 0,
	HDMI_AUDIO_CODING_TYPE_PCM = 1,
	HDMI_AUDIO_CODING_TYPE_AC3 = 2,
	HDMI_AUDIO_CODING_TYPE_MPEG1 = 3,
	HDMI_AUDIO_CODING_TYPE_MP3 = 4,
	HDMI_AUDIO_CODING_TYPE_MPEG2 = 5,
	HDMI_AUDIO_CODING_TYPE_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_DTS = 7,
	HDMI_AUDIO_CODING_TYPE_ATRAC = 8,
	HDMI_AUDIO_CODING_TYPE_DSD = 9,
	HDMI_AUDIO_CODING_TYPE_EAC3 = 10,
	HDMI_AUDIO_CODING_TYPE_DTS_HD = 11,
	HDMI_AUDIO_CODING_TYPE_MLP = 12,
	HDMI_AUDIO_CODING_TYPE_DST = 13,
	HDMI_AUDIO_CODING_TYPE_WMA_PRO = 14,
	HDMI_AUDIO_CODING_TYPE_CXT = 15,
};

enum hdmi_audio_coding_type_ext {
	HDMI_AUDIO_CODING_TYPE_EXT_CT = 0,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC = 1,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC_V2 = 2,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG_SURROUND = 3,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC = 4,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_V2 = 5,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_EXT_DRA = 7,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_SURROUND = 8,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC_SURROUND = 10,
};

enum hdmi_audio_sample_frequency {
	HDMI_AUDIO_SAMPLE_FREQUENCY_STREAM = 0,
	HDMI_AUDIO_SAMPLE_FREQUENCY_32000 = 1,
	HDMI_AUDIO_SAMPLE_FREQUENCY_44100 = 2,
	HDMI_AUDIO_SAMPLE_FREQUENCY_48000 = 3,
	HDMI_AUDIO_SAMPLE_FREQUENCY_88200 = 4,
	HDMI_AUDIO_SAMPLE_FREQUENCY_96000 = 5,
	HDMI_AUDIO_SAMPLE_FREQUENCY_176400 = 6,
	HDMI_AUDIO_SAMPLE_FREQUENCY_192000 = 7,
};

enum hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_SIZE_STREAM = 0,
	HDMI_AUDIO_SAMPLE_SIZE_16 = 1,
	HDMI_AUDIO_SAMPLE_SIZE_20 = 2,
	HDMI_AUDIO_SAMPLE_SIZE_24 = 3,
};

enum hdmi_colorimetry {
	HDMI_COLORIMETRY_NONE = 0,
	HDMI_COLORIMETRY_ITU_601 = 1,
	HDMI_COLORIMETRY_ITU_709 = 2,
	HDMI_COLORIMETRY_EXTENDED = 3,
};

enum hdmi_colorspace {
	HDMI_COLORSPACE_RGB = 0,
	HDMI_COLORSPACE_YUV422 = 1,
	HDMI_COLORSPACE_YUV444 = 2,
	HDMI_COLORSPACE_YUV420 = 3,
	HDMI_COLORSPACE_RESERVED4 = 4,
	HDMI_COLORSPACE_RESERVED5 = 5,
	HDMI_COLORSPACE_RESERVED6 = 6,
	HDMI_COLORSPACE_IDO_DEFINED = 7,
};

enum hdmi_content_type {
	HDMI_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_CONTENT_TYPE_PHOTO = 1,
	HDMI_CONTENT_TYPE_CINEMA = 2,
	HDMI_CONTENT_TYPE_GAME = 3,
};

enum hdmi_eotf {
	HDMI_EOTF_TRADITIONAL_GAMMA_SDR = 0,
	HDMI_EOTF_TRADITIONAL_GAMMA_HDR = 1,
	HDMI_EOTF_SMPTE_ST2084 = 2,
	HDMI_EOTF_BT_2100_HLG = 3,
};

enum hdmi_extended_colorimetry {
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_601 = 0,
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_709 = 1,
	HDMI_EXTENDED_COLORIMETRY_S_YCC_601 = 2,
	HDMI_EXTENDED_COLORIMETRY_OPYCC_601 = 3,
	HDMI_EXTENDED_COLORIMETRY_OPRGB = 4,
	HDMI_EXTENDED_COLORIMETRY_BT2020_CONST_LUM = 5,
	HDMI_EXTENDED_COLORIMETRY_BT2020 = 6,
	HDMI_EXTENDED_COLORIMETRY_RESERVED = 7,
};

enum hdmi_infoframe_type {
	HDMI_INFOFRAME_TYPE_VENDOR = 129,
	HDMI_INFOFRAME_TYPE_AVI = 130,
	HDMI_INFOFRAME_TYPE_SPD = 131,
	HDMI_INFOFRAME_TYPE_AUDIO = 132,
	HDMI_INFOFRAME_TYPE_DRM = 135,
};

enum hdmi_metadata_type {
	HDMI_STATIC_METADATA_TYPE1 = 0,
};

enum hdmi_nups {
	HDMI_NUPS_UNKNOWN = 0,
	HDMI_NUPS_HORIZONTAL = 1,
	HDMI_NUPS_VERTICAL = 2,
	HDMI_NUPS_BOTH = 3,
};

enum hdmi_picture_aspect {
	HDMI_PICTURE_ASPECT_NONE = 0,
	HDMI_PICTURE_ASPECT_4_3 = 1,
	HDMI_PICTURE_ASPECT_16_9 = 2,
	HDMI_PICTURE_ASPECT_64_27 = 3,
	HDMI_PICTURE_ASPECT_256_135 = 4,
	HDMI_PICTURE_ASPECT_RESERVED = 5,
};

enum hdmi_quantization_range {
	HDMI_QUANTIZATION_RANGE_DEFAULT = 0,
	HDMI_QUANTIZATION_RANGE_LIMITED = 1,
	HDMI_QUANTIZATION_RANGE_FULL = 2,
	HDMI_QUANTIZATION_RANGE_RESERVED = 3,
};

enum hdmi_scan_mode {
	HDMI_SCAN_MODE_NONE = 0,
	HDMI_SCAN_MODE_OVERSCAN = 1,
	HDMI_SCAN_MODE_UNDERSCAN = 2,
	HDMI_SCAN_MODE_RESERVED = 3,
};

enum hdmi_spd_sdi {
	HDMI_SPD_SDI_UNKNOWN = 0,
	HDMI_SPD_SDI_DSTB = 1,
	HDMI_SPD_SDI_DVDP = 2,
	HDMI_SPD_SDI_DVHS = 3,
	HDMI_SPD_SDI_HDDVR = 4,
	HDMI_SPD_SDI_DVC = 5,
	HDMI_SPD_SDI_DSC = 6,
	HDMI_SPD_SDI_VCD = 7,
	HDMI_SPD_SDI_GAME = 8,
	HDMI_SPD_SDI_PC = 9,
	HDMI_SPD_SDI_BD = 10,
	HDMI_SPD_SDI_SACD = 11,
	HDMI_SPD_SDI_HDDVD = 12,
	HDMI_SPD_SDI_PMP = 13,
};

enum hdmi_ycc_quantization_range {
	HDMI_YCC_QUANTIZATION_RANGE_LIMITED = 0,
	HDMI_YCC_QUANTIZATION_RANGE_FULL = 1,
};

enum health_desc_param {
	HEALTH_DESC_PARAM_LEN = 0,
	HEALTH_DESC_PARAM_TYPE = 1,
	HEALTH_DESC_PARAM_EOL_INFO = 2,
	HEALTH_DESC_PARAM_LIFE_TIME_EST_A = 3,
	HEALTH_DESC_PARAM_LIFE_TIME_EST_B = 4,
};

enum hi6421_type {
	HI6421 = 0,
	HI6421_V530 = 1,
};

enum hi6421v530_regulator_id {
	HI6421V530_LDO3 = 0,
	HI6421V530_LDO9 = 1,
	HI6421V530_LDO11 = 2,
	HI6421V530_LDO15 = 3,
	HI6421V530_LDO16 = 4,
};

enum hid_class_request {
	HID_REQ_GET_REPORT = 1,
	HID_REQ_GET_IDLE = 2,
	HID_REQ_GET_PROTOCOL = 3,
	HID_REQ_SET_REPORT = 9,
	HID_REQ_SET_IDLE = 10,
	HID_REQ_SET_PROTOCOL = 11,
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

enum hidma_cap {
	HIDMA_MSI_CAP = 1,
	HIDMA_IDENTITY_CAP = 2,
};

enum hk_flags {
	HK_FLAG_DOMAIN = 1,
	HK_FLAG_MANAGED_IRQ = 2,
	HK_FLAG_KERNEL_NOISE = 4,
};

enum hk_type {
	HK_TYPE_DOMAIN = 0,
	HK_TYPE_MANAGED_IRQ = 1,
	HK_TYPE_KERNEL_NOISE = 2,
	HK_TYPE_MAX = 3,
	HK_TYPE_TICK = 2,
	HK_TYPE_TIMER = 2,
	HK_TYPE_RCU = 2,
	HK_TYPE_MISC = 2,
	HK_TYPE_WQ = 2,
	HK_TYPE_KTHREAD = 2,
};

enum hn_flags_bits {
	HANDSHAKE_F_NET_DRAINING = 0,
};

enum hp_flags_bits {
	HANDSHAKE_F_PROTO_NOTIFY = 0,
};

enum hprobe_state {
	HPROBE_LEASED = 0,
	HPROBE_STABLE = 1,
	HPROBE_GONE = 2,
	HPROBE_CONSUMED = 3,
};

enum hr_flags_bits {
	HANDSHAKE_F_REQ_COMPLETED = 0,
	HANDSHAKE_F_REQ_SESSION = 1,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hte_edge {
	HTE_EDGE_NO_SETUP = 1,
	HTE_RISING_EDGE_TS = 2,
	HTE_FALLING_EDGE_TS = 4,
};

enum hte_return {
	HTE_CB_HANDLED = 0,
	HTE_RUN_SECOND_CB = 1,
};

enum hub_activation_type {
	HUB_INIT = 0,
	HUB_INIT2 = 1,
	HUB_INIT3 = 2,
	HUB_POST_RESET = 3,
	HUB_RESUME = 4,
	HUB_RESET_RESUME = 5,
};

enum hub_led_mode {
	INDICATOR_AUTO = 0,
	INDICATOR_CYCLE = 1,
	INDICATOR_GREEN_BLINK = 2,
	INDICATOR_GREEN_BLINK_OFF = 3,
	INDICATOR_AMBER_BLINK = 4,
	INDICATOR_AMBER_BLINK_OFF = 5,
	INDICATOR_ALT_BLINK = 6,
	INDICATOR_ALT_BLINK_OFF = 7,
} __attribute__((mode(byte)));

enum hub_quiescing_type {
	HUB_DISCONNECT = 0,
	HUB_PRE_RESET = 1,
	HUB_SUSPEND = 2,
};

enum hw_event_mc_err_type {
	HW_EVENT_ERR_CORRECTED = 0,
	HW_EVENT_ERR_UNCORRECTED = 1,
	HW_EVENT_ERR_DEFERRED = 2,
	HW_EVENT_ERR_FATAL = 3,
	HW_EVENT_ERR_INFO = 4,
};

enum hw_protection_action {
	HWPROT_ACT_DEFAULT = 0,
	HWPROT_ACT_SHUTDOWN = 1,
	HWPROT_ACT_REBOOT = 2,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
	hwmon_chip_pec = 13,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_intrusion_attributes {
	hwmon_intrusion_alarm = 0,
	hwmon_intrusion_beep = 1,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_pwm_attributes {
	hwmon_pwm_input = 0,
	hwmon_pwm_enable = 1,
	hwmon_pwm_mode = 2,
	hwmon_pwm_freq = 3,
	hwmon_pwm_auto_channels_temp = 4,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_humidity = 6,
	hwmon_fan = 7,
	hwmon_pwm = 8,
	hwmon_intrusion = 9,
	hwmon_max = 10,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwparam_type {
	hwparam_ioport = 0,
	hwparam_iomem = 1,
	hwparam_ioport_or_iomem = 2,
	hwparam_irq = 3,
	hwparam_dma = 4,
	hwparam_dma_addr = 5,
	hwparam_other = 6,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_provider_qualifier {
	HWTSTAMP_PROVIDER_QUALIFIER_PRECISE = 0,
	HWTSTAMP_PROVIDER_QUALIFIER_APPROX = 1,
	HWTSTAMP_PROVIDER_QUALIFIER_CNT = 2,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_NETDEV = 1,
	HWTSTAMP_SOURCE_PHYLIB = 2,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_chip_type {
	SLB9635 = 0,
	SLB9645 = 1,
	UNKNOWN = 2,
};

enum i2c_slave_event {
	I2C_SLAVE_READ_REQUESTED = 0,
	I2C_SLAVE_WRITE_REQUESTED = 1,
	I2C_SLAVE_READ_PROCESSED = 2,
	I2C_SLAVE_WRITE_RECEIVED = 3,
	I2C_SLAVE_STOP = 4,
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

enum ib_uverbs_odp_general_cap_bits {
	IB_UVERBS_ODP_SUPPORT = 1,
	IB_UVERBS_ODP_SUPPORT_IMPLICIT = 2,
};

enum ib_uverbs_odp_transport_cap_bits {
	IB_UVERBS_ODP_SUPPORT_SEND = 1,
	IB_UVERBS_ODP_SUPPORT_RECV = 2,
	IB_UVERBS_ODP_SUPPORT_WRITE = 4,
	IB_UVERBS_ODP_SUPPORT_READ = 8,
	IB_UVERBS_ODP_SUPPORT_ATOMIC = 16,
	IB_UVERBS_ODP_SUPPORT_SRQ_RECV = 32,
	IB_UVERBS_ODP_SUPPORT_FLUSH = 64,
	IB_UVERBS_ODP_SUPPORT_ATOMIC_WRITE = 128,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

enum igb_boards {
	board_82575 = 0,
};

enum igb_diagnostics_results {
	TEST_REG = 0,
	TEST_EEP = 1,
	TEST_IRQ = 2,
	TEST_LOOP = 3,
	TEST_LINK = 4,
};

enum igb_filter_match_flags {
	IGB_FILTER_FLAG_ETHER_TYPE = 1,
	IGB_FILTER_FLAG_VLAN_TCI = 2,
	IGB_FILTER_FLAG_SRC_MAC_ADDR = 4,
	IGB_FILTER_FLAG_DST_MAC_ADDR = 8,
};

enum igb_tx_buf_type {
	IGB_TYPE_SKB = 0,
	IGB_TYPE_XDP = 1,
	IGB_TYPE_XSK = 2,
};

enum igb_tx_flags {
	IGB_TX_FLAGS_VLAN = 1,
	IGB_TX_FLAGS_TSO = 2,
	IGB_TX_FLAGS_TSTAMP = 4,
	IGB_TX_FLAGS_IPV4 = 16,
	IGB_TX_FLAGS_CSUM = 32,
};

enum igbvf_boards {
	board_vf = 0,
	board_i350_vf = 1,
};

enum igbvf_state_t {
	__IGBVF_TESTING = 0,
	__IGBVF_RESETTING = 1,
	__IGBVF_DOWN = 2,
};

enum iio_available_type {
	IIO_AVAIL_LIST = 0,
	IIO_AVAIL_RANGE = 1,
};

enum iio_buffer_direction {
	IIO_BUFFER_DIRECTION_IN = 0,
	IIO_BUFFER_DIRECTION_OUT = 1,
};

enum iio_chan_info_enum {
	IIO_CHAN_INFO_RAW = 0,
	IIO_CHAN_INFO_PROCESSED = 1,
	IIO_CHAN_INFO_SCALE = 2,
	IIO_CHAN_INFO_OFFSET = 3,
	IIO_CHAN_INFO_CALIBSCALE = 4,
	IIO_CHAN_INFO_CALIBBIAS = 5,
	IIO_CHAN_INFO_PEAK = 6,
	IIO_CHAN_INFO_PEAK_SCALE = 7,
	IIO_CHAN_INFO_QUADRATURE_CORRECTION_RAW = 8,
	IIO_CHAN_INFO_AVERAGE_RAW = 9,
	IIO_CHAN_INFO_LOW_PASS_FILTER_3DB_FREQUENCY = 10,
	IIO_CHAN_INFO_HIGH_PASS_FILTER_3DB_FREQUENCY = 11,
	IIO_CHAN_INFO_SAMP_FREQ = 12,
	IIO_CHAN_INFO_FREQUENCY = 13,
	IIO_CHAN_INFO_PHASE = 14,
	IIO_CHAN_INFO_HARDWAREGAIN = 15,
	IIO_CHAN_INFO_HYSTERESIS = 16,
	IIO_CHAN_INFO_HYSTERESIS_RELATIVE = 17,
	IIO_CHAN_INFO_INT_TIME = 18,
	IIO_CHAN_INFO_ENABLE = 19,
	IIO_CHAN_INFO_CALIBHEIGHT = 20,
	IIO_CHAN_INFO_CALIBWEIGHT = 21,
	IIO_CHAN_INFO_DEBOUNCE_COUNT = 22,
	IIO_CHAN_INFO_DEBOUNCE_TIME = 23,
	IIO_CHAN_INFO_CALIBEMISSIVITY = 24,
	IIO_CHAN_INFO_OVERSAMPLING_RATIO = 25,
	IIO_CHAN_INFO_THERMOCOUPLE_TYPE = 26,
	IIO_CHAN_INFO_CALIBAMBIENT = 27,
	IIO_CHAN_INFO_ZEROPOINT = 28,
	IIO_CHAN_INFO_TROUGH = 29,
};

enum iio_chan_type {
	IIO_VOLTAGE = 0,
	IIO_CURRENT = 1,
	IIO_POWER = 2,
	IIO_ACCEL = 3,
	IIO_ANGL_VEL = 4,
	IIO_MAGN = 5,
	IIO_LIGHT = 6,
	IIO_INTENSITY = 7,
	IIO_PROXIMITY = 8,
	IIO_TEMP = 9,
	IIO_INCLI = 10,
	IIO_ROT = 11,
	IIO_ANGL = 12,
	IIO_TIMESTAMP = 13,
	IIO_CAPACITANCE = 14,
	IIO_ALTVOLTAGE = 15,
	IIO_CCT = 16,
	IIO_PRESSURE = 17,
	IIO_HUMIDITYRELATIVE = 18,
	IIO_ACTIVITY = 19,
	IIO_STEPS = 20,
	IIO_ENERGY = 21,
	IIO_DISTANCE = 22,
	IIO_VELOCITY = 23,
	IIO_CONCENTRATION = 24,
	IIO_RESISTANCE = 25,
	IIO_PH = 26,
	IIO_UVINDEX = 27,
	IIO_ELECTRICALCONDUCTIVITY = 28,
	IIO_COUNT = 29,
	IIO_INDEX = 30,
	IIO_GRAVITY = 31,
	IIO_POSITIONRELATIVE = 32,
	IIO_PHASE = 33,
	IIO_MASSCONCENTRATION = 34,
	IIO_DELTA_ANGL = 35,
	IIO_DELTA_VELOCITY = 36,
	IIO_COLORTEMP = 37,
	IIO_CHROMATICITY = 38,
	IIO_ATTENTION = 39,
};

enum iio_endian {
	IIO_CPU = 0,
	IIO_BE = 1,
	IIO_LE = 2,
};

enum iio_event_direction {
	IIO_EV_DIR_EITHER = 0,
	IIO_EV_DIR_RISING = 1,
	IIO_EV_DIR_FALLING = 2,
	IIO_EV_DIR_NONE = 3,
	IIO_EV_DIR_SINGLETAP = 4,
	IIO_EV_DIR_DOUBLETAP = 5,
	IIO_EV_DIR_FAULT_OPENWIRE = 6,
};

enum iio_event_info {
	IIO_EV_INFO_ENABLE = 0,
	IIO_EV_INFO_VALUE = 1,
	IIO_EV_INFO_HYSTERESIS = 2,
	IIO_EV_INFO_PERIOD = 3,
	IIO_EV_INFO_HIGH_PASS_FILTER_3DB = 4,
	IIO_EV_INFO_LOW_PASS_FILTER_3DB = 5,
	IIO_EV_INFO_TIMEOUT = 6,
	IIO_EV_INFO_RESET_TIMEOUT = 7,
	IIO_EV_INFO_TAP2_MIN_DELAY = 8,
	IIO_EV_INFO_RUNNING_PERIOD = 9,
	IIO_EV_INFO_RUNNING_COUNT = 10,
};

enum iio_event_type {
	IIO_EV_TYPE_THRESH = 0,
	IIO_EV_TYPE_MAG = 1,
	IIO_EV_TYPE_ROC = 2,
	IIO_EV_TYPE_THRESH_ADAPTIVE = 3,
	IIO_EV_TYPE_MAG_ADAPTIVE = 4,
	IIO_EV_TYPE_CHANGE = 5,
	IIO_EV_TYPE_MAG_REFERENCED = 6,
	IIO_EV_TYPE_GESTURE = 7,
	IIO_EV_TYPE_FAULT = 8,
};

enum iio_modifier {
	IIO_NO_MOD = 0,
	IIO_MOD_X = 1,
	IIO_MOD_Y = 2,
	IIO_MOD_Z = 3,
	IIO_MOD_X_AND_Y = 4,
	IIO_MOD_X_AND_Z = 5,
	IIO_MOD_Y_AND_Z = 6,
	IIO_MOD_X_AND_Y_AND_Z = 7,
	IIO_MOD_X_OR_Y = 8,
	IIO_MOD_X_OR_Z = 9,
	IIO_MOD_Y_OR_Z = 10,
	IIO_MOD_X_OR_Y_OR_Z = 11,
	IIO_MOD_LIGHT_BOTH = 12,
	IIO_MOD_LIGHT_IR = 13,
	IIO_MOD_ROOT_SUM_SQUARED_X_Y = 14,
	IIO_MOD_SUM_SQUARED_X_Y_Z = 15,
	IIO_MOD_LIGHT_CLEAR = 16,
	IIO_MOD_LIGHT_RED = 17,
	IIO_MOD_LIGHT_GREEN = 18,
	IIO_MOD_LIGHT_BLUE = 19,
	IIO_MOD_QUATERNION = 20,
	IIO_MOD_TEMP_AMBIENT = 21,
	IIO_MOD_TEMP_OBJECT = 22,
	IIO_MOD_NORTH_MAGN = 23,
	IIO_MOD_NORTH_TRUE = 24,
	IIO_MOD_NORTH_MAGN_TILT_COMP = 25,
	IIO_MOD_NORTH_TRUE_TILT_COMP = 26,
	IIO_MOD_RUNNING = 27,
	IIO_MOD_JOGGING = 28,
	IIO_MOD_WALKING = 29,
	IIO_MOD_STILL = 30,
	IIO_MOD_ROOT_SUM_SQUARED_X_Y_Z = 31,
	IIO_MOD_I = 32,
	IIO_MOD_Q = 33,
	IIO_MOD_CO2 = 34,
	IIO_MOD_VOC = 35,
	IIO_MOD_LIGHT_UV = 36,
	IIO_MOD_LIGHT_DUV = 37,
	IIO_MOD_PM1 = 38,
	IIO_MOD_PM2P5 = 39,
	IIO_MOD_PM4 = 40,
	IIO_MOD_PM10 = 41,
	IIO_MOD_ETHANOL = 42,
	IIO_MOD_H2 = 43,
	IIO_MOD_O2 = 44,
	IIO_MOD_LINEAR_X = 45,
	IIO_MOD_LINEAR_Y = 46,
	IIO_MOD_LINEAR_Z = 47,
	IIO_MOD_PITCH = 48,
	IIO_MOD_YAW = 49,
	IIO_MOD_ROLL = 50,
	IIO_MOD_LIGHT_UVA = 51,
	IIO_MOD_LIGHT_UVB = 52,
};

enum iio_shared_by {
	IIO_SEPARATE = 0,
	IIO_SHARED_BY_TYPE = 1,
	IIO_SHARED_BY_DIR = 2,
	IIO_SHARED_BY_ALL = 3,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum ingenic_machine_type {
	MACH_INGENIC_UNKNOWN = 0,
	MACH_INGENIC_JZ4720 = 1,
	MACH_INGENIC_JZ4725 = 2,
	MACH_INGENIC_JZ4725B = 3,
	MACH_INGENIC_JZ4730 = 4,
	MACH_INGENIC_JZ4740 = 5,
	MACH_INGENIC_JZ4750 = 6,
	MACH_INGENIC_JZ4755 = 7,
	MACH_INGENIC_JZ4760 = 8,
	MACH_INGENIC_JZ4760B = 9,
	MACH_INGENIC_JZ4770 = 10,
	MACH_INGENIC_JZ4775 = 11,
	MACH_INGENIC_JZ4780 = 12,
	MACH_INGENIC_X1000 = 13,
	MACH_INGENIC_X1000E = 14,
	MACH_INGENIC_X1830 = 15,
	MACH_INGENIC_X2000 = 16,
	MACH_INGENIC_X2000E = 17,
	MACH_INGENIC_X2000H = 18,
	MACH_INGENIC_X2100 = 19,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum interconnect_desc_param {
	INTERCONNECT_DESC_PARAM_LEN = 0,
	INTERCONNECT_DESC_PARAM_TYPE = 1,
	INTERCONNECT_DESC_PARAM_UNIPRO_VER = 2,
	INTERCONNECT_DESC_PARAM_MPHY_VER = 4,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
	IO_URING_F_TASK_DEAD = 8192,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_napi_op {
	IO_URING_NAPI_REGISTER_OP = 0,
	IO_URING_NAPI_STATIC_ADD_ID = 1,
	IO_URING_NAPI_STATIC_DEL_ID = 2,
};

enum io_uring_napi_tracking_strategy {
	IO_URING_NAPI_TRACKING_DYNAMIC = 0,
	IO_URING_NAPI_TRACKING_STATIC = 1,
	IO_URING_NAPI_TRACKING_INACTIVE = 255,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_BIND = 56,
	IORING_OP_LISTEN = 57,
	IORING_OP_RECV_ZC = 58,
	IORING_OP_EPOLL_WAIT = 59,
	IORING_OP_READV_FIXED = 60,
	IORING_OP_WRITEV_FIXED = 61,
	IORING_OP_PIPE = 62,
	IORING_OP_LAST = 63,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_CLOCK = 29,
	IORING_REGISTER_CLONE_BUFFERS = 30,
	IORING_REGISTER_SEND_MSG_RING = 31,
	IORING_REGISTER_ZCRX_IFQ = 32,
	IORING_REGISTER_RESIZE_RINGS = 33,
	IORING_REGISTER_MEM_REGION = 34,
	IORING_REGISTER_LAST = 35,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
	IOU_PBUF_RING_INC = 2,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_uring_zcrx_area_flags {
	IORING_ZCRX_AREA_DMABUF = 1,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum io_wq_type {
	IO_WQ_BOUND = 0,
	IO_WQ_UNBOUND = 1,
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
	IOMMU_CAP_DIRTY_TRACKING = 5,
};

enum iommu_domain_cookie_type {
	IOMMU_COOKIE_NONE = 0,
	IOMMU_COOKIE_DMA_IOVA = 1,
	IOMMU_COOKIE_DMA_MSI = 2,
	IOMMU_COOKIE_FAULT_HANDLER = 3,
	IOMMU_COOKIE_SVA = 4,
	IOMMU_COOKIE_IOMMUFD = 5,
};

enum iommu_resv_type {
	IOMMU_RESV_DIRECT = 0,
	IOMMU_RESV_DIRECT_RELAXABLE = 1,
	IOMMU_RESV_RESERVED = 2,
	IOMMU_RESV_MSI = 3,
	IOMMU_RESV_SW_MSI = 4,
};

enum iommufd_hwpt_alloc_flags {
	IOMMU_HWPT_ALLOC_NEST_PARENT = 1,
	IOMMU_HWPT_ALLOC_DIRTY_TRACKING = 2,
	IOMMU_HWPT_FAULT_ID_VALID = 4,
	IOMMU_HWPT_ALLOC_PASID = 8,
};

enum iommufd_object_type {
	IOMMUFD_OBJ_NONE = 0,
	IOMMUFD_OBJ_ANY = 0,
	IOMMUFD_OBJ_DEVICE = 1,
	IOMMUFD_OBJ_HWPT_PAGING = 2,
	IOMMUFD_OBJ_HWPT_NESTED = 3,
	IOMMUFD_OBJ_IOAS = 4,
	IOMMUFD_OBJ_ACCESS = 5,
	IOMMUFD_OBJ_FAULT = 6,
	IOMMUFD_OBJ_VIOMMU = 7,
	IOMMUFD_OBJ_VDEVICE = 8,
	IOMMUFD_OBJ_VEVENTQ = 9,
	IOMMUFD_OBJ_MAX = 10,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipmi_addr_space {
	IPMI_IO_ADDR_SPACE = 0,
	IPMI_MEM_ADDR_SPACE = 1,
};

enum ipmi_addr_src {
	SI_INVALID = 0,
	SI_HOTMOD = 1,
	SI_HARDCODED = 2,
	SI_SPMI = 3,
	SI_ACPI = 4,
	SI_SMBIOS = 5,
	SI_PCI = 6,
	SI_DEVICETREE = 7,
	SI_PLATFORM = 8,
	SI_LAST = 9,
};

enum ipmi_plat_interface_type {
	IPMI_PLAT_IF_SI = 0,
	IPMI_PLAT_IF_SSIF = 1,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum isp1760_ctrl_state {
	ISP1760_CTRL_SETUP = 0,
	ISP1760_CTRL_DATA_IN = 1,
	ISP1760_CTRL_DATA_OUT = 2,
	ISP1760_CTRL_STATUS = 3,
};

enum isp1760_queue_head_types {
	QH_CONTROL = 0,
	QH_BULK = 1,
	QH_INTERRUPT = 2,
	QH_END = 3,
};

enum isp176x_device_controller_fields {
	DC_DEVEN = 0,
	DC_DEVADDR = 1,
	DC_VBUSSTAT = 2,
	DC_SFRESET = 3,
	DC_GLINTENA = 4,
	DC_CDBGMOD_ACK = 5,
	DC_DDBGMODIN_ACK = 6,
	DC_DDBGMODOUT_ACK = 7,
	DC_INTPOL = 8,
	DC_IEPRXTX_7 = 9,
	DC_IEPRXTX_6 = 10,
	DC_IEPRXTX_5 = 11,
	DC_IEPRXTX_4 = 12,
	DC_IEPRXTX_3 = 13,
	DC_IEPRXTX_2 = 14,
	DC_IEPRXTX_1 = 15,
	DC_IEPRXTX_0 = 16,
	DC_IEP0SETUP = 17,
	DC_IEVBUS = 18,
	DC_IEHS_STA = 19,
	DC_IERESM = 20,
	DC_IESUSP = 21,
	DC_IEBRST = 22,
	DC_EP0SETUP = 23,
	DC_ENDPIDX = 24,
	DC_EPDIR = 25,
	DC_CLBUF = 26,
	DC_VENDP = 27,
	DC_DSEN = 28,
	DC_STATUS = 29,
	DC_STALL = 30,
	DC_BUFLEN = 31,
	DC_FFOSZ = 32,
	DC_EPENABLE = 33,
	DC_ENDPTYP = 34,
	DC_FRAMENUM = 35,
	DC_UFRAMENUM = 36,
	DC_CHIP_ID_HIGH = 37,
	DC_CHIP_ID_LOW = 38,
	DC_SCRATCH = 39,
	DC_FIELD_MAX = 40,
};

enum isp176x_host_controller_fields {
	PORT_OWNER = 0,
	PORT_POWER = 1,
	PORT_LSTATUS = 2,
	PORT_RESET = 3,
	PORT_SUSPEND = 4,
	PORT_RESUME = 5,
	PORT_PE = 6,
	PORT_CSC = 7,
	PORT_CONNECT = 8,
	HCS_PPC = 9,
	HCS_N_PORTS = 10,
	HCC_ISOC_CACHE = 11,
	HCC_ISOC_THRES = 12,
	CMD_LRESET = 13,
	CMD_RESET = 14,
	CMD_RUN = 15,
	STS_PCD = 16,
	HC_FRINDEX = 17,
	FLAG_CF = 18,
	HC_ISO_PTD_DONEMAP = 19,
	HC_ISO_PTD_SKIPMAP = 20,
	HC_ISO_PTD_LASTPTD = 21,
	HC_INT_PTD_DONEMAP = 22,
	HC_INT_PTD_SKIPMAP = 23,
	HC_INT_PTD_LASTPTD = 24,
	HC_ATL_PTD_DONEMAP = 25,
	HC_ATL_PTD_SKIPMAP = 26,
	HC_ATL_PTD_LASTPTD = 27,
	ALL_ATX_RESET = 28,
	HW_ANA_DIGI_OC = 29,
	HW_DEV_DMA = 30,
	HW_COMN_IRQ = 31,
	HW_COMN_DMA = 32,
	HW_DATA_BUS_WIDTH = 33,
	HW_DACK_POL_HIGH = 34,
	HW_DREQ_POL_HIGH = 35,
	HW_INTR_HIGH_ACT = 36,
	HW_INTF_LOCK = 37,
	HW_INTR_EDGE_TRIG = 38,
	HW_GLOBAL_INTR_EN = 39,
	HC_CHIP_ID_HIGH = 40,
	HC_CHIP_ID_LOW = 41,
	HC_CHIP_REV = 42,
	HC_SCRATCH = 43,
	SW_RESET_RESET_ATX = 44,
	SW_RESET_RESET_HC = 45,
	SW_RESET_RESET_ALL = 46,
	ISO_BUF_FILL = 47,
	INT_BUF_FILL = 48,
	ATL_BUF_FILL = 49,
	MEM_BANK_SEL = 50,
	MEM_START_ADDR = 51,
	HC_DATA = 52,
	HC_INTERRUPT = 53,
	HC_INT_IRQ_ENABLE = 54,
	HC_ATL_IRQ_ENABLE = 55,
	HC_ISO_IRQ_MASK_OR = 56,
	HC_INT_IRQ_MASK_OR = 57,
	HC_ATL_IRQ_MASK_OR = 58,
	HC_ISO_IRQ_MASK_AND = 59,
	HC_INT_IRQ_MASK_AND = 60,
	HC_ATL_IRQ_MASK_AND = 61,
	HW_OTG_DISABLE = 62,
	HW_SW_SEL_HC_DC = 63,
	HW_VBUS_DRV = 64,
	HW_SEL_CP_EXT = 65,
	HW_DM_PULLDOWN = 66,
	HW_DP_PULLDOWN = 67,
	HW_DP_PULLUP = 68,
	HW_HC_2_DIS = 69,
	HW_OTG_DISABLE_CLEAR = 70,
	HW_SW_SEL_HC_DC_CLEAR = 71,
	HW_VBUS_DRV_CLEAR = 72,
	HW_SEL_CP_EXT_CLEAR = 73,
	HW_DM_PULLDOWN_CLEAR = 74,
	HW_DP_PULLDOWN_CLEAR = 75,
	HW_DP_PULLUP_CLEAR = 76,
	HW_HC_2_DIS_CLEAR = 77,
	HC_FIELD_MAX = 78,
};

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_FOLIOQ = 4,
	ITER_XARRAY = 5,
	ITER_DISCARD = 6,
};

enum jbd2_shrink_type {
	JBD2_SHRINK_DESTROY = 0,
	JBD2_SHRINK_BUSY_STOP = 1,
	JBD2_SHRINK_BUSY_SKIP = 2,
};

enum jbd_state_bits {
	BH_JBD = 17,
	BH_JWrite = 18,
	BH_Freed = 19,
	BH_Revoked = 20,
	BH_RevokeValid = 21,
	BH_JBDDirty = 22,
	BH_JournalHead = 23,
	BH_Shadow = 24,
	BH_Verified = 25,
	BH_JBDPrivateStart = 26,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum kcmp_type {
	KCMP_FILE = 0,
	KCMP_VM = 1,
	KCMP_FILES = 2,
	KCMP_FS = 3,
	KCMP_SIGHAND = 4,
	KCMP_IO = 5,
	KCMP_SYSVSEM = 6,
	KCMP_EPOLL_TFD = 7,
	KCMP_TYPES = 8,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
	KERNFS_ROOT_INVARIANT_PARENT = 16,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
	KF_ARG_PTR_TO_IRQ_FLAG = 17,
	KF_ARG_PTR_TO_RES_SPIN_LOCK = 18,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_DMA = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_CGROUP = 2,
	NR_KMALLOC_TYPES = 3,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum kpage_operation {
	KPAGE_FLAGS = 0,
	KPAGE_COUNT = 1,
	KPAGE_CGROUP = 2,
};

enum ksm_advisor_type {
	KSM_ADVISOR_NONE = 0,
	KSM_ADVISOR_SCAN_TIME = 1,
};

enum ksm_get_folio_flags {
	KSM_GET_FOLIO_NOLOCK = 0,
	KSM_GET_FOLIO_LOCK = 1,
	KSM_GET_FOLIO_TRYLOCK = 2,
};

enum l2tp_debug_flags {
	L2TP_MSG_DEBUG = 1,
	L2TP_MSG_CONTROL = 2,
	L2TP_MSG_SEQ = 4,
	L2TP_MSG_DATA = 8,
};

enum label_id {
	label_clear_nopref = 1,
	label_clear_pref = 2,
	label_copy_nopref = 3,
	label_copy_pref_both = 4,
	label_copy_pref_store = 5,
};

enum label_id___2 {
	label_second_part = 1,
	label_leave = 2,
	label_vmalloc = 3,
	label_vmalloc_done = 4,
	label_tlbw_hazard_0 = 5,
	label_split = 13,
	label_tlbl_goaround1 = 14,
	label_tlbl_goaround2 = 15,
	label_nopage_tlbl = 16,
	label_nopage_tlbs = 17,
	label_nopage_tlbm = 18,
	label_smp_pgtable_change = 19,
	label_r3000_write_probe_fail = 20,
	label_large_segbits_fault = 21,
};

enum latency_range {
	lowest_latency = 0,
	low_latency = 1,
	bulk_latency = 2,
	latency_invalid = 255,
};

enum layoutdriver_policy_flags {
	PNFS_LAYOUTRET_ON_SETATTR = 1,
	PNFS_LAYOUTRET_ON_ERROR = 2,
	PNFS_READ_WHOLE_PAGE = 4,
	PNFS_LAYOUTGET_ON_OPEN = 8,
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_default_state {
	LEDS_DEFSTATE_OFF = 0,
	LEDS_DEFSTATE_ON = 1,
	LEDS_DEFSTATE_KEEP = 2,
};

enum led_mode {
	MO_LED_NORM = 0,
	MO_LED_BLINK = 1,
	MO_LED_OFF = 2,
	MO_LED_ON = 3,
};

enum led_trigger_netdev_modes {
	TRIGGER_NETDEV_LINK = 0,
	TRIGGER_NETDEV_LINK_10 = 1,
	TRIGGER_NETDEV_LINK_100 = 2,
	TRIGGER_NETDEV_LINK_1000 = 3,
	TRIGGER_NETDEV_LINK_2500 = 4,
	TRIGGER_NETDEV_LINK_5000 = 5,
	TRIGGER_NETDEV_LINK_10000 = 6,
	TRIGGER_NETDEV_HALF_DUPLEX = 7,
	TRIGGER_NETDEV_FULL_DUPLEX = 8,
	TRIGGER_NETDEV_TX = 9,
	TRIGGER_NETDEV_RX = 10,
	TRIGGER_NETDEV_TX_ERR = 11,
	TRIGGER_NETDEV_RX_ERR = 12,
	__TRIGGER_NETDEV_MAX = 13,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum limit_by4 {
	NFS4_LIMIT_SIZE = 1,
	NFS4_LIMIT_BLOCKS = 2,
};

enum link_inband_signalling {
	LINK_INBAND_DISABLE = 1,
	LINK_INBAND_ENABLE = 2,
	LINK_INBAND_BYPASS = 4,
};

enum lock_type4 {
	NFS4_UNLOCK_LT = 0,
	NFS4_READ_LT = 1,
	NFS4_WRITE_LT = 2,
	NFS4_READW_LT = 3,
	NFS4_WRITEW_LT = 4,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum lpuart_type {
	VF610_LPUART = 0,
	LS1021A_LPUART = 1,
	LS1028A_LPUART = 2,
	IMX7ULP_LPUART = 3,
	IMX8ULP_LPUART = 4,
	IMX8QXP_LPUART = 5,
	IMXRT1050_LPUART = 6,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

enum lsm_integrity_type {
	LSM_INT_DMVERITY_SIG_VALID = 0,
	LSM_INT_DMVERITY_ROOTHASH = 1,
	LSM_INT_FSVERITY_BUILTINSIG_VALID = 2,
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum lx_func {
	lwx_op = 0,
	lhx_op = 4,
	lbux_op = 6,
	ldx_op = 8,
	lwux_op = 16,
	lhux_op = 20,
	lbx_op = 22,
};

enum lzma2_seq {
	SEQ_CONTROL = 0,
	SEQ_UNCOMPRESSED_1 = 1,
	SEQ_UNCOMPRESSED_2 = 2,
	SEQ_COMPRESSED_0 = 3,
	SEQ_COMPRESSED_1 = 4,
	SEQ_PROPERTIES = 5,
	SEQ_LZMA_PREPARE = 6,
	SEQ_LZMA_RUN = 7,
	SEQ_COPY = 8,
};

enum lzma_state {
	STATE_LIT_LIT = 0,
	STATE_MATCH_LIT_LIT = 1,
	STATE_REP_LIT_LIT = 2,
	STATE_SHORTREP_LIT_LIT = 3,
	STATE_MATCH_LIT = 4,
	STATE_REP_LIT = 5,
	STATE_SHORTREP_LIT = 6,
	STATE_LIT_MATCH = 7,
	STATE_LIT_LONGREP = 8,
	STATE_LIT_SHORTREP = 9,
	STATE_NONLIT_MATCH = 10,
	STATE_NONLIT_REP = 11,
};

enum macb_bd_control {
	TSTAMP_DISABLED = 0,
	TSTAMP_FRAME_PTP_EVENT_ONLY = 1,
	TSTAMP_ALL_PTP_FRAMES = 2,
	TSTAMP_ALL_FRAMES = 3,
};

enum maddf_flags {
	MADDF_NEGATE_PRODUCT = 1,
	MADDF_NEGATE_ADDITION = 2,
};

enum major_op {
	spec_op = 0,
	bcond_op = 1,
	j_op = 2,
	jal_op = 3,
	beq_op = 4,
	bne_op = 5,
	blez_op = 6,
	bgtz_op = 7,
	addi_op = 8,
	pop10_op = 8,
	addiu_op = 9,
	slti_op = 10,
	sltiu_op = 11,
	andi_op = 12,
	ori_op = 13,
	xori_op = 14,
	lui_op = 15,
	cop0_op = 16,
	cop1_op = 17,
	cop2_op = 18,
	cop1x_op = 19,
	beql_op = 20,
	bnel_op = 21,
	blezl_op = 22,
	bgtzl_op = 23,
	daddi_op = 24,
	pop30_op = 24,
	daddiu_op = 25,
	ldl_op = 26,
	ldr_op = 27,
	spec2_op = 28,
	jalx_op = 29,
	mdmx_op = 30,
	msa_op = 30,
	spec3_op = 31,
	lb_op = 32,
	lh_op = 33,
	lwl_op = 34,
	lw_op = 35,
	lbu_op = 36,
	lhu_op = 37,
	lwr_op = 38,
	lwu_op = 39,
	sb_op = 40,
	sh_op = 41,
	swl_op = 42,
	sw_op = 43,
	sdl_op = 44,
	sdr_op = 45,
	swr_op = 46,
	cache_op = 47,
	ll_op = 48,
	lwc1_op = 49,
	lwc2_op = 50,
	bc6_op = 50,
	pref_op = 51,
	lld_op = 52,
	ldc1_op = 53,
	ldc2_op = 54,
	pop66_op = 54,
	ld_op = 55,
	sc_op = 56,
	swc1_op = 57,
	swc2_op = 58,
	balc6_op = 58,
	major_3b_op = 59,
	scd_op = 60,
	sdc1_op = 61,
	sdc2_op = 62,
	pop76_op = 62,
	sd_op = 63,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_RELEASE_ALWAYS = 6,
	AS_STABLE_WRITES = 7,
	AS_INACCESSIBLE = 8,
	AS_WRITEBACK_MAY_DEADLOCK_ON_RECLAIM = 9,
	AS_FOLIO_ORDER_BITS = 5,
	AS_FOLIO_ORDER_MIN = 16,
	AS_FOLIO_ORDER_MAX = 21,
};

enum max77620_alternate_pinmux_option {
	MAX77620_PINMUX_GPIO = 0,
	MAX77620_PINMUX_LOW_POWER_MODE_CONTROL_IN = 1,
	MAX77620_PINMUX_FLEXIBLE_POWER_SEQUENCER_OUT = 2,
	MAX77620_PINMUX_32K_OUT1 = 3,
	MAX77620_PINMUX_SD0_DYNAMIC_VOLTAGE_SCALING_IN = 4,
	MAX77620_PINMUX_SD1_DYNAMIC_VOLTAGE_SCALING_IN = 5,
	MAX77620_PINMUX_REFERENCE_OUT = 6,
};

enum max77620_chip_id {
	MAX77620 = 0,
	MAX20024 = 1,
	MAX77663 = 2,
};

enum max77620_fps_src {
	MAX77620_FPS_SRC_0 = 0,
	MAX77620_FPS_SRC_1 = 1,
	MAX77620_FPS_SRC_2 = 2,
	MAX77620_FPS_SRC_NONE = 3,
	MAX77620_FPS_SRC_DEF = 4,
};

enum max77620_pin_ppdrv {
	MAX77620_PIN_UNCONFIG_DRV = 0,
	MAX77620_PIN_OD_DRV = 1,
	MAX77620_PIN_PP_DRV = 2,
};

enum max77620_regulator_type {
	MAX77620_REGULATOR_TYPE_SD = 0,
	MAX77620_REGULATOR_TYPE_LDO_N = 1,
	MAX77620_REGULATOR_TYPE_LDO_P = 2,
};

enum max77620_regulators {
	MAX77620_REGULATOR_ID_SD0 = 0,
	MAX77620_REGULATOR_ID_SD1 = 1,
	MAX77620_REGULATOR_ID_SD2 = 2,
	MAX77620_REGULATOR_ID_SD3 = 3,
	MAX77620_REGULATOR_ID_SD4 = 4,
	MAX77620_REGULATOR_ID_LDO0 = 5,
	MAX77620_REGULATOR_ID_LDO1 = 6,
	MAX77620_REGULATOR_ID_LDO2 = 7,
	MAX77620_REGULATOR_ID_LDO3 = 8,
	MAX77620_REGULATOR_ID_LDO4 = 9,
	MAX77620_REGULATOR_ID_LDO5 = 10,
	MAX77620_REGULATOR_ID_LDO6 = 11,
	MAX77620_REGULATOR_ID_LDO7 = 12,
	MAX77620_REGULATOR_ID_LDO8 = 13,
	MAX77620_NUM_REGS = 14,
};

enum max77686_irq {
	MAX77686_PMICIRQ_PWRONF = 0,
	MAX77686_PMICIRQ_PWRONR = 1,
	MAX77686_PMICIRQ_JIGONBF = 2,
	MAX77686_PMICIRQ_JIGONBR = 3,
	MAX77686_PMICIRQ_ACOKBF = 4,
	MAX77686_PMICIRQ_ACOKBR = 5,
	MAX77686_PMICIRQ_ONKEY1S = 6,
	MAX77686_PMICIRQ_MRSTB = 7,
	MAX77686_PMICIRQ_140C = 8,
	MAX77686_PMICIRQ_120C = 9,
	MAX77686_RTCIRQ_RTC60S = 0,
	MAX77686_RTCIRQ_RTCA1 = 1,
	MAX77686_RTCIRQ_RTCA2 = 2,
	MAX77686_RTCIRQ_SMPL = 3,
	MAX77686_RTCIRQ_RTC1S = 4,
	MAX77686_RTCIRQ_WTSR = 5,
};

enum max77686_irq_source {
	PMIC_INT1 = 0,
	PMIC_INT2 = 1,
	RTC_INT = 2,
	MAX77686_IRQ_GROUP_NR = 3,
};

enum max77686_pmic_reg {
	MAX77686_REG_DEVICE_ID = 0,
	MAX77686_REG_INTSRC = 1,
	MAX77686_REG_INT1 = 2,
	MAX77686_REG_INT2 = 3,
	MAX77686_REG_INT1MSK = 4,
	MAX77686_REG_INT2MSK = 5,
	MAX77686_REG_STATUS1 = 6,
	MAX77686_REG_STATUS2 = 7,
	MAX77686_REG_PWRON = 8,
	MAX77686_REG_ONOFF_DELAY = 9,
	MAX77686_REG_MRSTB = 10,
	MAX77686_REG_BUCK1CTRL = 16,
	MAX77686_REG_BUCK1OUT = 17,
	MAX77686_REG_BUCK2CTRL1 = 18,
	MAX77686_REG_BUCK234FREQ = 19,
	MAX77686_REG_BUCK2DVS1 = 20,
	MAX77686_REG_BUCK2DVS2 = 21,
	MAX77686_REG_BUCK2DVS3 = 22,
	MAX77686_REG_BUCK2DVS4 = 23,
	MAX77686_REG_BUCK2DVS5 = 24,
	MAX77686_REG_BUCK2DVS6 = 25,
	MAX77686_REG_BUCK2DVS7 = 26,
	MAX77686_REG_BUCK2DVS8 = 27,
	MAX77686_REG_BUCK3CTRL1 = 28,
	MAX77686_REG_BUCK3DVS1 = 30,
	MAX77686_REG_BUCK3DVS2 = 31,
	MAX77686_REG_BUCK3DVS3 = 32,
	MAX77686_REG_BUCK3DVS4 = 33,
	MAX77686_REG_BUCK3DVS5 = 34,
	MAX77686_REG_BUCK3DVS6 = 35,
	MAX77686_REG_BUCK3DVS7 = 36,
	MAX77686_REG_BUCK3DVS8 = 37,
	MAX77686_REG_BUCK4CTRL1 = 38,
	MAX77686_REG_BUCK4DVS1 = 40,
	MAX77686_REG_BUCK4DVS2 = 41,
	MAX77686_REG_BUCK4DVS3 = 42,
	MAX77686_REG_BUCK4DVS4 = 43,
	MAX77686_REG_BUCK4DVS5 = 44,
	MAX77686_REG_BUCK4DVS6 = 45,
	MAX77686_REG_BUCK4DVS7 = 46,
	MAX77686_REG_BUCK4DVS8 = 47,
	MAX77686_REG_BUCK5CTRL = 48,
	MAX77686_REG_BUCK5OUT = 49,
	MAX77686_REG_BUCK6CTRL = 50,
	MAX77686_REG_BUCK6OUT = 51,
	MAX77686_REG_BUCK7CTRL = 52,
	MAX77686_REG_BUCK7OUT = 53,
	MAX77686_REG_BUCK8CTRL = 54,
	MAX77686_REG_BUCK8OUT = 55,
	MAX77686_REG_BUCK9CTRL = 56,
	MAX77686_REG_BUCK9OUT = 57,
	MAX77686_REG_LDO1CTRL1 = 64,
	MAX77686_REG_LDO2CTRL1 = 65,
	MAX77686_REG_LDO3CTRL1 = 66,
	MAX77686_REG_LDO4CTRL1 = 67,
	MAX77686_REG_LDO5CTRL1 = 68,
	MAX77686_REG_LDO6CTRL1 = 69,
	MAX77686_REG_LDO7CTRL1 = 70,
	MAX77686_REG_LDO8CTRL1 = 71,
	MAX77686_REG_LDO9CTRL1 = 72,
	MAX77686_REG_LDO10CTRL1 = 73,
	MAX77686_REG_LDO11CTRL1 = 74,
	MAX77686_REG_LDO12CTRL1 = 75,
	MAX77686_REG_LDO13CTRL1 = 76,
	MAX77686_REG_LDO14CTRL1 = 77,
	MAX77686_REG_LDO15CTRL1 = 78,
	MAX77686_REG_LDO16CTRL1 = 79,
	MAX77686_REG_LDO17CTRL1 = 80,
	MAX77686_REG_LDO18CTRL1 = 81,
	MAX77686_REG_LDO19CTRL1 = 82,
	MAX77686_REG_LDO20CTRL1 = 83,
	MAX77686_REG_LDO21CTRL1 = 84,
	MAX77686_REG_LDO22CTRL1 = 85,
	MAX77686_REG_LDO23CTRL1 = 86,
	MAX77686_REG_LDO24CTRL1 = 87,
	MAX77686_REG_LDO25CTRL1 = 88,
	MAX77686_REG_LDO26CTRL1 = 89,
	MAX77686_REG_LDO1CTRL2 = 96,
	MAX77686_REG_LDO2CTRL2 = 97,
	MAX77686_REG_LDO3CTRL2 = 98,
	MAX77686_REG_LDO4CTRL2 = 99,
	MAX77686_REG_LDO5CTRL2 = 100,
	MAX77686_REG_LDO6CTRL2 = 101,
	MAX77686_REG_LDO7CTRL2 = 102,
	MAX77686_REG_LDO8CTRL2 = 103,
	MAX77686_REG_LDO9CTRL2 = 104,
	MAX77686_REG_LDO10CTRL2 = 105,
	MAX77686_REG_LDO11CTRL2 = 106,
	MAX77686_REG_LDO12CTRL2 = 107,
	MAX77686_REG_LDO13CTRL2 = 108,
	MAX77686_REG_LDO14CTRL2 = 109,
	MAX77686_REG_LDO15CTRL2 = 110,
	MAX77686_REG_LDO16CTRL2 = 111,
	MAX77686_REG_LDO17CTRL2 = 112,
	MAX77686_REG_LDO18CTRL2 = 113,
	MAX77686_REG_LDO19CTRL2 = 114,
	MAX77686_REG_LDO20CTRL2 = 115,
	MAX77686_REG_LDO21CTRL2 = 116,
	MAX77686_REG_LDO22CTRL2 = 117,
	MAX77686_REG_LDO23CTRL2 = 118,
	MAX77686_REG_LDO24CTRL2 = 119,
	MAX77686_REG_LDO25CTRL2 = 120,
	MAX77686_REG_LDO26CTRL2 = 121,
	MAX77686_REG_BBAT_CHG = 126,
	MAX77686_REG_32KHZ = 127,
	MAX77686_REG_PMIC_END = 128,
};

enum max77686_rtc_reg {
	MAX77686_RTC_INT = 0,
	MAX77686_RTC_INTM = 1,
	MAX77686_RTC_CONTROLM = 2,
	MAX77686_RTC_CONTROL = 3,
	MAX77686_RTC_UPDATE0 = 4,
	MAX77686_WTSR_SMPL_CNTL = 6,
	MAX77686_RTC_SEC = 7,
	MAX77686_RTC_MIN = 8,
	MAX77686_RTC_HOUR = 9,
	MAX77686_RTC_WEEKDAY = 10,
	MAX77686_RTC_MONTH = 11,
	MAX77686_RTC_YEAR = 12,
	MAX77686_RTC_MONTHDAY = 13,
	MAX77686_ALARM1_SEC = 14,
	MAX77686_ALARM1_MIN = 15,
	MAX77686_ALARM1_HOUR = 16,
	MAX77686_ALARM1_WEEKDAY = 17,
	MAX77686_ALARM1_MONTH = 18,
	MAX77686_ALARM1_YEAR = 19,
	MAX77686_ALARM1_DATE = 20,
	MAX77686_ALARM2_SEC = 21,
	MAX77686_ALARM2_MIN = 22,
	MAX77686_ALARM2_HOUR = 23,
	MAX77686_ALARM2_WEEKDAY = 24,
	MAX77686_ALARM2_MONTH = 25,
	MAX77686_ALARM2_YEAR = 26,
	MAX77686_ALARM2_DATE = 27,
};

enum max77686_rtc_reg_offset {
	REG_RTC_CONTROLM = 0,
	REG_RTC_CONTROL = 1,
	REG_RTC_UPDATE0 = 2,
	REG_WTSR_SMPL_CNTL = 3,
	REG_RTC_SEC = 4,
	REG_RTC_MIN = 5,
	REG_RTC_HOUR = 6,
	REG_RTC_WEEKDAY = 7,
	REG_RTC_MONTH = 8,
	REG_RTC_YEAR = 9,
	REG_RTC_MONTHDAY = 10,
	REG_ALARM1_SEC = 11,
	REG_ALARM1_MIN = 12,
	REG_ALARM1_HOUR = 13,
	REG_ALARM1_WEEKDAY = 14,
	REG_ALARM1_MONTH = 15,
	REG_ALARM1_YEAR = 16,
	REG_ALARM1_DATE = 17,
	REG_ALARM2_SEC = 18,
	REG_ALARM2_MIN = 19,
	REG_ALARM2_HOUR = 20,
	REG_ALARM2_WEEKDAY = 21,
	REG_ALARM2_MONTH = 22,
	REG_ALARM2_YEAR = 23,
	REG_ALARM2_DATE = 24,
	REG_RTC_AE1 = 25,
	REG_RTC_END = 26,
};

enum max77802_rtc_reg {
	MAX77802_RTC_INT = 192,
	MAX77802_RTC_INTM = 193,
	MAX77802_RTC_CONTROLM = 194,
	MAX77802_RTC_CONTROL = 195,
	MAX77802_RTC_UPDATE0 = 196,
	MAX77802_RTC_UPDATE1 = 197,
	MAX77802_WTSR_SMPL_CNTL = 198,
	MAX77802_RTC_SEC = 199,
	MAX77802_RTC_MIN = 200,
	MAX77802_RTC_HOUR = 201,
	MAX77802_RTC_WEEKDAY = 202,
	MAX77802_RTC_MONTH = 203,
	MAX77802_RTC_YEAR = 204,
	MAX77802_RTC_MONTHDAY = 205,
	MAX77802_RTC_AE1 = 206,
	MAX77802_ALARM1_SEC = 207,
	MAX77802_ALARM1_MIN = 208,
	MAX77802_ALARM1_HOUR = 209,
	MAX77802_ALARM1_WEEKDAY = 210,
	MAX77802_ALARM1_MONTH = 211,
	MAX77802_ALARM1_YEAR = 212,
	MAX77802_ALARM1_DATE = 213,
	MAX77802_RTC_AE2 = 214,
	MAX77802_ALARM2_SEC = 215,
	MAX77802_ALARM2_MIN = 216,
	MAX77802_ALARM2_HOUR = 217,
	MAX77802_ALARM2_WEEKDAY = 218,
	MAX77802_ALARM2_MONTH = 219,
	MAX77802_ALARM2_YEAR = 220,
	MAX77802_ALARM2_DATE = 221,
	MAX77802_RTC_END = 223,
};

enum mctrl_gpio_idx {
	UART_GPIO_CTS = 0,
	UART_GPIO_DSR = 1,
	UART_GPIO_DCD = 2,
	UART_GPIO_RNG = 3,
	UART_GPIO_RI = 3,
	UART_GPIO_RTS = 4,
	UART_GPIO_DTR = 5,
	UART_GPIO_MAX = 6,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
	MEMBLOCK_RSRV_KERN = 32,
	MEMBLOCK_KHO_SCRATCH = 64,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 47,
	MEMCG_SOCK = 48,
	MEMCG_PERCPU_B = 49,
	MEMCG_VMALLOC = 50,
	MEMCG_KMEM = 51,
	MEMCG_ZSWAP_B = 52,
	MEMCG_ZSWAPPED = 53,
	MEMCG_NR_STAT = 54,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mfi_evt_class {
	MFI_EVT_CLASS_DEBUG = -2,
	MFI_EVT_CLASS_PROGRESS = -1,
	MFI_EVT_CLASS_INFO = 0,
	MFI_EVT_CLASS_WARNING = 1,
	MFI_EVT_CLASS_CRITICAL = 2,
	MFI_EVT_CLASS_FATAL = 3,
	MFI_EVT_CLASS_DEAD = 4,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_DAMON = 9,
	MR_TYPES = 10,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum mipi_dsi_compression_algo {
	MIPI_DSI_COMPRESSION_DSC = 0,
	MIPI_DSI_COMPRESSION_VENDOR = 3,
};

enum mipi_dsi_dcs_tear_mode {
	MIPI_DSI_DCS_TEAR_MODE_VBLANK = 0,
	MIPI_DSI_DCS_TEAR_MODE_VHBLANK = 1,
};

enum mipi_dsi_pixel_format {
	MIPI_DSI_FMT_RGB888 = 0,
	MIPI_DSI_FMT_RGB666 = 1,
	MIPI_DSI_FMT_RGB666_PACKED = 2,
	MIPI_DSI_FMT_RGB565 = 3,
};

enum mips_gic_local_interrupt {
	GIC_LOCAL_INT_WD = 0,
	GIC_LOCAL_INT_COMPARE = 1,
	GIC_LOCAL_INT_TIMER = 2,
	GIC_LOCAL_INT_PERFCTR = 3,
	GIC_LOCAL_INT_SWINT0 = 4,
	GIC_LOCAL_INT_SWINT1 = 5,
	GIC_LOCAL_INT_FDC = 6,
	GIC_NUM_LOCAL_INTRS = 7,
};

enum mips_regset {
	REGSET_GPR = 0,
	REGSET_DSP = 1,
	REGSET_FPR = 2,
	REGSET_FP_MODE = 3,
};

enum mm_16c_minor_op {
	mm_lwm16_op = 4,
	mm_swm16_op = 5,
	mm_jr16_op = 12,
	mm_jrc_op = 13,
	mm_jalr16_op = 14,
	mm_jalrs16_op = 15,
	mm_jraddiusp_op = 24,
};

enum mm_32a_minor_op {
	mm_sll32_op = 0,
	mm_ins_op = 12,
	mm_sllv32_op = 16,
	mm_ext_op = 44,
	mm_pool32axf_op = 60,
	mm_srl32_op = 64,
	mm_srlv32_op = 80,
	mm_sra_op = 128,
	mm_srav_op = 144,
	mm_rotr_op = 192,
	mm_lwxs_op = 280,
	mm_addu32_op = 336,
	mm_subu32_op = 464,
	mm_wsbh_op = 492,
	mm_mul_op = 528,
	mm_and_op = 592,
	mm_or32_op = 656,
	mm_xor32_op = 784,
	mm_slt_op = 848,
	mm_sltu_op = 912,
};

enum mm_32axf_minor_op {
	mm_mfc0_op = 3,
	mm_mtc0_op = 11,
	mm_tlbp_op = 13,
	mm_mfhi32_op = 53,
	mm_jalr_op = 60,
	mm_tlbr_op = 77,
	mm_mflo32_op = 117,
	mm_jalrhb_op = 124,
	mm_tlbwi_op = 141,
	mm_mthi32_op = 181,
	mm_tlbwr_op = 205,
	mm_mtlo32_op = 245,
	mm_di_op = 285,
	mm_jalrs_op = 316,
	mm_jalrshb_op = 380,
	mm_sync_op = 429,
	mm_syscall_op = 557,
	mm_wait_op = 589,
	mm_eret_op = 973,
	mm_divu_op = 1500,
};

enum mm_32b_func {
	mm_lwc2_func = 0,
	mm_lwp_func = 1,
	mm_ldc2_func = 2,
	mm_ldp_func = 4,
	mm_lwm32_func = 5,
	mm_cache_func = 6,
	mm_ldm_func = 7,
	mm_swc2_func = 8,
	mm_swp_func = 9,
	mm_sdc2_func = 10,
	mm_sdp_func = 12,
	mm_swm32_func = 13,
	mm_sdm_func = 15,
};

enum mm_32c_func {
	mm_pref_func = 2,
	mm_ll_func = 3,
	mm_swr_func = 9,
	mm_sc_func = 11,
	mm_lwu_func = 14,
};

enum mm_32f_10_minor_op {
	mm_lwxc1_op = 1,
	mm_swxc1_op = 2,
	mm_ldxc1_op = 3,
	mm_sdxc1_op = 4,
	mm_luxc1_op = 5,
	mm_suxc1_op = 6,
};

enum mm_32f_40_minor_op {
	mm_fmovf_op = 0,
	mm_fmovt_op = 1,
};

enum mm_32f_60_minor_op {
	mm_fadd_op = 0,
	mm_fsub_op = 1,
	mm_fmul_op = 2,
	mm_fdiv_op = 3,
};

enum mm_32f_70_minor_op {
	mm_fmovn_op = 0,
	mm_fmovz_op = 1,
};

enum mm_32f_73_minor_op {
	mm_fmov0_op = 1,
	mm_fcvtl_op = 4,
	mm_movf0_op = 5,
	mm_frsqrt_op = 8,
	mm_ffloorl_op = 12,
	mm_fabs0_op = 13,
	mm_fcvtw_op = 36,
	mm_movt0_op = 37,
	mm_fsqrt_op = 40,
	mm_ffloorw_op = 44,
	mm_fneg0_op = 45,
	mm_cfc1_op = 64,
	mm_frecip_op = 72,
	mm_fceill_op = 76,
	mm_fcvtd0_op = 77,
	mm_ctc1_op = 96,
	mm_fceilw_op = 108,
	mm_fcvts0_op = 109,
	mm_mfc1_op = 128,
	mm_fmov1_op = 129,
	mm_movf1_op = 133,
	mm_ftruncl_op = 140,
	mm_fabs1_op = 141,
	mm_mtc1_op = 160,
	mm_movt1_op = 165,
	mm_ftruncw_op = 172,
	mm_fneg1_op = 173,
	mm_mfhc1_op = 192,
	mm_froundl_op = 204,
	mm_fcvtd1_op = 205,
	mm_mthc1_op = 224,
	mm_froundw_op = 236,
	mm_fcvts1_op = 237,
};

enum mm_32f_func {
	mm_lwxc1_func = 72,
	mm_swxc1_func = 136,
	mm_ldxc1_func = 200,
	mm_sdxc1_func = 264,
};

enum mm_32f_minor_op {
	mm_32f_00_op = 0,
	mm_32f_01_op = 1,
	mm_32f_02_op = 2,
	mm_32f_10_op = 8,
	mm_32f_11_op = 9,
	mm_32f_12_op = 10,
	mm_32f_20_op = 16,
	mm_32f_30_op = 24,
	mm_32f_40_op = 32,
	mm_32f_41_op = 33,
	mm_32f_42_op = 34,
	mm_32f_50_op = 40,
	mm_32f_51_op = 41,
	mm_32f_52_op = 42,
	mm_32f_60_op = 48,
	mm_32f_70_op = 56,
	mm_32f_73_op = 59,
	mm_32f_74_op = 60,
};

enum mm_32i_minor_op {
	mm_bltz_op = 0,
	mm_bltzal_op = 1,
	mm_bgez_op = 2,
	mm_bgezal_op = 3,
	mm_blez_op = 4,
	mm_bnezc_op = 5,
	mm_bgtz_op = 6,
	mm_beqzc_op = 7,
	mm_tlti_op = 8,
	mm_tgei_op = 9,
	mm_tltiu_op = 10,
	mm_tgeiu_op = 11,
	mm_tnei_op = 12,
	mm_lui_op = 13,
	mm_teqi_op = 14,
	mm_reserved13_op = 15,
	mm_synci_op = 16,
	mm_bltzals_op = 17,
	mm_reserved14_op = 18,
	mm_bgezals_op = 19,
	mm_bc2f_op = 20,
	mm_bc2t_op = 21,
	mm_reserved15_op = 22,
	mm_reserved16_op = 23,
	mm_reserved17_op = 24,
	mm_reserved18_op = 25,
	mm_bposge64_op = 26,
	mm_bposge32_op = 27,
	mm_bc1f_op = 28,
	mm_bc1t_op = 29,
	mm_reserved19_op = 30,
	mm_reserved20_op = 31,
	mm_bc1any2f_op = 32,
	mm_bc1any2t_op = 33,
	mm_bc1any4f_op = 34,
	mm_bc1any4t_op = 35,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mm_major_op {
	mm_pool32a_op = 0,
	mm_pool16a_op = 1,
	mm_lbu16_op = 2,
	mm_move16_op = 3,
	mm_addi32_op = 4,
	mm_lbu32_op = 5,
	mm_sb32_op = 6,
	mm_lb32_op = 7,
	mm_pool32b_op = 8,
	mm_pool16b_op = 9,
	mm_lhu16_op = 10,
	mm_andi16_op = 11,
	mm_addiu32_op = 12,
	mm_lhu32_op = 13,
	mm_sh32_op = 14,
	mm_lh32_op = 15,
	mm_pool32i_op = 16,
	mm_pool16c_op = 17,
	mm_lwsp16_op = 18,
	mm_pool16d_op = 19,
	mm_ori32_op = 20,
	mm_pool32f_op = 21,
	mm_pool32s_op = 22,
	mm_reserved2_op = 23,
	mm_pool32c_op = 24,
	mm_lwgp16_op = 25,
	mm_lw16_op = 26,
	mm_pool16e_op = 27,
	mm_xori32_op = 28,
	mm_jals32_op = 29,
	mm_addiupc_op = 30,
	mm_reserved3_op = 31,
	mm_reserved4_op = 32,
	mm_pool16f_op = 33,
	mm_sb16_op = 34,
	mm_beqz16_op = 35,
	mm_slti32_op = 36,
	mm_beq32_op = 37,
	mm_swc132_op = 38,
	mm_lwc132_op = 39,
	mm_reserved5_op = 40,
	mm_reserved6_op = 41,
	mm_sh16_op = 42,
	mm_bnez16_op = 43,
	mm_sltiu32_op = 44,
	mm_bne32_op = 45,
	mm_sdc132_op = 46,
	mm_ldc132_op = 47,
	mm_reserved7_op = 48,
	mm_reserved8_op = 49,
	mm_swsp16_op = 50,
	mm_b16_op = 51,
	mm_andi32_op = 52,
	mm_j32_op = 53,
	mm_sd32_op = 54,
	mm_ld32_op = 55,
	mm_reserved11_op = 56,
	mm_reserved12_op = 57,
	mm_sw16_op = 58,
	mm_li16_op = 59,
	mm_jalx32_op = 60,
	mm_jal32_op = 61,
	mm_sw32_op = 62,
	mm_lw32_op = 63,
};

enum mmap_allocation_direction {
	UP = 0,
	DOWN = 1,
};

enum mmc_busy_cmd {
	MMC_BUSY_CMD6 = 0,
	MMC_BUSY_ERASE = 1,
	MMC_BUSY_HPI = 2,
	MMC_BUSY_EXTR_SINGLE = 3,
	MMC_BUSY_IO = 4,
};

enum mmc_drv_op {
	MMC_DRV_OP_IOCTL = 0,
	MMC_DRV_OP_IOCTL_RPMB = 1,
	MMC_DRV_OP_BOOT_WP = 2,
	MMC_DRV_OP_GET_CARD_STATUS = 3,
	MMC_DRV_OP_GET_EXT_CSD = 4,
};

enum mmc_err_stat {
	MMC_ERR_CMD_TIMEOUT = 0,
	MMC_ERR_CMD_CRC = 1,
	MMC_ERR_DAT_TIMEOUT = 2,
	MMC_ERR_DAT_CRC = 3,
	MMC_ERR_AUTO_CMD = 4,
	MMC_ERR_ADMA = 5,
	MMC_ERR_TUNING = 6,
	MMC_ERR_CMDQ_RED = 7,
	MMC_ERR_CMDQ_GCE = 8,
	MMC_ERR_CMDQ_ICCE = 9,
	MMC_ERR_REQ_TIMEOUT = 10,
	MMC_ERR_CMDQ_REQ_TIMEOUT = 11,
	MMC_ERR_ICE_CFG = 12,
	MMC_ERR_CTRL_TIMEOUT = 13,
	MMC_ERR_UNEXPECTED_IRQ = 14,
	MMC_ERR_MAX = 15,
};

enum mmc_issue_type {
	MMC_ISSUE_SYNC = 0,
	MMC_ISSUE_DCMD = 1,
	MMC_ISSUE_ASYNC = 2,
	MMC_ISSUE_MAX = 3,
};

enum mmc_issued {
	MMC_REQ_STARTED = 0,
	MMC_REQ_BUSY = 1,
	MMC_REQ_FAILED_TO_START = 2,
	MMC_REQ_FINISHED = 3,
};

enum mmc_poweroff_type {
	MMC_POWEROFF_SUSPEND = 0,
	MMC_POWEROFF_SHUTDOWN = 1,
	MMC_POWEROFF_UNBIND = 2,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mnt_tree_flags_t {
	MNT_TREE_MOVE = 1,
	MNT_TREE_BENEATH = 2,
	MNT_TREE_PROPAGATION = 4,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum mount_flags {
	MNT_NOSUID = 1,
	MNT_NODEV = 2,
	MNT_NOEXEC = 4,
	MNT_NOATIME = 8,
	MNT_NODIRATIME = 16,
	MNT_RELATIME = 32,
	MNT_READONLY = 64,
	MNT_NOSYMFOLLOW = 128,
	MNT_SHRINKABLE = 256,
	MNT_WRITE_HOLD = 512,
	MNT_SHARED = 4096,
	MNT_UNBINDABLE = 8192,
	MNT_INTERNAL = 16384,
	MNT_LOCK_ATIME = 262144,
	MNT_LOCK_NOEXEC = 524288,
	MNT_LOCK_NOSUID = 1048576,
	MNT_LOCK_NODEV = 2097152,
	MNT_LOCK_READONLY = 4194304,
	MNT_LOCKED = 8388608,
	MNT_DOOMED = 16777216,
	MNT_SYNC_UMOUNT = 33554432,
	MNT_MARKED = 67108864,
	MNT_UMOUNT = 134217728,
	MNT_SHARED_MASK = 8192,
	MNT_USER_SETTABLE_MASK = 255,
	MNT_ATIME_MASK = 56,
	MNT_INTERNAL_FLAGS = 125850112,
};

enum mount_kattr_flags_t {
	MOUNT_KATTR_RECURSE = 1,
	MOUNT_KATTR_IDMAP_REPLACE = 2,
};

enum mountstat {
	MNT_OK = 0,
	MNT_EPERM = 1,
	MNT_ENOENT = 2,
	MNT_EACCES = 13,
	MNT_EINVAL = 22,
};

enum mountstat3 {
	MNT3_OK = 0,
	MNT3ERR_PERM = 1,
	MNT3ERR_NOENT = 2,
	MNT3ERR_IO = 5,
	MNT3ERR_ACCES = 13,
	MNT3ERR_NOTDIR = 20,
	MNT3ERR_INVAL = 22,
	MNT3ERR_NAMETOOLONG = 63,
	MNT3ERR_NOTSUPP = 10004,
	MNT3ERR_SERVERFAULT = 10006,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum mremap_type {
	MREMAP_INVALID = 0,
	MREMAP_NO_RESIZE = 1,
	MREMAP_SHRINK = 2,
	MREMAP_EXPAND = 3,
};

enum msa_elm {
	msa_ctc_op = 62,
	msa_cfc_op = 126,
};

enum msa_func {
	msa_elm_op = 25,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum mt6328_irq_status_numbers {
	MT6328_IRQ_STATUS_PWRKEY = 0,
	MT6328_IRQ_STATUS_HOMEKEY = 1,
	MT6328_IRQ_STATUS_PWRKEY_R = 2,
	MT6328_IRQ_STATUS_HOMEKEY_R = 3,
	MT6328_IRQ_STATUS_THR_H = 4,
	MT6328_IRQ_STATUS_THR_L = 5,
	MT6328_IRQ_STATUS_BAT_H = 6,
	MT6328_IRQ_STATUS_BAT_L = 7,
	MT6328_IRQ_STATUS_RTC = 8,
	MT6328_IRQ_STATUS_AUDIO = 9,
	MT6328_IRQ_STATUS_ACCDET = 10,
	MT6328_IRQ_STATUS_ACCDET_EINT = 11,
	MT6328_IRQ_STATUS_ACCDET_NEGV = 12,
	MT6328_IRQ_STATUS_NI_LBAT_INT = 13,
	MT6328_IRQ_STATUS_VPROC_OC = 16,
	MT6328_IRQ_STATUS_VSYS_OC = 17,
	MT6328_IRQ_STATUS_VLTE_OC = 18,
	MT6328_IRQ_STATUS_VCORE_OC = 19,
	MT6328_IRQ_STATUS_VPA_OC = 20,
	MT6328_IRQ_STATUS_LDO_OC = 21,
	MT6328_IRQ_STATUS_BAT2_H = 22,
	MT6328_IRQ_STATUS_BAT2_L = 23,
	MT6328_IRQ_STATUS_VISMPS0_H = 24,
	MT6328_IRQ_STATUS_VISMPS0_L = 25,
	MT6328_IRQ_STATUS_AUXADC_IMP = 26,
	MT6328_IRQ_STATUS_OV = 32,
	MT6328_IRQ_STATUS_BVALID_DET = 33,
	MT6328_IRQ_STATUS_VBATON_HV = 34,
	MT6328_IRQ_STATUS_VBATON_UNDET = 35,
	MT6328_IRQ_STATUS_WATCHDOG = 36,
	MT6328_IRQ_STATUS_PCHR_CM_VDEC = 37,
	MT6328_IRQ_STATUS_CHRDET = 38,
	MT6328_IRQ_STATUS_PCHR_CM_VINC = 39,
	MT6328_IRQ_STATUS_FG_BAT_H = 40,
	MT6328_IRQ_STATUS_FG_BAT_L = 41,
	MT6328_IRQ_STATUS_FG_CUR_H = 42,
	MT6328_IRQ_STATUS_FG_CUR_L = 43,
	MT6328_IRQ_STATUS_FG_ZCV = 44,
	MT6328_IRQ_STATUS_SPKL_D = 45,
	MT6328_IRQ_STATUS_SPKL_AB = 46,
};

enum mt6331_irq_status_numbers {
	MT6331_IRQ_STATUS_PWRKEY = 0,
	MT6331_IRQ_STATUS_HOMEKEY = 1,
	MT6331_IRQ_STATUS_CHRDET = 2,
	MT6331_IRQ_STATUS_THR_H = 3,
	MT6331_IRQ_STATUS_THR_L = 4,
	MT6331_IRQ_STATUS_BAT_H = 5,
	MT6331_IRQ_STATUS_BAT_L = 6,
	MT6331_IRQ_STATUS_RTC = 7,
	MT6331_IRQ_STATUS_AUDIO = 8,
	MT6331_IRQ_STATUS_MAD = 9,
	MT6331_IRQ_STATUS_ACCDET = 10,
	MT6331_IRQ_STATUS_ACCDET_EINT = 11,
	MT6331_IRQ_STATUS_ACCDET_NEGV = 12,
	MT6331_IRQ_STATUS_VDVFS11_OC = 16,
	MT6331_IRQ_STATUS_VDVFS12_OC = 17,
	MT6331_IRQ_STATUS_VDVFS13_OC = 18,
	MT6331_IRQ_STATUS_VDVFS14_OC = 19,
	MT6331_IRQ_STATUS_GPU_OC = 20,
	MT6331_IRQ_STATUS_VCORE1_OC = 21,
	MT6331_IRQ_STATUS_VCORE2_OC = 22,
	MT6331_IRQ_STATUS_VIO18_OC = 23,
	MT6331_IRQ_STATUS_LDO_OC = 24,
	MT6331_IRQ_STATUS_NR = 25,
};

enum mt6357_irq_numbers {
	MT6357_IRQ_VPROC_OC = 0,
	MT6357_IRQ_VCORE_OC = 1,
	MT6357_IRQ_VMODEM_OC = 2,
	MT6357_IRQ_VS1_OC = 3,
	MT6357_IRQ_VPA_OC = 4,
	MT6357_IRQ_VCORE_PREOC = 5,
	MT6357_IRQ_VFE28_OC = 16,
	MT6357_IRQ_VXO22_OC = 17,
	MT6357_IRQ_VRF18_OC = 18,
	MT6357_IRQ_VRF12_OC = 19,
	MT6357_IRQ_VEFUSE_OC = 20,
	MT6357_IRQ_VCN33_OC = 21,
	MT6357_IRQ_VCN28_OC = 22,
	MT6357_IRQ_VCN18_OC = 23,
	MT6357_IRQ_VCAMA_OC = 24,
	MT6357_IRQ_VCAMD_OC = 25,
	MT6357_IRQ_VCAMIO_OC = 26,
	MT6357_IRQ_VLDO28_OC = 27,
	MT6357_IRQ_VUSB33_OC = 28,
	MT6357_IRQ_VAUX18_OC = 29,
	MT6357_IRQ_VAUD28_OC = 30,
	MT6357_IRQ_VIO28_OC = 31,
	MT6357_IRQ_VIO18_OC = 32,
	MT6357_IRQ_VSRAM_PROC_OC = 33,
	MT6357_IRQ_VSRAM_OTHERS_OC = 34,
	MT6357_IRQ_VIBR_OC = 35,
	MT6357_IRQ_VDRAM_OC = 36,
	MT6357_IRQ_VMC_OC = 37,
	MT6357_IRQ_VMCH_OC = 38,
	MT6357_IRQ_VEMC_OC = 39,
	MT6357_IRQ_VSIM1_OC = 40,
	MT6357_IRQ_VSIM2_OC = 41,
	MT6357_IRQ_PWRKEY = 48,
	MT6357_IRQ_HOMEKEY = 49,
	MT6357_IRQ_PWRKEY_R = 50,
	MT6357_IRQ_HOMEKEY_R = 51,
	MT6357_IRQ_NI_LBAT_INT = 52,
	MT6357_IRQ_CHRDET = 53,
	MT6357_IRQ_CHRDET_EDGE = 54,
	MT6357_IRQ_VCDT_HV_DET = 55,
	MT6357_IRQ_WATCHDOG = 56,
	MT6357_IRQ_VBATON_UNDET = 57,
	MT6357_IRQ_BVALID_DET = 58,
	MT6357_IRQ_OV = 59,
	MT6357_IRQ_RTC = 64,
	MT6357_IRQ_FG_BAT0_H = 80,
	MT6357_IRQ_FG_BAT0_L = 81,
	MT6357_IRQ_FG_CUR_H = 82,
	MT6357_IRQ_FG_CUR_L = 83,
	MT6357_IRQ_FG_ZCV = 84,
	MT6357_IRQ_BATON_LV = 96,
	MT6357_IRQ_BATON_HT = 97,
	MT6357_IRQ_BAT_H = 112,
	MT6357_IRQ_BAT_L = 113,
	MT6357_IRQ_AUXADC_IMP = 114,
	MT6357_IRQ_NAG_C_DLTV = 115,
	MT6357_IRQ_AUDIO = 128,
	MT6357_IRQ_ACCDET = 133,
	MT6357_IRQ_ACCDET_EINT0 = 134,
	MT6357_IRQ_ACCDET_EINT1 = 135,
	MT6357_IRQ_SPI_CMD_ALERT = 144,
	MT6357_IRQ_NR = 145,
};

enum mt6357_irq_top_status_shift {
	MT6357_BUCK_TOP = 0,
	MT6357_LDO_TOP = 1,
	MT6357_PSC_TOP = 2,
	MT6357_SCK_TOP = 3,
	MT6357_BM_TOP = 4,
	MT6357_HK_TOP = 5,
	MT6357_XPP_TOP = 6,
	MT6357_AUD_TOP = 7,
	MT6357_MISC_TOP = 8,
};

enum mt6358_irq_numbers {
	MT6358_IRQ_VPROC11_OC = 0,
	MT6358_IRQ_VPROC12_OC = 1,
	MT6358_IRQ_VCORE_OC = 2,
	MT6358_IRQ_VGPU_OC = 3,
	MT6358_IRQ_VMODEM_OC = 4,
	MT6358_IRQ_VDRAM1_OC = 5,
	MT6358_IRQ_VS1_OC = 6,
	MT6358_IRQ_VS2_OC = 7,
	MT6358_IRQ_VPA_OC = 8,
	MT6358_IRQ_VCORE_PREOC = 9,
	MT6358_IRQ_VFE28_OC = 16,
	MT6358_IRQ_VXO22_OC = 17,
	MT6358_IRQ_VRF18_OC = 18,
	MT6358_IRQ_VRF12_OC = 19,
	MT6358_IRQ_VEFUSE_OC = 20,
	MT6358_IRQ_VCN33_OC = 21,
	MT6358_IRQ_VCN28_OC = 22,
	MT6358_IRQ_VCN18_OC = 23,
	MT6358_IRQ_VCAMA1_OC = 24,
	MT6358_IRQ_VCAMA2_OC = 25,
	MT6358_IRQ_VCAMD_OC = 26,
	MT6358_IRQ_VCAMIO_OC = 27,
	MT6358_IRQ_VLDO28_OC = 28,
	MT6358_IRQ_VA12_OC = 29,
	MT6358_IRQ_VAUX18_OC = 30,
	MT6358_IRQ_VAUD28_OC = 31,
	MT6358_IRQ_VIO28_OC = 32,
	MT6358_IRQ_VIO18_OC = 33,
	MT6358_IRQ_VSRAM_PROC11_OC = 34,
	MT6358_IRQ_VSRAM_PROC12_OC = 35,
	MT6358_IRQ_VSRAM_OTHERS_OC = 36,
	MT6358_IRQ_VSRAM_GPU_OC = 37,
	MT6358_IRQ_VDRAM2_OC = 38,
	MT6358_IRQ_VMC_OC = 39,
	MT6358_IRQ_VMCH_OC = 40,
	MT6358_IRQ_VEMC_OC = 41,
	MT6358_IRQ_VSIM1_OC = 42,
	MT6358_IRQ_VSIM2_OC = 43,
	MT6358_IRQ_VIBR_OC = 44,
	MT6358_IRQ_VUSB_OC = 45,
	MT6358_IRQ_VBIF28_OC = 46,
	MT6358_IRQ_PWRKEY = 48,
	MT6358_IRQ_HOMEKEY = 49,
	MT6358_IRQ_PWRKEY_R = 50,
	MT6358_IRQ_HOMEKEY_R = 51,
	MT6358_IRQ_NI_LBAT_INT = 52,
	MT6358_IRQ_CHRDET = 53,
	MT6358_IRQ_CHRDET_EDGE = 54,
	MT6358_IRQ_VCDT_HV_DET = 55,
	MT6358_IRQ_RTC = 64,
	MT6358_IRQ_FG_BAT0_H = 80,
	MT6358_IRQ_FG_BAT0_L = 81,
	MT6358_IRQ_FG_CUR_H = 82,
	MT6358_IRQ_FG_CUR_L = 83,
	MT6358_IRQ_FG_ZCV = 84,
	MT6358_IRQ_FG_BAT1_H = 85,
	MT6358_IRQ_FG_BAT1_L = 86,
	MT6358_IRQ_FG_N_CHARGE_L = 87,
	MT6358_IRQ_FG_IAVG_H = 88,
	MT6358_IRQ_FG_IAVG_L = 89,
	MT6358_IRQ_FG_TIME_H = 90,
	MT6358_IRQ_FG_DISCHARGE = 91,
	MT6358_IRQ_FG_CHARGE = 92,
	MT6358_IRQ_BATON_LV = 96,
	MT6358_IRQ_BATON_HT = 97,
	MT6358_IRQ_BATON_BAT_IN = 98,
	MT6358_IRQ_BATON_BAT_OUT = 99,
	MT6358_IRQ_BIF = 100,
	MT6358_IRQ_BAT_H = 112,
	MT6358_IRQ_BAT_L = 113,
	MT6358_IRQ_BAT2_H = 114,
	MT6358_IRQ_BAT2_L = 115,
	MT6358_IRQ_BAT_TEMP_H = 116,
	MT6358_IRQ_BAT_TEMP_L = 117,
	MT6358_IRQ_AUXADC_IMP = 118,
	MT6358_IRQ_NAG_C_DLTV = 119,
	MT6358_IRQ_AUDIO = 128,
	MT6358_IRQ_ACCDET = 133,
	MT6358_IRQ_ACCDET_EINT0 = 134,
	MT6358_IRQ_ACCDET_EINT1 = 135,
	MT6358_IRQ_SPI_CMD_ALERT = 144,
	MT6358_IRQ_NR = 145,
};

enum mt6358_irq_top_status_shift {
	MT6358_BUCK_TOP = 0,
	MT6358_LDO_TOP = 1,
	MT6358_PSC_TOP = 2,
	MT6358_SCK_TOP = 3,
	MT6358_BM_TOP = 4,
	MT6358_HK_TOP = 5,
	MT6358_AUD_TOP = 6,
	MT6358_MISC_TOP = 7,
};

enum mt6359_irq_numbers {
	MT6359_IRQ_VCORE_OC = 1,
	MT6359_IRQ_VGPU11_OC = 2,
	MT6359_IRQ_VGPU12_OC = 3,
	MT6359_IRQ_VMODEM_OC = 4,
	MT6359_IRQ_VPROC1_OC = 5,
	MT6359_IRQ_VPROC2_OC = 6,
	MT6359_IRQ_VS1_OC = 7,
	MT6359_IRQ_VS2_OC = 8,
	MT6359_IRQ_VPA_OC = 9,
	MT6359_IRQ_VFE28_OC = 16,
	MT6359_IRQ_VXO22_OC = 17,
	MT6359_IRQ_VRF18_OC = 18,
	MT6359_IRQ_VRF12_OC = 19,
	MT6359_IRQ_VEFUSE_OC = 20,
	MT6359_IRQ_VCN33_1_OC = 21,
	MT6359_IRQ_VCN33_2_OC = 22,
	MT6359_IRQ_VCN13_OC = 23,
	MT6359_IRQ_VCN18_OC = 24,
	MT6359_IRQ_VA09_OC = 25,
	MT6359_IRQ_VCAMIO_OC = 26,
	MT6359_IRQ_VA12_OC = 27,
	MT6359_IRQ_VAUX18_OC = 28,
	MT6359_IRQ_VAUD18_OC = 29,
	MT6359_IRQ_VIO18_OC = 30,
	MT6359_IRQ_VSRAM_PROC1_OC = 31,
	MT6359_IRQ_VSRAM_PROC2_OC = 32,
	MT6359_IRQ_VSRAM_OTHERS_OC = 33,
	MT6359_IRQ_VSRAM_MD_OC = 34,
	MT6359_IRQ_VEMC_OC = 35,
	MT6359_IRQ_VSIM1_OC = 36,
	MT6359_IRQ_VSIM2_OC = 37,
	MT6359_IRQ_VUSB_OC = 38,
	MT6359_IRQ_VRFCK_OC = 39,
	MT6359_IRQ_VBBCK_OC = 40,
	MT6359_IRQ_VBIF28_OC = 41,
	MT6359_IRQ_VIBR_OC = 42,
	MT6359_IRQ_VIO28_OC = 43,
	MT6359_IRQ_VM18_OC = 44,
	MT6359_IRQ_VUFS_OC = 45,
	MT6359_IRQ_PWRKEY = 48,
	MT6359_IRQ_HOMEKEY = 49,
	MT6359_IRQ_PWRKEY_R = 50,
	MT6359_IRQ_HOMEKEY_R = 51,
	MT6359_IRQ_NI_LBAT_INT = 52,
	MT6359_IRQ_CHRDET_EDGE = 53,
	MT6359_IRQ_RTC = 64,
	MT6359_IRQ_FG_BAT_H = 80,
	MT6359_IRQ_FG_BAT_L = 81,
	MT6359_IRQ_FG_CUR_H = 82,
	MT6359_IRQ_FG_CUR_L = 83,
	MT6359_IRQ_FG_ZCV = 84,
	MT6359_IRQ_FG_N_CHARGE_L = 87,
	MT6359_IRQ_FG_IAVG_H = 88,
	MT6359_IRQ_FG_IAVG_L = 89,
	MT6359_IRQ_FG_DISCHARGE = 91,
	MT6359_IRQ_FG_CHARGE = 92,
	MT6359_IRQ_BATON_LV = 96,
	MT6359_IRQ_BATON_BAT_IN = 98,
	MT6359_IRQ_BATON_BAT_OU = 99,
	MT6359_IRQ_BIF = 100,
	MT6359_IRQ_BAT_H = 112,
	MT6359_IRQ_BAT_L = 113,
	MT6359_IRQ_BAT2_H = 114,
	MT6359_IRQ_BAT2_L = 115,
	MT6359_IRQ_BAT_TEMP_H = 116,
	MT6359_IRQ_BAT_TEMP_L = 117,
	MT6359_IRQ_THR_H = 118,
	MT6359_IRQ_THR_L = 119,
	MT6359_IRQ_AUXADC_IMP = 120,
	MT6359_IRQ_NAG_C_DLTV = 121,
	MT6359_IRQ_AUDIO = 128,
	MT6359_IRQ_ACCDET = 133,
	MT6359_IRQ_ACCDET_EINT0 = 134,
	MT6359_IRQ_ACCDET_EINT1 = 135,
	MT6359_IRQ_SPI_CMD_ALERT = 144,
	MT6359_IRQ_NR = 145,
};

enum mt6359_irq_top_status_shift {
	MT6359_BUCK_TOP = 0,
	MT6359_LDO_TOP = 1,
	MT6359_PSC_TOP = 2,
	MT6359_SCK_TOP = 3,
	MT6359_BM_TOP = 4,
	MT6359_HK_TOP = 5,
	MT6359_AUD_TOP = 7,
	MT6359_MISC_TOP = 8,
};

enum mt6397_irq_numbers {
	MT6397_IRQ_SPKL_AB = 0,
	MT6397_IRQ_SPKR_AB = 1,
	MT6397_IRQ_SPKL = 2,
	MT6397_IRQ_SPKR = 3,
	MT6397_IRQ_BAT_L = 4,
	MT6397_IRQ_BAT_H = 5,
	MT6397_IRQ_FG_BAT_L = 6,
	MT6397_IRQ_FG_BAT_H = 7,
	MT6397_IRQ_WATCHDOG = 8,
	MT6397_IRQ_PWRKEY = 9,
	MT6397_IRQ_THR_L = 10,
	MT6397_IRQ_THR_H = 11,
	MT6397_IRQ_VBATON_UNDET = 12,
	MT6397_IRQ_BVALID_DET = 13,
	MT6397_IRQ_CHRDET = 14,
	MT6397_IRQ_OV = 15,
	MT6397_IRQ_LDO = 16,
	MT6397_IRQ_HOMEKEY = 17,
	MT6397_IRQ_ACCDET = 18,
	MT6397_IRQ_AUDIO = 19,
	MT6397_IRQ_RTC = 20,
	MT6397_IRQ_PWRKEY_RSTB = 21,
	MT6397_IRQ_HDMI_SIFM = 22,
	MT6397_IRQ_HDMI_CEC = 23,
	MT6397_IRQ_VCA15 = 24,
	MT6397_IRQ_VSRMCA15 = 25,
	MT6397_IRQ_VCORE = 26,
	MT6397_IRQ_VGPU = 27,
	MT6397_IRQ_VIO18 = 28,
	MT6397_IRQ_VPCA7 = 29,
	MT6397_IRQ_VSRMCA7 = 30,
	MT6397_IRQ_VDRM = 31,
	MT6397_IRQ_NR = 32,
};

enum mtd_file_modes {
	MTD_FILE_MODE_NORMAL = 0,
	MTD_FILE_MODE_OTP_FACTORY = 1,
	MTD_FILE_MODE_OTP_USER = 2,
	MTD_FILE_MODE_RAW = 3,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_ZSWPOUT = 3,
	MTHP_STAT_SWPIN = 4,
	MTHP_STAT_SWPIN_FALLBACK = 5,
	MTHP_STAT_SWPIN_FALLBACK_CHARGE = 6,
	MTHP_STAT_SWPOUT = 7,
	MTHP_STAT_SWPOUT_FALLBACK = 8,
	MTHP_STAT_SHMEM_ALLOC = 9,
	MTHP_STAT_SHMEM_FALLBACK = 10,
	MTHP_STAT_SHMEM_FALLBACK_CHARGE = 11,
	MTHP_STAT_SPLIT = 12,
	MTHP_STAT_SPLIT_FAILED = 13,
	MTHP_STAT_SPLIT_DEFERRED = 14,
	MTHP_STAT_NR_ANON = 15,
	MTHP_STAT_NR_ANON_PARTIALLY_MAPPED = 16,
	__MTHP_STAT_COUNT = 17,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum multu_op {
	multu_multu_op = 0,
	multu_mulu_op = 2,
	multu_muhu_op = 3,
};

enum musb_buf_mode {
	BUF_SINGLE = 0,
	BUF_DOUBLE = 1,
} __attribute__((mode(byte)));

enum musb_fifo_style {
	FIFO_RXTX = 0,
	FIFO_TX = 1,
	FIFO_RX = 2,
} __attribute__((mode(byte)));

enum musb_g_ep0_state {
	MUSB_EP0_STAGE_IDLE = 0,
	MUSB_EP0_STAGE_SETUP = 1,
	MUSB_EP0_STAGE_TX = 2,
	MUSB_EP0_STAGE_RX = 3,
	MUSB_EP0_STAGE_STATUSIN = 4,
	MUSB_EP0_STAGE_STATUSOUT = 5,
	MUSB_EP0_STAGE_ACKWAIT = 6,
} __attribute__((mode(byte)));

enum musb_h_ep0_state {
	MUSB_EP0_IDLE = 0,
	MUSB_EP0_START = 1,
	MUSB_EP0_IN = 2,
	MUSB_EP0_OUT = 3,
	MUSB_EP0_STATUS = 4,
} __attribute__((mode(byte)));

enum musb_mode {
	MUSB_UNDEFINED = 0,
	MUSB_HOST = 1,
	MUSB_PERIPHERAL = 2,
	MUSB_OTG = 3,
};

enum musb_vbus_id_status {
	MUSB_UNKNOWN = 0,
	MUSB_ID_GROUND = 1,
	MUSB_ID_FLOAT = 2,
	MUSB_VBUS_VALID = 3,
	MUSB_VBUS_OFF = 4,
};

enum muxtype {
	pca954x_ismux = 0,
	pca954x_isswi = 1,
};

enum nand_bbt_block_status {
	NAND_BBT_BLOCK_STATUS_UNKNOWN = 0,
	NAND_BBT_BLOCK_GOOD = 1,
	NAND_BBT_BLOCK_WORN = 2,
	NAND_BBT_BLOCK_RESERVED = 3,
	NAND_BBT_BLOCK_FACTORY_BAD = 4,
	NAND_BBT_BLOCK_NUM_STATUS = 5,
};

enum nand_ecc_algo {
	NAND_ECC_ALGO_UNKNOWN = 0,
	NAND_ECC_ALGO_HAMMING = 1,
	NAND_ECC_ALGO_BCH = 2,
	NAND_ECC_ALGO_RS = 3,
};

enum nand_ecc_engine_integration {
	NAND_ECC_ENGINE_INTEGRATION_INVALID = 0,
	NAND_ECC_ENGINE_INTEGRATION_PIPELINED = 1,
	NAND_ECC_ENGINE_INTEGRATION_EXTERNAL = 2,
};

enum nand_ecc_engine_type {
	NAND_ECC_ENGINE_TYPE_INVALID = 0,
	NAND_ECC_ENGINE_TYPE_NONE = 1,
	NAND_ECC_ENGINE_TYPE_SOFT = 2,
	NAND_ECC_ENGINE_TYPE_ON_HOST = 3,
	NAND_ECC_ENGINE_TYPE_ON_DIE = 4,
};

enum nand_ecc_legacy_mode {
	NAND_ECC_INVALID = 0,
	NAND_ECC_NONE = 1,
	NAND_ECC_SOFT = 2,
	NAND_ECC_SOFT_BCH = 3,
	NAND_ECC_HW = 4,
	NAND_ECC_HW_SYNDROME = 5,
	NAND_ECC_ON_DIE = 6,
};

enum nand_ecc_placement {
	NAND_ECC_PLACEMENT_UNKNOWN = 0,
	NAND_ECC_PLACEMENT_OOB = 1,
	NAND_ECC_PLACEMENT_INTERLEAVED = 2,
};

enum nand_interface_type {
	NAND_SDR_IFACE = 0,
	NAND_NVDDR_IFACE = 1,
};

enum nand_op_instr_type {
	NAND_OP_CMD_INSTR = 0,
	NAND_OP_ADDR_INSTR = 1,
	NAND_OP_DATA_IN_INSTR = 2,
	NAND_OP_DATA_OUT_INSTR = 3,
	NAND_OP_WAITRDY_INSTR = 4,
};

enum nand_page_io_req_type {
	NAND_PAGE_READ = 0,
	NAND_PAGE_WRITE = 1,
};

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum net_iov_type {
	NET_IOV_DMABUF = 0,
	NET_IOV_IOURING = 1,
	NET_IOV_MAX = 4294967295,
};

enum net_xmit_qdisc_t {
	__NET_XMIT_STOLEN = 65536,
	__NET_XMIT_BYPASS = 131072,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1,
	IFF_EBRIDGE = 2,
	IFF_BONDING = 4,
	IFF_ISATAP = 8,
	IFF_WAN_HDLC = 16,
	IFF_XMIT_DST_RELEASE = 32,
	IFF_DONT_BRIDGE = 64,
	IFF_DISABLE_NETPOLL = 128,
	IFF_MACVLAN_PORT = 256,
	IFF_BRIDGE_PORT = 512,
	IFF_OVS_DATAPATH = 1024,
	IFF_TX_SKB_SHARING = 2048,
	IFF_UNICAST_FLT = 4096,
	IFF_TEAM_PORT = 8192,
	IFF_SUPP_NOFCS = 16384,
	IFF_LIVE_ADDR_CHANGE = 32768,
	IFF_MACVLAN = 65536,
	IFF_XMIT_DST_RELEASE_PERM = 131072,
	IFF_L3MDEV_MASTER = 262144,
	IFF_NO_QUEUE = 524288,
	IFF_OPENVSWITCH = 1048576,
	IFF_L3MDEV_SLAVE = 2097152,
	IFF_TEAM = 4194304,
	IFF_RXFH_CONFIGURED = 8388608,
	IFF_PHONY_HEADROOM = 16777216,
	IFF_MACSEC = 33554432,
	IFF_NO_RX_HANDLER = 67108864,
	IFF_FAILOVER = 134217728,
	IFF_FAILOVER_SLAVE = 268435456,
	IFF_L3MDEV_RX_HANDLER = 536870912,
	IFF_NO_ADDRCONF = 1073741824,
	IFF_TX_SKB_NO_LINEAR = 2147483648,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
	NETDEV_XSK_FLAGS_TX_LAUNCH_TIME_FIFO = 4,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netfs_collect_contig_trace {
	netfs_contig_trace_collect = 0,
	netfs_contig_trace_jump = 1,
	netfs_contig_trace_unlock = 2,
} __attribute__((mode(byte)));

enum netfs_donate_trace {
	netfs_trace_donate_tail_to_prev = 0,
	netfs_trace_donate_to_prev = 1,
	netfs_trace_donate_to_next = 2,
	netfs_trace_donate_to_deferred_next = 3,
} __attribute__((mode(byte)));

enum netfs_failure {
	netfs_fail_check_write_begin = 0,
	netfs_fail_copy_to_cache = 1,
	netfs_fail_dio_read_short = 2,
	netfs_fail_dio_read_zero = 3,
	netfs_fail_read = 4,
	netfs_fail_short_read = 5,
	netfs_fail_prepare_write = 6,
	netfs_fail_write = 7,
} __attribute__((mode(byte)));

enum netfs_folio_trace {
	netfs_folio_is_uptodate = 0,
	netfs_just_prefetch = 1,
	netfs_whole_folio_modify = 2,
	netfs_modify_and_clear = 3,
	netfs_streaming_write = 4,
	netfs_streaming_write_cont = 5,
	netfs_flush_content = 6,
	netfs_streaming_filled_page = 7,
	netfs_streaming_cont_filled_page = 8,
	netfs_folio_trace_abandon = 9,
	netfs_folio_trace_alloc_buffer = 10,
	netfs_folio_trace_cancel_copy = 11,
	netfs_folio_trace_cancel_store = 12,
	netfs_folio_trace_clear = 13,
	netfs_folio_trace_clear_cc = 14,
	netfs_folio_trace_clear_g = 15,
	netfs_folio_trace_clear_s = 16,
	netfs_folio_trace_copy_to_cache = 17,
	netfs_folio_trace_end_copy = 18,
	netfs_folio_trace_filled_gaps = 19,
	netfs_folio_trace_kill = 20,
	netfs_folio_trace_kill_cc = 21,
	netfs_folio_trace_kill_g = 22,
	netfs_folio_trace_kill_s = 23,
	netfs_folio_trace_mkwrite = 24,
	netfs_folio_trace_mkwrite_plus = 25,
	netfs_folio_trace_not_under_wback = 26,
	netfs_folio_trace_not_locked = 27,
	netfs_folio_trace_put = 28,
	netfs_folio_trace_read = 29,
	netfs_folio_trace_read_done = 30,
	netfs_folio_trace_read_gaps = 31,
	netfs_folio_trace_read_unlock = 32,
	netfs_folio_trace_redirtied = 33,
	netfs_folio_trace_store = 34,
	netfs_folio_trace_store_copy = 35,
	netfs_folio_trace_store_plus = 36,
	netfs_folio_trace_wthru = 37,
	netfs_folio_trace_wthru_plus = 38,
} __attribute__((mode(byte)));

enum netfs_folioq_trace {
	netfs_trace_folioq_alloc_buffer = 0,
	netfs_trace_folioq_clear = 1,
	netfs_trace_folioq_delete = 2,
	netfs_trace_folioq_make_space = 3,
	netfs_trace_folioq_rollbuf_init = 4,
	netfs_trace_folioq_read_progress = 5,
} __attribute__((mode(byte)));

enum netfs_io_origin {
	NETFS_READAHEAD = 0,
	NETFS_READPAGE = 1,
	NETFS_READ_GAPS = 2,
	NETFS_READ_SINGLE = 3,
	NETFS_READ_FOR_WRITE = 4,
	NETFS_UNBUFFERED_READ = 5,
	NETFS_DIO_READ = 6,
	NETFS_WRITEBACK = 7,
	NETFS_WRITEBACK_SINGLE = 8,
	NETFS_WRITETHROUGH = 9,
	NETFS_UNBUFFERED_WRITE = 10,
	NETFS_DIO_WRITE = 11,
	NETFS_PGPRIV2_COPY_TO_CACHE = 12,
	nr__netfs_io_origin = 13,
} __attribute__((mode(byte)));

enum netfs_io_source {
	NETFS_SOURCE_UNKNOWN = 0,
	NETFS_FILL_WITH_ZEROES = 1,
	NETFS_DOWNLOAD_FROM_SERVER = 2,
	NETFS_READ_FROM_CACHE = 3,
	NETFS_INVALID_READ = 4,
	NETFS_UPLOAD_TO_SERVER = 5,
	NETFS_WRITE_TO_CACHE = 6,
} __attribute__((mode(byte)));

enum netfs_read_from_hole {
	NETFS_READ_HOLE_IGNORE = 0,
	NETFS_READ_HOLE_FAIL = 1,
};

enum netfs_read_trace {
	netfs_read_trace_dio_read = 0,
	netfs_read_trace_expanded = 1,
	netfs_read_trace_readahead = 2,
	netfs_read_trace_readpage = 3,
	netfs_read_trace_read_gaps = 4,
	netfs_read_trace_read_single = 5,
	netfs_read_trace_prefetch_for_write = 6,
	netfs_read_trace_write_begin = 7,
} __attribute__((mode(byte)));

enum netfs_rreq_ref_trace {
	netfs_rreq_trace_get_for_outstanding = 0,
	netfs_rreq_trace_get_subreq = 1,
	netfs_rreq_trace_put_complete = 2,
	netfs_rreq_trace_put_discard = 3,
	netfs_rreq_trace_put_failed = 4,
	netfs_rreq_trace_put_no_submit = 5,
	netfs_rreq_trace_put_return = 6,
	netfs_rreq_trace_put_subreq = 7,
	netfs_rreq_trace_put_work_ip = 8,
	netfs_rreq_trace_see_work = 9,
	netfs_rreq_trace_see_work_complete = 10,
	netfs_rreq_trace_new = 11,
} __attribute__((mode(byte)));

enum netfs_rreq_trace {
	netfs_rreq_trace_assess = 0,
	netfs_rreq_trace_collect = 1,
	netfs_rreq_trace_complete = 2,
	netfs_rreq_trace_copy = 3,
	netfs_rreq_trace_dirty = 4,
	netfs_rreq_trace_done = 5,
	netfs_rreq_trace_end_copy_to_cache = 6,
	netfs_rreq_trace_free = 7,
	netfs_rreq_trace_ki_complete = 8,
	netfs_rreq_trace_recollect = 9,
	netfs_rreq_trace_redirty = 10,
	netfs_rreq_trace_resubmit = 11,
	netfs_rreq_trace_set_abandon = 12,
	netfs_rreq_trace_set_pause = 13,
	netfs_rreq_trace_unlock = 14,
	netfs_rreq_trace_unlock_pgpriv2 = 15,
	netfs_rreq_trace_unmark = 16,
	netfs_rreq_trace_unpause = 17,
	netfs_rreq_trace_wait_ip = 18,
	netfs_rreq_trace_wait_pause = 19,
	netfs_rreq_trace_wait_quiesce = 20,
	netfs_rreq_trace_waited_ip = 21,
	netfs_rreq_trace_waited_pause = 22,
	netfs_rreq_trace_waited_quiesce = 23,
	netfs_rreq_trace_wake_ip = 24,
	netfs_rreq_trace_wake_queue = 25,
	netfs_rreq_trace_write_done = 26,
} __attribute__((mode(byte)));

enum netfs_sreq_ref_trace {
	netfs_sreq_trace_get_copy_to_cache = 0,
	netfs_sreq_trace_get_resubmit = 1,
	netfs_sreq_trace_get_submit = 2,
	netfs_sreq_trace_get_short_read = 3,
	netfs_sreq_trace_new = 4,
	netfs_sreq_trace_put_abandon = 5,
	netfs_sreq_trace_put_cancel = 6,
	netfs_sreq_trace_put_clear = 7,
	netfs_sreq_trace_put_consumed = 8,
	netfs_sreq_trace_put_done = 9,
	netfs_sreq_trace_put_failed = 10,
	netfs_sreq_trace_put_merged = 11,
	netfs_sreq_trace_put_no_copy = 12,
	netfs_sreq_trace_put_oom = 13,
	netfs_sreq_trace_put_wip = 14,
	netfs_sreq_trace_put_work = 15,
	netfs_sreq_trace_put_terminated = 16,
} __attribute__((mode(byte)));

enum netfs_sreq_trace {
	netfs_sreq_trace_abandoned = 0,
	netfs_sreq_trace_add_donations = 1,
	netfs_sreq_trace_added = 2,
	netfs_sreq_trace_cache_nowrite = 3,
	netfs_sreq_trace_cache_prepare = 4,
	netfs_sreq_trace_cache_write = 5,
	netfs_sreq_trace_cancel = 6,
	netfs_sreq_trace_clear = 7,
	netfs_sreq_trace_consumed = 8,
	netfs_sreq_trace_discard = 9,
	netfs_sreq_trace_donate_to_prev = 10,
	netfs_sreq_trace_donate_to_next = 11,
	netfs_sreq_trace_download_instead = 12,
	netfs_sreq_trace_fail = 13,
	netfs_sreq_trace_free = 14,
	netfs_sreq_trace_hit_eof = 15,
	netfs_sreq_trace_io_bad = 16,
	netfs_sreq_trace_io_malformed = 17,
	netfs_sreq_trace_io_unknown = 18,
	netfs_sreq_trace_io_progress = 19,
	netfs_sreq_trace_io_req_submitted = 20,
	netfs_sreq_trace_io_retry_needed = 21,
	netfs_sreq_trace_limited = 22,
	netfs_sreq_trace_need_clear = 23,
	netfs_sreq_trace_partial_read = 24,
	netfs_sreq_trace_need_retry = 25,
	netfs_sreq_trace_prepare = 26,
	netfs_sreq_trace_prep_failed = 27,
	netfs_sreq_trace_progress = 28,
	netfs_sreq_trace_reprep_failed = 29,
	netfs_sreq_trace_retry = 30,
	netfs_sreq_trace_short = 31,
	netfs_sreq_trace_split = 32,
	netfs_sreq_trace_submit = 33,
	netfs_sreq_trace_superfluous = 34,
	netfs_sreq_trace_terminated = 35,
	netfs_sreq_trace_wait_for = 36,
	netfs_sreq_trace_write = 37,
	netfs_sreq_trace_write_skip = 38,
	netfs_sreq_trace_write_term = 39,
} __attribute__((mode(byte)));

enum netfs_write_trace {
	netfs_write_trace_copy_to_cache = 0,
	netfs_write_trace_dio_write = 1,
	netfs_write_trace_unbuffered_write = 2,
	netfs_write_trace_writeback = 3,
	netfs_write_trace_writeback_single = 4,
	netfs_write_trace_writethrough = 5,
} __attribute__((mode(byte)));

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netloc_type4 {
	NL4_NAME = 1,
	NL4_URL = 2,
	NL4_NETADDR = 3,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_ECACHE = 4,
	NF_CT_EXT_NUM = 5,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type;

enum nfs3_createmode {
	NFS3_CREATE_UNCHECKED = 0,
	NFS3_CREATE_GUARDED = 1,
	NFS3_CREATE_EXCLUSIVE = 2,
};

enum nfs3_ftype {
	NF3NON = 0,
	NF3REG = 1,
	NF3DIR = 2,
	NF3BLK = 3,
	NF3CHR = 4,
	NF3LNK = 5,
	NF3SOCK = 6,
	NF3FIFO = 7,
	NF3BAD = 8,
};

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

enum nfs4_acl_type {
	NFS4ACL_NONE = 0,
	NFS4ACL_ACL = 1,
	NFS4ACL_DACL = 2,
	NFS4ACL_SACL = 3,
};

enum nfs4_callback_procnum {
	CB_NULL = 0,
	CB_COMPOUND = 1,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

enum nfs4_client_state {
	NFS4CLNT_MANAGER_RUNNING = 0,
	NFS4CLNT_CHECK_LEASE = 1,
	NFS4CLNT_LEASE_EXPIRED = 2,
	NFS4CLNT_RECLAIM_REBOOT = 3,
	NFS4CLNT_RECLAIM_NOGRACE = 4,
	NFS4CLNT_DELEGRETURN = 5,
	NFS4CLNT_SESSION_RESET = 6,
	NFS4CLNT_LEASE_CONFIRM = 7,
	NFS4CLNT_SERVER_SCOPE_MISMATCH = 8,
	NFS4CLNT_PURGE_STATE = 9,
	NFS4CLNT_BIND_CONN_TO_SESSION = 10,
	NFS4CLNT_MOVED = 11,
	NFS4CLNT_LEASE_MOVED = 12,
	NFS4CLNT_DELEGATION_EXPIRED = 13,
	NFS4CLNT_RUN_MANAGER = 14,
	NFS4CLNT_MANAGER_AVAILABLE = 15,
	NFS4CLNT_RECALL_RUNNING = 16,
	NFS4CLNT_RECALL_ANY_LAYOUT_READ = 17,
	NFS4CLNT_RECALL_ANY_LAYOUT_RW = 18,
	NFS4CLNT_DELEGRETURN_DELAYED = 19,
};

enum nfs4_ff_op_type {
	NFS4_FF_OP_LAYOUTSTATS = 0,
	NFS4_FF_OP_LAYOUTRETURN = 1,
};

enum nfs4_open_delegation_type4 {
	NFS4_OPEN_DELEGATE_NONE = 0,
	NFS4_OPEN_DELEGATE_READ = 1,
	NFS4_OPEN_DELEGATE_WRITE = 2,
	NFS4_OPEN_DELEGATE_NONE_EXT = 3,
	NFS4_OPEN_DELEGATE_READ_ATTRS_DELEG = 4,
	NFS4_OPEN_DELEGATE_WRITE_ATTRS_DELEG = 5,
};

enum nfs4_session_state {
	NFS4_SESSION_INITING = 0,
	NFS4_SESSION_ESTABLISHED = 1,
};

enum nfs4_setxattr_options {
	SETXATTR4_EITHER = 0,
	SETXATTR4_CREATE = 1,
	SETXATTR4_REPLACE = 2,
};

enum nfs4_slot_tbl_state {
	NFS4_SLOT_TBL_DRAINING = 0,
};

enum nfs_cb_opnum4 {
	OP_CB_GETATTR = 3,
	OP_CB_RECALL = 4,
	OP_CB_LAYOUTRECALL = 5,
	OP_CB_NOTIFY = 6,
	OP_CB_PUSH_DELEG = 7,
	OP_CB_RECALL_ANY = 8,
	OP_CB_RECALLABLE_OBJ_AVAIL = 9,
	OP_CB_RECALL_SLOT = 10,
	OP_CB_SEQUENCE = 11,
	OP_CB_WANTS_CANCELLED = 12,
	OP_CB_NOTIFY_LOCK = 13,
	OP_CB_NOTIFY_DEVICEID = 14,
	OP_CB_OFFLOAD = 15,
	OP_CB_ILLEGAL = 10044,
};

enum nfs_ftype4 {
	NF4BAD = 0,
	NF4REG = 1,
	NF4DIR = 2,
	NF4BLK = 3,
	NF4CHR = 4,
	NF4LNK = 5,
	NF4SOCK = 6,
	NF4FIFO = 7,
	NF4ATTRDIR = 8,
	NF4NAMEDATTR = 9,
};

enum nfs_lock_status {
	NFS_LOCK_NOT_SET = 0,
	NFS_LOCK_LOCK = 1,
	NFS_LOCK_NOLOCK = 2,
};

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nfs_param {
	Opt_ac = 0,
	Opt_acdirmax = 1,
	Opt_acdirmin = 2,
	Opt_acl___2 = 3,
	Opt_acregmax = 4,
	Opt_acregmin = 5,
	Opt_actimeo = 6,
	Opt_addr = 7,
	Opt_bg = 8,
	Opt_bsize = 9,
	Opt_clientaddr = 10,
	Opt_cto = 11,
	Opt_alignwrite = 12,
	Opt_fatal_neterrors = 13,
	Opt_fg = 14,
	Opt_fscache = 15,
	Opt_fscache_flag = 16,
	Opt_hard = 17,
	Opt_intr = 18,
	Opt_local_lock = 19,
	Opt_lock = 20,
	Opt_lookupcache = 21,
	Opt_migration = 22,
	Opt_minorversion = 23,
	Opt_mountaddr = 24,
	Opt_mounthost = 25,
	Opt_mountport = 26,
	Opt_mountproto = 27,
	Opt_mountvers = 28,
	Opt_namelen = 29,
	Opt_nconnect = 30,
	Opt_max_connect = 31,
	Opt_port___2 = 32,
	Opt_posix = 33,
	Opt_proto = 34,
	Opt_rdirplus = 35,
	Opt_rdirplus_none = 36,
	Opt_rdirplus_force = 37,
	Opt_rdma = 38,
	Opt_resvport = 39,
	Opt_retrans = 40,
	Opt_retry = 41,
	Opt_rsize = 42,
	Opt_sec = 43,
	Opt_sharecache = 44,
	Opt_sloppy = 45,
	Opt_soft = 46,
	Opt_softerr = 47,
	Opt_softreval = 48,
	Opt_source___2 = 49,
	Opt_tcp = 50,
	Opt_timeo = 51,
	Opt_trunkdiscovery = 52,
	Opt_udp = 53,
	Opt_v = 54,
	Opt_vers = 55,
	Opt_wsize = 56,
	Opt_write = 57,
	Opt_xprtsec = 58,
};

enum nfs_stat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_EAGAIN = 11,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,
	NFSERR_WFLUSH = 99,
	NFSERR_BADHANDLE = 10001,
	NFSERR_NOT_SYNC = 10002,
	NFSERR_BAD_COOKIE = 10003,
	NFSERR_NOTSUPP = 10004,
	NFSERR_TOOSMALL = 10005,
	NFSERR_SERVERFAULT = 10006,
	NFSERR_BADTYPE = 10007,
	NFSERR_JUKEBOX = 10008,
	NFSERR_SAME = 10009,
	NFSERR_DENIED = 10010,
	NFSERR_EXPIRED = 10011,
	NFSERR_LOCKED = 10012,
	NFSERR_GRACE = 10013,
	NFSERR_FHEXPIRED = 10014,
	NFSERR_SHARE_DENIED = 10015,
	NFSERR_WRONGSEC = 10016,
	NFSERR_CLID_INUSE = 10017,
	NFSERR_RESOURCE = 10018,
	NFSERR_MOVED = 10019,
	NFSERR_NOFILEHANDLE = 10020,
	NFSERR_MINOR_VERS_MISMATCH = 10021,
	NFSERR_STALE_CLIENTID = 10022,
	NFSERR_STALE_STATEID = 10023,
	NFSERR_OLD_STATEID = 10024,
	NFSERR_BAD_STATEID = 10025,
	NFSERR_BAD_SEQID = 10026,
	NFSERR_NOT_SAME = 10027,
	NFSERR_LOCK_RANGE = 10028,
	NFSERR_SYMLINK = 10029,
	NFSERR_RESTOREFH = 10030,
	NFSERR_LEASE_MOVED = 10031,
	NFSERR_ATTRNOTSUPP = 10032,
	NFSERR_NO_GRACE = 10033,
	NFSERR_RECLAIM_BAD = 10034,
	NFSERR_RECLAIM_CONFLICT = 10035,
	NFSERR_BAD_XDR = 10036,
	NFSERR_LOCKS_HELD = 10037,
	NFSERR_OPENMODE = 10038,
	NFSERR_BADOWNER = 10039,
	NFSERR_BADCHAR = 10040,
	NFSERR_BADNAME = 10041,
	NFSERR_BAD_RANGE = 10042,
	NFSERR_LOCK_NOTSUPP = 10043,
	NFSERR_OP_ILLEGAL = 10044,
	NFSERR_DEADLOCK = 10045,
	NFSERR_FILE_OPEN = 10046,
	NFSERR_ADMIN_REVOKED = 10047,
	NFSERR_CB_PATH_DOWN = 10048,
};

enum nfs_stat_bytecounters {
	NFSIOS_NORMALREADBYTES = 0,
	NFSIOS_NORMALWRITTENBYTES = 1,
	NFSIOS_DIRECTREADBYTES = 2,
	NFSIOS_DIRECTWRITTENBYTES = 3,
	NFSIOS_SERVERREADBYTES = 4,
	NFSIOS_SERVERWRITTENBYTES = 5,
	NFSIOS_READPAGES = 6,
	NFSIOS_WRITEPAGES = 7,
	__NFSIOS_BYTESMAX = 8,
};

enum nfs_stat_eventcounters {
	NFSIOS_INODEREVALIDATE = 0,
	NFSIOS_DENTRYREVALIDATE = 1,
	NFSIOS_DATAINVALIDATE = 2,
	NFSIOS_ATTRINVALIDATE = 3,
	NFSIOS_VFSOPEN = 4,
	NFSIOS_VFSLOOKUP = 5,
	NFSIOS_VFSACCESS = 6,
	NFSIOS_VFSUPDATEPAGE = 7,
	NFSIOS_VFSREADPAGE = 8,
	NFSIOS_VFSREADPAGES = 9,
	NFSIOS_VFSWRITEPAGE = 10,
	NFSIOS_VFSWRITEPAGES = 11,
	NFSIOS_VFSGETDENTS = 12,
	NFSIOS_VFSSETATTR = 13,
	NFSIOS_VFSFLUSH = 14,
	NFSIOS_VFSFSYNC = 15,
	NFSIOS_VFSLOCK = 16,
	NFSIOS_VFSRELEASE = 17,
	NFSIOS_CONGESTIONWAIT = 18,
	NFSIOS_SETATTRTRUNC = 19,
	NFSIOS_EXTENDWRITE = 20,
	NFSIOS_SILLYRENAME = 21,
	NFSIOS_SHORTREAD = 22,
	NFSIOS_SHORTWRITE = 23,
	NFSIOS_DELAY = 24,
	NFSIOS_PNFS_READ = 25,
	NFSIOS_PNFS_WRITE = 26,
	__NFSIOS_COUNTSMAX = 27,
};

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADXDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
	NFS4ERR_BADIOMODE = 10049,
	NFS4ERR_BADLAYOUT = 10050,
	NFS4ERR_BAD_SESSION_DIGEST = 10051,
	NFS4ERR_BADSESSION = 10052,
	NFS4ERR_BADSLOT = 10053,
	NFS4ERR_COMPLETE_ALREADY = 10054,
	NFS4ERR_CONN_NOT_BOUND_TO_SESSION = 10055,
	NFS4ERR_DELEG_ALREADY_WANTED = 10056,
	NFS4ERR_BACK_CHAN_BUSY = 10057,
	NFS4ERR_LAYOUTTRYLATER = 10058,
	NFS4ERR_LAYOUTUNAVAILABLE = 10059,
	NFS4ERR_NOMATCHING_LAYOUT = 10060,
	NFS4ERR_RECALLCONFLICT = 10061,
	NFS4ERR_UNKNOWN_LAYOUTTYPE = 10062,
	NFS4ERR_SEQ_MISORDERED = 10063,
	NFS4ERR_SEQUENCE_POS = 10064,
	NFS4ERR_REQ_TOO_BIG = 10065,
	NFS4ERR_REP_TOO_BIG = 10066,
	NFS4ERR_REP_TOO_BIG_TO_CACHE = 10067,
	NFS4ERR_RETRY_UNCACHED_REP = 10068,
	NFS4ERR_UNSAFE_COMPOUND = 10069,
	NFS4ERR_TOO_MANY_OPS = 10070,
	NFS4ERR_OP_NOT_IN_SESSION = 10071,
	NFS4ERR_HASH_ALG_UNSUPP = 10072,
	NFS4ERR_CLIENTID_BUSY = 10074,
	NFS4ERR_PNFS_IO_HOLE = 10075,
	NFS4ERR_SEQ_FALSE_RETRY = 10076,
	NFS4ERR_BAD_HIGH_SLOT = 10077,
	NFS4ERR_DEADSESSION = 10078,
	NFS4ERR_ENCR_ALG_UNSUPP = 10079,
	NFS4ERR_PNFS_NO_LAYOUT = 10080,
	NFS4ERR_NOT_ONLY_OP = 10081,
	NFS4ERR_WRONG_CRED = 10082,
	NFS4ERR_WRONG_TYPE = 10083,
	NFS4ERR_DIRDELEG_UNAVAIL = 10084,
	NFS4ERR_REJECT_DELEG = 10085,
	NFS4ERR_RETURNCONFLICT = 10086,
	NFS4ERR_DELEG_REVOKED = 10087,
	NFS4ERR_PARTNER_NOTSUPP = 10088,
	NFS4ERR_PARTNER_NO_AUTH = 10089,
	NFS4ERR_UNION_NOTSUPP = 10090,
	NFS4ERR_OFFLOAD_DENIED = 10091,
	NFS4ERR_WRONG_LFS = 10092,
	NFS4ERR_BADLABEL = 10093,
	NFS4ERR_OFFLOAD_NO_REQS = 10094,
	NFS4ERR_NOXATTR = 10095,
	NFS4ERR_XATTR2BIG = 10096,
	NFS4ERR_FIRST_FREE = 10097,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_IOMMU_PAGES = 40,
	NR_SWAPCACHE = 41,
	PGDEMOTE_KSWAPD = 42,
	PGDEMOTE_DIRECT = 43,
	PGDEMOTE_KHUGEPAGED = 44,
	PGDEMOTE_PROACTIVE = 45,
	NR_BALLOON_PAGES = 46,
	NR_VM_NODE_STAT_ITEMS = 47,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum of_gpio_flags {
	OF_GPIO_ACTIVE_LOW = 1,
	OF_GPIO_SINGLE_ENDED = 2,
	OF_GPIO_OPEN_DRAIN = 4,
	OF_GPIO_TRANSITORY = 8,
	OF_GPIO_PULL_UP = 16,
	OF_GPIO_PULL_DOWN = 32,
	OF_GPIO_PULL_DISABLE = 64,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum ohci_rh_state {
	OHCI_RH_HALTED = 0,
	OHCI_RH_SUSPENDED = 1,
	OHCI_RH_RUNNING = 2,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum opcode {
	insn_addiu = 0,
	insn_addu = 1,
	insn_and = 2,
	insn_andi = 3,
	insn_bbit0 = 4,
	insn_bbit1 = 5,
	insn_beq = 6,
	insn_beql = 7,
	insn_bgez = 8,
	insn_bgezl = 9,
	insn_bgtz = 10,
	insn_blez = 11,
	insn_bltz = 12,
	insn_bltzl = 13,
	insn_bne = 14,
	insn_break = 15,
	insn_cache = 16,
	insn_cfc1 = 17,
	insn_cfcmsa = 18,
	insn_ctc1 = 19,
	insn_ctcmsa = 20,
	insn_daddiu = 21,
	insn_daddu = 22,
	insn_ddivu = 23,
	insn_ddivu_r6 = 24,
	insn_di = 25,
	insn_dins = 26,
	insn_dinsm = 27,
	insn_dinsu = 28,
	insn_divu = 29,
	insn_divu_r6 = 30,
	insn_dmfc0 = 31,
	insn_dmodu = 32,
	insn_dmtc0 = 33,
	insn_dmultu = 34,
	insn_dmulu = 35,
	insn_drotr = 36,
	insn_drotr32 = 37,
	insn_dsbh = 38,
	insn_dshd = 39,
	insn_dsll = 40,
	insn_dsll32 = 41,
	insn_dsllv = 42,
	insn_dsra = 43,
	insn_dsra32 = 44,
	insn_dsrav = 45,
	insn_dsrl = 46,
	insn_dsrl32 = 47,
	insn_dsrlv = 48,
	insn_dsubu = 49,
	insn_eret = 50,
	insn_ext = 51,
	insn_ins = 52,
	insn_j = 53,
	insn_jal = 54,
	insn_jalr = 55,
	insn_jr = 56,
	insn_lb = 57,
	insn_lbu = 58,
	insn_ld = 59,
	insn_lddir = 60,
	insn_ldpte = 61,
	insn_ldx = 62,
	insn_lh = 63,
	insn_lhu = 64,
	insn_ll = 65,
	insn_lld = 66,
	insn_lui = 67,
	insn_lw = 68,
	insn_lwu = 69,
	insn_lwx = 70,
	insn_mfc0 = 71,
	insn_mfhc0 = 72,
	insn_mfhi = 73,
	insn_mflo = 74,
	insn_modu = 75,
	insn_movn = 76,
	insn_movz = 77,
	insn_mtc0 = 78,
	insn_mthc0 = 79,
	insn_mthi = 80,
	insn_mtlo = 81,
	insn_mul = 82,
	insn_multu = 83,
	insn_mulu = 84,
	insn_muhu = 85,
	insn_nor = 86,
	insn_or = 87,
	insn_ori = 88,
	insn_pref = 89,
	insn_rfe = 90,
	insn_rotr = 91,
	insn_sb = 92,
	insn_sc = 93,
	insn_scd = 94,
	insn_seleqz = 95,
	insn_selnez = 96,
	insn_sd = 97,
	insn_sh = 98,
	insn_sll = 99,
	insn_sllv = 100,
	insn_slt = 101,
	insn_slti = 102,
	insn_sltiu = 103,
	insn_sltu = 104,
	insn_sra = 105,
	insn_srav = 106,
	insn_srl = 107,
	insn_srlv = 108,
	insn_subu = 109,
	insn_sw = 110,
	insn_sync = 111,
	insn_syscall = 112,
	insn_tlbp = 113,
	insn_tlbr = 114,
	insn_tlbwi = 115,
	insn_tlbwr = 116,
	insn_wait = 117,
	insn_wsbh = 118,
	insn_xor = 119,
	insn_xori = 120,
	insn_yield = 121,
	insn_invalid = 122,
};

enum open_claim_type4 {
	NFS4_OPEN_CLAIM_NULL = 0,
	NFS4_OPEN_CLAIM_PREVIOUS = 1,
	NFS4_OPEN_CLAIM_DELEGATE_CUR = 2,
	NFS4_OPEN_CLAIM_DELEGATE_PREV = 3,
	NFS4_OPEN_CLAIM_FH = 4,
	NFS4_OPEN_CLAIM_DELEG_CUR_FH = 5,
	NFS4_OPEN_CLAIM_DELEG_PREV_FH = 6,
};

enum opentype4 {
	NFS4_OPEN_NOCREATE = 0,
	NFS4_OPEN_CREATE = 1,
};

enum opp_table_access {
	OPP_TABLE_ACCESS_UNKNOWN = 0,
	OPP_TABLE_ACCESS_EXCLUSIVE = 1,
	OPP_TABLE_ACCESS_SHARED = 2,
};

enum orion_mdio_bus_type {
	BUS_TYPE_SMI = 0,
	BUS_TYPE_XSMI = 1,
};

enum ospi_mux_select_type {
	PM_OSPI_MUX_SEL_DMA = 0,
	PM_OSPI_MUX_SEL_LINEAR = 1,
};

enum otg_fsm_timer {
	A_WAIT_VRISE = 0,
	A_WAIT_VFALL = 1,
	A_WAIT_BCON = 2,
	A_AIDL_BDIS = 3,
	B_ASE0_BRST = 4,
	A_BIDL_ADIS = 5,
	B_AIDL_BDIS = 6,
	B_SE0_SRP = 7,
	B_SRP_FAIL = 8,
	A_WAIT_ENUM = 9,
	B_DATA_PLS = 10,
	B_SSEND_SRP = 11,
	NUM_OTG_FSM_TIMERS = 12,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum p9_cache_bits {
	CACHE_NONE = 0,
	CACHE_FILE = 1,
	CACHE_META = 2,
	CACHE_WRITEBACK = 4,
	CACHE_LOOSE = 8,
	CACHE_FSCACHE = 128,
};

enum p9_cache_shortcuts {
	CACHE_SC_NONE = 0,
	CACHE_SC_READAHEAD = 1,
	CACHE_SC_MMAP = 5,
	CACHE_SC_LOOSE = 15,
	CACHE_SC_FSCACHE = 143,
};

enum p9_fid_reftype {
	P9_FID_REF_CREATE = 0,
	P9_FID_REF_GET = 1,
	P9_FID_REF_PUT = 2,
	P9_FID_REF_DESTROY = 3,
} __attribute__((mode(byte)));

enum p9_msg_t {
	P9_TLERROR = 6,
	P9_RLERROR = 7,
	P9_TSTATFS = 8,
	P9_RSTATFS = 9,
	P9_TLOPEN = 12,
	P9_RLOPEN = 13,
	P9_TLCREATE = 14,
	P9_RLCREATE = 15,
	P9_TSYMLINK = 16,
	P9_RSYMLINK = 17,
	P9_TMKNOD = 18,
	P9_RMKNOD = 19,
	P9_TRENAME = 20,
	P9_RRENAME = 21,
	P9_TREADLINK = 22,
	P9_RREADLINK = 23,
	P9_TGETATTR = 24,
	P9_RGETATTR = 25,
	P9_TSETATTR = 26,
	P9_RSETATTR = 27,
	P9_TXATTRWALK = 30,
	P9_RXATTRWALK = 31,
	P9_TXATTRCREATE = 32,
	P9_RXATTRCREATE = 33,
	P9_TREADDIR = 40,
	P9_RREADDIR = 41,
	P9_TFSYNC = 50,
	P9_RFSYNC = 51,
	P9_TLOCK = 52,
	P9_RLOCK = 53,
	P9_TGETLOCK = 54,
	P9_RGETLOCK = 55,
	P9_TLINK = 70,
	P9_RLINK = 71,
	P9_TMKDIR = 72,
	P9_RMKDIR = 73,
	P9_TRENAMEAT = 74,
	P9_RRENAMEAT = 75,
	P9_TUNLINKAT = 76,
	P9_RUNLINKAT = 77,
	P9_TVERSION = 100,
	P9_RVERSION = 101,
	P9_TAUTH = 102,
	P9_RAUTH = 103,
	P9_TATTACH = 104,
	P9_RATTACH = 105,
	P9_TERROR = 106,
	P9_RERROR = 107,
	P9_TFLUSH = 108,
	P9_RFLUSH = 109,
	P9_TWALK = 110,
	P9_RWALK = 111,
	P9_TOPEN = 112,
	P9_ROPEN = 113,
	P9_TCREATE = 114,
	P9_RCREATE = 115,
	P9_TREAD = 116,
	P9_RREAD = 117,
	P9_TWRITE = 118,
	P9_RWRITE = 119,
	P9_TCLUNK = 120,
	P9_RCLUNK = 121,
	P9_TREMOVE = 122,
	P9_RREMOVE = 123,
	P9_TSTAT = 124,
	P9_RSTAT = 125,
	P9_TWSTAT = 126,
	P9_RWSTAT = 127,
};

enum p9_open_mode_t {
	P9_OREAD = 0,
	P9_OWRITE = 1,
	P9_ORDWR = 2,
	P9_OEXEC = 3,
	P9_OTRUNC = 16,
	P9_OREXEC = 32,
	P9_ORCLOSE = 64,
	P9_OAPPEND = 128,
	P9_OEXCL = 4096,
	P9L_MODE_MASK = 8191,
	P9L_DIRECT = 8192,
	P9L_NOWRITECACHE = 16384,
	P9L_LOOSE = 32768,
};

enum p9_perm_t {
	P9_DMDIR = 2147483648,
	P9_DMAPPEND = 1073741824,
	P9_DMEXCL = 536870912,
	P9_DMMOUNT = 268435456,
	P9_DMAUTH = 134217728,
	P9_DMTMP = 67108864,
	P9_DMSYMLINK = 33554432,
	P9_DMLINK = 16777216,
	P9_DMDEVICE = 8388608,
	P9_DMNAMEDPIPE = 2097152,
	P9_DMSOCKET = 1048576,
	P9_DMSETUID = 524288,
	P9_DMSETGID = 262144,
	P9_DMSETVTX = 65536,
};

enum p9_proto_versions {
	p9_proto_legacy = 0,
	p9_proto_2000u = 1,
	p9_proto_2000L = 2,
};

enum p9_req_status_t {
	REQ_STATUS_ALLOC = 0,
	REQ_STATUS_UNSENT = 1,
	REQ_STATUS_SENT = 2,
	REQ_STATUS_RCVD = 3,
	REQ_STATUS_FLSHD = 4,
	REQ_STATUS_ERROR = 5,
};

enum p9_session_flags {
	V9FS_PROTO_2000U = 1,
	V9FS_PROTO_2000L = 2,
	V9FS_ACCESS_SINGLE = 4,
	V9FS_ACCESS_USER = 8,
	V9FS_ACCESS_CLIENT = 16,
	V9FS_POSIX_ACL = 32,
	V9FS_NO_XATTR = 64,
	V9FS_IGNORE_QV = 128,
	V9FS_DIRECT_IO = 256,
	V9FS_SYNC = 512,
};

enum p9_trans_status {
	Connected = 0,
	BeginDisconnect = 1,
	Disconnected = 2,
	Hung = 3,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum packing_op {
	PACK = 0,
	UNPACK = 1,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 4096,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_migrate_skip = 3,
	NR_PAGEBLOCK_BITS = 4,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_owner_priv_1 = 10,
	PG_owner_2 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_reclaim = 16,
	PG_swapbacked = 17,
	PG_unevictable = 18,
	PG_dropbehind = 19,
	PG_mlocked = 20,
	__NR_PAGEFLAGS = 21,
	PG_readahead = 16,
	PG_swapcache = 10,
	PG_checked = 10,
	PG_anon_exclusive = 11,
	PG_mappedtodisk = 11,
	PG_fscache = 15,
	PG_pinned = 10,
	PG_savepinned = 4,
	PG_foreign = 10,
	PG_xen_remapped = 10,
	PG_isolated = 16,
	PG_reported = 3,
	PG_has_hwpoisoned = 8,
	PG_large_rmappable = 9,
	PG_partially_mapped = 16,
};

enum pagetype {
	PGTY_buddy = 240,
	PGTY_offline = 241,
	PGTY_table = 242,
	PGTY_guard = 243,
	PGTY_hugetlb = 244,
	PGTY_slab = 245,
	PGTY_zsmalloc = 246,
	PGTY_unaccepted = 247,
	PGTY_large_kmalloc = 248,
	PGTY_mapcount_underflow = 255,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

enum pca9450_chip_type {
	PCA9450_TYPE_PCA9450A = 0,
	PCA9450_TYPE_PCA9450BC = 1,
	PCA9450_TYPE_PCA9451A = 2,
	PCA9450_TYPE_PCA9452 = 3,
	PCA9450_TYPE_AMOUNT = 4,
};

enum pca_type {
	max_7356 = 0,
	max_7357 = 1,
	max_7358 = 2,
	max_7367 = 3,
	max_7368 = 4,
	max_7369 = 5,
	pca_9540 = 6,
	pca_9542 = 7,
	pca_9543 = 8,
	pca_9544 = 9,
	pca_9545 = 10,
	pca_9546 = 11,
	pca_9547 = 12,
	pca_9548 = 13,
	pca_9846 = 14,
	pca_9847 = 15,
	pca_9848 = 16,
	pca_9849 = 17,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_barno {
	NO_BAR = -1,
	BAR_0 = 0,
	BAR_1 = 1,
	BAR_2 = 2,
	BAR_3 = 3,
	BAR_4 = 4,
	BAR_5 = 5,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
	PCI_DEV_FLAGS_MSIX_TOUCH_ENTRY_DATA_FIRST = 8192,
};

enum pci_dev_reg_1 {
	PCI_Y2_PIG_ENA = -2147483648,
	PCI_Y2_DLL_DIS = 1073741824,
	PCI_SW_PWR_ON_RST = 1073741824,
	PCI_Y2_PHY2_COMA = 536870912,
	PCI_Y2_PHY1_COMA = 268435456,
	PCI_Y2_PHY2_POWD = 134217728,
	PCI_Y2_PHY1_POWD = 67108864,
	PCI_Y2_PME_LEGACY = 32768,
	PCI_PHY_LNK_TIM_MSK = 768,
	PCI_ENA_L1_EVENT = 128,
	PCI_ENA_GPHY_LNK = 64,
	PCI_FORCE_PEX_L1 = 32,
};

enum pci_dev_reg_2 {
	PCI_VPD_WR_THR = -16777216,
	PCI_DEV_SEL = 16646144,
	PCI_VPD_ROM_SZ = 114688,
	PCI_PATCH_DIR = 3840,
	PCI_EXT_PATCHS = 240,
	PCI_EN_DUMMY_RD = 8,
	PCI_REV_DESC = 4,
	PCI_USEDATA64 = 1,
};

enum pci_dev_reg_3 {
	P_CLK_ASF_REGS_DIS = 262144,
	P_CLK_COR_REGS_D0_DIS = 131072,
	P_CLK_MACSEC_DIS = 131072,
	P_CLK_PCI_REGS_D0_DIS = 65536,
	P_CLK_COR_YTB_ARB_DIS = 32768,
	P_CLK_MAC_LNK1_D3_DIS = 16384,
	P_CLK_COR_LNK1_D0_DIS = 8192,
	P_CLK_MAC_LNK1_D0_DIS = 4096,
	P_CLK_COR_LNK1_D3_DIS = 2048,
	P_CLK_PCI_MST_ARB_DIS = 1024,
	P_CLK_COR_REGS_D3_DIS = 512,
	P_CLK_PCI_REGS_D3_DIS = 256,
	P_CLK_REF_LNK1_GM_DIS = 128,
	P_CLK_COR_LNK1_GM_DIS = 64,
	P_CLK_PCI_COMMON_DIS = 32,
	P_CLK_COR_COMMON_DIS = 16,
	P_CLK_PCI_LNK1_BMU_DIS = 8,
	P_CLK_COR_LNK1_BMU_DIS = 4,
	P_CLK_PCI_LNK1_BIU_DIS = 2,
	P_CLK_COR_LNK1_BIU_DIS = 1,
	PCIE_OUR3_WOL_D3_COLD_SET = 406548,
};

enum pci_dev_reg_4 {
	P_PEX_LTSSM_STAT_MSK = -33554432,
	P_PEX_LTSSM_L1_STAT = 52,
	P_PEX_LTSSM_DET_STAT = 1,
	P_TIMER_VALUE_MSK = 16711680,
	P_FORCE_ASPM_REQUEST = 32768,
	P_ASPM_GPHY_LINK_DOWN = 16384,
	P_ASPM_INT_FIFO_EMPTY = 8192,
	P_ASPM_CLKRUN_REQUEST = 4096,
	P_ASPM_FORCE_CLKREQ_ENA = 16,
	P_ASPM_CLKREQ_PAD_CTL = 8,
	P_ASPM_A1_MODE_SELECT = 4,
	P_CLK_GATE_PEX_UNIT_ENA = 2,
	P_CLK_GATE_ROOT_COR_ENA = 1,
	P_ASPM_CONTROL_MSK = 61440,
};

enum pci_dev_reg_5 {
	P_CTL_DIV_CORE_CLK_ENA = -2147483648,
	P_CTL_SRESET_VMAIN_AV = 1073741824,
	P_CTL_BYPASS_VMAIN_AV = 536870912,
	P_CTL_TIM_VMAIN_AV_MSK = 402653184,
	P_REL_PCIE_RST_DE_ASS = 67108864,
	P_REL_GPHY_REC_PACKET = 33554432,
	P_REL_INT_FIFO_N_EMPTY = 16777216,
	P_REL_MAIN_PWR_AVAIL = 8388608,
	P_REL_CLKRUN_REQ_REL = 4194304,
	P_REL_PCIE_RESET_ASS = 2097152,
	P_REL_PME_ASSERTED = 1048576,
	P_REL_PCIE_EXIT_L1_ST = 524288,
	P_REL_LOADER_NOT_FIN = 262144,
	P_REL_PCIE_RX_EX_IDLE = 131072,
	P_REL_GPHY_LINK_UP = 65536,
	P_GAT_PCIE_RST_ASSERTED = 1024,
	P_GAT_GPHY_N_REC_PACKET = 512,
	P_GAT_INT_FIFO_EMPTY = 256,
	P_GAT_MAIN_PWR_N_AVAIL = 128,
	P_GAT_CLKRUN_REQ_REL = 64,
	P_GAT_PCIE_RESET_ASS = 32,
	P_GAT_PME_DE_ASSERTED = 16,
	P_GAT_PCIE_ENTER_L1_ST = 8,
	P_GAT_LOADER_FINISHED = 4,
	P_GAT_PCIE_RX_EL_IDLE = 2,
	P_GAT_GPHY_LINK_DOWN = 1,
	PCIE_OUR5_EVENT_CLK_D3_SET = 50987786,
};

enum pci_epc_bar_type {
	BAR_PROGRAMMABLE = 0,
	BAR_FIXED = 1,
	BAR_RESIZABLE = 2,
	BAR_RESERVED = 3,
};

enum pci_epc_interface_type {
	UNKNOWN_INTERFACE = -1,
	PRIMARY_INTERFACE = 0,
	SECONDARY_INTERFACE = 1,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_interrupt_pin {
	PCI_INTERRUPT_UNKNOWN = 0,
	PCI_INTERRUPT_INTA = 1,
	PCI_INTERRUPT_INTB = 2,
	PCI_INTERRUPT_INTC = 3,
	PCI_INTERRUPT_INTD = 4,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NONE = 1,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 2,
	PCI_P2PDMA_MAP_BUS_ADDR = 3,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 4,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcim_addr_devres_type {
	PCIM_ADDR_DEVRES_TYPE_INVALID = 0,
	PCIM_ADDR_DEVRES_TYPE_REGION = 1,
	PCIM_ADDR_DEVRES_TYPE_REGION_MAPPING = 2,
	PCIM_ADDR_DEVRES_TYPE_MAPPING = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum pedit_cmd {
	TCA_PEDIT_KEY_EX_CMD_SET = 0,
	TCA_PEDIT_KEY_EX_CMD_ADD = 1,
	__PEDIT_CMD_MAX = 2,
};

enum pedit_header_type {
	TCA_PEDIT_KEY_EX_HDR_TYPE_NETWORK = 0,
	TCA_PEDIT_KEY_EX_HDR_TYPE_ETH = 1,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP4 = 2,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP6 = 3,
	TCA_PEDIT_KEY_EX_HDR_TYPE_TCP = 4,
	TCA_PEDIT_KEY_EX_HDR_TYPE_UDP = 5,
	__PEDIT_HDR_TYPE_MAX = 6,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_COUNTERS_SHIFT = 19,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 20,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_mips_regs {
	PERF_REG_MIPS_PC = 0,
	PERF_REG_MIPS_R1 = 1,
	PERF_REG_MIPS_R2 = 2,
	PERF_REG_MIPS_R3 = 3,
	PERF_REG_MIPS_R4 = 4,
	PERF_REG_MIPS_R5 = 5,
	PERF_REG_MIPS_R6 = 6,
	PERF_REG_MIPS_R7 = 7,
	PERF_REG_MIPS_R8 = 8,
	PERF_REG_MIPS_R9 = 9,
	PERF_REG_MIPS_R10 = 10,
	PERF_REG_MIPS_R11 = 11,
	PERF_REG_MIPS_R12 = 12,
	PERF_REG_MIPS_R13 = 13,
	PERF_REG_MIPS_R14 = 14,
	PERF_REG_MIPS_R15 = 15,
	PERF_REG_MIPS_R16 = 16,
	PERF_REG_MIPS_R17 = 17,
	PERF_REG_MIPS_R18 = 18,
	PERF_REG_MIPS_R19 = 19,
	PERF_REG_MIPS_R20 = 20,
	PERF_REG_MIPS_R21 = 21,
	PERF_REG_MIPS_R22 = 22,
	PERF_REG_MIPS_R23 = 23,
	PERF_REG_MIPS_R24 = 24,
	PERF_REG_MIPS_R25 = 25,
	PERF_REG_MIPS_R26 = 26,
	PERF_REG_MIPS_R27 = 27,
	PERF_REG_MIPS_R28 = 28,
	PERF_REG_MIPS_R29 = 29,
	PERF_REG_MIPS_R30 = 30,
	PERF_REG_MIPS_R31 = 31,
	PERF_REG_MIPS_MAX = 32,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -5,
	PERF_EVENT_STATE_REVOKED = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_pmu_scope {
	PERF_PMU_SCOPE_NONE = 0,
	PERF_PMU_SCOPE_CORE = 1,
	PERF_PMU_SCOPE_DIE = 2,
	PERF_PMU_SCOPE_CLUSTER = 3,
	PERF_PMU_SCOPE_PKG = 4,
	PERF_PMU_SCOPE_SYS_WIDE = 5,
	PERF_PMU_MAX_SCOPE = 6,
};

enum perf_probe_config {
	PERF_PROBE_CONFIG_IS_RETPROBE = 1,
	PERF_UPROBE_REF_CTR_OFFSET_BITS = 32,
	PERF_UPROBE_REF_CTR_OFFSET_SHIFT = 32,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pf8x00_buck_states {
	SW_CONFIG1 = 0,
	SW_CONFIG2 = 1,
	SW_PWRUP = 2,
	SW_MODE1 = 3,
	SW_RUN_VOLT = 4,
	SW_STBY_VOLT = 5,
};

enum pf8x00_devid {
	PF8100 = 0,
	PF8121A = 2,
	PF8200 = 8,
};

enum pf8x00_ldo_states {
	LDO_CONFIG1 = 0,
	LDO_CONFIG2 = 1,
	LDO_PWRUP = 2,
	LDO_RUN_VOLT = 3,
	LDO_STBY_VOLT = 4,
};

enum pf8x00_regulators {
	PF8X00_LDO1 = 0,
	PF8X00_LDO2 = 1,
	PF8X00_LDO3 = 2,
	PF8X00_LDO4 = 3,
	PF8X00_BUCK1 = 4,
	PF8X00_BUCK2 = 5,
	PF8X00_BUCK3 = 6,
	PF8X00_BUCK4 = 7,
	PF8X00_BUCK5 = 8,
	PF8X00_BUCK6 = 9,
	PF8X00_BUCK7 = 10,
	PF8X00_VSNVS = 11,
	PF8X00_MAX_REGULATORS = 12,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum pgtable_bits {
	_PAGE_PRESENT_SHIFT = 0,
	_PAGE_NO_READ_SHIFT = 1,
	_PAGE_WRITE_SHIFT = 2,
	_PAGE_ACCESSED_SHIFT = 3,
	_PAGE_MODIFIED_SHIFT = 4,
	_PAGE_SPECIAL_SHIFT = 5,
	_PAGE_GLOBAL_SHIFT = 6,
	_PAGE_VALID_SHIFT = 7,
	_PAGE_DIRTY_SHIFT = 8,
	_CACHE_SHIFT = 9,
};

enum phy_event {
	PHYE_LOSS_OF_SIGNAL = 0,
	PHYE_OOB_DONE = 1,
	PHYE_OOB_ERROR = 2,
	PHYE_SPINUP_HOLD = 3,
	PHYE_RESUME_TIMEOUT = 4,
	PHYE_SHUTDOWN = 5,
	PHY_NUM_EVENTS = 6,
};

enum phy_func {
	PHY_FUNC_NOP = 0,
	PHY_FUNC_LINK_RESET = 1,
	PHY_FUNC_HARD_RESET = 2,
	PHY_FUNC_DISABLE = 3,
	PHY_FUNC_CLEAR_ERROR_LOG = 5,
	PHY_FUNC_CLEAR_AFFIL = 6,
	PHY_FUNC_TX_SATA_PS_SIGNAL = 7,
	PHY_FUNC_RELEASE_SPINUP_HOLD = 16,
	PHY_FUNC_SET_LINK_RATE = 17,
	PHY_FUNC_GET_EVENTS = 18,
};

enum phy_led_modes {
	PHY_LED_ACTIVE_HIGH = 0,
	PHY_LED_ACTIVE_LOW = 1,
	PHY_LED_INACTIVE_HIGH_IMPEDANCE = 2,
	__PHY_LED_MODES_NUM = 3,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
	PHY_MODE_HDMI = 20,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_state_work {
	PHY_STATE_WORK_NONE = 0,
	PHY_STATE_WORK_ANEG = 1,
	PHY_STATE_WORK_SUSPEND = 2,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phy_upstream {
	PHY_UPSTREAM_MAC = 0,
	PHY_UPSTREAM_PHY = 1,
};

enum phylink_op_type {
	PHYLINK_NETDEV = 0,
	PHYLINK_DEV = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum pidcg_event {
	PIDCG_MAX = 0,
	PIDCG_FORKFAIL = 1,
	NR_PIDCG_EVENTS = 2,
};

enum pin_config_param {
	PIN_CONFIG_BIAS_BUS_HOLD = 0,
	PIN_CONFIG_BIAS_DISABLE = 1,
	PIN_CONFIG_BIAS_HIGH_IMPEDANCE = 2,
	PIN_CONFIG_BIAS_PULL_DOWN = 3,
	PIN_CONFIG_BIAS_PULL_PIN_DEFAULT = 4,
	PIN_CONFIG_BIAS_PULL_UP = 5,
	PIN_CONFIG_DRIVE_OPEN_DRAIN = 6,
	PIN_CONFIG_DRIVE_OPEN_SOURCE = 7,
	PIN_CONFIG_DRIVE_PUSH_PULL = 8,
	PIN_CONFIG_DRIVE_STRENGTH = 9,
	PIN_CONFIG_DRIVE_STRENGTH_UA = 10,
	PIN_CONFIG_INPUT_DEBOUNCE = 11,
	PIN_CONFIG_INPUT_ENABLE = 12,
	PIN_CONFIG_INPUT_SCHMITT = 13,
	PIN_CONFIG_INPUT_SCHMITT_ENABLE = 14,
	PIN_CONFIG_INPUT_SCHMITT_UV = 15,
	PIN_CONFIG_MODE_LOW_POWER = 16,
	PIN_CONFIG_MODE_PWM = 17,
	PIN_CONFIG_OUTPUT = 18,
	PIN_CONFIG_OUTPUT_ENABLE = 19,
	PIN_CONFIG_OUTPUT_IMPEDANCE_OHMS = 20,
	PIN_CONFIG_PERSIST_STATE = 21,
	PIN_CONFIG_POWER_SOURCE = 22,
	PIN_CONFIG_SKEW_DELAY = 23,
	PIN_CONFIG_SLEEP_HARDWARE_STATE = 24,
	PIN_CONFIG_SLEW_RATE = 25,
	PIN_CONFIG_END = 127,
	PIN_CONFIG_MAX = 255,
};

enum pinctrl_map_type {
	PIN_MAP_TYPE_INVALID = 0,
	PIN_MAP_TYPE_DUMMY_STATE = 1,
	PIN_MAP_TYPE_MUX_GROUP = 2,
	PIN_MAP_TYPE_CONFIGS_PIN = 3,
	PIN_MAP_TYPE_CONFIGS_GROUP = 4,
};

enum pkcs7_actions {
	ACT_pkcs7_check_content_type = 0,
	ACT_pkcs7_extract_cert = 1,
	ACT_pkcs7_note_OID = 2,
	ACT_pkcs7_note_certificate_list = 3,
	ACT_pkcs7_note_content = 4,
	ACT_pkcs7_note_data = 5,
	ACT_pkcs7_note_signed_info = 6,
	ACT_pkcs7_note_signeddata_version = 7,
	ACT_pkcs7_note_signerinfo_version = 8,
	ACT_pkcs7_sig_note_authenticated_attr = 9,
	ACT_pkcs7_sig_note_digest_algo = 10,
	ACT_pkcs7_sig_note_issuer = 11,
	ACT_pkcs7_sig_note_pkey_algo = 12,
	ACT_pkcs7_sig_note_serial = 13,
	ACT_pkcs7_sig_note_set_of_authattrs = 14,
	ACT_pkcs7_sig_note_signature = 15,
	ACT_pkcs7_sig_note_skid = 16,
	NR__pkcs7_actions = 17,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pm_api_id {
	PM_API_FEATURES = 0,
	PM_GET_API_VERSION = 1,
	PM_REGISTER_NOTIFIER = 5,
	PM_FORCE_POWERDOWN = 8,
	PM_REQUEST_WAKEUP = 10,
	PM_SYSTEM_SHUTDOWN = 12,
	PM_REQUEST_NODE = 13,
	PM_RELEASE_NODE = 14,
	PM_SET_REQUIREMENT = 15,
	PM_RESET_ASSERT = 17,
	PM_RESET_GET_STATUS = 18,
	PM_MMIO_WRITE = 19,
	PM_MMIO_READ = 20,
	PM_PM_INIT_FINALIZE = 21,
	PM_FPGA_LOAD = 22,
	PM_FPGA_GET_STATUS = 23,
	PM_GET_CHIPID = 24,
	PM_SECURE_SHA = 26,
	PM_PINCTRL_REQUEST = 28,
	PM_PINCTRL_RELEASE = 29,
	PM_PINCTRL_SET_FUNCTION = 31,
	PM_PINCTRL_CONFIG_PARAM_GET = 32,
	PM_PINCTRL_CONFIG_PARAM_SET = 33,
	PM_IOCTL = 34,
	PM_QUERY_DATA = 35,
	PM_CLOCK_ENABLE = 36,
	PM_CLOCK_DISABLE = 37,
	PM_CLOCK_GETSTATE = 38,
	PM_CLOCK_SETDIVIDER = 39,
	PM_CLOCK_GETDIVIDER = 40,
	PM_CLOCK_SETPARENT = 43,
	PM_CLOCK_GETPARENT = 44,
	PM_FPGA_READ = 46,
	PM_SECURE_AES = 47,
	PM_EFUSE_ACCESS = 53,
	PM_FEATURE_CHECK = 63,
};

enum pm_gem_config_type {
	GEM_CONFIG_SGMII_MODE = 1,
	GEM_CONFIG_FIXED = 2,
};

enum pm_ioctl_id {
	IOCTL_GET_RPU_OPER_MODE = 0,
	IOCTL_SET_RPU_OPER_MODE = 1,
	IOCTL_RPU_BOOT_ADDR_CONFIG = 2,
	IOCTL_TCM_COMB_CONFIG = 3,
	IOCTL_SET_TAPDELAY_BYPASS = 4,
	IOCTL_SD_DLL_RESET = 6,
	IOCTL_SET_SD_TAPDELAY = 7,
	IOCTL_SET_PLL_FRAC_MODE = 8,
	IOCTL_GET_PLL_FRAC_MODE = 9,
	IOCTL_SET_PLL_FRAC_DATA = 10,
	IOCTL_GET_PLL_FRAC_DATA = 11,
	IOCTL_WRITE_GGS = 12,
	IOCTL_READ_GGS = 13,
	IOCTL_WRITE_PGGS = 14,
	IOCTL_READ_PGGS = 15,
	IOCTL_SET_BOOT_HEALTH_STATUS = 17,
	IOCTL_OSPI_MUX_SELECT = 21,
	IOCTL_REGISTER_SGI = 25,
	IOCTL_SET_FEATURE_CONFIG = 26,
	IOCTL_GET_FEATURE_CONFIG = 27,
	IOCTL_READ_REG = 28,
	IOCTL_SET_SD_CONFIG = 30,
	IOCTL_SET_GEM_CONFIG = 31,
	IOCTL_GET_QOS = 34,
};

enum pm_node_id {
	NODE_SD_0 = 39,
	NODE_SD_1 = 40,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pm_sd_config_type {
	SD_CONFIG_EMMC_SEL = 1,
	SD_CONFIG_BASECLK = 2,
	SD_CONFIG_8BIT = 3,
	SD_CONFIG_FIXED = 4,
};

enum pmic_id {
	TPS65214 = 0,
	TPS65215 = 1,
	TPS65219 = 2,
};

enum pnfs_iomode {
	IOMODE_READ = 1,
	IOMODE_RW = 2,
	IOMODE_ANY = 3,
};

enum pnfs_layout_destroy_mode {
	PNFS_LAYOUT_INVALIDATE = 0,
	PNFS_LAYOUT_BULK_RETURN = 1,
	PNFS_LAYOUT_FILE_BULK_RETURN = 2,
};

enum pnfs_layoutreturn_type {
	RETURN_FILE = 1,
	RETURN_FSID = 2,
	RETURN_ALL = 3,
};

enum pnfs_layouttype {
	LAYOUT_NFSV4_1_FILES = 1,
	LAYOUT_OSD2_OBJECTS = 2,
	LAYOUT_BLOCK_VOLUME = 3,
	LAYOUT_FLEX_FILES = 4,
	LAYOUT_SCSI = 5,
	LAYOUT_TYPE_MAX = 6,
};

enum pnfs_notify_deviceid_type4 {
	NOTIFY_DEVICEID4_CHANGE = 2,
	NOTIFY_DEVICEID4_DELETE = 4,
};

enum pnfs_try_status {
	PNFS_ATTEMPTED = 0,
	PNFS_NOT_ATTEMPTED = 1,
	PNFS_TRY_AGAIN = 2,
};

enum pnfs_update_layout_reason {
	PNFS_UPDATE_LAYOUT_UNKNOWN = 0,
	PNFS_UPDATE_LAYOUT_NO_PNFS = 1,
	PNFS_UPDATE_LAYOUT_RD_ZEROLEN = 2,
	PNFS_UPDATE_LAYOUT_MDSTHRESH = 3,
	PNFS_UPDATE_LAYOUT_NOMEM = 4,
	PNFS_UPDATE_LAYOUT_BULK_RECALL = 5,
	PNFS_UPDATE_LAYOUT_IO_TEST_FAIL = 6,
	PNFS_UPDATE_LAYOUT_FOUND_CACHED = 7,
	PNFS_UPDATE_LAYOUT_RETURN = 8,
	PNFS_UPDATE_LAYOUT_RETRY = 9,
	PNFS_UPDATE_LAYOUT_BLOCKED = 10,
	PNFS_UPDATE_LAYOUT_INVALID_OPEN = 11,
	PNFS_UPDATE_LAYOUT_SEND_LAYOUTGET = 12,
	PNFS_UPDATE_LAYOUT_EXIT = 13,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port_event {
	PORTE_BYTES_DMAED = 0,
	PORTE_BROADCAST_RCVD = 1,
	PORTE_LINK_RESET_ERR = 2,
	PORTE_TIMER_EVENT = 3,
	PORTE_HARD_RESET = 4,
	PORT_NUM_EVENTS = 5,
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum posix_timer_state {
	POSIX_TIMER_DISARMED = 0,
	POSIX_TIMER_ARMED = 1,
	POSIX_TIMER_REQUEUE_PENDING = 2,
};

enum power_desc_param_offset {
	PWR_DESC_LEN = 0,
	PWR_DESC_TYPE = 1,
	PWR_DESC_ACTIVE_LVLS_VCC_0 = 2,
	PWR_DESC_ACTIVE_LVLS_VCCQ_0 = 34,
	PWR_DESC_ACTIVE_LVLS_VCCQ2_0 = 66,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE_AWAKE = 2,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 3,
};

enum power_supply_charge_type {
	POWER_SUPPLY_CHARGE_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_CHARGE_TYPE_NONE = 1,
	POWER_SUPPLY_CHARGE_TYPE_TRICKLE = 2,
	POWER_SUPPLY_CHARGE_TYPE_FAST = 3,
	POWER_SUPPLY_CHARGE_TYPE_STANDARD = 4,
	POWER_SUPPLY_CHARGE_TYPE_ADAPTIVE = 5,
	POWER_SUPPLY_CHARGE_TYPE_CUSTOM = 6,
	POWER_SUPPLY_CHARGE_TYPE_LONGLIFE = 7,
	POWER_SUPPLY_CHARGE_TYPE_BYPASS = 8,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_CHARGE_TYPES = 2,
	POWER_SUPPLY_PROP_HEALTH = 3,
	POWER_SUPPLY_PROP_PRESENT = 4,
	POWER_SUPPLY_PROP_ONLINE = 5,
	POWER_SUPPLY_PROP_AUTHENTIC = 6,
	POWER_SUPPLY_PROP_TECHNOLOGY = 7,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 12,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 13,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 14,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 15,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 16,
	POWER_SUPPLY_PROP_CURRENT_MAX = 17,
	POWER_SUPPLY_PROP_CURRENT_NOW = 18,
	POWER_SUPPLY_PROP_CURRENT_AVG = 19,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 20,
	POWER_SUPPLY_PROP_POWER_NOW = 21,
	POWER_SUPPLY_PROP_POWER_AVG = 22,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 24,
	POWER_SUPPLY_PROP_CHARGE_FULL = 25,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 26,
	POWER_SUPPLY_PROP_CHARGE_NOW = 27,
	POWER_SUPPLY_PROP_CHARGE_AVG = 28,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 32,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 37,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 38,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 40,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 41,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 43,
	POWER_SUPPLY_PROP_ENERGY_FULL = 44,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 45,
	POWER_SUPPLY_PROP_ENERGY_NOW = 46,
	POWER_SUPPLY_PROP_ENERGY_AVG = 47,
	POWER_SUPPLY_PROP_CAPACITY = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 49,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 50,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 51,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 52,
	POWER_SUPPLY_PROP_TEMP = 53,
	POWER_SUPPLY_PROP_TEMP_MAX = 54,
	POWER_SUPPLY_PROP_TEMP_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 56,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 59,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 61,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 63,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 64,
	POWER_SUPPLY_PROP_TYPE = 65,
	POWER_SUPPLY_PROP_USB_TYPE = 66,
	POWER_SUPPLY_PROP_SCOPE = 67,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 68,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 69,
	POWER_SUPPLY_PROP_CALIBRATE = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 72,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 73,
	POWER_SUPPLY_PROP_MODEL_NAME = 74,
	POWER_SUPPLY_PROP_MANUFACTURER = 75,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 76,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum power_supply_usb_type {
	POWER_SUPPLY_USB_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_USB_TYPE_SDP = 1,
	POWER_SUPPLY_USB_TYPE_DCP = 2,
	POWER_SUPPLY_USB_TYPE_CDP = 3,
	POWER_SUPPLY_USB_TYPE_ACA = 4,
	POWER_SUPPLY_USB_TYPE_C = 5,
	POWER_SUPPLY_USB_TYPE_PD = 6,
	POWER_SUPPLY_USB_TYPE_PD_DRP = 7,
	POWER_SUPPLY_USB_TYPE_PD_PPS = 8,
	POWER_SUPPLY_USB_TYPE_APPLE_BRICK_ID = 9,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

enum printk_info_flags {
	LOG_FORCE_CON = 1,
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum priv_stack_mode {
	PRIV_STACK_UNKNOWN = 0,
	NO_PRIV_STACK = 1,
	PRIV_STACK_ADAPTIVE = 2,
};

enum probe_print_type {
	PROBE_PRINT_NORMAL = 0,
	PROBE_PRINT_RETURN = 1,
	PROBE_PRINT_EVENT = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_mem_force {
	PROC_MEM_FORCE_ALWAYS = 0,
	PROC_MEM_FORCE_PTRACE = 1,
	PROC_MEM_FORCE_NEVER = 2,
};

enum proc_param {
	Opt_gid___6 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum procmap_query_flags {
	PROCMAP_QUERY_VMA_READABLE = 1,
	PROCMAP_QUERY_VMA_WRITABLE = 2,
	PROCMAP_QUERY_VMA_EXECUTABLE = 4,
	PROCMAP_QUERY_VMA_SHARED = 8,
	PROCMAP_QUERY_COVERING_OR_NEXT_VMA = 16,
	PROCMAP_QUERY_FILE_BACKED_VMA = 32,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
	PERR_ACCESS = 9,
	PERR_REMOTE = 10,
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

enum psmouse_scale {
	PSMOUSE_SCALE11 = 0,
	PSMOUSE_SCALE21 = 1,
};

enum psmouse_state {
	PSMOUSE_IGNORE = 0,
	PSMOUSE_INITIALIZING = 1,
	PSMOUSE_RESYNCING = 2,
	PSMOUSE_CMD_MODE = 3,
	PSMOUSE_ACTIVATED = 4,
};

enum psmouse_type {
	PSMOUSE_NONE = 0,
	PSMOUSE_PS2 = 1,
	PSMOUSE_PS2PP = 2,
	PSMOUSE_THINKPS = 3,
	PSMOUSE_GENPS = 4,
	PSMOUSE_IMPS = 5,
	PSMOUSE_IMEX = 6,
	PSMOUSE_SYNAPTICS = 7,
	PSMOUSE_ALPS = 8,
	PSMOUSE_LIFEBOOK = 9,
	PSMOUSE_TRACKPOINT = 10,
	PSMOUSE_TOUCHKIT_PS2 = 11,
	PSMOUSE_CORTRON = 12,
	PSMOUSE_HGPK = 13,
	PSMOUSE_ELANTECH = 14,
	PSMOUSE_FSP = 15,
	PSMOUSE_SYNAPTICS_RELATIVE = 16,
	PSMOUSE_CYPRESS = 17,
	PSMOUSE_FOCALTECH = 18,
	PSMOUSE_VMMOUSE = 19,
	PSMOUSE_BYD = 20,
	PSMOUSE_SYNAPTICS_SMBUS = 21,
	PSMOUSE_ELANTECH_SMBUS = 22,
	PSMOUSE_AUTO = 23,
};

enum pstore_type_id {
	PSTORE_TYPE_DMESG = 0,
	PSTORE_TYPE_MCE = 1,
	PSTORE_TYPE_CONSOLE = 2,
	PSTORE_TYPE_FTRACE = 3,
	PSTORE_TYPE_PPC_RTAS = 4,
	PSTORE_TYPE_PPC_OF = 5,
	PSTORE_TYPE_PPC_COMMON = 6,
	PSTORE_TYPE_PMSG = 7,
	PSTORE_TYPE_PPC_OPAL = 8,
	PSTORE_TYPE_MAX = 9,
};

enum pt_watch_style {
	pt_watch_style_mips32 = 0,
	pt_watch_style_mips64 = 1,
};

enum ptp_clock_events {
	PTP_CLOCK_ALARM = 0,
	PTP_CLOCK_EXTTS = 1,
	PTP_CLOCK_EXTOFF = 2,
	PTP_CLOCK_PPS = 3,
	PTP_CLOCK_PPSUSR = 4,
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

enum ptw_func {
	lwdir_op = 0,
	lwpte_op = 1,
	lddir_op = 2,
	ldpte_op = 3,
};

enum pwm_polarity {
	PWM_POLARITY_NORMAL = 0,
	PWM_POLARITY_INVERSED = 1,
};

enum qdisc_class_ops_flags {
	QDISC_CLASS_OPS_DOIT_UNLOCKED = 1,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum query_opcode {
	UPIU_QUERY_OPCODE_NOP = 0,
	UPIU_QUERY_OPCODE_READ_DESC = 1,
	UPIU_QUERY_OPCODE_WRITE_DESC = 2,
	UPIU_QUERY_OPCODE_READ_ATTR = 3,
	UPIU_QUERY_OPCODE_WRITE_ATTR = 4,
	UPIU_QUERY_OPCODE_READ_FLAG = 5,
	UPIU_QUERY_OPCODE_SET_FLAG = 6,
	UPIU_QUERY_OPCODE_CLEAR_FLAG = 7,
	UPIU_QUERY_OPCODE_TOGGLE_FLAG = 8,
};

enum queue_mode {
	QUEUE_MODE_STRICT_PRIORITY = 0,
	QUEUE_MODE_STREAM_RESERVATION = 1,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum ramfs_param {
	Opt_mode___4 = 0,
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
};

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_nl_dev_type {
	RDMA_DEVICE_TYPE_SMI = 1,
};

enum rdma_nl_name_assign_type {
	RDMA_NAME_ASSIGN_TYPE_UNKNOWN = 0,
	RDMA_NAME_ASSIGN_TYPE_USER = 1,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_MAX = 8,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum ref_state_type {
	REF_TYPE_PTR = 2,
	REF_TYPE_IRQ = 4,
	REF_TYPE_LOCK = 8,
	REF_TYPE_RES_LOCK = 16,
	REF_TYPE_RES_LOCK_IRQ = 32,
	REF_TYPE_LOCK_MASK = 56,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

enum regex_type {
	MATCH_FULL = 0,
	MATCH_FRONT_ONLY = 1,
	MATCH_MIDDLE_ONLY = 2,
	MATCH_END_ONLY = 3,
	MATCH_GLOB = 4,
	MATCH_INDEX = 5,
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

enum regulator_active_discharge {
	REGULATOR_ACTIVE_DISCHARGE_DEFAULT = 0,
	REGULATOR_ACTIVE_DISCHARGE_DISABLE = 1,
	REGULATOR_ACTIVE_DISCHARGE_ENABLE = 2,
};

enum regulator_detection_severity {
	REGULATOR_SEVERITY_PROT = 0,
	REGULATOR_SEVERITY_ERR = 1,
	REGULATOR_SEVERITY_WARN = 2,
};

enum regulator_get_type {
	NORMAL_GET = 0,
	EXCLUSIVE_GET = 1,
	OPTIONAL_GET = 2,
	MAX_GET_TYPE = 3,
};

enum regulator_status {
	REGULATOR_STATUS_OFF = 0,
	REGULATOR_STATUS_ON = 1,
	REGULATOR_STATUS_ERROR = 2,
	REGULATOR_STATUS_FAST = 3,
	REGULATOR_STATUS_NORMAL = 4,
	REGULATOR_STATUS_IDLE = 5,
	REGULATOR_STATUS_STANDBY = 6,
	REGULATOR_STATUS_BYPASS = 7,
	REGULATOR_STATUS_UNDEFINED = 8,
};

enum regulator_type {
	REGULATOR_VOLTAGE = 0,
	REGULATOR_CURRENT = 1,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_ATOMIC = 27,
	__REQ_NOUNMAP = 28,
	__REQ_NR_BITS = 29,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 12,
	REQ_OP_ZONE_RESET = 13,
	REQ_OP_ZONE_RESET_ALL = 15,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum resctrl_conf_type {
	CDP_NONE = 0,
	CDP_CODE = 1,
	CDP_DATA = 2,
};

enum reset_control_flags {
	RESET_CONTROL_EXCLUSIVE = 4,
	RESET_CONTROL_EXCLUSIVE_DEASSERTED = 12,
	RESET_CONTROL_EXCLUSIVE_RELEASED = 0,
	RESET_CONTROL_SHARED = 1,
	RESET_CONTROL_SHARED_DEASSERTED = 9,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE = 6,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_DEASSERTED = 14,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_RELEASED = 2,
	RESET_CONTROL_OPTIONAL_SHARED = 3,
	RESET_CONTROL_OPTIONAL_SHARED_DEASSERTED = 11,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum rgmii_clock_delay {
	RGMII_CLK_DELAY_0_2_NS = 0,
	RGMII_CLK_DELAY_0_8_NS = 1,
	RGMII_CLK_DELAY_1_1_NS = 2,
	RGMII_CLK_DELAY_1_7_NS = 3,
	RGMII_CLK_DELAY_2_0_NS = 4,
	RGMII_CLK_DELAY_2_3_NS = 5,
	RGMII_CLK_DELAY_2_6_NS = 6,
	RGMII_CLK_DELAY_3_4_NS = 7,
};

enum ring_buffer_flags {
	RB_FL_OVERWRITE = 1,
};

enum ring_buffer_type {
	RINGBUF_TYPE_DATA_TYPE_LEN_MAX = 28,
	RINGBUF_TYPE_PADDING = 29,
	RINGBUF_TYPE_TIME_EXTEND = 30,
	RINGBUF_TYPE_TIME_STAMP = 31,
};

enum rk3x_i2c_state {
	STATE_IDLE___2 = 0,
	STATE_START = 1,
	STATE_READ = 2,
	STATE_WRITE = 3,
	STATE_STOP = 4,
};

enum rk805_reg {
	RK805_ID_DCDC1 = 0,
	RK805_ID_DCDC2 = 1,
	RK805_ID_DCDC3 = 2,
	RK805_ID_DCDC4 = 3,
	RK805_ID_LDO1 = 4,
	RK805_ID_LDO2 = 5,
	RK805_ID_LDO3 = 6,
};

enum rk806_irqs {
	RK806_IRQ_PWRON_FALL = 0,
	RK806_IRQ_PWRON_RISE = 1,
	RK806_IRQ_PWRON = 2,
	RK806_IRQ_PWRON_LP = 3,
	RK806_IRQ_HOTDIE = 4,
	RK806_IRQ_VDC_RISE = 5,
	RK806_IRQ_VDC_FALL = 6,
	RK806_IRQ_VB_LO = 7,
	RK806_IRQ_REV0 = 8,
	RK806_IRQ_REV1 = 9,
	RK806_IRQ_REV2 = 10,
	RK806_IRQ_CRC_ERROR = 11,
	RK806_IRQ_SLP3_GPIO = 12,
	RK806_IRQ_SLP2_GPIO = 13,
	RK806_IRQ_SLP1_GPIO = 14,
	RK806_IRQ_WDT = 15,
};

enum rk806_reg_id {
	RK806_ID_DCDC1 = 0,
	RK806_ID_DCDC2 = 1,
	RK806_ID_DCDC3 = 2,
	RK806_ID_DCDC4 = 3,
	RK806_ID_DCDC5 = 4,
	RK806_ID_DCDC6 = 5,
	RK806_ID_DCDC7 = 6,
	RK806_ID_DCDC8 = 7,
	RK806_ID_DCDC9 = 8,
	RK806_ID_DCDC10 = 9,
	RK806_ID_NLDO1 = 10,
	RK806_ID_NLDO2 = 11,
	RK806_ID_NLDO3 = 12,
	RK806_ID_NLDO4 = 13,
	RK806_ID_NLDO5 = 14,
	RK806_ID_PLDO1 = 15,
	RK806_ID_PLDO2 = 16,
	RK806_ID_PLDO3 = 17,
	RK806_ID_PLDO4 = 18,
	RK806_ID_PLDO5 = 19,
	RK806_ID_PLDO6 = 20,
	RK806_ID_END = 21,
};

enum rk808_reg {
	RK808_ID_DCDC1 = 0,
	RK808_ID_DCDC2 = 1,
	RK808_ID_DCDC3 = 2,
	RK808_ID_DCDC4 = 3,
	RK808_ID_LDO1 = 4,
	RK808_ID_LDO2 = 5,
	RK808_ID_LDO3 = 6,
	RK808_ID_LDO4 = 7,
	RK808_ID_LDO5 = 8,
	RK808_ID_LDO6 = 9,
	RK808_ID_LDO7 = 10,
	RK808_ID_LDO8 = 11,
	RK808_ID_SWITCH1 = 12,
	RK808_ID_SWITCH2 = 13,
};

enum rk809_reg_id {
	RK809_ID_DCDC5 = 13,
	RK809_ID_SW1 = 14,
	RK809_ID_SW2 = 15,
	RK809_NUM_REGULATORS = 16,
};

enum rk816_irqs {
	RK816_IRQ_PWRON_FALL = 0,
	RK816_IRQ_PWRON_RISE = 1,
	RK816_IRQ_VB_LOW = 2,
	RK816_IRQ_PWRON = 3,
	RK816_IRQ_PWRON_LP = 4,
	RK816_IRQ_HOTDIE = 5,
	RK816_IRQ_RTC_ALARM = 6,
	RK816_IRQ_RTC_PERIOD = 7,
	RK816_IRQ_USB_OV = 8,
	RK816_IRQ_PLUG_IN = 9,
	RK816_IRQ_PLUG_OUT = 10,
	RK816_IRQ_CHG_OK = 11,
	RK816_IRQ_CHG_TE = 12,
	RK816_IRQ_CHG_TS = 13,
	RK816_IRQ_CHG_CVTLIM = 14,
	RK816_IRQ_DISCHG_ILIM = 15,
};

enum rk816_reg {
	RK816_ID_DCDC1 = 0,
	RK816_ID_DCDC2 = 1,
	RK816_ID_DCDC3 = 2,
	RK816_ID_DCDC4 = 3,
	RK816_ID_LDO1 = 4,
	RK816_ID_LDO2 = 5,
	RK816_ID_LDO3 = 6,
	RK816_ID_LDO4 = 7,
	RK816_ID_LDO5 = 8,
	RK816_ID_LDO6 = 9,
	RK816_ID_BOOST = 10,
	RK816_ID_OTG_SW = 11,
};

enum rk817_reg_id {
	RK817_ID_DCDC1 = 0,
	RK817_ID_DCDC2 = 1,
	RK817_ID_DCDC3 = 2,
	RK817_ID_DCDC4 = 3,
	RK817_ID_LDO1 = 4,
	RK817_ID_LDO2 = 5,
	RK817_ID_LDO3 = 6,
	RK817_ID_LDO4 = 7,
	RK817_ID_LDO5 = 8,
	RK817_ID_LDO6 = 9,
	RK817_ID_LDO7 = 10,
	RK817_ID_LDO8 = 11,
	RK817_ID_LDO9 = 12,
	RK817_ID_BOOST = 13,
	RK817_ID_BOOST_OTG_SW = 14,
	RK817_NUM_REGULATORS = 15,
};

enum rk818_reg {
	RK818_ID_DCDC1 = 0,
	RK818_ID_DCDC2 = 1,
	RK818_ID_DCDC3 = 2,
	RK818_ID_DCDC4 = 3,
	RK818_ID_BOOST = 4,
	RK818_ID_LDO1 = 5,
	RK818_ID_LDO2 = 6,
	RK818_ID_LDO3 = 7,
	RK818_ID_LDO4 = 8,
	RK818_ID_LDO5 = 9,
	RK818_ID_LDO6 = 10,
	RK818_ID_LDO7 = 11,
	RK818_ID_LDO8 = 12,
	RK818_ID_LDO9 = 13,
	RK818_ID_SWITCH = 14,
	RK818_ID_HDMI_SWITCH = 15,
	RK818_ID_OTG_SWITCH = 16,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmap_level {
	RMAP_LEVEL_PTE = 0,
	RMAP_LEVEL_PMD = 1,
	RMAP_LEVEL_PUD = 2,
};

enum rmi_reg_state {
	RMI_REG_STATE_DEFAULT = 0,
	RMI_REG_STATE_OFF = 1,
	RMI_REG_STATE_ON = 2,
};

enum rmi_sensor_type {
	rmi_sensor_default = 0,
	rmi_sensor_touchscreen = 1,
	rmi_sensor_touchpad = 2,
};

enum rmp_flags {
	RMP_LOCKED = 1,
	RMP_USE_SHARED_ZEROPAGE = 2,
};

enum rmqueue_mode {
	RMQUEUE_NORMAL = 0,
	RMQUEUE_CMA = 1,
	RMQUEUE_CLAIM = 2,
	RMQUEUE_STEAL = 3,
};

enum rohm_chip_type {
	ROHM_CHIP_TYPE_BD9571 = 0,
	ROHM_CHIP_TYPE_BD9573 = 1,
	ROHM_CHIP_TYPE_BD9574 = 2,
	ROHM_CHIP_TYPE_BD9576 = 3,
	ROHM_CHIP_TYPE_BD71815 = 4,
	ROHM_CHIP_TYPE_BD71828 = 5,
	ROHM_CHIP_TYPE_BD71837 = 6,
	ROHM_CHIP_TYPE_BD71847 = 7,
	ROHM_CHIP_TYPE_BD96801 = 8,
	ROHM_CHIP_TYPE_BD96802 = 9,
	ROHM_CHIP_TYPE_BD96805 = 10,
	ROHM_CHIP_TYPE_BD96806 = 11,
	ROHM_CHIP_TYPE_AMOUNT = 12,
};

enum routing_attribute {
	DIRECT_ROUTING = 0,
	SUBTRACTIVE_ROUTING = 1,
	TABLE_ROUTING = 2,
};

enum rp_check {
	RP_CHECK_CALL = 0,
	RP_CHECK_CHAIN_CALL = 1,
	RP_CHECK_RET = 2,
};

enum rpc_accept_stat {
	RPC_SUCCESS = 0,
	RPC_PROG_UNAVAIL = 1,
	RPC_PROG_MISMATCH = 2,
	RPC_PROC_UNAVAIL = 3,
	RPC_GARBAGE_ARGS = 4,
	RPC_SYSTEM_ERR = 5,
	RPC_DROP_REPLY = 60000,
};

enum rpc_auth_flavors {
	RPC_AUTH_NULL = 0,
	RPC_AUTH_UNIX = 1,
	RPC_AUTH_SHORT = 2,
	RPC_AUTH_DES = 3,
	RPC_AUTH_KRB = 4,
	RPC_AUTH_GSS = 6,
	RPC_AUTH_TLS = 7,
	RPC_AUTH_MAXFLAVOR = 8,
	RPC_AUTH_GSS_KRB5 = 390003,
	RPC_AUTH_GSS_KRB5I = 390004,
	RPC_AUTH_GSS_KRB5P = 390005,
	RPC_AUTH_GSS_LKEY = 390006,
	RPC_AUTH_GSS_LKEYI = 390007,
	RPC_AUTH_GSS_LKEYP = 390008,
	RPC_AUTH_GSS_SPKM = 390009,
	RPC_AUTH_GSS_SPKMI = 390010,
	RPC_AUTH_GSS_SPKMP = 390011,
};

enum rpc_auth_stat {
	RPC_AUTH_OK = 0,
	RPC_AUTH_BADCRED = 1,
	RPC_AUTH_REJECTEDCRED = 2,
	RPC_AUTH_BADVERF = 3,
	RPC_AUTH_REJECTEDVERF = 4,
	RPC_AUTH_TOOWEAK = 5,
	RPCSEC_GSS_CREDPROBLEM = 13,
	RPCSEC_GSS_CTXPROBLEM = 14,
};

enum rpc_display_format_t {
	RPC_DISPLAY_ADDR = 0,
	RPC_DISPLAY_PORT = 1,
	RPC_DISPLAY_PROTO = 2,
	RPC_DISPLAY_HEX_ADDR = 3,
	RPC_DISPLAY_HEX_PORT = 4,
	RPC_DISPLAY_NETID = 5,
	RPC_DISPLAY_MAX = 6,
};

enum rpc_gss_proc {
	RPC_GSS_PROC_DATA = 0,
	RPC_GSS_PROC_INIT = 1,
	RPC_GSS_PROC_CONTINUE_INIT = 2,
	RPC_GSS_PROC_DESTROY = 3,
};

enum rpc_gss_svc {
	RPC_GSS_SVC_NONE = 1,
	RPC_GSS_SVC_INTEGRITY = 2,
	RPC_GSS_SVC_PRIVACY = 3,
};

enum rpc_msg_type {
	RPC_CALL = 0,
	RPC_REPLY = 1,
};

enum rpc_reject_stat {
	RPC_MISMATCH = 0,
	RPC_AUTH_ERROR = 1,
};

enum rpc_reply_stat {
	RPC_MSG_ACCEPTED = 0,
	RPC_MSG_DENIED = 1,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
	RPM_BLOCKED = 4,
};

enum rpmb_type {
	RPMB_TYPE_EMMC = 0,
	RPMB_TYPE_UFS = 1,
	RPMB_TYPE_NVME = 2,
};

enum rpmb_unit_desc_param {
	RPMB_UNIT_DESC_PARAM_LEN = 0,
	RPMB_UNIT_DESC_PARAM_TYPE = 1,
	RPMB_UNIT_DESC_PARAM_UNIT_INDEX = 2,
	RPMB_UNIT_DESC_PARAM_LU_ENABLE = 3,
	RPMB_UNIT_DESC_PARAM_BOOT_LUN_ID = 4,
	RPMB_UNIT_DESC_PARAM_LU_WR_PROTECT = 5,
	RPMB_UNIT_DESC_PARAM_LU_Q_DEPTH = 6,
	RPMB_UNIT_DESC_PARAM_PSA_SENSITIVE = 7,
	RPMB_UNIT_DESC_PARAM_MEM_TYPE = 8,
	RPMB_UNIT_DESC_PARAM_REGION_EN = 9,
	RPMB_UNIT_DESC_PARAM_LOGICAL_BLK_SIZE = 10,
	RPMB_UNIT_DESC_PARAM_LOGICAL_BLK_COUNT = 11,
	RPMB_UNIT_DESC_PARAM_REGION0_SIZE = 19,
	RPMB_UNIT_DESC_PARAM_REGION1_SIZE = 20,
	RPMB_UNIT_DESC_PARAM_REGION2_SIZE = 21,
	RPMB_UNIT_DESC_PARAM_REGION3_SIZE = 22,
	RPMB_UNIT_DESC_PARAM_PROVISIONING_TYPE = 23,
	RPMB_UNIT_DESC_PARAM_PHY_MEM_RSRC_CNT = 24,
};

enum rpmsg_ns_flags {
	RPMSG_NS_CREATE = 0,
	RPMSG_NS_DESTROY = 1,
};

enum rproc_crash_type {
	RPROC_MMUFAULT = 0,
	RPROC_WATCHDOG = 1,
	RPROC_FATAL_ERROR = 2,
};

enum rproc_dump_mechanism {
	RPROC_COREDUMP_DISABLED = 0,
	RPROC_COREDUMP_ENABLED = 1,
	RPROC_COREDUMP_INLINE = 2,
};

enum rproc_features {
	RPROC_FEAT_ATTACH_ON_RECOVERY = 0,
	RPROC_MAX_FEATURES = 1,
};

enum rproc_state {
	RPROC_OFFLINE = 0,
	RPROC_SUSPENDED = 1,
	RPROC_RUNNING = 2,
	RPROC_CRASHED = 3,
	RPROC_DELETED = 4,
	RPROC_ATTACHED = 5,
	RPROC_DETACHED = 6,
	RPROC_LAST = 7,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rqf_flags {
	__RQF_STARTED = 0,
	__RQF_FLUSH_SEQ = 1,
	__RQF_MIXED_MERGE = 2,
	__RQF_DONTPREP = 3,
	__RQF_SCHED_TAGS = 4,
	__RQF_USE_SCHED = 5,
	__RQF_FAILED = 6,
	__RQF_QUIET = 7,
	__RQF_IO_STAT = 8,
	__RQF_PM = 9,
	__RQF_HASHED = 10,
	__RQF_STATS = 11,
	__RQF_SPECIAL_PAYLOAD = 12,
	__RQF_ZONE_WRITE_PLUGGING = 13,
	__RQF_TIMED_OUT = 14,
	__RQF_RESV = 15,
	__RQF_BITS = 16,
};

enum rsaprivkey_actions {
	ACT_rsa_get_d = 0,
	ACT_rsa_get_dp = 1,
	ACT_rsa_get_dq = 2,
	ACT_rsa_get_e = 3,
	ACT_rsa_get_n = 4,
	ACT_rsa_get_p = 5,
	ACT_rsa_get_q = 6,
	ACT_rsa_get_qinv = 7,
	NR__rsaprivkey_actions = 8,
};

enum rsapubkey_actions {
	ACT_rsa_get_e___2 = 0,
	ACT_rsa_get_n___2 = 1,
	NR__rsapubkey_actions = 2,
};

enum rsc_handling_status {
	RSC_HANDLED = 0,
	RSC_IGNORED = 1,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_op {
	bltz_op = 0,
	bgez_op = 1,
	bltzl_op = 2,
	bgezl_op = 3,
	spimi_op = 4,
	unused_rt_op_0x05 = 5,
	unused_rt_op_0x06 = 6,
	unused_rt_op_0x07 = 7,
	tgei_op = 8,
	tgeiu_op = 9,
	tlti_op = 10,
	tltiu_op = 11,
	teqi_op = 12,
	unused_0x0d_rt_op = 13,
	tnei_op = 14,
	unused_0x0f_rt_op = 15,
	bltzal_op = 16,
	bgezal_op = 17,
	bltzall_op = 18,
	bgezall_op = 19,
	rt_op_0x14 = 20,
	rt_op_0x15 = 21,
	rt_op_0x16 = 22,
	rt_op_0x17 = 23,
	rt_op_0x18 = 24,
	rt_op_0x19 = 25,
	rt_op_0x1a = 26,
	rt_op_0x1b = 27,
	bposge32_op = 28,
	rt_op_0x1d = 29,
	rt_op_0x1e = 30,
	synci_op = 31,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	RTA_FLOWLABEL = 31,
	__RTA_MAX = 32,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	RTNLGRP_IPV4_MCADDR = 37,
	RTNLGRP_IPV6_MCADDR = 38,
	RTNLGRP_IPV6_ACADDR = 39,
	__RTNLGRP_MAX = 40,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum s2mpa01_reg {
	S2MPA01_REG_ID = 0,
	S2MPA01_REG_INT1 = 1,
	S2MPA01_REG_INT2 = 2,
	S2MPA01_REG_INT3 = 3,
	S2MPA01_REG_INT1M = 4,
	S2MPA01_REG_INT2M = 5,
	S2MPA01_REG_INT3M = 6,
	S2MPA01_REG_ST1 = 7,
	S2MPA01_REG_ST2 = 8,
	S2MPA01_REG_PWRONSRC = 9,
	S2MPA01_REG_OFFSRC = 10,
	S2MPA01_REG_RTC_BUF = 11,
	S2MPA01_REG_CTRL1 = 12,
	S2MPA01_REG_ETC_TEST = 13,
	S2MPA01_REG_RSVD1 = 14,
	S2MPA01_REG_BU_CHG = 15,
	S2MPA01_REG_RAMP1 = 16,
	S2MPA01_REG_RAMP2 = 17,
	S2MPA01_REG_LDO_DSCH1 = 18,
	S2MPA01_REG_LDO_DSCH2 = 19,
	S2MPA01_REG_LDO_DSCH3 = 20,
	S2MPA01_REG_LDO_DSCH4 = 21,
	S2MPA01_REG_OTP_ADRL = 22,
	S2MPA01_REG_OTP_ADRH = 23,
	S2MPA01_REG_OTP_DATA = 24,
	S2MPA01_REG_MON1SEL = 25,
	S2MPA01_REG_MON2SEL = 26,
	S2MPA01_REG_LEE = 27,
	S2MPA01_REG_RSVD2 = 28,
	S2MPA01_REG_RSVD3 = 29,
	S2MPA01_REG_RSVD4 = 30,
	S2MPA01_REG_RSVD5 = 31,
	S2MPA01_REG_RSVD6 = 32,
	S2MPA01_REG_TOP_RSVD = 33,
	S2MPA01_REG_DVS_SEL = 34,
	S2MPA01_REG_DVS_PTR = 35,
	S2MPA01_REG_DVS_DATA = 36,
	S2MPA01_REG_RSVD_NO = 37,
	S2MPA01_REG_UVLO = 38,
	S2MPA01_REG_LEE_NO = 39,
	S2MPA01_REG_B1CTRL1 = 40,
	S2MPA01_REG_B1CTRL2 = 41,
	S2MPA01_REG_B2CTRL1 = 42,
	S2MPA01_REG_B2CTRL2 = 43,
	S2MPA01_REG_B3CTRL1 = 44,
	S2MPA01_REG_B3CTRL2 = 45,
	S2MPA01_REG_B4CTRL1 = 46,
	S2MPA01_REG_B4CTRL2 = 47,
	S2MPA01_REG_B5CTRL1 = 48,
	S2MPA01_REG_B5CTRL2 = 49,
	S2MPA01_REG_B5CTRL3 = 50,
	S2MPA01_REG_B5CTRL4 = 51,
	S2MPA01_REG_B5CTRL5 = 52,
	S2MPA01_REG_B5CTRL6 = 53,
	S2MPA01_REG_B6CTRL1 = 54,
	S2MPA01_REG_B6CTRL2 = 55,
	S2MPA01_REG_B7CTRL1 = 56,
	S2MPA01_REG_B7CTRL2 = 57,
	S2MPA01_REG_B8CTRL1 = 58,
	S2MPA01_REG_B8CTRL2 = 59,
	S2MPA01_REG_B9CTRL1 = 60,
	S2MPA01_REG_B9CTRL2 = 61,
	S2MPA01_REG_B10CTRL1 = 62,
	S2MPA01_REG_B10CTRL2 = 63,
	S2MPA01_REG_L1CTRL = 64,
	S2MPA01_REG_L2CTRL = 65,
	S2MPA01_REG_L3CTRL = 66,
	S2MPA01_REG_L4CTRL = 67,
	S2MPA01_REG_L5CTRL = 68,
	S2MPA01_REG_L6CTRL = 69,
	S2MPA01_REG_L7CTRL = 70,
	S2MPA01_REG_L8CTRL = 71,
	S2MPA01_REG_L9CTRL = 72,
	S2MPA01_REG_L10CTRL = 73,
	S2MPA01_REG_L11CTRL = 74,
	S2MPA01_REG_L12CTRL = 75,
	S2MPA01_REG_L13CTRL = 76,
	S2MPA01_REG_L14CTRL = 77,
	S2MPA01_REG_L15CTRL = 78,
	S2MPA01_REG_L16CTRL = 79,
	S2MPA01_REG_L17CTRL = 80,
	S2MPA01_REG_L18CTRL = 81,
	S2MPA01_REG_L19CTRL = 82,
	S2MPA01_REG_L20CTRL = 83,
	S2MPA01_REG_L21CTRL = 84,
	S2MPA01_REG_L22CTRL = 85,
	S2MPA01_REG_L23CTRL = 86,
	S2MPA01_REG_L24CTRL = 87,
	S2MPA01_REG_L25CTRL = 88,
	S2MPA01_REG_L26CTRL = 89,
	S2MPA01_REG_LDO_OVCB1 = 90,
	S2MPA01_REG_LDO_OVCB2 = 91,
	S2MPA01_REG_LDO_OVCB3 = 92,
	S2MPA01_REG_LDO_OVCB4 = 93,
};

enum s2mpg10_irq {
	S2MPG10_IRQ_PWRONF = 0,
	S2MPG10_IRQ_PWRONR = 1,
	S2MPG10_IRQ_JIGONBF = 2,
	S2MPG10_IRQ_JIGONBR = 3,
	S2MPG10_IRQ_ACOKBF = 4,
	S2MPG10_IRQ_ACOKBR = 5,
	S2MPG10_IRQ_PWRON1S = 6,
	S2MPG10_IRQ_MRB = 7,
	S2MPG10_IRQ_RTC60S = 8,
	S2MPG10_IRQ_RTCA1 = 9,
	S2MPG10_IRQ_RTCA0 = 10,
	S2MPG10_IRQ_RTC1S = 11,
	S2MPG10_IRQ_WTSR_COLDRST = 12,
	S2MPG10_IRQ_WTSR = 13,
	S2MPG10_IRQ_WRST = 14,
	S2MPG10_IRQ_SMPL = 15,
	S2MPG10_IRQ_120C = 16,
	S2MPG10_IRQ_140C = 17,
	S2MPG10_IRQ_TSD = 18,
	S2MPG10_IRQ_PIF_TIMEOUT1 = 19,
	S2MPG10_IRQ_PIF_TIMEOUT2 = 20,
	S2MPG10_IRQ_SPD_PARITY_ERR = 21,
	S2MPG10_IRQ_SPD_ABNORMAL_STOP = 22,
	S2MPG10_IRQ_PMETER_OVERF = 23,
	S2MPG10_IRQ_OCP_B1M = 24,
	S2MPG10_IRQ_OCP_B2M = 25,
	S2MPG10_IRQ_OCP_B3M = 26,
	S2MPG10_IRQ_OCP_B4M = 27,
	S2MPG10_IRQ_OCP_B5M = 28,
	S2MPG10_IRQ_OCP_B6M = 29,
	S2MPG10_IRQ_OCP_B7M = 30,
	S2MPG10_IRQ_OCP_B8M = 31,
	S2MPG10_IRQ_OCP_B9M = 32,
	S2MPG10_IRQ_OCP_B10M = 33,
	S2MPG10_IRQ_WLWP_ACC = 34,
	S2MPG10_IRQ_SMPL_TIMEOUT = 35,
	S2MPG10_IRQ_WTSR_TIMEOUT = 36,
	S2MPG10_IRQ_SPD_SRP_PKT_RST = 37,
	S2MPG10_IRQ_PWR_WARN_CH0 = 38,
	S2MPG10_IRQ_PWR_WARN_CH1 = 39,
	S2MPG10_IRQ_PWR_WARN_CH2 = 40,
	S2MPG10_IRQ_PWR_WARN_CH3 = 41,
	S2MPG10_IRQ_PWR_WARN_CH4 = 42,
	S2MPG10_IRQ_PWR_WARN_CH5 = 43,
	S2MPG10_IRQ_PWR_WARN_CH6 = 44,
	S2MPG10_IRQ_PWR_WARN_CH7 = 45,
	S2MPG10_IRQ_NR = 46,
};

enum s2mpg10_pmic_reg {
	S2MPG10_PMIC_INT1 = 0,
	S2MPG10_PMIC_INT2 = 1,
	S2MPG10_PMIC_INT3 = 2,
	S2MPG10_PMIC_INT4 = 3,
	S2MPG10_PMIC_INT5 = 4,
	S2MPG10_PMIC_INT6 = 5,
	S2MPG10_PMIC_INT1M = 6,
	S2MPG10_PMIC_INT2M = 7,
	S2MPG10_PMIC_INT3M = 8,
	S2MPG10_PMIC_INT4M = 9,
	S2MPG10_PMIC_INT5M = 10,
	S2MPG10_PMIC_INT6M = 11,
	S2MPG10_PMIC_STATUS1 = 12,
	S2MPG10_PMIC_STATUS2 = 13,
	S2MPG10_PMIC_PWRONSRC = 14,
	S2MPG10_PMIC_OFFSRC = 15,
	S2MPG10_PMIC_BU_CHG = 16,
	S2MPG10_PMIC_RTCBUF = 17,
	S2MPG10_PMIC_COMMON_CTRL1 = 18,
	S2MPG10_PMIC_COMMON_CTRL2 = 19,
	S2MPG10_PMIC_COMMON_CTRL3 = 20,
	S2MPG10_PMIC_COMMON_CTRL4 = 21,
	S2MPG10_PMIC_SMPL_WARN_CTRL = 22,
	S2MPG10_PMIC_MIMICKING_CTRL = 23,
	S2MPG10_PMIC_B1M_CTRL = 24,
	S2MPG10_PMIC_B1M_OUT1 = 25,
	S2MPG10_PMIC_B1M_OUT2 = 26,
	S2MPG10_PMIC_B2M_CTRL = 27,
	S2MPG10_PMIC_B2M_OUT1 = 28,
	S2MPG10_PMIC_B2M_OUT2 = 29,
	S2MPG10_PMIC_B3M_CTRL = 30,
	S2MPG10_PMIC_B3M_OUT1 = 31,
	S2MPG10_PMIC_B3M_OUT2 = 32,
	S2MPG10_PMIC_B4M_CTRL = 33,
	S2MPG10_PMIC_B4M_OUT1 = 34,
	S2MPG10_PMIC_B4M_OUT2 = 35,
	S2MPG10_PMIC_B5M_CTRL = 36,
	S2MPG10_PMIC_B5M_OUT1 = 37,
	S2MPG10_PMIC_B5M_OUT2 = 38,
	S2MPG10_PMIC_B6M_CTRL = 39,
	S2MPG10_PMIC_B6M_OUT1 = 40,
	S2MPG10_PMIC_B6M_OUT2 = 41,
	S2MPG10_PMIC_B7M_CTRL = 42,
	S2MPG10_PMIC_B7M_OUT1 = 43,
	S2MPG10_PMIC_B7M_OUT2 = 44,
	S2MPG10_PMIC_B8M_CTRL = 45,
	S2MPG10_PMIC_B8M_OUT1 = 46,
	S2MPG10_PMIC_B8M_OUT2 = 47,
	S2MPG10_PMIC_B9M_CTRL = 48,
	S2MPG10_PMIC_B9M_OUT1 = 49,
	S2MPG10_PMIC_B9M_OUT2 = 50,
	S2MPG10_PMIC_B10M_CTRL = 51,
	S2MPG10_PMIC_B10M_OUT1 = 52,
	S2MPG10_PMIC_B10M_OUT2 = 53,
	S2MPG10_PMIC_BUCK1M_USONIC = 54,
	S2MPG10_PMIC_BUCK2M_USONIC = 55,
	S2MPG10_PMIC_BUCK3M_USONIC = 56,
	S2MPG10_PMIC_BUCK4M_USONIC = 57,
	S2MPG10_PMIC_BUCK5M_USONIC = 58,
	S2MPG10_PMIC_BUCK6M_USONIC = 59,
	S2MPG10_PMIC_BUCK7M_USONIC = 60,
	S2MPG10_PMIC_BUCK8M_USONIC = 61,
	S2MPG10_PMIC_BUCK9M_USONIC = 62,
	S2MPG10_PMIC_BUCK10M_USONIC = 63,
	S2MPG10_PMIC_L1M_CTRL = 64,
	S2MPG10_PMIC_L2M_CTRL = 65,
	S2MPG10_PMIC_L3M_CTRL = 66,
	S2MPG10_PMIC_L4M_CTRL = 67,
	S2MPG10_PMIC_L5M_CTRL = 68,
	S2MPG10_PMIC_L6M_CTRL = 69,
	S2MPG10_PMIC_L7M_CTRL = 70,
	S2MPG10_PMIC_L8M_CTRL = 71,
	S2MPG10_PMIC_L9M_CTRL = 72,
	S2MPG10_PMIC_L10M_CTRL = 73,
	S2MPG10_PMIC_L11M_CTRL1 = 74,
	S2MPG10_PMIC_L11M_CTRL2 = 75,
	S2MPG10_PMIC_L12M_CTRL1 = 76,
	S2MPG10_PMIC_L12M_CTRL2 = 77,
	S2MPG10_PMIC_L13M_CTRL1 = 78,
	S2MPG10_PMIC_L13M_CTRL2 = 79,
	S2MPG10_PMIC_L14M_CTRL = 80,
	S2MPG10_PMIC_L15M_CTRL1 = 81,
	S2MPG10_PMIC_L15M_CTRL2 = 82,
	S2MPG10_PMIC_L16M_CTRL = 83,
	S2MPG10_PMIC_L17M_CTRL = 84,
	S2MPG10_PMIC_L18M_CTRL = 85,
	S2MPG10_PMIC_L19M_CTRL = 86,
	S2MPG10_PMIC_L20M_CTRL = 87,
	S2MPG10_PMIC_L21M_CTRL = 88,
	S2MPG10_PMIC_L22M_CTRL = 89,
	S2MPG10_PMIC_L23M_CTRL = 90,
	S2MPG10_PMIC_L24M_CTRL = 91,
	S2MPG10_PMIC_L25M_CTRL = 92,
	S2MPG10_PMIC_L26M_CTRL = 93,
	S2MPG10_PMIC_L27M_CTRL = 94,
	S2MPG10_PMIC_L28M_CTRL = 95,
	S2MPG10_PMIC_L29M_CTRL = 96,
	S2MPG10_PMIC_L30M_CTRL = 97,
	S2MPG10_PMIC_L31M_CTRL = 98,
	S2MPG10_PMIC_LDO_CTRL1 = 99,
	S2MPG10_PMIC_LDO_CTRL2 = 100,
	S2MPG10_PMIC_LDO_DSCH1 = 101,
	S2MPG10_PMIC_LDO_DSCH2 = 102,
	S2MPG10_PMIC_LDO_DSCH3 = 103,
	S2MPG10_PMIC_LDO_DSCH4 = 104,
	S2MPG10_PMIC_LDO_BUCK7M_HLIMIT = 105,
	S2MPG10_PMIC_LDO_BUCK7M_LLIMIT = 106,
	S2MPG10_PMIC_LDO_LDO21M_HLIMIT = 107,
	S2MPG10_PMIC_LDO_LDO21M_LLIMIT = 108,
	S2MPG10_PMIC_LDO_LDO11M_HLIMIT = 109,
	S2MPG10_PMIC_DVS_RAMP1 = 110,
	S2MPG10_PMIC_DVS_RAMP2 = 111,
	S2MPG10_PMIC_DVS_RAMP3 = 112,
	S2MPG10_PMIC_DVS_RAMP4 = 113,
	S2MPG10_PMIC_DVS_RAMP5 = 114,
	S2MPG10_PMIC_DVS_RAMP6 = 115,
	S2MPG10_PMIC_DVS_SYNC_CTRL1 = 116,
	S2MPG10_PMIC_DVS_SYNC_CTRL2 = 117,
	S2MPG10_PMIC_DVS_SYNC_CTRL3 = 118,
	S2MPG10_PMIC_DVS_SYNC_CTRL4 = 119,
	S2MPG10_PMIC_DVS_SYNC_CTRL5 = 120,
	S2MPG10_PMIC_DVS_SYNC_CTRL6 = 121,
	S2MPG10_PMIC_OFF_CTRL1 = 122,
	S2MPG10_PMIC_OFF_CTRL2 = 123,
	S2MPG10_PMIC_OFF_CTRL3 = 124,
	S2MPG10_PMIC_OFF_CTRL4 = 125,
	S2MPG10_PMIC_SEQ_CTRL1 = 126,
	S2MPG10_PMIC_SEQ_CTRL2 = 127,
	S2MPG10_PMIC_SEQ_CTRL3 = 128,
	S2MPG10_PMIC_SEQ_CTRL4 = 129,
	S2MPG10_PMIC_SEQ_CTRL5 = 130,
	S2MPG10_PMIC_SEQ_CTRL6 = 131,
	S2MPG10_PMIC_SEQ_CTRL7 = 132,
	S2MPG10_PMIC_SEQ_CTRL8 = 133,
	S2MPG10_PMIC_SEQ_CTRL9 = 134,
	S2MPG10_PMIC_SEQ_CTRL10 = 135,
	S2MPG10_PMIC_SEQ_CTRL11 = 136,
	S2MPG10_PMIC_SEQ_CTRL12 = 137,
	S2MPG10_PMIC_SEQ_CTRL13 = 138,
	S2MPG10_PMIC_SEQ_CTRL14 = 139,
	S2MPG10_PMIC_SEQ_CTRL15 = 140,
	S2MPG10_PMIC_SEQ_CTRL16 = 141,
	S2MPG10_PMIC_SEQ_CTRL17 = 142,
	S2MPG10_PMIC_SEQ_CTRL18 = 143,
	S2MPG10_PMIC_SEQ_CTRL19 = 144,
	S2MPG10_PMIC_SEQ_CTRL20 = 145,
	S2MPG10_PMIC_SEQ_CTRL21 = 146,
	S2MPG10_PMIC_SEQ_CTRL22 = 147,
	S2MPG10_PMIC_SEQ_CTRL23 = 148,
	S2MPG10_PMIC_SEQ_CTRL24 = 149,
	S2MPG10_PMIC_SEQ_CTRL25 = 150,
	S2MPG10_PMIC_SEQ_CTRL26 = 151,
	S2MPG10_PMIC_SEQ_CTRL27 = 152,
	S2MPG10_PMIC_SEQ_CTRL28 = 153,
	S2MPG10_PMIC_SEQ_CTRL29 = 154,
	S2MPG10_PMIC_SEQ_CTRL30 = 155,
	S2MPG10_PMIC_SEQ_CTRL31 = 156,
	S2MPG10_PMIC_SEQ_CTRL32 = 157,
	S2MPG10_PMIC_SEQ_CTRL33 = 158,
	S2MPG10_PMIC_SEQ_CTRL34 = 159,
	S2MPG10_PMIC_SEQ_CTRL35 = 160,
	S2MPG10_PMIC_OFF_SEQ_CTRL1 = 161,
	S2MPG10_PMIC_OFF_SEQ_CTRL2 = 162,
	S2MPG10_PMIC_OFF_SEQ_CTRL3 = 163,
	S2MPG10_PMIC_OFF_SEQ_CTRL4 = 164,
	S2MPG10_PMIC_OFF_SEQ_CTRL5 = 165,
	S2MPG10_PMIC_OFF_SEQ_CTRL6 = 166,
	S2MPG10_PMIC_OFF_SEQ_CTRL7 = 167,
	S2MPG10_PMIC_OFF_SEQ_CTRL8 = 168,
	S2MPG10_PMIC_OFF_SEQ_CTRL9 = 169,
	S2MPG10_PMIC_OFF_SEQ_CTRL10 = 170,
	S2MPG10_PMIC_OFF_SEQ_CTRL11 = 171,
	S2MPG10_PMIC_OFF_SEQ_CTRL12 = 172,
	S2MPG10_PMIC_OFF_SEQ_CTRL13 = 173,
	S2MPG10_PMIC_OFF_SEQ_CTRL14 = 174,
	S2MPG10_PMIC_OFF_SEQ_CTRL15 = 175,
	S2MPG10_PMIC_OFF_SEQ_CTRL16 = 176,
	S2MPG10_PMIC_OFF_SEQ_CTRL17 = 177,
	S2MPG10_PMIC_OFF_SEQ_CTRL18 = 178,
	S2MPG10_PMIC_PCTRLSEL1 = 179,
	S2MPG10_PMIC_PCTRLSEL2 = 180,
	S2MPG10_PMIC_PCTRLSEL3 = 181,
	S2MPG10_PMIC_PCTRLSEL4 = 182,
	S2MPG10_PMIC_PCTRLSEL5 = 183,
	S2MPG10_PMIC_PCTRLSEL6 = 184,
	S2MPG10_PMIC_PCTRLSEL7 = 185,
	S2MPG10_PMIC_PCTRLSEL8 = 186,
	S2MPG10_PMIC_PCTRLSEL9 = 187,
	S2MPG10_PMIC_PCTRLSEL10 = 188,
	S2MPG10_PMIC_PCTRLSEL11 = 189,
	S2MPG10_PMIC_PCTRLSEL12 = 190,
	S2MPG10_PMIC_PCTRLSEL13 = 191,
	S2MPG10_PMIC_DCTRLSEL1 = 192,
	S2MPG10_PMIC_DCTRLSEL2 = 193,
	S2MPG10_PMIC_DCTRLSEL3 = 194,
	S2MPG10_PMIC_DCTRLSEL4 = 195,
	S2MPG10_PMIC_DCTRLSEL5 = 196,
	S2MPG10_PMIC_DCTRLSEL6 = 197,
	S2MPG10_PMIC_DCTRLSEL7 = 198,
	S2MPG10_PMIC_GPIO_CTRL1 = 199,
	S2MPG10_PMIC_GPIO_CTRL2 = 200,
	S2MPG10_PMIC_GPIO_CTRL3 = 201,
	S2MPG10_PMIC_GPIO_CTRL4 = 202,
	S2MPG10_PMIC_GPIO_CTRL5 = 203,
	S2MPG10_PMIC_GPIO_CTRL6 = 204,
	S2MPG10_PMIC_GPIO_CTRL7 = 205,
	S2MPG10_PMIC_B2M_OCP_WARN = 206,
	S2MPG10_PMIC_B2M_OCP_WARN_X = 207,
	S2MPG10_PMIC_B2M_OCP_WARN_Y = 208,
	S2MPG10_PMIC_B2M_OCP_WARN_Z = 209,
	S2MPG10_PMIC_B3M_OCP_WARN = 210,
	S2MPG10_PMIC_B3M_OCP_WARN_X = 211,
	S2MPG10_PMIC_B3M_OCP_WARN_Y = 212,
	S2MPG10_PMIC_B3M_OCP_WARN_Z = 213,
	S2MPG10_PMIC_B10M_OCP_WARN = 214,
	S2MPG10_PMIC_B10M_OCP_WARN_X = 215,
	S2MPG10_PMIC_B10M_OCP_WARN_Y = 216,
	S2MPG10_PMIC_B10M_OCP_WARN_Z = 217,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN = 218,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_X = 219,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_Y = 220,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_Z = 221,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN = 222,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_X = 223,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_Y = 224,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_Z = 225,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN = 226,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_X = 227,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_Y = 228,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_Z = 229,
	S2MPG10_PMIC_BUCK_OCP_EN1 = 230,
	S2MPG10_PMIC_BUCK_OCP_EN2 = 231,
	S2MPG10_PMIC_BUCK_OCP_PD_EN1 = 232,
	S2MPG10_PMIC_BUCK_OCP_PD_EN2 = 233,
	S2MPG10_PMIC_BUCK_OCP_CTRL1 = 234,
	S2MPG10_PMIC_BUCK_OCP_CTRL2 = 235,
	S2MPG10_PMIC_BUCK_OCP_CTRL3 = 236,
	S2MPG10_PMIC_BUCK_OCP_CTRL4 = 237,
	S2MPG10_PMIC_BUCK_OCP_CTRL5 = 238,
	S2MPG10_PMIC_PIF_CTRL = 239,
	S2MPG10_PMIC_BUCK_HR_MODE1 = 240,
	S2MPG10_PMIC_BUCK_HR_MODE2 = 241,
	S2MPG10_PMIC_FAULTOUT_CTRL = 242,
	S2MPG10_PMIC_LDO_SENSE1 = 243,
	S2MPG10_PMIC_LDO_SENSE2 = 244,
	S2MPG10_PMIC_LDO_SENSE3 = 245,
	S2MPG10_PMIC_LDO_SENSE4 = 246,
};

enum s2mpg10_rtc_reg {
	S2MPG10_RTC_CTRL = 0,
	S2MPG10_RTC_UPDATE = 1,
	S2MPG10_RTC_SMPL = 2,
	S2MPG10_RTC_WTSR = 3,
	S2MPG10_RTC_CAP_SEL = 4,
	S2MPG10_RTC_MSEC = 5,
	S2MPG10_RTC_SEC = 6,
	S2MPG10_RTC_MIN = 7,
	S2MPG10_RTC_HOUR = 8,
	S2MPG10_RTC_WEEK = 9,
	S2MPG10_RTC_DAY = 10,
	S2MPG10_RTC_MON = 11,
	S2MPG10_RTC_YEAR = 12,
	S2MPG10_RTC_A0SEC = 13,
	S2MPG10_RTC_A0MIN = 14,
	S2MPG10_RTC_A0HOUR = 15,
	S2MPG10_RTC_A0WEEK = 16,
	S2MPG10_RTC_A0DAY = 17,
	S2MPG10_RTC_A0MON = 18,
	S2MPG10_RTC_A0YEAR = 19,
	S2MPG10_RTC_A1SEC = 20,
	S2MPG10_RTC_A1MIN = 21,
	S2MPG10_RTC_A1HOUR = 22,
	S2MPG10_RTC_A1WEEK = 23,
	S2MPG10_RTC_A1DAY = 24,
	S2MPG10_RTC_A1MON = 25,
	S2MPG10_RTC_A1YEAR = 26,
	S2MPG10_RTC_OSC_CTRL = 27,
};

enum s2mps11_irq {
	S2MPS11_IRQ_PWRONF = 0,
	S2MPS11_IRQ_PWRONR = 1,
	S2MPS11_IRQ_JIGONBF = 2,
	S2MPS11_IRQ_JIGONBR = 3,
	S2MPS11_IRQ_ACOKBF = 4,
	S2MPS11_IRQ_ACOKBR = 5,
	S2MPS11_IRQ_PWRON1S = 6,
	S2MPS11_IRQ_MRB = 7,
	S2MPS11_IRQ_RTC60S = 8,
	S2MPS11_IRQ_RTCA1 = 9,
	S2MPS11_IRQ_RTCA0 = 10,
	S2MPS11_IRQ_SMPL = 11,
	S2MPS11_IRQ_RTC1S = 12,
	S2MPS11_IRQ_WTSR = 13,
	S2MPS11_IRQ_INT120C = 14,
	S2MPS11_IRQ_INT140C = 15,
	S2MPS11_IRQ_NR = 16,
};

enum s2mps11_reg {
	S2MPS11_REG_ID = 0,
	S2MPS11_REG_INT1 = 1,
	S2MPS11_REG_INT2 = 2,
	S2MPS11_REG_INT3 = 3,
	S2MPS11_REG_INT1M = 4,
	S2MPS11_REG_INT2M = 5,
	S2MPS11_REG_INT3M = 6,
	S2MPS11_REG_ST1 = 7,
	S2MPS11_REG_ST2 = 8,
	S2MPS11_REG_OFFSRC = 9,
	S2MPS11_REG_PWRONSRC = 10,
	S2MPS11_REG_RTC_CTRL = 11,
	S2MPS11_REG_CTRL1 = 12,
	S2MPS11_REG_ETC_TEST = 13,
	S2MPS11_REG_RSVD3 = 14,
	S2MPS11_REG_BU_CHG = 15,
	S2MPS11_REG_RAMP = 16,
	S2MPS11_REG_RAMP_BUCK = 17,
	S2MPS11_REG_LDO1_8 = 18,
	S2MPS11_REG_LDO9_16 = 19,
	S2MPS11_REG_LDO17_24 = 20,
	S2MPS11_REG_LDO25_32 = 21,
	S2MPS11_REG_LDO33_38 = 22,
	S2MPS11_REG_LDO1_8_1 = 23,
	S2MPS11_REG_LDO9_16_1 = 24,
	S2MPS11_REG_LDO17_24_1 = 25,
	S2MPS11_REG_LDO25_32_1 = 26,
	S2MPS11_REG_LDO33_38_1 = 27,
	S2MPS11_REG_OTP_ADRL = 28,
	S2MPS11_REG_OTP_ADRH = 29,
	S2MPS11_REG_OTP_DATA = 30,
	S2MPS11_REG_MON1SEL = 31,
	S2MPS11_REG_MON2SEL = 32,
	S2MPS11_REG_LEE = 33,
	S2MPS11_REG_RSVD_NO = 34,
	S2MPS11_REG_UVLO = 35,
	S2MPS11_REG_LEE_NO = 36,
	S2MPS11_REG_B1CTRL1 = 37,
	S2MPS11_REG_B1CTRL2 = 38,
	S2MPS11_REG_B2CTRL1 = 39,
	S2MPS11_REG_B2CTRL2 = 40,
	S2MPS11_REG_B3CTRL1 = 41,
	S2MPS11_REG_B3CTRL2 = 42,
	S2MPS11_REG_B4CTRL1 = 43,
	S2MPS11_REG_B4CTRL2 = 44,
	S2MPS11_REG_B5CTRL1 = 45,
	S2MPS11_REG_BUCK5_SW = 46,
	S2MPS11_REG_B5CTRL2 = 47,
	S2MPS11_REG_B5CTRL3 = 48,
	S2MPS11_REG_B5CTRL4 = 49,
	S2MPS11_REG_B5CTRL5 = 50,
	S2MPS11_REG_B6CTRL1 = 51,
	S2MPS11_REG_B6CTRL2 = 52,
	S2MPS11_REG_B7CTRL1 = 53,
	S2MPS11_REG_B7CTRL2 = 54,
	S2MPS11_REG_B8CTRL1 = 55,
	S2MPS11_REG_B8CTRL2 = 56,
	S2MPS11_REG_B9CTRL1 = 57,
	S2MPS11_REG_B9CTRL2 = 58,
	S2MPS11_REG_B10CTRL1 = 59,
	S2MPS11_REG_B10CTRL2 = 60,
	S2MPS11_REG_L1CTRL = 61,
	S2MPS11_REG_L2CTRL = 62,
	S2MPS11_REG_L3CTRL = 63,
	S2MPS11_REG_L4CTRL = 64,
	S2MPS11_REG_L5CTRL = 65,
	S2MPS11_REG_L6CTRL = 66,
	S2MPS11_REG_L7CTRL = 67,
	S2MPS11_REG_L8CTRL = 68,
	S2MPS11_REG_L9CTRL = 69,
	S2MPS11_REG_L10CTRL = 70,
	S2MPS11_REG_L11CTRL = 71,
	S2MPS11_REG_L12CTRL = 72,
	S2MPS11_REG_L13CTRL = 73,
	S2MPS11_REG_L14CTRL = 74,
	S2MPS11_REG_L15CTRL = 75,
	S2MPS11_REG_L16CTRL = 76,
	S2MPS11_REG_L17CTRL = 77,
	S2MPS11_REG_L18CTRL = 78,
	S2MPS11_REG_L19CTRL = 79,
	S2MPS11_REG_L20CTRL = 80,
	S2MPS11_REG_L21CTRL = 81,
	S2MPS11_REG_L22CTRL = 82,
	S2MPS11_REG_L23CTRL = 83,
	S2MPS11_REG_L24CTRL = 84,
	S2MPS11_REG_L25CTRL = 85,
	S2MPS11_REG_L26CTRL = 86,
	S2MPS11_REG_L27CTRL = 87,
	S2MPS11_REG_L28CTRL = 88,
	S2MPS11_REG_L29CTRL = 89,
	S2MPS11_REG_L30CTRL = 90,
	S2MPS11_REG_L31CTRL = 91,
	S2MPS11_REG_L32CTRL = 92,
	S2MPS11_REG_L33CTRL = 93,
	S2MPS11_REG_L34CTRL = 94,
	S2MPS11_REG_L35CTRL = 95,
	S2MPS11_REG_L36CTRL = 96,
	S2MPS11_REG_L37CTRL = 97,
	S2MPS11_REG_L38CTRL = 98,
};

enum s2mps11_regulators {
	S2MPS11_LDO1 = 0,
	S2MPS11_LDO2 = 1,
	S2MPS11_LDO3 = 2,
	S2MPS11_LDO4 = 3,
	S2MPS11_LDO5 = 4,
	S2MPS11_LDO6 = 5,
	S2MPS11_LDO7 = 6,
	S2MPS11_LDO8 = 7,
	S2MPS11_LDO9 = 8,
	S2MPS11_LDO10 = 9,
	S2MPS11_LDO11 = 10,
	S2MPS11_LDO12 = 11,
	S2MPS11_LDO13 = 12,
	S2MPS11_LDO14 = 13,
	S2MPS11_LDO15 = 14,
	S2MPS11_LDO16 = 15,
	S2MPS11_LDO17 = 16,
	S2MPS11_LDO18 = 17,
	S2MPS11_LDO19 = 18,
	S2MPS11_LDO20 = 19,
	S2MPS11_LDO21 = 20,
	S2MPS11_LDO22 = 21,
	S2MPS11_LDO23 = 22,
	S2MPS11_LDO24 = 23,
	S2MPS11_LDO25 = 24,
	S2MPS11_LDO26 = 25,
	S2MPS11_LDO27 = 26,
	S2MPS11_LDO28 = 27,
	S2MPS11_LDO29 = 28,
	S2MPS11_LDO30 = 29,
	S2MPS11_LDO31 = 30,
	S2MPS11_LDO32 = 31,
	S2MPS11_LDO33 = 32,
	S2MPS11_LDO34 = 33,
	S2MPS11_LDO35 = 34,
	S2MPS11_LDO36 = 35,
	S2MPS11_LDO37 = 36,
	S2MPS11_LDO38 = 37,
	S2MPS11_BUCK1 = 38,
	S2MPS11_BUCK2 = 39,
	S2MPS11_BUCK3 = 40,
	S2MPS11_BUCK4 = 41,
	S2MPS11_BUCK5 = 42,
	S2MPS11_BUCK6 = 43,
	S2MPS11_BUCK7 = 44,
	S2MPS11_BUCK8 = 45,
	S2MPS11_BUCK9 = 46,
	S2MPS11_BUCK10 = 47,
	S2MPS11_REGULATOR_MAX = 48,
};

enum s2mps13_reg {
	S2MPS13_REG_ID = 0,
	S2MPS13_REG_INT1 = 1,
	S2MPS13_REG_INT2 = 2,
	S2MPS13_REG_INT3 = 3,
	S2MPS13_REG_INT1M = 4,
	S2MPS13_REG_INT2M = 5,
	S2MPS13_REG_INT3M = 6,
	S2MPS13_REG_ST1 = 7,
	S2MPS13_REG_ST2 = 8,
	S2MPS13_REG_PWRONSRC = 9,
	S2MPS13_REG_OFFSRC = 10,
	S2MPS13_REG_BU_CHG = 11,
	S2MPS13_REG_RTCCTRL = 12,
	S2MPS13_REG_CTRL1 = 13,
	S2MPS13_REG_CTRL2 = 14,
	S2MPS13_REG_RSVD1 = 15,
	S2MPS13_REG_RSVD2 = 16,
	S2MPS13_REG_RSVD3 = 17,
	S2MPS13_REG_RSVD4 = 18,
	S2MPS13_REG_RSVD5 = 19,
	S2MPS13_REG_RSVD6 = 20,
	S2MPS13_REG_CTRL3 = 21,
	S2MPS13_REG_RSVD7 = 22,
	S2MPS13_REG_RSVD8 = 23,
	S2MPS13_REG_WRSTBI = 24,
	S2MPS13_REG_B1CTRL = 25,
	S2MPS13_REG_B1OUT = 26,
	S2MPS13_REG_B2CTRL = 27,
	S2MPS13_REG_B2OUT = 28,
	S2MPS13_REG_B3CTRL = 29,
	S2MPS13_REG_B3OUT = 30,
	S2MPS13_REG_B4CTRL = 31,
	S2MPS13_REG_B4OUT = 32,
	S2MPS13_REG_B5CTRL = 33,
	S2MPS13_REG_B5OUT = 34,
	S2MPS13_REG_B6CTRL = 35,
	S2MPS13_REG_B6OUT = 36,
	S2MPS13_REG_B7CTRL = 37,
	S2MPS13_REG_B7SW = 38,
	S2MPS13_REG_B7OUT = 39,
	S2MPS13_REG_B8CTRL = 40,
	S2MPS13_REG_B8OUT = 41,
	S2MPS13_REG_B9CTRL = 42,
	S2MPS13_REG_B9OUT = 43,
	S2MPS13_REG_B10CTRL = 44,
	S2MPS13_REG_B10OUT = 45,
	S2MPS13_REG_BB1CTRL = 46,
	S2MPS13_REG_BB1OUT = 47,
	S2MPS13_REG_BUCK_RAMP1 = 48,
	S2MPS13_REG_BUCK_RAMP2 = 49,
	S2MPS13_REG_LDO_DVS1 = 50,
	S2MPS13_REG_LDO_DVS2 = 51,
	S2MPS13_REG_LDO_DVS3 = 52,
	S2MPS13_REG_B6OUT2 = 53,
	S2MPS13_REG_L1CTRL = 54,
	S2MPS13_REG_L2CTRL = 55,
	S2MPS13_REG_L3CTRL = 56,
	S2MPS13_REG_L4CTRL = 57,
	S2MPS13_REG_L5CTRL = 58,
	S2MPS13_REG_L6CTRL = 59,
	S2MPS13_REG_L7CTRL = 60,
	S2MPS13_REG_L8CTRL = 61,
	S2MPS13_REG_L9CTRL = 62,
	S2MPS13_REG_L10CTRL = 63,
	S2MPS13_REG_L11CTRL = 64,
	S2MPS13_REG_L12CTRL = 65,
	S2MPS13_REG_L13CTRL = 66,
	S2MPS13_REG_L14CTRL = 67,
	S2MPS13_REG_L15CTRL = 68,
	S2MPS13_REG_L16CTRL = 69,
	S2MPS13_REG_L17CTRL = 70,
	S2MPS13_REG_L18CTRL = 71,
	S2MPS13_REG_L19CTRL = 72,
	S2MPS13_REG_L20CTRL = 73,
	S2MPS13_REG_L21CTRL = 74,
	S2MPS13_REG_L22CTRL = 75,
	S2MPS13_REG_L23CTRL = 76,
	S2MPS13_REG_L24CTRL = 77,
	S2MPS13_REG_L25CTRL = 78,
	S2MPS13_REG_L26CTRL = 79,
	S2MPS13_REG_L27CTRL = 80,
	S2MPS13_REG_L28CTRL = 81,
	S2MPS13_REG_L29CTRL = 82,
	S2MPS13_REG_L30CTRL = 83,
	S2MPS13_REG_L31CTRL = 84,
	S2MPS13_REG_L32CTRL = 85,
	S2MPS13_REG_L33CTRL = 86,
	S2MPS13_REG_L34CTRL = 87,
	S2MPS13_REG_L35CTRL = 88,
	S2MPS13_REG_L36CTRL = 89,
	S2MPS13_REG_L37CTRL = 90,
	S2MPS13_REG_L38CTRL = 91,
	S2MPS13_REG_L39CTRL = 92,
	S2MPS13_REG_L40CTRL = 93,
	S2MPS13_REG_LDODSCH1 = 94,
	S2MPS13_REG_LDODSCH2 = 95,
	S2MPS13_REG_LDODSCH3 = 96,
	S2MPS13_REG_LDODSCH4 = 97,
	S2MPS13_REG_LDODSCH5 = 98,
};

enum s2mps13_regulators {
	S2MPS13_LDO1 = 0,
	S2MPS13_LDO2 = 1,
	S2MPS13_LDO3 = 2,
	S2MPS13_LDO4 = 3,
	S2MPS13_LDO5 = 4,
	S2MPS13_LDO6 = 5,
	S2MPS13_LDO7 = 6,
	S2MPS13_LDO8 = 7,
	S2MPS13_LDO9 = 8,
	S2MPS13_LDO10 = 9,
	S2MPS13_LDO11 = 10,
	S2MPS13_LDO12 = 11,
	S2MPS13_LDO13 = 12,
	S2MPS13_LDO14 = 13,
	S2MPS13_LDO15 = 14,
	S2MPS13_LDO16 = 15,
	S2MPS13_LDO17 = 16,
	S2MPS13_LDO18 = 17,
	S2MPS13_LDO19 = 18,
	S2MPS13_LDO20 = 19,
	S2MPS13_LDO21 = 20,
	S2MPS13_LDO22 = 21,
	S2MPS13_LDO23 = 22,
	S2MPS13_LDO24 = 23,
	S2MPS13_LDO25 = 24,
	S2MPS13_LDO26 = 25,
	S2MPS13_LDO27 = 26,
	S2MPS13_LDO28 = 27,
	S2MPS13_LDO29 = 28,
	S2MPS13_LDO30 = 29,
	S2MPS13_LDO31 = 30,
	S2MPS13_LDO32 = 31,
	S2MPS13_LDO33 = 32,
	S2MPS13_LDO34 = 33,
	S2MPS13_LDO35 = 34,
	S2MPS13_LDO36 = 35,
	S2MPS13_LDO37 = 36,
	S2MPS13_LDO38 = 37,
	S2MPS13_LDO39 = 38,
	S2MPS13_LDO40 = 39,
	S2MPS13_BUCK1 = 40,
	S2MPS13_BUCK2 = 41,
	S2MPS13_BUCK3 = 42,
	S2MPS13_BUCK4 = 43,
	S2MPS13_BUCK5 = 44,
	S2MPS13_BUCK6 = 45,
	S2MPS13_BUCK7 = 46,
	S2MPS13_BUCK8 = 47,
	S2MPS13_BUCK9 = 48,
	S2MPS13_BUCK10 = 49,
	S2MPS13_REGULATOR_MAX = 50,
};

enum s2mps14_irq {
	S2MPS14_IRQ_PWRONF = 0,
	S2MPS14_IRQ_PWRONR = 1,
	S2MPS14_IRQ_JIGONBF = 2,
	S2MPS14_IRQ_JIGONBR = 3,
	S2MPS14_IRQ_ACOKBF = 4,
	S2MPS14_IRQ_ACOKBR = 5,
	S2MPS14_IRQ_PWRON1S = 6,
	S2MPS14_IRQ_MRB = 7,
	S2MPS14_IRQ_RTC60S = 8,
	S2MPS14_IRQ_RTCA1 = 9,
	S2MPS14_IRQ_RTCA0 = 10,
	S2MPS14_IRQ_SMPL = 11,
	S2MPS14_IRQ_RTC1S = 12,
	S2MPS14_IRQ_WTSR = 13,
	S2MPS14_IRQ_INT120C = 14,
	S2MPS14_IRQ_INT140C = 15,
	S2MPS14_IRQ_TSD = 16,
	S2MPS14_IRQ_NR = 17,
};

enum s2mps14_reg {
	S2MPS14_REG_ID = 0,
	S2MPS14_REG_INT1 = 1,
	S2MPS14_REG_INT2 = 2,
	S2MPS14_REG_INT3 = 3,
	S2MPS14_REG_INT1M = 4,
	S2MPS14_REG_INT2M = 5,
	S2MPS14_REG_INT3M = 6,
	S2MPS14_REG_ST1 = 7,
	S2MPS14_REG_ST2 = 8,
	S2MPS14_REG_PWRONSRC = 9,
	S2MPS14_REG_OFFSRC = 10,
	S2MPS14_REG_BU_CHG = 11,
	S2MPS14_REG_RTCCTRL = 12,
	S2MPS14_REG_CTRL1 = 13,
	S2MPS14_REG_CTRL2 = 14,
	S2MPS14_REG_RSVD1 = 15,
	S2MPS14_REG_RSVD2 = 16,
	S2MPS14_REG_RSVD3 = 17,
	S2MPS14_REG_RSVD4 = 18,
	S2MPS14_REG_RSVD5 = 19,
	S2MPS14_REG_RSVD6 = 20,
	S2MPS14_REG_CTRL3 = 21,
	S2MPS14_REG_RSVD7 = 22,
	S2MPS14_REG_RSVD8 = 23,
	S2MPS14_REG_WRSTBI = 24,
	S2MPS14_REG_B1CTRL1 = 25,
	S2MPS14_REG_B1CTRL2 = 26,
	S2MPS14_REG_B2CTRL1 = 27,
	S2MPS14_REG_B2CTRL2 = 28,
	S2MPS14_REG_B3CTRL1 = 29,
	S2MPS14_REG_B3CTRL2 = 30,
	S2MPS14_REG_B4CTRL1 = 31,
	S2MPS14_REG_B4CTRL2 = 32,
	S2MPS14_REG_B5CTRL1 = 33,
	S2MPS14_REG_B5CTRL2 = 34,
	S2MPS14_REG_L1CTRL = 35,
	S2MPS14_REG_L2CTRL = 36,
	S2MPS14_REG_L3CTRL = 37,
	S2MPS14_REG_L4CTRL = 38,
	S2MPS14_REG_L5CTRL = 39,
	S2MPS14_REG_L6CTRL = 40,
	S2MPS14_REG_L7CTRL = 41,
	S2MPS14_REG_L8CTRL = 42,
	S2MPS14_REG_L9CTRL = 43,
	S2MPS14_REG_L10CTRL = 44,
	S2MPS14_REG_L11CTRL = 45,
	S2MPS14_REG_L12CTRL = 46,
	S2MPS14_REG_L13CTRL = 47,
	S2MPS14_REG_L14CTRL = 48,
	S2MPS14_REG_L15CTRL = 49,
	S2MPS14_REG_L16CTRL = 50,
	S2MPS14_REG_L17CTRL = 51,
	S2MPS14_REG_L18CTRL = 52,
	S2MPS14_REG_L19CTRL = 53,
	S2MPS14_REG_L20CTRL = 54,
	S2MPS14_REG_L21CTRL = 55,
	S2MPS14_REG_L22CTRL = 56,
	S2MPS14_REG_L23CTRL = 57,
	S2MPS14_REG_L24CTRL = 58,
	S2MPS14_REG_L25CTRL = 59,
	S2MPS14_REG_LDODSCH1 = 60,
	S2MPS14_REG_LDODSCH2 = 61,
	S2MPS14_REG_LDODSCH3 = 62,
};

enum s2mps14_regulators {
	S2MPS14_LDO1 = 0,
	S2MPS14_LDO2 = 1,
	S2MPS14_LDO3 = 2,
	S2MPS14_LDO4 = 3,
	S2MPS14_LDO5 = 4,
	S2MPS14_LDO6 = 5,
	S2MPS14_LDO7 = 6,
	S2MPS14_LDO8 = 7,
	S2MPS14_LDO9 = 8,
	S2MPS14_LDO10 = 9,
	S2MPS14_LDO11 = 10,
	S2MPS14_LDO12 = 11,
	S2MPS14_LDO13 = 12,
	S2MPS14_LDO14 = 13,
	S2MPS14_LDO15 = 14,
	S2MPS14_LDO16 = 15,
	S2MPS14_LDO17 = 16,
	S2MPS14_LDO18 = 17,
	S2MPS14_LDO19 = 18,
	S2MPS14_LDO20 = 19,
	S2MPS14_LDO21 = 20,
	S2MPS14_LDO22 = 21,
	S2MPS14_LDO23 = 22,
	S2MPS14_LDO24 = 23,
	S2MPS14_LDO25 = 24,
	S2MPS14_BUCK1 = 25,
	S2MPS14_BUCK2 = 26,
	S2MPS14_BUCK3 = 27,
	S2MPS14_BUCK4 = 28,
	S2MPS14_BUCK5 = 29,
	S2MPS14_REGULATOR_MAX = 30,
};

enum s2mps15_reg {
	S2MPS15_REG_ID = 0,
	S2MPS15_REG_INT1 = 1,
	S2MPS15_REG_INT2 = 2,
	S2MPS15_REG_INT3 = 3,
	S2MPS15_REG_INT1M = 4,
	S2MPS15_REG_INT2M = 5,
	S2MPS15_REG_INT3M = 6,
	S2MPS15_REG_ST1 = 7,
	S2MPS15_REG_ST2 = 8,
	S2MPS15_REG_PWRONSRC = 9,
	S2MPS15_REG_OFFSRC = 10,
	S2MPS15_REG_BU_CHG = 11,
	S2MPS15_REG_RTC_BUF = 12,
	S2MPS15_REG_CTRL1 = 13,
	S2MPS15_REG_CTRL2 = 14,
	S2MPS15_REG_RSVD1 = 15,
	S2MPS15_REG_RSVD2 = 16,
	S2MPS15_REG_RSVD3 = 17,
	S2MPS15_REG_RSVD4 = 18,
	S2MPS15_REG_RSVD5 = 19,
	S2MPS15_REG_RSVD6 = 20,
	S2MPS15_REG_CTRL3 = 21,
	S2MPS15_REG_RSVD7 = 22,
	S2MPS15_REG_RSVD8 = 23,
	S2MPS15_REG_RSVD9 = 24,
	S2MPS15_REG_B1CTRL1 = 25,
	S2MPS15_REG_B1CTRL2 = 26,
	S2MPS15_REG_B2CTRL1 = 27,
	S2MPS15_REG_B2CTRL2 = 28,
	S2MPS15_REG_B3CTRL1 = 29,
	S2MPS15_REG_B3CTRL2 = 30,
	S2MPS15_REG_B4CTRL1 = 31,
	S2MPS15_REG_B4CTRL2 = 32,
	S2MPS15_REG_B5CTRL1 = 33,
	S2MPS15_REG_B5CTRL2 = 34,
	S2MPS15_REG_B6CTRL1 = 35,
	S2MPS15_REG_B6CTRL2 = 36,
	S2MPS15_REG_B7CTRL1 = 37,
	S2MPS15_REG_B7CTRL2 = 38,
	S2MPS15_REG_B8CTRL1 = 39,
	S2MPS15_REG_B8CTRL2 = 40,
	S2MPS15_REG_B9CTRL1 = 41,
	S2MPS15_REG_B9CTRL2 = 42,
	S2MPS15_REG_B10CTRL1 = 43,
	S2MPS15_REG_B10CTRL2 = 44,
	S2MPS15_REG_BBCTRL1 = 45,
	S2MPS15_REG_BBCTRL2 = 46,
	S2MPS15_REG_BRAMP = 47,
	S2MPS15_REG_LDODVS1 = 48,
	S2MPS15_REG_LDODVS2 = 49,
	S2MPS15_REG_LDODVS3 = 50,
	S2MPS15_REG_LDODVS4 = 51,
	S2MPS15_REG_L1CTRL = 52,
	S2MPS15_REG_L2CTRL = 53,
	S2MPS15_REG_L3CTRL = 54,
	S2MPS15_REG_L4CTRL = 55,
	S2MPS15_REG_L5CTRL = 56,
	S2MPS15_REG_L6CTRL = 57,
	S2MPS15_REG_L7CTRL = 58,
	S2MPS15_REG_L8CTRL = 59,
	S2MPS15_REG_L9CTRL = 60,
	S2MPS15_REG_L10CTRL = 61,
	S2MPS15_REG_L11CTRL = 62,
	S2MPS15_REG_L12CTRL = 63,
	S2MPS15_REG_L13CTRL = 64,
	S2MPS15_REG_L14CTRL = 65,
	S2MPS15_REG_L15CTRL = 66,
	S2MPS15_REG_L16CTRL = 67,
	S2MPS15_REG_L17CTRL = 68,
	S2MPS15_REG_L18CTRL = 69,
	S2MPS15_REG_L19CTRL = 70,
	S2MPS15_REG_L20CTRL = 71,
	S2MPS15_REG_L21CTRL = 72,
	S2MPS15_REG_L22CTRL = 73,
	S2MPS15_REG_L23CTRL = 74,
	S2MPS15_REG_L24CTRL = 75,
	S2MPS15_REG_L25CTRL = 76,
	S2MPS15_REG_L26CTRL = 77,
	S2MPS15_REG_L27CTRL = 78,
	S2MPS15_REG_LDODSCH1 = 79,
	S2MPS15_REG_LDODSCH2 = 80,
	S2MPS15_REG_LDODSCH3 = 81,
	S2MPS15_REG_LDODSCH4 = 82,
};

enum s2mps15_regulators {
	S2MPS15_LDO1 = 0,
	S2MPS15_LDO2 = 1,
	S2MPS15_LDO3 = 2,
	S2MPS15_LDO4 = 3,
	S2MPS15_LDO5 = 4,
	S2MPS15_LDO6 = 5,
	S2MPS15_LDO7 = 6,
	S2MPS15_LDO8 = 7,
	S2MPS15_LDO9 = 8,
	S2MPS15_LDO10 = 9,
	S2MPS15_LDO11 = 10,
	S2MPS15_LDO12 = 11,
	S2MPS15_LDO13 = 12,
	S2MPS15_LDO14 = 13,
	S2MPS15_LDO15 = 14,
	S2MPS15_LDO16 = 15,
	S2MPS15_LDO17 = 16,
	S2MPS15_LDO18 = 17,
	S2MPS15_LDO19 = 18,
	S2MPS15_LDO20 = 19,
	S2MPS15_LDO21 = 20,
	S2MPS15_LDO22 = 21,
	S2MPS15_LDO23 = 22,
	S2MPS15_LDO24 = 23,
	S2MPS15_LDO25 = 24,
	S2MPS15_LDO26 = 25,
	S2MPS15_LDO27 = 26,
	S2MPS15_BUCK1 = 27,
	S2MPS15_BUCK2 = 28,
	S2MPS15_BUCK3 = 29,
	S2MPS15_BUCK4 = 30,
	S2MPS15_BUCK5 = 31,
	S2MPS15_BUCK6 = 32,
	S2MPS15_BUCK7 = 33,
	S2MPS15_BUCK8 = 34,
	S2MPS15_BUCK9 = 35,
	S2MPS15_BUCK10 = 36,
	S2MPS15_BUCK11 = 37,
	S2MPS15_REGULATOR_MAX = 38,
};

enum s2mps_rtc_reg {
	S2MPS_RTC_CTRL = 0,
	S2MPS_WTSR_SMPL_CNTL = 1,
	S2MPS_RTC_UDR_CON = 2,
	S2MPS_RSVD = 3,
	S2MPS_RTC_SEC = 4,
	S2MPS_RTC_MIN = 5,
	S2MPS_RTC_HOUR = 6,
	S2MPS_RTC_WEEKDAY = 7,
	S2MPS_RTC_DATE = 8,
	S2MPS_RTC_MONTH = 9,
	S2MPS_RTC_YEAR = 10,
	S2MPS_ALARM0_SEC = 11,
	S2MPS_ALARM0_MIN = 12,
	S2MPS_ALARM0_HOUR = 13,
	S2MPS_ALARM0_WEEKDAY = 14,
	S2MPS_ALARM0_DATE = 15,
	S2MPS_ALARM0_MONTH = 16,
	S2MPS_ALARM0_YEAR = 17,
	S2MPS_ALARM1_SEC = 18,
	S2MPS_ALARM1_MIN = 19,
	S2MPS_ALARM1_HOUR = 20,
	S2MPS_ALARM1_WEEKDAY = 21,
	S2MPS_ALARM1_DATE = 22,
	S2MPS_ALARM1_MONTH = 23,
	S2MPS_ALARM1_YEAR = 24,
	S2MPS_OFFSRC = 25,
	S2MPS_RTC_REG_MAX = 26,
};

enum s2mpu02_irq {
	S2MPU02_IRQ_PWRONF = 0,
	S2MPU02_IRQ_PWRONR = 1,
	S2MPU02_IRQ_JIGONBF = 2,
	S2MPU02_IRQ_JIGONBR = 3,
	S2MPU02_IRQ_ACOKBF = 4,
	S2MPU02_IRQ_ACOKBR = 5,
	S2MPU02_IRQ_PWRON1S = 6,
	S2MPU02_IRQ_MRB = 7,
	S2MPU02_IRQ_RTC60S = 8,
	S2MPU02_IRQ_RTCA1 = 9,
	S2MPU02_IRQ_RTCA0 = 10,
	S2MPU02_IRQ_SMPL = 11,
	S2MPU02_IRQ_RTC1S = 12,
	S2MPU02_IRQ_WTSR = 13,
	S2MPU02_IRQ_INT120C = 14,
	S2MPU02_IRQ_INT140C = 15,
	S2MPU02_IRQ_TSD = 16,
	S2MPU02_IRQ_NR = 17,
};

enum s2mpu05_irq {
	S2MPU05_IRQ_PWRONF = 0,
	S2MPU05_IRQ_PWRONR = 1,
	S2MPU05_IRQ_JIGONBF = 2,
	S2MPU05_IRQ_JIGONBR = 3,
	S2MPU05_IRQ_ACOKF = 4,
	S2MPU05_IRQ_ACOKR = 5,
	S2MPU05_IRQ_PWRON1S = 6,
	S2MPU05_IRQ_MRB = 7,
	S2MPU05_IRQ_RTC60S = 8,
	S2MPU05_IRQ_RTCA1 = 9,
	S2MPU05_IRQ_RTCA0 = 10,
	S2MPU05_IRQ_SMPL = 11,
	S2MPU05_IRQ_RTC1S = 12,
	S2MPU05_IRQ_WTSR = 13,
	S2MPU05_IRQ_INT120C = 14,
	S2MPU05_IRQ_INT140C = 15,
	S2MPU05_IRQ_TSD = 16,
	S2MPU05_IRQ_NR = 17,
};

enum s5m8767_irq {
	S5M8767_IRQ_PWRR = 0,
	S5M8767_IRQ_PWRF = 1,
	S5M8767_IRQ_PWR1S = 2,
	S5M8767_IRQ_JIGR = 3,
	S5M8767_IRQ_JIGF = 4,
	S5M8767_IRQ_LOWBAT2 = 5,
	S5M8767_IRQ_LOWBAT1 = 6,
	S5M8767_IRQ_MRB = 7,
	S5M8767_IRQ_DVSOK2 = 8,
	S5M8767_IRQ_DVSOK3 = 9,
	S5M8767_IRQ_DVSOK4 = 10,
	S5M8767_IRQ_RTC60S = 11,
	S5M8767_IRQ_RTCA1 = 12,
	S5M8767_IRQ_RTCA2 = 13,
	S5M8767_IRQ_SMPL = 14,
	S5M8767_IRQ_RTC1S = 15,
	S5M8767_IRQ_WTSR = 16,
	S5M8767_IRQ_NR = 17,
};

enum s5m8767_reg {
	S5M8767_REG_ID = 0,
	S5M8767_REG_INT1 = 1,
	S5M8767_REG_INT2 = 2,
	S5M8767_REG_INT3 = 3,
	S5M8767_REG_INT1M = 4,
	S5M8767_REG_INT2M = 5,
	S5M8767_REG_INT3M = 6,
	S5M8767_REG_STATUS1 = 7,
	S5M8767_REG_STATUS2 = 8,
	S5M8767_REG_STATUS3 = 9,
	S5M8767_REG_CTRL1 = 10,
	S5M8767_REG_CTRL2 = 11,
	S5M8767_REG_LOWBAT1 = 12,
	S5M8767_REG_LOWBAT2 = 13,
	S5M8767_REG_BUCHG = 14,
	S5M8767_REG_DVSRAMP = 15,
	S5M8767_REG_DVSTIMER2 = 16,
	S5M8767_REG_DVSTIMER3 = 17,
	S5M8767_REG_DVSTIMER4 = 18,
	S5M8767_REG_LDO1 = 19,
	S5M8767_REG_LDO2 = 20,
	S5M8767_REG_LDO3 = 21,
	S5M8767_REG_LDO4 = 22,
	S5M8767_REG_LDO5 = 23,
	S5M8767_REG_LDO6 = 24,
	S5M8767_REG_LDO7 = 25,
	S5M8767_REG_LDO8 = 26,
	S5M8767_REG_LDO9 = 27,
	S5M8767_REG_LDO10 = 28,
	S5M8767_REG_LDO11 = 29,
	S5M8767_REG_LDO12 = 30,
	S5M8767_REG_LDO13 = 31,
	S5M8767_REG_LDO14 = 32,
	S5M8767_REG_LDO15 = 33,
	S5M8767_REG_LDO16 = 34,
	S5M8767_REG_LDO17 = 35,
	S5M8767_REG_LDO18 = 36,
	S5M8767_REG_LDO19 = 37,
	S5M8767_REG_LDO20 = 38,
	S5M8767_REG_LDO21 = 39,
	S5M8767_REG_LDO22 = 40,
	S5M8767_REG_LDO23 = 41,
	S5M8767_REG_LDO24 = 42,
	S5M8767_REG_LDO25 = 43,
	S5M8767_REG_LDO26 = 44,
	S5M8767_REG_LDO27 = 45,
	S5M8767_REG_LDO28 = 46,
	S5M8767_REG_UVLO = 49,
	S5M8767_REG_BUCK1CTRL1 = 50,
	S5M8767_REG_BUCK1CTRL2 = 51,
	S5M8767_REG_BUCK2CTRL = 52,
	S5M8767_REG_BUCK2DVS1 = 53,
	S5M8767_REG_BUCK2DVS2 = 54,
	S5M8767_REG_BUCK2DVS3 = 55,
	S5M8767_REG_BUCK2DVS4 = 56,
	S5M8767_REG_BUCK2DVS5 = 57,
	S5M8767_REG_BUCK2DVS6 = 58,
	S5M8767_REG_BUCK2DVS7 = 59,
	S5M8767_REG_BUCK2DVS8 = 60,
	S5M8767_REG_BUCK3CTRL = 61,
	S5M8767_REG_BUCK3DVS1 = 62,
	S5M8767_REG_BUCK3DVS2 = 63,
	S5M8767_REG_BUCK3DVS3 = 64,
	S5M8767_REG_BUCK3DVS4 = 65,
	S5M8767_REG_BUCK3DVS5 = 66,
	S5M8767_REG_BUCK3DVS6 = 67,
	S5M8767_REG_BUCK3DVS7 = 68,
	S5M8767_REG_BUCK3DVS8 = 69,
	S5M8767_REG_BUCK4CTRL = 70,
	S5M8767_REG_BUCK4DVS1 = 71,
	S5M8767_REG_BUCK4DVS2 = 72,
	S5M8767_REG_BUCK4DVS3 = 73,
	S5M8767_REG_BUCK4DVS4 = 74,
	S5M8767_REG_BUCK4DVS5 = 75,
	S5M8767_REG_BUCK4DVS6 = 76,
	S5M8767_REG_BUCK4DVS7 = 77,
	S5M8767_REG_BUCK4DVS8 = 78,
	S5M8767_REG_BUCK5CTRL1 = 79,
	S5M8767_REG_BUCK5CTRL2 = 80,
	S5M8767_REG_BUCK5CTRL3 = 81,
	S5M8767_REG_BUCK5CTRL4 = 82,
	S5M8767_REG_BUCK5CTRL5 = 83,
	S5M8767_REG_BUCK6CTRL1 = 84,
	S5M8767_REG_BUCK6CTRL2 = 85,
	S5M8767_REG_BUCK7CTRL1 = 86,
	S5M8767_REG_BUCK7CTRL2 = 87,
	S5M8767_REG_BUCK8CTRL1 = 88,
	S5M8767_REG_BUCK8CTRL2 = 89,
	S5M8767_REG_BUCK9CTRL1 = 90,
	S5M8767_REG_BUCK9CTRL2 = 91,
	S5M8767_REG_LDO1CTRL = 92,
	S5M8767_REG_LDO2_1CTRL = 93,
	S5M8767_REG_LDO2_2CTRL = 94,
	S5M8767_REG_LDO2_3CTRL = 95,
	S5M8767_REG_LDO2_4CTRL = 96,
	S5M8767_REG_LDO3CTRL = 97,
	S5M8767_REG_LDO4CTRL = 98,
	S5M8767_REG_LDO5CTRL = 99,
	S5M8767_REG_LDO6CTRL = 100,
	S5M8767_REG_LDO7CTRL = 101,
	S5M8767_REG_LDO8CTRL = 102,
	S5M8767_REG_LDO9CTRL = 103,
	S5M8767_REG_LDO10CTRL = 104,
	S5M8767_REG_LDO11CTRL = 105,
	S5M8767_REG_LDO12CTRL = 106,
	S5M8767_REG_LDO13CTRL = 107,
	S5M8767_REG_LDO14CTRL = 108,
	S5M8767_REG_LDO15CTRL = 109,
	S5M8767_REG_LDO16CTRL = 110,
	S5M8767_REG_LDO17CTRL = 111,
	S5M8767_REG_LDO18CTRL = 112,
	S5M8767_REG_LDO19CTRL = 113,
	S5M8767_REG_LDO20CTRL = 114,
	S5M8767_REG_LDO21CTRL = 115,
	S5M8767_REG_LDO22CTRL = 116,
	S5M8767_REG_LDO23CTRL = 117,
	S5M8767_REG_LDO24CTRL = 118,
	S5M8767_REG_LDO25CTRL = 119,
	S5M8767_REG_LDO26CTRL = 120,
	S5M8767_REG_LDO27CTRL = 121,
	S5M8767_REG_LDO28CTRL = 122,
};

enum s5m_rtc_reg {
	S5M_RTC_SEC = 0,
	S5M_RTC_MIN = 1,
	S5M_RTC_HOUR = 2,
	S5M_RTC_WEEKDAY = 3,
	S5M_RTC_DATE = 4,
	S5M_RTC_MONTH = 5,
	S5M_RTC_YEAR1 = 6,
	S5M_RTC_YEAR2 = 7,
	S5M_ALARM0_SEC = 8,
	S5M_ALARM0_MIN = 9,
	S5M_ALARM0_HOUR = 10,
	S5M_ALARM0_WEEKDAY = 11,
	S5M_ALARM0_DATE = 12,
	S5M_ALARM0_MONTH = 13,
	S5M_ALARM0_YEAR1 = 14,
	S5M_ALARM0_YEAR2 = 15,
	S5M_ALARM1_SEC = 16,
	S5M_ALARM1_MIN = 17,
	S5M_ALARM1_HOUR = 18,
	S5M_ALARM1_WEEKDAY = 19,
	S5M_ALARM1_DATE = 20,
	S5M_ALARM1_MONTH = 21,
	S5M_ALARM1_YEAR1 = 22,
	S5M_ALARM1_YEAR2 = 23,
	S5M_ALARM0_CONF = 24,
	S5M_ALARM1_CONF = 25,
	S5M_RTC_STATUS = 26,
	S5M_WTSR_SMPL_CNTL = 27,
	S5M_RTC_UDR_CON = 28,
	S5M_RTC_REG_MAX = 29,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum sas_device_type {
	SAS_PHY_UNUSED = 0,
	SAS_END_DEVICE = 1,
	SAS_EDGE_EXPANDER_DEVICE = 2,
	SAS_FANOUT_EXPANDER_DEVICE = 3,
	SAS_HA = 4,
	SAS_SATA_DEV = 5,
	SAS_SATA_PM = 7,
	SAS_SATA_PM_PORT = 8,
	SAS_SATA_PENDING = 9,
};

enum sas_ha_state {
	SAS_HA_REGISTERED = 0,
	SAS_HA_DRAINING = 1,
	SAS_HA_ATA_EH_ACTIVE = 2,
	SAS_HA_FROZEN = 3,
	SAS_HA_RESUMING = 4,
};

enum sas_internal_abort {
	SAS_INTERNAL_ABORT_SINGLE = 0,
	SAS_INTERNAL_ABORT_DEV = 1,
};

enum sas_linkrate {
	SAS_LINK_RATE_UNKNOWN = 0,
	SAS_PHY_DISABLED = 1,
	SAS_PHY_RESET_PROBLEM = 2,
	SAS_SATA_SPINUP_HOLD = 3,
	SAS_SATA_PORT_SELECTOR = 4,
	SAS_PHY_RESET_IN_PROGRESS = 5,
	SAS_LINK_RATE_1_5_GBPS = 8,
	SAS_LINK_RATE_G1 = 8,
	SAS_LINK_RATE_3_0_GBPS = 9,
	SAS_LINK_RATE_G2 = 9,
	SAS_LINK_RATE_6_0_GBPS = 10,
	SAS_LINK_RATE_12_0_GBPS = 11,
	SAS_LINK_RATE_22_5_GBPS = 12,
	SAS_LINK_RATE_FAILED = 16,
	SAS_PHY_VIRTUAL = 17,
};

enum sas_oob_mode {
	OOB_NOT_CONNECTED = 0,
	SATA_OOB_MODE = 1,
	SAS_OOB_MODE = 2,
};

enum sas_open_rej_reason {
	SAS_OREJ_UNKNOWN = 0,
	SAS_OREJ_BAD_DEST = 1,
	SAS_OREJ_CONN_RATE = 2,
	SAS_OREJ_EPROTO = 3,
	SAS_OREJ_RESV_AB0 = 4,
	SAS_OREJ_RESV_AB1 = 5,
	SAS_OREJ_RESV_AB2 = 6,
	SAS_OREJ_RESV_AB3 = 7,
	SAS_OREJ_WRONG_DEST = 8,
	SAS_OREJ_STP_NORES = 9,
	SAS_OREJ_NO_DEST = 10,
	SAS_OREJ_PATH_BLOCKED = 11,
	SAS_OREJ_RSVD_CONT0 = 12,
	SAS_OREJ_RSVD_CONT1 = 13,
	SAS_OREJ_RSVD_INIT0 = 14,
	SAS_OREJ_RSVD_INIT1 = 15,
	SAS_OREJ_RSVD_STOP0 = 16,
	SAS_OREJ_RSVD_STOP1 = 17,
	SAS_OREJ_RSVD_RETRY = 18,
};

enum sas_phy_role {
	PHY_ROLE_NONE = 0,
	PHY_ROLE_TARGET = 64,
	PHY_ROLE_INITIATOR = 128,
};

enum sas_protocol {
	SAS_PROTOCOL_NONE = 0,
	SAS_PROTOCOL_SATA = 1,
	SAS_PROTOCOL_SMP = 2,
	SAS_PROTOCOL_STP = 4,
	SAS_PROTOCOL_SSP = 8,
	SAS_PROTOCOL_ALL = 14,
	SAS_PROTOCOL_STP_ALL = 5,
	SAS_PROTOCOL_INTERNAL_ABORT = 16,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_guard_type {
	SHOST_DIX_GUARD_CRC = 1,
	SHOST_DIX_GUARD_IP = 2,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 2500,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum sctp_msg_flags {
	MSG_NOTIFICATION = 32768,
};

enum scx_consts {
	SCX_DSP_DFL_MAX_BATCH = 32,
	SCX_DSP_MAX_LOOPS = 32,
	SCX_WATCHDOG_MAX_TIMEOUT = 7500,
	SCX_EXIT_BT_LEN = 64,
	SCX_EXIT_MSG_LEN = 1024,
	SCX_EXIT_DUMP_DFL_LEN = 32768,
	SCX_CPUPERF_ONE = 1024,
	SCX_TASK_ITER_BATCH = 32,
};

enum scx_cpu_preempt_reason {
	SCX_CPU_PREEMPT_RT = 0,
	SCX_CPU_PREEMPT_DL = 1,
	SCX_CPU_PREEMPT_STOP = 2,
	SCX_CPU_PREEMPT_UNKNOWN = 3,
};

enum scx_deq_flags {
	SCX_DEQ_SLEEP = 1ULL,
	SCX_DEQ_CORE_SCHED_EXEC = 4294967296ULL,
};

enum scx_dsq_id_flags {
	SCX_DSQ_FLAG_BUILTIN = 9223372036854775808ULL,
	SCX_DSQ_FLAG_LOCAL_ON = 4611686018427387904ULL,
	SCX_DSQ_INVALID = 9223372036854775808ULL,
	SCX_DSQ_GLOBAL = 9223372036854775809ULL,
	SCX_DSQ_LOCAL = 9223372036854775810ULL,
	SCX_DSQ_LOCAL_ON = 13835058055282163712ULL,
	SCX_DSQ_LOCAL_CPU_MASK = 4294967295ULL,
};

enum scx_dsq_iter_flags {
	SCX_DSQ_ITER_REV = 65536,
	__SCX_DSQ_ITER_HAS_SLICE = 1073741824,
	__SCX_DSQ_ITER_HAS_VTIME = 2147483648,
	__SCX_DSQ_ITER_USER_FLAGS = 65536,
	__SCX_DSQ_ITER_ALL_FLAGS = 3221291008,
};

enum scx_dsq_lnode_flags {
	SCX_DSQ_LNODE_ITER_CURSOR = 1,
	__SCX_DSQ_LNODE_PRIV_SHIFT = 16,
};

enum scx_enable_state {
	SCX_ENABLING = 0,
	SCX_ENABLED = 1,
	SCX_DISABLING = 2,
	SCX_DISABLED = 3,
};

enum scx_enq_flags {
	SCX_ENQ_WAKEUP = 1ULL,
	SCX_ENQ_HEAD = 16ULL,
	SCX_ENQ_CPU_SELECTED = 1024ULL,
	SCX_ENQ_PREEMPT = 4294967296ULL,
	SCX_ENQ_REENQ = 1099511627776ULL,
	SCX_ENQ_LAST = 2199023255552ULL,
	__SCX_ENQ_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_ENQ_CLEAR_OPSS = 72057594037927936ULL,
	SCX_ENQ_DSQ_PRIQ = 144115188075855872ULL,
};

enum scx_ent_dsq_flags {
	SCX_TASK_DSQ_ON_PRIQ = 1,
};

enum scx_ent_flags {
	SCX_TASK_QUEUED = 1,
	SCX_TASK_RESET_RUNNABLE_AT = 4,
	SCX_TASK_DEQD_FOR_SLEEP = 8,
	SCX_TASK_STATE_SHIFT = 8,
	SCX_TASK_STATE_BITS = 2,
	SCX_TASK_STATE_MASK = 768,
	SCX_TASK_CURSOR = -2147483648,
};

enum scx_exit_code {
	SCX_ECODE_RSN_HOTPLUG = 4294967296ULL,
	SCX_ECODE_ACT_RESTART = 281474976710656ULL,
};

enum scx_exit_kind {
	SCX_EXIT_NONE = 0,
	SCX_EXIT_DONE = 1,
	SCX_EXIT_UNREG = 64,
	SCX_EXIT_UNREG_BPF = 65,
	SCX_EXIT_UNREG_KERN = 66,
	SCX_EXIT_SYSRQ = 67,
	SCX_EXIT_ERROR = 1024,
	SCX_EXIT_ERROR_BPF = 1025,
	SCX_EXIT_ERROR_STALL = 1026,
};

enum scx_kf_mask {
	SCX_KF_UNLOCKED = 0,
	SCX_KF_CPU_RELEASE = 1,
	SCX_KF_DISPATCH = 2,
	SCX_KF_ENQUEUE = 4,
	SCX_KF_SELECT_CPU = 8,
	SCX_KF_REST = 16,
	__SCX_KF_RQ_LOCKED = 31,
	__SCX_KF_TERMINAL = 28,
};

enum scx_kick_flags {
	SCX_KICK_IDLE = 1,
	SCX_KICK_PREEMPT = 2,
	SCX_KICK_WAIT = 4,
};

enum scx_opi {
	SCX_OPI_BEGIN = 0,
	SCX_OPI_NORMAL_BEGIN = 0,
	SCX_OPI_NORMAL_END = 29,
	SCX_OPI_CPU_HOTPLUG_BEGIN = 29,
	SCX_OPI_CPU_HOTPLUG_END = 31,
	SCX_OPI_END = 31,
};

enum scx_ops_flags {
	SCX_OPS_KEEP_BUILTIN_IDLE = 1ULL,
	SCX_OPS_ENQ_LAST = 2ULL,
	SCX_OPS_ENQ_EXITING = 4ULL,
	SCX_OPS_SWITCH_PARTIAL = 8ULL,
	SCX_OPS_ENQ_MIGRATION_DISABLED = 16ULL,
	SCX_OPS_ALLOW_QUEUED_WAKEUP = 32ULL,
	SCX_OPS_BUILTIN_IDLE_PER_NODE = 64ULL,
	SCX_OPS_HAS_CGROUP_WEIGHT = 65536ULL,
	SCX_OPS_ALL_FLAGS = 65663ULL,
	__SCX_OPS_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_OPS_HAS_CPU_PREEMPT = 72057594037927936ULL,
};

enum scx_ops_state {
	SCX_OPSS_NONE = 0,
	SCX_OPSS_QUEUEING = 1,
	SCX_OPSS_QUEUED = 2,
	SCX_OPSS_DISPATCHING = 3,
	SCX_OPSS_QSEQ_SHIFT = 2,
};

enum scx_pick_idle_cpu_flags {
	SCX_PICK_IDLE_CORE = 1,
	SCX_PICK_IDLE_IN_NODE = 2,
};

enum scx_public_consts {
	SCX_OPS_NAME_LEN = 128ULL,
	SCX_SLICE_DFL = 20000000ULL,
	SCX_SLICE_INF = 18446744073709551615ULL,
};

enum scx_rq_flags {
	SCX_RQ_ONLINE = 1,
	SCX_RQ_CAN_STOP_TICK = 2,
	SCX_RQ_BAL_PENDING = 4,
	SCX_RQ_BAL_KEEP = 8,
	SCX_RQ_BYPASSING = 16,
	SCX_RQ_CLK_VALID = 32,
	SCX_RQ_IN_WAKEUP = 65536,
	SCX_RQ_IN_BALANCE = 131072,
};

enum scx_task_state {
	SCX_TASK_NONE = 0,
	SCX_TASK_INIT = 1,
	SCX_TASK_READY = 2,
	SCX_TASK_ENABLED = 3,
	SCX_TASK_NR_STATES = 4,
};

enum scx_tg_flags {
	SCX_TG_ONLINE = 1,
	SCX_TG_INITED = 2,
};

enum scx_wake_flags {
	SCX_WAKE_FORK = 4,
	SCX_WAKE_TTWU = 8,
	SCX_WAKE_SYNC = 16,
};

enum sd_uhs2_operation {
	UHS2_PHY_INIT = 0,
	UHS2_SET_CONFIG = 1,
	UHS2_ENABLE_INT = 2,
	UHS2_DISABLE_INT = 3,
	UHS2_ENABLE_CLK = 4,
	UHS2_DISABLE_CLK = 5,
	UHS2_CHECK_DORMANT = 6,
	UHS2_SET_IOS = 7,
};

enum sdhci_cookie {
	COOKIE_UNMAPPED___2 = 0,
	COOKIE_PRE_MAPPED___2 = 1,
	COOKIE_MAPPED___2 = 2,
};

enum sdhci_reset_reason {
	SDHCI_RESET_FOR_INIT = 0,
	SDHCI_RESET_FOR_REQUEST_ERROR = 1,
	SDHCI_RESET_FOR_REQUEST_ERROR_DATA_ONLY = 2,
	SDHCI_RESET_FOR_TUNING_ABORT = 3,
	SDHCI_RESET_FOR_CARD_REMOVED = 4,
	SDHCI_RESET_FOR_CQE_RECOVERY = 5,
};

enum sec_device_type {
	S5M8767X = 0,
	S2DOS05 = 1,
	S2MPA01 = 2,
	S2MPG10 = 3,
	S2MPS11X = 4,
	S2MPS13X = 5,
	S2MPS14X = 6,
	S2MPS15X = 7,
	S2MPU02 = 8,
	S2MPU05 = 9,
};

enum serdev_parity {
	SERDEV_PARITY_NONE = 0,
	SERDEV_PARITY_EVEN = 1,
	SERDEV_PARITY_ODD = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum service_response {
	SAS_TASK_COMPLETE = 0,
	SAS_TASK_UNDELIVERED = -1,
};

enum set_event_iter_type {
	SET_EVENT_FILE = 0,
	SET_EVENT_MOD = 1,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum shmem_param {
	Opt_gid___7 = 0,
	Opt_huge = 1,
	Opt_mode___5 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes = 5,
	Opt_size = 6,
	Opt_uid___6 = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota___2 = 11,
	Opt_usrquota___2 = 12,
	Opt_grpquota___2 = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
	Opt_casefold_version = 18,
	Opt_casefold = 19,
	Opt_strict_encoding = 20,
};

enum si_type {
	SI_TYPE_INVALID = 0,
	SI_KCS = 1,
	SI_SMIC = 2,
	SI_BT = 3,
	SI_TYPE_MAX = 4,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_TCP_ABORT_ON_CLOSE = 11,
	SK_RST_REASON_TCP_ABORT_ON_LINGER = 12,
	SK_RST_REASON_TCP_ABORT_ON_MEMORY = 13,
	SK_RST_REASON_TCP_STATE = 14,
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT = 15,
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA = 16,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 17,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 18,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 19,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 20,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 21,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 22,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 23,
	SK_RST_REASON_ERROR = 24,
	SK_RST_REASON_MAX = 25,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_SOCKET_CLOSE = 4,
	SKB_DROP_REASON_SOCKET_FILTER = 5,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 6,
	SKB_DROP_REASON_UNIX_DISCONNECT = 7,
	SKB_DROP_REASON_UNIX_SKIP_OOB = 8,
	SKB_DROP_REASON_PKT_TOO_SMALL = 9,
	SKB_DROP_REASON_TCP_CSUM = 10,
	SKB_DROP_REASON_UDP_CSUM = 11,
	SKB_DROP_REASON_NETFILTER_DROP = 12,
	SKB_DROP_REASON_OTHERHOST = 13,
	SKB_DROP_REASON_IP_CSUM = 14,
	SKB_DROP_REASON_IP_INHDR = 15,
	SKB_DROP_REASON_IP_RPFILTER = 16,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 17,
	SKB_DROP_REASON_XFRM_POLICY = 18,
	SKB_DROP_REASON_IP_NOPROTO = 19,
	SKB_DROP_REASON_PROTO_MEM = 20,
	SKB_DROP_REASON_TCP_AUTH_HDR = 21,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 22,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 23,
	SKB_DROP_REASON_TCP_MD5FAILURE = 24,
	SKB_DROP_REASON_TCP_AONOTFOUND = 25,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 26,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 27,
	SKB_DROP_REASON_TCP_AOFAILURE = 28,
	SKB_DROP_REASON_SOCKET_BACKLOG = 29,
	SKB_DROP_REASON_TCP_FLAGS = 30,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 31,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 32,
	SKB_DROP_REASON_TCP_OLD_DATA = 33,
	SKB_DROP_REASON_TCP_OVERWINDOW = 34,
	SKB_DROP_REASON_TCP_OFOMERGE = 35,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 36,
	SKB_DROP_REASON_TCP_RFC7323_PAWS_ACK = 37,
	SKB_DROP_REASON_TCP_RFC7323_TW_PAWS = 38,
	SKB_DROP_REASON_TCP_RFC7323_TSECR = 39,
	SKB_DROP_REASON_TCP_LISTEN_OVERFLOW = 40,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 41,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 42,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 43,
	SKB_DROP_REASON_TCP_RESET = 44,
	SKB_DROP_REASON_TCP_INVALID_SYN = 45,
	SKB_DROP_REASON_TCP_CLOSE = 46,
	SKB_DROP_REASON_TCP_FASTOPEN = 47,
	SKB_DROP_REASON_TCP_OLD_ACK = 48,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 49,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 50,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 51,
	SKB_DROP_REASON_TCP_OFO_DROP = 52,
	SKB_DROP_REASON_IP_OUTNOROUTES = 53,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 54,
	SKB_DROP_REASON_IPV6DISABLED = 55,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 56,
	SKB_DROP_REASON_NEIGH_FAILED = 57,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 58,
	SKB_DROP_REASON_NEIGH_DEAD = 59,
	SKB_DROP_REASON_NEIGH_HH_FILLFAIL = 60,
	SKB_DROP_REASON_TC_EGRESS = 61,
	SKB_DROP_REASON_SECURITY_HOOK = 62,
	SKB_DROP_REASON_QDISC_DROP = 63,
	SKB_DROP_REASON_QDISC_OVERLIMIT = 64,
	SKB_DROP_REASON_QDISC_CONGESTED = 65,
	SKB_DROP_REASON_CAKE_FLOOD = 66,
	SKB_DROP_REASON_FQ_BAND_LIMIT = 67,
	SKB_DROP_REASON_FQ_HORIZON_LIMIT = 68,
	SKB_DROP_REASON_FQ_FLOW_LIMIT = 69,
	SKB_DROP_REASON_CPU_BACKLOG = 70,
	SKB_DROP_REASON_XDP = 71,
	SKB_DROP_REASON_TC_INGRESS = 72,
	SKB_DROP_REASON_UNHANDLED_PROTO = 73,
	SKB_DROP_REASON_SKB_CSUM = 74,
	SKB_DROP_REASON_SKB_GSO_SEG = 75,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 76,
	SKB_DROP_REASON_DEV_HDR = 77,
	SKB_DROP_REASON_DEV_READY = 78,
	SKB_DROP_REASON_FULL_RING = 79,
	SKB_DROP_REASON_NOMEM = 80,
	SKB_DROP_REASON_HDR_TRUNC = 81,
	SKB_DROP_REASON_TAP_FILTER = 82,
	SKB_DROP_REASON_TAP_TXFILTER = 83,
	SKB_DROP_REASON_ICMP_CSUM = 84,
	SKB_DROP_REASON_INVALID_PROTO = 85,
	SKB_DROP_REASON_IP_INADDRERRORS = 86,
	SKB_DROP_REASON_IP_INNOROUTES = 87,
	SKB_DROP_REASON_IP_LOCAL_SOURCE = 88,
	SKB_DROP_REASON_IP_INVALID_SOURCE = 89,
	SKB_DROP_REASON_IP_LOCALNET = 90,
	SKB_DROP_REASON_IP_INVALID_DEST = 91,
	SKB_DROP_REASON_PKT_TOO_BIG = 92,
	SKB_DROP_REASON_DUP_FRAG = 93,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 94,
	SKB_DROP_REASON_FRAG_TOO_FAR = 95,
	SKB_DROP_REASON_TCP_MINTTL = 96,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 97,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 98,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 99,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 100,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 101,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 102,
	SKB_DROP_REASON_QUEUE_PURGE = 103,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 104,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 105,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 106,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 107,
	SKB_DROP_REASON_VXLAN_INVALID_HDR = 108,
	SKB_DROP_REASON_VXLAN_VNI_NOT_FOUND = 109,
	SKB_DROP_REASON_MAC_INVALID_SOURCE = 110,
	SKB_DROP_REASON_VXLAN_ENTRY_EXISTS = 111,
	SKB_DROP_REASON_NO_TX_TARGET = 112,
	SKB_DROP_REASON_IP_TUNNEL_ECN = 113,
	SKB_DROP_REASON_TUNNEL_TXINFO = 114,
	SKB_DROP_REASON_LOCAL_MAC = 115,
	SKB_DROP_REASON_ARP_PVLAN_DISABLE = 116,
	SKB_DROP_REASON_MAC_IEEE_MAC_CONTROL = 117,
	SKB_DROP_REASON_BRIDGE_INGRESS_STP_STATE = 118,
	SKB_DROP_REASON_MAX = 119,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 2,
	SKB_DROP_REASON_SUBSYS_NUM = 3,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_NUM = 1,
};

enum skb_tstamp_type {
	SKB_CLOCK_REALTIME = 0,
	SKB_CLOCK_MONOTONIC = 1,
	SKB_CLOCK_TAI = 2,
	__SKB_CLOCK_MAX = 2,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN___2 = 0,
	PARTIAL = 1,
	UP___2 = 2,
	FULL = 3,
};

enum snd_compr_direction {
	SND_COMPRESS_PLAYBACK = 0,
	SND_COMPRESS_CAPTURE = 1,
	SND_COMPRESS_ACCEL = 2,
};

enum snd_ctl_add_mode {
	CTL_ADD_EXCLUSIVE = 0,
	CTL_REPLACE = 1,
	CTL_ADD_ON_REPLACE = 2,
};

enum snd_device_state {
	SNDRV_DEV_BUILD = 0,
	SNDRV_DEV_REGISTERED = 1,
	SNDRV_DEV_DISCONNECTED = 2,
};

enum snd_device_type {
	SNDRV_DEV_LOWLEVEL = 0,
	SNDRV_DEV_INFO = 1,
	SNDRV_DEV_BUS = 2,
	SNDRV_DEV_CODEC = 3,
	SNDRV_DEV_PCM = 4,
	SNDRV_DEV_COMPRESS = 5,
	SNDRV_DEV_RAWMIDI = 6,
	SNDRV_DEV_TIMER = 7,
	SNDRV_DEV_SEQUENCER = 8,
	SNDRV_DEV_HWDEP = 9,
	SNDRV_DEV_JACK = 10,
	SNDRV_DEV_CONTROL = 11,
};

enum snd_dma_sync_mode {
	SNDRV_DMA_SYNC_CPU = 0,
	SNDRV_DMA_SYNC_DEVICE = 1,
};

enum snd_jack_types {
	SND_JACK_HEADPHONE = 1,
	SND_JACK_MICROPHONE = 2,
	SND_JACK_HEADSET = 3,
	SND_JACK_LINEOUT = 4,
	SND_JACK_MECHANICAL = 8,
	SND_JACK_VIDEOOUT = 16,
	SND_JACK_AVOUT = 20,
	SND_JACK_LINEIN = 32,
	SND_JACK_USB = 64,
	SND_JACK_BTN_0 = 16384,
	SND_JACK_BTN_1 = 8192,
	SND_JACK_BTN_2 = 4096,
	SND_JACK_BTN_3 = 2048,
	SND_JACK_BTN_4 = 1024,
	SND_JACK_BTN_5 = 512,
};

enum snd_soc_bias_level {
	SND_SOC_BIAS_OFF = 0,
	SND_SOC_BIAS_STANDBY = 1,
	SND_SOC_BIAS_PREPARE = 2,
	SND_SOC_BIAS_ON = 3,
};

enum snd_soc_dapm_direction {
	SND_SOC_DAPM_DIR_IN = 0,
	SND_SOC_DAPM_DIR_OUT = 1,
};

enum snd_soc_dapm_type {
	snd_soc_dapm_input = 0,
	snd_soc_dapm_output = 1,
	snd_soc_dapm_mux = 2,
	snd_soc_dapm_demux = 3,
	snd_soc_dapm_mixer = 4,
	snd_soc_dapm_mixer_named_ctl = 5,
	snd_soc_dapm_pga = 6,
	snd_soc_dapm_out_drv = 7,
	snd_soc_dapm_adc = 8,
	snd_soc_dapm_dac = 9,
	snd_soc_dapm_micbias = 10,
	snd_soc_dapm_mic = 11,
	snd_soc_dapm_hp = 12,
	snd_soc_dapm_spk = 13,
	snd_soc_dapm_line = 14,
	snd_soc_dapm_switch = 15,
	snd_soc_dapm_vmid = 16,
	snd_soc_dapm_pre = 17,
	snd_soc_dapm_post = 18,
	snd_soc_dapm_supply = 19,
	snd_soc_dapm_pinctrl = 20,
	snd_soc_dapm_regulator_supply = 21,
	snd_soc_dapm_clock_supply = 22,
	snd_soc_dapm_aif_in = 23,
	snd_soc_dapm_aif_out = 24,
	snd_soc_dapm_siggen = 25,
	snd_soc_dapm_sink = 26,
	snd_soc_dapm_dai_in = 27,
	snd_soc_dapm_dai_out = 28,
	snd_soc_dapm_dai_link = 29,
	snd_soc_dapm_kcontrol = 30,
	snd_soc_dapm_buffer = 31,
	snd_soc_dapm_scheduler = 32,
	snd_soc_dapm_effect = 33,
	snd_soc_dapm_src = 34,
	snd_soc_dapm_asrc = 35,
	snd_soc_dapm_encoder = 36,
	snd_soc_dapm_decoder = 37,
	SND_SOC_DAPM_TYPE_COUNT = 38,
};

enum snd_soc_dobj_type {
	SND_SOC_DOBJ_NONE = 0,
	SND_SOC_DOBJ_MIXER = 1,
	SND_SOC_DOBJ_BYTES = 2,
	SND_SOC_DOBJ_ENUM = 3,
	SND_SOC_DOBJ_GRAPH = 4,
	SND_SOC_DOBJ_WIDGET = 5,
	SND_SOC_DOBJ_DAI_LINK = 6,
	SND_SOC_DOBJ_PCM = 7,
	SND_SOC_DOBJ_CODEC_LINK = 8,
	SND_SOC_DOBJ_BACKEND_LINK = 9,
};

enum snd_soc_dpcm_link_state {
	SND_SOC_DPCM_LINK_STATE_NEW = 0,
	SND_SOC_DPCM_LINK_STATE_FREE = 1,
};

enum snd_soc_dpcm_state {
	SND_SOC_DPCM_STATE_NEW = 0,
	SND_SOC_DPCM_STATE_OPEN = 1,
	SND_SOC_DPCM_STATE_HW_PARAMS = 2,
	SND_SOC_DPCM_STATE_PREPARE = 3,
	SND_SOC_DPCM_STATE_START = 4,
	SND_SOC_DPCM_STATE_STOP = 5,
	SND_SOC_DPCM_STATE_PAUSED = 6,
	SND_SOC_DPCM_STATE_SUSPEND = 7,
	SND_SOC_DPCM_STATE_HW_FREE = 8,
	SND_SOC_DPCM_STATE_CLOSE = 9,
};

enum snd_soc_dpcm_trigger {
	SND_SOC_DPCM_TRIGGER_PRE = 0,
	SND_SOC_DPCM_TRIGGER_POST = 1,
};

enum snd_soc_dpcm_update {
	SND_SOC_DPCM_UPDATE_NO = 0,
	SND_SOC_DPCM_UPDATE_BE = 1,
	SND_SOC_DPCM_UPDATE_FE = 2,
};

enum snd_soc_pcm_subclass {
	SND_SOC_PCM_CLASS_PCM = 0,
	SND_SOC_PCM_CLASS_BE = 1,
};

enum snd_soc_trigger_order {
	SND_SOC_TRIGGER_ORDER_DEFAULT = 0,
	SND_SOC_TRIGGER_ORDER_LDC = 1,
	SND_SOC_TRIGGER_ORDER_MAX = 2,
};

enum sndrv_ctl_event_type {
	SNDRV_CTL_EVENT_ELEM = 0,
	SNDRV_CTL_EVENT_LAST = 0,
};

enum snoop_when {
	SUBMIT = 0,
	COMPLETE = 1,
};

enum soc_pad_ctrl_type {
	SOC_PAD_SD = 0,
	SOC_PAD_FIXED_1_8V = 1,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
	SOCK_RCVPRIORITY = 28,
	SOCK_TIMESTAMPING_ANY = 29,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_DGRAM = 1,
	SOCK_STREAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum socket_flags {
	SOCKWQ_ASYNC_NOSPACE = 0,
	SOCKWQ_ASYNC_WAITDATA = 1,
	SOCK_NOSPACE = 2,
	SOCK_SUPPORT_ZC = 3,
	SOCK_CUSTOM_SOCKOPT = 4,
};

enum spec2_op {
	madd_op = 0,
	maddu_op = 1,
	mul_op = 2,
	spec2_3_unused_op = 3,
	msub_op = 4,
	msubu_op = 5,
	clz_op = 32,
	clo_op = 33,
	dclz_op = 36,
	dclo_op = 37,
	sdbpp_op = 63,
};

enum spec3_op {
	ext_op = 0,
	dextm_op = 1,
	dextu_op = 2,
	dext_op = 3,
	ins_op = 4,
	dinsm_op = 5,
	dinsu_op = 6,
	dins_op = 7,
	yield_op = 9,
	lx_op = 10,
	lwle_op = 25,
	lwre_op = 26,
	cachee_op = 27,
	sbe_op = 28,
	she_op = 29,
	sce_op = 30,
	swe_op = 31,
	bshfl_op = 32,
	swle_op = 33,
	swre_op = 34,
	prefe_op = 35,
	dbshfl_op = 36,
	cache6_op = 37,
	sc6_op = 38,
	scd6_op = 39,
	lbue_op = 40,
	lhue_op = 41,
	lbe_op = 44,
	lhe_op = 45,
	lle_op = 46,
	lwe_op = 47,
	pref6_op = 53,
	ll6_op = 54,
	lld6_op = 55,
	rdhwr_op = 59,
};

enum spec_op {
	sll_op = 0,
	movc_op = 1,
	srl_op = 2,
	sra_op = 3,
	sllv_op = 4,
	pmon_op = 5,
	srlv_op = 6,
	srav_op = 7,
	jr_op = 8,
	jalr_op = 9,
	movz_op = 10,
	movn_op = 11,
	syscall_op = 12,
	break_op = 13,
	spim_op = 14,
	sync_op = 15,
	mfhi_op = 16,
	mthi_op = 17,
	mflo_op = 18,
	mtlo_op = 19,
	dsllv_op = 20,
	spec2_unused_op = 21,
	dsrlv_op = 22,
	dsrav_op = 23,
	mult_op = 24,
	multu_op = 25,
	div_op = 26,
	divu_op = 27,
	dmult_op = 28,
	dmultu_op = 29,
	ddiv_op = 30,
	ddivu_op = 31,
	add_op = 32,
	addu_op = 33,
	sub_op = 34,
	subu_op = 35,
	and_op = 36,
	or_op = 37,
	xor_op = 38,
	nor_op = 39,
	spec3_unused_op = 40,
	spec4_unused_op = 41,
	slt_op = 42,
	sltu_op = 43,
	dadd_op = 44,
	daddu_op = 45,
	dsub_op = 46,
	dsubu_op = 47,
	tge_op = 48,
	tgeu_op = 49,
	tlt_op = 50,
	tltu_op = 51,
	teq_op = 52,
	seleqz_op = 53,
	tne_op = 54,
	selnez_op = 55,
	dsll_op = 56,
	spec5_unused_op = 57,
	dsrl_op = 58,
	dsra_op = 59,
	dsll32_op = 60,
	spec6_unused_op = 61,
	dsrl32_op = 62,
	dsra32_op = 63,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_list_front = 7,
	KF_bpf_list_back = 8,
	KF_bpf_cast_to_kern_ctx = 9,
	KF_bpf_rdonly_cast = 10,
	KF_bpf_rcu_read_lock = 11,
	KF_bpf_rcu_read_unlock = 12,
	KF_bpf_rbtree_remove = 13,
	KF_bpf_rbtree_add_impl = 14,
	KF_bpf_rbtree_first = 15,
	KF_bpf_rbtree_root = 16,
	KF_bpf_rbtree_left = 17,
	KF_bpf_rbtree_right = 18,
	KF_bpf_dynptr_from_skb = 19,
	KF_bpf_dynptr_from_xdp = 20,
	KF_bpf_dynptr_slice = 21,
	KF_bpf_dynptr_slice_rdwr = 22,
	KF_bpf_dynptr_clone = 23,
	KF_bpf_percpu_obj_new_impl = 24,
	KF_bpf_percpu_obj_drop_impl = 25,
	KF_bpf_throw = 26,
	KF_bpf_wq_set_callback_impl = 27,
	KF_bpf_preempt_disable = 28,
	KF_bpf_preempt_enable = 29,
	KF_bpf_iter_css_task_new = 30,
	KF_bpf_session_cookie = 31,
	KF_bpf_get_kmem_cache = 32,
	KF_bpf_local_irq_save = 33,
	KF_bpf_local_irq_restore = 34,
	KF_bpf_iter_num_new = 35,
	KF_bpf_iter_num_next = 36,
	KF_bpf_iter_num_destroy = 37,
	KF_bpf_set_dentry_xattr = 38,
	KF_bpf_remove_dentry_xattr = 39,
	KF_bpf_res_spin_lock = 40,
	KF_bpf_res_spin_unlock = 41,
	KF_bpf_res_spin_lock_irqsave = 42,
	KF_bpf_res_spin_unlock_irqrestore = 43,
	KF___bpf_trap = 44,
};

enum spi_mem_data_dir {
	SPI_MEM_NO_DATA = 0,
	SPI_MEM_DATA_IN = 1,
	SPI_MEM_DATA_OUT = 2,
};

enum spi_nor_cmd_ext {
	SPI_NOR_EXT_NONE = 0,
	SPI_NOR_EXT_REPEAT = 1,
	SPI_NOR_EXT_INVERT = 2,
	SPI_NOR_EXT_HEX = 3,
};

enum spi_nor_option_flags {
	SNOR_F_HAS_SR_TB = 1,
	SNOR_F_NO_OP_CHIP_ERASE = 2,
	SNOR_F_BROKEN_RESET = 4,
	SNOR_F_4B_OPCODES = 8,
	SNOR_F_HAS_4BAIT = 16,
	SNOR_F_HAS_LOCK = 32,
	SNOR_F_HAS_16BIT_SR = 64,
	SNOR_F_NO_READ_CR = 128,
	SNOR_F_HAS_SR_TB_BIT6 = 256,
	SNOR_F_HAS_4BIT_BP = 512,
	SNOR_F_HAS_SR_BP3_BIT6 = 1024,
	SNOR_F_IO_MODE_EN_VOLATILE = 2048,
	SNOR_F_SOFT_RESET = 4096,
	SNOR_F_SWP_IS_VOLATILE = 8192,
	SNOR_F_RWW = 16384,
	SNOR_F_ECC = 32768,
	SNOR_F_NO_WP = 65536,
	SNOR_F_SWAP16 = 131072,
};

enum spi_nor_pp_command_index {
	SNOR_CMD_PP = 0,
	SNOR_CMD_PP_1_1_4 = 1,
	SNOR_CMD_PP_1_4_4 = 2,
	SNOR_CMD_PP_4_4_4 = 3,
	SNOR_CMD_PP_1_1_8 = 4,
	SNOR_CMD_PP_1_8_8 = 5,
	SNOR_CMD_PP_8_8_8 = 6,
	SNOR_CMD_PP_8_8_8_DTR = 7,
	SNOR_CMD_PP_MAX = 8,
};

enum spi_nor_protocol {
	SNOR_PROTO_1_1_1 = 65793,
	SNOR_PROTO_1_1_2 = 65794,
	SNOR_PROTO_1_1_4 = 65796,
	SNOR_PROTO_1_1_8 = 65800,
	SNOR_PROTO_1_2_2 = 66050,
	SNOR_PROTO_1_4_4 = 66564,
	SNOR_PROTO_1_8_8 = 67592,
	SNOR_PROTO_2_2_2 = 131586,
	SNOR_PROTO_4_4_4 = 263172,
	SNOR_PROTO_8_8_8 = 526344,
	SNOR_PROTO_1_1_1_DTR = 16843009,
	SNOR_PROTO_1_2_2_DTR = 16843266,
	SNOR_PROTO_1_4_4_DTR = 16843780,
	SNOR_PROTO_1_8_8_DTR = 16844808,
	SNOR_PROTO_8_8_8_DTR = 17303560,
};

enum spi_nor_read_command_index {
	SNOR_CMD_READ = 0,
	SNOR_CMD_READ_FAST = 1,
	SNOR_CMD_READ_1_1_1_DTR = 2,
	SNOR_CMD_READ_1_1_2 = 3,
	SNOR_CMD_READ_1_2_2 = 4,
	SNOR_CMD_READ_2_2_2 = 5,
	SNOR_CMD_READ_1_2_2_DTR = 6,
	SNOR_CMD_READ_1_1_4 = 7,
	SNOR_CMD_READ_1_4_4 = 8,
	SNOR_CMD_READ_4_4_4 = 9,
	SNOR_CMD_READ_1_4_4_DTR = 10,
	SNOR_CMD_READ_1_1_8 = 11,
	SNOR_CMD_READ_1_8_8 = 12,
	SNOR_CMD_READ_8_8_8 = 13,
	SNOR_CMD_READ_1_8_8_DTR = 14,
	SNOR_CMD_READ_8_8_8_DTR = 15,
	SNOR_CMD_READ_MAX = 16,
};

enum spmi_boost_byp_registers {
	SPMI_BOOST_BYP_REG_CURRENT_LIMIT = 75,
};

enum spmi_boost_registers {
	SPMI_BOOST_REG_CURRENT_LIMIT = 74,
};

enum spmi_common_control_register_index {
	SPMI_COMMON_IDX_VOLTAGE_RANGE = 0,
	SPMI_COMMON_IDX_VOLTAGE_SET = 1,
	SPMI_COMMON_IDX_MODE = 5,
	SPMI_COMMON_IDX_ENABLE = 6,
};

enum spmi_common_regulator_registers {
	SPMI_COMMON_REG_DIG_MAJOR_REV = 1,
	SPMI_COMMON_REG_TYPE = 4,
	SPMI_COMMON_REG_SUBTYPE = 5,
	SPMI_COMMON_REG_VOLTAGE_RANGE = 64,
	SPMI_COMMON_REG_VOLTAGE_SET = 65,
	SPMI_COMMON_REG_MODE = 69,
	SPMI_COMMON_REG_ENABLE = 70,
	SPMI_COMMON_REG_PULL_DOWN = 72,
	SPMI_COMMON_REG_SOFT_START = 76,
	SPMI_COMMON_REG_STEP_CTRL = 97,
};

enum spmi_ftsmps426_regulator_registers {
	SPMI_FTSMPS426_REG_VOLTAGE_LSB = 64,
	SPMI_FTSMPS426_REG_VOLTAGE_MSB = 65,
	SPMI_FTSMPS426_REG_VOLTAGE_ULS_LSB = 104,
	SPMI_FTSMPS426_REG_VOLTAGE_ULS_MSB = 105,
};

enum spmi_hfsmps_regulator_registers {
	SPMI_HFSMPS_REG_STEP_CTRL = 60,
	SPMI_HFSMPS_REG_PULL_DOWN = 160,
};

enum spmi_regulator_logical_type {
	SPMI_REGULATOR_LOGICAL_TYPE_SMPS = 0,
	SPMI_REGULATOR_LOGICAL_TYPE_LDO = 1,
	SPMI_REGULATOR_LOGICAL_TYPE_VS = 2,
	SPMI_REGULATOR_LOGICAL_TYPE_BOOST = 3,
	SPMI_REGULATOR_LOGICAL_TYPE_FTSMPS = 4,
	SPMI_REGULATOR_LOGICAL_TYPE_BOOST_BYP = 5,
	SPMI_REGULATOR_LOGICAL_TYPE_LN_LDO = 6,
	SPMI_REGULATOR_LOGICAL_TYPE_ULT_LO_SMPS = 7,
	SPMI_REGULATOR_LOGICAL_TYPE_ULT_HO_SMPS = 8,
	SPMI_REGULATOR_LOGICAL_TYPE_ULT_LDO = 9,
	SPMI_REGULATOR_LOGICAL_TYPE_FTSMPS426 = 10,
	SPMI_REGULATOR_LOGICAL_TYPE_HFS430 = 11,
	SPMI_REGULATOR_LOGICAL_TYPE_FTSMPS3 = 12,
	SPMI_REGULATOR_LOGICAL_TYPE_LDO_510 = 13,
	SPMI_REGULATOR_LOGICAL_TYPE_HFSMPS = 14,
};

enum spmi_regulator_subtype {
	SPMI_REGULATOR_SUBTYPE_GP_CTL = 8,
	SPMI_REGULATOR_SUBTYPE_RF_CTL = 9,
	SPMI_REGULATOR_SUBTYPE_N50 = 1,
	SPMI_REGULATOR_SUBTYPE_N150 = 2,
	SPMI_REGULATOR_SUBTYPE_N300 = 3,
	SPMI_REGULATOR_SUBTYPE_N600 = 4,
	SPMI_REGULATOR_SUBTYPE_N1200 = 5,
	SPMI_REGULATOR_SUBTYPE_N600_ST = 6,
	SPMI_REGULATOR_SUBTYPE_N1200_ST = 7,
	SPMI_REGULATOR_SUBTYPE_N900_ST = 20,
	SPMI_REGULATOR_SUBTYPE_N300_ST = 21,
	SPMI_REGULATOR_SUBTYPE_P50 = 8,
	SPMI_REGULATOR_SUBTYPE_P150 = 9,
	SPMI_REGULATOR_SUBTYPE_P300 = 10,
	SPMI_REGULATOR_SUBTYPE_P600 = 11,
	SPMI_REGULATOR_SUBTYPE_P1200 = 12,
	SPMI_REGULATOR_SUBTYPE_LN = 16,
	SPMI_REGULATOR_SUBTYPE_LV_P50 = 40,
	SPMI_REGULATOR_SUBTYPE_LV_P150 = 41,
	SPMI_REGULATOR_SUBTYPE_LV_P300 = 42,
	SPMI_REGULATOR_SUBTYPE_LV_P600 = 43,
	SPMI_REGULATOR_SUBTYPE_LV_P1200 = 44,
	SPMI_REGULATOR_SUBTYPE_LV_P450 = 45,
	SPMI_REGULATOR_SUBTYPE_HT_N300_ST = 48,
	SPMI_REGULATOR_SUBTYPE_HT_N600_ST = 49,
	SPMI_REGULATOR_SUBTYPE_HT_N1200_ST = 50,
	SPMI_REGULATOR_SUBTYPE_HT_LVP150 = 59,
	SPMI_REGULATOR_SUBTYPE_HT_LVP300 = 60,
	SPMI_REGULATOR_SUBTYPE_L660_N300_ST = 66,
	SPMI_REGULATOR_SUBTYPE_L660_N600_ST = 67,
	SPMI_REGULATOR_SUBTYPE_L660_P50 = 70,
	SPMI_REGULATOR_SUBTYPE_L660_P150 = 71,
	SPMI_REGULATOR_SUBTYPE_L660_P600 = 73,
	SPMI_REGULATOR_SUBTYPE_L660_LVP150 = 77,
	SPMI_REGULATOR_SUBTYPE_L660_LVP600 = 79,
	SPMI_REGULATOR_SUBTYPE_LV100 = 1,
	SPMI_REGULATOR_SUBTYPE_LV300 = 2,
	SPMI_REGULATOR_SUBTYPE_MV300 = 8,
	SPMI_REGULATOR_SUBTYPE_MV500 = 9,
	SPMI_REGULATOR_SUBTYPE_HDMI = 16,
	SPMI_REGULATOR_SUBTYPE_OTG = 17,
	SPMI_REGULATOR_SUBTYPE_5V_BOOST = 1,
	SPMI_REGULATOR_SUBTYPE_FTS_CTL = 8,
	SPMI_REGULATOR_SUBTYPE_FTS2p5_CTL = 9,
	SPMI_REGULATOR_SUBTYPE_FTS426_CTL = 10,
	SPMI_REGULATOR_SUBTYPE_BB_2A = 1,
	SPMI_REGULATOR_SUBTYPE_ULT_HF_CTL1 = 13,
	SPMI_REGULATOR_SUBTYPE_ULT_HF_CTL2 = 14,
	SPMI_REGULATOR_SUBTYPE_ULT_HF_CTL3 = 15,
	SPMI_REGULATOR_SUBTYPE_ULT_HF_CTL4 = 16,
	SPMI_REGULATOR_SUBTYPE_HFS430 = 10,
	SPMI_REGULATOR_SUBTYPE_HT_P150 = 53,
	SPMI_REGULATOR_SUBTYPE_HT_P600 = 61,
	SPMI_REGULATOR_SUBTYPE_HFSMPS_510 = 10,
	SPMI_REGULATOR_SUBTYPE_FTSMPS_510 = 11,
	SPMI_REGULATOR_SUBTYPE_LV_P150_510 = 113,
	SPMI_REGULATOR_SUBTYPE_LV_P300_510 = 114,
	SPMI_REGULATOR_SUBTYPE_LV_P600_510 = 115,
	SPMI_REGULATOR_SUBTYPE_N300_510 = 106,
	SPMI_REGULATOR_SUBTYPE_N600_510 = 107,
	SPMI_REGULATOR_SUBTYPE_N1200_510 = 108,
	SPMI_REGULATOR_SUBTYPE_MV_P50_510 = 122,
	SPMI_REGULATOR_SUBTYPE_MV_P150_510 = 123,
	SPMI_REGULATOR_SUBTYPE_MV_P600_510 = 125,
};

enum spmi_regulator_type {
	SPMI_REGULATOR_TYPE_BUCK = 3,
	SPMI_REGULATOR_TYPE_LDO = 4,
	SPMI_REGULATOR_TYPE_VS = 5,
	SPMI_REGULATOR_TYPE_BOOST = 27,
	SPMI_REGULATOR_TYPE_FTS = 28,
	SPMI_REGULATOR_TYPE_BOOST_BYP = 31,
	SPMI_REGULATOR_TYPE_ULT_LDO = 33,
	SPMI_REGULATOR_TYPE_ULT_BUCK = 34,
};

enum spmi_saw3_registers {
	SAW3_SECURE = 0,
	SAW3_ID = 4,
	SAW3_SPM_STS = 12,
	SAW3_AVS_STS = 16,
	SAW3_PMIC_STS = 20,
	SAW3_RST = 24,
	SAW3_VCTL = 28,
	SAW3_AVS_CTL = 32,
	SAW3_AVS_LIMIT = 36,
	SAW3_AVS_DLY = 40,
	SAW3_AVS_HYSTERESIS = 44,
	SAW3_SPM_STS2 = 56,
	SAW3_SPM_PMIC_DATA_3 = 76,
	SAW3_VERSION = 4048,
};

enum spmi_vs_registers {
	SPMI_VS_REG_OCP = 74,
	SPMI_VS_REG_SOFT_START = 76,
};

enum spmi_vs_soft_start_str {
	SPMI_VS_SOFT_START_STR_0P05_UA = 0,
	SPMI_VS_SOFT_START_STR_0P25_UA = 1,
	SPMI_VS_SOFT_START_STR_0P55_UA = 2,
	SPMI_VS_SOFT_START_STR_0P75_UA = 3,
	SPMI_VS_SOFT_START_STR_HW_DEFAULT = 4,
};

enum squashfs_param {
	Opt_errors___3 = 0,
	Opt_threads = 1,
};

enum sr_retry_flags {
	IO_SR_MSG_RETRY = 1,
	IO_SR_MSG_PARTIAL_MAP = 2,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_FASTPATH = 0,
	ALLOC_SLOWPATH = 1,
	FREE_FASTPATH = 2,
	FREE_SLOWPATH = 3,
	FREE_FROZEN = 4,
	FREE_ADD_PARTIAL = 5,
	FREE_REMOVE_PARTIAL = 6,
	ALLOC_FROM_PARTIAL = 7,
	ALLOC_SLAB = 8,
	ALLOC_REFILL = 9,
	ALLOC_NODE_MISMATCH = 10,
	FREE_SLAB = 11,
	CPUSLAB_FLUSH = 12,
	DEACTIVATE_FULL = 13,
	DEACTIVATE_EMPTY = 14,
	DEACTIVATE_TO_HEAD = 15,
	DEACTIVATE_TO_TAIL = 16,
	DEACTIVATE_REMOTE_FREES = 17,
	DEACTIVATE_BYPASS = 18,
	ORDER_FALLBACK = 19,
	CMPXCHG_DOUBLE_CPU_FAIL = 20,
	CMPXCHG_DOUBLE_FAIL = 21,
	CPU_PARTIAL_ALLOC = 22,
	CPU_PARTIAL_FREE = 23,
	CPU_PARTIAL_NODE = 24,
	CPU_PARTIAL_DRAIN = 25,
	NR_SLUB_STAT_ITEMS = 26,
};

enum state {
	Start = 0,
	Collect = 1,
	GotHeader = 2,
	SkipIt = 3,
	GotName = 4,
	CopyFile = 5,
	GotSymlink = 6,
	Reset = 7,
};

enum state_protect_how4 {
	SP4_NONE = 0,
	SP4_MACH_CRED = 1,
	SP4_SSV = 2,
};

enum status_css {
	CSS_TCPUDPCSOK = 128,
	CSS_ISUDP = 64,
	CSS_ISTCP = 32,
	CSS_ISIPFRAG = 16,
	CSS_ISIPV6 = 8,
	CSS_IPV4CSUMOK = 4,
	CSS_ISIPV4 = 2,
	CSS_LINK_BIT = 1,
};

enum store_type {
	wr_invalid = 0,
	wr_new_root = 1,
	wr_store_root = 2,
	wr_exact_fit = 3,
	wr_spanning_store = 4,
	wr_split_store = 5,
	wr_rebalance = 6,
	wr_append = 7,
	wr_node_store = 8,
	wr_slot_store = 9,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum stripetype4 {
	STRIPE_SPARSE = 1,
	STRIPE_DENSE = 2,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum super_iter_flags_t {
	SUPER_ITER_EXCL = 1,
	SUPER_ITER_UNLOCKED = 2,
	SUPER_ITER_REVERSE = 4,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_SYSERR = 2,
	SVC_VALID = 3,
	SVC_NEGATIVE = 4,
	SVC_OK = 5,
	SVC_DROP = 6,
	SVC_CLOSE = 7,
	SVC_DENIED = 8,
	SVC_PENDING = 9,
	SVC_COMPLETE = 10,
};

enum sw_activity {
	OFF = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum swap_cluster_flags {
	CLUSTER_FLAG_NONE = 0,
	CLUSTER_FLAG_FREE = 1,
	CLUSTER_FLAG_NONFULL = 2,
	CLUSTER_FLAG_FRAG = 3,
	CLUSTER_FLAG_USABLE = 3,
	CLUSTER_FLAG_FULL = 4,
	CLUSTER_FLAG_DISCARD = 5,
	CLUSTER_FLAG_MAX = 6,
};

enum switchdev_attr_id {
	SWITCHDEV_ATTR_ID_UNDEFINED = 0,
	SWITCHDEV_ATTR_ID_PORT_STP_STATE = 1,
	SWITCHDEV_ATTR_ID_PORT_MST_STATE = 2,
	SWITCHDEV_ATTR_ID_PORT_BRIDGE_FLAGS = 3,
	SWITCHDEV_ATTR_ID_PORT_PRE_BRIDGE_FLAGS = 4,
	SWITCHDEV_ATTR_ID_PORT_MROUTER = 5,
	SWITCHDEV_ATTR_ID_BRIDGE_AGEING_TIME = 6,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_FILTERING = 7,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_PROTOCOL = 8,
	SWITCHDEV_ATTR_ID_BRIDGE_MC_DISABLED = 9,
	SWITCHDEV_ATTR_ID_BRIDGE_MROUTER = 10,
	SWITCHDEV_ATTR_ID_BRIDGE_MST = 11,
	SWITCHDEV_ATTR_ID_MRP_PORT_ROLE = 12,
	SWITCHDEV_ATTR_ID_VLAN_MSTI = 13,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum switchdev_obj_id {
	SWITCHDEV_OBJ_ID_UNDEFINED = 0,
	SWITCHDEV_OBJ_ID_PORT_VLAN = 1,
	SWITCHDEV_OBJ_ID_PORT_MDB = 2,
	SWITCHDEV_OBJ_ID_HOST_MDB = 3,
	SWITCHDEV_OBJ_ID_MRP = 4,
	SWITCHDEV_OBJ_ID_RING_TEST_MRP = 5,
	SWITCHDEV_OBJ_ID_RING_ROLE_MRP = 6,
	SWITCHDEV_OBJ_ID_RING_STATE_MRP = 7,
	SWITCHDEV_OBJ_ID_IN_TEST_MRP = 8,
	SWITCHDEV_OBJ_ID_IN_ROLE_MRP = 9,
	SWITCHDEV_OBJ_ID_IN_STATE_MRP = 10,
};

enum swxilim_bits {
	SWXILIM_2100_MA = 0,
	SWXILIM_2600_MA = 1,
	SWXILIM_3000_MA = 2,
	SWXILIM_4500_MA = 3,
};

enum synaptics_pkt_type {
	SYN_NEWABS = 0,
	SYN_NEWABS_STRICT = 1,
	SYN_NEWABS_RELAXED = 2,
	SYN_OLDABS = 3,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum tap_delay_type {
	PM_TAPDELAY_INPUT = 0,
	PM_TAPDELAY_OUTPUT = 1,
};

enum task_attribute {
	TASK_ATTR_SIMPLE = 0,
	TASK_ATTR_HOQ = 1,
	TASK_ATTR_ORDERED = 2,
	TASK_ATTR_ACA = 4,
};

enum task_disposition {
	TASK_IS_DONE = 0,
	TASK_IS_ABORTED = 1,
	TASK_IS_AT_LU = 2,
	TASK_IS_NOT_AT_LU = 3,
	TASK_ABORT_FAILED = 4,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
	TWA_NMI_CURRENT = 4,
};

enum tc_fifo_command {
	TC_FIFO_REPLACE = 0,
	TC_FIFO_DESTROY = 1,
	TC_FIFO_STATS = 2,
};

enum tc_link_layer {
	TC_LINKLAYER_UNAWARE = 0,
	TC_LINKLAYER_ETHERNET = 1,
	TC_LINKLAYER_ATM = 2,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_root_command {
	TC_ROOT_GRAFT = 0,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tca_id {
	TCA_ID_UNSPEC = 0,
	TCA_ID_POLICE = 1,
	TCA_ID_GACT = 5,
	TCA_ID_IPT = 6,
	TCA_ID_PEDIT = 7,
	TCA_ID_MIRRED = 8,
	TCA_ID_NAT = 9,
	TCA_ID_XT = 10,
	TCA_ID_SKBEDIT = 11,
	TCA_ID_VLAN = 12,
	TCA_ID_BPF = 13,
	TCA_ID_CONNMARK = 14,
	TCA_ID_SKBMOD = 15,
	TCA_ID_CSUM = 16,
	TCA_ID_TUNNEL_KEY = 17,
	TCA_ID_SIMP = 22,
	TCA_ID_IFE = 25,
	TCA_ID_SAMPLE = 26,
	TCA_ID_CTINFO = 27,
	TCA_ID_MPLS = 28,
	TCA_ID_CT = 29,
	TCA_ID_GATE = 30,
	__TCA_ID_MAX = 255,
};

enum tcf_proto_ops_flags {
	TCF_PROTO_OPS_DOIT_UNLOCKED = 1,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
	TCP_TW_ACK_OOW = 4,
};

enum tcpa_event_types {
	PREBOOT = 0,
	POST_CODE = 1,
	UNUSED = 2,
	NO_ACTION = 3,
	SEPARATOR = 4,
	ACTION = 5,
	EVENT_TAG = 6,
	SCRTM_CONTENTS = 7,
	SCRTM_VERSION = 8,
	CPU_MICROCODE = 9,
	PLATFORM_CONFIG_FLAGS = 10,
	TABLE_OF_DEVICES = 11,
	COMPACT_HASH = 12,
	IPL = 13,
	IPL_PARTITION_DATA = 14,
	NONHOST_CODE = 15,
	NONHOST_CONFIG = 16,
	NONHOST_INFO = 17,
};

enum tcpa_pc_event_ids {
	SMBIOS = 1,
	BIS_CERT = 2,
	POST_BIOS_ROM = 3,
	ESCD = 4,
	CMOS = 5,
	NVRAM = 6,
	OPTION_ROM_EXEC = 7,
	OPTION_ROM_CONFIG = 8,
	OPTION_ROM_MICROCODE = 10,
	S_CRTM_VERSION = 11,
	S_CRTM_CONTENTS = 12,
	POST_CONTENTS = 13,
	HOST_TABLE_OF_DEVICES = 14,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
	THERMAL_TZ_RESUME = 12,
	THERMAL_TZ_ADD_THRESHOLD = 13,
	THERMAL_TZ_DEL_THRESHOLD = 14,
	THERMAL_TZ_FLUSH_THRESHOLDS = 15,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timer_tread_format {
	TREAD_FORMAT_NONE = 0,
	TREAD_FORMAT_TIME64 = 1,
	TREAD_FORMAT_TIME32 = 2,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tis_access {
	TPM_ACCESS_VALID = 128,
	TPM_ACCESS_ACTIVE_LOCALITY = 32,
	TPM_ACCESS_REQUEST_PENDING = 4,
	TPM_ACCESS_REQUEST_USE = 2,
};

enum tis_defaults {
	TIS_SHORT_TIMEOUT = 750,
	TIS_LONG_TIMEOUT = 2000,
};

enum tis_status {
	TPM_STS_VALID = 128,
	TPM_STS_COMMAND_READY = 64,
	TPM_STS_GO = 32,
	TPM_STS_DATA_AVAIL = 16,
	TPM_STS_DATA_EXPECT = 8,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum tlb_flush_reason {
	TLB_FLUSH_ON_TASK_SWITCH = 0,
	TLB_REMOTE_SHOOTDOWN = 1,
	TLB_LOCAL_SHOOTDOWN = 2,
	TLB_LOCAL_MM_SHOOTDOWN = 3,
	TLB_REMOTE_SEND_IPI = 4,
	TLB_REMOTE_WRONG_CPU = 5,
	NR_TLB_FLUSH_REASONS = 6,
};

enum tlb_write_entry {
	tlb_random = 0,
	tlb_indexed = 1,
};

enum tp_func_state {
	TP_FUNC_0 = 0,
	TP_FUNC_1 = 1,
	TP_FUNC_2 = 2,
	TP_FUNC_N = 3,
};

enum tp_transition_sync {
	TP_TRANSITION_SYNC_1_0_1 = 0,
	TP_TRANSITION_SYNC_N_2_1 = 1,
	_NR_TP_TRANSITION_SYNC = 2,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tpm2_capabilities {
	TPM2_CAP_HANDLES = 1,
	TPM2_CAP_COMMANDS = 2,
	TPM2_CAP_PCRS = 5,
	TPM2_CAP_TPM_PROPERTIES = 6,
};

enum tpm2_cc_attrs {
	TPM2_CC_ATTR_CHANDLES = 25,
	TPM2_CC_ATTR_RHANDLE = 28,
	TPM2_CC_ATTR_VENDOR = 29,
};

enum tpm2_command_codes {
	TPM2_CC_FIRST = 287,
	TPM2_CC_HIERARCHY_CONTROL = 289,
	TPM2_CC_HIERARCHY_CHANGE_AUTH = 297,
	TPM2_CC_CREATE_PRIMARY = 305,
	TPM2_CC_SEQUENCE_COMPLETE = 318,
	TPM2_CC_SELF_TEST = 323,
	TPM2_CC_STARTUP = 324,
	TPM2_CC_SHUTDOWN = 325,
	TPM2_CC_NV_READ = 334,
	TPM2_CC_CREATE = 339,
	TPM2_CC_LOAD = 343,
	TPM2_CC_SEQUENCE_UPDATE = 348,
	TPM2_CC_UNSEAL = 350,
	TPM2_CC_CONTEXT_LOAD = 353,
	TPM2_CC_CONTEXT_SAVE = 354,
	TPM2_CC_FLUSH_CONTEXT = 357,
	TPM2_CC_READ_PUBLIC = 371,
	TPM2_CC_START_AUTH_SESS = 374,
	TPM2_CC_VERIFY_SIGNATURE = 375,
	TPM2_CC_GET_CAPABILITY = 378,
	TPM2_CC_GET_RANDOM = 379,
	TPM2_CC_PCR_READ = 382,
	TPM2_CC_PCR_EXTEND = 386,
	TPM2_CC_EVENT_SEQUENCE_COMPLETE = 389,
	TPM2_CC_HASH_SEQUENCE_START = 390,
	TPM2_CC_CREATE_LOADED = 401,
	TPM2_CC_LAST = 403,
};

enum tpm2_const {
	TPM2_PLATFORM_PCR = 24,
	TPM2_PCR_SELECT_MIN = 3,
};

enum tpm2_handle_types {
	TPM2_HT_HMAC_SESSION = 33554432,
	TPM2_HT_POLICY_SESSION = 50331648,
	TPM2_HT_TRANSIENT = 2147483648,
};

enum tpm2_permanent_handles {
	TPM2_RH_NULL = 1073741831,
	TPM2_RS_PW = 1073741833,
};

enum tpm2_properties {
	TPM_PT_TOTAL_COMMANDS = 297,
};

enum tpm2_return_codes {
	TPM2_RC_SUCCESS = 0,
	TPM2_RC_HASH = 131,
	TPM2_RC_HANDLE = 139,
	TPM2_RC_INTEGRITY = 159,
	TPM2_RC_INITIALIZE = 256,
	TPM2_RC_FAILURE = 257,
	TPM2_RC_DISABLED = 288,
	TPM2_RC_UPGRADE = 301,
	TPM2_RC_COMMAND_CODE = 323,
	TPM2_RC_TESTING = 2314,
	TPM2_RC_REFERENCE_H0 = 2320,
	TPM2_RC_RETRY = 2338,
	TPM2_RC_SESSION_MEMORY = 2307,
};

enum tpm2_session_attributes {
	TPM2_SA_CONTINUE_SESSION = 1,
	TPM2_SA_AUDIT_EXCLUSIVE = 2,
	TPM2_SA_AUDIT_RESET = 8,
	TPM2_SA_DECRYPT = 32,
	TPM2_SA_ENCRYPT = 64,
	TPM2_SA_AUDIT = 128,
};

enum tpm2_startup_types {
	TPM2_SU_CLEAR = 0,
	TPM2_SU_STATE = 1,
};

enum tpm2_structures {
	TPM2_ST_NO_SESSIONS = 32769,
	TPM2_ST_SESSIONS = 32770,
	TPM2_ST_CREATION = 32801,
};

enum tpm2_timeouts {
	TPM2_TIMEOUT_A = 750,
	TPM2_TIMEOUT_B = 4000,
	TPM2_TIMEOUT_C = 200,
	TPM2_TIMEOUT_D = 30,
	TPM2_DURATION_SHORT = 20,
	TPM2_DURATION_MEDIUM = 750,
	TPM2_DURATION_LONG = 2000,
	TPM2_DURATION_LONG_LONG = 300000,
	TPM2_DURATION_DEFAULT = 120000,
};

enum tpm_algorithms {
	TPM_ALG_ERROR = 0,
	TPM_ALG_SHA1 = 4,
	TPM_ALG_AES = 6,
	TPM_ALG_KEYEDHASH = 8,
	TPM_ALG_SHA256 = 11,
	TPM_ALG_SHA384 = 12,
	TPM_ALG_SHA512 = 13,
	TPM_ALG_NULL = 16,
	TPM_ALG_SM3_256 = 18,
	TPM_ALG_ECC = 35,
	TPM_ALG_CFB = 67,
};

enum tpm_buf_flags {
	TPM_BUF_OVERFLOW = 1,
	TPM_BUF_TPM2B = 2,
	TPM_BUF_BOUNDARY_ERROR = 4,
};

enum tpm_capabilities {
	TPM_CAP_FLAG = 4,
	TPM_CAP_PROP = 5,
	TPM_CAP_VERSION_1_1 = 6,
	TPM_CAP_VERSION_1_2 = 26,
};

enum tpm_chip_flags {
	TPM_CHIP_FLAG_BOOTSTRAPPED = 1,
	TPM_CHIP_FLAG_TPM2 = 2,
	TPM_CHIP_FLAG_IRQ = 4,
	TPM_CHIP_FLAG_VIRTUAL = 8,
	TPM_CHIP_FLAG_HAVE_TIMEOUTS = 16,
	TPM_CHIP_FLAG_ALWAYS_POWERED = 32,
	TPM_CHIP_FLAG_FIRMWARE_POWER_MANAGED = 64,
	TPM_CHIP_FLAG_FIRMWARE_UPGRADE = 128,
	TPM_CHIP_FLAG_SUSPENDED = 256,
	TPM_CHIP_FLAG_HWRNG_DISABLED = 512,
	TPM_CHIP_FLAG_DISABLE = 1024,
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum tpm_sub_capabilities {
	TPM_CAP_PROP_PCR = 257,
	TPM_CAP_PROP_MANUFACTURER = 259,
	TPM_CAP_FLAG_PERM = 264,
	TPM_CAP_FLAG_VOL = 265,
	TPM_CAP_PROP_OWNER = 273,
	TPM_CAP_PROP_TIS_TIMEOUT = 277,
	TPM_CAP_PROP_TIS_DURATION = 288,
};

enum tpm_timeout {
	TPM_TIMEOUT = 5,
	TPM_TIMEOUT_RETRY = 100,
	TPM_TIMEOUT_RANGE_US = 300,
	TPM_TIMEOUT_POLL = 1,
	TPM_TIMEOUT_USECS_MIN = 100,
	TPM_TIMEOUT_USECS_MAX = 500,
};

enum tps65214_regulator_id {
	TPS65214_LDO_1 = 3,
	TPS65214_LDO_2 = 4,
};

enum tps65215_regulator_id {
	TPS65215_LDO_2 = 4,
};

enum tps65219_regulator_id {
	TPS65219_BUCK_1 = 0,
	TPS65219_BUCK_2 = 1,
	TPS65219_BUCK_3 = 2,
	TPS65219_LDO_1 = 3,
	TPS65219_LDO_2 = 4,
	TPS65219_LDO_3 = 5,
	TPS65219_LDO_4 = 6,
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_NEED_RESCHED_LAZY = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

enum trace_iter_flags {
	TRACE_FILE_LAT_FMT = 1,
	TRACE_FILE_ANNOTATE = 2,
	TRACE_FILE_TIME_IN_NS = 4,
};

enum trace_iterator_bits {
	TRACE_ITER_PRINT_PARENT_BIT = 0,
	TRACE_ITER_SYM_OFFSET_BIT = 1,
	TRACE_ITER_SYM_ADDR_BIT = 2,
	TRACE_ITER_VERBOSE_BIT = 3,
	TRACE_ITER_RAW_BIT = 4,
	TRACE_ITER_HEX_BIT = 5,
	TRACE_ITER_BIN_BIT = 6,
	TRACE_ITER_BLOCK_BIT = 7,
	TRACE_ITER_FIELDS_BIT = 8,
	TRACE_ITER_PRINTK_BIT = 9,
	TRACE_ITER_ANNOTATE_BIT = 10,
	TRACE_ITER_USERSTACKTRACE_BIT = 11,
	TRACE_ITER_SYM_USEROBJ_BIT = 12,
	TRACE_ITER_PRINTK_MSGONLY_BIT = 13,
	TRACE_ITER_CONTEXT_INFO_BIT = 14,
	TRACE_ITER_LATENCY_FMT_BIT = 15,
	TRACE_ITER_RECORD_CMD_BIT = 16,
	TRACE_ITER_RECORD_TGID_BIT = 17,
	TRACE_ITER_OVERWRITE_BIT = 18,
	TRACE_ITER_STOP_ON_FREE_BIT = 19,
	TRACE_ITER_IRQ_INFO_BIT = 20,
	TRACE_ITER_MARKERS_BIT = 21,
	TRACE_ITER_EVENT_FORK_BIT = 22,
	TRACE_ITER_TRACE_PRINTK_BIT = 23,
	TRACE_ITER_COPY_MARKER_BIT = 24,
	TRACE_ITER_PAUSE_ON_TRACE_BIT = 25,
	TRACE_ITER_HASH_PTR_BIT = 26,
	TRACE_ITER_STACKTRACE_BIT = 27,
	TRACE_ITER_LAST_BIT = 28,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_TRACE_PRINTK = 8388608,
	TRACE_ITER_COPY_MARKER = 16777216,
	TRACE_ITER_PAUSE_ON_TRACE = 33554432,
	TRACE_ITER_HASH_PTR = 67108864,
	TRACE_ITER_STACKTRACE = 134217728,
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_GRAPH_RETADDR_ENT = 12,
	TRACE_USER_STACK = 13,
	TRACE_BLK = 14,
	TRACE_BPUTS = 15,
	TRACE_HWLAT = 16,
	TRACE_OSNOISE = 17,
	TRACE_TIMERLAT = 18,
	TRACE_RAW_DATA = 19,
	TRACE_FUNC_REPEATS = 20,
	__TRACE_LAST_TYPE = 21,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum tre_type {
	HIDMA_TRE_MEMCPY = 3,
	HIDMA_TRE_MEMSET = 4,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_driver_flag {
	TTY_DRIVER_INSTALLED = 1,
	TTY_DRIVER_RESET_TERMIOS = 2,
	TTY_DRIVER_REAL_RAW = 4,
	TTY_DRIVER_DYNAMIC_DEV = 8,
	TTY_DRIVER_DEVPTS_MEM = 16,
	TTY_DRIVER_HARDWARE_BREAK = 32,
	TTY_DRIVER_DYNAMIC_ALLOC = 64,
	TTY_DRIVER_UNNUMBERED_NODE = 128,
};

enum tty_driver_subtype {
	SYSTEM_TYPE_TTY = 1,
	SYSTEM_TYPE_CONSOLE = 2,
	SYSTEM_TYPE_SYSCONS = 3,
	SYSTEM_TYPE_SYSPTMX = 4,
	PTY_TYPE_MASTER = 1,
	PTY_TYPE_SLAVE = 2,
	SERIAL_TYPE_NORMAL = 1,
};

enum tty_driver_type {
	TTY_DRIVER_TYPE_SYSTEM = 0,
	TTY_DRIVER_TYPE_CONSOLE = 1,
	TTY_DRIVER_TYPE_SERIAL = 2,
	TTY_DRIVER_TYPE_PTY = 3,
	TTY_DRIVER_TYPE_SCC = 4,
	TTY_DRIVER_TYPE_SYSCONS = 5,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tty_struct_flags {
	TTY_THROTTLED = 0,
	TTY_IO_ERROR = 1,
	TTY_OTHER_CLOSED = 2,
	TTY_EXCLUSIVE = 3,
	TTY_DO_WRITE_WAKEUP = 4,
	TTY_LDISC_OPEN = 5,
	TTY_PTY_LOCK = 6,
	TTY_NO_WRITE_SPLIT = 7,
	TTY_HUPPED = 8,
	TTY_HUPPING = 9,
	TTY_LDISC_CHANGING = 10,
	TTY_LDISC_HALTED = 11,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum tx_queue_prio {
	TX_QUEUE_PRIO_HIGH = 0,
	TX_QUEUE_PRIO_LOW = 1,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum uart_iotype {
	UPIO_UNKNOWN = -1,
	UPIO_PORT = 0,
	UPIO_HUB6 = 1,
	UPIO_MEM = 2,
	UPIO_MEM32 = 3,
	UPIO_AU = 4,
	UPIO_TSI = 5,
	UPIO_MEM32BE = 6,
	UPIO_MEM16 = 7,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_FANOTIFY_GROUPS = 10,
	UCOUNT_FANOTIFY_MARKS = 11,
	UCOUNT_COUNTS = 12,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum udp_parsable_tunnel_type {
	UDP_TUNNEL_TYPE_VXLAN = 1,
	UDP_TUNNEL_TYPE_GENEVE = 2,
	UDP_TUNNEL_TYPE_VXLAN_GPE = 4,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_MAY_SLEEP = 1,
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 4,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 8,
};

enum ufs_bsg_msg_code {
	UPIU_TRANSACTION_UIC_CMD = 31,
	UPIU_TRANSACTION_ARPMB_CMD = 32,
};

enum ufs_dev_pwr_mode {
	UFS_ACTIVE_PWR_MODE = 1,
	UFS_SLEEP_PWR_MODE = 2,
	UFS_POWERDOWN_PWR_MODE = 3,
	UFS_DEEPSLEEP_PWR_MODE = 4,
};

enum ufs_event_type {
	UFS_EVT_PA_ERR = 0,
	UFS_EVT_DL_ERR = 1,
	UFS_EVT_NL_ERR = 2,
	UFS_EVT_TL_ERR = 3,
	UFS_EVT_DME_ERR = 4,
	UFS_EVT_AUTO_HIBERN8_ERR = 5,
	UFS_EVT_FATAL_ERR = 6,
	UFS_EVT_LINK_STARTUP_FAIL = 7,
	UFS_EVT_RESUME_ERR = 8,
	UFS_EVT_SUSPEND_ERR = 9,
	UFS_EVT_WL_SUSP_ERR = 10,
	UFS_EVT_WL_RES_ERR = 11,
	UFS_EVT_DEV_RESET = 12,
	UFS_EVT_HOST_RESET = 13,
	UFS_EVT_ABORT = 14,
	UFS_EVT_CNT = 15,
};

enum ufs_hs_gear_rate {
	PA_HS_MODE_A = 1,
	PA_HS_MODE_B = 2,
};

enum ufs_hs_gear_tag {
	UFS_HS_DONT_CHANGE = 0,
	UFS_HS_G1 = 1,
	UFS_HS_G2 = 2,
	UFS_HS_G3 = 3,
	UFS_HS_G4 = 4,
	UFS_HS_G5 = 5,
};

enum ufs_lanes {
	UFS_LANE_DONT_CHANGE = 0,
	UFS_LANE_1 = 1,
	UFS_LANE_2 = 2,
};

enum ufs_lu_wp_type {
	UFS_LU_NO_WP = 0,
	UFS_LU_POWER_ON_WP = 1,
	UFS_LU_PERM_WP = 2,
};

enum ufs_notify_change_status {
	PRE_CHANGE = 0,
	POST_CHANGE = 1,
};

enum ufs_pa_pwr_mode {
	FAST_MODE = 1,
	SLOW_MODE = 2,
	FASTAUTO_MODE = 4,
	SLOWAUTO_MODE = 5,
	UNCHANGED = 7,
};

enum ufs_pm_level {
	UFS_PM_LVL_0 = 0,
	UFS_PM_LVL_1 = 1,
	UFS_PM_LVL_2 = 2,
	UFS_PM_LVL_3 = 3,
	UFS_PM_LVL_4 = 4,
	UFS_PM_LVL_5 = 5,
	UFS_PM_LVL_6 = 6,
	UFS_PM_LVL_MAX = 7,
};

enum ufs_pm_op {
	UFS_RUNTIME_PM = 0,
	UFS_SYSTEM_PM = 1,
	UFS_SHUTDOWN_PM = 2,
};

enum ufs_pwm_gear_tag {
	UFS_PWM_DONT_CHANGE = 0,
	UFS_PWM_G1 = 1,
	UFS_PWM_G2 = 2,
	UFS_PWM_G3 = 3,
	UFS_PWM_G4 = 4,
	UFS_PWM_G5 = 5,
	UFS_PWM_G6 = 6,
	UFS_PWM_G7 = 7,
};

enum ufs_ref_clk_freq {
	REF_CLK_FREQ_19_2_MHZ = 0,
	REF_CLK_FREQ_26_MHZ = 1,
	REF_CLK_FREQ_38_4_MHZ = 2,
	REF_CLK_FREQ_52_MHZ = 3,
	REF_CLK_FREQ_INVAL = -1,
};

enum ufs_rpmb_op_type {
	UFS_RPMB_WRITE_KEY = 1,
	UFS_RPMB_READ_CNT = 2,
	UFS_RPMB_WRITE = 3,
	UFS_RPMB_READ = 4,
	UFS_RPMB_READ_RESP = 5,
	UFS_RPMB_SEC_CONF_WRITE = 6,
	UFS_RPMB_SEC_CONF_READ = 7,
	UFS_RPMB_PURGE_ENABLE = 8,
	UFS_RPMB_PURGE_STATUS_READ = 9,
};

enum ufs_rtc_time {
	UFS_RTC_RELATIVE = 0,
	UFS_RTC_ABSOLUTE = 1,
};

enum ufs_trace_str_t {
	UFS_CMD_SEND = 0,
	UFS_CMD_COMP = 1,
	UFS_DEV_COMP = 2,
	UFS_QUERY_SEND = 3,
	UFS_QUERY_COMP = 4,
	UFS_QUERY_ERR = 5,
	UFS_TM_SEND = 6,
	UFS_TM_COMP = 7,
	UFS_TM_ERR = 8,
};

enum ufs_trace_tsf_t {
	UFS_TSF_CDB = 0,
	UFS_TSF_OSF = 1,
	UFS_TSF_TM_INPUT = 2,
	UFS_TSF_TM_OUTPUT = 3,
};

enum ufshcd_caps {
	UFSHCD_CAP_CLK_GATING = 1,
	UFSHCD_CAP_HIBERN8_WITH_CLK_GATING = 2,
	UFSHCD_CAP_CLK_SCALING = 4,
	UFSHCD_CAP_AUTO_BKOPS_SUSPEND = 8,
	UFSHCD_CAP_INTR_AGGR = 16,
	UFSHCD_CAP_KEEP_AUTO_BKOPS_ENABLED_EXCEPT_SUSPEND = 32,
	UFSHCD_CAP_RPM_AUTOSUSPEND = 64,
	UFSHCD_CAP_WB_EN = 128,
	UFSHCD_CAP_CRYPTO = 256,
	UFSHCD_CAP_AGGR_POWER_COLLAPSE = 512,
	UFSHCD_CAP_DEEPSLEEP = 1024,
	UFSHCD_CAP_TEMP_NOTIF = 2048,
	UFSHCD_CAP_WB_WITH_CLK_SCALING = 4096,
};

enum ufshcd_mcq_opr {
	OPR_SQD = 0,
	OPR_SQIS = 1,
	OPR_CQD = 2,
	OPR_CQIS = 3,
	OPR_MAX = 4,
};

enum ufshcd_quirks {
	UFSHCD_QUIRK_BROKEN_INTR_AGGR = 1,
	UFSHCD_QUIRK_DELAY_BEFORE_DME_CMDS = 2,
	UFSHCD_QUIRK_BROKEN_LCC = 4,
	UFSHCD_QUIRK_BROKEN_PA_RXHSUNTERMCAP = 8,
	UFSHCD_QUIRK_DME_PEER_ACCESS_AUTO_MODE = 16,
	UFSHCD_QUIRK_BROKEN_UFS_HCI_VERSION = 32,
	UFSHCI_QUIRK_BROKEN_REQ_LIST_CLR = 64,
	UFSHCI_QUIRK_SKIP_RESET_INTR_AGGR = 128,
	UFSHCI_QUIRK_BROKEN_HCE = 256,
	UFSHCD_QUIRK_PRDT_BYTE_GRAN = 512,
	UFSHCD_QUIRK_BROKEN_OCS_FATAL_ERROR = 1024,
	UFSHCD_QUIRK_BROKEN_AUTO_HIBERN8 = 2048,
	UFSHCI_QUIRK_SKIP_MANUAL_WB_FLUSH_CTRL = 4096,
	UFSHCD_QUIRK_SKIP_DEF_UNIPRO_TIMEOUT_SETTING = 8192,
	UFSHCD_QUIRK_BROKEN_UIC_CMD = 32768,
	UFSHCD_QUIRK_SKIP_PH_CONFIGURATION = 65536,
	UFSHCD_QUIRK_HIBERN_FASTAUTO = 262144,
	UFSHCD_QUIRK_REINIT_AFTER_MAX_GEAR_SWITCH = 524288,
	UFSHCD_QUIRK_MCQ_BROKEN_INTR = 1048576,
	UFSHCD_QUIRK_MCQ_BROKEN_RTC = 2097152,
	UFSHCD_QUIRK_CUSTOM_CRYPTO_PROFILE = 4194304,
	UFSHCD_QUIRK_BROKEN_CRYPTO_ENABLE = 8388608,
	UFSHCD_QUIRK_KEYS_IN_PRDT = 16777216,
	UFSHCD_QUIRK_BROKEN_LSDBS_CAP = 33554432,
};

enum ufshcd_res {
	RES_UFS = 0,
	RES_MCQ = 1,
	RES_MCQ_SQD = 2,
	RES_MCQ_SQIS = 3,
	RES_MCQ_CQD = 4,
	RES_MCQ_CQIS = 5,
	RES_MCQ_VS = 6,
	RES_MAX = 7,
};

enum ufshcd_state {
	UFSHCD_STATE_RESET = 0,
	UFSHCD_STATE_OPERATIONAL = 1,
	UFSHCD_STATE_EH_SCHEDULED_NON_FATAL = 2,
	UFSHCD_STATE_EH_SCHEDULED_FATAL = 3,
	UFSHCD_STATE_ERROR = 4,
};

enum uic_cmd_dme {
	UIC_CMD_DME_GET = 1,
	UIC_CMD_DME_SET = 2,
	UIC_CMD_DME_PEER_GET = 3,
	UIC_CMD_DME_PEER_SET = 4,
	UIC_CMD_DME_POWERON = 16,
	UIC_CMD_DME_POWEROFF = 17,
	UIC_CMD_DME_ENABLE = 18,
	UIC_CMD_DME_RESET = 20,
	UIC_CMD_DME_END_PT_RST = 21,
	UIC_CMD_DME_LINK_STARTUP = 22,
	UIC_CMD_DME_HIBER_ENTER = 23,
	UIC_CMD_DME_HIBER_EXIT = 24,
	UIC_CMD_DME_TEST_MODE = 26,
};

enum uic_link_state {
	UIC_LINK_OFF_STATE = 0,
	UIC_LINK_ACTIVE_STATE = 1,
	UIC_LINK_HIBERN8_STATE = 2,
	UIC_LINK_BROKEN_STATE = 3,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum unit_desc_param {
	UNIT_DESC_PARAM_LEN = 0,
	UNIT_DESC_PARAM_TYPE = 1,
	UNIT_DESC_PARAM_UNIT_INDEX = 2,
	UNIT_DESC_PARAM_LU_ENABLE = 3,
	UNIT_DESC_PARAM_BOOT_LUN_ID = 4,
	UNIT_DESC_PARAM_LU_WR_PROTECT = 5,
	UNIT_DESC_PARAM_LU_Q_DEPTH = 6,
	UNIT_DESC_PARAM_PSA_SENSITIVE = 7,
	UNIT_DESC_PARAM_MEM_TYPE = 8,
	UNIT_DESC_PARAM_DATA_RELIABILITY = 9,
	UNIT_DESC_PARAM_LOGICAL_BLK_SIZE = 10,
	UNIT_DESC_PARAM_LOGICAL_BLK_COUNT = 11,
	UNIT_DESC_PARAM_ERASE_BLK_SIZE = 19,
	UNIT_DESC_PARAM_PROVISIONING_TYPE = 23,
	UNIT_DESC_PARAM_PHY_MEM_RSRC_CNT = 24,
	UNIT_DESC_PARAM_CTX_CAPABILITIES = 32,
	UNIT_DESC_PARAM_LARGE_UNIT_SIZE_M1 = 34,
	UNIT_DESC_PARAM_HPB_LU_MAX_ACTIVE_RGNS = 35,
	UNIT_DESC_PARAM_HPB_PIN_RGN_START_OFF = 37,
	UNIT_DESC_PARAM_HPB_NUM_PIN_RGNS = 39,
	UNIT_DESC_PARAM_WB_BUF_ALLOC_UNITS = 41,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum upiu_request_transaction {
	UPIU_TRANSACTION_NOP_OUT = 0,
	UPIU_TRANSACTION_COMMAND = 1,
	UPIU_TRANSACTION_DATA_OUT = 2,
	UPIU_TRANSACTION_TASK_REQ = 4,
	UPIU_TRANSACTION_QUERY_REQ = 22,
};

enum upiu_response_transaction {
	UPIU_TRANSACTION_NOP_IN = 32,
	UPIU_TRANSACTION_RESPONSE = 33,
	UPIU_TRANSACTION_DATA_IN = 34,
	UPIU_TRANSACTION_TASK_RSP = 36,
	UPIU_TRANSACTION_READY_XFER = 49,
	UPIU_TRANSACTION_QUERY_RSP = 54,
	UPIU_TRANSACTION_REJECT_UPIU = 63,
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

enum usb3503_mode {
	USB3503_MODE_UNKNOWN = 0,
	USB3503_MODE_HUB = 1,
	USB3503_MODE_STANDBY = 2,
	USB3503_MODE_BYPASS = 3,
};

enum usb3_link_state {
	USB3_LPM_U0 = 0,
	USB3_LPM_U1 = 1,
	USB3_LPM_U2 = 2,
	USB3_LPM_U3 = 3,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_dev_authorize_policy {
	USB_DEVICE_AUTHORIZE_NONE = 0,
	USB_DEVICE_AUTHORIZE_ALL = 1,
	USB_DEVICE_AUTHORIZE_INTERNAL = 2,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_device_state {
	USB_STATE_NOTATTACHED = 0,
	USB_STATE_ATTACHED = 1,
	USB_STATE_POWERED = 2,
	USB_STATE_RECONNECTING = 3,
	USB_STATE_UNAUTHENTICATED = 4,
	USB_STATE_DEFAULT = 5,
	USB_STATE_ADDRESS = 6,
	USB_STATE_CONFIGURED = 7,
	USB_STATE_SUSPENDED = 8,
};

enum usb_dr_mode {
	USB_DR_MODE_UNKNOWN = 0,
	USB_DR_MODE_HOST = 1,
	USB_DR_MODE_PERIPHERAL = 2,
	USB_DR_MODE_OTG = 3,
};

enum usb_interface_condition {
	USB_INTERFACE_UNBOUND = 0,
	USB_INTERFACE_BINDING = 1,
	USB_INTERFACE_BOUND = 2,
	USB_INTERFACE_UNBINDING = 3,
};

enum usb_led_event {
	USB_LED_EVENT_HOST = 0,
	USB_LED_EVENT_GADGET = 1,
};

enum usb_link_tunnel_mode {
	USB_LINK_UNKNOWN = 0,
	USB_LINK_NATIVE = 1,
	USB_LINK_TUNNELED = 2,
};

enum usb_otg_state {
	OTG_STATE_UNDEFINED = 0,
	OTG_STATE_B_IDLE = 1,
	OTG_STATE_B_SRP_INIT = 2,
	OTG_STATE_B_PERIPHERAL = 3,
	OTG_STATE_B_WAIT_ACON = 4,
	OTG_STATE_B_HOST = 5,
	OTG_STATE_A_IDLE = 6,
	OTG_STATE_A_WAIT_VRISE = 7,
	OTG_STATE_A_WAIT_BCON = 8,
	OTG_STATE_A_HOST = 9,
	OTG_STATE_A_SUSPEND = 10,
	OTG_STATE_A_PERIPHERAL = 11,
	OTG_STATE_A_WAIT_VFALL = 12,
	OTG_STATE_A_VBUS_ERR = 13,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_interface {
	USBPHY_INTERFACE_MODE_UNKNOWN = 0,
	USBPHY_INTERFACE_MODE_UTMI = 1,
	USBPHY_INTERFACE_MODE_UTMIW = 2,
	USBPHY_INTERFACE_MODE_ULPI = 3,
	USBPHY_INTERFACE_MODE_SERIAL = 4,
	USBPHY_INTERFACE_MODE_HSIC = 5,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum usb_port_connect_type {
	USB_PORT_CONNECT_TYPE_UNKNOWN = 0,
	USB_PORT_CONNECT_TYPE_HOT_PLUG = 1,
	USB_PORT_CONNECT_TYPE_HARD_WIRED = 2,
	USB_PORT_NOT_USED = 3,
};

enum usb_role {
	USB_ROLE_NONE = 0,
	USB_ROLE_HOST = 1,
	USB_ROLE_DEVICE = 2,
};

enum usb_ssp_rate {
	USB_SSP_GEN_UNKNOWN = 0,
	USB_SSP_GEN_2x1 = 1,
	USB_SSP_GEN_1x2 = 2,
	USB_SSP_GEN_2x2 = 3,
};

enum usb_wireless_status {
	USB_WIRELESS_STATUS_NA = 0,
	USB_WIRELESS_STATUS_DISCONNECTED = 1,
	USB_WIRELESS_STATUS_CONNECTED = 2,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum utf8_normalization {
	UTF8_NFDI = 0,
	UTF8_NFDICF = 1,
	UTF8_NMAX = 2,
};

enum utp_data_direction {
	UTP_NO_DATA_TRANSFER = 0,
	UTP_HOST_TO_DEVICE = 1,
	UTP_DEVICE_TO_HOST = 2,
};

enum utp_ocs {
	OCS_SUCCESS = 0,
	OCS_INVALID_CMD_TABLE_ATTR = 1,
	OCS_INVALID_PRDT_ATTR = 2,
	OCS_MISMATCH_DATA_BUF_SIZE = 3,
	OCS_MISMATCH_RESP_UPIU_SIZE = 4,
	OCS_PEER_COMM_FAILURE = 5,
	OCS_ABORTED = 6,
	OCS_FATAL_ERROR = 7,
	OCS_DEVICE_FATAL_ERROR = 8,
	OCS_INVALID_CRYPTO_CONFIG = 9,
	OCS_GENERAL_CRYPTO_ERROR = 10,
	OCS_INVALID_COMMAND_STATUS = 15,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum vc3_clk {
	VC3_REF = 0,
	VC3_SE1 = 1,
	VC3_SE2 = 2,
	VC3_SE3 = 3,
	VC3_DIFF1 = 4,
	VC3_DIFF2 = 5,
};

enum vc3_clk_mux {
	VC3_SE1_MUX = 0,
	VC3_SE2_MUX = 1,
	VC3_SE3_MUX = 2,
	VC3_DIFF1_MUX = 3,
	VC3_DIFF2_MUX = 4,
};

enum vc3_div {
	VC3_DIV1 = 0,
	VC3_DIV2 = 1,
	VC3_DIV3 = 2,
	VC3_DIV4 = 3,
	VC3_DIV5 = 4,
};

enum vc3_div_mux {
	VC3_DIV1_MUX = 0,
	VC3_DIV3_MUX = 1,
	VC3_DIV4_MUX = 2,
};

enum vc3_pfd {
	VC3_PFD1 = 0,
	VC3_PFD2 = 1,
	VC3_PFD3 = 2,
};

enum vc3_pfd_mux {
	VC3_PFD2_MUX = 0,
	VC3_PFD3_MUX = 1,
};

enum vc3_pll {
	VC3_PLL1 = 0,
	VC3_PLL2 = 1,
	VC3_PLL3 = 2,
};

enum vc5_model {
	IDT_VC5_5P49V5923 = 0,
	IDT_VC5_5P49V5925 = 1,
	IDT_VC5_5P49V5933 = 2,
	IDT_VC5_5P49V5935 = 3,
	IDT_VC6_5P49V60 = 4,
	IDT_VC6_5P49V6901 = 5,
	IDT_VC6_5P49V6965 = 6,
	IDT_VC6_5P49V6975 = 7,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_R4K = 1,
	VDSO_CLOCKMODE_GIC = 2,
	VDSO_CLOCKMODE_MAX = 3,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum vdso_pages {
	VDSO_TIME_PAGE_OFFSET = 0,
	VDSO_TIMENS_PAGE_OFFSET = 1,
	VDSO_RNG_PAGE_OFFSET = 2,
	VDSO_ARCH_PAGES_START = 3,
	VDSO_ARCH_PAGES_END = 3,
	VDSO_NR_PAGES = 4,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum vfio_device_mig_state {
	VFIO_DEVICE_STATE_ERROR = 0,
	VFIO_DEVICE_STATE_STOP = 1,
	VFIO_DEVICE_STATE_RUNNING = 2,
	VFIO_DEVICE_STATE_STOP_COPY = 3,
	VFIO_DEVICE_STATE_RESUMING = 4,
	VFIO_DEVICE_STATE_RUNNING_P2P = 5,
	VFIO_DEVICE_STATE_PRE_COPY = 6,
	VFIO_DEVICE_STATE_PRE_COPY_P2P = 7,
	VFIO_DEVICE_STATE_NR = 8,
};

enum vfio_group_type {
	VFIO_IOMMU = 0,
	VFIO_EMULATED_IOMMU = 1,
	VFIO_NO_IOMMU = 2,
};

enum virtio_balloon_config_read {
	VIRTIO_BALLOON_CONFIG_READ_CMD_ID = 0,
};

enum virtio_balloon_vq {
	VIRTIO_BALLOON_VQ_INFLATE = 0,
	VIRTIO_BALLOON_VQ_DEFLATE = 1,
	VIRTIO_BALLOON_VQ_STATS = 2,
	VIRTIO_BALLOON_VQ_FREE_PAGE = 3,
	VIRTIO_BALLOON_VQ_REPORTING = 4,
	VIRTIO_BALLOON_VQ_MAX = 5,
};

enum virtnet_xmit_type {
	VIRTNET_XMIT_TYPE_SKB = 0,
	VIRTNET_XMIT_TYPE_SKB_ORPHAN = 1,
	VIRTNET_XMIT_TYPE_XDP = 2,
	VIRTNET_XMIT_TYPE_XSK = 3,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_NORMAL = 4,
	PGALLOC_MOVABLE = 5,
	ALLOCSTALL_NORMAL = 6,
	ALLOCSTALL_MOVABLE = 7,
	PGSCAN_SKIP_NORMAL = 8,
	PGSCAN_SKIP_MOVABLE = 9,
	PGFREE = 10,
	PGACTIVATE = 11,
	PGDEACTIVATE = 12,
	PGLAZYFREE = 13,
	PGFAULT = 14,
	PGMAJFAULT = 15,
	PGLAZYFREED = 16,
	PGREFILL = 17,
	PGREUSE = 18,
	PGSTEAL_KSWAPD = 19,
	PGSTEAL_DIRECT = 20,
	PGSTEAL_KHUGEPAGED = 21,
	PGSTEAL_PROACTIVE = 22,
	PGSCAN_KSWAPD = 23,
	PGSCAN_DIRECT = 24,
	PGSCAN_KHUGEPAGED = 25,
	PGSCAN_PROACTIVE = 26,
	PGSCAN_DIRECT_THROTTLE = 27,
	PGSCAN_ANON = 28,
	PGSCAN_FILE = 29,
	PGSTEAL_ANON = 30,
	PGSTEAL_FILE = 31,
	PGINODESTEAL = 32,
	SLABS_SCANNED = 33,
	KSWAPD_INODESTEAL = 34,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 35,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 36,
	PAGEOUTRUN = 37,
	PGROTATED = 38,
	DROP_PAGECACHE = 39,
	DROP_SLAB = 40,
	OOM_KILL = 41,
	PGMIGRATE_SUCCESS = 42,
	PGMIGRATE_FAIL = 43,
	THP_MIGRATION_SUCCESS = 44,
	THP_MIGRATION_FAIL = 45,
	THP_MIGRATION_SPLIT = 46,
	COMPACTMIGRATE_SCANNED = 47,
	COMPACTFREE_SCANNED = 48,
	COMPACTISOLATED = 49,
	COMPACTSTALL = 50,
	COMPACTFAIL = 51,
	COMPACTSUCCESS = 52,
	KCOMPACTD_WAKE = 53,
	KCOMPACTD_MIGRATE_SCANNED = 54,
	KCOMPACTD_FREE_SCANNED = 55,
	CMA_ALLOC_SUCCESS = 56,
	CMA_ALLOC_FAIL = 57,
	UNEVICTABLE_PGCULLED = 58,
	UNEVICTABLE_PGSCANNED = 59,
	UNEVICTABLE_PGRESCUED = 60,
	UNEVICTABLE_PGMLOCKED = 61,
	UNEVICTABLE_PGMUNLOCKED = 62,
	UNEVICTABLE_PGCLEARED = 63,
	UNEVICTABLE_PGSTRANDED = 64,
	BALLOON_INFLATE = 65,
	BALLOON_DEFLATE = 66,
	BALLOON_MIGRATE = 67,
	SWAP_RA = 68,
	SWAP_RA_HIT = 69,
	SWPIN_ZERO = 70,
	SWPOUT_ZERO = 71,
	KSM_SWPIN_COPY = 72,
	COW_KSM = 73,
	NR_VM_EVENT_ITEMS = 74,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vm_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_MEMMAP_PAGES = 2,
	NR_MEMMAP_BOOT_PAGES = 3,
	NR_VM_STAT_ITEMS = 4,
};

enum vma_merge_state {
	VMA_MERGE_START = 0,
	VMA_MERGE_ERROR_NOMEM = 1,
	VMA_MERGE_NOMERGE = 2,
	VMA_MERGE_SUCCESS = 3,
};

enum vmalloc64_mode {
	not_refill = 0,
	refill_scratch = 1,
	refill_noscratch = 2,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum vp_vq_vector_policy {
	VP_VQ_VECTOR_POLICY_EACH = 0,
	VP_VQ_VECTOR_POLICY_SHARED_SLOW = 1,
	VP_VQ_VECTOR_POLICY_SHARED = 2,
};

enum vsc85xx_global_phy {
	VSC88XX_BASE_ADDR = 0,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_resize_en {
	WB_RESIZE_EN_IDLE = 0,
	WB_RESIZE_EN_DECREASE = 1,
	WB_RESIZE_EN_INCREASE = 2,
};

enum wb_resize_hint {
	WB_RESIZE_HINT_KEEP = 0,
	WB_RESIZE_HINT_DECREASE = 1,
	WB_RESIZE_HINT_INCREASE = 2,
};

enum wb_resize_status {
	WB_RESIZE_STATUS_IDLE = 0,
	WB_RESIZE_STATUS_IN_PROGRESS = 1,
	WB_RESIZE_STATUS_COMPLETE_SUCCESS = 2,
	WB_RESIZE_STATUS_GENERAL_FAILURE = 3,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum wd_read_status {
	WD_READ_SUCCESS = 0,
	WD_READ_UNSTABLE = 1,
	WD_READ_SKIP = 2,
};

enum why_no_delegation4 {
	WND4_NOT_WANTED = 0,
	WND4_CONTENTION = 1,
	WND4_RESOURCE = 2,
	WND4_NOT_SUPP_FTYPE = 3,
	WND4_WRITE_DELEG_NOT_SUPP_FTYPE = 4,
	WND4_NOT_SUPP_UPGRADE = 5,
	WND4_NOT_SUPP_DOWNGRADE = 6,
	WND4_CANCELLED = 7,
	WND4_IS_DIR = 8,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 11,
	WORK_OFFQ_POOL_BITS = 11,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 2048,
	WQ_UNBOUND_MAX_ACTIVE = 2048,
	WQ_DFL_ACTIVE = 1024,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 17,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 75000,
	MAYDAY_INITIAL_TIMEOUT = 2,
	MAYDAY_INTERVAL = 25,
	CREATE_COOLDOWN = 250,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 256,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum x509_actions {
	ACT_x509_extract_key_data = 0,
	ACT_x509_extract_name_segment = 1,
	ACT_x509_note_OID = 2,
	ACT_x509_note_issuer = 3,
	ACT_x509_note_not_after = 4,
	ACT_x509_note_not_before = 5,
	ACT_x509_note_params = 6,
	ACT_x509_note_serial = 7,
	ACT_x509_note_sig_algo = 8,
	ACT_x509_note_signature = 9,
	ACT_x509_note_subject = 10,
	ACT_x509_note_tbs_certificate = 11,
	ACT_x509_process_extension = 12,
	NR__x509_actions = 13,
};

enum x509_akid_actions {
	ACT_x509_akid_note_kid = 0,
	ACT_x509_akid_note_name = 1,
	ACT_x509_akid_note_serial = 2,
	ACT_x509_extract_name_segment___2 = 3,
	ACT_x509_note_OID___2 = 4,
	NR__x509_akid_actions = 5,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xen_domain_type {
	XEN_NATIVE = 0,
	XEN_PV_DOMAIN = 1,
	XEN_HVM_DOMAIN = 2,
};

enum xenon_phy_type_enum {
	EMMC_5_0_PHY = 0,
	EMMC_5_1_PHY = 1,
	NR_PHY_TYPES = 2,
};

enum xenon_variant {
	XENON_A3700 = 0,
	XENON_AP806 = 1,
	XENON_AP807 = 2,
	XENON_CP110 = 3,
	XENON_AC5 = 4,
};

enum xfer_buf_dir {
	TO_XFER_BUF = 0,
	FROM_XFER_BUF = 1,
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	XFRMA_SA_DIR = 33,
	XFRMA_NAT_KEEPALIVE_INTERVAL = 34,
	XFRMA_SA_PCPU = 35,
	XFRMA_IPTFS_DROP_TIME = 36,
	XFRMA_IPTFS_REORDER_WINDOW = 37,
	XFRMA_IPTFS_DONT_FRAG = 38,
	XFRMA_IPTFS_INIT_DELAY = 39,
	XFRMA_IPTFS_MAX_QSIZE = 40,
	XFRMA_IPTFS_PKT_SIZE = 41,
	__XFRMA_MAX = 42,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xhci_cancelled_td_status {
	TD_DIRTY = 0,
	TD_HALTED = 1,
	TD_CLEARING_CACHE = 2,
	TD_CLEARING_CACHE_DEFERRED = 3,
	TD_CLEARED = 4,
};

enum xhci_ep_reset_type {
	EP_HARD_RESET = 0,
	EP_SOFT_RESET = 1,
};

enum xhci_overhead_type {
	LS_OVERHEAD_TYPE = 0,
	FS_OVERHEAD_TYPE = 1,
	HS_OVERHEAD_TYPE = 2,
};

enum xhci_ring_type {
	TYPE_CTRL = 0,
	TYPE_ISOC = 1,
	TYPE_BULK = 2,
	TYPE_INTR = 3,
	TYPE_STREAM = 4,
	TYPE_COMMAND = 5,
	TYPE_EVENT = 6,
};

enum xhci_setup_dev {
	SETUP_CONTEXT_ONLY = 0,
	SETUP_CONTEXT_ADDRESS = 1,
};

enum xhci_sideband_notify_type {
	XHCI_SIDEBAND_XFER_RING_FREE = 0,
};

enum xhci_sideband_type {
	XHCI_SIDEBAND_AUDIO = 0,
	XHCI_SIDEBAND_VENDOR = 1,
};

enum xprt_transports {
	XPRT_TRANSPORT_UDP = 17,
	XPRT_TRANSPORT_TCP = 6,
	XPRT_TRANSPORT_BC_TCP = -2147483642,
	XPRT_TRANSPORT_RDMA = 256,
	XPRT_TRANSPORT_BC_RDMA = -2147483392,
	XPRT_TRANSPORT_LOCAL = 257,
	XPRT_TRANSPORT_TCP_TLS = 258,
};

enum xprt_xid_rb_cmp {
	XID_RB_EQUAL = 0,
	XID_RB_LEFT = 1,
	XID_RB_RIGHT = 2,
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xz_check {
	XZ_CHECK_NONE = 0,
	XZ_CHECK_CRC32 = 1,
	XZ_CHECK_CRC64 = 4,
	XZ_CHECK_SHA256 = 10,
};

enum xz_mode {
	XZ_SINGLE = 0,
	XZ_PREALLOC = 1,
	XZ_DYNALLOC = 2,
};

enum xz_ret {
	XZ_OK = 0,
	XZ_STREAM_END = 1,
	XZ_UNSUPPORTED_CHECK = 2,
	XZ_MEM_ERROR = 3,
	XZ_MEMLIMIT_ERROR = 4,
	XZ_FORMAT_ERROR = 5,
	XZ_OPTIONS_ERROR = 6,
	XZ_DATA_ERROR = 7,
	XZ_BUF_ERROR = 8,
};

enum yukon_ec_rev {
	CHIP_REV_YU_EC_A1 = 0,
	CHIP_REV_YU_EC_A2 = 1,
	CHIP_REV_YU_EC_A3 = 2,
};

enum yukon_ec_u_rev {
	CHIP_REV_YU_EC_U_A0 = 1,
	CHIP_REV_YU_EC_U_A1 = 2,
	CHIP_REV_YU_EC_U_B0 = 3,
	CHIP_REV_YU_EC_U_B1 = 5,
};

enum yukon_ex_rev {
	CHIP_REV_YU_EX_A0 = 1,
	CHIP_REV_YU_EX_B0 = 2,
};

enum yukon_fe_p_rev {
	CHIP_REV_YU_FE2_A0 = 0,
};

enum yukon_prm_rev {
	CHIP_REV_YU_PRM_Z1 = 1,
	CHIP_REV_YU_PRM_A0 = 2,
};

enum yukon_supr_rev {
	CHIP_REV_YU_SU_A0 = 0,
	CHIP_REV_YU_SU_B0 = 1,
	CHIP_REV_YU_SU_B1 = 3,
};

enum yukon_xl_rev {
	CHIP_REV_YU_XL_A0 = 0,
	CHIP_REV_YU_XL_A1 = 1,
	CHIP_REV_YU_XL_A2 = 2,
	CHIP_REV_YU_XL_A3 = 3,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_FREE_PAGES_BLOCKS = 1,
	NR_ZONE_LRU_BASE = 2,
	NR_ZONE_INACTIVE_ANON = 2,
	NR_ZONE_ACTIVE_ANON = 3,
	NR_ZONE_INACTIVE_FILE = 4,
	NR_ZONE_ACTIVE_FILE = 5,
	NR_ZONE_UNEVICTABLE = 6,
	NR_ZONE_WRITE_PENDING = 7,
	NR_MLOCK = 8,
	NR_FREE_CMA_PAGES = 9,
	NR_VM_ZONE_STAT_ITEMS = 10,
};

enum zone_type {
	ZONE_NORMAL = 0,
	ZONE_MOVABLE = 1,
	__MAX_NR_ZONES = 2,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

typedef _Bool bool;

typedef char __pad_after_uframe[4];

typedef char __pad_before_uframe[0];

typedef const char (* const ethnl_string_array_t)[32];

typedef int __s32;

typedef __s32 Elf32_Sword;

typedef __s32 s32;

typedef s32 __compat_uid_t;

typedef __compat_uid_t __compat_uid32_t;

typedef int __kernel_clockid_t;

typedef int __kernel_ipc_pid_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_ptrdiff_t;

typedef int __kernel_rwf_t;

typedef int __kernel_ssize_t;

typedef int __kernel_timer_t;

typedef int class_get_unused_fd_t;

typedef __kernel_clockid_t clockid_t;

typedef s32 compat_clock_t;

typedef s32 compat_int_t;

typedef s32 compat_long_t;

typedef s32 compat_pid_t;

typedef s32 compat_ssize_t;

typedef s32 compat_timer_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int ext4_grpblk_t;

typedef int folio_walk_flags_t;

typedef int fpb_t;

typedef int fpi_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int kprobe_opcode_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef int snd_ctl_elem_iface_t;

typedef int snd_ctl_elem_type_t;

typedef int snd_pcm_access_t;

typedef int snd_pcm_format_t;

typedef int snd_pcm_hw_param_t;

typedef int snd_pcm_state_t;

typedef int snd_pcm_subformat_t;

typedef __kernel_ssize_t ssize_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef int word_type;

typedef long int __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef long int __kernel_daddr_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long int intptr_t;

typedef long int mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef long int snd_pcm_sframes_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef long long int __s64;

typedef __s64 s64;

typedef s64 int64_t;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long int qsize_t;

typedef __s64 time64_t;

typedef long long unsigned int __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64;

typedef long long unsigned int UDItype;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef __u64 __le64;

typedef __u64 __virtio64;

typedef u64 async_cookie_t;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef u64 clientid4;

typedef u64 compat_u64;

typedef long long unsigned int ext4_fsblk_t;

typedef __be64 fdt64_t;

typedef u64 freelist_full_t;

typedef u64 io_req_flags_t;

typedef long long unsigned int llu;

typedef u64 netdev_features_t;

typedef u64 sci_t;

typedef u64 sector_t;

typedef __u64 timeu64_t;

typedef u64 u_int64_t;

typedef u64 upf_t;

typedef uint64_t vli_type;

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef long unsigned int __kernel_ulong_t;

typedef __kernel_ulong_t __kernel_ino_t;

typedef __kernel_ulong_t aio_context_t;

typedef long unsigned int dspreg_t;

typedef long unsigned int elf_greg_t;

typedef elf_greg_t elf_gregset_t[45];

typedef __kernel_ulong_t ino_t;

typedef long unsigned int irq_hw_number_t;

typedef long unsigned int kernel_ulong_t;

typedef long unsigned int kimage_entry_t;

typedef mpi_limb_t *mpi_ptr_t;

typedef long unsigned int netmem_ref;

typedef long unsigned int old_sigset_t;

typedef long unsigned int perf_trace_t[2048];

typedef long unsigned int pte_marker;

typedef long unsigned int snd_pcm_uframes_t;

typedef long unsigned int uLong;

typedef long unsigned int u_long;

typedef long unsigned int uintptr_t;

typedef long unsigned int ulg;

typedef long unsigned int ulong;

typedef uintptr_t uptrval;

typedef long unsigned int vm_flags_t;

typedef short int __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef short int mm_id_mapcount_t;

typedef short unsigned int __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef short unsigned int ush;

typedef ush Pos;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16;

typedef __u16 __be16;

typedef __u16 __hc16;

typedef short unsigned int __kernel_gid16_t;

typedef short unsigned int __kernel_sa_family_t;

typedef short unsigned int __kernel_uid16_t;

typedef __u16 __le16;

typedef __u16 __rpmsg16;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef __u16 comp_t;

typedef __kernel_gid16_t gid16_t;

typedef short unsigned int mm_id_t;

typedef short unsigned int pci_bus_flags_t;

typedef short unsigned int pci_dev_flags_t;

typedef short unsigned int pipe_index_t;

typedef __u16 port_id;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef short unsigned int u_short;

typedef __kernel_uid16_t uid16_t;

typedef __u16 uio_meta_flags_t;

typedef short unsigned int umode_t;

typedef short unsigned int ushort;

typedef u16 wchar_t;

typedef signed char __s8;

typedef __s8 s8;

typedef s8 int8_t;

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef uint8_t U8;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef u8 dscp_t;

typedef u8 rmap_age_t;

typedef unsigned char *sk_buff_data_t;

typedef unsigned char u8___2;

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef __u8 virtio_net_ctrl_ack;

typedef unsigned int __kernel_size_t;

typedef __kernel_size_t size_t;

typedef size_t BitContainerType;

typedef unsigned int __u32;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_DTable;

typedef __u32 u32;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef unsigned int OM_uint32;

typedef __u32 __be32;

typedef __u32 __dw;

typedef __u32 __hc32;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_gid_t;

typedef unsigned int __kernel_mode_t;

typedef unsigned int __kernel_old_dev_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_uid_t;

typedef __u32 __le32;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __rpmsg32;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef unsigned int autofs_wqt_t;

typedef unsigned int blk_features_t;

typedef unsigned int blk_flags_t;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef u32 compat_caddr_t;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef unsigned int cycles_t;

typedef u32 depot_flags_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef u32 dma_addr_t;

typedef uint32_t drbg_flag_t;

typedef u32 errseq_t;

typedef unsigned int ext4_group_t;

typedef __u32 ext4_lblk_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef unsigned int ioasid_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef u32 jump_label_t;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef unsigned int mips_instruction;

typedef unsigned int mmc_pm_flag_t;

typedef __kernel_mode_t mode_t;

typedef u32 nlink_t;

typedef u32 note_buf_t[72];

typedef u32 pci_bus_addr_t;

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef u32 phys_addr_t;

typedef __kernel_uid32_t projid_t;

typedef __kernel_uid32_t qid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef phys_addr_t resource_size_t;

typedef u32 rpc_authflavor_t;

typedef __be32 rpc_fraghdr;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int tid_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef u32 u_int32_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unicode_t;

typedef u32 uprobe_opcode_t;

typedef unsigned int upstat_t;

typedef u32 usb_port_location_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef unsigned int zap_flags_t;

typedef struct {
	BitContainerType bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

struct DWstruct {
	int low;
	int high;
};

typedef union {
	struct DWstruct s;
	long long int ll;
} DWunion;

typedef struct {
	size_t state;
	const void *table;
} FSE_DState_t;

typedef struct {
	U16 tableLog;
	U16 fastMode;
} FSE_DTableHeader;

typedef struct {
	short int ncount[256];
} FSE_DecompressWksp;

typedef struct {
	short unsigned int newState;
	unsigned char symbol;
	unsigned char nbBits;
} FSE_decode_t;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U16 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	const BYTE *ip[4];
	BYTE *op[4];
	U64 bits[4];
	const void *dt;
	const BYTE *ilowest;
	BYTE *oend;
	const BYTE *iend[4];
	long: 32;
} HUF_DecompressFastArgs;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[219];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef struct {
	U32 rankVal[156];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[219];
} HUF_ReadDTableX2_Workspace;

struct buffer_head;

typedef struct {
	__le32 *p;
	__le32 key;
	struct buffer_head *bh;
} Indirect;

typedef struct {
	const uint8_t *externalDict;
	size_t extDictSize;
	const uint8_t *prefixEnd;
	size_t prefixSize;
} LZ4_streamDecode_t_internal;

typedef union {
	long long unsigned int table[4];
	LZ4_streamDecode_t_internal internal_donotuse;
} LZ4_streamDecode_t;

struct folio;

typedef struct {
	struct folio *v;
} Sector;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

typedef struct {
	long long unsigned int frameContentSize;
	long long unsigned int windowSize;
	unsigned int blockSizeMax;
	ZSTD_FrameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
	unsigned int _reserved1;
	unsigned int _reserved2;
	long: 32;
} ZSTD_FrameHeader;

typedef struct {
	unsigned int longOffsetShare;
	unsigned int maxNbAdditionalBits;
} ZSTD_OffsetInfo;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	U16 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef struct {
	size_t nbBlocks;
	size_t compressedSize;
	long long unsigned int decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ZSTD_fseState;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ZSTD_seqSymbol_header;

typedef struct {
	long unsigned int fds_bits[32];
} __kernel_fd_set;

typedef struct {
	int val[2];
} __kernel_fsid_t;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef struct {
	s64 counter;
} atomic64_t;

typedef struct {
	int counter;
} atomic_t;

typedef atomic_t atomic_long_t;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

struct permanent_flags_t {
	__be16 tag;
	u8 disable;
	u8 ownership;
	u8 deactivated;
	u8 readPubek;
	u8 disableOwnerClear;
	u8 allowMaintenance;
	u8 physicalPresenceLifetimeLock;
	u8 physicalPresenceHWEnable;
	u8 physicalPresenceCMDEnable;
	u8 CEKPUsed;
	u8 TPMpost;
	u8 TPMpostLock;
	u8 FIPS;
	u8 operator;
	u8 enableRevokeEK;
	u8 nvLocked;
	u8 readSRKPub;
	u8 tpmEstablished;
	u8 maintenanceDone;
	u8 disableFullDALogicInfo;
};

struct stclear_flags_t {
	__be16 tag;
	u8 deactivated;
	u8 disableForceClear;
	u8 physicalPresence;
	u8 physicalPresenceLock;
	u8 bGlobalLock;
} __attribute__((packed));

struct tpm1_version {
	u8 major;
	u8 minor;
	u8 rev_major;
	u8 rev_minor;
};

struct tpm1_version2 {
	__be16 tag;
	struct tpm1_version version;
};

struct timeout_t {
	__be32 a;
	__be32 b;
	__be32 c;
	__be32 d;
};

struct duration_t {
	__be32 tpm_short;
	__be32 tpm_medium;
	__be32 tpm_long;
};

typedef union {
	struct permanent_flags_t perm_flags;
	struct stclear_flags_t stclear_flags;
	__u8 owned;
	__be32 num_pcrs;
	struct tpm1_version version1;
	struct tpm1_version2 version2;
	__be32 manufacturer_id;
	struct timeout_t timeout;
	struct duration_t duration;
} cap_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	void *lock;
} class_cpus_read_lock_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

struct irq_desc;

typedef struct {
	struct irq_desc *lock;
	long unsigned int flags;
	bool bus;
} class_irqdesc_lock_t;

typedef struct {
	void *lock;
	long unsigned int flags;
} class_irqsave_t;

struct device;

typedef struct {
	struct device *lock;
} class_msi_descs_lock_t;

struct snd_pcm_substream;

typedef struct {
	struct snd_pcm_substream *lock;
} class_pcm_stream_lock_irq_t;

typedef struct {
	struct snd_pcm_substream *lock;
	long unsigned int flags;
} class_pcm_stream_lock_irqsave_t;

struct perf_cpu_context;

struct perf_event_context;

typedef struct {
	struct perf_cpu_context *cpuctx;
	struct perf_event_context *ctx;
} class_perf_ctx_lock_t;

typedef struct {
	void *lock;
} class_preempt_notrace_t;

typedef struct {
	void *lock;
} class_preempt_t;

struct raw_spinlock;

typedef struct raw_spinlock raw_spinlock_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	long unsigned int flags;
} class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_t;

typedef struct {
	void *lock;
} class_rcu_t;

typedef struct {
	void *lock;
} class_rcu_tasks_trace_t;

struct qspinlock {
	union {
		atomic_t val;
		struct {
			u8 locked;
			u8 pending;
		};
		struct {
			u16 locked_pending;
			u16 tail;
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_read_lock_irqsave_t;

struct pin_cookie {};

struct rq_flags {
	long unsigned int flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
};

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_t;

struct spinlock;

typedef struct spinlock spinlock_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	long unsigned int flags;
} class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_irq_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_write_lock_irqsave_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	short unsigned int val;
} code;

typedef struct {
	long unsigned int bits[1];
} dma_cap_mask_t;

typedef struct {
	__u8 b[16];
} guid_t;

typedef guid_t efi_guid_t;

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ext4_acl_header;

typedef __kernel_fd_set fd_set;

typedef struct {
	long unsigned int *in;
	long unsigned int *out;
	long unsigned int *ex;
	long unsigned int *res_in;
	long unsigned int *res_out;
	long unsigned int *res_ex;
} fd_set_bits;

typedef struct {
	atomic_t refcnt;
} file_ref_t;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		long unsigned int counter;
	};
	freelist_full_t full;
} freelist_aba_t;

typedef struct {
	long unsigned int v;
} freeptr_t;

typedef struct {
	long unsigned int key[2];
} hsiphash_key_t;

typedef struct {
	unsigned int __softirq_pending;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
} irq_cpustat_t;

typedef struct {
	u64 val;
} kernel_cap_t;

typedef struct {
	gid_t val;
} kgid_t;

typedef struct {
	projid_t val;
} kprojid_t;

typedef struct {
	uid_t val;
} kuid_t;

typedef struct {
	atomic64_t a;
} local64_t;

typedef struct {} local_lock_t;

typedef struct {
	atomic_long_t a;
} local_t;

typedef struct {
	local_lock_t llock;
	u8 acquired;
} local_trylock_t;

typedef struct {} lockdep_map_p;

typedef union {
	long unsigned int x[1];
} map_word;

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

typedef struct {
	union {
		u64 asid[256];
		atomic64_t mmid;
	};
	void *vdso;
	spinlock_t bd_emupage_lock;
	long unsigned int *bd_emupage_allocmap;
	wait_queue_head_t bd_emupage_queue;
} mm_context_t;

typedef struct {} netdevice_tracker;

typedef struct {} netns_tracker;

typedef struct {
	char data[8];
} nfs4_verifier;

typedef struct {
	long unsigned int bits[1];
} nodemask_t;

typedef struct {
	long unsigned int pgd;
} pgd_t;

typedef struct {
	pgd_t pgd;
} p4d_t;

typedef struct {
	u64 pme;
} pagemap_entry_t;

typedef struct {
	u64 val;
} pfn_t;

typedef struct {
	long unsigned int pgprot;
} pgprot_t;

typedef struct {
	p4d_t p4d;
} pud_t;

typedef struct {
	pud_t pud;
} pmd_t;

struct net;

typedef struct {
	struct net *net;
} possible_net_t;

typedef struct {
	long unsigned int pte;
} pte_t;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

typedef union {
} release_pages_arg;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} seqState_t;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} seq_t;

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

typedef struct {
	long unsigned int sig[4];
} sigset_t;

typedef struct {
	u64 key[2];
} siphash_key_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

typedef struct {
	char *from;
	char *to;
} substring_t;

typedef struct {
	long unsigned int val;
} swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	u64 v;
} u64_stats_t;

typedef struct {
	__u8 b[16];
} uuid_t;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef struct {
	uid_t val;
} vfsuid_t;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} xfrm_address_t;

typedef ZSTD_customMem zstd_custom_mem;

typedef ZSTD_FrameHeader zstd_frame_header;

struct IOV_111 {
	u8 maxVFsSupported;
	u8 numVFsEnabled;
	u8 requestorId;
	u8 reserved[5];
};

struct IO_REQUEST_INFO {
	u64 ldStartBlock;
	u32 numBlocks;
	u16 ldTgtId;
	u8 isRead;
	__le16 devHandle;
	u8 pd_interface;
	long: 32;
	u64 pdBlock;
	u8 fpOkForIo;
	u8 IoforUnevenSpan;
	u8 start_span;
	u8 do_fp_rlbypass;
	long: 32;
	u64 start_row;
	u8 span_arm;
	u8 pd_after_lb;
	u16 r1_alt_dev_handle;
	bool ra_capable;
	u8 data_arms;
};

struct LD_LOAD_BALANCE_INFO {
	u8 loadBalanceFlag;
	u8 reserved1;
	atomic_t scsi_pending_cmds[256];
	long: 32;
	u64 last_accessed_block[256];
};

struct megasas_cmd_fusion;

struct STREAM_DETECT {
	u64 next_seq_lba;
	struct megasas_cmd_fusion *first_cmd_fusion;
	struct megasas_cmd_fusion *last_cmd_fusion;
	u32 count_cmds_in_stream;
	u16 num_sges_in_group;
	u8 is_read;
	u8 group_depth;
	bool group_flush;
	u8 reserved[7];
};

struct LD_STREAM_DETECT {
	bool write_back;
	bool fp_write_enabled;
	bool members_ssds;
	bool fp_cache_bypass_capable;
	u32 mru_bit_map;
	struct STREAM_DETECT stream_track[8];
};

struct _LD_SPAN_SET {
	u64 log_start_lba;
	u64 log_end_lba;
	u64 span_row_start;
	u64 span_row_end;
	u64 data_strip_start;
	u64 data_strip_end;
	u64 data_row_start;
	u64 data_row_end;
	u8 strip_offset[8];
	u32 span_row_data_width;
	u32 diff;
	u32 reserved[2];
};

typedef struct _LD_SPAN_SET LD_SPAN_SET;

struct LOG_BLOCK_SPAN_INFO {
	LD_SPAN_SET span_set[8];
};

typedef struct LOG_BLOCK_SPAN_INFO LD_SPAN_INFO;

typedef struct LOG_BLOCK_SPAN_INFO *PLD_SPAN_INFO;

struct MEGASAS_RAID_MFA_IO_REQUEST_DESCRIPTOR {
	u32 RequestFlags: 8;
	u32 MessageAddress1: 24;
	u32 MessageAddress2;
};

struct MPI2_DEFAULT_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 DescriptorTypeDependent;
};

struct MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 Reserved1;
};

struct MPI2_SCSI_IO_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 DevHandle;
};

struct MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 IoIndex;
};

struct MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 Reserved;
};

union MEGASAS_REQUEST_DESCRIPTOR_UNION {
	struct MPI2_DEFAULT_REQUEST_DESCRIPTOR Default;
	struct MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR HighPriority;
	struct MPI2_SCSI_IO_REQUEST_DESCRIPTOR SCSIIO;
	struct MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR SCSITarget;
	struct MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR RAIDAccelerator;
	struct MEGASAS_RAID_MFA_IO_REQUEST_DESCRIPTOR MFAIo;
	union {
		struct {
			__le32 low;
			__le32 high;
		} u;
		__le64 Words;
	};
};

struct MPI25_IEEE_SGE_CHAIN64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 NextChainOffset;
	u8 Flags;
};

struct MPI2_ADDRESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le32 ReplyFrameAddress;
};

struct MPI2_DEFAULT_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 DescriptorTypeDependent1;
	__le32 DescriptorTypeDependent2;
};

struct MPI2_IEEE_SGE_CHAIN32 {
	__le32 Address;
	__le32 FlagsLength;
};

struct MPI2_IEEE_SGE_CHAIN64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 Reserved2;
	u8 Flags;
};

union MPI2_IEEE_SGE_CHAIN_UNION {
	struct MPI2_IEEE_SGE_CHAIN32 Chain32;
	struct MPI2_IEEE_SGE_CHAIN64 Chain64;
};

struct MPI2_IEEE_SGE_SIMPLE32 {
	__le32 Address;
	__le32 FlagsLength;
};

struct MPI2_IEEE_SGE_SIMPLE64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 Reserved2;
	u8 Flags;
};

union MPI2_IEEE_SGE_SIMPLE_UNION {
	struct MPI2_IEEE_SGE_SIMPLE32 Simple32;
	struct MPI2_IEEE_SGE_SIMPLE64 Simple64;
};

struct MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY {
	u64 RDPQBaseAddress;
	u32 Reserved1;
	u32 Reserved2;
};

struct MPI2_IOC_INIT_REQUEST {
	u8 WhoInit;
	u8 Reserved1;
	u8 ChainOffset;
	u8 Function;
	__le16 Reserved2;
	u8 Reserved3;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	__le16 Reserved4;
	__le16 MsgVersion;
	__le16 HeaderVersion;
	u32 Reserved5;
	__le16 Reserved6;
	u8 HostPageSize;
	u8 HostMSIxVectors;
	__le16 Reserved8;
	__le16 SystemRequestFrameSize;
	__le16 ReplyDescriptorPostQueueDepth;
	__le16 ReplyFreeQueueDepth;
	__le32 SenseBufferAddressHigh;
	__le32 SystemReplyAddressHigh;
	__le64 SystemRequestFrameBaseAddress;
	__le64 ReplyDescriptorPostQueueAddress;
	__le64 ReplyFreeQueueAddress;
	__le64 TimeStamp;
};

struct MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le32 Reserved;
};

struct MPI2_SCSI_IO_CDB_EEDP32 {
	u8 CDB[20];
	__be32 PrimaryReferenceTag;
	__be16 PrimaryApplicationTag;
	__be16 PrimaryApplicationTagMask;
	__le32 TransferLength;
};

struct MPI2_SGE_SIMPLE_UNION {
	__le32 FlagsLength;
	long: 32;
	union {
		__le32 Address32;
		__le64 Address64;
	} u;
};

union MPI2_SCSI_IO_CDB_UNION {
	u8 CDB32[32];
	struct MPI2_SCSI_IO_CDB_EEDP32 EEDP32;
	struct MPI2_SGE_SIMPLE_UNION SGE;
};

struct RAID_CONTEXT {
	u8 type: 4;
	u8 nseg: 4;
	u8 resvd0;
	__le16 timeout_value;
	u8 reg_lock_flags;
	u8 resvd1;
	__le16 virtual_disk_tgt_id;
	__le64 reg_lock_row_lba;
	__le32 reg_lock_length;
	__le16 next_lmid;
	u8 ex_status;
	u8 status;
	u8 raid_flags;
	u8 num_sge;
	__le16 config_seq_num;
	u8 span_arm;
	u8 priority;
	u8 num_sge_ext;
	u8 resvd2;
};

struct RAID_CONTEXT_G35 {
	u16 nseg_type;
	u16 timeout_value;
	u16 routing_flags;
	u16 virtual_disk_tgt_id;
	__le64 reg_lock_row_lba;
	u32 reg_lock_length;
	union {
		u16 rmw_op_index;
		u16 peer_smid;
		u16 r56_arm_map;
	} flow_specific;
	u8 ex_status;
	u8 status;
	u8 raid_flags;
	u8 span_arm;
	u16 config_seq_num;
	union {
		struct {
			u16 num_sge: 12;
			u16 reserved: 3;
			u16 stream_detected: 1;
		} bits;
		u8 bytes[2];
	} u;
	u8 resvd2[2];
};

union RAID_CONTEXT_UNION {
	struct RAID_CONTEXT raid_context;
	struct RAID_CONTEXT_G35 raid_context_g35;
};

struct MPI2_SGE_CHAIN_UNION {
	__le16 Length;
	u8 NextChainOffset;
	u8 Flags;
	long: 32;
	union {
		__le32 Address32;
		__le64 Address64;
	} u;
};

union MPI2_SGE_IO_UNION {
	struct MPI2_SGE_SIMPLE_UNION MpiSimple;
	struct MPI2_SGE_CHAIN_UNION MpiChain;
	union MPI2_IEEE_SGE_SIMPLE_UNION IeeeSimple;
	union MPI2_IEEE_SGE_CHAIN_UNION IeeeChain;
};

struct MPI2_RAID_SCSI_IO_REQUEST {
	__le16 DevHandle;
	u8 ChainOffset;
	u8 Function;
	__le16 Reserved1;
	u8 Reserved2;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	__le16 Reserved3;
	__le32 SenseBufferLowAddress;
	__le16 SGLFlags;
	u8 SenseBufferLength;
	u8 Reserved4;
	u8 SGLOffset0;
	u8 SGLOffset1;
	u8 SGLOffset2;
	u8 SGLOffset3;
	__le32 SkipCount;
	__le32 DataLength;
	__le32 BidirectionalDataLength;
	__le16 IoFlags;
	__le16 EEDPFlags;
	__le32 EEDPBlockSize;
	__le32 SecondaryReferenceTag;
	__le16 SecondaryApplicationTag;
	__le16 ApplicationTagTranslationMask;
	u8 LUN[8];
	__le32 Control;
	union MPI2_SCSI_IO_CDB_UNION CDB;
	union RAID_CONTEXT_UNION RaidContext;
	union {
		union MPI2_SGE_IO_UNION SGL;
		struct {
			struct {} __empty_SGLs;
			union MPI2_SGE_IO_UNION SGLs[0];
		};
	};
};

struct MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 TaskTag;
	__le16 Reserved1;
};

struct MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	u8 SequenceNumber;
	u8 Reserved1;
	__le16 IoIndex;
};

struct MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	u8 VP_ID;
	u8 Flags;
	__le16 InitiatorDevHandle;
	__le16 IoIndex;
};

union MPI2_REPLY_DESCRIPTORS_UNION {
	struct MPI2_DEFAULT_REPLY_DESCRIPTOR Default;
	struct MPI2_ADDRESS_REPLY_DESCRIPTOR AddressReply;
	struct MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR SCSIIOSuccess;
	struct MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR TargetAssistSuccess;
	struct MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR TargetCommandBuffer;
	struct MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR RAIDAcceleratorSuccess;
	__le64 Words;
};

struct MPI2_SCSI_TASK_MANAGE_REPLY {
	u16 DevHandle;
	u8 MsgLength;
	u8 Function;
	u8 ResponseCode;
	u8 TaskType;
	u8 Reserved1;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	u16 Reserved2;
	u16 Reserved3;
	u16 IOCStatus;
	u32 IOCLogInfo;
	u32 TerminationCount;
	u32 ResponseInfo;
};

struct MPI2_SCSI_TASK_MANAGE_REQUEST {
	u16 DevHandle;
	u8 ChainOffset;
	u8 Function;
	u8 Reserved1;
	u8 TaskType;
	u8 Reserved2;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	u16 Reserved3;
	u8 LUN[8];
	u32 Reserved4[7];
	u16 TaskMID;
	u16 Reserved5;
};

struct MR_ARRAY_INFO {
	__le16 pd[32];
};

struct MR_CPU_AFFINITY_MASK {
	union {
		struct {
			u8 hw_path: 1;
			u8 cpu0: 1;
			u8 cpu1: 1;
			u8 cpu2: 1;
			u8 cpu3: 1;
			u8 reserved: 3;
		};
		u8 core_mask;
	};
};

struct MR_CTRL_HB_HOST_MEM {
	struct {
		u32 fwCounter;
		struct {
			u32 debugmode: 1;
			u32 reserved: 31;
		} debug;
		u32 reserved_fw[6];
		u32 driverCounter;
		u32 reserved_driver[7];
	} HB;
	u8 pad[960];
};

struct MR_DEV_HANDLE_INFO {
	__le16 curDevHdl;
	u8 validHandles;
	u8 interfaceType;
	__le16 devHandle[2];
};

struct MR_IO_AFFINITY {
	union {
		struct {
			struct MR_CPU_AFFINITY_MASK pdRead;
			struct MR_CPU_AFFINITY_MASK pdWrite;
			struct MR_CPU_AFFINITY_MASK ldRead;
			struct MR_CPU_AFFINITY_MASK ldWrite;
		};
		u32 word;
	};
	u8 maxCores;
	u8 reserved[3];
};

struct MR_LD_RAID {
	struct {
		u32 fpCapable: 1;
		u32 ra_capable: 1;
		u32 reserved5: 2;
		u32 ldPiMode: 4;
		u32 pdPiMode: 4;
		u32 encryptionType: 8;
		u32 fpWriteCapable: 1;
		u32 fpReadCapable: 1;
		u32 fpWriteAcrossStripe: 1;
		u32 fpReadAcrossStripe: 1;
		u32 fpNonRWCapable: 1;
		u32 tmCapable: 1;
		u32 fpBypassRegionLock: 1;
		u32 disable_coalescing: 1;
		u32 fp_rmw_capable: 1;
		u32 fp_cache_bypass_capable: 1;
		u32 reserved4: 2;
	} capability;
	__le32 reserved6;
	__le64 size;
	u8 spanDepth;
	u8 level;
	u8 stripeShift;
	u8 rowSize;
	u8 rowDataSize;
	u8 writeMode;
	u8 PRL;
	u8 SRL;
	__le16 targetId;
	u8 ldState;
	u8 regTypeReqOnWrite;
	u8 modFactor;
	u8 regTypeReqOnRead;
	__le16 seqNum;
	struct {
		u32 ldSyncRequired: 1;
		u32 regTypeReqOnReadIsValid: 1;
		u32 isEPD: 1;
		u32 enableSLDOnAllRWIOs: 1;
		u32 reserved: 28;
	} flags;
	u8 LUN[8];
	u8 fpIoTimeoutForLd;
	u8 ld_accept_priority_type;
	u8 reserved2[2];
	u32 logical_block_length;
	struct {
		u32 ld_pi_exp: 4;
		u32 ld_logical_block_exp: 4;
		u32 reserved1: 24;
	};
	struct MR_IO_AFFINITY cpuAffinity;
	u8 reserved3[64];
};

struct MR_LD_SPAN {
	__le64 startBlk;
	__le64 numBlks;
	__le16 arrayRef;
	u8 spanRowSize;
	u8 spanRowDataSize;
	u8 reserved[4];
};

struct MR_QUAD_ELEMENT {
	__le64 logStart;
	__le64 logEnd;
	__le64 offsetInSpan;
	__le32 diff;
	__le32 reserved1;
};

struct MR_SPAN_INFO {
	__le32 noElements;
	__le32 reserved1;
	struct MR_QUAD_ELEMENT quad[8];
};

struct MR_SPAN_BLOCK_INFO {
	__le64 num_rows;
	struct MR_LD_SPAN span;
	struct MR_SPAN_INFO block_span_info;
};

struct MR_LD_SPAN_MAP {
	struct MR_LD_RAID ldRaid;
	u8 dataArmMap[32];
	struct MR_SPAN_BLOCK_INFO spanBlock[8];
};

struct MR_DRV_RAID_MAP {
	__le32 totalSize;
	union {
		struct {
			__le32 maxLd;
			__le32 maxSpanDepth;
			__le32 maxRowSize;
			__le32 maxPdCount;
			__le32 maxArrays;
		} validationInfo;
		__le32 version[5];
	};
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	__le16 ldCount;
	__le16 arCount;
	__le16 spanCount;
	__le16 reserve3;
	struct MR_DEV_HANDLE_INFO devHndlInfo[512];
	u16 ldTgtIdToLd[512];
	struct MR_ARRAY_INFO arMapInfo[512];
	struct MR_LD_SPAN_MAP ldSpanMap[0];
};

struct MR_DRV_RAID_MAP_ALL {
	struct MR_DRV_RAID_MAP raidMap;
	struct MR_LD_SPAN_MAP ldSpanMap[512];
};

struct MR_DRV_SYSTEM_INFO {
	u8 infoVersion;
	u8 systemIdLength;
	u16 reserved0;
	u8 systemId[64];
	u8 reserved[1980];
};

struct MR_FW_RAID_MAP {
	__le32 totalSize;
	union {
		struct {
			__le32 maxLd;
			__le32 maxSpanDepth;
			__le32 maxRowSize;
			__le32 maxPdCount;
			__le32 maxArrays;
		} validationInfo;
		__le32 version[5];
	};
	__le32 ldCount;
	__le32 Reserved1;
	u8 ldTgtIdToLd[128];
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	struct MR_ARRAY_INFO arMapInfo[128];
	struct MR_DEV_HANDLE_INFO devHndlInfo[256];
	struct MR_LD_SPAN_MAP ldSpanMap[0];
};

struct MR_FW_RAID_MAP_ALL {
	struct MR_FW_RAID_MAP raidMap;
	struct MR_LD_SPAN_MAP ldSpanMap[64];
};

struct MR_RAID_MAP_DESC_TABLE {
	u32 raid_map_desc_type;
	u32 raid_map_desc_offset;
	u32 raid_map_desc_buffer_size;
	u32 raid_map_desc_elements;
};

struct MR_FW_RAID_MAP_DYNAMIC {
	u32 raid_map_size;
	u32 desc_table_offset;
	u32 desc_table_size;
	u32 desc_table_num_elements;
	u64 reserved1;
	u32 reserved2[3];
	u8 fp_pd_io_timeout_sec;
	u8 reserved3[3];
	u32 rmw_fp_seq_num;
	u16 ld_count;
	u16 ar_count;
	u16 span_count;
	u16 reserved4[3];
	union {
		struct {
			struct MR_DEV_HANDLE_INFO *dev_hndl_info;
			u16 *ld_tgt_id_to_ld;
			struct MR_ARRAY_INFO *ar_map_info;
			struct MR_LD_SPAN_MAP *ld_span_map;
		};
		u64 ptr_structure_size[4];
	};
	struct MR_RAID_MAP_DESC_TABLE raid_map_desc_table[4];
	u32 raid_map_desc_data[0];
};

struct MR_FW_RAID_MAP_EXT {
	u32 reserved;
	union {
		struct {
			u32 maxLd;
			u32 maxSpanDepth;
			u32 maxRowSize;
			u32 maxPdCount;
			u32 maxArrays;
		} validationInfo;
		u32 version[5];
	};
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	__le16 ldCount;
	__le16 arCount;
	__le16 spanCount;
	__le16 reserve3;
	struct MR_DEV_HANDLE_INFO devHndlInfo[256];
	u8 ldTgtIdToLd[256];
	struct MR_ARRAY_INFO arMapInfo[256];
	struct MR_LD_SPAN_MAP ldSpanMap[256];
};

struct MR_HOST_DEVICE_LIST_ENTRY {
	struct {
		union {
			struct {
				u8 is_sys_pd: 1;
				u8 reserved: 7;
			} bits;
			u8 byte;
		} u;
	} flags;
	u8 scsi_type;
	__le16 target_id;
	u8 reserved[4];
	__le64 sas_addr[2];
};

struct MR_HOST_DEVICE_LIST {
	__le32 size;
	__le32 count;
	__le32 reserved[2];
	struct MR_HOST_DEVICE_LIST_ENTRY host_device_list[0];
};

union MR_LD_REF {
	struct {
		u8 targetId;
		u8 reserved;
		__le16 seqNum;
	};
	__le32 ref;
};

struct MR_LD_LIST {
	__le32 ldCount;
	__le32 reserved;
	struct {
		union MR_LD_REF ref;
		u8 state;
		u8 reserved[3];
		__le64 size;
	} ldList[256];
};

struct MR_LD_TARGETID_LIST {
	__le32 size;
	__le32 count;
	u8 pad[3];
	u8 targetId[256];
};

struct MR_LD_TARGET_SYNC {
	u8 targetId;
	u8 reserved;
	__le16 seqNum;
};

struct MR_LD_VF_MAP {
	u32 size;
	union MR_LD_REF ref;
	u8 ldVfCount;
	u8 reserved[6];
	u8 policy[0];
};

struct MR_LD_VF_AFFILIATION {
	u32 size;
	u8 ldCount;
	u8 vfCount;
	u8 thisVf;
	u8 reserved[9];
	struct MR_LD_VF_MAP map[1];
};

struct MR_LD_VF_MAP_111 {
	u8 targetId;
	u8 reserved[3];
	u8 policy[8];
};

struct MR_LD_VF_AFFILIATION_111 {
	u8 vdCount;
	u8 vfCount;
	u8 thisVf;
	u8 reserved[5];
	struct MR_LD_VF_MAP_111 map[64];
};

struct MR_PD_ADDRESS {
	__le16 deviceId;
	u16 enclDeviceId;
	union {
		struct {
			u8 enclIndex;
			u8 slotNumber;
		} mrPdAddress;
		struct {
			u8 enclPosition;
			u8 enclConnectorIndex;
		} mrEnclAddress;
	};
	u8 scsiDevType;
	union {
		u8 connectedPortBitmap;
		u8 connectedPortNumbers;
	};
	u64 sasAddr[2];
};

struct MR_PD_CFG_SEQ {
	u16 seqNum;
	u16 devHandle;
	struct {
		u8 tmCapable: 1;
		u8 reserved: 7;
	} capability;
	u8 reserved;
	u16 pd_target_id;
};

struct MR_PD_CFG_SEQ_NUM_SYNC {
	__le32 size;
	__le32 count;
	struct MR_PD_CFG_SEQ seq[0];
};

union MR_PD_DDF_TYPE {
	struct {
		union {
			struct {
				u16 forcedPDGUID: 1;
				u16 inVD: 1;
				u16 isGlobalSpare: 1;
				u16 isSpare: 1;
				u16 isForeign: 1;
				u16 reserved: 7;
				u16 intf: 4;
			} pdType;
			u16 type;
		};
		u16 reserved;
	} ddf;
	struct {
		u32 reserved;
	} nonDisk;
	u32 type;
};

union MR_PD_REF {
	struct {
		u16 deviceId;
		u16 seqNum;
	} mrPdRef;
	u32 ref;
};

union MR_PROGRESS {
	struct {
		u16 progress;
		union {
			u16 elapsedSecs;
			u16 elapsedSecsForLastPercent;
		};
	} mrProgress;
	u32 w;
};

struct MR_PD_PROGRESS {
	struct {
		u32 rbld: 1;
		u32 patrol: 1;
		u32 clear: 1;
		u32 copyBack: 1;
		u32 erase: 1;
		u32 locate: 1;
		u32 reserved: 26;
	} active;
	union MR_PROGRESS rbld;
	union MR_PROGRESS patrol;
	union {
		union MR_PROGRESS clear;
		union MR_PROGRESS erase;
	};
	struct {
		u32 rbld: 1;
		u32 patrol: 1;
		u32 clear: 1;
		u32 copyBack: 1;
		u32 erase: 1;
		u32 reserved: 27;
	} pause;
	union MR_PROGRESS reserved[3];
};

struct MR_PD_INFO {
	union MR_PD_REF ref;
	u8 inquiryData[96];
	u8 vpdPage83[64];
	u8 notSupported;
	u8 scsiDevType;
	union {
		u8 connectedPortBitmap;
		u8 connectedPortNumbers;
	};
	u8 deviceSpeed;
	u32 mediaErrCount;
	u32 otherErrCount;
	u32 predFailCount;
	u32 lastPredFailEventSeqNum;
	u16 fwState;
	u8 disabledForRemoval;
	u8 linkSpeed;
	union MR_PD_DDF_TYPE state;
	struct {
		u8 count;
		u8 isPathBroken: 4;
		u8 reserved3: 3;
		u8 widePortCapable: 1;
		u8 connectorIndex[2];
		u8 reserved[4];
		u64 sasAddr[2];
		u8 reserved2[16];
	} pathInfo;
	u64 rawSize;
	u64 nonCoercedSize;
	u64 coercedSize;
	u16 enclDeviceId;
	u8 enclIndex;
	union {
		u8 slotNumber;
		u8 enclConnectorIndex;
	};
	struct MR_PD_PROGRESS progInfo;
	u8 badBlockTableFull;
	u8 unusableInCurrentConfig;
	u8 vpdPage83Ext[64];
	u8 powerState;
	u8 enclPosition;
	u32 allowedOps;
	u16 copyBackPartnerId;
	u16 enclPartnerDeviceId;
	struct {
		u16 fdeCapable: 1;
		u16 fdeEnabled: 1;
		u16 secured: 1;
		u16 locked: 1;
		u16 foreign: 1;
		u16 needsEKM: 1;
		u16 reserved: 10;
	} security;
	u8 mediaType;
	u8 notCertified;
	u8 bridgeVendor[8];
	u8 bridgeProductIdentification[16];
	u8 bridgeProductRevisionLevel[4];
	u8 satBridgeExists;
	u8 interfaceType;
	u8 temperature;
	u8 emulatedBlockSize;
	u16 userDataBlockSize;
	u16 reserved2;
	struct {
		u32 piType: 3;
		u32 piFormatted: 1;
		u32 piEligible: 1;
		u32 NCQ: 1;
		u32 WCE: 1;
		u32 commissionedSpare: 1;
		u32 emergencySpare: 1;
		u32 ineligibleForSSCD: 1;
		u32 ineligibleForLd: 1;
		u32 useSSEraseType: 1;
		u32 wceUnchanged: 1;
		u32 supportScsiUnmap: 1;
		u32 reserved: 18;
	} properties;
	u64 shieldDiagCompletionTime;
	u8 shieldCounter;
	u8 linkSpeedOther;
	u8 reserved4[2];
	struct {
		u32 bbmErrCountSupported: 1;
		u32 bbmErrCount: 31;
	} bbmErr;
	u8 reserved1[84];
};

struct MR_PD_LIST {
	__le32 size;
	__le32 count;
	struct MR_PD_ADDRESS addr[1];
};

struct MR_PRIV_DEVICE {
	bool is_tm_capable;
	bool tm_busy;
	atomic_t sdev_priv_busy;
	atomic_t r1_ldio_hint;
	u8 interface_type;
	u8 task_abort_tmo;
	u8 target_reset_tmo;
};

struct MR_SNAPDUMP_PROPERTIES {
	u8 offload_num;
	u8 max_num_supported;
	u8 cur_num_supported;
	u8 trigger_min_num_sec_before_ocr;
	u8 reserved[12];
};

struct MR_TARGET_PROPERTIES {
	u32 max_io_size_kb;
	u32 device_qdepth;
	u32 sector_size;
	u8 reset_tmo;
	u8 reserved[499];
};

struct MR_TM_REQUEST {
	char request[128];
};

struct MR_TM_REPLY {
	char reply[128];
};

struct MR_TASK_MANAGE_REQUEST {
	struct MR_TM_REQUEST TmRequest;
	union {
		struct {
			u32 isTMForLD: 1;
			u32 isTMForPD: 1;
			u32 reserved1: 30;
			u32 reserved2;
		} tmReqFlags;
		struct MR_TM_REPLY TMReply;
	};
};

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

struct sk_buff;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct u64_stats_sync {
	seqcount_t seq;
};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
	long: 32;
	long: 32;
	long: 32;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct lock_class_key {};

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 32;
	long: 32;
	long: 32;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long int privdata[0];
};

struct Qdisc_class_common {
	u32 classid;
	unsigned int filter_cnt;
	struct hlist_node hnode;
};

struct hlist_head;

struct Qdisc_class_hash {
	struct hlist_head *hash;
	unsigned int hashsize;
	unsigned int hashmask;
	unsigned int hashelems;
};

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
};

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
};

struct kref {
	refcount_t refcount;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
};

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
	struct rw_semaphore update_nr_hwq_lock;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct timerqueue_node {
	struct rb_node node;
	long: 32;
	ktime_t expires;
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
	long: 32;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct wake_irq;

struct pm_subsys_data;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	bool should_wakeup: 1;
	long: 32;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	long: 32;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
	long: 32;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct dev_archdata {};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct em_perf_domain;

struct dev_pin_info;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct cma;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct em_perf_domain *em_pd;
	struct dev_pin_info *pins;
	struct dev_msi_info msi;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct cma *cma_area;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_coherent: 1;
	bool dma_skip_sync: 1;
	long: 32;
};

struct scsi_host_template;

struct scsi_transport_template;

struct workqueue_struct;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	long unsigned int last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	long: 32;
	u64 max_lun;
	unsigned int unique_id;
	short unsigned int max_cmd_len;
	int this_id;
	int can_queue;
	short int cmd_per_lun;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	long unsigned int base;
	long unsigned int io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	long: 32;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	long unsigned int hostdata[0];
	long: 32;
};

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
	long: 32;
};

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_FrameHeader fParams;
	U64 processedCSize;
	U64 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	int isFrameDecompression;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	int disableHufAsm;
	int maxBlockSizeParam;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
};

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef ZSTD_DCtx ZSTD_DStream;

typedef ZSTD_DCtx zstd_dctx;

typedef ZSTD_DStream zstd_dstream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
};

typedef ZSTD_DDict zstd_ddict;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

typedef ZSTD_inBuffer zstd_in_buffer;

typedef ZSTD_outBuffer zstd_out_buffer;

union _MFI_CAPABILITIES {
	struct {
		u32 support_fp_remote_lun: 1;
		u32 support_additional_msix: 1;
		u32 support_fastpath_wb: 1;
		u32 support_max_255lds: 1;
		u32 support_ndrive_r1_lb: 1;
		u32 support_core_affinity: 1;
		u32 security_protocol_cmds_fw: 1;
		u32 support_ext_queue_depth: 1;
		u32 support_ext_io_size: 1;
		u32 support_vfid_in_ioframe: 1;
		u32 support_fp_rlbypass: 1;
		u32 support_qd_throttling: 1;
		u32 support_pd_map_target_id: 1;
		u32 support_64bit_mode: 1;
		u32 support_nvme_passthru: 1;
		u32 support_fw_exposed_dev_list: 1;
		u32 support_memdump: 1;
		u32 reserved: 15;
	} mfi_capabilities;
	__le32 reg;
};

typedef union _MFI_CAPABILITIES MFI_CAPABILITIES;

struct __aio_sigset {
	const sigset_t *sigmask;
	size_t sigsetsize;
};

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	};
};

typedef void (*smp_call_func_t)(void *);

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
};

typedef struct __call_single_data call_single_data_t;

struct idr;

struct __class_idr {
	struct idr *idr;
	int id;
};

typedef struct __class_idr class_idr_alloc_t;

struct __extcon_info {
	unsigned int type;
	unsigned int id;
	const char *name;
};

struct __fat_dirent {
	long int d_ino;
	__kernel_off_t d_off;
	short unsigned int d_reclen;
	char d_name[256];
};

struct __fb_timings {
	u32 dclk;
	u32 hfreq;
	u32 vfreq;
	u32 hactive;
	u32 vactive;
	u32 hblank;
	u32 vblank;
	u32 htotal;
	u32 vtotal;
};

struct genradix_root;

struct __genradix {
	struct genradix_root *root;
};

struct pmu;

struct cgroup;

struct __group_key {
	int cpu;
	struct pmu *pmu;
	struct cgroup *cgroup;
};

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long int tv_nsec;
};

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
};

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
};

struct __kernel_old_itimerval {
	struct __kernel_old_timeval it_interval;
	struct __kernel_old_timeval it_value;
};

struct __kernel_old_timespec {
	__kernel_old_time_t tv_sec;
	long int tv_nsec;
};

struct __kernel_sock_timeval {
	__s64 tv_sec;
	__s64 tv_usec;
};

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		};
		void *__align;
	};
};

struct __kernel_timex_timeval {
	__kernel_time64_t tv_sec;
	long long int tv_usec;
};

struct __kernel_timex {
	unsigned int modes;
	long: 32;
	long long int offset;
	long long int freq;
	long long int maxerror;
	long long int esterror;
	int status;
	long: 32;
	long long int constant;
	long long int precision;
	long long int tolerance;
	struct __kernel_timex_timeval time;
	long long int tick;
	long long int ppsfreq;
	long long int jitter;
	int shift;
	long: 32;
	long long int stabil;
	long long int jitcnt;
	long long int calcnt;
	long long int errcnt;
	long long int stbcnt;
	int tai;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
};

struct __large_struct {
	long unsigned int buf[100];
};

union sigval {
	int sival_int;
	void *sival_ptr;
};

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} _sigchld;
	struct {
		void *_addr;
		union {
			int _trapno;
			short int _addr_lsb;
			struct {
				char _dummy_bnd[4];
				void *_lower;
				void *_upper;
			} _addr_bnd;
			struct {
				char _dummy_pkey[4];
				__u32 _pkey;
			} _addr_pkey;
			struct {
				long unsigned int _data;
				__u32 _type;
				__u32 _flags;
			} _perf;
		};
	} _sigfault;
	struct {
		long int _band;
		int _fd;
	} _sigpoll;
	struct {
		void *_call_addr;
		int _syscall;
		unsigned int _arch;
	} _sigsys;
};

struct bpf_flow_keys;

struct bpf_sock;

struct __sk_buff {
	__u32 len;
	__u32 pkt_type;
	__u32 mark;
	__u32 queue_mapping;
	__u32 protocol;
	__u32 vlan_present;
	__u32 vlan_tci;
	__u32 vlan_proto;
	__u32 priority;
	__u32 ingress_ifindex;
	__u32 ifindex;
	__u32 tc_index;
	__u32 cb[5];
	__u32 hash;
	__u32 tc_classid;
	__u32 data;
	__u32 data_end;
	__u32 napi_id;
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 data_meta;
	union {
		struct bpf_flow_keys *flow_keys;
	};
	__u64 tstamp;
	__u32 wire_len;
	__u32 gso_segs;
	union {
		struct bpf_sock *sk;
	};
	__u32 gso_size;
	__u8 tstamp_type;
	__u64 hwtstamp;
};

struct dentry;

struct __track_dentry_update_args {
	struct dentry *dentry;
	int op;
};

struct __track_range_args {
	ext4_lblk_t start;
	ext4_lblk_t end;
};

struct __una_u32 {
	u32 x;
};

struct inode;

struct __uprobe_key {
	struct inode *inode;
	long: 32;
	loff_t offset;
};

struct __user_cap_data_struct {
	__u32 effective;
	__u32 permitted;
	__u32 inheritable;
};

typedef struct __user_cap_data_struct *cap_user_data_t;

struct __user_cap_header_struct {
	__u32 version;
	int pid;
};

typedef struct __user_cap_header_struct *cap_user_header_t;

struct net_device;

struct _bpf_dtab_netdev {
	struct net_device *dev;
};

struct _flow_keys_digest_data {
	__be16 n_proto;
	u8 ip_proto;
	u8 padding;
	__be32 ports;
	__be32 src;
	__be32 dst;
};

struct _gpt_entry_attributes {
	u64 required_to_function: 1;
	u64 reserved: 47;
	u64 type_guid_specific: 16;
};

typedef struct _gpt_entry_attributes gpt_entry_attributes;

struct _gpt_entry {
	efi_guid_t partition_type_guid;
	efi_guid_t unique_partition_guid;
	__le64 starting_lba;
	__le64 ending_lba;
	gpt_entry_attributes attributes;
	__le16 partition_name[36];
};

typedef struct _gpt_entry gpt_entry;

struct _gpt_header {
	__le64 signature;
	__le32 revision;
	__le32 header_size;
	__le32 header_crc32;
	__le32 reserved1;
	__le64 my_lba;
	__le64 alternate_lba;
	__le64 first_usable_lba;
	__le64 last_usable_lba;
	efi_guid_t disk_guid;
	__le64 partition_entry_lba;
	__le32 num_partition_entries;
	__le32 sizeof_partition_entry;
	__le32 partition_entry_array_crc32;
};

typedef struct _gpt_header gpt_header;

struct _gpt_mbr_record {
	u8 boot_indicator;
	u8 start_head;
	u8 start_sector;
	u8 start_track;
	u8 os_type;
	u8 end_head;
	u8 end_sector;
	u8 end_track;
	__le32 starting_lba;
	__le32 size_in_lba;
};

typedef struct _gpt_mbr_record gpt_mbr_record;

struct _ieee754_csr {
	unsigned int rm: 2;
	unsigned int sx: 5;
	unsigned int mx: 5;
	unsigned int cx: 6;
	unsigned int nan2008: 1;
	unsigned int abs2008: 1;
	unsigned int pad0: 3;
	unsigned int c: 1;
	unsigned int nod: 1;
	unsigned int fcc: 7;
};

struct _legacy_mbr {
	u8 boot_code[440];
	__le32 unique_mbr_signature;
	__le16 unknown;
	gpt_mbr_record partition_record[4];
	__le16 signature;
} __attribute__((packed));

typedef struct _legacy_mbr legacy_mbr;

struct strp_msg {
	int full_len;
	int offset;
};

struct _strp_msg {
	struct strp_msg strp;
	int accum_len;
};

struct a4tech_sc {
	long unsigned int quirks;
	unsigned int hw_wheel;
	__s32 delayed_value;
};

struct acct_v3 {
	char ac_flag;
	char ac_version;
	__u16 ac_tty;
	__u32 ac_exitcode;
	__u32 ac_uid;
	__u32 ac_gid;
	__u32 ac_pid;
	__u32 ac_ppid;
	__u32 ac_btime;
	__u32 ac_etime;
	comp_t ac_utime;
	comp_t ac_stime;
	comp_t ac_mem;
	comp_t ac_io;
	comp_t ac_rw;
	comp_t ac_minflt;
	comp_t ac_majflt;
	comp_t ac_swaps;
	char ac_comm[16];
};

typedef struct acct_v3 acct_t;

struct ack_sample {
	u32 pkts_acked;
	s32 rtt_us;
	u32 in_flight;
};

struct crypto_tfm;

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
};

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	unsigned int cra_reqsize;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
	} cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct comp_alg_common {
	struct crypto_alg base;
};

struct acomp_req;

struct crypto_acomp;

struct acomp_alg {
	int (*compress)(struct acomp_req *);
	int (*decompress)(struct acomp_req *);
	int (*init)(struct crypto_acomp *);
	void (*exit)(struct crypto_acomp *);
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	union {
		struct {
			struct crypto_alg base;
		};
		struct comp_alg_common calg;
	};
};

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
};

struct scatterlist {
	long unsigned int page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
};

struct acomp_req_chain {
	crypto_completion_t compl;
	void *data;
	struct scatterlist ssg;
	struct scatterlist dsg;
	union {
		const u8 *src;
		struct folio *sfolio;
	};
	union {
		u8 *dst;
		struct folio *dfolio;
	};
	u32 flags;
};

struct acomp_req {
	struct crypto_async_request base;
	union {
		struct scatterlist *src;
		const u8 *svirt;
	};
	union {
		struct scatterlist *dst;
		u8 *dvirt;
	};
	unsigned int slen;
	unsigned int dlen;
	struct acomp_req_chain chain;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	void *__ctx[0];
};

union crypto_no_such_thing;

struct scatter_walk {
	union {
		void * const addr;
		union crypto_no_such_thing *__addr;
	};
	struct scatterlist *sg;
	unsigned int offset;
};

struct acomp_walk {
	union {
		struct {
			struct {
				const void * const addr;
			} virt;
		} src;
		struct scatter_walk in;
	};
	union {
		struct {
			struct {
				void * const addr;
			} virt;
		} dst;
		struct scatter_walk out;
	};
	unsigned int slen;
	unsigned int dlen;
	int flags;
};

struct acpi_device_id {
	__u8 id[16];
	kernel_ulong_t driver_data;
	__u32 cls;
	__u32 cls_msk;
};

struct acpi_gpio_params;

struct acpi_gpio_mapping {
	const char *name;
	const struct acpi_gpio_params *data;
	unsigned int size;
	unsigned int quirks;
};

struct acpi_gpio_params {
	unsigned int crs_entry_index;
	short unsigned int line_index;
	bool active_low;
};

struct action_cache {};

struct action_devres {
	void *data;
	void (*action)(void *);
};

struct action_gate_entry {
	u8 gate_state;
	u32 interval;
	s32 ipv;
	s32 maxoctets;
};

struct action_ops {
	int (*pre_action)(struct snd_pcm_substream *, snd_pcm_state_t);
	int (*do_action)(struct snd_pcm_substream *, snd_pcm_state_t);
	void (*undo_action)(struct snd_pcm_substream *, snd_pcm_state_t);
	void (*post_action)(struct snd_pcm_substream *, snd_pcm_state_t);
};

struct xarray {
	spinlock_t xa_lock;
	gfp_t xa_flags;
	void *xa_head;
};

struct rb_root {
	struct rb_node *rb_node;
};

struct rb_root_cached {
	struct rb_root rb_root;
	struct rb_node *rb_leftmost;
};

struct address_space_operations;

struct address_space {
	struct inode *host;
	struct xarray i_pages;
	struct rw_semaphore invalidate_lock;
	gfp_t gfp_mask;
	atomic_t i_mmap_writable;
	struct rb_root_cached i_mmap;
	long unsigned int nrpages;
	long unsigned int writeback_index;
	const struct address_space_operations *a_ops;
	long unsigned int flags;
	errseq_t wb_err;
	spinlock_t i_private_lock;
	struct list_head i_private_list;
	struct rw_semaphore i_mmap_rwsem;
	void *i_private_data;
};

struct file;

struct writeback_control;

struct readahead_control;

struct kiocb;

struct iov_iter;

struct swap_info_struct;

struct address_space_operations {
	int (*read_folio)(struct file *, struct folio *);
	int (*writepages)(struct address_space *, struct writeback_control *);
	bool (*dirty_folio)(struct address_space *, struct folio *);
	void (*readahead)(struct readahead_control *);
	int (*write_begin)(struct file *, struct address_space *, loff_t, unsigned int, struct folio **, void **);
	int (*write_end)(struct file *, struct address_space *, loff_t, unsigned int, unsigned int, struct folio *, void *);
	sector_t (*bmap)(struct address_space *, sector_t);
	void (*invalidate_folio)(struct folio *, size_t, size_t);
	bool (*release_folio)(struct folio *, gfp_t);
	void (*free_folio)(struct folio *);
	ssize_t (*direct_IO)(struct kiocb *, struct iov_iter *);
	int (*migrate_folio)(struct address_space *, struct folio *, struct folio *, enum migrate_mode);
	int (*launder_folio)(struct folio *);
	bool (*is_partially_uptodate)(struct folio *, size_t, size_t);
	void (*is_dirty_writeback)(struct folio *, bool *, bool *);
	int (*error_remove_folio)(struct address_space *, struct folio *);
	int (*swap_activate)(struct swap_info_struct *, struct file *, sector_t *);
	void (*swap_deactivate)(struct file *);
	int (*swap_rw)(struct kiocb *, struct iov_iter *);
};

struct advisor_ctx {
	ktime_t start_scan;
	long unsigned int scan_time;
	long unsigned int change;
	long long unsigned int cpu_time;
};

struct crypto_aead;

struct aead_request;

struct aead_alg {
	int (*setkey)(struct crypto_aead *, const u8 *, unsigned int);
	int (*setauthsize)(struct crypto_aead *, unsigned int);
	int (*encrypt)(struct aead_request *);
	int (*decrypt)(struct aead_request *);
	int (*init)(struct crypto_aead *);
	void (*exit)(struct crypto_aead *);
	unsigned int ivsize;
	unsigned int maxauthsize;
	unsigned int chunksize;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct crypto_alg base;
};

struct aead_geniv_ctx {
	spinlock_t lock;
	struct crypto_aead *child;
	u8 salt[0];
};

struct crypto_template;

struct crypto_spawn;

struct crypto_instance {
	struct crypto_alg alg;
	struct crypto_template *tmpl;
	union {
		struct hlist_node list;
		struct crypto_spawn *spawns;
	};
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	void *__ctx[0];
};

struct aead_instance {
	void (*free)(struct aead_instance *);
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	union {
		struct {
			char head[128];
			struct crypto_instance base;
		} s;
		struct aead_alg alg;
	};
};

struct aead_request {
	struct crypto_async_request base;
	unsigned int assoclen;
	unsigned int cryptlen;
	u8 *iv;
	struct scatterlist *src;
	struct scatterlist *dst;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	void *__ctx[0];
};

struct pcie_tlp_log {
	union {
		u32 dw[14];
		struct {
			u32 _do_not_use[4];
			u32 prefix[4];
		};
	};
	u8 header_len;
	bool flit;
};

struct aer_capability_regs {
	u32 header;
	u32 uncor_status;
	u32 uncor_mask;
	u32 uncor_severity;
	u32 cor_status;
	u32 cor_mask;
	u32 cap_control;
	struct pcie_tlp_log header_log;
	u32 root_command;
	u32 root_status;
	u16 cor_err_source;
	u16 uncor_err_source;
};

struct pci_dev;

struct aer_err_info {
	struct pci_dev *dev[5];
	int ratelimit_print[5];
	int error_dev_num;
	const char *level;
	unsigned int id: 16;
	unsigned int severity: 2;
	unsigned int root_ratelimit_print: 1;
	unsigned int __pad1: 4;
	unsigned int multi_error_valid: 1;
	unsigned int first_error: 5;
	unsigned int __pad2: 2;
	unsigned int tlp_header_valid: 1;
	unsigned int status;
	unsigned int mask;
	struct pcie_tlp_log tlp;
};

struct aer_err_source {
	u32 status;
	u32 id;
};

struct ratelimit_state {
	raw_spinlock_t lock;
	int interval;
	int burst;
	atomic_t rs_n_left;
	atomic_t missed;
	unsigned int flags;
	long unsigned int begin;
};

struct aer_info {
	u64 dev_cor_errs[16];
	u64 dev_fatal_errs[27];
	u64 dev_nonfatal_errs[27];
	u64 dev_total_cor_errs;
	u64 dev_total_fatal_errs;
	u64 dev_total_nonfatal_errs;
	u64 rootport_total_cor_errs;
	u64 rootport_total_fatal_errs;
	u64 rootport_total_nonfatal_errs;
	struct ratelimit_state correctable_ratelimit;
	struct ratelimit_state nonfatal_ratelimit;
};

struct aer_rpc {
	struct pci_dev *rpd;
	struct {
		union {
			struct __kfifo kfifo;
			struct aer_err_source *type;
			const struct aer_err_source *const_type;
			char (*rectype)[0];
			struct aer_err_source *ptr;
			const struct aer_err_source *ptr_const;
		};
		struct aer_err_source buf[128];
	} aer_fifo;
};

struct cpumask;

struct affinity_context {
	const struct cpumask *new_mask;
	struct cpumask *user_mask;
	unsigned int flags;
};

struct aggregate_control {
	long int *aggregate;
	long int *local;
	long int *pending;
	long int *ppending;
	long int *cstat;
	long int *cstat_prev;
	int size;
};

struct component_master_ops;

struct component_match;

struct aggregate_device {
	struct list_head node;
	bool bound;
	const struct component_master_ops *ops;
	struct device *parent;
	struct component_match *match;
};

struct hash_alg_common {
	unsigned int digestsize;
	unsigned int statesize;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct crypto_alg base;
};

struct ahash_request;

struct crypto_ahash;

struct ahash_alg {
	int (*init)(struct ahash_request *);
	int (*update)(struct ahash_request *);
	int (*final)(struct ahash_request *);
	int (*finup)(struct ahash_request *);
	int (*digest)(struct ahash_request *);
	int (*export)(struct ahash_request *, void *);
	int (*import)(struct ahash_request *, const void *);
	int (*export_core)(struct ahash_request *, void *);
	int (*import_core)(struct ahash_request *, const void *);
	int (*setkey)(struct crypto_ahash *, const u8 *, unsigned int);
	int (*init_tfm)(struct crypto_ahash *);
	void (*exit_tfm)(struct crypto_ahash *);
	int (*clone_tfm)(struct crypto_ahash *, struct crypto_ahash *);
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct hash_alg_common halg;
};

struct ahash_hmac_ctx {
	struct crypto_ahash *hash;
	u8 pads[0];
};

struct ahash_instance {
	void (*free)(struct ahash_instance *);
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	union {
		struct {
			char head[256];
			struct crypto_instance base;
		} s;
		struct ahash_alg alg;
	};
};

struct ahash_request {
	struct crypto_async_request base;
	unsigned int nbytes;
	union {
		struct scatterlist *src;
		const u8 *svirt;
	};
	u8 *result;
	struct scatterlist sg_head[2];
	crypto_completion_t saved_complete;
	void *saved_data;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	void *__ctx[0];
};

struct ahci_cmd_hdr {
	__le32 opts;
	__le32 status;
	__le32 tbl_addr;
	__le32 tbl_addr_hi;
	__le32 reserved[4];
};

struct timer_list {
	struct hlist_node entry;
	long unsigned int expires;
	void (*function)(struct timer_list *);
	u32 flags;
};

struct ata_link;

struct ahci_em_priv {
	enum sw_activity blink_policy;
	struct timer_list timer;
	long unsigned int saved_activity;
	long unsigned int activity;
	long unsigned int led_state;
	struct ata_link *link;
};

struct clk_bulk_data;

struct reset_control;

struct regulator;

struct phy;

struct ata_port;

struct ata_host;

struct ahci_host_priv {
	unsigned int flags;
	u32 mask_port_map;
	void *mmio;
	u32 cap;
	u32 cap2;
	u32 version;
	u32 port_map;
	u32 saved_cap;
	u32 saved_cap2;
	u32 saved_port_map;
	u32 saved_port_cap[32];
	u32 em_loc;
	u32 em_buf_sz;
	u32 em_msg_type;
	u32 remapped_nvme;
	bool got_runtime_pm;
	unsigned int n_clks;
	struct clk_bulk_data *clks;
	unsigned int f_rsts;
	struct reset_control *rsts;
	struct regulator **target_pwrs;
	struct regulator *ahci_regulator;
	struct regulator *phy_regulator;
	struct phy **phys;
	unsigned int nports;
	void *plat_data;
	unsigned int irq;
	void (*start_engine)(struct ata_port *);
	int (*stop_engine)(struct ata_port *);
	irqreturn_t (*irq_handler)(int, void *);
	int (*get_irq_vector)(struct ata_host *, int);
};

struct ahci_port_priv {
	struct ata_link *active_link;
	struct ahci_cmd_hdr *cmd_slot;
	dma_addr_t cmd_slot_dma;
	void *cmd_tbl;
	dma_addr_t cmd_tbl_dma;
	void *rx_fis;
	dma_addr_t rx_fis_dma;
	unsigned int ncq_saw_d2h: 1;
	unsigned int ncq_saw_dmas: 1;
	unsigned int ncq_saw_sdb: 1;
	spinlock_t lock;
	u32 intr_mask;
	bool fbs_supported;
	bool fbs_enabled;
	int fbs_last_dev;
	struct ahci_em_priv em_priv[15];
	char *irq_desc;
};

struct ahci_sg {
	__le32 addr;
	__le32 addr_hi;
	__le32 reserved;
	__le32 flags_size;
};

struct wait_page_queue;

struct kiocb {
	struct file *ki_filp;
	long: 32;
	loff_t ki_pos;
	void (*ki_complete)(struct kiocb *, long int);
	void *private;
	int ki_flags;
	u16 ki_ioprio;
	u8 ki_write_stream;
	union {
		struct wait_page_queue *ki_waitq;
		ssize_t (*dio_complete)(void *);
	};
	long: 32;
};

struct cred;

struct fsync_iocb {
	struct file *file;
	struct work_struct work;
	bool datasync;
	struct cred *creds;
};

struct wait_queue_entry;

typedef int (*wait_queue_func_t)(struct wait_queue_entry *, unsigned int, int, void *);

struct wait_queue_entry {
	unsigned int flags;
	void *private;
	wait_queue_func_t func;
	struct list_head entry;
};

struct poll_iocb {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	bool cancelled;
	bool work_scheduled;
	bool work_need_resched;
	struct wait_queue_entry wait;
	struct work_struct work;
};

typedef int kiocb_cancel_fn(struct kiocb *);

struct io_event {
	__u64 data;
	__u64 obj;
	__s64 res;
	__s64 res2;
};

struct kioctx;

struct eventfd_ctx;

struct aio_kiocb {
	union {
		struct file *ki_filp;
		struct kiocb rw;
		struct fsync_iocb fsync;
		struct poll_iocb poll;
	};
	struct kioctx *ki_ctx;
	kiocb_cancel_fn *ki_cancel;
	struct io_event ki_res;
	struct list_head ki_list;
	refcount_t ki_refcnt;
	struct eventfd_ctx *ki_eventfd;
};

struct poll_table_struct;

typedef void (*poll_queue_proc)(struct file *, wait_queue_head_t *, struct poll_table_struct *);

struct poll_table_struct {
	poll_queue_proc _qproc;
	__poll_t _key;
};

struct aio_poll_table {
	struct poll_table_struct pt;
	struct aio_kiocb *iocb;
	bool queued;
	int error;
};

struct aio_ring {
	unsigned int id;
	unsigned int nr;
	unsigned int head;
	unsigned int tail;
	unsigned int magic;
	unsigned int compat_features;
	unsigned int incompat_features;
	unsigned int header_length;
	struct io_event io_events[0];
};

struct aio_waiter {
	struct wait_queue_entry w;
	size_t min_nr;
};

struct akcipher_request;

struct crypto_akcipher;

struct akcipher_alg {
	int (*encrypt)(struct akcipher_request *);
	int (*decrypt)(struct akcipher_request *);
	int (*set_pub_key)(struct crypto_akcipher *, const void *, unsigned int);
	int (*set_priv_key)(struct crypto_akcipher *, const void *, unsigned int);
	unsigned int (*max_size)(struct crypto_akcipher *);
	int (*init)(struct crypto_akcipher *);
	void (*exit)(struct crypto_akcipher *);
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct crypto_alg base;
};

struct akcipher_instance {
	void (*free)(struct akcipher_instance *);
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	union {
		struct {
			char head[128];
			struct crypto_instance base;
		} s;
		struct akcipher_alg alg;
	};
};

struct akcipher_request {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int src_len;
	unsigned int dst_len;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	void *__ctx[0];
};

struct alarm {
	struct timerqueue_node node;
	struct hrtimer timer;
	void (*function)(struct alarm *, ktime_t);
	enum alarmtimer_type type;
	int state;
	void *data;
};

struct timerqueue_head {
	struct rb_root_cached rb_root;
};

struct timespec64;

struct alarm_base {
	spinlock_t lock;
	struct timerqueue_head timerqueue;
	ktime_t (*get_ktime)(void);
	void (*get_timespec)(struct timespec64 *);
	clockid_t base_clockid;
};

struct alias_prop {
	struct list_head link;
	const char *alias;
	struct device_node *np;
	int id;
	char stem[0];
};

struct zonelist;

struct zoneref;

struct alloc_context {
	struct zonelist *zonelist;
	nodemask_t *nodemask;
	struct zoneref *preferred_zoneref;
	int migratetype;
	enum zone_type highest_zoneidx;
	bool spread_dirty_pages;
};

struct codetag {
	unsigned int flags;
	unsigned int lineno;
	const char *modname;
	const char *function;
	const char *filename;
	long: 32;
};

struct alloc_tag_counters;

struct alloc_tag {
	struct codetag ct;
	struct alloc_tag_counters *counters;
	long: 32;
};

struct alloc_tag_counters {
	u64 bytes;
	u64 calls;
};

struct alps_bitmap_point {
	int start_bit;
	int num_bits;
};

struct delayed_work {
	struct work_struct work;
	struct timer_list timer;
	struct workqueue_struct *wq;
	int cpu;
};

struct input_mt_pos {
	s16 x;
	s16 y;
};

struct alps_fields {
	unsigned int x_map;
	unsigned int y_map;
	unsigned int fingers;
	int pressure;
	struct input_mt_pos st;
	struct input_mt_pos mt[4];
	unsigned int first_mp: 1;
	unsigned int is_mp: 1;
	unsigned int left: 1;
	unsigned int right: 1;
	unsigned int middle: 1;
	unsigned int ts_left: 1;
	unsigned int ts_right: 1;
	unsigned int ts_middle: 1;
};

struct psmouse;

struct input_dev;

struct alps_nibble_commands;

struct alps_data {
	struct psmouse *psmouse;
	struct input_dev *dev2;
	struct input_dev *dev3;
	char phys2[32];
	char phys3[32];
	struct delayed_work dev3_register_work;
	const struct alps_nibble_commands *nibble_commands;
	int addr_command;
	u16 proto_version;
	u8 byte0;
	u8 mask0;
	u8 dev_id[3];
	u8 fw_ver[3];
	int flags;
	int x_max;
	int y_max;
	int x_bits;
	int y_bits;
	unsigned int x_res;
	unsigned int y_res;
	int (*hw_init)(struct psmouse *);
	void (*process_packet)(struct psmouse *);
	int (*decode_fields)(struct alps_fields *, unsigned char *, struct psmouse *);
	void (*set_abs_params)(struct alps_data *, struct input_dev *);
	int prev_fin;
	int multi_packet;
	int second_touch;
	unsigned char multi_data[6];
	struct alps_fields f;
	u8 quirks;
	struct timer_list timer;
};

struct alps_protocol_info {
	u16 version;
	u8 byte0;
	u8 mask0;
	unsigned int flags;
};

struct alps_model_info {
	u8 signature[3];
	struct alps_protocol_info protocol_info;
};

struct alps_nibble_commands {
	int command;
	unsigned char data;
};

struct amba_cs_uci_id {
	unsigned int devarch;
	unsigned int devarch_mask;
	unsigned int devtype;
	void *data;
};

struct resource {
	resource_size_t start;
	resource_size_t end;
	const char *name;
	long unsigned int flags;
	long unsigned int desc;
	struct resource *parent;
	struct resource *sibling;
	struct resource *child;
};

struct device_dma_parameters {
	unsigned int max_segment_size;
	unsigned int min_align_mask;
	long unsigned int segment_boundary_mask;
};

struct clk;

struct amba_device {
	struct device dev;
	struct resource res;
	struct clk *pclk;
	struct device_dma_parameters dma_parms;
	unsigned int periphid;
	struct mutex periphid_lock;
	unsigned int cid;
	struct amba_cs_uci_id uci;
	unsigned int irq[9];
	const char *driver_override;
};

struct kobj_uevent_env;

struct kobj_ns_type_operations;

struct dev_pm_ops;

struct class {
	const char *name;
	const struct attribute_group **class_groups;
	const struct attribute_group **dev_groups;
	int (*dev_uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *);
	void (*class_release)(const struct class *);
	void (*dev_release)(struct device *);
	int (*shutdown_pre)(struct device *);
	const struct kobj_ns_type_operations *ns_type;
	const void * (*namespace)(const struct device *);
	void (*get_ownership)(const struct device *, kuid_t *, kgid_t *);
	const struct dev_pm_ops *pm;
};

struct transport_container;

struct transport_class {
	struct class class;
	int (*setup)(struct transport_container *, struct device *, struct device *);
	int (*configure)(struct transport_container *, struct device *, struct device *);
	int (*remove)(struct transport_container *, struct device *, struct device *);
};

struct klist_node;

struct klist {
	spinlock_t k_lock;
	struct list_head k_list;
	void (*get)(struct klist_node *);
	void (*put)(struct klist_node *);
};

struct device_attribute;

struct attribute_container {
	struct list_head node;
	struct klist containers;
	struct class *class;
	const struct attribute_group *grp;
	struct device_attribute **attrs;
	int (*match)(struct attribute_container *, struct device *);
	long unsigned int flags;
};

struct anon_transport_class {
	struct transport_class tclass;
	struct attribute_container container;
};

struct anon_vma {
	struct anon_vma *root;
	struct rw_semaphore rwsem;
	atomic_t refcount;
	long unsigned int num_children;
	long unsigned int num_active_vmas;
	struct anon_vma *parent;
	struct rb_root_cached rb_root;
};

struct vm_area_struct;

struct anon_vma_chain {
	struct vm_area_struct *vma;
	struct anon_vma *anon_vma;
	struct list_head same_vma;
	struct rb_node rb;
	long unsigned int rb_subtree_last;
};

struct anon_vma_name {
	struct kref kref;
	char name[0];
};

struct api_context {
	struct completion done;
	int status;
};

struct apple_backlight_config_report {
	u8 report_id;
	u8 version;
	u16 backlight_off;
	u16 backlight_on_min;
	u16 backlight_on_max;
};

struct apple_backlight_set_report {
	u8 report_id;
	u8 version;
	u16 backlight;
	u16 rate;
};

struct apple_key_translation {
	u16 from;
	u16 to;
	u8 flags;
};

struct led_pattern;

struct led_trigger;

struct led_hw_trigger_type;

struct led_classdev {
	const char *name;
	unsigned int brightness;
	unsigned int max_brightness;
	unsigned int color;
	int flags;
	long unsigned int work_flags;
	void (*brightness_set)(struct led_classdev *, enum led_brightness);
	int (*brightness_set_blocking)(struct led_classdev *, enum led_brightness);
	enum led_brightness (*brightness_get)(struct led_classdev *);
	int (*blink_set)(struct led_classdev *, long unsigned int *, long unsigned int *);
	int (*pattern_set)(struct led_classdev *, struct led_pattern *, u32, int);
	int (*pattern_clear)(struct led_classdev *);
	struct device *dev;
	const struct attribute_group **groups;
	struct list_head node;
	const char *default_trigger;
	long unsigned int blink_delay_on;
	long unsigned int blink_delay_off;
	struct timer_list blink_timer;
	int blink_brightness;
	int new_blink_brightness;
	void (*flash_resume)(struct led_classdev *);
	struct workqueue_struct *wq;
	struct work_struct set_brightness_work;
	int delayed_set_value;
	long unsigned int delayed_delay_on;
	long unsigned int delayed_delay_off;
	struct rw_semaphore trigger_lock;
	struct led_trigger *trigger;
	struct list_head trig_list;
	void *trigger_data;
	bool activated;
	struct led_hw_trigger_type *trigger_type;
	const char *hw_control_trigger;
	int (*hw_control_is_supported)(struct led_classdev *, long unsigned int);
	int (*hw_control_set)(struct led_classdev *, long unsigned int);
	int (*hw_control_get)(struct led_classdev *, long unsigned int *);
	struct device * (*hw_control_get_device)(struct led_classdev *);
	struct mutex led_access;
};

struct hid_report;

struct apple_magic_backlight {
	struct led_classdev cdev;
	struct hid_report *brightness;
	struct hid_report *power;
};

struct apple_non_apple_keyboard {
	char *name;
};

struct hid_device;

struct apple_sc_backlight;

struct apple_sc {
	struct hid_device *hdev;
	long unsigned int quirks;
	unsigned int fn_on;
	unsigned int fn_found;
	long unsigned int pressed_numlock[24];
	struct timer_list battery_timer;
	struct apple_sc_backlight *backlight;
};

struct apple_sc_backlight {
	struct led_classdev cdev;
	struct hid_device *hdev;
};

struct workqueue_attrs;

struct pool_workqueue;

struct apply_wqattrs_ctx {
	struct workqueue_struct *wq;
	struct workqueue_attrs *attrs;
	struct list_head list;
	struct pool_workqueue *dfl_pwq;
	struct pool_workqueue *pwq_tbl[0];
};

struct aqr107_hw_stat {
	const char *name;
	int reg;
	int size;
};

struct aqr107_priv {
	u64 sgmii_stats[10];
	long unsigned int leds_active_low;
	long unsigned int leds_active_high;
};

struct arch_elf_state {
	int nan_2008;
	int fp_abi;
	int interp_fp_abi;
	int overall_fp_mode;
};

struct arch_io_reserve_memtype_wc_devres {
	resource_size_t start;
	resource_size_t size;
};

struct arch_msi_msg_addr_hi {
	u32 address_hi;
};

typedef struct arch_msi_msg_addr_hi arch_msi_msg_addr_hi_t;

struct arch_msi_msg_addr_lo {
	u32 address_lo;
};

typedef struct arch_msi_msg_addr_lo arch_msi_msg_addr_lo_t;

struct arch_msi_msg_data {
	u32 data;
};

typedef struct arch_msi_msg_data arch_msi_msg_data_t;

struct arch_specific_insn {
	int dummy;
};

struct arch_uprobe {
	long unsigned int resume_epc;
	u32 insn[2];
	u32 ixol[2];
};

struct arch_uprobe_task {
	long unsigned int saved_trap_nr;
};

struct arch_vdso_time_data {};

struct args_askumount {
	__u32 may_umount;
};

struct args_expire {
	__u32 how;
};

struct args_fail {
	__u32 token;
	__s32 status;
};

struct args_in {
	__u32 type;
};

struct args_out {
	__u32 devid;
	__u32 magic;
};

struct args_ismountpoint {
	union {
		struct args_in in;
		struct args_out out;
	};
};

struct args_openmount {
	__u32 devid;
};

struct args_protosubver {
	__u32 sub_version;
};

struct args_protover {
	__u32 version;
};

struct args_ready {
	__u32 token;
};

struct args_requester {
	__u32 uid;
	__u32 gid;
};

struct args_setpipefd {
	__s32 pipefd;
};

struct args_timeout {
	__u64 timeout;
};

struct arphdr {
	__be16 ar_hrd;
	__be16 ar_pro;
	unsigned char ar_hln;
	unsigned char ar_pln;
	__be16 ar_op;
};

struct sockaddr {
	sa_family_t sa_family;
	union {
		char sa_data_min[14];
		struct {
			struct {} __empty_sa_data;
			char sa_data[0];
		};
	};
};

struct arpreq {
	struct sockaddr arp_pa;
	struct sockaddr arp_ha;
	int arp_flags;
	struct sockaddr arp_netmask;
	char arp_dev[16];
};

struct trace_array;

struct trace_buffer;

struct trace_array_cpu;

struct array_buffer {
	struct trace_array *tr;
	struct trace_buffer *buffer;
	struct trace_array_cpu *data;
	long: 32;
	u64 time_start;
	int cpu;
	long: 32;
};

struct sas_work {
	struct list_head drain_node;
	struct work_struct work;
};

struct asd_sas_phy;

struct asd_sas_event {
	struct sas_work work;
	struct asd_sas_phy *phy;
	int event;
};

struct sas_phy;

struct asd_sas_port;

struct sas_ha_struct;

struct asd_sas_phy {
	atomic_t event_nr;
	int in_shutdown;
	int error;
	int suspended;
	struct sas_phy *phy;
	int enabled;
	int id;
	enum sas_protocol iproto;
	enum sas_protocol tproto;
	enum sas_phy_role role;
	enum sas_oob_mode oob_mode;
	enum sas_linkrate linkrate;
	u8 *sas_addr;
	u8 attached_sas_addr[8];
	spinlock_t frame_rcvd_lock;
	u8 *frame_rcvd;
	int frame_rcvd_size;
	spinlock_t sas_prim_lock;
	u32 sas_prim;
	struct list_head port_phy_el;
	struct asd_sas_port *port;
	struct sas_ha_struct *ha;
	void *lldd_phy;
};

struct sas_discovery_event {
	struct sas_work work;
	struct asd_sas_port *port;
};

struct sas_discovery {
	struct sas_discovery_event disc_work[4];
	long unsigned int pending;
	u8 fanout_sas_addr[8];
	u8 eeds_a[8];
	u8 eeds_b[8];
	int max_level;
};

struct domain_device;

struct sas_port;

struct asd_sas_port {
	struct sas_discovery disc;
	struct domain_device *port_dev;
	spinlock_t dev_list_lock;
	struct list_head dev_list;
	struct list_head disco_list;
	struct list_head destroy_list;
	struct list_head sas_port_del_list;
	enum sas_linkrate linkrate;
	struct sas_work work;
	int suspended;
	int id;
	u8 sas_addr[8];
	u8 attached_sas_addr[8];
	enum sas_protocol iproto;
	enum sas_protocol tproto;
	enum sas_oob_mode oob_mode;
	spinlock_t phy_list_lock;
	struct list_head phy_list;
	int num_phys;
	u32 phy_mask;
	struct sas_ha_struct *ha;
	struct sas_port *port;
	void *lldd_port;
};

typedef int (*asn1_action_t)(void *, size_t, unsigned char, const void *, size_t);

struct asn1_decoder {
	const unsigned char *machine;
	size_t machlen;
	const asn1_action_t *actions;
};

struct assoc_array_ptr;

struct assoc_array {
	struct assoc_array_ptr *root;
	long unsigned int nr_leaves_on_tree;
};

struct assoc_array_node;

struct assoc_array_delete_collapse_context {
	struct assoc_array_node *node;
	const void *skip_leaf;
	int slot;
};

struct assoc_array_ops;

struct assoc_array_edit {
	struct callback_head rcu;
	struct assoc_array *array;
	const struct assoc_array_ops *ops;
	const struct assoc_array_ops *ops_for_excised_subtree;
	struct assoc_array_ptr *leaf;
	struct assoc_array_ptr **leaf_p;
	struct assoc_array_ptr *dead_leaf;
	struct assoc_array_ptr *new_meta[3];
	struct assoc_array_ptr *excised_meta[1];
	struct assoc_array_ptr *excised_subtree;
	struct assoc_array_ptr **set_backpointers[16];
	struct assoc_array_ptr *set_backpointers_to;
	struct assoc_array_node *adjust_count_on;
	long int adjust_count_by;
	struct {
		struct assoc_array_ptr **ptr;
		struct assoc_array_ptr *to;
	} set[2];
	struct {
		u8 *p;
		u8 to;
	} set_parent_slot[1];
	u8 segment_cache[17];
};

struct assoc_array_node {
	struct assoc_array_ptr *back_pointer;
	u8 parent_slot;
	struct assoc_array_ptr *slots[16];
	long unsigned int nr_leaves_on_branch;
};

struct assoc_array_ops {
	long unsigned int (*get_key_chunk)(const void *, int);
	long unsigned int (*get_object_key_chunk)(const void *, int);
	bool (*compare_object)(const void *, const void *);
	int (*diff_objects)(const void *, const void *);
	void (*free_object)(void *);
};

struct assoc_array_shortcut {
	struct assoc_array_ptr *back_pointer;
	int parent_slot;
	int skip_to_level;
	struct assoc_array_ptr *next_node;
	long unsigned int index_key[0];
};

struct assoc_array_walk_result {
	struct {
		struct assoc_array_node *node;
		int level;
		int slot;
	} terminal_node;
	struct {
		struct assoc_array_shortcut *shortcut;
		int level;
		int sc_level;
		long unsigned int sc_segments;
		long unsigned int dissimilarity;
	} wrong_shortcut;
};

struct asym_cap_data {
	struct list_head link;
	struct callback_head rcu;
	long unsigned int capacity;
	long unsigned int cpus[0];
};

struct asymmetric_key_id {
	short unsigned int len;
	unsigned char data[0];
};

struct asymmetric_key_ids {
	void *id[3];
};

struct key_preparsed_payload;

struct asymmetric_key_parser {
	struct list_head link;
	struct module *owner;
	const char *name;
	int (*parse)(struct key_preparsed_payload *);
};

struct key;

struct seq_file;

struct kernel_pkey_params;

struct kernel_pkey_query;

struct public_key_signature;

struct asymmetric_key_subtype {
	struct module *owner;
	const char *name;
	short unsigned int name_len;
	void (*describe)(const struct key *, struct seq_file *);
	void (*destroy)(void *, void *);
	int (*query)(const struct kernel_pkey_params *, struct kernel_pkey_query *);
	int (*eds_op)(struct kernel_pkey_params *, const void *, void *);
	int (*verify_signature)(const struct key *, const struct public_key_signature *);
};

struct usb_dev_state;

struct pid;

struct urb;

struct usb_memory;

struct async {
	struct list_head asynclist;
	struct usb_dev_state *ps;
	struct pid *pid;
	const struct cred *cred;
	unsigned int signr;
	unsigned int ifnum;
	void *userbuffer;
	void *userurb;
	sigval_t userurb_sigval;
	struct urb *urb;
	struct usb_memory *usbm;
	unsigned int mem_usage;
	int status;
	u8 bulk_addr;
	u8 bulk_status;
};

struct async_domain {
	struct list_head pending;
	unsigned int registered: 1;
};

typedef void (*async_func_t)(void *, async_cookie_t);

struct async_entry {
	struct list_head domain_list;
	struct list_head global_list;
	struct work_struct work;
	async_cookie_t cookie;
	async_func_t func;
	void *data;
	struct async_domain *domain;
	long: 32;
};

struct io_poll {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	int retries;
	struct wait_queue_entry wait;
};

struct async_poll {
	struct io_poll poll;
	struct io_poll *double_poll;
};

struct async_scan_data {
	struct list_head list;
	struct Scsi_Host *shost;
	struct completion prev_finished;
};

struct at803x_context {
	u16 bmcr;
	u16 advertise;
	u16 control1000;
	u16 int_enable;
	u16 smart_speed;
	u16 led_control;
};

struct regulator_dev;

struct at803x_priv {
	int flags;
	u16 clk_25m_reg;
	u16 clk_25m_mask;
	u8 smarteee_lpi_tw_1g;
	u8 smarteee_lpi_tw_100m;
	bool is_fiber;
	bool is_1000basex;
	struct regulator_dev *vddio_rdev;
	struct regulator_dev *vddh_rdev;
};

struct at803x_ss_mask {
	u16 speed_mask;
	u8 speed_shift;
};

struct ata_bmdma_prd {
	__le32 addr;
	__le32 flags_len;
};

struct ata_cdl {
	u8 desc_log_buf[512];
	u8 ncq_sense_log_buf[1024];
};

struct ata_cpr {
	u8 num;
	u8 num_storage_elements;
	long: 32;
	u64 start_lba;
	u64 num_lbas;
};

struct ata_cpr_log {
	u8 nr_cpr;
	long: 32;
	struct ata_cpr cpr[0];
};

struct ata_dev_quirks_entry {
	const char *model_num;
	const char *model_rev;
	unsigned int quirks;
};

struct ata_ering_entry {
	unsigned int eflags;
	unsigned int err_mask;
	u64 timestamp;
};

struct ata_ering {
	int cursor;
	long: 32;
	struct ata_ering_entry ring[32];
};

struct scsi_device;

struct ata_device {
	struct ata_link *link;
	unsigned int devno;
	unsigned int quirks;
	long unsigned int flags;
	struct scsi_device *sdev;
	void *private_data;
	struct device tdev;
	u64 n_sectors;
	u64 n_native_sectors;
	unsigned int class;
	long unsigned int unpark_deadline;
	u8 pio_mode;
	u8 dma_mode;
	u8 xfer_mode;
	unsigned int xfer_shift;
	unsigned int multi_count;
	unsigned int max_sectors;
	unsigned int cdb_len;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	u16 cylinders;
	u16 heads;
	u16 sectors;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	union {
		u16 id[256];
		u32 gscr[128];
	};
	u8 devslp_timing[8];
	u8 ncq_send_recv_cmds[20];
	u8 ncq_non_data_cmds[64];
	u32 zac_zoned_cap;
	u32 zac_zones_optimal_open;
	u32 zac_zones_optimal_nonseq;
	u32 zac_zones_max_open;
	struct ata_cpr_log *cpr_log;
	struct ata_cdl *cdl;
	int spdn_cnt;
	struct ata_ering ering;
	u8 sector_buf[512];
};

struct ata_eh_cmd_timeout_ent {
	const u8 *commands;
	const unsigned int *timeouts;
};

struct ata_eh_info {
	struct ata_device *dev;
	u32 serror;
	unsigned int err_mask;
	unsigned int action;
	unsigned int dev_action[2];
	unsigned int flags;
	unsigned int probe_mask;
	char desc[80];
	int desc_len;
};

struct ata_eh_context {
	struct ata_eh_info i;
	int tries[2];
	int cmd_timeout_idx[16];
	unsigned int classes[2];
	unsigned int did_probe_mask;
	unsigned int unloaded_mask;
	unsigned int saved_ncq_enabled;
	u8 saved_xfer_mode[2];
	long unsigned int last_reset;
};

struct ata_force_param {
	const char *name;
	u8 cbl;
	u8 spd_limit;
	unsigned int xfer_mask;
	unsigned int quirk_on;
	unsigned int quirk_off;
	unsigned int pflags_on;
	u16 lflags_on;
	u16 lflags_off;
};

struct ata_force_ent {
	int port;
	int device;
	struct ata_force_param param;
};

struct ata_port_operations;

struct ata_host {
	spinlock_t lock;
	struct device *dev;
	void * const *iomap;
	unsigned int n_ports;
	unsigned int n_tags;
	void *private_data;
	struct ata_port_operations *ops;
	long unsigned int flags;
	struct kref kref;
	struct mutex eh_mutex;
	struct task_struct *eh_owner;
	struct ata_port *simplex_claimed;
	struct ata_port *ports[0];
};

struct transport_container {
	struct attribute_container ac;
	const struct attribute_group *statistics;
};

struct scsi_transport_template {
	struct transport_container host_attrs;
	struct transport_container target_attrs;
	struct transport_container device_attrs;
	int (*user_scan)(struct Scsi_Host *, uint, uint, u64);
	int device_size;
	int device_private_offset;
	int target_size;
	int target_private_offset;
	int host_size;
	unsigned int create_work_queue: 1;
	void (*eh_strategy_handler)(struct Scsi_Host *);
};

struct attribute {
	const char *name;
	umode_t mode;
};

struct device_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device *, struct device_attribute *, char *);
	ssize_t (*store)(struct device *, struct device_attribute *, const char *, size_t);
};

struct ata_internal {
	struct scsi_transport_template t;
	struct device_attribute private_port_attrs[3];
	struct device_attribute private_link_attrs[3];
	struct device_attribute private_dev_attrs[9];
	struct transport_container link_attr_cont;
	struct transport_container dev_attr_cont;
	struct device_attribute *link_attrs[4];
	struct device_attribute *port_attrs[4];
	struct device_attribute *dev_attrs[10];
};

struct ata_ioports {
	void *cmd_addr;
	void *data_addr;
	void *error_addr;
	void *feature_addr;
	void *nsect_addr;
	void *lbal_addr;
	void *lbam_addr;
	void *lbah_addr;
	void *device_addr;
	void *status_addr;
	void *command_addr;
	void *altstatus_addr;
	void *ctl_addr;
	void *bmdma_addr;
	void *scr_addr;
};

struct ata_link {
	struct ata_port *ap;
	int pmp;
	struct device tdev;
	unsigned int active_tag;
	u32 sactive;
	unsigned int flags;
	u32 saved_scontrol;
	unsigned int hw_sata_spd_limit;
	unsigned int sata_spd_limit;
	unsigned int sata_spd;
	enum ata_lpm_policy lpm_policy;
	struct ata_eh_info eh_info;
	struct ata_eh_context eh_context;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct ata_device device[2];
	long unsigned int last_lpm_change;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct ata_taskfile {
	long unsigned int flags;
	u8 protocol;
	u8 ctl;
	u8 hob_feature;
	u8 hob_nsect;
	u8 hob_lbal;
	u8 hob_lbam;
	u8 hob_lbah;
	union {
		u8 error;
		u8 feature;
	};
	u8 nsect;
	u8 lbal;
	u8 lbam;
	u8 lbah;
	u8 device;
	union {
		u8 status;
		u8 command;
	};
	u32 auxiliary;
};

struct ata_queued_cmd;

typedef void (*ata_qc_cb_t)(struct ata_queued_cmd *);

struct scsi_cmnd;

struct ata_queued_cmd {
	struct ata_port *ap;
	struct ata_device *dev;
	struct scsi_cmnd *scsicmd;
	void (*scsidone)(struct scsi_cmnd *);
	struct ata_taskfile tf;
	u8 cdb[16];
	long unsigned int flags;
	unsigned int tag;
	unsigned int hw_tag;
	unsigned int n_elem;
	unsigned int orig_n_elem;
	int dma_dir;
	unsigned int sect_size;
	unsigned int nbytes;
	unsigned int extrabytes;
	unsigned int curbytes;
	struct scatterlist sgent;
	struct scatterlist *sg;
	struct scatterlist *cursg;
	unsigned int cursg_ofs;
	unsigned int err_mask;
	struct ata_taskfile result_tf;
	ata_qc_cb_t complete_fn;
	void *private_data;
	void *lldd_task;
};

struct ata_port_stats {
	long unsigned int unhandled_irq;
	long unsigned int idle_irq;
	long unsigned int rw_reqbuf;
};

struct ata_port {
	struct Scsi_Host *scsi_host;
	struct ata_port_operations *ops;
	spinlock_t *lock;
	long unsigned int flags;
	unsigned int pflags;
	unsigned int print_id;
	unsigned int port_no;
	struct ata_ioports ioaddr;
	u8 ctl;
	u8 last_ctl;
	struct ata_link *sff_pio_task_link;
	struct delayed_work sff_pio_task;
	struct ata_bmdma_prd *bmdma_prd;
	dma_addr_t bmdma_prd_dma;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	unsigned int cbl;
	struct ata_queued_cmd qcmd[33];
	u64 qc_active;
	int nr_active_links;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct ata_link link;
	struct ata_link *slave_link;
	int nr_pmp_links;
	struct ata_link *pmp_link;
	struct ata_link *excl_link;
	struct ata_port_stats stats;
	struct ata_host *host;
	struct device *dev;
	long: 32;
	struct device tdev;
	struct mutex scsi_scan_mutex;
	struct delayed_work hotplug_task;
	struct delayed_work scsi_rescan_task;
	unsigned int hsm_task_state;
	struct list_head eh_done_q;
	wait_queue_head_t eh_wait_q;
	int eh_tries;
	struct completion park_req_pending;
	pm_message_t pm_mesg;
	enum ata_lpm_policy target_lpm_policy;
	struct timer_list fastdrain_timer;
	unsigned int fastdrain_cnt;
	long: 32;
	async_cookie_t cookie;
	int em_message_type;
	void *private_data;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct ata_port_info {
	long unsigned int flags;
	long unsigned int link_flags;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	struct ata_port_operations *port_ops;
	void *private_data;
};

typedef int (*ata_prereset_fn_t)(struct ata_link *, long unsigned int);

typedef int (*ata_reset_fn_t)(struct ata_link *, unsigned int *, long unsigned int);

typedef void (*ata_postreset_fn_t)(struct ata_link *, unsigned int *);

struct ata_port_operations {
	int (*qc_defer)(struct ata_queued_cmd *);
	int (*check_atapi_dma)(struct ata_queued_cmd *);
	enum ata_completion_errors (*qc_prep)(struct ata_queued_cmd *);
	unsigned int (*qc_issue)(struct ata_queued_cmd *);
	void (*qc_fill_rtf)(struct ata_queued_cmd *);
	void (*qc_ncq_fill_rtf)(struct ata_port *, u64);
	int (*cable_detect)(struct ata_port *);
	unsigned int (*mode_filter)(struct ata_device *, unsigned int);
	void (*set_piomode)(struct ata_port *, struct ata_device *);
	void (*set_dmamode)(struct ata_port *, struct ata_device *);
	int (*set_mode)(struct ata_link *, struct ata_device **);
	unsigned int (*read_id)(struct ata_device *, struct ata_taskfile *, __le16 *);
	void (*dev_config)(struct ata_device *);
	void (*freeze)(struct ata_port *);
	void (*thaw)(struct ata_port *);
	ata_prereset_fn_t prereset;
	ata_reset_fn_t softreset;
	ata_reset_fn_t hardreset;
	ata_postreset_fn_t postreset;
	ata_prereset_fn_t pmp_prereset;
	ata_reset_fn_t pmp_softreset;
	ata_reset_fn_t pmp_hardreset;
	ata_postreset_fn_t pmp_postreset;
	void (*error_handler)(struct ata_port *);
	void (*lost_interrupt)(struct ata_port *);
	void (*post_internal_cmd)(struct ata_queued_cmd *);
	void (*sched_eh)(struct ata_port *);
	void (*end_eh)(struct ata_port *);
	int (*scr_read)(struct ata_link *, unsigned int, u32 *);
	int (*scr_write)(struct ata_link *, unsigned int, u32);
	void (*pmp_attach)(struct ata_port *);
	void (*pmp_detach)(struct ata_port *);
	int (*set_lpm)(struct ata_link *, enum ata_lpm_policy, unsigned int);
	int (*port_suspend)(struct ata_port *, pm_message_t);
	int (*port_resume)(struct ata_port *);
	int (*port_start)(struct ata_port *);
	void (*port_stop)(struct ata_port *);
	void (*host_stop)(struct ata_host *);
	void (*sff_dev_select)(struct ata_port *, unsigned int);
	void (*sff_set_devctl)(struct ata_port *, u8);
	u8 (*sff_check_status)(struct ata_port *);
	u8 (*sff_check_altstatus)(struct ata_port *);
	void (*sff_tf_load)(struct ata_port *, const struct ata_taskfile *);
	void (*sff_tf_read)(struct ata_port *, struct ata_taskfile *);
	void (*sff_exec_command)(struct ata_port *, const struct ata_taskfile *);
	unsigned int (*sff_data_xfer)(struct ata_queued_cmd *, unsigned char *, unsigned int, int);
	void (*sff_irq_on)(struct ata_port *);
	bool (*sff_irq_check)(struct ata_port *);
	void (*sff_irq_clear)(struct ata_port *);
	void (*sff_drain_fifo)(struct ata_queued_cmd *);
	void (*bmdma_setup)(struct ata_queued_cmd *);
	void (*bmdma_start)(struct ata_queued_cmd *);
	void (*bmdma_stop)(struct ata_queued_cmd *);
	u8 (*bmdma_status)(struct ata_port *);
	ssize_t (*em_show)(struct ata_port *, char *);
	ssize_t (*em_store)(struct ata_port *, const char *, size_t);
	ssize_t (*sw_activity_show)(struct ata_device *, char *);
	ssize_t (*sw_activity_store)(struct ata_device *, enum sw_activity);
	ssize_t (*transmit_led_message)(struct ata_port *, u32, ssize_t);
	const struct ata_port_operations *inherits;
};

struct ata_show_ering_arg {
	char *buf;
	int written;
};

struct ata_task_resp {
	u16 frame_len;
	u8 ending_fis[24];
};

struct ata_xfer_ent {
	int shift;
	int bits;
	u8 base;
};

struct ps2dev;

typedef enum ps2_disposition (*ps2_pre_receive_handler_t)(struct ps2dev *, u8, unsigned int);

typedef void (*ps2_receive_handler_t)(struct ps2dev *, u8);

struct serio;

struct ps2dev {
	struct serio *serio;
	struct mutex cmd_mutex;
	wait_queue_head_t wait;
	long unsigned int flags;
	u8 cmdbuf[8];
	u8 cmdcnt;
	u8 nak;
	ps2_pre_receive_handler_t pre_receive_handler;
	ps2_receive_handler_t receive_handler;
};

struct vivaldi_data {
	u32 function_row_physmap[24];
	unsigned int num_function_row_keys;
};

struct atkbd {
	struct ps2dev ps2dev;
	struct input_dev *dev;
	char name[64];
	char phys[32];
	short unsigned int id;
	short unsigned int keycode[512];
	long unsigned int force_release_mask[16];
	unsigned char set;
	bool translated;
	bool extra;
	bool write;
	bool softrepeat;
	bool softraw;
	bool scroll;
	bool enabled;
	unsigned char emul;
	bool resend;
	bool release;
	long unsigned int xl_bit;
	unsigned int last;
	long unsigned int time;
	long unsigned int err_count;
	struct delayed_work event_work;
	long unsigned int event_jiffies;
	long unsigned int event_mask;
	struct mutex mutex;
	struct vivaldi_data vdata;
};

struct notifier_block;

struct atomic_notifier_head {
	spinlock_t lock;
	struct notifier_block *head;
};

struct bin_attribute;

struct attribute_group {
	const char *name;
	umode_t (*is_visible)(struct kobject *, struct attribute *, int);
	umode_t (*is_bin_visible)(struct kobject *, const struct bin_attribute *, int);
	size_t (*bin_size)(struct kobject *, const struct bin_attribute *, int);
	struct attribute **attrs;
	union {
		const struct bin_attribute * const *bin_attrs;
		const struct bin_attribute * const *bin_attrs_new;
	};
};

struct audit_context;

struct audit_buffer {
	struct sk_buff *skb;
	struct audit_context *ctx;
	gfp_t gfp_mask;
};

struct audit_cap_data {
	kernel_cap_t permitted;
	kernel_cap_t inheritable;
	union {
		unsigned int fE;
		kernel_cap_t effective;
	};
	kernel_cap_t ambient;
	kuid_t rootid;
	long: 32;
};

struct timespec64 {
	time64_t tv_sec;
	long int tv_nsec;
	long: 32;
};

struct lsm_prop_selinux {};

struct lsm_prop_smack {};

struct lsm_prop_apparmor {};

struct lsm_prop_bpf {};

struct lsm_prop {
	struct lsm_prop_selinux selinux;
	struct lsm_prop_smack smack;
	struct lsm_prop_apparmor apparmor;
	struct lsm_prop_bpf bpf;
};

struct filename;

struct audit_names {
	struct list_head list;
	struct filename *name;
	int name_len;
	bool hidden;
	long unsigned int ino;
	dev_t dev;
	umode_t mode;
	kuid_t uid;
	kgid_t gid;
	dev_t rdev;
	struct lsm_prop oprop;
	long: 32;
	struct audit_cap_data fcap;
	unsigned int fcap_ver;
	unsigned char type;
	bool should_free;
};

struct vfsmount;

struct path {
	struct vfsmount *mnt;
	struct dentry *dentry;
};

struct audit_aux_data;

struct audit_tree_refs;

struct mq_attr {
	__kernel_long_t mq_flags;
	__kernel_long_t mq_maxmsg;
	__kernel_long_t mq_msgsize;
	__kernel_long_t mq_curmsgs;
	__kernel_long_t __reserved[4];
};

struct open_how {
	__u64 flags;
	__u64 mode;
	__u64 resolve;
};

struct audit_ntp_data {};

struct audit_proctitle {
	int len;
	char *value;
};

struct audit_context {
	int dummy;
	enum {
		AUDIT_CTX_UNUSED = 0,
		AUDIT_CTX_SYSCALL = 1,
		AUDIT_CTX_URING = 2,
	} context;
	enum audit_state state;
	enum audit_state current_state;
	unsigned int serial;
	int major;
	int uring_op;
	long: 32;
	struct timespec64 ctime;
	long unsigned int argv[4];
	long int return_code;
	long: 32;
	u64 prio;
	int return_valid;
	long: 32;
	struct audit_names preallocated_names[5];
	int name_count;
	struct list_head names_list;
	char *filterkey;
	struct path pwd;
	struct audit_aux_data *aux;
	struct audit_aux_data *aux_pids;
	struct __kernel_sockaddr_storage *sockaddr;
	size_t sockaddr_len;
	pid_t ppid;
	kuid_t uid;
	kuid_t euid;
	kuid_t suid;
	kuid_t fsuid;
	kgid_t gid;
	kgid_t egid;
	kgid_t sgid;
	kgid_t fsgid;
	long unsigned int personality;
	int arch;
	pid_t target_pid;
	kuid_t target_auid;
	kuid_t target_uid;
	unsigned int target_sessionid;
	struct lsm_prop target_ref;
	char target_comm[16];
	struct audit_tree_refs *trees;
	struct audit_tree_refs *first_trees;
	struct list_head killed_trees;
	int tree_count;
	int type;
	long: 32;
	union {
		struct {
			int nargs;
			long int args[6];
		} socketcall;
		struct {
			kuid_t uid;
			kgid_t gid;
			umode_t mode;
			struct lsm_prop oprop;
			int has_perm;
			uid_t perm_uid;
			gid_t perm_gid;
			umode_t perm_mode;
			long unsigned int qbytes;
		} ipc;
		struct {
			mqd_t mqdes;
			struct mq_attr mqstat;
		} mq_getsetattr;
		struct {
			mqd_t mqdes;
			int sigev_signo;
		} mq_notify;
		struct {
			mqd_t mqdes;
			size_t msg_len;
			unsigned int msg_prio;
			long: 32;
			struct timespec64 abs_timeout;
		} mq_sendrecv;
		struct {
			int oflag;
			umode_t mode;
			struct mq_attr attr;
		} mq_open;
		struct {
			pid_t pid;
			long: 32;
			struct audit_cap_data cap;
		} capset;
		struct {
			int fd;
			int flags;
		} mmap;
		struct open_how openat2;
		struct {
			int argc;
		} execve;
		struct {
			char *name;
		} module;
		struct {
			struct audit_ntp_data ntp_data;
			struct timespec64 tk_injoffset;
		} time;
	};
	int fds[2];
	struct audit_proctitle proctitle;
};

struct audit_ctl_mutex {
	struct mutex lock;
	void *owner;
};

struct audit_watch;

struct audit_tree;

struct audit_fsnotify_mark;

struct audit_field;

struct audit_krule {
	u32 pflags;
	u32 flags;
	u32 listnr;
	u32 action;
	u32 mask[64];
	u32 buflen;
	u32 field_count;
	char *filterkey;
	struct audit_field *fields;
	struct audit_field *arch_f;
	struct audit_field *inode_f;
	struct audit_watch *watch;
	struct audit_tree *tree;
	struct audit_fsnotify_mark *exe;
	struct list_head rlist;
	struct list_head list;
	long: 32;
	u64 prio;
};

struct audit_entry {
	struct list_head list;
	struct callback_head rcu;
	struct audit_krule rule;
};

struct audit_features {
	__u32 vers;
	__u32 mask;
	__u32 features;
	__u32 lock;
};

struct audit_field {
	u32 type;
	union {
		u32 val;
		kuid_t uid;
		kgid_t gid;
		struct {
			char *lsm_str;
			void *lsm_rule;
		};
	};
	u32 op;
};

struct sock;

struct audit_net {
	struct sock *sk;
};

struct audit_netlink_list {
	__u32 portid;
	struct net *net;
	struct sk_buff_head q;
};

struct audit_reply {
	__u32 portid;
	struct net *net;
	struct sk_buff *skb;
};

struct audit_rule_data {
	__u32 flags;
	__u32 action;
	__u32 field_count;
	__u32 mask[64];
	__u32 fields[64];
	__u32 values[64];
	__u32 fieldflags[64];
	__u32 buflen;
	char buf[0];
};

struct audit_sig_info {
	uid_t uid;
	pid_t pid;
	char ctx[0];
};

struct audit_status {
	__u32 mask;
	__u32 enabled;
	__u32 failure;
	__u32 pid;
	__u32 rate_limit;
	__u32 backlog_limit;
	__u32 lost;
	__u32 backlog;
	union {
		__u32 version;
		__u32 feature_bitmap;
	};
	__u32 backlog_wait_time;
	__u32 backlog_wait_time_actual;
};

struct audit_tty_status {
	__u32 enabled;
	__u32 log_passwd;
};

struct auditd_connection {
	struct pid *pid;
	u32 portid;
	struct net *net;
	struct callback_head rcu;
};

struct auth_cred {
	const struct cred *cred;
	const char *principal;
};

struct auth_ops;

struct auth_domain {
	struct kref ref;
	struct hlist_node hash;
	char *name;
	struct auth_ops *flavour;
	struct callback_head callback_head;
};

struct svc_rqst;

struct auth_ops {
	char *name;
	struct module *owner;
	int flavour;
	enum svc_auth_status (*accept)(struct svc_rqst *);
	int (*release)(struct svc_rqst *);
	void (*domain_release)(struct auth_domain *);
	enum svc_auth_status (*set_client)(struct svc_rqst *);
	rpc_authflavor_t (*pseudoflavor)(struct svc_rqst *);
};

struct auto_mode_param {
	int qp_type;
};

struct autofs_dev_ioctl {
	__u32 ver_major;
	__u32 ver_minor;
	__u32 size;
	__s32 ioctlfd;
	union {
		struct args_protover protover;
		struct args_protosubver protosubver;
		struct args_openmount openmount;
		struct args_ready ready;
		struct args_fail fail;
		struct args_setpipefd setpipefd;
		struct args_timeout timeout;
		struct args_requester requester;
		struct args_expire expire;
		struct args_askumount askumount;
		struct args_ismountpoint ismountpoint;
	};
	char path[0];
};

struct autofs_fs_context {
	kuid_t uid;
	kgid_t gid;
	int pgrp;
	bool pgrp_set;
};

struct autofs_sb_info;

struct autofs_info {
	struct dentry *dentry;
	int flags;
	struct completion expire_complete;
	struct list_head active;
	struct list_head expiring;
	struct autofs_sb_info *sbi;
	long unsigned int exp_timeout;
	long unsigned int last_used;
	int count;
	kuid_t uid;
	kgid_t gid;
	struct callback_head rcu;
};

struct autofs_packet_hdr {
	int proto_version;
	int type;
};

struct autofs_packet_expire {
	struct autofs_packet_hdr hdr;
	int len;
	char name[256];
};

struct autofs_packet_expire_multi {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	int len;
	char name[256];
};

struct autofs_packet_missing {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	int len;
	char name[256];
};

union autofs_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_packet_missing missing;
	struct autofs_packet_expire expire;
	struct autofs_packet_expire_multi expire_multi;
};

struct super_block;

struct autofs_wait_queue;

struct autofs_sb_info {
	u32 magic;
	int pipefd;
	struct file *pipe;
	struct pid *oz_pgrp;
	int version;
	int sub_version;
	int min_proto;
	int max_proto;
	unsigned int flags;
	long unsigned int exp_timeout;
	unsigned int type;
	struct super_block *sb;
	struct mutex wq_mutex;
	struct mutex pipe_mutex;
	spinlock_t fs_lock;
	struct autofs_wait_queue *queues;
	spinlock_t lookup_lock;
	struct list_head active_list;
	struct list_head expiring_list;
	struct callback_head rcu;
};

struct autofs_v5_packet {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	__u32 dev;
	__u64 ino;
	__u32 uid;
	__u32 gid;
	__u32 pid;
	__u32 tgid;
	__u32 len;
	char name[256];
	long: 32;
};

typedef struct autofs_v5_packet autofs_packet_expire_direct_t;

typedef struct autofs_v5_packet autofs_packet_expire_indirect_t;

typedef struct autofs_v5_packet autofs_packet_missing_direct_t;

typedef struct autofs_v5_packet autofs_packet_missing_indirect_t;

union autofs_v5_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_v5_packet v5_packet;
	autofs_packet_missing_indirect_t missing_indirect;
	autofs_packet_expire_indirect_t expire_indirect;
	autofs_packet_missing_direct_t missing_direct;
	autofs_packet_expire_direct_t expire_direct;
};

struct qstr {
	union {
		struct {
			u32 hash;
			u32 len;
		};
		u64 hash_len;
	};
	const unsigned char *name;
	long: 32;
};

struct autofs_wait_queue {
	wait_queue_head_t queue;
	struct autofs_wait_queue *next;
	autofs_wqt_t wait_queue_token;
	long: 32;
	struct qstr name;
	u32 offset;
	u32 dev;
	u64 ino;
	kuid_t uid;
	kgid_t gid;
	pid_t pid;
	pid_t tgid;
	int status;
	unsigned int wait_ctr;
};

struct task_group;

struct autogroup {
	struct kref kref;
	struct task_group *tg;
	struct rw_semaphore lock;
	long unsigned int id;
	int nice;
};

struct auxiliary_device {
	struct device dev;
	const char *name;
	u32 id;
	struct {
		struct xarray irqs;
		struct mutex lock;
		bool irq_dir_exists;
	} sysfs;
};

struct auxiliary_device_id {
	char name[32];
	kernel_ulong_t driver_data;
};

struct of_device_id;

struct driver_private;

struct device_driver {
	const char *name;
	const struct bus_type *bus;
	struct module *owner;
	const char *mod_name;
	bool suppress_bind_attrs;
	enum probe_type probe_type;
	const struct of_device_id *of_match_table;
	const struct acpi_device_id *acpi_match_table;
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	int (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	const struct dev_pm_ops *pm;
	void (*coredump)(struct device *);
	struct driver_private *p;
};

struct auxiliary_driver {
	int (*probe)(struct auxiliary_device *, const struct auxiliary_device_id *);
	void (*remove)(struct auxiliary_device *);
	void (*shutdown)(struct auxiliary_device *);
	int (*suspend)(struct auxiliary_device *, pm_message_t);
	int (*resume)(struct auxiliary_device *);
	const char *name;
	struct device_driver driver;
	const struct auxiliary_device_id *id_table;
};

struct auxiliary_irq_info {
	struct device_attribute sysfs_attr;
	char name[11];
};

struct regmap;

struct regmap_irq_chip_data;

struct mfd_cell;

struct regmap_config;

struct regmap_irq_chip;

struct axp20x_dev {
	struct device *dev;
	int irq;
	long unsigned int irq_flags;
	struct regmap *regmap;
	struct regmap_irq_chip_data *regmap_irqc;
	enum axp20x_variants variant;
	int nr_cells;
	const struct mfd_cell *cells;
	const struct regmap_config *regmap_cfg;
	const struct regmap_irq_chip *regmap_irq_chip;
};

struct b_format {
	unsigned int func: 6;
	unsigned int code: 20;
	unsigned int opcode: 6;
};

struct backing_aio {
	struct kiocb iocb;
	refcount_t ref;
	struct kiocb *orig_iocb;
	void (*end_write)(struct kiocb *, ssize_t);
	struct work_struct work;
	long int res;
};

struct percpu_counter {
	raw_spinlock_t lock;
	long: 32;
	s64 count;
	s32 *counters;
	long: 32;
};

struct fprop_local_percpu {
	struct percpu_counter events;
	unsigned int period;
	raw_spinlock_t lock;
};

struct percpu_ref_data;

struct percpu_ref {
	long unsigned int percpu_count_ptr;
	struct percpu_ref_data *data;
};

struct backing_dev_info;

struct cgroup_subsys_state;

struct bdi_writeback {
	struct backing_dev_info *bdi;
	long unsigned int state;
	long unsigned int last_old_flush;
	struct list_head b_dirty;
	struct list_head b_io;
	struct list_head b_more_io;
	struct list_head b_dirty_time;
	spinlock_t list_lock;
	atomic_t writeback_inodes;
	long: 32;
	struct percpu_counter stat[4];
	long unsigned int bw_time_stamp;
	long unsigned int dirtied_stamp;
	long unsigned int written_stamp;
	long unsigned int write_bandwidth;
	long unsigned int avg_write_bandwidth;
	long unsigned int dirty_ratelimit;
	long unsigned int balanced_dirty_ratelimit;
	long: 32;
	struct fprop_local_percpu completions;
	int dirty_exceeded;
	enum wb_reason start_all_reason;
	spinlock_t work_lock;
	struct list_head work_list;
	struct delayed_work dwork;
	struct delayed_work bw_dwork;
	struct list_head bdi_node;
	struct percpu_ref refcnt;
	long: 32;
	struct fprop_local_percpu memcg_completions;
	struct cgroup_subsys_state *memcg_css;
	struct cgroup_subsys_state *blkcg_css;
	struct list_head memcg_node;
	struct list_head blkcg_node;
	struct list_head b_attached;
	struct list_head offline_node;
	union {
		struct work_struct release_work;
		struct callback_head rcu;
	};
};

struct backing_dev_info {
	u64 id;
	struct rb_node rb_node;
	struct list_head bdi_list;
	long unsigned int ra_pages;
	long unsigned int io_pages;
	struct kref refcnt;
	unsigned int capabilities;
	unsigned int min_ratio;
	unsigned int max_ratio;
	unsigned int max_prop_frac;
	atomic_long_t tot_write_bandwidth;
	long unsigned int last_bdp_sleep;
	struct bdi_writeback wb;
	struct list_head wb_list;
	struct xarray cgwb_tree;
	struct mutex cgwb_release_mutex;
	struct rw_semaphore wb_switch_rwsem;
	wait_queue_head_t wb_waitq;
	struct device *dev;
	char dev_name[64];
	struct device *owner;
	struct timer_list laptop_mode_wb_timer;
	struct dentry *debug_dir;
	long: 32;
};

struct file_ra_state {
	long unsigned int start;
	unsigned int size;
	unsigned int async_size;
	unsigned int ra_pages;
	unsigned int mmap_miss;
	long: 32;
	loff_t prev_pos;
};

struct file_operations;

struct fown_struct;

struct file {
	spinlock_t f_lock;
	fmode_t f_mode;
	const struct file_operations *f_op;
	struct address_space *f_mapping;
	void *private_data;
	struct inode *f_inode;
	unsigned int f_flags;
	unsigned int f_iocb_flags;
	const struct cred *f_cred;
	struct fown_struct *f_owner;
	struct path f_path;
	union {
		struct mutex f_pos_lock;
		u64 f_pipe;
	};
	loff_t f_pos;
	void *f_security;
	errseq_t f_wb_err;
	errseq_t f_sb_err;
	struct hlist_head *f_ep;
	union {
		struct callback_head f_task_work;
		struct llist_node f_llist;
		struct file_ra_state f_ra;
		freeptr_t f_freeptr;
	};
	file_ref_t f_ref;
	long: 32;
};

struct backing_file {
	struct file file;
	union {
		struct path user_path;
		freeptr_t bf_freeptr;
	};
};

struct backing_file_ctx {
	const struct cred *cred;
	void (*accessed)(struct file *);
	void (*end_write)(struct kiocb *, ssize_t);
};

struct bpf_verifier_env;

struct backtrack_state {
	struct bpf_verifier_env *env;
	u32 frame;
	u32 reg_masks[8];
	u64 stack_masks[8];
};

struct badblocks {
	struct device *dev;
	int count;
	int unacked_exist;
	int shift;
	u64 *page;
	int changed;
	seqlock_t lock;
	sector_t sector;
	sector_t size;
};

struct badblocks_context {
	sector_t start;
	sector_t len;
	int ack;
	long: 32;
};

struct balance_callback {
	struct balance_callback *next;
	void (*func)(struct rq *);
};

struct page;

struct balloon_dev_info {
	long unsigned int isolated_pages;
	spinlock_t pages_lock;
	struct list_head pages;
	int (*migratepage)(struct balloon_dev_info *, struct page *, struct page *, enum migrate_mode);
};

struct batadv_unicast_packet {
	__u8 packet_type;
	__u8 version;
	__u8 ttl;
	__u8 ttvn;
	__u8 dest[6];
};

struct batch_u16 {
	u16 entropy[48];
	local_lock_t lock;
	long unsigned int generation;
	unsigned int position;
};

struct batch_u32 {
	u32 entropy[24];
	local_lock_t lock;
	long unsigned int generation;
	unsigned int position;
};

struct batch_u64 {
	u64 entropy[12];
	local_lock_t lock;
	long unsigned int generation;
	unsigned int position;
};

struct batch_u8 {
	u8 entropy[96];
	local_lock_t lock;
	long unsigned int generation;
	unsigned int position;
};

struct bcache_ops {
	void (*bc_enable)(void);
	void (*bc_disable)(void);
	void (*bc_wback_inv)(long unsigned int, long unsigned int);
	void (*bc_inv)(long unsigned int, long unsigned int);
	void (*bc_prefetch_enable)(void);
	void (*bc_prefetch_disable)(void);
	bool (*bc_prefetch_is_enabled)(void);
};

struct regulator_config;

struct regulator_ops;

struct linear_range;

struct regulator_desc {
	const char *name;
	const char *supply_name;
	const char *of_match;
	bool of_match_full_name;
	const char *regulators_node;
	int (*of_parse_cb)(struct device_node *, const struct regulator_desc *, struct regulator_config *);
	int (*init_cb)(struct regulator_dev *, struct regulator_config *);
	int id;
	unsigned int continuous_voltage_range: 1;
	unsigned int n_voltages;
	unsigned int n_current_limits;
	const struct regulator_ops *ops;
	int irq;
	enum regulator_type type;
	struct module *owner;
	unsigned int min_uV;
	unsigned int uV_step;
	unsigned int linear_min_sel;
	int fixed_uV;
	unsigned int ramp_delay;
	int min_dropout_uV;
	const struct linear_range *linear_ranges;
	const unsigned int *linear_range_selectors_bitfield;
	int n_linear_ranges;
	const unsigned int *volt_table;
	const unsigned int *curr_table;
	unsigned int vsel_range_reg;
	unsigned int vsel_range_mask;
	bool range_applied_by_vsel;
	unsigned int vsel_reg;
	unsigned int vsel_mask;
	unsigned int vsel_step;
	unsigned int csel_reg;
	unsigned int csel_mask;
	unsigned int apply_reg;
	unsigned int apply_bit;
	unsigned int enable_reg;
	unsigned int enable_mask;
	unsigned int enable_val;
	unsigned int disable_val;
	bool enable_is_inverted;
	unsigned int bypass_reg;
	unsigned int bypass_mask;
	unsigned int bypass_val_on;
	unsigned int bypass_val_off;
	unsigned int active_discharge_on;
	unsigned int active_discharge_off;
	unsigned int active_discharge_mask;
	unsigned int active_discharge_reg;
	unsigned int soft_start_reg;
	unsigned int soft_start_mask;
	unsigned int soft_start_val_on;
	unsigned int pull_down_reg;
	unsigned int pull_down_mask;
	unsigned int pull_down_val_on;
	unsigned int ramp_reg;
	unsigned int ramp_mask;
	const unsigned int *ramp_delay_table;
	unsigned int n_ramp_values;
	unsigned int enable_time;
	unsigned int off_on_delay;
	unsigned int poll_enabled_time;
	unsigned int (*of_map_mode)(unsigned int);
};

struct rohm_dvs_config {
	uint64_t level_map;
	unsigned int run_reg;
	unsigned int run_mask;
	unsigned int run_on_mask;
	unsigned int idle_reg;
	unsigned int idle_mask;
	unsigned int idle_on_mask;
	unsigned int suspend_reg;
	unsigned int suspend_mask;
	unsigned int suspend_on_mask;
	unsigned int lpsr_reg;
	unsigned int lpsr_mask;
	unsigned int lpsr_on_mask;
	unsigned int snvs_reg;
	unsigned int snvs_mask;
	unsigned int snvs_on_mask;
	long: 32;
};

struct reg_init {
	unsigned int reg;
	unsigned int mask;
	unsigned int val;
};

struct bd718xx_regulator_data {
	struct regulator_desc desc;
	long: 32;
	const struct rohm_dvs_config dvs;
	const struct reg_init init;
	const struct reg_init *additional_inits;
	int additional_init_amnt;
	long: 32;
};

struct bd9571mwv_reg {
	struct regmap *regmap;
	u8 bkup_mode_cnt_keepon;
	u8 bkup_mode_cnt_saved;
	bool bkup_mode_enabled;
	bool rstbmode_level;
	bool rstbmode_pulse;
};

struct bd_holder_disk {
	struct list_head list;
	struct kobject *holder_dir;
	int refcnt;
};

struct bd_table;

struct bd_list {
	struct bd_table **bd_table_array;
	int num_tabs;
	int max_bdi;
	int eqp_bdi;
	int hwd_bdi;
	int num_bds_table;
};

struct bdc_bd;

struct bd_table {
	struct bdc_bd *start_bd;
	dma_addr_t dma;
};

struct bdc_req;

struct bd_transfer {
	struct bdc_req *req;
	int start_bdi;
	int next_hwd_bdi;
	int num_bds;
};

struct usb_udc;

struct usb_gadget_ops;

struct usb_ep;

struct usb_otg_caps;

struct usb_gadget {
	struct work_struct work;
	struct usb_udc *udc;
	const struct usb_gadget_ops *ops;
	struct usb_ep *ep0;
	struct list_head ep_list;
	enum usb_device_speed speed;
	enum usb_device_speed max_speed;
	enum usb_ssp_rate ssp_rate;
	enum usb_ssp_rate max_ssp_rate;
	enum usb_device_state state;
	const char *name;
	long: 32;
	struct device dev;
	unsigned int isoch_delay;
	unsigned int out_epnum;
	unsigned int in_epnum;
	unsigned int mA;
	struct usb_otg_caps *otg_caps;
	unsigned int sg_supported: 1;
	unsigned int is_otg: 1;
	unsigned int is_a_peripheral: 1;
	unsigned int b_hnp_enable: 1;
	unsigned int a_hnp_support: 1;
	unsigned int a_alt_hnp_support: 1;
	unsigned int hnp_polling_support: 1;
	unsigned int host_request_flag: 1;
	unsigned int quirk_ep_out_aligned_size: 1;
	unsigned int quirk_altset_not_supp: 1;
	unsigned int quirk_stall_not_supp: 1;
	unsigned int quirk_zlp_not_supp: 1;
	unsigned int quirk_avoids_skb_reserve: 1;
	unsigned int is_selfpowered: 1;
	unsigned int deactivated: 1;
	unsigned int connected: 1;
	unsigned int lpm_capable: 1;
	unsigned int wakeup_capable: 1;
	unsigned int wakeup_armed: 1;
	int irq;
	int id_number;
};

struct bdc_scratchpad {
	dma_addr_t sp_dma;
	void *buff;
	u32 size;
};

struct bdc_sr;

struct srr {
	struct bdc_sr *sr_bds;
	u16 eqp_index;
	u16 dqp_index;
	dma_addr_t dma_addr;
};

struct usb_ctrlrequest {
	__u8 bRequestType;
	__u8 bRequest;
	__le16 wValue;
	__le16 wIndex;
	__le16 wLength;
};

struct usb_request {
	void *buf;
	unsigned int length;
	dma_addr_t dma;
	struct scatterlist *sg;
	unsigned int num_sgs;
	unsigned int num_mapped_sgs;
	unsigned int stream_id: 16;
	unsigned int is_last: 1;
	unsigned int no_interrupt: 1;
	unsigned int zero: 1;
	unsigned int short_not_ok: 1;
	unsigned int dma_mapped: 1;
	unsigned int sg_was_mapped: 1;
	void (*complete)(struct usb_ep *, struct usb_request *);
	void *context;
	struct list_head list;
	unsigned int frame_number;
	int status;
	unsigned int actual;
};

struct bdc_ep;

struct bdc_req {
	struct usb_request usb_req;
	struct list_head queue;
	struct bdc_ep *ep;
	struct bd_transfer bd_xfr;
	int epnum;
};

struct usb_gadget_driver;

struct dma_pool;

struct bdc {
	struct usb_gadget gadget;
	struct usb_gadget_driver *gadget_driver;
	struct device *dev;
	spinlock_t lock;
	struct phy **phys;
	int num_phys;
	unsigned int num_eps;
	struct bdc_ep **bdc_ep_array;
	void *regs;
	struct bdc_scratchpad scratchpad;
	u32 sp_buff_size;
	struct srr srr;
	struct usb_ctrlrequest setup_pkt;
	struct bdc_req ep0_req;
	struct bdc_req status_req;
	enum bdc_ep0_state ep0_state;
	bool delayed_status;
	bool zlp_needed;
	bool reinit;
	bool pullup;
	u32 devstatus;
	int irq;
	void *mem;
	u32 dev_addr;
	struct dma_pool *bd_table_pool;
	u8 test_mode;
	void (*sr_handler[2])(struct bdc *, struct bdc_sr *);
	void (*sr_xsf_ep0[3])(struct bdc *, struct bdc_sr *);
	unsigned char ep0_response_buff[6];
	struct delayed_work func_wake_notify;
	struct clk *clk;
};

struct bdc_bd {
	__le32 offset[4];
};

struct usb_ep_caps {
	unsigned int type_control: 1;
	unsigned int type_iso: 1;
	unsigned int type_bulk: 1;
	unsigned int type_int: 1;
	unsigned int dir_in: 1;
	unsigned int dir_out: 1;
};

struct usb_ep_ops;

struct usb_endpoint_descriptor;

struct usb_ss_ep_comp_descriptor;

struct usb_ep {
	void *driver_data;
	const char *name;
	const struct usb_ep_ops *ops;
	const struct usb_endpoint_descriptor *desc;
	const struct usb_ss_ep_comp_descriptor *comp_desc;
	struct list_head ep_list;
	struct usb_ep_caps caps;
	bool claimed;
	bool enabled;
	unsigned int mult: 2;
	unsigned int maxburst: 5;
	u8 address;
	u16 maxpacket;
	u16 maxpacket_limit;
	u16 max_streams;
};

struct bdc_ep {
	struct usb_ep usb_ep;
	struct list_head queue;
	struct bdc *bdc;
	u8 ep_type;
	u8 dir;
	u8 ep_num;
	const struct usb_ss_ep_comp_descriptor *comp_desc;
	const struct usb_endpoint_descriptor *desc;
	unsigned int flags;
	char name[20];
	struct bd_list bd_list;
	bool ignore_next_sr;
};

struct bdc_sr {
	__le32 offset[4];
};

struct gendisk;

struct request_queue;

struct disk_stats;

struct blk_holder_ops;

struct partition_meta_info;

struct block_device {
	sector_t bd_start_sect;
	sector_t bd_nr_sectors;
	struct gendisk *bd_disk;
	struct request_queue *bd_queue;
	struct disk_stats *bd_stats;
	long unsigned int bd_stamp;
	atomic_t __bd_flags;
	dev_t bd_dev;
	struct address_space *bd_mapping;
	atomic_t bd_openers;
	spinlock_t bd_size_lock;
	void *bd_claiming;
	void *bd_holder;
	const struct blk_holder_ops *bd_holder_ops;
	struct mutex bd_holder_lock;
	int bd_holders;
	struct kobject *bd_holder_dir;
	atomic_t bd_fsfreeze_count;
	struct mutex bd_fsfreeze_mutex;
	struct partition_meta_info *bd_meta_info;
	int bd_writers;
	void *bd_security;
	struct device bd_device;
};

struct hlist_head {
	struct hlist_node *first;
};

struct posix_acl;

struct inode_operations;

struct file_lock_context;

struct pipe_inode_info;

struct cdev;

struct fsnotify_mark_connector;

struct inode {
	umode_t i_mode;
	short unsigned int i_opflags;
	kuid_t i_uid;
	kgid_t i_gid;
	unsigned int i_flags;
	struct posix_acl *i_acl;
	struct posix_acl *i_default_acl;
	const struct inode_operations *i_op;
	struct super_block *i_sb;
	struct address_space *i_mapping;
	void *i_security;
	long unsigned int i_ino;
	union {
		const unsigned int i_nlink;
		unsigned int __i_nlink;
	};
	dev_t i_rdev;
	long: 32;
	loff_t i_size;
	time64_t i_atime_sec;
	time64_t i_mtime_sec;
	time64_t i_ctime_sec;
	u32 i_atime_nsec;
	u32 i_mtime_nsec;
	u32 i_ctime_nsec;
	u32 i_generation;
	spinlock_t i_lock;
	short unsigned int i_bytes;
	u8 i_blkbits;
	enum rw_hint i_write_hint;
	blkcnt_t i_blocks;
	seqcount_t i_size_seqcount;
	u32 i_state;
	struct rw_semaphore i_rwsem;
	long unsigned int dirtied_when;
	long unsigned int dirtied_time_when;
	struct hlist_node i_hash;
	struct list_head i_io_list;
	struct bdi_writeback *i_wb;
	int i_wb_frn_winner;
	u16 i_wb_frn_avg_time;
	u16 i_wb_frn_history;
	struct list_head i_lru;
	struct list_head i_sb_list;
	struct list_head i_wb_list;
	union {
		struct hlist_head i_dentry;
		struct callback_head i_rcu;
	};
	atomic64_t i_version;
	atomic64_t i_sequence;
	atomic_t i_count;
	atomic_t i_dio_count;
	atomic_t i_writecount;
	atomic_t i_readcount;
	union {
		const struct file_operations *i_fop;
		void (*free_inode)(struct inode *);
	};
	struct file_lock_context *i_flctx;
	struct address_space i_data;
	union {
		struct list_head i_devices;
		int i_linklen;
	};
	union {
		struct pipe_inode_info *i_pipe;
		struct cdev *i_cdev;
		char *i_link;
		unsigned int i_dir_seq;
	};
	__u32 i_fsnotify_mask;
	struct fsnotify_mark_connector *i_fsnotify_marks;
	void *i_private;
	long: 32;
};

struct bdev_inode {
	struct block_device bdev;
	struct inode vfs_inode;
};

struct bfq_sched_data;

struct bfq_queue;

struct bfq_entity {
	struct rb_node rb_node;
	bool on_st_or_in_serv;
	u64 start;
	u64 finish;
	struct rb_root *tree;
	long: 32;
	u64 min_start;
	int service;
	int budget;
	int allocated;
	int dev_weight;
	int weight;
	int new_weight;
	int orig_weight;
	struct bfq_entity *parent;
	struct bfq_sched_data *my_sched_data;
	struct bfq_sched_data *sched_data;
	int prio_changed;
	bool in_groups_with_pending_reqs;
	struct bfq_queue *last_bfqq_created;
	long: 32;
};

struct bfq_ttime {
	u64 last_end_request;
	u64 ttime_total;
	long unsigned int ttime_samples;
	long: 32;
	u64 ttime_mean;
};

struct bfq_data;

struct request;

struct bfq_weight_counter;

struct bfq_io_cq;

struct bfq_queue {
	int ref;
	int stable_ref;
	struct bfq_data *bfqd;
	short unsigned int ioprio;
	short unsigned int ioprio_class;
	short unsigned int new_ioprio;
	short unsigned int new_ioprio_class;
	long: 32;
	u64 last_serv_time_ns;
	unsigned int inject_limit;
	long unsigned int decrease_time_jif;
	struct bfq_queue *new_bfqq;
	struct rb_node pos_node;
	struct rb_root *pos_root;
	struct rb_root sort_list;
	struct request *next_rq;
	int queued[2];
	int meta_pending;
	struct list_head fifo;
	struct bfq_entity entity;
	struct bfq_weight_counter *weight_counter;
	int max_budget;
	long unsigned int budget_timeout;
	int dispatched;
	long unsigned int flags;
	struct list_head bfqq_list;
	long: 32;
	struct bfq_ttime ttime;
	u64 io_start_time;
	u64 tot_idle_time;
	u32 seek_history;
	struct hlist_node burst_list_node;
	long: 32;
	sector_t last_request_pos;
	unsigned int requests_within_timer;
	pid_t pid;
	struct bfq_io_cq *bic;
	long unsigned int wr_cur_max_time;
	long unsigned int soft_rt_next_start;
	long unsigned int last_wr_start_finish;
	unsigned int wr_coeff;
	long unsigned int last_idle_bklogged;
	long unsigned int service_from_backlogged;
	long unsigned int service_from_wr;
	long unsigned int wr_start_at_switch_to_srt;
	long unsigned int split_time;
	long unsigned int first_IO_time;
	long unsigned int creation_time;
	struct bfq_queue *waker_bfqq;
	struct bfq_queue *tentative_waker_bfqq;
	unsigned int num_waker_detections;
	long: 32;
	u64 waker_detection_started;
	struct hlist_node woken_list_node;
	struct hlist_head woken_list;
	unsigned int actuator_idx;
};

struct blk_independent_access_range {
	struct kobject kobj;
	long: 32;
	sector_t sector;
	sector_t nr_sectors;
};

struct bfq_group;

struct bfq_data {
	struct request_queue *queue;
	struct list_head dispatch;
	struct bfq_group *root_group;
	struct rb_root_cached queue_weights_tree;
	unsigned int num_groups_with_pending_reqs;
	unsigned int busy_queues[3];
	int wr_busy_queues;
	int queued;
	int tot_rq_in_driver;
	int rq_in_driver[8];
	bool nonrot_with_queueing;
	int max_rq_in_driver;
	int hw_tag_samples;
	int hw_tag;
	int budgets_assigned;
	struct hrtimer idle_slice_timer;
	struct bfq_queue *in_service_queue;
	long: 32;
	sector_t last_position;
	sector_t in_serv_last_pos;
	u64 last_completion;
	struct bfq_queue *last_completed_rq_bfqq;
	struct bfq_queue *last_bfqq_created;
	u64 last_empty_occupied_ns;
	bool wait_dispatch;
	struct request *waited_rq;
	bool rqs_injected;
	long: 32;
	u64 first_dispatch;
	u64 last_dispatch;
	ktime_t last_budget_start;
	ktime_t last_idling_start;
	long unsigned int last_idling_start_jiffies;
	int peak_rate_samples;
	u32 sequential_samples;
	long: 32;
	u64 tot_sectors_dispatched;
	u32 last_rq_max_size;
	long: 32;
	u64 delta_from_first;
	u32 peak_rate;
	int bfq_max_budget;
	struct list_head active_list[8];
	struct list_head idle_list;
	u64 bfq_fifo_expire[2];
	unsigned int bfq_back_penalty;
	unsigned int bfq_back_max;
	u32 bfq_slice_idle;
	int bfq_user_max_budget;
	unsigned int bfq_timeout;
	bool strict_guarantees;
	long unsigned int last_ins_in_burst;
	long unsigned int bfq_burst_interval;
	int burst_size;
	struct bfq_entity *burst_parent_entity;
	long unsigned int bfq_large_burst_thresh;
	bool large_burst;
	struct hlist_head burst_list;
	bool low_latency;
	unsigned int bfq_wr_coeff;
	unsigned int bfq_wr_rt_max_time;
	unsigned int bfq_wr_min_idle_time;
	long unsigned int bfq_wr_min_inter_arr_async;
	unsigned int bfq_wr_max_softrt_rate;
	long: 32;
	u64 rate_dur_prod;
	struct bfq_queue oom_bfqq;
	spinlock_t lock;
	struct bfq_io_cq *bio_bic;
	struct bfq_queue *bio_bfqq;
	unsigned int word_depths[4];
	unsigned int full_depth_shift;
	unsigned int num_actuators;
	long: 32;
	sector_t sector[8];
	sector_t nr_sectors[8];
	struct blk_independent_access_range ia_ranges[8];
	unsigned int actuator_load_threshold;
	long: 32;
};

struct blkcg_gq;

struct blkg_policy_data {
	struct blkcg_gq *blkg;
	int plid;
	bool online;
};

struct bfq_service_tree {
	struct rb_root active;
	struct rb_root idle;
	struct bfq_entity *first_idle;
	struct bfq_entity *last_idle;
	u64 vtime;
	long unsigned int wsum;
	long: 32;
};

struct bfq_sched_data {
	struct bfq_entity *in_service_entity;
	struct bfq_entity *next_in_service;
	struct bfq_service_tree service_tree[3];
	long unsigned int bfq_class_idle_last_service;
	long: 32;
};

struct blkg_rwstat {
	struct percpu_counter cpu_cnt[5];
	atomic64_t aux_cnt[5];
};

struct bfqg_stats {
	struct blkg_rwstat bytes;
	struct blkg_rwstat ios;
};

struct bfq_group {
	struct blkg_policy_data pd;
	refcount_t ref;
	struct bfq_entity entity;
	struct bfq_sched_data sched_data;
	struct bfq_data *bfqd;
	struct bfq_queue *async_bfqq[128];
	struct bfq_queue *async_idle_bfqq[8];
	struct bfq_entity *my_entity;
	int active_entities;
	int num_queues_with_pending_reqs;
	struct rb_root rq_pos_tree;
	long: 32;
	struct bfqg_stats stats;
};

struct blkcg;

struct blkcg_policy_data {
	struct blkcg *blkcg;
	int plid;
};

struct bfq_group_data {
	struct blkcg_policy_data pd;
	unsigned int weight;
};

struct io_context;

struct kmem_cache;

struct io_cq {
	struct request_queue *q;
	struct io_context *ioc;
	union {
		struct list_head q_node;
		struct kmem_cache *__rcu_icq_cache;
	};
	union {
		struct hlist_node ioc_node;
		struct callback_head __rcu_head;
	};
	unsigned int flags;
};

struct bfq_iocq_bfqq_data {
	bool saved_has_short_ttime;
	bool saved_IO_bound;
	long: 32;
	u64 saved_io_start_time;
	u64 saved_tot_idle_time;
	bool saved_in_large_burst;
	bool was_in_burst_list;
	unsigned int saved_weight;
	long unsigned int saved_wr_coeff;
	long unsigned int saved_last_wr_start_finish;
	long unsigned int saved_service_from_wr;
	long unsigned int saved_wr_start_at_switch_to_srt;
	unsigned int saved_wr_cur_max_time;
	long: 32;
	struct bfq_ttime saved_ttime;
	u64 saved_last_serv_time_ns;
	unsigned int saved_inject_limit;
	long unsigned int saved_decrease_time_jif;
	struct bfq_queue *stable_merge_bfqq;
	bool stably_merged;
};

struct bfq_io_cq {
	struct io_cq icq;
	struct bfq_queue *bfqq[16];
	int ioprio;
	uint64_t blkcg_serial_nr;
	struct bfq_iocq_bfqq_data bfqq_data[8];
	unsigned int requests;
	long: 32;
};

struct bfq_weight_counter {
	unsigned int weight;
	unsigned int num_active;
	struct rb_node weights_node;
};

struct bgl_lock {
	spinlock_t lock;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bgpio_pdata {
	const char *label;
	int base;
	int ngpio;
};

struct bh_accounting {
	int nr;
	int ratelimit;
};

struct bh_lru {
	struct buffer_head *bhs[16];
};

struct bictcp {
	u32 cnt;
	u32 last_max_cwnd;
	u32 last_cwnd;
	u32 last_time;
	u32 bic_origin_point;
	u32 bic_K;
	u32 delay_min;
	u32 epoch_start;
	u32 ack_cnt;
	u32 tcp_cwnd;
	u16 unused;
	u8 sample_cnt;
	u8 found;
	u32 round_start;
	u32 end_seq;
	u32 last_ack;
	u32 curr_rtt;
};

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)(void);
	ssize_t (*read)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*read_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	loff_t (*llseek)(struct file *, struct kobject *, const struct bin_attribute *, loff_t, int);
	int (*mmap)(struct file *, struct kobject *, const struct bin_attribute *, struct vm_area_struct *);
};

struct bvec_iter {
	sector_t bi_sector;
	unsigned int bi_size;
	unsigned int bi_idx;
	unsigned int bi_bvec_done;
};

struct bio;

typedef void bio_end_io_t(struct bio *);

struct bio_issue {
	u64 value;
};

struct bio_vec {
	struct page *bv_page;
	unsigned int bv_len;
	unsigned int bv_offset;
};

struct bio_integrity_payload;

struct bio_set;

struct bio {
	struct bio *bi_next;
	struct block_device *bi_bdev;
	blk_opf_t bi_opf;
	short unsigned int bi_flags;
	short unsigned int bi_ioprio;
	enum rw_hint bi_write_hint;
	u8 bi_write_stream;
	blk_status_t bi_status;
	atomic_t __bi_remaining;
	struct bvec_iter bi_iter;
	union {
		blk_qc_t bi_cookie;
		unsigned int __bi_nr_segments;
	};
	bio_end_io_t *bi_end_io;
	void *bi_private;
	struct blkcg_gq *bi_blkg;
	long: 32;
	struct bio_issue bi_issue;
	struct bio_integrity_payload *bi_integrity;
	short unsigned int bi_vcnt;
	short unsigned int bi_max_vecs;
	atomic_t __bi_cnt;
	struct bio_vec *bi_io_vec;
	struct bio_set *bi_pool;
	struct bio_vec bi_inline_vecs[0];
	long: 32;
};

struct bio_alloc_cache {
	struct bio *free_list;
	struct bio *free_list_irq;
	unsigned int nr;
	unsigned int nr_irq;
};

struct blk_crypto_key;

struct bio_crypt_ctx {
	const struct blk_crypto_key *bc_key;
	long: 32;
	u64 bc_dun[4];
};

struct bio_integrity_payload {
	struct bvec_iter bip_iter;
	short unsigned int bip_vcnt;
	short unsigned int bip_max_vcnt;
	short unsigned int bip_flags;
	u16 app_tag;
	struct bio_vec *bip_vec;
};

struct bio_integrity_alloc {
	struct bio_integrity_payload bip;
	struct bio_vec bvecs[0];
};

struct bio_integrity_data {
	struct bio *bio;
	struct bvec_iter saved_bio_iter;
	struct work_struct work;
	struct bio_integrity_payload bip;
	struct bio_vec bvec;
};

struct bio_list {
	struct bio *head;
	struct bio *tail;
};

struct iovec {
	void *iov_base;
	__kernel_size_t iov_len;
};

struct kvec;

struct folio_queue;

struct iov_iter {
	u8 iter_type;
	bool nofault;
	bool data_source;
	size_t iov_offset;
	union {
		struct iovec __ubuf_iovec;
		struct {
			union {
				const struct iovec *__iov;
				const struct kvec *kvec;
				const struct bio_vec *bvec;
				const struct folio_queue *folioq;
				struct xarray *xarray;
				void *ubuf;
			};
			size_t count;
		};
	};
	union {
		long unsigned int nr_segs;
		u8 folioq_slot;
		loff_t xarray_start;
	};
};

struct bio_map_data {
	bool is_our_pages: 1;
	bool is_null_mapped: 1;
	long: 32;
	struct iov_iter iter;
	struct iovec iov[0];
};

struct bio_post_read_ctx {
	struct bio *bio;
	struct work_struct work;
	unsigned int cur_step;
	unsigned int enabled_steps;
};

typedef void *mempool_alloc_t(gfp_t, void *);

typedef void mempool_free_t(void *, void *);

struct mempool_s {
	spinlock_t lock;
	int min_nr;
	int curr_nr;
	void **elements;
	void *pool_data;
	mempool_alloc_t *alloc;
	mempool_free_t *free;
	wait_queue_head_t wait;
};

typedef struct mempool_s mempool_t;

struct bio_set {
	struct kmem_cache *bio_slab;
	unsigned int front_pad;
	struct bio_alloc_cache *cache;
	mempool_t bio_pool;
	mempool_t bvec_pool;
	unsigned int back_pad;
	spinlock_t rescue_lock;
	struct bio_list rescue_list;
	struct work_struct rescue_work;
	struct workqueue_struct *rescue_workqueue;
	struct hlist_node cpuhp_dead;
};

struct bio_slab {
	struct kmem_cache *slab;
	unsigned int slab_ref;
	unsigned int slab_size;
	char name[12];
};

struct biovec_slab {
	int nr_vecs;
	char *name;
	struct kmem_cache *slab;
};

struct bl_dev_msg {
	int32_t status;
	uint32_t major;
	uint32_t minor;
};

struct blacklist_entry {
	struct list_head next;
	char *buf;
};

struct blake2s_state {
	u32 h[8];
	u32 t[2];
	u32 f[2];
	u8 buf[64];
	unsigned int buflen;
	unsigned int outlen;
};

struct blk_crypto_config {
	enum blk_crypto_mode_num crypto_mode;
	unsigned int data_unit_size;
	unsigned int dun_bytes;
	enum blk_crypto_key_type key_type;
};

struct blk_crypto_key {
	struct blk_crypto_config crypto_cfg;
	unsigned int data_unit_size_bits;
	unsigned int size;
	u8 bytes[128];
};

struct blk_expired_data {
	bool has_timedout_rq;
	long unsigned int next;
	long unsigned int timeout_start;
};

struct blk_flush_queue {
	spinlock_t mq_flush_lock;
	unsigned int flush_pending_idx: 1;
	unsigned int flush_running_idx: 1;
	blk_status_t rq_status;
	long unsigned int flush_pending_since;
	struct list_head flush_queue[2];
	long unsigned int flush_data_in_flight;
	struct request *flush_rq;
};

struct blk_holder_ops {
	void (*mark_dead)(struct block_device *, bool);
	void (*sync)(struct block_device *);
	int (*freeze)(struct block_device *);
	int (*thaw)(struct block_device *);
};

struct blk_ia_range_sysfs_entry {
	struct attribute attr;
	ssize_t (*show)(struct blk_independent_access_range *, char *);
};

struct blk_independent_access_ranges {
	struct kobject kobj;
	bool sysfs_registered;
	unsigned int nr_ia_ranges;
	long: 32;
	struct blk_independent_access_range ia_range[0];
};

struct blk_integrity {
	unsigned char flags;
	enum blk_integrity_checksum csum_type;
	unsigned char tuple_size;
	unsigned char pi_offset;
	unsigned char interval_exp;
	unsigned char tag_size;
};

struct blk_integrity_iter {
	void *prot_buf;
	void *data_buf;
	sector_t seed;
	unsigned int data_size;
	short unsigned int interval;
	const char *disk_name;
	long: 32;
};

struct blk_iou_cmd {
	int res;
	bool nowait;
};

struct blk_major_name {
	struct blk_major_name *next;
	int major;
	char name[16];
	void (*probe)(dev_t);
};

struct rq_list;

struct blk_mq_ctx;

struct blk_mq_hw_ctx;

struct blk_mq_alloc_data {
	struct request_queue *q;
	blk_mq_req_flags_t flags;
	unsigned int shallow_depth;
	blk_opf_t cmd_flags;
	req_flags_t rq_flags;
	unsigned int nr_tags;
	struct rq_list *cached_rqs;
	struct blk_mq_ctx *ctx;
	struct blk_mq_hw_ctx *hctx;
};

struct blk_mq_ctxs;

struct blk_mq_ctx {
	struct {
		spinlock_t lock;
		struct list_head rq_lists[3];
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
	};
	unsigned int cpu;
	short unsigned int index_hw[3];
	struct blk_mq_hw_ctx *hctxs[3];
	struct request_queue *queue;
	struct blk_mq_ctxs *ctxs;
	struct kobject kobj;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct blk_mq_ctxs {
	struct kobject kobj;
	struct blk_mq_ctx *queue_ctx;
};

struct seq_operations;

struct blk_mq_debugfs_attr {
	const char *name;
	umode_t mode;
	int (*show)(void *, struct seq_file *);
	ssize_t (*write)(void *, const char *, size_t, loff_t *);
	const struct seq_operations *seq_ops;
};

struct cpumask {
	long unsigned int bits[128];
};

typedef struct cpumask cpumask_var_t[1];

struct sbitmap_word;

struct sbitmap {
	unsigned int depth;
	unsigned int shift;
	unsigned int map_nr;
	bool round_robin;
	struct sbitmap_word *map;
	unsigned int *alloc_hint;
};

typedef struct wait_queue_entry wait_queue_entry_t;

struct blk_mq_hw_ctx {
	struct {
		spinlock_t lock;
		struct list_head dispatch;
		long unsigned int state;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
		long: 32;
	};
	struct delayed_work run_work;
	cpumask_var_t cpumask;
	int next_cpu;
	int next_cpu_batch;
	long unsigned int flags;
	void *sched_data;
	struct request_queue *queue;
	struct blk_flush_queue *fq;
	void *driver_data;
	struct sbitmap ctx_map;
	struct blk_mq_ctx *dispatch_from;
	unsigned int dispatch_busy;
	short unsigned int type;
	short unsigned int nr_ctx;
	struct blk_mq_ctx **ctxs;
	spinlock_t dispatch_wait_lock;
	wait_queue_entry_t dispatch_wait;
	atomic_t wait_index;
	struct blk_mq_tags *tags;
	struct blk_mq_tags *sched_tags;
	unsigned int numa_node;
	unsigned int queue_num;
	atomic_t nr_active;
	struct hlist_node cpuhp_online;
	struct hlist_node cpuhp_dead;
	struct kobject kobj;
	struct dentry *debugfs_dir;
	struct dentry *sched_debugfs_dir;
	struct list_head hctx_list;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct blk_mq_hw_ctx_sysfs_entry {
	struct attribute attr;
	ssize_t (*show)(struct blk_mq_hw_ctx *, char *);
};

struct blk_mq_queue_data;

struct io_comp_batch;

struct blk_mq_ops {
	blk_status_t (*queue_rq)(struct blk_mq_hw_ctx *, const struct blk_mq_queue_data *);
	void (*commit_rqs)(struct blk_mq_hw_ctx *);
	void (*queue_rqs)(struct rq_list *);
	int (*get_budget)(struct request_queue *);
	void (*put_budget)(struct request_queue *, int);
	void (*set_rq_budget_token)(struct request *, int);
	int (*get_rq_budget_token)(struct request *);
	enum blk_eh_timer_return (*timeout)(struct request *);
	int (*poll)(struct blk_mq_hw_ctx *, struct io_comp_batch *);
	void (*complete)(struct request *);
	int (*init_hctx)(struct blk_mq_hw_ctx *, void *, unsigned int);
	void (*exit_hctx)(struct blk_mq_hw_ctx *, unsigned int);
	int (*init_request)(struct blk_mq_tag_set *, struct request *, unsigned int, unsigned int);
	void (*exit_request)(struct blk_mq_tag_set *, struct request *, unsigned int);
	void (*cleanup_rq)(struct request *);
	bool (*busy)(struct request_queue *);
	void (*map_queues)(struct blk_mq_tag_set *);
	void (*show_rq)(struct seq_file *, struct request *);
};

struct blk_mq_queue_data {
	struct request *rq;
	bool last;
};

struct sbq_wait_state;

struct sbitmap_queue {
	struct sbitmap sb;
	unsigned int wake_batch;
	atomic_t wake_index;
	struct sbq_wait_state *ws;
	atomic_t ws_active;
	unsigned int min_shallow_depth;
	atomic_t completion_cnt;
	atomic_t wakeup_cnt;
};

struct blk_mq_tags {
	unsigned int nr_tags;
	unsigned int nr_reserved_tags;
	unsigned int active_queues;
	struct sbitmap_queue bitmap_tags;
	struct sbitmap_queue breserved_tags;
	struct request **rqs;
	struct request **static_rqs;
	struct list_head page_list;
	spinlock_t lock;
};

struct rq_list {
	struct request *head;
	struct request *tail;
};

struct blk_plug {
	struct rq_list mq_list;
	struct rq_list cached_rqs;
	u64 cur_ktime;
	short unsigned int nr_ios;
	short unsigned int rq_count;
	bool multiple_queues;
	bool has_elevator;
	struct list_head cb_list;
};

struct blk_plug_cb;

typedef void (*blk_plug_cb_fn)(struct blk_plug_cb *, bool);

struct blk_plug_cb {
	struct list_head list;
	blk_plug_cb_fn callback;
	void *data;
};

struct blk_queue_stats {
	struct list_head callbacks;
	spinlock_t lock;
	int accounting;
};

struct blk_rq_stat {
	u64 mean;
	u64 min;
	u64 max;
	u32 nr_samples;
	long: 32;
	u64 batch;
};

struct blk_rq_wait {
	struct completion done;
	blk_status_t ret;
};

struct blk_stat_callback {
	struct list_head list;
	struct timer_list timer;
	struct blk_rq_stat *cpu_stat;
	int (*bucket_fn)(const struct request *);
	unsigned int buckets;
	struct blk_rq_stat *stat;
	void (*timer_fn)(struct blk_stat_callback *);
	void *data;
	struct callback_head rcu;
};

struct blk_zone {
	__u64 start;
	__u64 len;
	__u64 wp;
	__u8 type;
	__u8 cond;
	__u8 non_seq;
	__u8 reset;
	__u8 resv[4];
	__u64 capacity;
	__u8 reserved[24];
};

struct rcu_work {
	struct work_struct work;
	struct callback_head rcu;
	struct workqueue_struct *wq;
};

struct cgroup_subsys;

struct css_rstat_cpu;

struct cgroup_subsys_state {
	struct cgroup *cgroup;
	struct cgroup_subsys *ss;
	struct percpu_ref refcnt;
	struct css_rstat_cpu *rstat_cpu;
	struct list_head sibling;
	struct list_head children;
	int id;
	unsigned int flags;
	long: 32;
	u64 serial_nr;
	atomic_t online_cnt;
	struct work_struct destroy_work;
	struct rcu_work destroy_rwork;
	struct cgroup_subsys_state *parent;
	int nr_descendants;
	struct cgroup_subsys_state *rstat_flush_next;
	long: 32;
};

struct llist_head;

struct blkcg {
	struct cgroup_subsys_state css;
	spinlock_t lock;
	refcount_t online_pin;
	atomic_t congestion_count;
	struct xarray blkg_tree;
	struct blkcg_gq *blkg_hint;
	struct hlist_head blkg_list;
	struct blkcg_policy_data *cpd[6];
	struct list_head all_blkcgs_node;
	struct llist_head *lhead;
	struct list_head cgwb_list;
	long: 32;
};

struct blkg_iostat {
	u64 bytes[3];
	u64 ios[3];
};

struct blkg_iostat_set {
	struct u64_stats_sync sync;
	struct blkcg_gq *blkg;
	struct llist_node lnode;
	int lqueued;
	struct blkg_iostat cur;
	struct blkg_iostat last;
};

struct blkcg_gq {
	struct request_queue *q;
	struct list_head q_node;
	struct hlist_node blkcg_node;
	struct blkcg *blkcg;
	struct blkcg_gq *parent;
	struct percpu_ref refcnt;
	bool online;
	struct blkg_iostat_set *iostat_cpu;
	long: 32;
	struct blkg_iostat_set iostat;
	struct blkg_policy_data *pd[6];
	spinlock_t async_bio_lock;
	struct bio_list async_bios;
	union {
		struct work_struct async_bio_work;
		struct work_struct free_work;
	};
	atomic_t use_delay;
	atomic64_t delay_nsec;
	atomic64_t delay_start;
	u64 last_delay;
	int last_use;
	struct callback_head callback_head;
	long: 32;
};

typedef struct blkcg_policy_data *blkcg_pol_alloc_cpd_fn(gfp_t);

typedef void blkcg_pol_free_cpd_fn(struct blkcg_policy_data *);

typedef struct blkg_policy_data *blkcg_pol_alloc_pd_fn(struct gendisk *, struct blkcg *, gfp_t);

typedef void blkcg_pol_init_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_online_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_offline_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_free_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_reset_pd_stats_fn(struct blkg_policy_data *);

typedef void blkcg_pol_stat_pd_fn(struct blkg_policy_data *, struct seq_file *);

struct cftype;

struct blkcg_policy {
	int plid;
	struct cftype *dfl_cftypes;
	struct cftype *legacy_cftypes;
	blkcg_pol_alloc_cpd_fn *cpd_alloc_fn;
	blkcg_pol_free_cpd_fn *cpd_free_fn;
	blkcg_pol_alloc_pd_fn *pd_alloc_fn;
	blkcg_pol_init_pd_fn *pd_init_fn;
	blkcg_pol_online_pd_fn *pd_online_fn;
	blkcg_pol_offline_pd_fn *pd_offline_fn;
	blkcg_pol_free_pd_fn *pd_free_fn;
	blkcg_pol_reset_pd_stats_fn *pd_reset_stats_fn;
	blkcg_pol_stat_pd_fn *pd_stat_fn;
};

struct blkdev_dio {
	union {
		struct kiocb *iocb;
		struct task_struct *waiter;
	};
	size_t size;
	atomic_t ref;
	unsigned int flags;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct bio bio;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct blkg_conf_ctx {
	char *input;
	char *body;
	struct block_device *bdev;
	struct blkcg_gq *blkg;
};

struct blkg_rwstat_sample {
	u64 cnt[5];
};

struct blkpg_ioctl_arg {
	int op;
	int flags;
	int datalen;
	void *data;
};

struct blkpg_partition {
	long long int start;
	long long int length;
	int pno;
	char devname[64];
	char volname[64];
	long: 32;
};

typedef int (*report_zones_cb)(struct blk_zone *, unsigned int, void *);

struct hd_geometry;

struct pr_ops;

struct block_device_operations {
	void (*submit_bio)(struct bio *);
	int (*poll_bio)(struct bio *, struct io_comp_batch *, unsigned int);
	int (*open)(struct gendisk *, blk_mode_t);
	void (*release)(struct gendisk *);
	int (*ioctl)(struct block_device *, blk_mode_t, unsigned int, long unsigned int);
	int (*compat_ioctl)(struct block_device *, blk_mode_t, unsigned int, long unsigned int);
	unsigned int (*check_events)(struct gendisk *, unsigned int);
	void (*unlock_native_capacity)(struct gendisk *);
	int (*getgeo)(struct block_device *, struct hd_geometry *);
	int (*set_read_only)(struct block_device *, bool);
	void (*free_disk)(struct gendisk *);
	void (*swap_slot_free_notify)(struct block_device *, long unsigned int);
	int (*report_zones)(struct gendisk *, sector_t, unsigned int, report_zones_cb, void *);
	char * (*devnode)(struct gendisk *, umode_t *);
	int (*get_unique_id)(struct gendisk *, u8 *, enum blk_unique_id);
	struct module *owner;
	const struct pr_ops *pr_ops;
	int (*alternative_gpt_sector)(struct gendisk *, sector_t *);
};

struct blockgroup_lock {
	struct bgl_lock locks[128];
};

struct blocking_notifier_head {
	struct rw_semaphore rwsem;
	struct notifier_block *head;
};

struct software_node;

struct spi_board_info {
	char modalias[32];
	const void *platform_data;
	const struct software_node *swnode;
	void *controller_data;
	int irq;
	u32 max_speed_hz;
	u16 bus_num;
	u16 chip_select;
	u32 mode;
};

struct boardinfo {
	struct list_head list;
	struct spi_board_info board_info;
};

struct boot_triggers {
	const char *event;
	char *trigger;
};

struct iphdr {
	__u8 ihl: 4;
	__u8 version: 4;
	__u8 tos;
	__be16 tot_len;
	__be16 id;
	__be16 frag_off;
	__u8 ttl;
	__u8 protocol;
	__sum16 check;
	union {
		struct {
			__be32 saddr;
			__be32 daddr;
		};
		struct {
			__be32 saddr;
			__be32 daddr;
		} addrs;
	};
};

struct udphdr {
	__be16 source;
	__be16 dest;
	__be16 len;
	__sum16 check;
};

struct bootp_pkt {
	struct iphdr iph;
	struct udphdr udph;
	u8 op;
	u8 htype;
	u8 hlen;
	u8 hops;
	__be32 xid;
	__be16 secs;
	__be16 flags;
	__be32 client_ip;
	__be32 your_ip;
	__be32 server_ip;
	__be32 relay_ip;
	u8 hw_addr[16];
	u8 serv_name[64];
	u8 boot_file[128];
	u8 exten[312];
};

struct bpf_map_ops;

struct btf_record;

struct btf;

struct obj_cgroup;

struct btf_type;

struct bpf_map {
	const struct bpf_map_ops *ops;
	struct bpf_map *inner_map_meta;
	void *security;
	enum bpf_map_type map_type;
	u32 key_size;
	u32 value_size;
	u32 max_entries;
	long: 32;
	u64 map_extra;
	u32 map_flags;
	u32 id;
	struct btf_record *record;
	int numa_node;
	u32 btf_key_type_id;
	u32 btf_value_type_id;
	u32 btf_vmlinux_value_type_id;
	struct btf *btf;
	struct obj_cgroup *objcg;
	char name[16];
	struct mutex freeze_mutex;
	long: 32;
	atomic64_t refcnt;
	atomic64_t usercnt;
	union {
		struct work_struct work;
		struct callback_head rcu;
	};
	atomic64_t writecnt;
	struct {
		const struct btf_type *attach_func_proto;
		spinlock_t lock;
		enum bpf_prog_type type;
		bool jited;
		bool xdp_has_frags;
	} owner;
	bool bypass_spec_v1;
	bool frozen;
	bool free_after_mult_rcu_gp;
	bool free_after_rcu_gp;
	long: 32;
	atomic64_t sleepable_refcnt;
	s64 *elem_count;
	long: 32;
};

struct bpf_array_aux;

struct bpf_array {
	struct bpf_map map;
	u32 elem_size;
	u32 index_mask;
	struct bpf_array_aux *aux;
	long: 32;
	union {
		struct {
			struct {} __empty_value;
			char value[0];
		};
		struct {
			struct {} __empty_ptrs;
			void *ptrs[0];
		};
		struct {
			struct {} __empty_pptrs;
			void *pptrs[0];
		};
	};
};

struct bpf_array_aux {
	struct list_head poke_progs;
	struct bpf_map *map;
	struct mutex poke_mutex;
	struct work_struct work;
};

struct bpf_prog;

struct bpf_async_cb {
	struct bpf_map *map;
	struct bpf_prog *prog;
	void *callback_fn;
	void *value;
	union {
		struct callback_head rcu;
		struct work_struct delete_work;
	};
	u64 flags;
};

struct bpf_spin_lock {
	__u32 val;
};

struct bpf_hrtimer;

struct bpf_work;

struct bpf_async_kern {
	union {
		struct bpf_async_cb *cb;
		struct bpf_hrtimer *timer;
		struct bpf_work *work;
	};
	struct bpf_spin_lock lock;
};

struct btf_func_model {
	u8 ret_size;
	u8 ret_flags;
	u8 nr_args;
	u8 arg_size[12];
	u8 arg_flags[12];
};

struct bpf_attach_target_info {
	struct btf_func_model fmodel;
	long int tgt_addr;
	struct module *tgt_mod;
	const char *tgt_name;
	const struct btf_type *tgt_type;
};

union bpf_attr {
	struct {
		__u32 map_type;
		__u32 key_size;
		__u32 value_size;
		__u32 max_entries;
		__u32 map_flags;
		__u32 inner_map_fd;
		__u32 numa_node;
		char map_name[16];
		__u32 map_ifindex;
		__u32 btf_fd;
		__u32 btf_key_type_id;
		__u32 btf_value_type_id;
		__u32 btf_vmlinux_value_type_id;
		__u64 map_extra;
		__s32 value_type_btf_obj_fd;
		__s32 map_token_fd;
	};
	struct {
		__u32 map_fd;
		long: 32;
		__u64 key;
		union {
			__u64 value;
			__u64 next_key;
		};
		__u64 flags;
	};
	struct {
		__u64 in_batch;
		__u64 out_batch;
		__u64 keys;
		__u64 values;
		__u32 count;
		__u32 map_fd;
		__u64 elem_flags;
		__u64 flags;
	} batch;
	struct {
		__u32 prog_type;
		__u32 insn_cnt;
		__u64 insns;
		__u64 license;
		__u32 log_level;
		__u32 log_size;
		__u64 log_buf;
		__u32 kern_version;
		__u32 prog_flags;
		char prog_name[16];
		__u32 prog_ifindex;
		__u32 expected_attach_type;
		__u32 prog_btf_fd;
		__u32 func_info_rec_size;
		__u64 func_info;
		__u32 func_info_cnt;
		__u32 line_info_rec_size;
		__u64 line_info;
		__u32 line_info_cnt;
		__u32 attach_btf_id;
		union {
			__u32 attach_prog_fd;
			__u32 attach_btf_obj_fd;
		};
		__u32 core_relo_cnt;
		__u64 fd_array;
		__u64 core_relos;
		__u32 core_relo_rec_size;
		__u32 log_true_size;
		__s32 prog_token_fd;
		__u32 fd_array_cnt;
	};
	struct {
		__u64 pathname;
		__u32 bpf_fd;
		__u32 file_flags;
		__s32 path_fd;
		long: 32;
	};
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_bpf_fd;
		__u32 attach_type;
		__u32 attach_flags;
		__u32 replace_bpf_fd;
		union {
			__u32 relative_fd;
			__u32 relative_id;
		};
		__u64 expected_revision;
	};
	struct {
		__u32 prog_fd;
		__u32 retval;
		__u32 data_size_in;
		__u32 data_size_out;
		__u64 data_in;
		__u64 data_out;
		__u32 repeat;
		__u32 duration;
		__u32 ctx_size_in;
		__u32 ctx_size_out;
		__u64 ctx_in;
		__u64 ctx_out;
		__u32 flags;
		__u32 cpu;
		__u32 batch_size;
		long: 32;
	} test;
	struct {
		union {
			__u32 start_id;
			__u32 prog_id;
			__u32 map_id;
			__u32 btf_id;
			__u32 link_id;
		};
		__u32 next_id;
		__u32 open_flags;
		__s32 fd_by_id_token_fd;
	};
	struct {
		__u32 bpf_fd;
		__u32 info_len;
		__u64 info;
	} info;
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 query_flags;
		__u32 attach_flags;
		__u64 prog_ids;
		union {
			__u32 prog_cnt;
			__u32 count;
		};
		long: 32;
		__u64 prog_attach_flags;
		__u64 link_ids;
		__u64 link_attach_flags;
		__u64 revision;
	} query;
	struct {
		__u64 name;
		__u32 prog_fd;
		long: 32;
		__u64 cookie;
	} raw_tracepoint;
	struct {
		__u64 btf;
		__u64 btf_log_buf;
		__u32 btf_size;
		__u32 btf_log_size;
		__u32 btf_log_level;
		__u32 btf_log_true_size;
		__u32 btf_flags;
		__s32 btf_token_fd;
	};
	struct {
		__u32 pid;
		__u32 fd;
		__u32 flags;
		__u32 buf_len;
		__u64 buf;
		__u32 prog_id;
		__u32 fd_type;
		__u64 probe_offset;
		__u64 probe_addr;
	} task_fd_query;
	struct {
		union {
			__u32 prog_fd;
			__u32 map_fd;
		};
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 flags;
		union {
			__u32 target_btf_id;
			struct {
				__u64 iter_info;
				__u32 iter_info_len;
				long: 32;
			};
			struct {
				__u64 bpf_cookie;
			} perf_event;
			struct {
				__u32 flags;
				__u32 cnt;
				__u64 syms;
				__u64 addrs;
				__u64 cookies;
			} kprobe_multi;
			struct {
				__u32 target_btf_id;
				long: 32;
				__u64 cookie;
			} tracing;
			struct {
				__u32 pf;
				__u32 hooknum;
				__s32 priority;
				__u32 flags;
			} netfilter;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				long: 32;
				__u64 expected_revision;
			} tcx;
			struct {
				__u64 path;
				__u64 offsets;
				__u64 ref_ctr_offsets;
				__u64 cookies;
				__u32 cnt;
				__u32 flags;
				__u32 pid;
				long: 32;
			} uprobe_multi;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				long: 32;
				__u64 expected_revision;
			} netkit;
		};
	} link_create;
	struct {
		__u32 link_fd;
		union {
			__u32 new_prog_fd;
			__u32 new_map_fd;
		};
		__u32 flags;
		union {
			__u32 old_prog_fd;
			__u32 old_map_fd;
		};
	} link_update;
	struct {
		__u32 link_fd;
	} link_detach;
	struct {
		__u32 type;
	} enable_stats;
	struct {
		__u32 link_fd;
		__u32 flags;
	} iter_create;
	struct {
		__u32 prog_fd;
		__u32 map_fd;
		__u32 flags;
	} prog_bind_map;
	struct {
		__u32 flags;
		__u32 bpffs_fd;
	} token_create;
};

struct bpf_binary_header {
	u32 size;
	long: 32;
	u8 image[0];
};

struct bpf_bloom_filter {
	struct bpf_map map;
	u32 bitset_mask;
	u32 hash_seed;
	u32 nr_hash_funcs;
	long unsigned int bitset[0];
	long: 32;
};

struct bpf_bprintf_buffers {
	char bin_args[512];
	char buf[1024];
};

struct bpf_bprintf_data {
	u32 *bin_args;
	char *buf;
	bool get_bin_args;
	bool get_buf;
};

struct bpf_btf_info {
	__u64 btf;
	__u32 btf_size;
	__u32 id;
	__u64 name;
	__u32 name_len;
	__u32 kernel_btf;
};

struct btf_field;

struct bpf_call_arg_meta {
	struct bpf_map *map_ptr;
	bool raw_mode;
	bool pkt_access;
	u8 release_regno;
	int regno;
	int access_size;
	int mem_size;
	long: 32;
	u64 msize_max_value;
	int ref_obj_id;
	int dynptr_id;
	int map_uid;
	int func_id;
	struct btf *btf;
	u32 btf_id;
	struct btf *ret_btf;
	u32 ret_btf_id;
	u32 subprogno;
	struct btf_field *kptr_field;
	s64 const_map_key;
};

struct bpf_cand_cache {
	const char *name;
	u32 name_len;
	u16 kind;
	u16 cnt;
	struct {
		const struct btf *btf;
		u32 id;
	} cands[0];
};

struct bpf_run_ctx {};

struct bpf_prog_array_item;

struct bpf_cg_run_ctx {
	struct bpf_run_ctx run_ctx;
	const struct bpf_prog_array_item *prog_item;
	int retval;
};

struct bpf_cgroup_dev_ctx {
	__u32 access_type;
	__u32 major;
	__u32 minor;
};

struct bpf_link_ops;

struct bpf_link {
	atomic64_t refcnt;
	u32 id;
	enum bpf_link_type type;
	const struct bpf_link_ops *ops;
	struct bpf_prog *prog;
	bool sleepable;
	union {
		struct callback_head rcu;
		struct work_struct work;
	};
	long: 32;
};

struct bpf_cgroup_link {
	struct bpf_link link;
	struct cgroup *cgroup;
	enum bpf_attach_type type;
};

struct bpf_cgroup_storage_key {
	__u64 cgroup_inode_id;
	__u32 attach_type;
	long: 32;
};

struct bpf_storage_buffer;

struct bpf_cgroup_storage_map;

struct bpf_cgroup_storage {
	union {
		struct bpf_storage_buffer *buf;
		void *percpu_buf;
	};
	struct bpf_cgroup_storage_map *map;
	struct bpf_cgroup_storage_key key;
	struct list_head list_map;
	struct list_head list_cg;
	struct rb_node node;
	struct callback_head rcu;
	long: 32;
};

struct bpf_cgroup_storage_map {
	struct bpf_map map;
	spinlock_t lock;
	struct rb_root root;
	struct list_head list;
};

struct bpf_lru_list {
	struct list_head lists[3];
	unsigned int counts[2];
	struct list_head *next_inactive_rotation;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	raw_spinlock_t lock;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bpf_lru_locallist;

struct bpf_common_lru {
	struct bpf_lru_list lru_list;
	struct bpf_lru_locallist *local_list;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bpf_core_accessor {
	__u32 type_id;
	__u32 idx;
	const char *name;
};

struct bpf_core_cand {
	const struct btf *btf;
	__u32 id;
};

struct bpf_core_cand_list {
	struct bpf_core_cand *cands;
	int len;
};

struct bpf_verifier_log;

struct bpf_core_ctx {
	struct bpf_verifier_log *log;
	const struct btf *btf;
};

struct bpf_core_relo {
	__u32 insn_off;
	__u32 type_id;
	__u32 access_str_off;
	enum bpf_core_relo_kind kind;
};

struct bpf_core_relo_res {
	__u64 orig_val;
	__u64 new_val;
	bool poison;
	bool validate;
	bool fail_memsz_adjust;
	__u32 orig_sz;
	__u32 orig_type_id;
	__u32 new_sz;
	__u32 new_type_id;
	long: 32;
};

struct bpf_core_spec {
	const struct btf *btf;
	struct bpf_core_accessor spec[64];
	__u32 root_type_id;
	enum bpf_core_relo_kind relo_kind;
	int len;
	int raw_spec[64];
	int raw_len;
	__u32 bit_offset;
};

struct bpf_cpu_map_entry;

struct bpf_cpu_map {
	struct bpf_map map;
	struct bpf_cpu_map_entry **cpu_map;
	long: 32;
};

struct bpf_cpumap_val {
	__u32 qsize;
	union {
		int fd;
		__u32 id;
	} bpf_prog;
};

struct gro_list {
	struct list_head list;
	int count;
};

struct gro_node {
	long unsigned int bitmask;
	struct gro_list hash[8];
	struct list_head rx_list;
	u32 rx_count;
	u32 cached_napi_id;
};

struct xdp_bulk_queue;

struct ptr_ring;

struct bpf_cpu_map_entry {
	u32 cpu;
	int map_id;
	struct xdp_bulk_queue *bulkq;
	struct ptr_ring *queue;
	struct task_struct *kthread;
	struct bpf_cpumap_val value;
	struct bpf_prog *prog;
	struct gro_node gro;
	struct completion kthread_running;
	struct rcu_work free_work;
};

typedef struct cpumask cpumask_t;

struct bpf_cpumask {
	cpumask_t cpumask;
	refcount_t usage;
};

struct bpf_crypto_type;

struct bpf_crypto_ctx {
	const struct bpf_crypto_type *type;
	void *tfm;
	u32 siv_len;
	struct callback_head rcu;
	refcount_t usage;
};

struct bpf_crypto_params {
	char type[14];
	u8 reserved[2];
	char algo[128];
	u8 key[256];
	u32 key_len;
	u32 authsize;
};

struct bpf_crypto_type {
	void * (*alloc_tfm)(const char *);
	void (*free_tfm)(void *);
	int (*has_algo)(const char *);
	int (*setkey)(void *, const u8 *, unsigned int);
	int (*setauthsize)(void *, unsigned int);
	int (*encrypt)(void *, const u8 *, u8 *, unsigned int, u8 *);
	int (*decrypt)(void *, const u8 *, u8 *, unsigned int, u8 *);
	unsigned int (*ivsize)(void *);
	unsigned int (*statesize)(void *);
	u32 (*get_flags)(void *);
	struct module *owner;
	char name[14];
};

struct bpf_crypto_type_list {
	const struct bpf_crypto_type *type;
	struct list_head list;
};

struct bpf_ctx_arg_aux {
	u32 offset;
	enum bpf_reg_type reg_type;
	struct btf *btf;
	u32 btf_id;
	u32 ref_obj_id;
	bool refcounted;
};

struct skb_ext;

struct sk_buff {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
			union {
				struct net_device *dev;
				long unsigned int dev_scratch;
			};
		};
		struct rb_node rbnode;
		struct list_head list;
		struct llist_node ll_node;
	};
	struct sock *sk;
	union {
		ktime_t tstamp;
		u64 skb_mstamp_ns;
	};
	char cb[48];
	union {
		struct {
			long unsigned int _skb_refdst;
			void (*destructor)(struct sk_buff *);
		};
		struct list_head tcp_tsorted_anchor;
		long unsigned int _sk_redir;
	};
	long unsigned int _nfct;
	unsigned int len;
	unsigned int data_len;
	__u16 mac_len;
	__u16 hdr_len;
	__u16 queue_mapping;
	__u8 __cloned_offset[0];
	__u8 cloned: 1;
	__u8 nohdr: 1;
	__u8 fclone: 2;
	__u8 peeked: 1;
	__u8 head_frag: 1;
	__u8 pfmemalloc: 1;
	__u8 pp_recycle: 1;
	__u8 active_extensions;
	union {
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 tstamp_type: 2;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 ipvs_property: 1;
			__u8 offload_fwd_mark: 1;
			__u8 offload_l3_fwd_mark: 1;
			__u8 redirected: 1;
			__u8 nf_skip_egress: 1;
			__u8 slow_gro: 1;
			__u8 unreadable: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		};
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 tstamp_type: 2;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 ipvs_property: 1;
			__u8 offload_fwd_mark: 1;
			__u8 offload_l3_fwd_mark: 1;
			__u8 redirected: 1;
			__u8 nf_skip_egress: 1;
			__u8 slow_gro: 1;
			__u8 unreadable: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		} headers;
	};
	sk_buff_data_t tail;
	sk_buff_data_t end;
	unsigned char *head;
	unsigned char *data;
	unsigned int truesize;
	refcount_t users;
	struct skb_ext *extensions;
};

struct xdp_md {
	__u32 data;
	__u32 data_end;
	__u32 data_meta;
	__u32 ingress_ifindex;
	__u32 rx_queue_index;
	__u32 egress_ifindex;
};

struct xdp_rxq_info;

struct xdp_txq_info;

struct xdp_buff {
	void *data;
	void *data_end;
	void *data_meta;
	void *data_hard_start;
	struct xdp_rxq_info *rxq;
	struct xdp_txq_info *txq;
	u32 frame_sz;
	u32 flags;
};

struct bpf_sock {
	__u32 bound_dev_if;
	__u32 family;
	__u32 type;
	__u32 protocol;
	__u32 mark;
	__u32 priority;
	__u32 src_ip4;
	__u32 src_ip6[4];
	__u32 src_port;
	__be16 dst_port;
	__u32 dst_ip4;
	__u32 dst_ip6[4];
	__u32 state;
	__s32 rx_queue_mapping;
};

struct hlist_nulls_node {
	struct hlist_nulls_node *next;
	struct hlist_nulls_node **pprev;
};

struct proto;

struct inet_timewait_death_row;

struct sock_common {
	union {
		__addrpair skc_addrpair;
		struct {
			__be32 skc_daddr;
			__be32 skc_rcv_saddr;
		};
	};
	union {
		unsigned int skc_hash;
		__u16 skc_u16hashes[2];
	};
	union {
		__portpair skc_portpair;
		struct {
			__be16 skc_dport;
			__u16 skc_num;
		};
	};
	short unsigned int skc_family;
	volatile unsigned char skc_state;
	unsigned char skc_reuse: 4;
	unsigned char skc_reuseport: 1;
	unsigned char skc_ipv6only: 1;
	unsigned char skc_net_refcnt: 1;
	int skc_bound_dev_if;
	union {
		struct hlist_node skc_bind_node;
		struct hlist_node skc_portaddr_node;
	};
	struct proto *skc_prot;
	possible_net_t skc_net;
	struct in6_addr skc_v6_daddr;
	struct in6_addr skc_v6_rcv_saddr;
	atomic64_t skc_cookie;
	union {
		long unsigned int skc_flags;
		struct sock *skc_listener;
		struct inet_timewait_death_row *skc_tw_dr;
	};
	int skc_dontcopy_begin[0];
	union {
		struct hlist_node skc_node;
		struct hlist_nulls_node skc_nulls_node;
	};
	short unsigned int skc_tx_queue_mapping;
	short unsigned int skc_rx_queue_mapping;
	union {
		int skc_incoming_cpu;
		u32 skc_rcv_wnd;
		u32 skc_tw_rcv_nxt;
	};
	refcount_t skc_refcnt;
	int skc_dontcopy_end[0];
	union {
		u32 skc_rxhash;
		u32 skc_window_clamp;
		u32 skc_tw_snd_nxt;
	};
	long: 32;
};

struct page_frag {
	struct page *page;
	__u16 offset;
	__u16 size;
};

struct sock_cgroup_data {
	struct cgroup *cgroup;
};

struct dst_entry;

struct sk_filter;

struct socket_wq;

struct socket;

struct mem_cgroup;

struct sock_reuseport;

struct bpf_local_storage;

struct sock {
	struct sock_common __sk_common;
	__u8 __cacheline_group_begin__sock_write_rx[0];
	atomic_t sk_drops;
	__s32 sk_peek_off;
	struct sk_buff_head sk_error_queue;
	struct sk_buff_head sk_receive_queue;
	struct {
		atomic_t rmem_alloc;
		int len;
		struct sk_buff *head;
		struct sk_buff *tail;
	} sk_backlog;
	__u8 __cacheline_group_end__sock_write_rx[0];
	__u8 __cacheline_group_begin__sock_read_rx[0];
	struct dst_entry *sk_rx_dst;
	int sk_rx_dst_ifindex;
	u32 sk_rx_dst_cookie;
	unsigned int sk_ll_usec;
	unsigned int sk_napi_id;
	u16 sk_busy_poll_budget;
	u8 sk_prefer_busy_poll;
	u8 sk_userlocks;
	int sk_rcvbuf;
	struct sk_filter *sk_filter;
	union {
		struct socket_wq *sk_wq;
		struct socket_wq *sk_wq_raw;
	};
	void (*sk_data_ready)(struct sock *);
	long int sk_rcvtimeo;
	int sk_rcvlowat;
	__u8 __cacheline_group_end__sock_read_rx[0];
	__u8 __cacheline_group_begin__sock_read_rxtx[0];
	int sk_err;
	struct socket *sk_socket;
	struct mem_cgroup *sk_memcg;
	__u8 __cacheline_group_end__sock_read_rxtx[0];
	__u8 __cacheline_group_begin__sock_write_rxtx[0];
	socket_lock_t sk_lock;
	u32 sk_reserved_mem;
	int sk_forward_alloc;
	u32 sk_tsflags;
	__u8 __cacheline_group_end__sock_write_rxtx[0];
	__u8 __cacheline_group_begin__sock_write_tx[0];
	int sk_write_pending;
	atomic_t sk_omem_alloc;
	int sk_sndbuf;
	int sk_wmem_queued;
	refcount_t sk_wmem_alloc;
	long unsigned int sk_tsq_flags;
	union {
		struct sk_buff *sk_send_head;
		struct rb_root tcp_rtx_queue;
	};
	struct sk_buff_head sk_write_queue;
	u32 sk_dst_pending_confirm;
	u32 sk_pacing_status;
	struct page_frag sk_frag;
	struct timer_list sk_timer;
	long unsigned int sk_pacing_rate;
	atomic_t sk_zckey;
	atomic_t sk_tskey;
	__u8 __cacheline_group_end__sock_write_tx[0];
	__u8 __cacheline_group_begin__sock_read_tx[0];
	long unsigned int sk_max_pacing_rate;
	long int sk_sndtimeo;
	u32 sk_priority;
	u32 sk_mark;
	struct dst_entry *sk_dst_cache;
	long: 32;
	netdev_features_t sk_route_caps;
	u16 sk_gso_type;
	u16 sk_gso_max_segs;
	unsigned int sk_gso_max_size;
	gfp_t sk_allocation;
	u32 sk_txhash;
	u8 sk_pacing_shift;
	bool sk_use_task_frag;
	__u8 __cacheline_group_end__sock_read_tx[0];
	u8 sk_gso_disabled: 1;
	u8 sk_kern_sock: 1;
	u8 sk_no_check_tx: 1;
	u8 sk_no_check_rx: 1;
	u8 sk_shutdown;
	u16 sk_type;
	u16 sk_protocol;
	long unsigned int sk_lingertime;
	struct proto *sk_prot_creator;
	rwlock_t sk_callback_lock;
	int sk_err_soft;
	u32 sk_ack_backlog;
	u32 sk_max_ack_backlog;
	kuid_t sk_uid;
	spinlock_t sk_peer_lock;
	int sk_bind_phc;
	struct pid *sk_peer_pid;
	const struct cred *sk_peer_cred;
	ktime_t sk_stamp;
	seqlock_t sk_stamp_seq;
	int sk_disconnects;
	union {
		u8 sk_txrehash;
		u8 sk_scm_recv_flags;
		struct {
			u8 sk_scm_credentials: 1;
			u8 sk_scm_security: 1;
			u8 sk_scm_pidfd: 1;
			u8 sk_scm_rights: 1;
			u8 sk_scm_unused: 4;
		};
	};
	u8 sk_clockid;
	u8 sk_txtime_deadline_mode: 1;
	u8 sk_txtime_report_errors: 1;
	u8 sk_txtime_unused: 6;
	u8 sk_bpf_cb_flags;
	void *sk_user_data;
	void *sk_security;
	struct sock_cgroup_data sk_cgrp_data;
	void (*sk_state_change)(struct sock *);
	void (*sk_write_space)(struct sock *);
	void (*sk_error_report)(struct sock *);
	int (*sk_backlog_rcv)(struct sock *, struct sk_buff *);
	void (*sk_destruct)(struct sock *);
	struct sock_reuseport *sk_reuseport_cb;
	struct bpf_local_storage *sk_bpf_storage;
	struct callback_head sk_rcu;
	netns_tracker ns_tracker;
	struct xarray sk_user_frags;
	long: 32;
};

struct bpf_sock_addr {
	__u32 user_family;
	__u32 user_ip4;
	__u32 user_ip6[4];
	__u32 user_port;
	__u32 family;
	__u32 type;
	__u32 protocol;
	__u32 msg_src_ip4;
	__u32 msg_src_ip6[4];
	long: 32;
	union {
		struct bpf_sock *sk;
	};
};

struct bpf_sock_addr_kern {
	struct sock *sk;
	struct sockaddr *uaddr;
	u64 tmp_reg;
	void *t_ctx;
	u32 uaddrlen;
};

struct bpf_sock_ops {
	__u32 op;
	union {
		__u32 args[4];
		__u32 reply;
		__u32 replylong[4];
	};
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 is_fullsock;
	__u32 snd_cwnd;
	__u32 srtt_us;
	__u32 bpf_sock_ops_cb_flags;
	__u32 state;
	__u32 rtt_min;
	__u32 snd_ssthresh;
	__u32 rcv_nxt;
	__u32 snd_nxt;
	__u32 snd_una;
	__u32 mss_cache;
	__u32 ecn_flags;
	__u32 rate_delivered;
	__u32 rate_interval_us;
	__u32 packets_out;
	__u32 retrans_out;
	__u32 total_retrans;
	__u32 segs_in;
	__u32 data_segs_in;
	__u32 segs_out;
	__u32 data_segs_out;
	__u32 lost_out;
	__u32 sacked_out;
	__u32 sk_txhash;
	__u64 bytes_received;
	__u64 bytes_acked;
	union {
		struct bpf_sock *sk;
	};
	union {
		void *skb_data;
	};
	union {
		void *skb_data_end;
	};
	__u32 skb_len;
	__u32 skb_tcp_flags;
	__u64 skb_hwtstamp;
};

struct bpf_sock_ops_kern {
	struct sock *sk;
	union {
		u32 args[4];
		u32 reply;
		u32 replylong[4];
	};
	struct sk_buff *syn_skb;
	struct sk_buff *skb;
	void *skb_data_end;
	u8 op;
	u8 is_fullsock;
	u8 is_locked_tcp_sock;
	u8 remaining_opt_len;
	long: 32;
	u64 temp;
};

struct sk_msg_md {
	union {
		void *data;
	};
	union {
		void *data_end;
	};
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 size;
	union {
		struct bpf_sock *sk;
	};
};

struct sk_msg_sg {
	u32 start;
	u32 curr;
	u32 end;
	u32 size;
	u32 copybreak;
	long unsigned int copy[1];
	struct scatterlist data[19];
};

struct sk_msg {
	struct sk_msg_sg sg;
	void *data;
	void *data_end;
	u32 apply_bytes;
	u32 cork_bytes;
	u32 flags;
	struct sk_buff *skb;
	struct sock *sk_redir;
	struct sock *sk;
	struct list_head list;
};

struct bpf_flow_dissector {
	struct bpf_flow_keys *flow_keys;
	const struct sk_buff *skb;
	const void *data;
	const void *data_end;
};

struct pt_regs {
	long unsigned int args[8];
	long unsigned int regs[32];
	long unsigned int cp0_status;
	long unsigned int hi;
	long unsigned int lo;
	long unsigned int cp0_badvaddr;
	long unsigned int cp0_cause;
	long unsigned int cp0_epc;
	long unsigned int __last[0];
};

typedef struct pt_regs bpf_user_pt_regs_t;

struct bpf_perf_event_data {
	bpf_user_pt_regs_t regs;
	__u64 sample_period;
	__u64 addr;
};

struct perf_sample_data;

struct perf_event;

struct bpf_perf_event_data_kern {
	bpf_user_pt_regs_t *regs;
	struct perf_sample_data *data;
	struct perf_event *event;
};

struct bpf_raw_tracepoint_args {
	__u64 args[0];
};

struct bpf_sysctl {
	__u32 write;
	__u32 file_pos;
};

struct ctl_table_header;

struct ctl_table;

struct bpf_sysctl_kern {
	struct ctl_table_header *head;
	const struct ctl_table *table;
	void *cur_val;
	size_t cur_len;
	void *new_val;
	size_t new_len;
	int new_updated;
	int write;
	loff_t *ppos;
	long: 32;
	u64 tmp_reg;
};

struct bpf_sockopt {
	union {
		struct bpf_sock *sk;
	};
	union {
		void *optval;
	};
	union {
		void *optval_end;
	};
	__s32 level;
	__s32 optname;
	__s32 optlen;
	__s32 retval;
};

struct bpf_sockopt_kern {
	struct sock *sk;
	u8 *optval;
	u8 *optval_end;
	s32 level;
	s32 optname;
	s32 optlen;
	struct task_struct *current_task;
	long: 32;
	u64 tmp_reg;
};

struct sk_reuseport_md {
	union {
		void *data;
	};
	union {
		void *data_end;
	};
	__u32 len;
	__u32 eth_protocol;
	__u32 ip_protocol;
	__u32 bind_inany;
	__u32 hash;
	long: 32;
	union {
		struct bpf_sock *sk;
	};
	union {
		struct bpf_sock *migrating_sk;
	};
};

struct sk_reuseport_kern {
	struct sk_buff *skb;
	struct sock *sk;
	struct sock *selected_sk;
	struct sock *migrating_sk;
	void *data_end;
	u32 hash;
	u32 reuseport_id;
	bool bind_inany;
};

struct bpf_sk_lookup {
	union {
		union {
			struct bpf_sock *sk;
		};
		__u64 cookie;
	};
	__u32 family;
	__u32 protocol;
	__u32 remote_ip4;
	__u32 remote_ip6[4];
	__be16 remote_port;
	__u32 local_ip4;
	__u32 local_ip6[4];
	__u32 local_port;
	__u32 ingress_ifindex;
	long: 32;
};

struct bpf_sk_lookup_kern {
	u16 family;
	u16 protocol;
	__be16 sport;
	u16 dport;
	struct {
		__be32 saddr;
		__be32 daddr;
	} v4;
	struct {
		const struct in6_addr *saddr;
		const struct in6_addr *daddr;
	} v6;
	struct sock *selected_sk;
	u32 ingress_ifindex;
	bool no_reuseport;
};

struct nf_hook_state;

struct bpf_nf_ctx {
	const struct nf_hook_state *state;
	struct sk_buff *skb;
};

struct bpf_ctx_convert {
	struct __sk_buff BPF_PROG_TYPE_SOCKET_FILTER_prog;
	struct sk_buff BPF_PROG_TYPE_SOCKET_FILTER_kern;
	struct __sk_buff BPF_PROG_TYPE_SCHED_CLS_prog;
	struct sk_buff BPF_PROG_TYPE_SCHED_CLS_kern;
	struct __sk_buff BPF_PROG_TYPE_SCHED_ACT_prog;
	struct sk_buff BPF_PROG_TYPE_SCHED_ACT_kern;
	struct xdp_md BPF_PROG_TYPE_XDP_prog;
	struct xdp_buff BPF_PROG_TYPE_XDP_kern;
	struct __sk_buff BPF_PROG_TYPE_CGROUP_SKB_prog;
	struct sk_buff BPF_PROG_TYPE_CGROUP_SKB_kern;
	struct bpf_sock BPF_PROG_TYPE_CGROUP_SOCK_prog;
	struct sock BPF_PROG_TYPE_CGROUP_SOCK_kern;
	struct bpf_sock_addr BPF_PROG_TYPE_CGROUP_SOCK_ADDR_prog;
	struct bpf_sock_addr_kern BPF_PROG_TYPE_CGROUP_SOCK_ADDR_kern;
	struct __sk_buff BPF_PROG_TYPE_LWT_IN_prog;
	struct sk_buff BPF_PROG_TYPE_LWT_IN_kern;
	struct __sk_buff BPF_PROG_TYPE_LWT_OUT_prog;
	struct sk_buff BPF_PROG_TYPE_LWT_OUT_kern;
	struct __sk_buff BPF_PROG_TYPE_LWT_XMIT_prog;
	struct sk_buff BPF_PROG_TYPE_LWT_XMIT_kern;
	struct __sk_buff BPF_PROG_TYPE_LWT_SEG6LOCAL_prog;
	struct sk_buff BPF_PROG_TYPE_LWT_SEG6LOCAL_kern;
	struct bpf_sock_ops BPF_PROG_TYPE_SOCK_OPS_prog;
	struct bpf_sock_ops_kern BPF_PROG_TYPE_SOCK_OPS_kern;
	struct __sk_buff BPF_PROG_TYPE_SK_SKB_prog;
	struct sk_buff BPF_PROG_TYPE_SK_SKB_kern;
	struct sk_msg_md BPF_PROG_TYPE_SK_MSG_prog;
	struct sk_msg BPF_PROG_TYPE_SK_MSG_kern;
	struct __sk_buff BPF_PROG_TYPE_FLOW_DISSECTOR_prog;
	struct bpf_flow_dissector BPF_PROG_TYPE_FLOW_DISSECTOR_kern;
	bpf_user_pt_regs_t BPF_PROG_TYPE_KPROBE_prog;
	struct pt_regs BPF_PROG_TYPE_KPROBE_kern;
	__u64 BPF_PROG_TYPE_TRACEPOINT_prog;
	u64 BPF_PROG_TYPE_TRACEPOINT_kern;
	struct bpf_perf_event_data BPF_PROG_TYPE_PERF_EVENT_prog;
	struct bpf_perf_event_data_kern BPF_PROG_TYPE_PERF_EVENT_kern;
	long: 32;
	struct bpf_raw_tracepoint_args BPF_PROG_TYPE_RAW_TRACEPOINT_prog;
	u64 BPF_PROG_TYPE_RAW_TRACEPOINT_kern;
	struct bpf_raw_tracepoint_args BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE_prog;
	u64 BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE_kern;
	void *BPF_PROG_TYPE_TRACING_prog;
	void *BPF_PROG_TYPE_TRACING_kern;
	struct bpf_cgroup_dev_ctx BPF_PROG_TYPE_CGROUP_DEVICE_prog;
	struct bpf_cgroup_dev_ctx BPF_PROG_TYPE_CGROUP_DEVICE_kern;
	struct bpf_sysctl BPF_PROG_TYPE_CGROUP_SYSCTL_prog;
	struct bpf_sysctl_kern BPF_PROG_TYPE_CGROUP_SYSCTL_kern;
	struct bpf_sockopt BPF_PROG_TYPE_CGROUP_SOCKOPT_prog;
	struct bpf_sockopt_kern BPF_PROG_TYPE_CGROUP_SOCKOPT_kern;
	struct sk_reuseport_md BPF_PROG_TYPE_SK_REUSEPORT_prog;
	struct sk_reuseport_kern BPF_PROG_TYPE_SK_REUSEPORT_kern;
	struct bpf_sk_lookup BPF_PROG_TYPE_SK_LOOKUP_prog;
	struct bpf_sk_lookup_kern BPF_PROG_TYPE_SK_LOOKUP_kern;
	void *BPF_PROG_TYPE_STRUCT_OPS_prog;
	void *BPF_PROG_TYPE_STRUCT_OPS_kern;
	void *BPF_PROG_TYPE_EXT_prog;
	void *BPF_PROG_TYPE_EXT_kern;
	void *BPF_PROG_TYPE_SYSCALL_prog;
	void *BPF_PROG_TYPE_SYSCALL_kern;
	struct bpf_nf_ctx BPF_PROG_TYPE_NETFILTER_prog;
	struct bpf_nf_ctx BPF_PROG_TYPE_NETFILTER_kern;
	long: 32;
};

struct bpf_devmap_val {
	__u32 ifindex;
	union {
		int fd;
		__u32 id;
	} bpf_prog;
};

struct bpf_dispatcher_prog {
	struct bpf_prog *prog;
	refcount_t users;
};

struct latch_tree_node {
	struct rb_node node[2];
};

struct bpf_ksym {
	long unsigned int start;
	long unsigned int end;
	char name[512];
	struct list_head lnode;
	struct latch_tree_node tnode;
	bool prog;
};

struct bpf_dispatcher {
	struct mutex mutex;
	void *func;
	struct bpf_dispatcher_prog progs[48];
	int num_progs;
	void *image;
	void *rw_image;
	u32 image_off;
	struct bpf_ksym ksym;
};

struct bpf_dtab_netdev;

struct bpf_dtab {
	struct bpf_map map;
	struct bpf_dtab_netdev **netdev_map;
	struct list_head list;
	struct hlist_head *dev_index_head;
	spinlock_t index_lock;
	unsigned int items;
	u32 n_buckets;
	long: 32;
};

struct bpf_dtab_netdev {
	struct net_device *dev;
	struct hlist_node index_hlist;
	struct bpf_prog *xdp_prog;
	struct callback_head rcu;
	unsigned int idx;
	struct bpf_devmap_val val;
};

struct bpf_dummy_ops_state;

struct bpf_dummy_ops {
	int (*test_1)(struct bpf_dummy_ops_state *);
	int (*test_2)(struct bpf_dummy_ops_state *, int, short unsigned int, char, long unsigned int);
	int (*test_sleepable)(struct bpf_dummy_ops_state *);
};

struct bpf_dummy_ops_state {
	int val;
};

struct bpf_dummy_ops_test_args {
	u64 args[12];
	struct bpf_dummy_ops_state state;
	long: 32;
};

struct bpf_dynptr {
	__u64 __opaque[2];
};

struct bpf_dynptr_kern {
	void *data;
	u32 size;
	u32 offset;
	long: 32;
};

struct bpf_prog_array_item {
	struct bpf_prog *prog;
	long: 32;
	union {
		struct bpf_cgroup_storage *cgroup_storage[2];
		u64 bpf_cookie;
	};
};

struct bpf_prog_array {
	struct callback_head rcu;
	struct bpf_prog_array_item items[0];
};

struct bpf_empty_prog_array {
	struct bpf_prog_array hdr;
	struct bpf_prog *null_prog;
	long: 32;
};

struct bpf_event_entry {
	struct perf_event *event;
	struct file *perf_file;
	struct file *map_file;
	struct callback_head rcu;
};

struct bpf_fentry_test_t {
	struct bpf_fentry_test_t *a;
};

struct bpf_fib_lookup {
	__u8 family;
	__u8 l4_protocol;
	__be16 sport;
	__be16 dport;
	union {
		__u16 tot_len;
		__u16 mtu_result;
	};
	__u32 ifindex;
	union {
		__u8 tos;
		__be32 flowinfo;
		__u32 rt_metric;
	};
	union {
		__be32 ipv4_src;
		__u32 ipv6_src[4];
	};
	union {
		__be32 ipv4_dst;
		__u32 ipv6_dst[4];
	};
	union {
		struct {
			__be16 h_vlan_proto;
			__be16 h_vlan_TCI;
		};
		__u32 tbid;
	};
	union {
		struct {
			__u32 mark;
		};
		struct {
			__u8 smac[6];
			__u8 dmac[6];
		};
	};
};

struct bpf_flow_keys {
	__u16 nhoff;
	__u16 thoff;
	__u16 addr_proto;
	__u8 is_frag;
	__u8 is_first_frag;
	__u8 is_encap;
	__u8 ip_proto;
	__be16 n_proto;
	__be16 sport;
	__be16 dport;
	union {
		struct {
			__be32 ipv4_src;
			__be32 ipv4_dst;
		};
		struct {
			__u32 ipv6_src[4];
			__u32 ipv6_dst[4];
		};
	};
	__u32 flags;
	__be32 flow_label;
};

struct bpf_func_info {
	__u32 insn_off;
	__u32 type_id;
};

struct bpf_func_info_aux {
	u16 linkage;
	bool unreliable;
	bool called: 1;
	bool verified: 1;
};

struct bpf_func_proto {
	u64 (*func)(u64, u64, u64, u64, u64);
	bool gpl_only;
	bool pkt_access;
	bool might_sleep;
	bool allow_fastcall;
	enum bpf_return_type ret_type;
	union {
		struct {
			enum bpf_arg_type arg1_type;
			enum bpf_arg_type arg2_type;
			enum bpf_arg_type arg3_type;
			enum bpf_arg_type arg4_type;
			enum bpf_arg_type arg5_type;
		};
		enum bpf_arg_type arg_type[5];
	};
	union {
		struct {
			u32 *arg1_btf_id;
			u32 *arg2_btf_id;
			u32 *arg3_btf_id;
			u32 *arg4_btf_id;
			u32 *arg5_btf_id;
		};
		u32 *arg_btf_id[5];
		struct {
			size_t arg1_size;
			size_t arg2_size;
			size_t arg3_size;
			size_t arg4_size;
			size_t arg5_size;
		};
		size_t arg_size[5];
	};
	int *ret_btf_id;
	bool (*allowed)(const struct bpf_prog *);
};

struct tnum {
	u64 value;
	u64 mask;
};

struct bpf_reg_state {
	enum bpf_reg_type type;
	s32 off;
	union {
		int range;
		struct {
			struct bpf_map *map_ptr;
			u32 map_uid;
		};
		struct {
			struct btf *btf;
			u32 btf_id;
		};
		struct {
			u32 mem_size;
			u32 dynptr_id;
		};
		struct {
			enum bpf_dynptr_type type;
			bool first_slot;
		} dynptr;
		struct {
			struct btf *btf;
			u32 btf_id;
			enum bpf_iter_state state: 2;
			int depth: 30;
		} iter;
		struct {
			enum {
				IRQ_NATIVE_KFUNC = 0,
				IRQ_LOCK_KFUNC = 1,
			} kfunc_class;
		} irq;
		struct {
			long unsigned int raw1;
			long unsigned int raw2;
		} raw;
		u32 subprogno;
	};
	long: 32;
	struct tnum var_off;
	s64 smin_value;
	s64 smax_value;
	u64 umin_value;
	u64 umax_value;
	s32 s32_min_value;
	s32 s32_max_value;
	u32 u32_min_value;
	u32 u32_max_value;
	u32 id;
	u32 ref_obj_id;
	struct bpf_reg_state *parent;
	u32 frameno;
	s32 subreg_def;
	enum bpf_reg_liveness live;
	bool precise;
	long: 32;
};

struct bpf_retval_range {
	s32 minval;
	s32 maxval;
};

struct bpf_stack_state;

struct bpf_func_state {
	struct bpf_reg_state regs[11];
	int callsite;
	u32 frameno;
	u32 subprogno;
	u32 async_entry_cnt;
	struct bpf_retval_range callback_ret_range;
	bool in_callback_fn;
	bool in_async_callback_fn;
	bool in_exception_callback_fn;
	u32 callback_depth;
	struct bpf_stack_state *stack;
	int allocated_stack;
};

struct bpf_hrtimer {
	struct bpf_async_cb cb;
	struct hrtimer timer;
	atomic_t cancelling;
	long: 32;
};

struct bpf_mem_caches;

struct bpf_mem_cache;

struct bpf_mem_alloc {
	struct bpf_mem_caches *caches;
	struct bpf_mem_cache *cache;
	struct obj_cgroup *objcg;
	bool percpu;
	struct work_struct work;
};

struct pcpu_freelist_head;

struct pcpu_freelist {
	struct pcpu_freelist_head *freelist;
};

struct bpf_lru_node;

typedef bool (*del_from_htab_func)(void *, struct bpf_lru_node *);

struct bpf_lru {
	union {
		struct bpf_common_lru common_lru;
		struct bpf_lru_list *percpu_lru;
	};
	del_from_htab_func del_from_htab;
	void *del_arg;
	unsigned int hash_offset;
	unsigned int target_free;
	unsigned int nr_scans;
	bool percpu;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bucket;

struct htab_elem;

struct bpf_htab {
	struct bpf_map map;
	struct bpf_mem_alloc ma;
	struct bpf_mem_alloc pcpu_ma;
	struct bucket *buckets;
	void *elems;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	union {
		struct pcpu_freelist freelist;
		struct bpf_lru lru;
	};
	struct htab_elem **extra_elems;
	long: 32;
	struct percpu_counter pcount;
	atomic_t count;
	bool use_percpu_counter;
	u32 n_buckets;
	u32 elem_size;
	u32 hashrnd;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bpf_id_pair {
	u32 old;
	u32 cur;
};

struct bpf_idmap {
	u32 tmp_id_gen;
	struct bpf_id_pair map[600];
};

struct bpf_idset {
	u32 count;
	u32 ids[600];
};

struct bpf_insn {
	__u8 code;
	__u8 dst_reg: 4;
	__u8 src_reg: 4;
	__s16 off;
	__s32 imm;
};

struct bpf_insn_access_aux {
	enum bpf_reg_type reg_type;
	bool is_ldsx;
	union {
		int ctx_field_size;
		struct {
			struct btf *btf;
			u32 btf_id;
			u32 ref_obj_id;
		};
	};
	struct bpf_verifier_log *log;
	bool is_retval;
};

struct bpf_map_ptr_state {
	struct bpf_map *map_ptr;
	bool poison;
	bool unpriv;
};

struct bpf_loop_inline_state {
	unsigned int initialized: 1;
	unsigned int fit_for_inline: 1;
	u32 callback_subprogno;
};

struct btf_struct_meta;

struct bpf_insn_aux_data {
	union {
		enum bpf_reg_type ptr_type;
		struct bpf_map_ptr_state map_ptr_state;
		s32 call_imm;
		u32 alu_limit;
		struct {
			u32 map_index;
			u32 map_off;
		};
		struct {
			enum bpf_reg_type reg_type;
			union {
				struct {
					struct btf *btf;
					u32 btf_id;
				};
				u32 mem_size;
			};
		} btf_var;
		struct bpf_loop_inline_state loop_inline_state;
	};
	long: 32;
	union {
		u64 obj_new_size;
		u64 insert_off;
	};
	struct btf_struct_meta *kptr_struct_meta;
	long: 32;
	u64 map_key_state;
	int ctx_field_size;
	u32 seen;
	bool sanitize_stack_spill;
	bool zext_dst;
	bool needs_zext;
	bool storage_get_func_atomic;
	bool is_iter_next;
	bool call_with_percpu_alloc_ptr;
	u8 alu_state;
	u8 fastcall_pattern: 1;
	u8 fastcall_spills_num: 3;
	u8 arg_prog: 4;
	unsigned int orig_idx;
	bool jmp_point;
	bool prune_point;
	bool force_checkpoint;
	bool calls_callback;
	u16 live_regs_before;
	long: 32;
};

typedef void (*bpf_insn_print_t)(void *, const char *, ...);

typedef const char * (*bpf_insn_revmap_call_t)(void *, const struct bpf_insn *);

typedef const char * (*bpf_insn_print_imm_t)(void *, const struct bpf_insn *, __u64);

struct bpf_insn_cbs {
	bpf_insn_print_t cb_print;
	bpf_insn_revmap_call_t cb_call;
	bpf_insn_print_imm_t cb_imm;
	void *private_data;
};

struct bpf_insn_hist_entry {
	u32 idx;
	u32 prev_idx: 20;
	u32 flags: 12;
	u64 linked_regs;
};

struct bpf_iter_meta;

struct bpf_iter__bpf_link {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct bpf_link *link;
	};
};

struct bpf_iter__bpf_map {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct bpf_map *map;
	};
};

struct bpf_iter__bpf_map_elem {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct bpf_map *map;
	};
	union {
		void *key;
	};
	union {
		void *value;
	};
};

struct bpf_iter__bpf_prog {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct bpf_prog *prog;
	};
};

struct bpf_iter__bpf_sk_storage_map {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct bpf_map *map;
	};
	union {
		struct sock *sk;
	};
	union {
		void *value;
	};
};

struct bpf_iter__cgroup {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct cgroup *cgroup;
	};
};

struct dma_buf;

struct bpf_iter__dmabuf {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct dma_buf *dmabuf;
	};
};

struct bpf_iter__kmem_cache {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct kmem_cache *s;
	};
};

struct kallsym_iter;

struct bpf_iter__ksym {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct kallsym_iter *ksym;
	};
};

struct netlink_sock;

struct bpf_iter__netlink {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct netlink_sock *sk;
	};
};

struct bpf_iter__sockmap {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct bpf_map *map;
	};
	union {
		void *key;
	};
	union {
		struct sock *sk;
	};
};

struct bpf_iter__task {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct task_struct *task;
	};
};

struct bpf_iter__task__safe_trusted {
	struct bpf_iter_meta *meta;
	struct task_struct *task;
};

struct bpf_iter__task_file {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct task_struct *task;
	};
	u32 fd;
	long: 32;
	union {
		struct file *file;
	};
};

struct bpf_iter__task_vma {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct task_struct *task;
	};
	union {
		struct vm_area_struct *vma;
	};
};

struct bpf_iter__tcp {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct sock_common *sk_common;
	};
	uid_t uid;
	long: 32;
};

struct udp_sock;

struct bpf_iter__udp {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct udp_sock *udp_sk;
	};
	uid_t uid;
	long: 32;
	int bucket;
	long: 32;
};

struct unix_sock;

struct bpf_iter__unix {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct unix_sock *unix_sk;
	};
	uid_t uid;
	long: 32;
};

struct bpf_iter_aux_info {
	struct bpf_map *map;
	struct {
		struct cgroup *start;
		enum bpf_cgroup_iter_order order;
	} cgroup;
	struct {
		enum bpf_iter_task_type type;
		u32 pid;
	} task;
};

struct bpf_iter_bits {
	__u64 __opaque[2];
};

struct bpf_iter_bits_kern {
	union {
		__u64 *bits;
		__u64 bits_copy;
	};
	int nr_bits;
	int bit;
};

struct bpf_iter_css {
	__u64 __opaque[3];
};

struct bpf_iter_css_kern {
	struct cgroup_subsys_state *start;
	struct cgroup_subsys_state *pos;
	unsigned int flags;
	long: 32;
};

struct bpf_iter_css_task {
	__u64 __opaque[1];
};

struct css_task_iter;

struct bpf_iter_css_task_kern {
	struct css_task_iter *css_it;
	long: 32;
};

struct bpf_iter_dmabuf {
	__u64 __opaque[1];
};

struct bpf_iter_dmabuf_kern {
	struct dma_buf *dmabuf;
	long: 32;
};

struct bpf_iter_kmem_cache {
	__u64 __opaque[1];
};

struct bpf_iter_kmem_cache_kern {
	struct kmem_cache *pos;
	long: 32;
};

struct bpf_iter_target_info;

struct bpf_iter_link {
	struct bpf_link link;
	struct bpf_iter_aux_info aux;
	struct bpf_iter_target_info *tinfo;
};

union bpf_iter_link_info {
	struct {
		__u32 map_fd;
	} map;
	struct {
		enum bpf_cgroup_iter_order order;
		__u32 cgroup_fd;
		__u64 cgroup_id;
	} cgroup;
	struct {
		__u32 tid;
		__u32 pid;
		__u32 pid_fd;
	} task;
};

struct bpf_iter_meta {
	union {
		struct seq_file *seq;
	};
	u64 session_id;
	u64 seq_num;
};

struct bpf_iter_meta__safe_trusted {
	struct seq_file *seq;
};

struct bpf_iter_num {
	__u64 __opaque[1];
};

struct bpf_iter_num_kern {
	int cur;
	int end;
};

struct bpf_iter_seq_info;

struct bpf_iter_priv_data {
	struct bpf_iter_target_info *tinfo;
	const struct bpf_iter_seq_info *seq_info;
	struct bpf_prog *prog;
	long: 32;
	u64 session_id;
	u64 seq_num;
	bool done_stop;
	long: 32;
	u8 target_private[0];
};

typedef int (*bpf_iter_attach_target_t)(struct bpf_prog *, union bpf_iter_link_info *, struct bpf_iter_aux_info *);

typedef void (*bpf_iter_detach_target_t)(struct bpf_iter_aux_info *);

typedef void (*bpf_iter_show_fdinfo_t)(const struct bpf_iter_aux_info *, struct seq_file *);

struct bpf_link_info;

typedef int (*bpf_iter_fill_link_info_t)(const struct bpf_iter_aux_info *, struct bpf_link_info *);

typedef const struct bpf_func_proto * (*bpf_iter_get_func_proto_t)(enum bpf_func_id, const struct bpf_prog *);

struct bpf_iter_reg {
	const char *target;
	bpf_iter_attach_target_t attach_target;
	bpf_iter_detach_target_t detach_target;
	bpf_iter_show_fdinfo_t show_fdinfo;
	bpf_iter_fill_link_info_t fill_link_info;
	bpf_iter_get_func_proto_t get_func_proto;
	u32 ctx_arg_info_size;
	u32 feature;
	struct bpf_ctx_arg_aux ctx_arg_info[2];
	const struct bpf_iter_seq_info *seq_info;
};

struct bpf_iter_scx_dsq {
	u64 __opaque[6];
};

struct scx_dsq_list_node {
	struct list_head node;
	u32 flags;
	u32 priv;
};

struct scx_dispatch_q;

struct bpf_iter_scx_dsq_kern {
	struct scx_dsq_list_node cursor;
	struct scx_dispatch_q *dsq;
	long: 32;
	u64 slice;
	u64 vtime;
};

struct bpf_iter_seq_array_map_info {
	struct bpf_map *map;
	void *percpu_value_buf;
	u32 index;
};

struct bpf_iter_seq_hash_map_info {
	struct bpf_map *map;
	struct bpf_htab *htab;
	void *percpu_value_buf;
	u32 bucket_id;
	u32 skip_elems;
};

typedef int (*bpf_iter_init_seq_priv_t)(void *, struct bpf_iter_aux_info *);

typedef void (*bpf_iter_fini_seq_priv_t)(void *);

struct bpf_iter_seq_info {
	const struct seq_operations *seq_ops;
	bpf_iter_init_seq_priv_t init_seq_private;
	bpf_iter_fini_seq_priv_t fini_seq_private;
	u32 seq_priv_size;
};

struct bpf_iter_seq_link_info {
	u32 link_id;
};

struct bpf_iter_seq_map_info {
	u32 map_id;
};

struct bpf_iter_seq_prog_info {
	u32 prog_id;
};

struct bpf_iter_seq_sk_storage_map_info {
	struct bpf_map *map;
	unsigned int bucket_id;
	unsigned int skip_elems;
};

struct pid_namespace;

struct bpf_iter_seq_task_common {
	struct pid_namespace *ns;
	enum bpf_iter_task_type type;
	u32 pid;
	u32 pid_visiting;
};

struct bpf_iter_seq_task_file_info {
	struct bpf_iter_seq_task_common common;
	struct task_struct *task;
	u32 tid;
	u32 fd;
};

struct bpf_iter_seq_task_info {
	struct bpf_iter_seq_task_common common;
	u32 tid;
};

struct mm_struct;

struct bpf_iter_seq_task_vma_info {
	struct bpf_iter_seq_task_common common;
	struct task_struct *task;
	struct mm_struct *mm;
	struct vm_area_struct *vma;
	u32 tid;
	long unsigned int prev_vm_start;
	long unsigned int prev_vm_end;
};

struct bpf_iter_target_info {
	struct list_head list;
	const struct bpf_iter_reg *reg_info;
	u32 btf_id;
};

struct bpf_iter_task {
	__u64 __opaque[3];
};

struct bpf_iter_task_kern {
	struct task_struct *task;
	struct task_struct *pos;
	unsigned int flags;
	long: 32;
};

struct bpf_iter_task_vma {
	__u64 __opaque[1];
};

struct bpf_iter_task_vma_kern_data;

struct bpf_iter_task_vma_kern {
	struct bpf_iter_task_vma_kern_data *data;
	long: 32;
};

struct maple_enode;

struct maple_tree;

struct maple_alloc;

struct ma_state {
	struct maple_tree *tree;
	long unsigned int index;
	long unsigned int last;
	struct maple_enode *node;
	long unsigned int min;
	long unsigned int max;
	struct maple_alloc *alloc;
	enum maple_status status;
	unsigned char depth;
	unsigned char offset;
	unsigned char mas_flags;
	unsigned char end;
	enum store_type store_type;
};

struct vma_iterator {
	struct ma_state mas;
};

struct mmap_unlock_irq_work;

struct bpf_iter_task_vma_kern_data {
	struct task_struct *task;
	struct mm_struct *mm;
	struct mmap_unlock_irq_work *work;
	struct vma_iterator vmi;
};

struct bpf_jit_poke_descriptor {
	void *tailcall_target;
	void *tailcall_bypass;
	void *bypass_addr;
	void *aux;
	union {
		struct {
			struct bpf_map *map;
			u32 key;
		} tail_call;
	};
	bool tailcall_target_stable;
	u8 adj_off;
	u16 reason;
	u32 insn_idx;
};

struct bpf_key {
	struct key *key;
	bool has_ref;
};

struct bpf_kfunc_btf {
	struct btf *btf;
	struct module *module;
	u16 offset;
};

struct bpf_kfunc_btf_tab {
	struct bpf_kfunc_btf descs[256];
	u32 nr_descs;
};

struct bpf_kfunc_call_arg_meta {
	struct btf *btf;
	u32 func_id;
	u32 kfunc_flags;
	const struct btf_type *func_proto;
	const char *func_name;
	u32 ref_obj_id;
	u8 release_regno;
	bool r0_rdonly;
	u32 ret_btf_id;
	u64 r0_size;
	u32 subprogno;
	long: 32;
	struct {
		u64 value;
		bool found;
		long: 32;
	} arg_constant;
	struct btf *arg_btf;
	u32 arg_btf_id;
	bool arg_owning_ref;
	bool arg_prog;
	struct {
		struct btf_field *field;
	} arg_list_head;
	struct {
		struct btf_field *field;
	} arg_rbtree_root;
	struct {
		enum bpf_dynptr_type type;
		u32 id;
		u32 ref_obj_id;
	} initialized_dynptr;
	struct {
		u8 spi;
		u8 frameno;
	} iter;
	struct {
		struct bpf_map *ptr;
		int uid;
	} map;
	long: 32;
	u64 mem_size;
};

struct bpf_kfunc_desc {
	struct btf_func_model func_model;
	u32 func_id;
	s32 imm;
	u16 offset;
	long unsigned int addr;
};

struct bpf_kfunc_desc_tab {
	struct bpf_kfunc_desc descs[256];
	u32 nr_descs;
};

struct bpf_line_info {
	__u32 insn_off;
	__u32 file_name_off;
	__u32 line_off;
	__u32 line_col;
};

struct bpf_link_info {
	__u32 type;
	__u32 id;
	__u32 prog_id;
	long: 32;
	union {
		struct {
			__u64 tp_name;
			__u32 tp_name_len;
			long: 32;
		} raw_tracepoint;
		struct {
			__u32 attach_type;
			__u32 target_obj_id;
			__u32 target_btf_id;
		} tracing;
		struct {
			__u64 cgroup_id;
			__u32 attach_type;
			long: 32;
		} cgroup;
		struct {
			__u64 target_name;
			__u32 target_name_len;
			union {
				struct {
					__u32 map_id;
				} map;
			};
			union {
				struct {
					__u64 cgroup_id;
					__u32 order;
					long: 32;
				} cgroup;
				struct {
					__u32 tid;
					__u32 pid;
				} task;
			};
		} iter;
		struct {
			__u32 netns_ino;
			__u32 attach_type;
		} netns;
		struct {
			__u32 ifindex;
		} xdp;
		struct {
			__u32 map_id;
		} struct_ops;
		struct {
			__u32 pf;
			__u32 hooknum;
			__s32 priority;
			__u32 flags;
		} netfilter;
		struct {
			__u64 addrs;
			__u32 count;
			__u32 flags;
			__u64 missed;
			__u64 cookies;
		} kprobe_multi;
		struct {
			__u64 path;
			__u64 offsets;
			__u64 ref_ctr_offsets;
			__u64 cookies;
			__u32 path_size;
			__u32 count;
			__u32 flags;
			__u32 pid;
		} uprobe_multi;
		struct {
			__u32 type;
			long: 32;
			union {
				struct {
					__u64 file_name;
					__u32 name_len;
					__u32 offset;
					__u64 cookie;
					__u64 ref_ctr_offset;
				} uprobe;
				struct {
					__u64 func_name;
					__u32 name_len;
					__u32 offset;
					__u64 addr;
					__u64 missed;
					__u64 cookie;
				} kprobe;
				struct {
					__u64 tp_name;
					__u32 name_len;
					long: 32;
					__u64 cookie;
				} tracepoint;
				struct {
					__u64 config;
					__u32 type;
					long: 32;
					__u64 cookie;
				} event;
			};
		} perf_event;
		struct {
			__u32 ifindex;
			__u32 attach_type;
		} tcx;
		struct {
			__u32 ifindex;
			__u32 attach_type;
		} netkit;
		struct {
			__u32 map_id;
			__u32 attach_type;
		} sockmap;
	};
};

struct bpf_link_ops {
	void (*release)(struct bpf_link *);
	void (*dealloc)(struct bpf_link *);
	void (*dealloc_deferred)(struct bpf_link *);
	int (*detach)(struct bpf_link *);
	int (*update_prog)(struct bpf_link *, struct bpf_prog *, struct bpf_prog *);
	void (*show_fdinfo)(const struct bpf_link *, struct seq_file *);
	int (*fill_link_info)(const struct bpf_link *, struct bpf_link_info *);
	int (*update_map)(struct bpf_link *, struct bpf_map *, struct bpf_map *);
	__poll_t (*poll)(struct file *, struct poll_table_struct *);
};

struct bpf_link_primer {
	struct bpf_link *link;
	struct file *file;
	int fd;
	u32 id;
};

struct bpf_list_head {
	__u64 __opaque[2];
};

struct bpf_list_node {
	__u64 __opaque[3];
};

struct bpf_list_node_kern {
	struct list_head list_head;
	void *owner;
	long: 32;
};

struct bpf_local_storage_data;

struct bpf_local_storage_map;

struct bpf_local_storage {
	struct bpf_local_storage_data *cache[16];
	struct bpf_local_storage_map *smap;
	struct hlist_head list;
	void *owner;
	struct callback_head rcu;
	raw_spinlock_t lock;
};

struct bpf_local_storage_cache {
	spinlock_t idx_lock;
	long: 32;
	u64 idx_usage_counts[16];
};

struct bpf_local_storage_data {
	struct bpf_local_storage_map *smap;
	long: 32;
	u8 data[0];
};

struct bpf_local_storage_elem {
	struct hlist_node map_node;
	struct hlist_node snode;
	struct bpf_local_storage *local_storage;
	union {
		struct callback_head rcu;
		struct hlist_node free_node;
	};
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct bpf_local_storage_data sdata;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bpf_local_storage_map_bucket;

struct bpf_local_storage_map {
	struct bpf_map map;
	struct bpf_local_storage_map_bucket *buckets;
	u32 bucket_log;
	u16 elem_size;
	u16 cache_idx;
	struct bpf_mem_alloc selem_ma;
	struct bpf_mem_alloc storage_ma;
	bool bpf_ma;
};

struct bpf_local_storage_map_bucket {
	struct hlist_head list;
	raw_spinlock_t lock;
};

struct bpf_lpm_trie_key_hdr {
	__u32 prefixlen;
};

struct bpf_lpm_trie_key_u8 {
	union {
		struct bpf_lpm_trie_key_hdr hdr;
		__u32 prefixlen;
	};
	__u8 data[0];
};

struct bpf_lru_locallist {
	struct list_head lists[2];
	u16 next_steal;
	raw_spinlock_t lock;
};

struct bpf_lru_node {
	struct list_head list;
	u16 cpu;
	u8 type;
	u8 ref;
};

struct bpf_offloaded_map;

struct bpf_map_dev_ops {
	int (*map_get_next_key)(struct bpf_offloaded_map *, void *, void *);
	int (*map_lookup_elem)(struct bpf_offloaded_map *, void *, void *);
	int (*map_update_elem)(struct bpf_offloaded_map *, void *, void *, u64);
	int (*map_delete_elem)(struct bpf_offloaded_map *, void *);
};

struct bpf_map_info {
	__u32 type;
	__u32 id;
	__u32 key_size;
	__u32 value_size;
	__u32 max_entries;
	__u32 map_flags;
	char name[16];
	__u32 ifindex;
	__u32 btf_vmlinux_value_type_id;
	__u64 netns_dev;
	__u64 netns_ino;
	__u32 btf_id;
	__u32 btf_key_type_id;
	__u32 btf_value_type_id;
	__u32 btf_vmlinux_id;
	__u64 map_extra;
};

typedef u64 (*bpf_callback_t)(u64, u64, u64, u64, u64);

struct bpf_prog_aux;

struct bpf_map_ops {
	int (*map_alloc_check)(union bpf_attr *);
	struct bpf_map * (*map_alloc)(union bpf_attr *);
	void (*map_release)(struct bpf_map *, struct file *);
	void (*map_free)(struct bpf_map *);
	int (*map_get_next_key)(struct bpf_map *, void *, void *);
	void (*map_release_uref)(struct bpf_map *);
	void * (*map_lookup_elem_sys_only)(struct bpf_map *, void *);
	int (*map_lookup_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	int (*map_lookup_and_delete_elem)(struct bpf_map *, void *, void *, u64);
	int (*map_lookup_and_delete_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	int (*map_update_batch)(struct bpf_map *, struct file *, const union bpf_attr *, union bpf_attr *);
	int (*map_delete_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	void * (*map_lookup_elem)(struct bpf_map *, void *);
	long int (*map_update_elem)(struct bpf_map *, void *, void *, u64);
	long int (*map_delete_elem)(struct bpf_map *, void *);
	long int (*map_push_elem)(struct bpf_map *, void *, u64);
	long int (*map_pop_elem)(struct bpf_map *, void *);
	long int (*map_peek_elem)(struct bpf_map *, void *);
	void * (*map_lookup_percpu_elem)(struct bpf_map *, void *, u32);
	void * (*map_fd_get_ptr)(struct bpf_map *, struct file *, int);
	void (*map_fd_put_ptr)(struct bpf_map *, void *, bool);
	int (*map_gen_lookup)(struct bpf_map *, struct bpf_insn *);
	u32 (*map_fd_sys_lookup_elem)(void *);
	void (*map_seq_show_elem)(struct bpf_map *, void *, struct seq_file *);
	int (*map_check_btf)(const struct bpf_map *, const struct btf *, const struct btf_type *, const struct btf_type *);
	int (*map_poke_track)(struct bpf_map *, struct bpf_prog_aux *);
	void (*map_poke_untrack)(struct bpf_map *, struct bpf_prog_aux *);
	void (*map_poke_run)(struct bpf_map *, u32, struct bpf_prog *, struct bpf_prog *);
	int (*map_direct_value_addr)(const struct bpf_map *, u64 *, u32);
	int (*map_direct_value_meta)(const struct bpf_map *, u64, u32 *);
	int (*map_mmap)(struct bpf_map *, struct vm_area_struct *);
	__poll_t (*map_poll)(struct bpf_map *, struct file *, struct poll_table_struct *);
	long unsigned int (*map_get_unmapped_area)(struct file *, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
	int (*map_local_storage_charge)(struct bpf_local_storage_map *, void *, u32);
	void (*map_local_storage_uncharge)(struct bpf_local_storage_map *, void *, u32);
	struct bpf_local_storage ** (*map_owner_storage_ptr)(void *);
	long int (*map_redirect)(struct bpf_map *, u64, u64);
	bool (*map_meta_equal)(const struct bpf_map *, const struct bpf_map *);
	int (*map_set_for_each_callback_args)(struct bpf_verifier_env *, struct bpf_func_state *, struct bpf_func_state *);
	long int (*map_for_each_callback)(struct bpf_map *, bpf_callback_t, void *, u64);
	u64 (*map_mem_usage)(const struct bpf_map *);
	int *map_btf_id;
	const struct bpf_iter_seq_info *iter_seq_info;
};

struct llist_head {
	struct llist_node *first;
};

struct rcuwait {
	struct task_struct *task;
};

struct irq_work {
	struct __call_single_node node;
	void (*func)(struct irq_work *);
	struct rcuwait irqwait;
};

struct bpf_mem_cache {
	struct llist_head free_llist;
	local_t active;
	struct llist_head free_llist_extra;
	struct irq_work refill_work;
	struct obj_cgroup *objcg;
	int unit_size;
	int free_cnt;
	int low_watermark;
	int high_watermark;
	int batch;
	int percpu_size;
	bool draining;
	struct bpf_mem_cache *tgt;
	struct llist_head free_by_rcu;
	struct llist_node *free_by_rcu_tail;
	struct llist_head waiting_for_gp;
	struct llist_node *waiting_for_gp_tail;
	struct callback_head rcu;
	atomic_t call_rcu_in_progress;
	struct llist_head free_llist_extra_rcu;
	struct llist_head free_by_rcu_ttrace;
	struct llist_head waiting_for_gp_ttrace;
	struct callback_head rcu_ttrace;
	atomic_t call_rcu_ttrace_in_progress;
};

struct bpf_mem_caches {
	struct bpf_mem_cache cache[11];
};

struct bpf_mount_opts {
	kuid_t uid;
	kgid_t gid;
	umode_t mode;
	long: 32;
	u64 delegate_cmds;
	u64 delegate_maps;
	u64 delegate_progs;
	u64 delegate_attachs;
};

struct bpf_mprog_fp {
	struct bpf_prog *prog;
};

struct bpf_mprog_bundle;

struct bpf_mprog_entry {
	struct bpf_mprog_fp fp_items[64];
	struct bpf_mprog_bundle *parent;
};

struct bpf_mprog_cp {
	struct bpf_link *link;
};

struct bpf_mprog_bundle {
	struct bpf_mprog_entry a;
	struct bpf_mprog_entry b;
	struct bpf_mprog_cp cp_items[64];
	struct bpf_prog *ref;
	long: 32;
	atomic64_t revision;
	u32 count;
	long: 32;
};

struct bpf_nested_pt_regs {
	struct pt_regs regs[3];
};

struct bpf_nh_params {
	u32 nh_family;
	union {
		u32 ipv4_nh;
		struct in6_addr ipv6_nh;
	};
};

struct bpf_redirect_info {
	u64 tgt_index;
	void *tgt_value;
	struct bpf_map *map;
	u32 flags;
	u32 map_id;
	enum bpf_map_type map_type;
	struct bpf_nh_params nh;
	u32 kern_flags;
	long: 32;
};

struct bpf_net_context {
	struct bpf_redirect_info ri;
	struct list_head cpu_map_flush_list;
	struct list_head dev_map_flush_list;
	struct list_head xskmap_map_flush_list;
};

struct bpf_netns_link {
	struct bpf_link link;
	enum bpf_attach_type type;
	enum netns_bpf_attach_type netns_type;
	struct net *net;
	struct list_head node;
	long: 32;
};

typedef unsigned int nf_hookfn(void *, struct sk_buff *, const struct nf_hook_state *);

struct nf_hook_ops {
	struct list_head list;
	struct callback_head rcu;
	nf_hookfn *hook;
	struct net_device *dev;
	void *priv;
	u8 pf;
	enum nf_hook_ops_type hook_ops_type: 8;
	unsigned int hooknum;
	int priority;
};

struct nf_defrag_hook;

struct bpf_nf_link {
	struct bpf_link link;
	struct nf_hook_ops hook_ops;
	netns_tracker ns_tracker;
	struct net *net;
	u32 dead;
	const struct nf_defrag_hook *defrag_hook;
	long: 32;
};

struct bpf_prog_offload_ops;

struct bpf_offload_dev {
	const struct bpf_prog_offload_ops *ops;
	struct list_head netdevs;
	void *priv;
};

struct rhash_head {
	struct rhash_head *next;
};

struct bpf_offload_netdev {
	struct rhash_head l;
	struct net_device *netdev;
	struct bpf_offload_dev *offdev;
	struct list_head progs;
	struct list_head maps;
	struct list_head offdev_netdevs;
};

struct bpf_offloaded_map {
	struct bpf_map map;
	struct net_device *netdev;
	const struct bpf_map_dev_ops *dev_ops;
	void *dev_priv;
	struct list_head offloads;
	long: 32;
};

struct bpf_perf_event_value {
	__u64 counter;
	__u64 enabled;
	__u64 running;
};

struct bpf_perf_link {
	struct bpf_link link;
	struct file *perf_file;
	long: 32;
};

struct bpf_pidns_info {
	__u32 pid;
	__u32 tgid;
};

struct bpf_preload_info {
	char link_name[16];
	struct bpf_link *link;
};

struct bpf_preload_ops {
	int (*preload)(struct bpf_preload_info *);
	struct module *owner;
};

struct sock_filter {
	__u16 code;
	__u8 jt;
	__u8 jf;
	__u32 k;
};

struct bpf_prog_stats;

struct sock_fprog_kern;

struct bpf_prog {
	u16 pages;
	u16 jited: 1;
	u16 jit_requested: 1;
	u16 gpl_compatible: 1;
	u16 cb_access: 1;
	u16 dst_needed: 1;
	u16 blinding_requested: 1;
	u16 blinded: 1;
	u16 is_func: 1;
	u16 kprobe_override: 1;
	u16 has_callchain_buf: 1;
	u16 enforce_expected_attach_type: 1;
	u16 call_get_stack: 1;
	u16 call_get_func_ip: 1;
	u16 tstamp_type_access: 1;
	u16 sleepable: 1;
	enum bpf_prog_type type;
	enum bpf_attach_type expected_attach_type;
	u32 len;
	u32 jited_len;
	u8 tag[8];
	struct bpf_prog_stats *stats;
	int *active;
	unsigned int (*bpf_func)(const void *, const struct bpf_insn *);
	struct bpf_prog_aux *aux;
	struct sock_fprog_kern *orig_prog;
	union {
		struct {
			struct {} __empty_insns;
			struct sock_filter insns[0];
		};
		struct {
			struct {} __empty_insnsi;
			struct bpf_insn insnsi[0];
		};
	};
};

struct bpf_arena;

struct bpf_trampoline;

struct bpf_prog_ops;

struct bpf_struct_ops;

struct btf_mod_pair;

struct user_struct;

struct bpf_token;

struct bpf_prog_offload;

struct exception_table_entry;

struct bpf_prog_aux {
	atomic64_t refcnt;
	u32 used_map_cnt;
	u32 used_btf_cnt;
	u32 max_ctx_offset;
	u32 max_pkt_offset;
	u32 max_tp_access;
	u32 stack_depth;
	u32 id;
	u32 func_cnt;
	u32 real_func_cnt;
	u32 func_idx;
	u32 attach_btf_id;
	u32 attach_st_ops_member_off;
	u32 ctx_arg_info_size;
	u32 max_rdonly_access;
	u32 max_rdwr_access;
	struct btf *attach_btf;
	struct bpf_ctx_arg_aux *ctx_arg_info;
	void *priv_stack_ptr;
	struct mutex dst_mutex;
	struct bpf_prog *dst_prog;
	struct bpf_trampoline *dst_trampoline;
	enum bpf_prog_type saved_dst_prog_type;
	enum bpf_attach_type saved_dst_attach_type;
	bool verifier_zext;
	bool dev_bound;
	bool offload_requested;
	bool attach_btf_trace;
	bool attach_tracing_prog;
	bool func_proto_unreliable;
	bool tail_call_reachable;
	bool xdp_has_frags;
	bool exception_cb;
	bool exception_boundary;
	bool is_extended;
	bool jits_use_priv_stack;
	bool priv_stack_requested;
	bool changes_pkt_data;
	bool might_sleep;
	u64 prog_array_member_cnt;
	struct mutex ext_mutex;
	struct bpf_arena *arena;
	void (*recursion_detected)(struct bpf_prog *);
	const struct btf_type *attach_func_proto;
	const char *attach_func_name;
	struct bpf_prog **func;
	void *jit_data;
	struct bpf_jit_poke_descriptor *poke_tab;
	struct bpf_kfunc_desc_tab *kfunc_tab;
	struct bpf_kfunc_btf_tab *kfunc_btf_tab;
	u32 size_poke_tab;
	struct bpf_ksym ksym;
	const struct bpf_prog_ops *ops;
	const struct bpf_struct_ops *st_ops;
	struct bpf_map **used_maps;
	struct mutex used_maps_mutex;
	struct btf_mod_pair *used_btfs;
	struct bpf_prog *prog;
	struct user_struct *user;
	long: 32;
	u64 load_time;
	u32 verified_insns;
	int cgroup_atype;
	struct bpf_map *cgroup_storage[2];
	char name[16];
	u64 (*bpf_exception_cb)(u64, u64, u64, u64, u64);
	void *security;
	struct bpf_token *token;
	struct bpf_prog_offload *offload;
	struct btf *btf;
	struct bpf_func_info *func_info;
	struct bpf_func_info_aux *func_info_aux;
	struct bpf_line_info *linfo;
	void **jited_linfo;
	u32 func_info_cnt;
	u32 nr_linfo;
	u32 linfo_idx;
	struct module *mod;
	u32 num_exentries;
	struct exception_table_entry *extable;
	union {
		struct work_struct work;
		struct callback_head rcu;
	};
	long: 32;
};

struct bpf_prog_dummy {
	struct bpf_prog prog;
};

struct bpf_prog_info {
	__u32 type;
	__u32 id;
	__u8 tag[8];
	__u32 jited_prog_len;
	__u32 xlated_prog_len;
	__u64 jited_prog_insns;
	__u64 xlated_prog_insns;
	__u64 load_time;
	__u32 created_by_uid;
	__u32 nr_map_ids;
	__u64 map_ids;
	char name[16];
	__u32 ifindex;
	__u32 gpl_compatible: 1;
	__u64 netns_dev;
	__u64 netns_ino;
	__u32 nr_jited_ksyms;
	__u32 nr_jited_func_lens;
	__u64 jited_ksyms;
	__u64 jited_func_lens;
	__u32 btf_id;
	__u32 func_info_rec_size;
	__u64 func_info;
	__u32 nr_func_info;
	__u32 nr_line_info;
	__u64 line_info;
	__u64 jited_line_info;
	__u32 nr_jited_line_info;
	__u32 line_info_rec_size;
	__u32 jited_line_info_rec_size;
	__u32 nr_prog_tags;
	__u64 prog_tags;
	__u64 run_time_ns;
	__u64 run_cnt;
	__u64 recursion_misses;
	__u32 verified_insns;
	__u32 attach_btf_obj_id;
	__u32 attach_btf_id;
	long: 32;
};

struct bpf_prog_kstats {
	u64 nsecs;
	u64 cnt;
	u64 misses;
};

struct bpf_prog_list {
	struct hlist_node node;
	struct bpf_prog *prog;
	struct bpf_cgroup_link *link;
	struct bpf_cgroup_storage *storage[2];
	u32 flags;
};

struct bpf_prog_offload {
	struct bpf_prog *prog;
	struct net_device *netdev;
	struct bpf_offload_dev *offdev;
	void *dev_priv;
	struct list_head offloads;
	bool dev_state;
	bool opt_failed;
	void *jited_image;
	u32 jited_len;
};

struct bpf_prog_offload_ops {
	int (*insn_hook)(struct bpf_verifier_env *, int, int);
	int (*finalize)(struct bpf_verifier_env *);
	int (*replace_insn)(struct bpf_verifier_env *, u32, struct bpf_insn *);
	int (*remove_insns)(struct bpf_verifier_env *, u32, u32);
	int (*prepare)(struct bpf_prog *);
	int (*translate)(struct bpf_prog *);
	void (*destroy)(struct bpf_prog *);
};

struct bpf_prog_ops {
	int (*test_run)(struct bpf_prog *, const union bpf_attr *, union bpf_attr *);
};

struct bpf_prog_pack {
	struct list_head list;
	void *ptr;
	long unsigned int bitmap[0];
};

struct bpf_prog_stats {
	u64_stats_t cnt;
	u64_stats_t nsecs;
	u64_stats_t misses;
	struct u64_stats_sync syncp;
	long: 32;
};

typedef struct qspinlock rqspinlock_t;

struct bpf_queue_stack {
	struct bpf_map map;
	rqspinlock_t lock;
	u32 head;
	u32 tail;
	u32 size;
	char elements[0];
};

struct tracepoint;

struct bpf_raw_event_map {
	struct tracepoint *tp;
	void *bpf_func;
	u32 num_args;
	u32 writable_size;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bpf_raw_tp_link {
	struct bpf_link link;
	struct bpf_raw_event_map *btp;
	long: 32;
	u64 cookie;
};

struct bpf_raw_tp_null_args {
	const char *func;
	long: 32;
	u64 mask;
};

struct bpf_raw_tp_regs {
	struct pt_regs regs[3];
};

struct bpf_raw_tp_test_run_info {
	struct bpf_prog *prog;
	void *ctx;
	u32 retval;
};

struct bpf_rb_node {
	__u64 __opaque[4];
};

struct bpf_rb_node_kern {
	struct rb_node rb_node;
	void *owner;
};

struct bpf_rb_root {
	__u64 __opaque[2];
};

struct bpf_redir_neigh {
	__u32 nh_family;
	union {
		__be32 ipv4_nh;
		__u32 ipv6_nh[4];
	};
};

struct bpf_refcount {
	__u32 __opaque[1];
};

struct bpf_reference_state {
	enum ref_state_type type;
	int id;
	int insn_idx;
	void *ptr;
};

struct bpf_reg_types {
	const enum bpf_reg_type types[10];
	u32 *btf_id;
};

struct bpf_res_spin_lock {
	u32 val;
};

struct bpf_ringbuf {
	wait_queue_head_t waitq;
	struct irq_work work;
	long: 32;
	u64 mask;
	struct page **pages;
	int nr_pages;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	rqspinlock_t spinlock;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	atomic_t busy;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long unsigned int consumer_pos;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long unsigned int producer_pos;
	long unsigned int pending_pos;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	char data[0];
};

struct bpf_ringbuf_hdr {
	u32 len;
	u32 pg_off;
};

struct bpf_ringbuf_map {
	struct bpf_map map;
	struct bpf_ringbuf *rb;
	long: 32;
};

struct bpf_sanitize_info {
	struct bpf_insn_aux_data aux;
	bool mask_to_left;
	long: 32;
};

struct bpf_session_run_ctx {
	struct bpf_run_ctx run_ctx;
	bool is_return;
	void *data;
};

struct sk_psock_progs {
	struct bpf_prog *msg_parser;
	struct bpf_prog *stream_parser;
	struct bpf_prog *stream_verdict;
	struct bpf_prog *skb_verdict;
	struct bpf_link *msg_parser_link;
	struct bpf_link *stream_parser_link;
	struct bpf_link *stream_verdict_link;
	struct bpf_link *skb_verdict_link;
};

struct bpf_shtab_bucket;

struct bpf_shtab {
	struct bpf_map map;
	struct bpf_shtab_bucket *buckets;
	u32 buckets_num;
	u32 elem_size;
	struct sk_psock_progs progs;
	atomic_t count;
};

struct bpf_shtab_bucket {
	struct hlist_head head;
	spinlock_t lock;
};

struct bpf_shtab_elem {
	struct callback_head rcu;
	u32 hash;
	struct sock *sk;
	struct hlist_node node;
	u8 key[0];
};

struct bpf_sk_storage_diag {
	u32 nr_maps;
	struct bpf_map *maps[0];
};

struct qdisc_skb_cb {
	struct {
		unsigned int pkt_len;
		u16 slave_dev_queue_mapping;
		u16 tc_classid;
	};
	unsigned char data[20];
};

struct bpf_skb_data_end {
	struct qdisc_skb_cb qdisc_cb;
	void *data_meta;
	void *data_end;
};

struct bpf_sock_tuple {
	union {
		struct {
			__be32 saddr;
			__be32 daddr;
			__be16 sport;
			__be16 dport;
		} ipv4;
		struct {
			__be32 saddr[4];
			__be32 daddr[4];
			__be16 sport;
			__be16 dport;
		} ipv6;
	};
};

struct bpf_sockopt_buf {
	u8 data[32];
};

struct bpf_stab {
	struct bpf_map map;
	struct sock **sks;
	struct sk_psock_progs progs;
	spinlock_t lock;
};

struct bpf_stack_build_id {
	__s32 status;
	unsigned char build_id[20];
	union {
		__u64 offset;
		__u64 ip;
	};
};

struct stack_map_bucket;

struct bpf_stack_map {
	struct bpf_map map;
	void *elems;
	struct pcpu_freelist freelist;
	u32 n_buckets;
	struct stack_map_bucket *buckets[0];
	long: 32;
};

struct bpf_stack_state {
	struct bpf_reg_state spilled_ptr;
	u8 slot_type[8];
};

struct bpf_storage_buffer {
	struct callback_head rcu;
	char data[0];
};

struct bpf_verifier_ops;

struct btf_member;

struct bpf_struct_ops {
	const struct bpf_verifier_ops *verifier_ops;
	int (*init)(struct btf *);
	int (*check_member)(const struct btf_type *, const struct btf_member *, const struct bpf_prog *);
	int (*init_member)(const struct btf_type *, const struct btf_member *, void *, const void *);
	int (*reg)(void *, struct bpf_link *);
	void (*unreg)(void *, struct bpf_link *);
	int (*update)(void *, void *, struct bpf_link *);
	int (*validate)(void *);
	void *cfi_stubs;
	struct module *owner;
	const char *name;
	struct btf_func_model func_models[64];
};

struct bpf_struct_ops_arg_info {
	struct bpf_ctx_arg_aux *info;
	u32 cnt;
};

struct bpf_struct_ops_common_value {
	refcount_t refcnt;
	enum bpf_struct_ops_state state;
};

struct bpf_struct_ops_bpf_dummy_ops {
	struct bpf_struct_ops_common_value common;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct bpf_dummy_ops data;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bpf_struct_ops_desc {
	struct bpf_struct_ops *st_ops;
	const struct btf_type *type;
	const struct btf_type *value_type;
	u32 type_id;
	u32 value_id;
	struct bpf_struct_ops_arg_info *arg_info;
};

struct bpf_struct_ops_link {
	struct bpf_link link;
	struct bpf_map *map;
	wait_queue_head_t wait_hup;
};

struct bpf_struct_ops_value {
	struct bpf_struct_ops_common_value common;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	char data[0];
};

struct bpf_struct_ops_map {
	struct bpf_map map;
	const struct bpf_struct_ops_desc *st_ops_desc;
	struct mutex lock;
	struct bpf_link **links;
	struct bpf_ksym **ksyms;
	u32 funcs_cnt;
	u32 image_pages_cnt;
	void *image_pages[8];
	struct btf *btf;
	struct bpf_struct_ops_value *uvalue;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct bpf_struct_ops_value kvalue;
};

struct scx_cpu_acquire_args;

struct scx_cpu_release_args;

struct scx_init_task_args;

struct scx_exit_task_args;

struct scx_dump_ctx;

struct scx_cgroup_init_args;

struct scx_exit_info;

struct sched_ext_ops {
	s32 (*select_cpu)(struct task_struct *, s32, u64);
	void (*enqueue)(struct task_struct *, u64);
	void (*dequeue)(struct task_struct *, u64);
	void (*dispatch)(s32, struct task_struct *);
	void (*tick)(struct task_struct *);
	void (*runnable)(struct task_struct *, u64);
	void (*running)(struct task_struct *);
	void (*stopping)(struct task_struct *, bool);
	void (*quiescent)(struct task_struct *, u64);
	bool (*yield)(struct task_struct *, struct task_struct *);
	bool (*core_sched_before)(struct task_struct *, struct task_struct *);
	void (*set_weight)(struct task_struct *, u32);
	void (*set_cpumask)(struct task_struct *, const struct cpumask *);
	void (*update_idle)(s32, bool);
	void (*cpu_acquire)(s32, struct scx_cpu_acquire_args *);
	void (*cpu_release)(s32, struct scx_cpu_release_args *);
	s32 (*init_task)(struct task_struct *, struct scx_init_task_args *);
	void (*exit_task)(struct task_struct *, struct scx_exit_task_args *);
	void (*enable)(struct task_struct *);
	void (*disable)(struct task_struct *);
	void (*dump)(struct scx_dump_ctx *);
	void (*dump_cpu)(struct scx_dump_ctx *, s32, bool);
	void (*dump_task)(struct scx_dump_ctx *, struct task_struct *);
	s32 (*cgroup_init)(struct cgroup *, struct scx_cgroup_init_args *);
	void (*cgroup_exit)(struct cgroup *);
	s32 (*cgroup_prep_move)(struct task_struct *, struct cgroup *, struct cgroup *);
	void (*cgroup_move)(struct task_struct *, struct cgroup *, struct cgroup *);
	void (*cgroup_cancel_move)(struct task_struct *, struct cgroup *, struct cgroup *);
	void (*cgroup_set_weight)(struct cgroup *, u32);
	void (*cpu_online)(s32);
	void (*cpu_offline)(s32);
	s32 (*init)(void);
	void (*exit)(struct scx_exit_info *);
	u32 dispatch_max_batch;
	u64 flags;
	u32 timeout_ms;
	u32 exit_dump_len;
	u64 hotplug_seq;
	char name[128];
	void *priv;
	long: 32;
};

struct bpf_struct_ops_sched_ext_ops {
	struct bpf_struct_ops_common_value common;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct sched_ext_ops data;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct rate_sample;

union tcp_cc_info;

struct tcp_congestion_ops {
	u32 (*ssthresh)(struct sock *);
	void (*cong_avoid)(struct sock *, u32, u32);
	void (*set_state)(struct sock *, u8);
	void (*cwnd_event)(struct sock *, enum tcp_ca_event);
	void (*in_ack_event)(struct sock *, u32);
	void (*pkts_acked)(struct sock *, const struct ack_sample *);
	u32 (*min_tso_segs)(struct sock *);
	void (*cong_control)(struct sock *, u32, int, const struct rate_sample *);
	u32 (*undo_cwnd)(struct sock *);
	u32 (*sndbuf_expand)(struct sock *);
	size_t (*get_info)(struct sock *, u32, int *, union tcp_cc_info *);
	char name[16];
	struct module *owner;
	struct list_head list;
	u32 key;
	u32 flags;
	void (*init)(struct sock *);
	void (*release)(struct sock *);
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bpf_struct_ops_tcp_congestion_ops {
	struct bpf_struct_ops_common_value common;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct tcp_congestion_ops data;
};

struct bpf_subprog_arg_info {
	enum bpf_arg_type arg_type;
	union {
		u32 mem_size;
		u32 btf_id;
	};
};

struct bpf_subprog_info {
	u32 start;
	u32 linfo_idx;
	u16 stack_depth;
	u16 stack_extra;
	s16 fastcall_stack_off;
	bool has_tail_call: 1;
	bool tail_call_reachable: 1;
	bool has_ld_abs: 1;
	bool is_cb: 1;
	bool is_async_cb: 1;
	bool is_exception_cb: 1;
	bool args_cached: 1;
	bool keep_fastcall_stack: 1;
	bool changes_pkt_data: 1;
	bool might_sleep: 1;
	enum priv_stack_mode priv_stack_mode;
	u8 arg_cnt;
	struct bpf_subprog_arg_info args[5];
};

struct seq_net_private {
	struct net *net;
	netns_tracker ns_tracker;
};

struct tcp_iter_state {
	struct seq_net_private p;
	enum tcp_seq_states state;
	struct sock *syn_wait_sk;
	int bucket;
	int offset;
	int sbucket;
	int num;
	long: 32;
	loff_t last_pos;
};

struct bpf_tcp_iter_state {
	struct tcp_iter_state state;
	unsigned int cur_sk;
	unsigned int end_sk;
	unsigned int max_sk;
	struct sock **batch;
	bool st_bucket_done;
	long: 32;
};

struct bpf_tcp_req_attrs {
	u32 rcv_tsval;
	u32 rcv_tsecr;
	u16 mss;
	u8 rcv_wscale;
	u8 snd_wscale;
	u8 ecn_ok;
	u8 wscale_ok;
	u8 sack_ok;
	u8 tstamp_ok;
	u8 usec_ts_ok;
	u8 reserved[3];
};

struct bpf_tcp_sock {
	__u32 snd_cwnd;
	__u32 srtt_us;
	__u32 rtt_min;
	__u32 snd_ssthresh;
	__u32 rcv_nxt;
	__u32 snd_nxt;
	__u32 snd_una;
	__u32 mss_cache;
	__u32 ecn_flags;
	__u32 rate_delivered;
	__u32 rate_interval_us;
	__u32 packets_out;
	__u32 retrans_out;
	__u32 total_retrans;
	__u32 segs_in;
	__u32 data_segs_in;
	__u32 segs_out;
	__u32 data_segs_out;
	__u32 lost_out;
	__u32 sacked_out;
	__u64 bytes_received;
	__u64 bytes_acked;
	__u32 dsack_dups;
	__u32 delivered;
	__u32 delivered_ce;
	__u32 icsk_retransmits;
};

struct bpf_test_timer {
	enum {
		NO_PREEMPT = 0,
		NO_MIGRATE = 1,
	} mode;
	u32 i;
	u64 time_start;
	u64 time_spent;
};

struct bpf_throw_ctx {
	struct bpf_prog_aux *aux;
	long: 32;
	u64 sp;
	u64 bp;
	int cnt;
	long: 32;
};

struct bpf_timed_may_goto {
	u64 count;
	u64 timestamp;
};

struct bpf_timer {
	__u64 __opaque[2];
};

struct user_namespace;

struct bpf_token {
	struct work_struct work;
	atomic64_t refcnt;
	struct user_namespace *userns;
	long: 32;
	u64 allowed_cmds;
	u64 allowed_maps;
	u64 allowed_progs;
	u64 allowed_attachs;
	void *security;
	long: 32;
};

struct bpf_trace_module {
	struct module *module;
	struct list_head list;
};

struct bpf_trace_run_ctx {
	struct bpf_run_ctx run_ctx;
	u64 bpf_cookie;
	bool is_uprobe;
	long: 32;
};

union perf_sample_weight {
	__u64 full;
	struct {
		__u32 var1_dw;
		__u16 var2_w;
		__u16 var3_w;
	};
};

union perf_mem_data_src {
	__u64 val;
	struct {
		__u64 mem_op: 5;
		__u64 mem_lvl: 14;
		__u64 mem_snoop: 5;
		__u64 mem_lock: 2;
		__u64 mem_dtlb: 7;
		__u64 mem_lvl_num: 4;
		__u64 mem_remote: 1;
		__u64 mem_snoopx: 2;
		__u64 mem_blk: 3;
		__u64 mem_hops: 3;
		__u64 mem_rsvd: 18;
	};
};

struct perf_regs {
	__u64 abi;
	struct pt_regs *regs;
	long: 32;
};

struct perf_callchain_entry;

struct perf_raw_record;

struct perf_branch_stack;

struct perf_sample_data {
	u64 sample_flags;
	u64 period;
	u64 dyn_size;
	u64 type;
	struct {
		u32 pid;
		u32 tid;
	} tid_entry;
	u64 time;
	u64 id;
	struct {
		u32 cpu;
		u32 reserved;
	} cpu_entry;
	u64 ip;
	struct perf_callchain_entry *callchain;
	struct perf_raw_record *raw;
	struct perf_branch_stack *br_stack;
	u64 *br_stack_cntr;
	union perf_sample_weight weight;
	union perf_mem_data_src data_src;
	u64 txn;
	struct perf_regs regs_user;
	struct perf_regs regs_intr;
	u64 stack_user_size;
	u64 stream_id;
	u64 cgroup;
	u64 addr;
	u64 phys_addr;
	u64 data_page_size;
	u64 code_page_size;
	u64 aux_size;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
};

struct bpf_trace_sample_data {
	struct perf_sample_data sds[3];
};

struct bpf_tramp_link {
	struct bpf_link link;
	struct hlist_node tramp_hlist;
	u64 cookie;
};

struct bpf_tracing_link {
	struct bpf_tramp_link link;
	enum bpf_attach_type attach_type;
	struct bpf_trampoline *trampoline;
	struct bpf_prog *tgt_prog;
	long: 32;
};

struct bpf_tramp_image {
	void *image;
	int size;
	struct bpf_ksym ksym;
	struct percpu_ref pcref;
	void *ip_after_call;
	void *ip_epilogue;
	union {
		struct callback_head rcu;
		struct work_struct work;
	};
};

struct bpf_tramp_links {
	struct bpf_tramp_link *links[38];
	int nr_links;
};

struct bpf_tramp_run_ctx {
	struct bpf_run_ctx run_ctx;
	u64 bpf_cookie;
	struct bpf_run_ctx *saved_run_ctx;
	long: 32;
};

struct ftrace_ops;

struct bpf_trampoline {
	struct hlist_node hlist;
	struct ftrace_ops *fops;
	struct mutex mutex;
	refcount_t refcnt;
	u32 flags;
	long: 32;
	u64 key;
	struct {
		struct btf_func_model model;
		void *addr;
		bool ftrace_managed;
	} func;
	struct bpf_prog *extension_prog;
	struct hlist_head progs_hlist[3];
	int progs_cnt[3];
	struct bpf_tramp_image *cur_image;
	long: 32;
};

struct bpf_tunnel_key {
	__u32 tunnel_id;
	union {
		__u32 remote_ipv4;
		__u32 remote_ipv6[4];
	};
	__u8 tunnel_tos;
	__u8 tunnel_ttl;
	union {
		__u16 tunnel_ext;
		__be16 tunnel_flags;
	};
	__u32 tunnel_label;
	union {
		__u32 local_ipv4;
		__u32 local_ipv6[4];
	};
};

struct bpf_tuple {
	struct bpf_prog *prog;
	struct bpf_link *link;
};

union bpf_udp_iter_batch_item {
	struct sock *sk;
	__u64 cookie;
};

struct udp_iter_state {
	struct seq_net_private p;
	int bucket;
};

struct bpf_udp_iter_state {
	struct udp_iter_state state;
	unsigned int cur_sk;
	unsigned int end_sk;
	unsigned int max_sk;
	union bpf_udp_iter_batch_item *batch;
};

struct bpf_unix_iter_state {
	struct seq_net_private p;
	unsigned int cur_sk;
	unsigned int end_sk;
	unsigned int max_sk;
	struct sock **batch;
	bool st_bucket_done;
};

struct uprobe_consumer {
	int (*handler)(struct uprobe_consumer *, struct pt_regs *, __u64 *);
	int (*ret_handler)(struct uprobe_consumer *, long unsigned int, struct pt_regs *, __u64 *);
	bool (*filter)(struct uprobe_consumer *, struct mm_struct *);
	struct list_head cons_node;
	long: 32;
	__u64 id;
};

struct bpf_uprobe_multi_link;

struct uprobe;

struct bpf_uprobe {
	struct bpf_uprobe_multi_link *link;
	long: 32;
	loff_t offset;
	long unsigned int ref_ctr_offset;
	long: 32;
	u64 cookie;
	struct uprobe *uprobe;
	long: 32;
	struct uprobe_consumer consumer;
	bool session;
	long: 32;
};

struct bpf_uprobe_multi_link {
	struct path path;
	struct bpf_link link;
	u32 cnt;
	u32 flags;
	struct bpf_uprobe *uprobes;
	struct task_struct *task;
};

struct bpf_uprobe_multi_run_ctx {
	struct bpf_session_run_ctx session_ctx;
	long unsigned int entry_ip;
	struct bpf_uprobe *uprobe;
};

struct btf_mod_pair {
	struct btf *btf;
	struct module *module;
};

struct bpf_verifier_log {
	u64 start_pos;
	u64 end_pos;
	char *ubuf;
	u32 level;
	u32 len_total;
	u32 len_max;
	char kbuf[1024];
};

struct bpf_verifier_stack_elem;

struct bpf_verifier_state;

struct bpf_verifier_env {
	u32 insn_idx;
	u32 prev_insn_idx;
	struct bpf_prog *prog;
	const struct bpf_verifier_ops *ops;
	struct module *attach_btf_mod;
	struct bpf_verifier_stack_elem *head;
	int stack_size;
	bool strict_alignment;
	bool test_state_freq;
	bool test_reg_invariants;
	struct bpf_verifier_state *cur_state;
	struct list_head *explored_states;
	struct list_head free_list;
	struct bpf_map *used_maps[64];
	struct btf_mod_pair used_btfs[64];
	u32 used_map_cnt;
	u32 used_btf_cnt;
	u32 id_gen;
	u32 hidden_subprog_cnt;
	int exception_callback_subprog;
	bool explore_alu_limits;
	bool allow_ptr_leaks;
	bool allow_uninit_stack;
	bool bpf_capable;
	bool bypass_spec_v1;
	bool bypass_spec_v4;
	bool seen_direct_write;
	bool seen_exception;
	struct bpf_insn_aux_data *insn_aux_data;
	const struct bpf_line_info *prev_linfo;
	long: 32;
	struct bpf_verifier_log log;
	struct bpf_subprog_info subprog_info[258];
	union {
		struct bpf_idmap idmap_scratch;
		struct bpf_idset idset_scratch;
	};
	struct {
		int *insn_state;
		int *insn_stack;
		int *insn_postorder;
		int cur_stack;
		int cur_postorder;
	} cfg;
	struct backtrack_state bt;
	struct bpf_insn_hist_entry *insn_hist;
	struct bpf_insn_hist_entry *cur_hist_ent;
	u32 insn_hist_cap;
	u32 pass_cnt;
	u32 subprog_cnt;
	u32 prev_insn_processed;
	u32 insn_processed;
	u32 prev_jmps_processed;
	u32 jmps_processed;
	long: 32;
	u64 verification_time;
	u32 max_states_per_insn;
	u32 total_states;
	u32 peak_states;
	u32 longest_mark_read_walk;
	u32 free_list_size;
	u32 explored_states_size;
	bpfptr_t fd_array;
	u32 scratched_regs;
	long: 32;
	u64 scratched_stack_slots;
	u64 prev_log_pos;
	u64 prev_insn_print_pos;
	struct bpf_reg_state fake_reg[2];
	char tmp_str_buf[320];
	struct bpf_insn insn_buf[32];
	struct bpf_insn epilogue_buf[32];
};

struct bpf_verifier_ops {
	const struct bpf_func_proto * (*get_func_proto)(enum bpf_func_id, const struct bpf_prog *);
	bool (*is_valid_access)(int, int, enum bpf_access_type, const struct bpf_prog *, struct bpf_insn_access_aux *);
	int (*gen_prologue)(struct bpf_insn *, bool, const struct bpf_prog *);
	int (*gen_epilogue)(struct bpf_insn *, const struct bpf_prog *, s16);
	int (*gen_ld_abs)(const struct bpf_insn *, struct bpf_insn *);
	u32 (*convert_ctx_access)(enum bpf_access_type, const struct bpf_insn *, struct bpf_insn *, struct bpf_prog *, u32 *);
	int (*btf_struct_access)(struct bpf_verifier_log *, const struct bpf_reg_state *, int, int);
};

struct bpf_verifier_state {
	struct bpf_func_state *frame[8];
	struct bpf_verifier_state *parent;
	struct bpf_reference_state *refs;
	u32 branches;
	u32 insn_idx;
	u32 curframe;
	u32 acquired_refs;
	u32 active_locks;
	u32 active_preempt_locks;
	u32 active_irq_id;
	u32 active_lock_id;
	void *active_lock_ptr;
	bool active_rcu_lock;
	bool speculative;
	bool in_sleepable;
	u32 first_insn_idx;
	u32 last_insn_idx;
	struct bpf_verifier_state *loop_entry;
	u32 insn_hist_start;
	u32 insn_hist_end;
	u32 dfs_depth;
	u32 callback_unroll_depth;
	u32 may_goto_depth;
	u32 used_as_loop_entry;
};

struct bpf_verifier_stack_elem {
	struct bpf_verifier_state st;
	int insn_idx;
	int prev_insn_idx;
	struct bpf_verifier_stack_elem *next;
	u32 log_pos;
};

struct bpf_verifier_state_list {
	struct bpf_verifier_state state;
	struct list_head node;
	u32 miss_cnt;
	u32 hit_cnt: 31;
	u32 in_free_list: 1;
};

struct bpf_work {
	struct bpf_async_cb cb;
	struct work_struct work;
	struct work_struct delete_work;
};

struct bpf_wq {
	__u64 __opaque[2];
};

struct bpf_xdp_link;

struct bpf_xdp_entity {
	struct bpf_prog *prog;
	struct bpf_xdp_link *link;
};

struct bpf_xdp_link {
	struct bpf_link link;
	struct net_device *dev;
	int flags;
};

struct bpf_xdp_sock {
	__u32 queue_id;
};

struct bpffs_btf_enums {
	const struct btf *btf;
	const struct btf_type *cmd_t;
	const struct btf_type *map_t;
	const struct btf_type *prog_t;
	const struct btf_type *attach_t;
};

struct trace_entry {
	short unsigned int type;
	unsigned char flags;
	unsigned char preempt_count;
	int pid;
};

struct bprint_entry {
	struct trace_entry ent;
	long unsigned int ip;
	const char *fmt;
	u32 buf[0];
};

struct bputs_entry {
	struct trace_entry ent;
	long unsigned int ip;
	const char *str;
};

struct bq27xxx_device_info;

struct bq27xxx_access_methods {
	int (*read)(struct bq27xxx_device_info *, u8, bool);
	int (*write)(struct bq27xxx_device_info *, u8, int, bool);
	int (*read_bulk)(struct bq27xxx_device_info *, u8, u8 *, int);
	int (*write_bulk)(struct bq27xxx_device_info *, u8, u8 *, int);
};

struct bq27xxx_reg_cache {
	int capacity;
	int flags;
};

union power_supply_propval {
	int intval;
	const char *strval;
};

struct bq27xxx_dm_reg;

struct power_supply;

struct bq27xxx_device_info {
	struct device *dev;
	enum bq27xxx_chip chip;
	u32 opts;
	const char *name;
	struct bq27xxx_dm_reg *dm_regs;
	u32 unseal_key;
	struct bq27xxx_access_methods bus;
	struct bq27xxx_reg_cache cache;
	int charge_design_full;
	int voltage_min_design;
	int voltage_max_design;
	bool removed;
	long unsigned int last_update;
	union power_supply_propval last_status;
	struct delayed_work work;
	struct power_supply *bat;
	struct list_head list;
	struct mutex lock;
	u8 *regs;
};

struct bq27xxx_dm_buf {
	u8 class;
	u8 block;
	u8 data[32];
	bool has_data;
	bool dirty;
};

struct bq27xxx_dm_reg {
	u8 subclass_id;
	u8 offset;
	u8 bytes;
	u16 min;
	u16 max;
};

struct br_ip {
	union {
		__be32 ip4;
		struct in6_addr ip6;
	} src;
	union {
		__be32 ip4;
		struct in6_addr ip6;
		unsigned char mac_addr[6];
	} dst;
	__be16 proto;
	__u16 vid;
};

struct br_mcast_stats {
	__u64 igmp_v1queries[2];
	__u64 igmp_v2queries[2];
	__u64 igmp_v3queries[2];
	__u64 igmp_leaves[2];
	__u64 igmp_v1reports[2];
	__u64 igmp_v2reports[2];
	__u64 igmp_v3reports[2];
	__u64 igmp_parse_errors;
	__u64 mld_v1queries[2];
	__u64 mld_v2queries[2];
	__u64 mld_leaves[2];
	__u64 mld_v1reports[2];
	__u64 mld_v2reports[2];
	__u64 mld_parse_errors;
	__u64 mcast_bytes[2];
	__u64 mcast_packets[2];
};

struct br_mdb_entry {
	__u32 ifindex;
	__u8 state;
	__u8 flags;
	__u16 vid;
	struct {
		union {
			__be32 ip4;
			struct in6_addr ip6;
			unsigned char mac_addr[6];
		} u;
		__be16 proto;
	} addr;
};

struct br_port_msg {
	__u8 family;
	__u32 ifindex;
};

struct metadata_dst;

struct br_tunnel_info {
	__be64 tunnel_id;
	struct metadata_dst *tunnel_dst;
	long: 32;
};

struct bridge_id {
	unsigned char prio[2];
	unsigned char addr[6];
};

typedef struct bridge_id bridge_id;

struct bridge_mcast_other_query {
	struct timer_list timer;
	struct timer_list delay_timer;
};

struct bridge_mcast_own_query {
	struct timer_list timer;
	u32 startup_sent;
};

struct bridge_mcast_querier {
	struct br_ip addr;
	int port_ifidx;
	seqcount_spinlock_t seq;
};

struct bridge_mcast_stats {
	struct br_mcast_stats mstats;
	struct u64_stats_sync syncp;
	long: 32;
};

struct bridge_stp_xstats {
	__u64 transition_blk;
	__u64 transition_fwd;
	__u64 rx_bpdu;
	__u64 tx_bpdu;
	__u64 rx_tcn;
	__u64 tx_tcn;
};

struct broadcast_sk {
	struct sock *sk;
	struct work_struct work;
};

struct broken_edid {
	u8 manufacturer[4];
	u32 model;
	u32 fix;
};

struct fs_pin {
	wait_queue_head_t wait;
	int done;
	struct hlist_node s_list;
	struct hlist_node m_list;
	void (*kill)(struct fs_pin *);
};

struct bsd_acct_struct {
	struct fs_pin pin;
	atomic_long_t count;
	struct callback_head rcu;
	struct mutex lock;
	bool active;
	bool check_space;
	long unsigned int needcheck;
	struct file *file;
	struct pid_namespace *ns;
	struct work_struct work;
	struct completion done;
	acct_t ac;
};

struct bsg_buffer {
	unsigned int payload_len;
	int sg_cnt;
	struct scatterlist *sg_list;
};

struct cdev {
	struct kobject kobj;
	struct module *owner;
	const struct file_operations *ops;
	struct list_head list;
	dev_t dev;
	unsigned int count;
};

struct sg_io_v4;

typedef int bsg_sg_io_fn(struct request_queue *, struct sg_io_v4 *, bool, unsigned int);

struct bsg_device {
	struct request_queue *queue;
	long: 32;
	struct device device;
	struct cdev cdev;
	int max_queue;
	unsigned int timeout;
	unsigned int reserved_size;
	bsg_sg_io_fn *sg_io_fn;
	long: 32;
};

struct bsg_job {
	struct device *dev;
	struct kref kref;
	unsigned int timeout;
	void *request;
	void *reply;
	unsigned int request_len;
	unsigned int reply_len;
	struct bsg_buffer request_payload;
	struct bsg_buffer reply_payload;
	int result;
	unsigned int reply_payload_rcv_len;
	struct request *bidi_rq;
	struct bio *bidi_bio;
	void *dd_data;
};

typedef int bsg_job_fn(struct bsg_job *);

typedef enum blk_eh_timer_return bsg_timeout_fn(struct request *);

struct bsg_set {
	struct blk_mq_tag_set tag_set;
	struct bsg_device *bd;
	bsg_job_fn *job_fn;
	bsg_timeout_fn *timeout_fn;
};

typedef bool busy_tag_iter_fn(struct request *, void *);

struct bt_iter_data {
	struct blk_mq_hw_ctx *hctx;
	struct request_queue *q;
	busy_tag_iter_fn *fn;
	void *data;
	bool reserved;
};

struct bt_tags_iter_data {
	struct blk_mq_tags *tags;
	busy_tag_iter_fn *fn;
	void *data;
	unsigned int flags;
};

struct btf_header {
	__u16 magic;
	__u8 version;
	__u8 flags;
	__u32 hdr_len;
	__u32 type_off;
	__u32 type_len;
	__u32 str_off;
	__u32 str_len;
};

struct btf_kfunc_set_tab;

struct btf_id_dtor_kfunc_tab;

struct btf_struct_metas;

struct btf_struct_ops_tab;

struct btf {
	void *data;
	struct btf_type **types;
	u32 *resolved_ids;
	u32 *resolved_sizes;
	const char *strings;
	void *nohdr_data;
	struct btf_header hdr;
	u32 nr_types;
	u32 types_size;
	u32 data_size;
	refcount_t refcnt;
	u32 id;
	struct callback_head rcu;
	struct btf_kfunc_set_tab *kfunc_set_tab;
	struct btf_id_dtor_kfunc_tab *dtor_kfunc_tab;
	struct btf_struct_metas *struct_meta_tab;
	struct btf_struct_ops_tab *struct_ops_tab;
	struct btf *base_btf;
	u32 start_id;
	u32 start_str_off;
	char name[60];
	bool kernel_btf;
	__u32 *base_id_map;
};

struct btf_array {
	__u32 type;
	__u32 index_type;
	__u32 nelems;
};

struct btf_decl_tag {
	__s32 component_idx;
};

struct btf_enum {
	__u32 name_off;
	__s32 val;
};

struct btf_enum64 {
	__u32 name_off;
	__u32 val_lo32;
	__u32 val_hi32;
};

typedef void (*btf_dtor_kfunc_t)(void *);

struct btf_field_kptr {
	struct btf *btf;
	struct module *module;
	btf_dtor_kfunc_t dtor;
	u32 btf_id;
};

struct btf_field_graph_root {
	struct btf *btf;
	u32 value_btf_id;
	u32 node_offset;
	struct btf_record *value_rec;
};

struct btf_field {
	u32 offset;
	u32 size;
	enum btf_field_type type;
	union {
		struct btf_field_kptr kptr;
		struct btf_field_graph_root graph_root;
	};
};

struct btf_field_desc {
	int t_off_cnt;
	int t_offs[2];
	int m_sz;
	int m_off_cnt;
	int m_offs[1];
};

struct btf_field_info {
	enum btf_field_type type;
	u32 off;
	union {
		struct {
			u32 type_id;
		} kptr;
		struct {
			const char *node_name;
			u32 value_btf_id;
		} graph_root;
	};
};

struct btf_field_iter {
	struct btf_field_desc desc;
	void *p;
	int m_idx;
	int off_idx;
	int vlen;
};

struct btf_id_dtor_kfunc {
	u32 btf_id;
	u32 kfunc_btf_id;
};

struct btf_id_dtor_kfunc_tab {
	u32 cnt;
	struct btf_id_dtor_kfunc dtors[0];
};

struct btf_id_set {
	u32 cnt;
	u32 ids[0];
};

struct btf_id_set8 {
	u32 cnt;
	u32 flags;
	struct {
		u32 id;
		u32 flags;
	} pairs[0];
};

typedef int (*btf_kfunc_filter_t)(const struct bpf_prog *, u32);

struct btf_kfunc_hook_filter {
	btf_kfunc_filter_t filters[16];
	u32 nr_filters;
};

struct btf_kfunc_id_set {
	struct module *owner;
	struct btf_id_set8 *set;
	btf_kfunc_filter_t filter;
};

struct btf_kfunc_set_tab {
	struct btf_id_set8 *sets[14];
	struct btf_kfunc_hook_filter hook_filters[14];
};

struct btf_verifier_env;

struct resolve_vertex;

struct btf_show;

struct btf_kind_operations {
	s32 (*check_meta)(struct btf_verifier_env *, const struct btf_type *, u32);
	int (*resolve)(struct btf_verifier_env *, const struct resolve_vertex *);
	int (*check_member)(struct btf_verifier_env *, const struct btf_type *, const struct btf_member *, const struct btf_type *);
	int (*check_kflag_member)(struct btf_verifier_env *, const struct btf_type *, const struct btf_member *, const struct btf_type *);
	void (*log_details)(struct btf_verifier_env *, const struct btf_type *);
	void (*show)(const struct btf *, const struct btf_type *, u32, void *, u8, struct btf_show *);
};

struct btf_member {
	__u32 name_off;
	__u32 type;
	__u32 offset;
};

struct btf_module {
	struct list_head list;
	struct module *module;
	struct btf *btf;
	struct bin_attribute *sysfs_attr;
	int flags;
};

struct btf_name_info {
	const char *name;
	bool needs_size: 1;
	unsigned int size: 31;
	__u32 id;
};

struct btf_param {
	__u32 name_off;
	__u32 type;
};

struct btf_ptr {
	void *ptr;
	__u32 type_id;
	__u32 flags;
};

struct btf_record {
	u32 cnt;
	u32 field_mask;
	int spin_lock_off;
	int res_spin_lock_off;
	int timer_off;
	int wq_off;
	int refcount_off;
	struct btf_field fields[0];
};

struct btf_relocate {
	struct btf *btf;
	const struct btf *base_btf;
	const struct btf *dist_base_btf;
	unsigned int nr_base_types;
	unsigned int nr_split_types;
	unsigned int nr_dist_base_types;
	int dist_str_len;
	int base_str_len;
	__u32 *id_map;
	__u32 *str_map;
};

struct btf_sec_info {
	u32 off;
	u32 len;
};

typedef void *va_list;

struct btf_show {
	u64 flags;
	void *target;
	void (*showfn)(struct btf_show *, const char *, va_list);
	const struct btf *btf;
	struct {
		u8 depth;
		u8 depth_to_show;
		u8 depth_check;
		u8 array_member: 1;
		u8 array_terminated: 1;
		u16 array_encoding;
		u32 type_id;
		int status;
		const struct btf_type *type;
		const struct btf_member *member;
		char name[80];
	} state;
	struct {
		u32 size;
		void *head;
		void *data;
		u8 safe[32];
	} obj;
};

struct btf_show_snprintf {
	struct btf_show show;
	int len_left;
	int len;
};

struct btf_struct_meta {
	u32 btf_id;
	struct btf_record *record;
};

struct btf_struct_metas {
	u32 cnt;
	struct btf_struct_meta types[0];
};

struct btf_struct_ops_tab {
	u32 cnt;
	u32 capacity;
	struct bpf_struct_ops_desc ops[0];
};

struct btf_type {
	__u32 name_off;
	__u32 info;
	union {
		__u32 size;
		__u32 type;
	};
};

struct btf_var {
	__u32 linkage;
};

struct btf_var_secinfo {
	__u32 type;
	__u32 offset;
	__u32 size;
};

struct resolve_vertex {
	const struct btf_type *t;
	u32 type_id;
	u16 next_member;
};

struct btf_verifier_env {
	struct btf *btf;
	u8 *visit_states;
	struct resolve_vertex stack[32];
	struct bpf_verifier_log log;
	u32 log_type_id;
	u32 top_stack;
	enum verifier_phase phase;
	enum resolve_mode resolve_mode;
};

struct hlist_nulls_head {
	struct hlist_nulls_node *first;
};

struct bucket {
	struct hlist_nulls_head head;
	rqspinlock_t raw_lock;
};

struct lockdep_map {};

struct rhash_lock_head;

struct bucket_table {
	unsigned int size;
	unsigned int nest;
	u32 hash_rnd;
	struct list_head walkers;
	struct callback_head rcu;
	struct bucket_table *future_tbl;
	struct lockdep_map dep_map;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	struct rhash_lock_head *buckets[0];
};

struct buf_sel_arg {
	struct iovec *iovs;
	size_t out_len;
	size_t max_len;
	short unsigned int nr_iovs;
	short unsigned int mode;
	short unsigned int buf_group;
	short unsigned int partial_map;
};

struct buffer_data_page {
	u64 time_stamp;
	local_t commit;
	unsigned char data[0];
	long: 32;
};

struct buffer_data_read_page {
	unsigned int order;
	struct buffer_data_page *data;
};

typedef void bh_end_io_t(struct buffer_head *, int);

struct buffer_head {
	long unsigned int b_state;
	struct buffer_head *b_this_page;
	union {
		struct page *b_page;
		struct folio *b_folio;
	};
	long: 32;
	sector_t b_blocknr;
	size_t b_size;
	char *b_data;
	struct block_device *b_bdev;
	bh_end_io_t *b_end_io;
	void *b_private;
	struct list_head b_assoc_buffers;
	struct address_space *b_assoc_map;
	atomic_t b_count;
	spinlock_t b_uptodate_lock;
};

struct buffer_page {
	struct list_head list;
	local_t write;
	unsigned int read;
	local_t entries;
	long unsigned int real_end;
	unsigned int order;
	u32 id: 30;
	u32 range: 1;
	struct buffer_data_page *page;
};

struct buffer_ref {
	struct trace_buffer *buffer;
	void *page;
	int cpu;
	refcount_t refcount;
};

struct builtin_fw {
	char *name;
	void *data;
	long unsigned int size;
};

struct bulk_cb_wrap {
	__le32 Signature;
	__u32 Tag;
	__le32 DataTransferLength;
	__u8 Flags;
	__u8 Lun;
	__u8 Length;
	__u8 CDB[16];
};

struct bulk_cs_wrap {
	__le32 Signature;
	__u32 Tag;
	__le32 Residue;
	__u8 Status;
};

struct group_data {
	int limit[21];
	int base[20];
	int permute[258];
	int minLen;
	int maxLen;
};

struct bunzip_data {
	int writeCopies;
	int writePos;
	int writeRunCountdown;
	int writeCount;
	int writeCurrent;
	long int (*fill)(void *, long unsigned int);
	long int inbufCount;
	long int inbufPos;
	unsigned char *inbuf;
	unsigned int inbufBitCount;
	unsigned int inbufBits;
	unsigned int crc32Table[256];
	unsigned int headerCRC;
	unsigned int totalCRC;
	unsigned int writeCRC;
	unsigned int *dbuf;
	unsigned int dbufSize;
	unsigned char selectors[32768];
	struct group_data groups[6];
	int io_error;
	int byteCount[256];
	unsigned char symToByte[256];
	unsigned char mtfSymbol[256];
};

struct bus_attribute {
	struct attribute attr;
	ssize_t (*show)(const struct bus_type *, char *);
	ssize_t (*store)(const struct bus_type *, const char *, size_t);
};

struct bus_dma_region {
	phys_addr_t cpu_start;
	dma_addr_t dma_start;
	u64 size;
};

struct bus_type {
	const char *name;
	const char *dev_name;
	const struct attribute_group **bus_groups;
	const struct attribute_group **dev_groups;
	const struct attribute_group **drv_groups;
	int (*match)(struct device *, const struct device_driver *);
	int (*uevent)(const struct device *, struct kobj_uevent_env *);
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	void (*remove)(struct device *);
	void (*shutdown)(struct device *);
	const struct cpumask * (*irq_get_affinity)(struct device *, unsigned int);
	int (*online)(struct device *);
	int (*offline)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	int (*num_vf)(struct device *);
	int (*dma_configure)(struct device *);
	void (*dma_cleanup)(struct device *);
	const struct dev_pm_ops *pm;
	bool need_parent_lock;
};

struct bvec_iter_all {
	struct bio_vec bv;
	int idx;
	unsigned int done;
};

struct byd_data {
	struct timer_list timer;
	struct psmouse *psmouse;
	s32 abs_x;
	s32 abs_y;
	volatile long unsigned int last_touch_time;
	bool btn_left;
	bool btn_right;
	bool touch;
};

struct c0r_format {
	unsigned int sel: 3;
	unsigned int z: 8;
	unsigned int rd: 5;
	unsigned int rt: 5;
	unsigned int rs: 5;
	unsigned int opcode: 6;
};

struct c_format {
	unsigned int simmediate: 16;
	unsigned int cache: 2;
	unsigned int c_op: 3;
	unsigned int rs: 5;
	unsigned int opcode: 6;
};

struct cache_head;

struct cache_deferred_req {
	struct hlist_node hash;
	struct list_head recent;
	struct cache_head *item;
	void *owner;
	void (*revisit)(struct cache_deferred_req *, int);
};

struct cache_desc {
	unsigned int waysize;
	short unsigned int sets;
	unsigned char ways;
	unsigned char linesz;
	unsigned char waybit;
	unsigned char flags;
};

struct proc_dir_entry;

struct cache_detail {
	struct module *owner;
	int hash_size;
	struct hlist_head *hash_table;
	spinlock_t hash_lock;
	char *name;
	void (*cache_put)(struct kref *);
	int (*cache_upcall)(struct cache_detail *, struct cache_head *);
	void (*cache_request)(struct cache_detail *, struct cache_head *, char **, int *);
	int (*cache_parse)(struct cache_detail *, char *, int);
	int (*cache_show)(struct seq_file *, struct cache_detail *, struct cache_head *);
	void (*warn_no_listener)(struct cache_detail *, int);
	struct cache_head * (*alloc)(void);
	void (*flush)(void);
	int (*match)(struct cache_head *, struct cache_head *);
	void (*init)(struct cache_head *, struct cache_head *);
	void (*update)(struct cache_head *, struct cache_head *);
	time64_t flush_time;
	struct list_head others;
	time64_t nextcheck;
	int entries;
	struct list_head queue;
	atomic_t writers;
	time64_t last_close;
	time64_t last_warn;
	union {
		struct proc_dir_entry *procfs;
		struct dentry *pipefs;
	};
	struct net *net;
};

struct cache_head {
	struct hlist_node cache_list;
	time64_t expiry_time;
	time64_t last_refresh;
	struct kref ref;
	long unsigned int flags;
};

struct cache_queue {
	struct list_head list;
	int reader;
};

struct cache_reader {
	struct cache_queue q;
	int offset;
};

struct cache_req {
	struct cache_deferred_req * (*defer)(struct cache_req *);
	long unsigned int thread_wait;
};

struct cache_request {
	struct cache_queue q;
	struct cache_head *item;
	char *buf;
	int len;
	int readers;
};

struct cache_type_info {
	const char *size_prop;
	const char *line_size_props[2];
	const char *nr_sets_prop;
};

struct cacheinfo {
	unsigned int id;
	enum cache_type type;
	unsigned int level;
	unsigned int coherency_line_size;
	unsigned int number_of_sets;
	unsigned int ways_of_associativity;
	unsigned int physical_line_partition;
	unsigned int size;
	cpumask_t shared_cpu_map;
	unsigned int attributes;
	void *fw_token;
	bool disable_sysfs;
	void *priv;
};

struct cacheline_padding {
	char x[0];
};

struct cachestat {
	__u64 nr_cache;
	__u64 nr_dirty;
	__u64 nr_writeback;
	__u64 nr_evicted;
	__u64 nr_recently_evicted;
};

struct cachestat_range {
	__u64 off;
	__u64 len;
};

struct call_function_data {
	call_single_data_t *csd;
	cpumask_var_t cpumask;
	cpumask_var_t cpumask_ipi;
};

struct call_summary {
	u8 num_params;
	bool is_void;
	bool fastcall;
};

struct cb_process_state;

struct xdr_stream;

struct callback_op {
	__be32 (*process_op)(void *, void *, struct cb_process_state *);
	__be32 (*decode_args)(struct svc_rqst *, struct xdr_stream *, void *);
	__be32 (*encode_res)(struct svc_rqst *, struct xdr_stream *, const void *);
	long int res_maxsize;
};

struct callchain_cpus_entries {
	struct callback_head callback_head;
	struct perf_callchain_entry *cpu_entries[0];
};

struct compact_control;

struct capture_control {
	struct compact_control *cc;
	struct page *page;
};

struct cb_compound_hdr_arg {
	unsigned int taglen;
	const char *tag;
	unsigned int minorversion;
	unsigned int cb_ident;
	unsigned int nops;
};

struct cb_compound_hdr_res {
	__be32 *status;
	unsigned int taglen;
	const char *tag;
	__be32 *nops;
};

struct cb_devicenotifyitem;

struct cb_devicenotifyargs {
	uint32_t ndevs;
	struct cb_devicenotifyitem *devs;
};

struct nfs4_deviceid {
	char data[16];
};

struct cb_devicenotifyitem {
	uint32_t cbd_notify_type;
	uint32_t cbd_layout_type;
	struct nfs4_deviceid cbd_dev_id;
	uint32_t cbd_immediate;
};

struct nfs_fh {
	short unsigned int size;
	unsigned char data[128];
};

struct cb_getattrargs {
	struct nfs_fh fh;
	uint32_t bitmap[3];
};

struct cb_getattrres {
	__be32 status;
	uint32_t bitmap[3];
	uint64_t size;
	uint64_t change_attr;
	struct timespec64 atime;
	struct timespec64 ctime;
	struct timespec64 mtime;
};

struct pnfs_layout_range {
	u32 iomode;
	long: 32;
	u64 offset;
	u64 length;
};

struct nfs4_stateid_struct {
	union {
		char data[16];
		