#ifndef PACKAGE_LIST_MODEL
#define PACKAGE_LIST_MODEL

#include <QAbstractItemModel>
#include <QList>
#include <qlist.h>               // for QList
#include <qnamespace.h>          // for DisplayRole, Orientation, SortOrder
#include <qobjectdefs.h>         // for Q_OBJECT
#include <qstring.h>             // for QString
#include <qvariant.h>            // for QVariant

class PackageListItem;
class QObject;

class PackageListModel : public QAbstractItemModel
{
	Q_OBJECT
public:
	PackageListModel(QObject *parent = nullptr);
	~PackageListModel();

	void setPackages(QList<PackageListItem*>&);

	// Declaration of pure virtual methods to be implemented.
	int columnCount(const QModelIndex& parent = QModelIndex()) const override;
	QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const override;
	QModelIndex index(int row, int column, const QModelIndex& parent = QModelIndex()) const override;
	QModelIndex parent(const QModelIndex& index) const override;
	int rowCount(const QModelIndex& parent = QModelIndex()) const override;
	void sort(int column, Qt::SortOrder order) override;
	
	// Some virtual methods to reimplement.
	
	// Used for the header.
	QVariant headerData (int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const override;
	bool hasChildren(const QModelIndex& parent = QModelIndex()) const override;

	QList<PackageListItem*> packages() const;

private:
	QList<PackageListItem*> m_packages;

	static bool packageLessThan(PackageListItem *p1, PackageListItem *p2);
	static bool packageMoreThan(PackageListItem *p1, PackageListItem *p2);
};

#endif
