/*
 * Copyright (C) 2004-2008  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _IMAGEAPPS_PREVIEW_CENTERING_CLIP_VIEW_H
#define _IMAGEAPPS_PREVIEW_CENTERING_CLIP_VIEW_H

#include <AppKit/NSClipView.h>
#include <AppKit/NSScrollView.h>

/**
 * A customized NSClipView that centers it's document vie
 * instead of shoving it into the corner.
 *
 * Credits:
 * The CenteringClipView is based on an article from bergdesign.com:
 * http://www.bergdesign.com/missing_cocoa_docs/nsclipview.html
 */
@interface CenteringClipView : NSClipView
{
}

- (void) centerDocumentView;
+ (void) configureScrollView: (NSScrollView*)aScrollView;

@end

#endif
