/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import org.apache.bsf.util.DocumentCell;

public class BreakPoint {
    protected int m_brkptId;
    protected int m_lineno;
    protected int m_offset;
    protected boolean m_lineDefined;
    protected DocumentCell m_cell;

    public BreakPoint(DocumentCell documentCell, int n) {
        this.m_cell = documentCell;
        this.m_brkptId = n;
        this.m_lineno = -1;
        this.m_lineDefined = true;
    }

    public boolean isLineDefined() {
        return this.m_lineDefined;
    }

    public int getId() {
        return this.m_brkptId;
    }

    public int getLineNo() {
        if (this.m_lineDefined) {
            return this.m_lineno;
        }
        return -1;
    }

    public int getOffset() {
        if (this.m_lineDefined) {
            return -1;
        }
        return this.m_offset;
    }

    public void setLineNo(int n) {
        this.m_lineno = n;
    }

    public void setOffset(int n) {
        this.m_offset = n;
    }

    public String toString() {
        if (this.m_lineDefined) {
            return "line #" + Integer.toString(this.m_lineno);
        }
        return "offset " + Integer.toString(this.m_offset);
    }
}

