/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.Constants;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;

public class PageContextImpl
extends PageContext {
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "PageContextImpl");
    protected BodyContent[] outs = new BodyContentImpl[0];
    protected int depth = -1;
    protected Servlet servlet;
    protected ServletConfig config;
    protected ServletContext context;
    protected JspFactory factory;
    protected boolean needsSession;
    protected String errorPageURL;
    protected boolean autoFlush;
    protected int bufferSize;
    protected transient Hashtable attributes = new Hashtable(16);
    protected transient ServletRequest request;
    protected transient ServletResponse response;
    protected transient Object page;
    protected transient HttpSession session;
    protected boolean isIncluded;
    protected transient JspWriter out;
    protected transient JspWriterImpl baseOut;

    PageContextImpl(JspFactory factory) {
        this.factory = factory;
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this._initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush);
    }

    void _initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = needsSession;
        this.errorPageURL = errorPageURL;
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.request = request;
        this.response = response;
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        if (needsSession && this.session == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        this.depth = -1;
        if (this.baseOut == null) {
            this.baseOut = this._createOut(bufferSize, autoFlush);
        } else {
            this.baseOut.init(response, bufferSize, autoFlush);
        }
        this.out = this.baseOut;
        if (this.out == null) {
            throw new IllegalStateException("failed initialize JspWriter");
        }
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", request);
        this.setAttribute("javax.servlet.jsp.jspResponse", response);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
        this.isIncluded = request.getAttribute("javax.servlet.include.servlet_path") != null;
    }

    public void release() {
        this.out = this.baseOut;
        try {
            if (this.isIncluded) {
                ((JspWriterImpl)this.out).flushBuffer();
            } else {
                ((JspWriterImpl)this.out).flushBuffer();
            }
        }
        catch (IOException ex) {
            this.loghelper.log("Internal error flushing the buffer in release()");
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.autoFlush = true;
        this.request = null;
        this.response = null;
        this.depth = -1;
        this.baseOut.recycle();
        this.session = null;
        this.attributes.clear();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                return this.session.getAttribute(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw new IllegalArgumentException("unidentified scope");
    }

    public void setAttribute(String name, Object attribute) {
        this.attributes.put(name, attribute);
    }

    public void setAttribute(String name, Object o, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.put(name, o);
                break;
            }
            case 2: {
                this.request.setAttribute(name, o);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                this.session.setAttribute(name, o);
                break;
            }
            case 4: {
                this.context.setAttribute(name, o);
                break;
            }
        }
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
        }
    }

    public int getAttributesScope(String name) {
        if (this.attributes.get(name) != null) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(name) != null) {
            return 3;
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(String name) {
        Object o = this.attributes.get(name);
        if (o != null) {
            return o;
        }
        o = this.request.getAttribute(name);
        if (o != null) {
            return o;
        }
        if (this.session != null && (o = this.session.getAttribute(name)) != null) {
            return o;
        }
        return this.context.getAttribute(name);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.keys();
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session != null) {
                    return this.session.getAttributeNames();
                }
                throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    public void removeAttribute(String name) {
        try {
            this.removeAttribute(name, 1);
            this.removeAttribute(name, 2);
            if (this.session != null) {
                this.removeAttribute(name, 3);
            }
            this.removeAttribute(name, 4);
        }
        catch (Exception ex) {}
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
    }

    public Object getPage() {
        return this.servlet;
    }

    private final String getAbsolutePathRelativeToContext(String relativeUrlPath) {
        String path = relativeUrlPath;
        if (!path.startsWith("/")) {
            String uri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (uri == null) {
                uri = ((HttpServletRequest)this.request).getServletPath();
            }
            String baseURI = uri.substring(0, uri.lastIndexOf(47));
            path = baseURI + '/' + path;
        }
        return path;
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        JspRuntimeLibrary.include((HttpServletRequest)this.request, (HttpServletResponse)this.response, relativeUrlPath, this.out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void forward(String relativeUrlPath) throws ServletException, IOException {
        try {
            this.out.clear();
            if (true) ** GOTO lbl8
        }
        catch (IOException ex) {
            throw new IllegalStateException(Constants.getString("jsp.error.attempt_to_clear_flushed_buffer"));
        }
        do {
            this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
lbl8:
            // 2 sources

        } while (this.response instanceof ServletResponseWrapperInclude);
        path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        includeUri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
        if (includeUri != null) {
            this.request.removeAttribute("javax.servlet.include.servlet_path");
        }
        try {
            this.context.getRequestDispatcher(path).forward(this.request, this.response);
        }
        finally {
            if (includeUri != null) {
                this.request.setAttribute("javax.servlet.include.servlet_path", (Object)includeUri);
            }
            this.request.setAttribute("javax.servlet.forward.seen", (Object)"true");
        }
    }

    public BodyContent pushBody() {
        ++this.depth;
        if (this.depth >= this.outs.length) {
            BodyContentImpl[] newOuts = new BodyContentImpl[this.depth + 1];
            int i = 0;
            while (i < this.outs.length) {
                newOuts[i] = this.outs[i];
                ++i;
            }
            newOuts[this.depth] = new BodyContentImpl(this.out);
            this.outs = newOuts;
        }
        this.outs[this.depth].clearBody();
        this.out = this.outs[this.depth];
        return this.outs[this.depth];
    }

    public JspWriter popBody() {
        --this.depth;
        this.out = this.depth >= 0 ? this.outs[this.depth] : this.baseOut;
        return this.out;
    }

    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    public void handlePageException(Throwable t) throws IOException, ServletException {
        if (t == null) {
            throw new NullPointerException("null Throwable");
        }
        this.request.setAttribute("javax.servlet.jsp.jspException", (Object)t);
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            this.request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
            this.request.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
            this.request.setAttribute("javax.servlet.error.servlet_name", (Object)this.config.getServletName());
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException ise) {
                this.include(this.errorPageURL);
            }
            Object newException = this.request.getAttribute("javax.servlet.error.exception");
            if (newException != null && newException == t) {
                this.request.removeAttribute("javax.servlet.error.exception");
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof JspException) {
                Throwable rootCause = ((JspException)t).getRootCause();
                if (rootCause != null) {
                    throw new ServletException(t.getMessage(), rootCause);
                }
                throw new ServletException(t);
            }
            throw new ServletException(t);
        }
        this.request.removeAttribute("javax.servlet.error.status_code");
        this.request.removeAttribute("javax.servlet.error.request_uri");
        this.request.removeAttribute("javax.servlet.error.status_code");
        this.request.removeAttribute("javax.servlet.jsp.jspException");
    }

    protected JspWriterImpl _createOut(int bufferSize, boolean autoFlush) throws IOException, IllegalArgumentException {
        try {
            return new JspWriterImpl(this.response, bufferSize, autoFlush);
        }
        catch (Throwable t) {
            this.loghelper.log("creating out", t);
            return null;
        }
    }
}

