/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.interval.ia_math;

import net.sourceforge.interval.ia_math.IAException;
import net.sourceforge.interval.ia_math.IAMath;

public class RealInterval
implements Cloneable {
    double lo;
    double hi;

    public RealInterval(double d, double d2) throws IAException {
        if (!(d <= d2)) {
            throw new IAException("RealInterval(x=" + d + ",y=" + d2 + "): must have x<=y");
        }
        this.lo = d;
        this.hi = d2;
    }

    public RealInterval(double d) throws IAException {
        if (!(Double.NEGATIVE_INFINITY < d) || !(d < Double.POSITIVE_INFINITY)) {
            throw new IAException("RealInterval(x): must have -inf<x<inf");
        }
        this.lo = d;
        this.hi = d;
    }

    public RealInterval() {
        this.lo = Double.NEGATIVE_INFINITY;
        this.hi = Double.POSITIVE_INFINITY;
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    public boolean equals(RealInterval realInterval) {
        return this.lo == realInterval.lo && this.hi == realInterval.hi;
    }

    public void intersect(RealInterval realInterval) throws IAException {
        this.lo = Math.max(this.lo, realInterval.lo);
        this.hi = Math.min(this.hi, realInterval.hi);
        if (this.lo <= this.hi) {
            return;
        }
        throw new IAException("this.intersect(X): intersection is empty");
    }

    public void union(RealInterval realInterval) throws IAException {
        this.lo = Math.min(this.lo, realInterval.lo);
        this.hi = Math.max(this.hi, realInterval.hi);
    }

    public boolean nonEmpty() {
        return this.lo <= this.hi;
    }

    public String toString() {
        return this.toString2();
    }

    private String toString1() {
        return new String("[" + this.doubleToString(this.lo) + " , " + this.doubleToString(this.hi) + "]");
    }

    private String toString1a() {
        return new String("[" + new Double(this.lo).toString() + " , " + new Double(this.hi).toString() + "]");
    }

    private String toString2() {
        Double d = new Double((this.lo + this.hi) / 2.0);
        String string = this.doubleToString((this.lo + this.hi) / 2.0);
        String string2 = this.doubleToString(this.hi - d);
        if (Math.abs(d) > (this.hi - this.lo) / 2.0) {
            return new String("(" + string + " +/- " + string2 + ") ");
        }
        return this.toString1();
    }

    private String doubleToString(double d) {
        StringBuffer stringBuffer = new StringBuffer(new Double(d).toString());
        int n = stringBuffer.length();
        int n2 = 1;
        while (n2 < 20 - n) {
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        return new RealInterval(this.lo, this.hi);
    }

    public static RealInterval emptyInterval() {
        RealInterval realInterval = new RealInterval(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        return realInterval;
    }

    public static RealInterval fullInterval() {
        RealInterval realInterval = new RealInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        return realInterval;
    }

    public static void main(String[] stringArray) {
        RealInterval realInterval = new RealInterval(-3.0, -2.0);
        RealInterval realInterval2 = new RealInterval(-6.0, 7.0);
        RealInterval realInterval3 = new RealInterval();
        RealInterval realInterval4 = new RealInterval();
        realInterval3 = IAMath.add(realInterval, realInterval2);
        System.out.println("x = [" + realInterval.lo + " , " + realInterval.hi + "]");
        System.out.println("y = [" + realInterval2.lo + " , " + realInterval2.hi + "]");
        System.out.println("x+y = [" + realInterval3.lo + " , " + realInterval3.hi + "]");
        realInterval4 = IAMath.mul(realInterval, realInterval2);
        System.out.println("x*y = [" + realInterval4.lo + " , " + realInterval4.hi + "]");
    }
}

