#ifndef _HASH_H
#define _HASH_H

struct hashlist {
  char *name;
  void *ptr;
  struct hashlist *next;
};

extern void InitializeHashTable(struct hashlist **tab, int size);
extern int RecurseHashTable(struct hashlist **hashtab, int hashsize,
	int (*func)(struct hashlist *elem));
extern int CountHashTableEntries(struct hashlist *p);
extern int CountHashTableBinsUsed(struct hashlist *p);
extern void HashDelete(char *name, struct hashlist **hashtab, int hashsize);

/* these functions return a pointer to a hash list element */
extern struct hashlist *HashInstall(char *name, struct hashlist **hashtab,
	int hashsize);
extern struct hashlist *HashPtrInstall(char *name, void *ptr, 
				struct hashlist **hashtab, int hashsize);

/* these functions return the ->ptr field of a struct hashlist */
extern void *HashLookup(char *s, struct hashlist **hashtab, int hashsize);
extern void *HashFirst(struct hashlist **hashtab, int hashsize);
extern void *HashNext(struct hashlist **hashtab, int hashsize);

#endif /* _HASH_H */
