/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  amlxml.h

  XML Advanced MAME List format files functions
*/

#ifndef MAMORY_AMLXML_H
#define MAMORY_AMLXML_H

#include <expat.h>
#include <mamory/readinfo.h>
#include <sortbox/sortbox.h>
#define MAX_DEPTH 6 // Root->gamelist->game->dipswitch->dipvalue->name

typedef struct s_XMLUserData
{
  XML_Parser Parser;
  void *StartHandlerStack[MAX_DEPTH];
  void *EndHandlerStack[MAX_DEPTH];
  unsigned int ElementIDStack[MAX_DEPTH];
  int Depth;
  s_SortBox *RomContentsSortBox;
  s_SortBox *GamesSortBox;
  s_GameInfo **TempGames;
  unsigned int NbrTempGames;
  unsigned char *Source;
  unsigned int SourceType;
  unsigned int Type;
  unsigned char *String;
  s_GamesList *GamesList;
  s_GameInfo *GameInfo;
  s_DriverInfo *Driver;
  s_SoundInfo *Sound;
  s_DisplayInfo *Display;
  s_InputInfo *Input;
  s_DipSwitchInfo *DipSwitch;
  s_ChipInfo *Chip;
  s_RomInfo *Rom;
  s_DiskInfo *Disk;
} s_XMLUserData;

int isAMLXMLFile(const char *Path);
s_GamesList *GetGamesListFromAMLXMLFile(unsigned char *File,
					unsigned char *Source,
					unsigned int SourceType);
#endif
