"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reorder = reorder;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
/**
 * Reorder a provided `list`
 * Returns a new array and does not modify the original array
 */
function reorder(_ref) {
  var list = _ref.list,
    startIndex = _ref.startIndex,
    finishIndex = _ref.finishIndex;
  if (startIndex === -1 || finishIndex === -1) {
    return list;
  }
  var result = Array.from(list);
  var _result$splice = result.splice(startIndex, 1),
    _result$splice2 = (0, _slicedToArray2.default)(_result$splice, 1),
    removed = _result$splice2[0];
  result.splice(finishIndex, 0, removed);
  return result;
}