// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pi

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreatePerformanceAnalysisReport = "CreatePerformanceAnalysisReport"

// CreatePerformanceAnalysisReportRequest generates a "aws/request.Request" representing the
// client's request for the CreatePerformanceAnalysisReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePerformanceAnalysisReport for more information on using the CreatePerformanceAnalysisReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePerformanceAnalysisReportRequest method.
//	req, resp := client.CreatePerformanceAnalysisReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/CreatePerformanceAnalysisReport
func (c *PI) CreatePerformanceAnalysisReportRequest(input *CreatePerformanceAnalysisReportInput) (req *request.Request, output *CreatePerformanceAnalysisReportOutput) {
	op := &request.Operation{
		Name:       opCreatePerformanceAnalysisReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePerformanceAnalysisReportInput{}
	}

	output = &CreatePerformanceAnalysisReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePerformanceAnalysisReport API operation for AWS Performance Insights.
//
// Creates a new performance analysis report for a specific time period for
// the DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation CreatePerformanceAnalysisReport for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/CreatePerformanceAnalysisReport
func (c *PI) CreatePerformanceAnalysisReport(input *CreatePerformanceAnalysisReportInput) (*CreatePerformanceAnalysisReportOutput, error) {
	req, out := c.CreatePerformanceAnalysisReportRequest(input)
	return out, req.Send()
}

// CreatePerformanceAnalysisReportWithContext is the same as CreatePerformanceAnalysisReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePerformanceAnalysisReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) CreatePerformanceAnalysisReportWithContext(ctx aws.Context, input *CreatePerformanceAnalysisReportInput, opts ...request.Option) (*CreatePerformanceAnalysisReportOutput, error) {
	req, out := c.CreatePerformanceAnalysisReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePerformanceAnalysisReport = "DeletePerformanceAnalysisReport"

// DeletePerformanceAnalysisReportRequest generates a "aws/request.Request" representing the
// client's request for the DeletePerformanceAnalysisReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePerformanceAnalysisReport for more information on using the DeletePerformanceAnalysisReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePerformanceAnalysisReportRequest method.
//	req, resp := client.DeletePerformanceAnalysisReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DeletePerformanceAnalysisReport
func (c *PI) DeletePerformanceAnalysisReportRequest(input *DeletePerformanceAnalysisReportInput) (req *request.Request, output *DeletePerformanceAnalysisReportOutput) {
	op := &request.Operation{
		Name:       opDeletePerformanceAnalysisReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePerformanceAnalysisReportInput{}
	}

	output = &DeletePerformanceAnalysisReportOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePerformanceAnalysisReport API operation for AWS Performance Insights.
//
// Deletes a performance analysis report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation DeletePerformanceAnalysisReport for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DeletePerformanceAnalysisReport
func (c *PI) DeletePerformanceAnalysisReport(input *DeletePerformanceAnalysisReportInput) (*DeletePerformanceAnalysisReportOutput, error) {
	req, out := c.DeletePerformanceAnalysisReportRequest(input)
	return out, req.Send()
}

// DeletePerformanceAnalysisReportWithContext is the same as DeletePerformanceAnalysisReport with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePerformanceAnalysisReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) DeletePerformanceAnalysisReportWithContext(ctx aws.Context, input *DeletePerformanceAnalysisReportInput, opts ...request.Option) (*DeletePerformanceAnalysisReportOutput, error) {
	req, out := c.DeletePerformanceAnalysisReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDimensionKeys = "DescribeDimensionKeys"

// DescribeDimensionKeysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDimensionKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDimensionKeys for more information on using the DescribeDimensionKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDimensionKeysRequest method.
//	req, resp := client.DescribeDimensionKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys
func (c *PI) DescribeDimensionKeysRequest(input *DescribeDimensionKeysInput) (req *request.Request, output *DescribeDimensionKeysOutput) {
	op := &request.Operation{
		Name:       opDescribeDimensionKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDimensionKeysInput{}
	}

	output = &DescribeDimensionKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDimensionKeys API operation for AWS Performance Insights.
//
// For a specific time period, retrieve the top N dimension keys for a metric.
//
// Each response element returns a maximum of 500 bytes. For larger elements,
// such as SQL statements, only the first 500 bytes are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation DescribeDimensionKeys for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys
func (c *PI) DescribeDimensionKeys(input *DescribeDimensionKeysInput) (*DescribeDimensionKeysOutput, error) {
	req, out := c.DescribeDimensionKeysRequest(input)
	return out, req.Send()
}

// DescribeDimensionKeysWithContext is the same as DescribeDimensionKeys with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDimensionKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) DescribeDimensionKeysWithContext(ctx aws.Context, input *DescribeDimensionKeysInput, opts ...request.Option) (*DescribeDimensionKeysOutput, error) {
	req, out := c.DescribeDimensionKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDimensionKeysPages iterates over the pages of a DescribeDimensionKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDimensionKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeDimensionKeys operation.
//	pageNum := 0
//	err := client.DescribeDimensionKeysPages(params,
//	    func(page *pi.DescribeDimensionKeysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PI) DescribeDimensionKeysPages(input *DescribeDimensionKeysInput, fn func(*DescribeDimensionKeysOutput, bool) bool) error {
	return c.DescribeDimensionKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDimensionKeysPagesWithContext same as DescribeDimensionKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) DescribeDimensionKeysPagesWithContext(ctx aws.Context, input *DescribeDimensionKeysInput, fn func(*DescribeDimensionKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDimensionKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDimensionKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDimensionKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDimensionKeyDetails = "GetDimensionKeyDetails"

// GetDimensionKeyDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetDimensionKeyDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDimensionKeyDetails for more information on using the GetDimensionKeyDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDimensionKeyDetailsRequest method.
//	req, resp := client.GetDimensionKeyDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetDimensionKeyDetails
func (c *PI) GetDimensionKeyDetailsRequest(input *GetDimensionKeyDetailsInput) (req *request.Request, output *GetDimensionKeyDetailsOutput) {
	op := &request.Operation{
		Name:       opGetDimensionKeyDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDimensionKeyDetailsInput{}
	}

	output = &GetDimensionKeyDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDimensionKeyDetails API operation for AWS Performance Insights.
//
// Get the attributes of the specified dimension group for a DB instance or
// data source. For example, if you specify a SQL ID, GetDimensionKeyDetails
// retrieves the full text of the dimension db.sql.statement associated with
// this ID. This operation is useful because GetResourceMetrics and DescribeDimensionKeys
// don't support retrieval of large SQL statement text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation GetDimensionKeyDetails for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetDimensionKeyDetails
func (c *PI) GetDimensionKeyDetails(input *GetDimensionKeyDetailsInput) (*GetDimensionKeyDetailsOutput, error) {
	req, out := c.GetDimensionKeyDetailsRequest(input)
	return out, req.Send()
}

// GetDimensionKeyDetailsWithContext is the same as GetDimensionKeyDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetDimensionKeyDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) GetDimensionKeyDetailsWithContext(ctx aws.Context, input *GetDimensionKeyDetailsInput, opts ...request.Option) (*GetDimensionKeyDetailsOutput, error) {
	req, out := c.GetDimensionKeyDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPerformanceAnalysisReport = "GetPerformanceAnalysisReport"

// GetPerformanceAnalysisReportRequest generates a "aws/request.Request" representing the
// client's request for the GetPerformanceAnalysisReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPerformanceAnalysisReport for more information on using the GetPerformanceAnalysisReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPerformanceAnalysisReportRequest method.
//	req, resp := client.GetPerformanceAnalysisReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetPerformanceAnalysisReport
func (c *PI) GetPerformanceAnalysisReportRequest(input *GetPerformanceAnalysisReportInput) (req *request.Request, output *GetPerformanceAnalysisReportOutput) {
	op := &request.Operation{
		Name:       opGetPerformanceAnalysisReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPerformanceAnalysisReportInput{}
	}

	output = &GetPerformanceAnalysisReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPerformanceAnalysisReport API operation for AWS Performance Insights.
//
// Retrieves the report including the report ID, status, time details, and the
// insights with recommendations. The report status can be RUNNING, SUCCEEDED,
// or FAILED. The insights include the description and recommendation fields.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation GetPerformanceAnalysisReport for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetPerformanceAnalysisReport
func (c *PI) GetPerformanceAnalysisReport(input *GetPerformanceAnalysisReportInput) (*GetPerformanceAnalysisReportOutput, error) {
	req, out := c.GetPerformanceAnalysisReportRequest(input)
	return out, req.Send()
}

// GetPerformanceAnalysisReportWithContext is the same as GetPerformanceAnalysisReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetPerformanceAnalysisReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) GetPerformanceAnalysisReportWithContext(ctx aws.Context, input *GetPerformanceAnalysisReportInput, opts ...request.Option) (*GetPerformanceAnalysisReportOutput, error) {
	req, out := c.GetPerformanceAnalysisReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceMetadata = "GetResourceMetadata"

// GetResourceMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceMetadata for more information on using the GetResourceMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceMetadataRequest method.
//	req, resp := client.GetResourceMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetadata
func (c *PI) GetResourceMetadataRequest(input *GetResourceMetadataInput) (req *request.Request, output *GetResourceMetadataOutput) {
	op := &request.Operation{
		Name:       opGetResourceMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourceMetadataInput{}
	}

	output = &GetResourceMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceMetadata API operation for AWS Performance Insights.
//
// Retrieve the metadata for different features. For example, the metadata might
// indicate that a feature is turned on or off on a specific DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation GetResourceMetadata for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetadata
func (c *PI) GetResourceMetadata(input *GetResourceMetadataInput) (*GetResourceMetadataOutput, error) {
	req, out := c.GetResourceMetadataRequest(input)
	return out, req.Send()
}

// GetResourceMetadataWithContext is the same as GetResourceMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) GetResourceMetadataWithContext(ctx aws.Context, input *GetResourceMetadataInput, opts ...request.Option) (*GetResourceMetadataOutput, error) {
	req, out := c.GetResourceMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceMetrics = "GetResourceMetrics"

// GetResourceMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceMetrics for more information on using the GetResourceMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceMetricsRequest method.
//	req, resp := client.GetResourceMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics
func (c *PI) GetResourceMetricsRequest(input *GetResourceMetricsInput) (req *request.Request, output *GetResourceMetricsOutput) {
	op := &request.Operation{
		Name:       opGetResourceMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceMetricsInput{}
	}

	output = &GetResourceMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceMetrics API operation for AWS Performance Insights.
//
// Retrieve Performance Insights metrics for a set of data sources over a time
// period. You can provide specific dimension groups and dimensions, and provide
// filtering criteria for each group. You must specify an aggregate function
// for each metric.
//
// Each response element returns a maximum of 500 bytes. For larger elements,
// such as SQL statements, only the first 500 bytes are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation GetResourceMetrics for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics
func (c *PI) GetResourceMetrics(input *GetResourceMetricsInput) (*GetResourceMetricsOutput, error) {
	req, out := c.GetResourceMetricsRequest(input)
	return out, req.Send()
}

// GetResourceMetricsWithContext is the same as GetResourceMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) GetResourceMetricsWithContext(ctx aws.Context, input *GetResourceMetricsInput, opts ...request.Option) (*GetResourceMetricsOutput, error) {
	req, out := c.GetResourceMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceMetricsPages iterates over the pages of a GetResourceMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetResourceMetrics operation.
//	pageNum := 0
//	err := client.GetResourceMetricsPages(params,
//	    func(page *pi.GetResourceMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PI) GetResourceMetricsPages(input *GetResourceMetricsInput, fn func(*GetResourceMetricsOutput, bool) bool) error {
	return c.GetResourceMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceMetricsPagesWithContext same as GetResourceMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) GetResourceMetricsPagesWithContext(ctx aws.Context, input *GetResourceMetricsInput, fn func(*GetResourceMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAvailableResourceDimensions = "ListAvailableResourceDimensions"

// ListAvailableResourceDimensionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableResourceDimensions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableResourceDimensions for more information on using the ListAvailableResourceDimensions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAvailableResourceDimensionsRequest method.
//	req, resp := client.ListAvailableResourceDimensionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceDimensions
func (c *PI) ListAvailableResourceDimensionsRequest(input *ListAvailableResourceDimensionsInput) (req *request.Request, output *ListAvailableResourceDimensionsOutput) {
	op := &request.Operation{
		Name:       opListAvailableResourceDimensions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAvailableResourceDimensionsInput{}
	}

	output = &ListAvailableResourceDimensionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableResourceDimensions API operation for AWS Performance Insights.
//
// Retrieve the dimensions that can be queried for each specified metric type
// on a specified DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation ListAvailableResourceDimensions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceDimensions
func (c *PI) ListAvailableResourceDimensions(input *ListAvailableResourceDimensionsInput) (*ListAvailableResourceDimensionsOutput, error) {
	req, out := c.ListAvailableResourceDimensionsRequest(input)
	return out, req.Send()
}

// ListAvailableResourceDimensionsWithContext is the same as ListAvailableResourceDimensions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableResourceDimensions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) ListAvailableResourceDimensionsWithContext(ctx aws.Context, input *ListAvailableResourceDimensionsInput, opts ...request.Option) (*ListAvailableResourceDimensionsOutput, error) {
	req, out := c.ListAvailableResourceDimensionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAvailableResourceDimensionsPages iterates over the pages of a ListAvailableResourceDimensions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAvailableResourceDimensions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAvailableResourceDimensions operation.
//	pageNum := 0
//	err := client.ListAvailableResourceDimensionsPages(params,
//	    func(page *pi.ListAvailableResourceDimensionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PI) ListAvailableResourceDimensionsPages(input *ListAvailableResourceDimensionsInput, fn func(*ListAvailableResourceDimensionsOutput, bool) bool) error {
	return c.ListAvailableResourceDimensionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAvailableResourceDimensionsPagesWithContext same as ListAvailableResourceDimensionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) ListAvailableResourceDimensionsPagesWithContext(ctx aws.Context, input *ListAvailableResourceDimensionsInput, fn func(*ListAvailableResourceDimensionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAvailableResourceDimensionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAvailableResourceDimensionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAvailableResourceDimensionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAvailableResourceMetrics = "ListAvailableResourceMetrics"

// ListAvailableResourceMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableResourceMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableResourceMetrics for more information on using the ListAvailableResourceMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAvailableResourceMetricsRequest method.
//	req, resp := client.ListAvailableResourceMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceMetrics
func (c *PI) ListAvailableResourceMetricsRequest(input *ListAvailableResourceMetricsInput) (req *request.Request, output *ListAvailableResourceMetricsOutput) {
	op := &request.Operation{
		Name:       opListAvailableResourceMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAvailableResourceMetricsInput{}
	}

	output = &ListAvailableResourceMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableResourceMetrics API operation for AWS Performance Insights.
//
// Retrieve metrics of the specified types that can be queried for a specified
// DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation ListAvailableResourceMetrics for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceMetrics
func (c *PI) ListAvailableResourceMetrics(input *ListAvailableResourceMetricsInput) (*ListAvailableResourceMetricsOutput, error) {
	req, out := c.ListAvailableResourceMetricsRequest(input)
	return out, req.Send()
}

// ListAvailableResourceMetricsWithContext is the same as ListAvailableResourceMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableResourceMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) ListAvailableResourceMetricsWithContext(ctx aws.Context, input *ListAvailableResourceMetricsInput, opts ...request.Option) (*ListAvailableResourceMetricsOutput, error) {
	req, out := c.ListAvailableResourceMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAvailableResourceMetricsPages iterates over the pages of a ListAvailableResourceMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAvailableResourceMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAvailableResourceMetrics operation.
//	pageNum := 0
//	err := client.ListAvailableResourceMetricsPages(params,
//	    func(page *pi.ListAvailableResourceMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PI) ListAvailableResourceMetricsPages(input *ListAvailableResourceMetricsInput, fn func(*ListAvailableResourceMetricsOutput, bool) bool) error {
	return c.ListAvailableResourceMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAvailableResourceMetricsPagesWithContext same as ListAvailableResourceMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) ListAvailableResourceMetricsPagesWithContext(ctx aws.Context, input *ListAvailableResourceMetricsInput, fn func(*ListAvailableResourceMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAvailableResourceMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAvailableResourceMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAvailableResourceMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPerformanceAnalysisReports = "ListPerformanceAnalysisReports"

// ListPerformanceAnalysisReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListPerformanceAnalysisReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPerformanceAnalysisReports for more information on using the ListPerformanceAnalysisReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPerformanceAnalysisReportsRequest method.
//	req, resp := client.ListPerformanceAnalysisReportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListPerformanceAnalysisReports
func (c *PI) ListPerformanceAnalysisReportsRequest(input *ListPerformanceAnalysisReportsInput) (req *request.Request, output *ListPerformanceAnalysisReportsOutput) {
	op := &request.Operation{
		Name:       opListPerformanceAnalysisReports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPerformanceAnalysisReportsInput{}
	}

	output = &ListPerformanceAnalysisReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPerformanceAnalysisReports API operation for AWS Performance Insights.
//
// Lists all the analysis reports created for the DB instance. The reports are
// sorted based on the start time of each report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation ListPerformanceAnalysisReports for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListPerformanceAnalysisReports
func (c *PI) ListPerformanceAnalysisReports(input *ListPerformanceAnalysisReportsInput) (*ListPerformanceAnalysisReportsOutput, error) {
	req, out := c.ListPerformanceAnalysisReportsRequest(input)
	return out, req.Send()
}

// ListPerformanceAnalysisReportsWithContext is the same as ListPerformanceAnalysisReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListPerformanceAnalysisReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) ListPerformanceAnalysisReportsWithContext(ctx aws.Context, input *ListPerformanceAnalysisReportsInput, opts ...request.Option) (*ListPerformanceAnalysisReportsOutput, error) {
	req, out := c.ListPerformanceAnalysisReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPerformanceAnalysisReportsPages iterates over the pages of a ListPerformanceAnalysisReports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPerformanceAnalysisReports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPerformanceAnalysisReports operation.
//	pageNum := 0
//	err := client.ListPerformanceAnalysisReportsPages(params,
//	    func(page *pi.ListPerformanceAnalysisReportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PI) ListPerformanceAnalysisReportsPages(input *ListPerformanceAnalysisReportsInput, fn func(*ListPerformanceAnalysisReportsOutput, bool) bool) error {
	return c.ListPerformanceAnalysisReportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPerformanceAnalysisReportsPagesWithContext same as ListPerformanceAnalysisReportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) ListPerformanceAnalysisReportsPagesWithContext(ctx aws.Context, input *ListPerformanceAnalysisReportsInput, fn func(*ListPerformanceAnalysisReportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPerformanceAnalysisReportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPerformanceAnalysisReportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPerformanceAnalysisReportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListTagsForResource
func (c *PI) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Performance Insights.
//
// Retrieves all the metadata tags associated with Amazon RDS Performance Insights
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListTagsForResource
func (c *PI) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/TagResource
func (c *PI) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Performance Insights.
//
// Adds metadata tags to the Amazon RDS Performance Insights resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/TagResource
func (c *PI) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/UntagResource
func (c *PI) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Performance Insights.
//
// Deletes the metadata tags from the Amazon RDS Performance Insights resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     One of the arguments provided is invalid for this request.
//
//   - InternalServiceError
//     The request failed due to an unknown error.
//
//   - NotAuthorizedException
//     The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/UntagResource
func (c *PI) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Retrieves the summary of the performance analysis report created for a time
// period.
type AnalysisReport struct {
	_ struct{} `type:"structure"`

	// The name of the analysis report.
	//
	// AnalysisReportId is a required field
	AnalysisReportId *string `min:"1" type:"string" required:"true"`

	// The time you created the analysis report.
	CreateTime *time.Time `type:"timestamp"`

	// The analysis end time in the report.
	EndTime *time.Time `type:"timestamp"`

	// The unique identifier of the analysis report.
	Identifier *string `type:"string"`

	// The list of identified insights in the analysis report.
	Insights []*Insight `type:"list"`

	// List the tags for the Amazon Web Services service for which Performance Insights
	// returns metrics. Valid values are as follows:
	//
	//    * RDS
	//
	//    * DOCDB
	ServiceType *string `type:"string" enum:"ServiceType"`

	// The analysis start time in the report.
	StartTime *time.Time `type:"timestamp"`

	// The status of the created analysis report.
	Status *string `type:"string" enum:"AnalysisStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisReport) GoString() string {
	return s.String()
}

// SetAnalysisReportId sets the AnalysisReportId field's value.
func (s *AnalysisReport) SetAnalysisReportId(v string) *AnalysisReport {
	s.AnalysisReportId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AnalysisReport) SetCreateTime(v time.Time) *AnalysisReport {
	s.CreateTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AnalysisReport) SetEndTime(v time.Time) *AnalysisReport {
	s.EndTime = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *AnalysisReport) SetIdentifier(v string) *AnalysisReport {
	s.Identifier = &v
	return s
}

// SetInsights sets the Insights field's value.
func (s *AnalysisReport) SetInsights(v []*Insight) *AnalysisReport {
	s.Insights = v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *AnalysisReport) SetServiceType(v string) *AnalysisReport {
	s.ServiceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AnalysisReport) SetStartTime(v time.Time) *AnalysisReport {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalysisReport) SetStatus(v string) *AnalysisReport {
	s.Status = &v
	return s
}

// Retrieves the details of the performance analysis report.
type AnalysisReportSummary struct {
	_ struct{} `type:"structure"`

	// The name of the analysis report.
	AnalysisReportId *string `type:"string"`

	// The time you created the analysis report.
	CreateTime *time.Time `type:"timestamp"`

	// The end time of the analysis in the report.
	EndTime *time.Time `type:"timestamp"`

	// The start time of the analysis in the report.
	StartTime *time.Time `type:"timestamp"`

	// The status of the analysis report.
	Status *string `type:"string" enum:"AnalysisStatus"`

	// List of all the tags added to the analysis report.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisReportSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisReportSummary) GoString() string {
	return s.String()
}

// SetAnalysisReportId sets the AnalysisReportId field's value.
func (s *AnalysisReportSummary) SetAnalysisReportId(v string) *AnalysisReportSummary {
	s.AnalysisReportId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AnalysisReportSummary) SetCreateTime(v time.Time) *AnalysisReportSummary {
	s.CreateTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AnalysisReportSummary) SetEndTime(v time.Time) *AnalysisReportSummary {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AnalysisReportSummary) SetStartTime(v time.Time) *AnalysisReportSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalysisReportSummary) SetStatus(v string) *AnalysisReportSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AnalysisReportSummary) SetTags(v []*Tag) *AnalysisReportSummary {
	s.Tags = v
	return s
}

type CreatePerformanceAnalysisReportInput struct {
	_ struct{} `type:"structure"`

	// The end time defined for the analysis report.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// An immutable, Amazon Web Services Region-unique identifier for a data source.
	// Performance Insights gathers metrics from this data source.
	//
	// To use an Amazon RDS instance as a data source, you specify its DbiResourceId
	// value. For example, specify db-ADECBTYHKTSAUMUZQYPDS2GW4A.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The Amazon Web Services service for which Performance Insights will return
	// metrics. Valid value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`

	// The start time defined for the analysis report.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// The metadata assigned to the analysis report consisting of a key-value pair.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePerformanceAnalysisReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePerformanceAnalysisReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePerformanceAnalysisReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePerformanceAnalysisReportInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *CreatePerformanceAnalysisReportInput) SetEndTime(v time.Time) *CreatePerformanceAnalysisReportInput {
	s.EndTime = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *CreatePerformanceAnalysisReportInput) SetIdentifier(v string) *CreatePerformanceAnalysisReportInput {
	s.Identifier = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *CreatePerformanceAnalysisReportInput) SetServiceType(v string) *CreatePerformanceAnalysisReportInput {
	s.ServiceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreatePerformanceAnalysisReportInput) SetStartTime(v time.Time) *CreatePerformanceAnalysisReportInput {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePerformanceAnalysisReportInput) SetTags(v []*Tag) *CreatePerformanceAnalysisReportInput {
	s.Tags = v
	return s
}

type CreatePerformanceAnalysisReportOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the created analysis report.
	AnalysisReportId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePerformanceAnalysisReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePerformanceAnalysisReportOutput) GoString() string {
	return s.String()
}

// SetAnalysisReportId sets the AnalysisReportId field's value.
func (s *CreatePerformanceAnalysisReportOutput) SetAnalysisReportId(v string) *CreatePerformanceAnalysisReportOutput {
	s.AnalysisReportId = &v
	return s
}

// List of data objects which provide details about source metrics. This field
// can be used to determine the PI metric to render for the insight. This data
// type also includes static values for the metrics for the Insight that were
// calculated and included in text and annotations on the DB load chart.
type Data struct {
	_ struct{} `type:"structure"`

	// This field determines the Performance Insights metric to render for the insight.
	// The name field refers to a Performance Insights metric.
	PerformanceInsightsMetric *PerformanceInsightsMetric `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Data) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Data) GoString() string {
	return s.String()
}

// SetPerformanceInsightsMetric sets the PerformanceInsightsMetric field's value.
func (s *Data) SetPerformanceInsightsMetric(v *PerformanceInsightsMetric) *Data {
	s.PerformanceInsightsMetric = v
	return s
}

// A timestamp, and a single numerical value, which together represent a measurement
// at a particular point in time.
type DataPoint struct {
	_ struct{} `type:"structure"`

	// The time, in epoch format, associated with a particular Value.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`

	// The actual value associated with a particular Timestamp.
	//
	// Value is a required field
	Value *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPoint) GoString() string {
	return s.String()
}

// SetTimestamp sets the Timestamp field's value.
func (s *DataPoint) SetTimestamp(v time.Time) *DataPoint {
	s.Timestamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DataPoint) SetValue(v float64) *DataPoint {
	s.Value = &v
	return s
}

type DeletePerformanceAnalysisReportInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the analysis report for deletion.
	//
	// AnalysisReportId is a required field
	AnalysisReportId *string `min:"1" type:"string" required:"true"`

	// An immutable identifier for a data source that is unique for an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source.
	// In the console, the identifier is shown as ResourceID. When you call DescribeDBInstances,
	// the identifier is returned as DbiResourceId.
	//
	// To use a DB instance as a data source, specify its DbiResourceId value. For
	// example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The Amazon Web Services service for which Performance Insights will return
	// metrics. Valid value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePerformanceAnalysisReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePerformanceAnalysisReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePerformanceAnalysisReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePerformanceAnalysisReportInput"}
	if s.AnalysisReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisReportId"))
	}
	if s.AnalysisReportId != nil && len(*s.AnalysisReportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisReportId", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisReportId sets the AnalysisReportId field's value.
func (s *DeletePerformanceAnalysisReportInput) SetAnalysisReportId(v string) *DeletePerformanceAnalysisReportInput {
	s.AnalysisReportId = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeletePerformanceAnalysisReportInput) SetIdentifier(v string) *DeletePerformanceAnalysisReportInput {
	s.Identifier = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *DeletePerformanceAnalysisReportInput) SetServiceType(v string) *DeletePerformanceAnalysisReportInput {
	s.ServiceType = &v
	return s
}

type DeletePerformanceAnalysisReportOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePerformanceAnalysisReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePerformanceAnalysisReportOutput) GoString() string {
	return s.String()
}

type DescribeDimensionKeysInput struct {
	_ struct{} `type:"structure"`

	// Additional metrics for the top N dimension keys. If the specified dimension
	// group in the GroupBy parameter is db.sql_tokenized, you can specify per-SQL
	// metrics to get the values for the top N SQL digests. The response syntax
	// is as follows: "AdditionalMetrics" : { "string" : "string" }.
	AdditionalMetrics []*string `min:"1" type:"list"`

	// The date and time specifying the end of the requested time series data. The
	// value specified is exclusive, which means that data points less than (but
	// not equal to) EndTime are returned.
	//
	// The value for EndTime must be later than the value for StartTime.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// One or more filters to apply in the request. Restrictions:
	//
	//    * Any number of filters by the same dimension, as specified in the GroupBy
	//    or Partition parameters.
	//
	//    * A single filter for any other dimension in this dimension group.
	Filter map[string]*string `type:"map"`

	// A specification for how to aggregate the data points from a query result.
	// You must specify a valid dimension group. Performance Insights returns all
	// dimensions within this group, unless you provide the names of specific dimensions
	// within this group. You can also request that Performance Insights return
	// a limited number of values for a dimension.
	//
	// GroupBy is a required field
	GroupBy *DimensionGroup `type:"structure" required:"true"`

	// An immutable, Amazon Web Services Region-unique identifier for a data source.
	// Performance Insights gathers metrics from this data source.
	//
	// To use an Amazon RDS instance as a data source, you specify its DbiResourceId
	// value. For example, specify db-FAIHNTYBKTGAUSUZQYPDS2GW4A.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The maximum number of items to return in the response. If more items exist
	// than the specified MaxRecords value, a pagination token is included in the
	// response so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// The name of a Performance Insights metric to be measured.
	//
	// Valid values for Metric are:
	//
	//    * db.load.avg - A scaled representation of the number of active sessions
	//    for the database engine.
	//
	//    * db.sampledload.avg - The raw number of active sessions for the database
	//    engine.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the
	// number of active sessions is greater than the internal threshold, Performance
	// Insights samples the active sessions, with db.load.avg showing the scaled
	// values, db.sampledload.avg showing the raw values, and db.sampledload.avg
	// less than db.load.avg. For most use cases, you can query db.load.avg only.
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`

	// For each dimension specified in GroupBy, specify a secondary dimension to
	// further subdivide the partition keys in the response.
	PartitionBy *DimensionGroup `type:"structure"`

	// The granularity, in seconds, of the data points returned from Performance
	// Insights. A period can be as short as one second, or as long as one day (86400
	// seconds). Valid values are:
	//
	//    * 1 (one second)
	//
	//    * 60 (one minute)
	//
	//    * 300 (five minutes)
	//
	//    * 3600 (one hour)
	//
	//    * 86400 (twenty-four hours)
	//
	// If you don't specify PeriodInSeconds, then Performance Insights chooses a
	// value for you, with a goal of returning roughly 100-200 data points in the
	// response.
	PeriodInSeconds *int64 `type:"integer"`

	// The Amazon Web Services service for which Performance Insights will return
	// metrics. Valid values are as follows:
	//
	//    * RDS
	//
	//    * DOCDB
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`

	// The date and time specifying the beginning of the requested time series data.
	// You must specify a StartTime within the past 7 days. The value specified
	// is inclusive, which means that data points equal to or greater than StartTime
	// are returned.
	//
	// The value for StartTime must be earlier than the value for EndTime.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDimensionKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDimensionKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDimensionKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDimensionKeysInput"}
	if s.AdditionalMetrics != nil && len(s.AdditionalMetrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalMetrics", 1))
	}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.GroupBy == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupBy"))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.GroupBy != nil {
		if err := s.GroupBy.Validate(); err != nil {
			invalidParams.AddNested("GroupBy", err.(request.ErrInvalidParams))
		}
	}
	if s.PartitionBy != nil {
		if err := s.PartitionBy.Validate(); err != nil {
			invalidParams.AddNested("PartitionBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalMetrics sets the AdditionalMetrics field's value.
func (s *DescribeDimensionKeysInput) SetAdditionalMetrics(v []*string) *DescribeDimensionKeysInput {
	s.AdditionalMetrics = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeDimensionKeysInput) SetEndTime(v time.Time) *DescribeDimensionKeysInput {
	s.EndTime = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *DescribeDimensionKeysInput) SetFilter(v map[string]*string) *DescribeDimensionKeysInput {
	s.Filter = v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *DescribeDimensionKeysInput) SetGroupBy(v *DimensionGroup) *DescribeDimensionKeysInput {
	s.GroupBy = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DescribeDimensionKeysInput) SetIdentifier(v string) *DescribeDimensionKeysInput {
	s.Identifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDimensionKeysInput) SetMaxResults(v int64) *DescribeDimensionKeysInput {
	s.MaxResults = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *DescribeDimensionKeysInput) SetMetric(v string) *DescribeDimensionKeysInput {
	s.Metric = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDimensionKeysInput) SetNextToken(v string) *DescribeDimensionKeysInput {
	s.NextToken = &v
	return s
}

// SetPartitionBy sets the PartitionBy field's value.
func (s *DescribeDimensionKeysInput) SetPartitionBy(v *DimensionGroup) *DescribeDimensionKeysInput {
	s.PartitionBy = v
	return s
}

// SetPeriodInSeconds sets the PeriodInSeconds field's value.
func (s *DescribeDimensionKeysInput) SetPeriodInSeconds(v int64) *DescribeDimensionKeysInput {
	s.PeriodInSeconds = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *DescribeDimensionKeysInput) SetServiceType(v string) *DescribeDimensionKeysInput {
	s.ServiceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeDimensionKeysInput) SetStartTime(v time.Time) *DescribeDimensionKeysInput {
	s.StartTime = &v
	return s
}

type DescribeDimensionKeysOutput struct {
	_ struct{} `type:"structure"`

	// The end time for the returned dimension keys, after alignment to a granular
	// boundary (as specified by PeriodInSeconds). AlignedEndTime will be greater
	// than or equal to the value of the user-specified Endtime.
	AlignedEndTime *time.Time `type:"timestamp"`

	// The start time for the returned dimension keys, after alignment to a granular
	// boundary (as specified by PeriodInSeconds). AlignedStartTime will be less
	// than or equal to the value of the user-specified StartTime.
	AlignedStartTime *time.Time `type:"timestamp"`

	// The dimension keys that were requested.
	Keys []*DimensionKeyDescription `type:"list"`

	// A pagination token that indicates the response didn’t return all available
	// records because MaxRecords was specified in the previous request. To get
	// the remaining records, specify NextToken in a separate request with this
	// value.
	NextToken *string `min:"1" type:"string"`

	// If PartitionBy was present in the request, PartitionKeys contains the breakdown
	// of dimension keys by the specified partitions.
	PartitionKeys []*ResponsePartitionKey `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDimensionKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDimensionKeysOutput) GoString() string {
	return s.String()
}

// SetAlignedEndTime sets the AlignedEndTime field's value.
func (s *DescribeDimensionKeysOutput) SetAlignedEndTime(v time.Time) *DescribeDimensionKeysOutput {
	s.AlignedEndTime = &v
	return s
}

// SetAlignedStartTime sets the AlignedStartTime field's value.
func (s *DescribeDimensionKeysOutput) SetAlignedStartTime(v time.Time) *DescribeDimensionKeysOutput {
	s.AlignedStartTime = &v
	return s
}

// SetKeys sets the Keys field's value.
func (s *DescribeDimensionKeysOutput) SetKeys(v []*DimensionKeyDescription) *DescribeDimensionKeysOutput {
	s.Keys = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDimensionKeysOutput) SetNextToken(v string) *DescribeDimensionKeysOutput {
	s.NextToken = &v
	return s
}

// SetPartitionKeys sets the PartitionKeys field's value.
func (s *DescribeDimensionKeysOutput) SetPartitionKeys(v []*ResponsePartitionKey) *DescribeDimensionKeysOutput {
	s.PartitionKeys = v
	return s
}

// The information about a dimension.
type DimensionDetail struct {
	_ struct{} `type:"structure"`

	// The identifier of a dimension.
	Identifier *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionDetail) GoString() string {
	return s.String()
}

// SetIdentifier sets the Identifier field's value.
func (s *DimensionDetail) SetIdentifier(v string) *DimensionDetail {
	s.Identifier = &v
	return s
}

// A logical grouping of Performance Insights metrics for a related subject
// area. For example, the db.sql dimension group consists of the following dimensions:
//
//   - db.sql.id - The hash of a running SQL statement, generated by Performance
//     Insights.
//
//   - db.sql.db_id - Either the SQL ID generated by the database engine, or
//     a value generated by Performance Insights that begins with pi-.
//
//   - db.sql.statement - The full text of the SQL statement that is running,
//     for example, SELECT * FROM employees.
//
//   - db.sql_tokenized.id - The hash of the SQL digest generated by Performance
//     Insights.
//
// Each response element returns a maximum of 500 bytes. For larger elements,
// such as SQL statements, only the first 500 bytes are returned.
type DimensionGroup struct {
	_ struct{} `type:"structure"`

	// A list of specific dimensions from a dimension group. If this parameter is
	// not present, then it signifies that all of the dimensions in the group were
	// requested, or are present in the response.
	//
	// Valid values for elements in the Dimensions array are:
	//
	//    * db.application.name - The name of the application that is connected
	//    to the database. Valid values are as follows: Aurora PostgreSQL Amazon
	//    RDS PostgreSQL Amazon DocumentDB
	//
	//    * db.host.id - The host ID of the connected client (all engines).
	//
	//    * db.host.name - The host name of the connected client (all engines).
	//
	//    * db.name - The name of the database to which the client is connected.
	//    Valid values are as follows: Aurora PostgreSQL Amazon RDS PostgreSQL Aurora
	//    MySQL Amazon RDS MySQL Amazon RDS MariaDB Amazon DocumentDB
	//
	//    * db.query.id - The query ID generated by Performance Insights (only Amazon
	//    DocumentDB).
	//
	//    * db.query.db_id - The query ID generated by the database (only Amazon
	//    DocumentDB).
	//
	//    * db.query.statement - The text of the query that is being run (only Amazon
	//    DocumentDB).
	//
	//    * db.query.tokenized_id
	//
	//    * db.query.tokenized.id - The query digest ID generated by Performance
	//    Insights (only Amazon DocumentDB).
	//
	//    * db.query.tokenized.db_id - The query digest ID generated by Performance
	//    Insights (only Amazon DocumentDB).
	//
	//    * db.query.tokenized.statement - The text of the query digest (only Amazon
	//    DocumentDB).
	//
	//    * db.session_type.name - The type of the current session (only Amazon
	//    DocumentDB).
	//
	//    * db.sql.id - The hash of the full, non-tokenized SQL statement generated
	//    by Performance Insights (all engines except Amazon DocumentDB).
	//
	//    * db.sql.db_id - Either the SQL ID generated by the database engine, or
	//    a value generated by Performance Insights that begins with pi- (all engines
	//    except Amazon DocumentDB).
	//
	//    * db.sql.statement - The full text of the SQL statement that is running,
	//    as in SELECT * FROM employees (all engines except Amazon DocumentDB)
	//
	//    * db.sql.tokenized_id
	//
	//    * db.sql_tokenized.id - The hash of the SQL digest generated by Performance
	//    Insights (all engines except Amazon DocumentDB). In the console, db.sql_tokenized.id
	//    is called the Support ID because Amazon Web Services Support can look
	//    at this data to help you troubleshoot database issues.
	//
	//    * db.sql_tokenized.db_id - Either the native database ID used to refer
	//    to the SQL statement, or a synthetic ID such as pi-2372568224 that Performance
	//    Insights generates if the native database ID isn't available (all engines
	//    except Amazon DocumentDB).
	//
	//    * db.sql_tokenized.statement - The text of the SQL digest, as in SELECT
	//    * FROM employees WHERE employee_id = ? (all engines except Amazon DocumentDB)
	//
	//    * db.user.id - The ID of the user logged in to the database (all engines
	//    except Amazon DocumentDB).
	//
	//    * db.user.name - The name of the user logged in to the database (all engines
	//    except Amazon DocumentDB).
	//
	//    * db.wait_event.name - The event for which the backend is waiting (all
	//    engines except Amazon DocumentDB).
	//
	//    * db.wait_event.type - The type of event for which the backend is waiting
	//    (all engines except Amazon DocumentDB).
	//
	//    * db.wait_event_type.name - The name of the event type for which the backend
	//    is waiting (all engines except Amazon DocumentDB).
	//
	//    * db.wait_state.name - The event for which the backend is waiting (only
	//    Amazon DocumentDB).
	Dimensions []*string `min:"1" type:"list"`

	// The name of the dimension group. Valid values are as follows:
	//
	//    * db - The name of the database to which the client is connected. The
	//    following values are permitted: Aurora PostgreSQL Amazon RDS PostgreSQL
	//    Aurora MySQL Amazon RDS MySQL Amazon RDS MariaDB Amazon DocumentDB
	//
	//    * db.application - The name of the application that is connected to the
	//    database. The following values are permitted: Aurora PostgreSQL Amazon
	//    RDS PostgreSQL Amazon DocumentDB
	//
	//    * db.host - The host name of the connected client (all engines).
	//
	//    * db.query - The query that is currently running (only Amazon DocumentDB).
	//
	//    * db.query_tokenized - The digest query (only Amazon DocumentDB).
	//
	//    * db.session_type - The type of the current session (only Aurora PostgreSQL
	//    and RDS PostgreSQL).
	//
	//    * db.sql - The text of the SQL statement that is currently running (all
	//    engines except Amazon DocumentDB).
	//
	//    * db.sql_tokenized - The SQL digest (all engines except Amazon DocumentDB).
	//
	//    * db.user - The user logged in to the database (all engines except Amazon
	//    DocumentDB).
	//
	//    * db.wait_event - The event for which the database backend is waiting
	//    (all engines except Amazon DocumentDB).
	//
	//    * db.wait_event_type - The type of event for which the database backend
	//    is waiting (all engines except Amazon DocumentDB).
	//
	//    * db.wait_state - The event for which the database backend is waiting
	//    (only Amazon DocumentDB).
	//
	// Group is a required field
	Group *string `type:"string" required:"true"`

	// The maximum number of items to fetch for this dimension group.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionGroup"}
	if s.Dimensions != nil && len(s.Dimensions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Dimensions", 1))
	}
	if s.Group == nil {
		invalidParams.Add(request.NewErrParamRequired("Group"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *DimensionGroup) SetDimensions(v []*string) *DimensionGroup {
	s.Dimensions = v
	return s
}

// SetGroup sets the Group field's value.
func (s *DimensionGroup) SetGroup(v string) *DimensionGroup {
	s.Group = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DimensionGroup) SetLimit(v int64) *DimensionGroup {
	s.Limit = &v
	return s
}

// Information about dimensions within a dimension group.
type DimensionGroupDetail struct {
	_ struct{} `type:"structure"`

	// The dimensions within a dimension group.
	Dimensions []*DimensionDetail `type:"list"`

	// The name of the dimension group.
	Group *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionGroupDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionGroupDetail) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *DimensionGroupDetail) SetDimensions(v []*DimensionDetail) *DimensionGroupDetail {
	s.Dimensions = v
	return s
}

// SetGroup sets the Group field's value.
func (s *DimensionGroupDetail) SetGroup(v string) *DimensionGroupDetail {
	s.Group = &v
	return s
}

// An object that includes the requested dimension key values and aggregated
// metric values within a dimension group.
type DimensionKeyDescription struct {
	_ struct{} `type:"structure"`

	// A map that contains the value for each additional metric.
	AdditionalMetrics map[string]*float64 `type:"map"`

	// A map of name-value pairs for the dimensions in the group.
	Dimensions map[string]*string `type:"map"`

	// If PartitionBy was specified, PartitionKeys contains the dimensions that
	// were.
	Partitions []*float64 `type:"list"`

	// The aggregated metric value for the dimensions, over the requested time range.
	Total *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionKeyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionKeyDescription) GoString() string {
	return s.String()
}

// SetAdditionalMetrics sets the AdditionalMetrics field's value.
func (s *DimensionKeyDescription) SetAdditionalMetrics(v map[string]*float64) *DimensionKeyDescription {
	s.AdditionalMetrics = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *DimensionKeyDescription) SetDimensions(v map[string]*string) *DimensionKeyDescription {
	s.Dimensions = v
	return s
}

// SetPartitions sets the Partitions field's value.
func (s *DimensionKeyDescription) SetPartitions(v []*float64) *DimensionKeyDescription {
	s.Partitions = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DimensionKeyDescription) SetTotal(v float64) *DimensionKeyDescription {
	s.Total = &v
	return s
}

// An object that describes the details for a specified dimension.
type DimensionKeyDetail struct {
	_ struct{} `type:"structure"`

	// The full name of the dimension. The full name includes the group name and
	// key name. The following values are valid:
	//
	//    * db.query.statement (Amazon DocumentDB)
	//
	//    * db.sql.statement (Amazon RDS and Aurora)
	Dimension *string `type:"string"`

	// The status of the dimension detail data. Possible values include the following:
	//
	//    * AVAILABLE - The dimension detail data is ready to be retrieved.
	//
	//    * PROCESSING - The dimension detail data isn't ready to be retrieved because
	//    more processing time is required. If the requested detail data has the
	//    status PROCESSING, Performance Insights returns the truncated query.
	//
	//    * UNAVAILABLE - The dimension detail data could not be collected successfully.
	Status *string `type:"string" enum:"DetailStatus"`

	// The value of the dimension detail data. Depending on the return status, this
	// value is either the full or truncated SQL query for the following dimensions:
	//
	//    * db.query.statement (Amazon DocumentDB)
	//
	//    * db.sql.statement (Amazon RDS and Aurora)
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionKeyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionKeyDetail) GoString() string {
	return s.String()
}

// SetDimension sets the Dimension field's value.
func (s *DimensionKeyDetail) SetDimension(v string) *DimensionKeyDetail {
	s.Dimension = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DimensionKeyDetail) SetStatus(v string) *DimensionKeyDetail {
	s.Status = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionKeyDetail) SetValue(v string) *DimensionKeyDetail {
	s.Value = &v
	return s
}

// The metadata for a feature. For example, the metadata might indicate that
// a feature is turned on or off on a specific DB instance.
type FeatureMetadata struct {
	_ struct{} `type:"structure"`

	// The status of the feature on the DB instance. Possible values include the
	// following:
	//
	//    * ENABLED - The feature is enabled on the instance.
	//
	//    * DISABLED - The feature is disabled on the instance.
	//
	//    * UNSUPPORTED - The feature isn't supported on the instance.
	//
	//    * ENABLED_PENDING_REBOOT - The feature is enabled on the instance but
	//    requires a reboot to take effect.
	//
	//    * DISABLED_PENDING_REBOOT - The feature is disabled on the instance but
	//    requires a reboot to take effect.
	//
	//    * UNKNOWN - The feature status couldn't be determined.
	Status *string `type:"string" enum:"FeatureStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureMetadata) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *FeatureMetadata) SetStatus(v string) *FeatureMetadata {
	s.Status = &v
	return s
}

type GetDimensionKeyDetailsInput struct {
	_ struct{} `type:"structure"`

	// The name of the dimension group. Performance Insights searches the specified
	// group for the dimension group ID. The following group name values are valid:
	//
	//    * db.query (Amazon DocumentDB only)
	//
	//    * db.sql (Amazon RDS and Aurora only)
	//
	// Group is a required field
	Group *string `type:"string" required:"true"`

	// The ID of the dimension group from which to retrieve dimension details. For
	// dimension group db.sql, the group ID is db.sql.id. The following group ID
	// values are valid:
	//
	//    * db.sql.id for dimension group db.sql (Aurora and RDS only)
	//
	//    * db.query.id for dimension group db.query (DocumentDB only)
	//
	// GroupIdentifier is a required field
	GroupIdentifier *string `type:"string" required:"true"`

	// The ID for a data source from which to gather dimension data. This ID must
	// be immutable and unique within an Amazon Web Services Region. When a DB instance
	// is the data source, specify its DbiResourceId value. For example, specify
	// db-ABCDEFGHIJKLMNOPQRSTU1VW2X.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// A list of dimensions to retrieve the detail data for within the given dimension
	// group. If you don't specify this parameter, Performance Insights returns
	// all dimension data within the specified dimension group. Specify dimension
	// names for the following dimension groups:
	//
	//    * db.sql - Specify either the full dimension name db.sql.statement or
	//    the short dimension name statement (Aurora and RDS only).
	//
	//    * db.query - Specify either the full dimension name db.query.statement
	//    or the short dimension name statement (DocumentDB only).
	RequestedDimensions []*string `min:"1" type:"list"`

	// The Amazon Web Services service for which Performance Insights returns data.
	// The only valid value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionKeyDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionKeyDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDimensionKeyDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDimensionKeyDetailsInput"}
	if s.Group == nil {
		invalidParams.Add(request.NewErrParamRequired("Group"))
	}
	if s.GroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIdentifier"))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.RequestedDimensions != nil && len(s.RequestedDimensions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestedDimensions", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *GetDimensionKeyDetailsInput) SetGroup(v string) *GetDimensionKeyDetailsInput {
	s.Group = &v
	return s
}

// SetGroupIdentifier sets the GroupIdentifier field's value.
func (s *GetDimensionKeyDetailsInput) SetGroupIdentifier(v string) *GetDimensionKeyDetailsInput {
	s.GroupIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDimensionKeyDetailsInput) SetIdentifier(v string) *GetDimensionKeyDetailsInput {
	s.Identifier = &v
	return s
}

// SetRequestedDimensions sets the RequestedDimensions field's value.
func (s *GetDimensionKeyDetailsInput) SetRequestedDimensions(v []*string) *GetDimensionKeyDetailsInput {
	s.RequestedDimensions = v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetDimensionKeyDetailsInput) SetServiceType(v string) *GetDimensionKeyDetailsInput {
	s.ServiceType = &v
	return s
}

type GetDimensionKeyDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The details for the requested dimensions.
	Dimensions []*DimensionKeyDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionKeyDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionKeyDetailsOutput) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *GetDimensionKeyDetailsOutput) SetDimensions(v []*DimensionKeyDetail) *GetDimensionKeyDetailsOutput {
	s.Dimensions = v
	return s
}

type GetPerformanceAnalysisReportInput struct {
	_ struct{} `type:"structure"`

	// The text language in the report. The default language is EN_US (English).
	AcceptLanguage *string `type:"string" enum:"AcceptLanguage"`

	// A unique identifier of the created analysis report. For example, report-12345678901234567
	//
	// AnalysisReportId is a required field
	AnalysisReportId *string `min:"1" type:"string" required:"true"`

	// An immutable identifier for a data source that is unique for an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source.
	// In the console, the identifier is shown as ResourceID. When you call DescribeDBInstances,
	// the identifier is returned as DbiResourceId.
	//
	// To use a DB instance as a data source, specify its DbiResourceId value. For
	// example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The Amazon Web Services service for which Performance Insights will return
	// metrics. Valid value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`

	// Indicates the text format in the report. The options are PLAIN_TEXT or MARKDOWN.
	// The default value is plain text.
	TextFormat *string `type:"string" enum:"TextFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPerformanceAnalysisReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPerformanceAnalysisReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPerformanceAnalysisReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPerformanceAnalysisReportInput"}
	if s.AnalysisReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisReportId"))
	}
	if s.AnalysisReportId != nil && len(*s.AnalysisReportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisReportId", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *GetPerformanceAnalysisReportInput) SetAcceptLanguage(v string) *GetPerformanceAnalysisReportInput {
	s.AcceptLanguage = &v
	return s
}

// SetAnalysisReportId sets the AnalysisReportId field's value.
func (s *GetPerformanceAnalysisReportInput) SetAnalysisReportId(v string) *GetPerformanceAnalysisReportInput {
	s.AnalysisReportId = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetPerformanceAnalysisReportInput) SetIdentifier(v string) *GetPerformanceAnalysisReportInput {
	s.Identifier = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetPerformanceAnalysisReportInput) SetServiceType(v string) *GetPerformanceAnalysisReportInput {
	s.ServiceType = &v
	return s
}

// SetTextFormat sets the TextFormat field's value.
func (s *GetPerformanceAnalysisReportInput) SetTextFormat(v string) *GetPerformanceAnalysisReportInput {
	s.TextFormat = &v
	return s
}

type GetPerformanceAnalysisReportOutput struct {
	_ struct{} `type:"structure"`

	// The summary of the performance analysis report created for a time period.
	AnalysisReport *AnalysisReport `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPerformanceAnalysisReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPerformanceAnalysisReportOutput) GoString() string {
	return s.String()
}

// SetAnalysisReport sets the AnalysisReport field's value.
func (s *GetPerformanceAnalysisReportOutput) SetAnalysisReport(v *AnalysisReport) *GetPerformanceAnalysisReportOutput {
	s.AnalysisReport = v
	return s
}

type GetResourceMetadataInput struct {
	_ struct{} `type:"structure"`

	// An immutable identifier for a data source that is unique for an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source.
	// To use a DB instance as a data source, specify its DbiResourceId value. For
	// example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The Amazon Web Services service for which Performance Insights returns metrics.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceMetadataInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourceMetadataInput) SetIdentifier(v string) *GetResourceMetadataInput {
	s.Identifier = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetResourceMetadataInput) SetServiceType(v string) *GetResourceMetadataInput {
	s.ServiceType = &v
	return s
}

type GetResourceMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for different features. For example, the metadata might indicate
	// that a feature is turned on or off on a specific DB instance.
	Features map[string]*FeatureMetadata `type:"map"`

	// An immutable identifier for a data source that is unique for an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source.
	// To use a DB instance as a data source, specify its DbiResourceId value. For
	// example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X.
	Identifier *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetadataOutput) GoString() string {
	return s.String()
}

// SetFeatures sets the Features field's value.
func (s *GetResourceMetadataOutput) SetFeatures(v map[string]*FeatureMetadata) *GetResourceMetadataOutput {
	s.Features = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourceMetadataOutput) SetIdentifier(v string) *GetResourceMetadataOutput {
	s.Identifier = &v
	return s
}

type GetResourceMetricsInput struct {
	_ struct{} `type:"structure"`

	// The date and time specifying the end of the requested time series query range.
	// The value specified is exclusive. Thus, the command returns data points less
	// than (but not equal to) EndTime.
	//
	// The value for EndTime must be later than the value for StartTime.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// An immutable identifier for a data source that is unique for an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source.
	// In the console, the identifier is shown as ResourceID. When you call DescribeDBInstances,
	// the identifier is returned as DbiResourceId.
	//
	// To use a DB instance as a data source, specify its DbiResourceId value. For
	// example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The maximum number of items to return in the response. If more items exist
	// than the specified MaxRecords value, a pagination token is included in the
	// response so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An array of one or more queries to perform. Each query must specify a Performance
	// Insights metric and specify an aggregate function, and you can provide filtering
	// criteria. You must append the aggregate function to the metric. For example,
	// to find the average for the metric db.load you must use db.load.avg. Valid
	// values for aggregate functions include .avg, .min, .max, and .sum.
	//
	// MetricQueries is a required field
	MetricQueries []*MetricQuery `min:"1" type:"list" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`

	// The returned timestamp which is the start or end time of the time periods.
	// The default value is END_TIME.
	PeriodAlignment *string `type:"string" enum:"PeriodAlignment"`

	// The granularity, in seconds, of the data points returned from Performance
	// Insights. A period can be as short as one second, or as long as one day (86400
	// seconds). Valid values are:
	//
	//    * 1 (one second)
	//
	//    * 60 (one minute)
	//
	//    * 300 (five minutes)
	//
	//    * 3600 (one hour)
	//
	//    * 86400 (twenty-four hours)
	//
	// If you don't specify PeriodInSeconds, then Performance Insights will choose
	// a value for you, with a goal of returning roughly 100-200 data points in
	// the response.
	PeriodInSeconds *int64 `type:"integer"`

	// The Amazon Web Services service for which Performance Insights returns metrics.
	// Valid values are as follows:
	//
	//    * RDS
	//
	//    * DOCDB
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`

	// The date and time specifying the beginning of the requested time series query
	// range. You can't specify a StartTime that is earlier than 7 days ago. By
	// default, Performance Insights has 7 days of retention, but you can extend
	// this range up to 2 years. The value specified is inclusive. Thus, the command
	// returns data points equal to or greater than StartTime.
	//
	// The value for StartTime must be earlier than the value for EndTime.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceMetricsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.MetricQueries == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricQueries"))
	}
	if s.MetricQueries != nil && len(s.MetricQueries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricQueries", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.MetricQueries != nil {
		for i, v := range s.MetricQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetResourceMetricsInput) SetEndTime(v time.Time) *GetResourceMetricsInput {
	s.EndTime = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourceMetricsInput) SetIdentifier(v string) *GetResourceMetricsInput {
	s.Identifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourceMetricsInput) SetMaxResults(v int64) *GetResourceMetricsInput {
	s.MaxResults = &v
	return s
}

// SetMetricQueries sets the MetricQueries field's value.
func (s *GetResourceMetricsInput) SetMetricQueries(v []*MetricQuery) *GetResourceMetricsInput {
	s.MetricQueries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceMetricsInput) SetNextToken(v string) *GetResourceMetricsInput {
	s.NextToken = &v
	return s
}

// SetPeriodAlignment sets the PeriodAlignment field's value.
func (s *GetResourceMetricsInput) SetPeriodAlignment(v string) *GetResourceMetricsInput {
	s.PeriodAlignment = &v
	return s
}

// SetPeriodInSeconds sets the PeriodInSeconds field's value.
func (s *GetResourceMetricsInput) SetPeriodInSeconds(v int64) *GetResourceMetricsInput {
	s.PeriodInSeconds = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetResourceMetricsInput) SetServiceType(v string) *GetResourceMetricsInput {
	s.ServiceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetResourceMetricsInput) SetStartTime(v time.Time) *GetResourceMetricsInput {
	s.StartTime = &v
	return s
}

type GetResourceMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The end time for the returned metrics, after alignment to a granular boundary
	// (as specified by PeriodInSeconds). AlignedEndTime will be greater than or
	// equal to the value of the user-specified Endtime.
	AlignedEndTime *time.Time `type:"timestamp"`

	// The start time for the returned metrics, after alignment to a granular boundary
	// (as specified by PeriodInSeconds). AlignedStartTime will be less than or
	// equal to the value of the user-specified StartTime.
	AlignedStartTime *time.Time `type:"timestamp"`

	// An immutable identifier for a data source that is unique for an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source.
	// In the console, the identifier is shown as ResourceID. When you call DescribeDBInstances,
	// the identifier is returned as DbiResourceId.
	Identifier *string `type:"string"`

	// An array of metric results, where each array element contains all of the
	// data points for a particular dimension.
	MetricList []*MetricKeyDataPoints `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetricsOutput) GoString() string {
	return s.String()
}

// SetAlignedEndTime sets the AlignedEndTime field's value.
func (s *GetResourceMetricsOutput) SetAlignedEndTime(v time.Time) *GetResourceMetricsOutput {
	s.AlignedEndTime = &v
	return s
}

// SetAlignedStartTime sets the AlignedStartTime field's value.
func (s *GetResourceMetricsOutput) SetAlignedStartTime(v time.Time) *GetResourceMetricsOutput {
	s.AlignedStartTime = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourceMetricsOutput) SetIdentifier(v string) *GetResourceMetricsOutput {
	s.Identifier = &v
	return s
}

// SetMetricList sets the MetricList field's value.
func (s *GetResourceMetricsOutput) SetMetricList(v []*MetricKeyDataPoints) *GetResourceMetricsOutput {
	s.MetricList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceMetricsOutput) SetNextToken(v string) *GetResourceMetricsOutput {
	s.NextToken = &v
	return s
}

// Retrieves the list of performance issues which are identified.
type Insight struct {
	_ struct{} `type:"structure"`

	// Metric names and values from the timeframe used as baseline to generate the
	// insight.
	BaselineData []*Data `type:"list"`

	// Indicates if the insight is causal or correlated insight.
	Context *string `type:"string" enum:"ContextType"`

	// Description of the insight. For example: A high severity Insight found between
	// 02:00 to 02:30, where there was an unusually high DB load 600x above baseline.
	// Likely performance impact.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Insight's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The end time of the insight. For example, 2018-10-30T00:00:00Z.
	EndTime *time.Time `type:"timestamp"`

	// List of data objects containing metrics and references from the time range
	// while generating the insight.
	InsightData []*Data `type:"list"`

	// The unique identifier for the insight. For example, insight-12345678901234567.
	//
	// InsightId is a required field
	InsightId *string `type:"string" required:"true"`

	// The type of insight. For example, HighDBLoad, HighCPU, or DominatingSQLs.
	InsightType *string `type:"string"`

	// List of recommendations for the insight. For example, Investigate the following
	// SQLs that contributed to 100% of the total DBLoad during that time period:
	// sql-id.
	Recommendations []*Recommendation `type:"list"`

	// The severity of the insight. The values are: Low, Medium, or High.
	Severity *string `type:"string" enum:"Severity"`

	// The start time of the insight. For example, 2018-10-30T00:00:00Z.
	StartTime *time.Time `type:"timestamp"`

	// List of supporting insights that provide additional factors for the insight.
	SupportingInsights []*Insight `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Insight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Insight) GoString() string {
	return s.String()
}

// SetBaselineData sets the BaselineData field's value.
func (s *Insight) SetBaselineData(v []*Data) *Insight {
	s.BaselineData = v
	return s
}

// SetContext sets the Context field's value.
func (s *Insight) SetContext(v string) *Insight {
	s.Context = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Insight) SetDescription(v string) *Insight {
	s.Description = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Insight) SetEndTime(v time.Time) *Insight {
	s.EndTime = &v
	return s
}

// SetInsightData sets the InsightData field's value.
func (s *Insight) SetInsightData(v []*Data) *Insight {
	s.InsightData = v
	return s
}

// SetInsightId sets the InsightId field's value.
func (s *Insight) SetInsightId(v string) *Insight {
	s.InsightId = &v
	return s
}

// SetInsightType sets the InsightType field's value.
func (s *Insight) SetInsightType(v string) *Insight {
	s.InsightType = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *Insight) SetRecommendations(v []*Recommendation) *Insight {
	s.Recommendations = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Insight) SetSeverity(v string) *Insight {
	s.Severity = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Insight) SetStartTime(v time.Time) *Insight {
	s.StartTime = &v
	return s
}

// SetSupportingInsights sets the SupportingInsights field's value.
func (s *Insight) SetSupportingInsights(v []*Insight) *Insight {
	s.SupportingInsights = v
	return s
}

// The request failed due to an unknown error.
type InternalServiceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) GoString() string {
	return s.String()
}

func newErrorInternalServiceError(v protocol.ResponseMetadata) error {
	return &InternalServiceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceError) Code() string {
	return "InternalServiceError"
}

// Message returns the exception's message.
func (s *InternalServiceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceError) OrigErr() error {
	return nil
}

func (s *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// One of the arguments provided is invalid for this request.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAvailableResourceDimensionsInput struct {
	_ struct{} `type:"structure"`

	// The actions to discover the dimensions you are authorized to access. If you
	// specify multiple actions, then the response will contain the dimensions common
	// for all the actions.
	//
	// When you don't specify this request parameter or provide an empty list, the
	// response contains all the available dimensions for the target database engine
	// whether or not you are authorized to access them.
	AuthorizedActions []*string `type:"list" enum:"FineGrainedAction"`

	// An immutable identifier for a data source that is unique within an Amazon
	// Web Services Region. Performance Insights gathers metrics from this data
	// source. To use an Amazon RDS DB instance as a data source, specify its DbiResourceId
	// value. For example, specify db-ABCDEFGHIJKLMNOPQRSTU1VWZ.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The maximum number of items to return in the response. If more items exist
	// than the specified MaxRecords value, a pagination token is included in the
	// response so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// The types of metrics for which to retrieve dimensions. Valid values include
	// db.load.
	//
	// Metrics is a required field
	Metrics []*string `min:"1" type:"list" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Web Services service for which Performance Insights returns metrics.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableResourceDimensionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableResourceDimensionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAvailableResourceDimensionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAvailableResourceDimensionsInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Metrics == nil {
		invalidParams.Add(request.NewErrParamRequired("Metrics"))
	}
	if s.Metrics != nil && len(s.Metrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Metrics", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedActions sets the AuthorizedActions field's value.
func (s *ListAvailableResourceDimensionsInput) SetAuthorizedActions(v []*string) *ListAvailableResourceDimensionsInput {
	s.AuthorizedActions = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *ListAvailableResourceDimensionsInput) SetIdentifier(v string) *ListAvailableResourceDimensionsInput {
	s.Identifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAvailableResourceDimensionsInput) SetMaxResults(v int64) *ListAvailableResourceDimensionsInput {
	s.MaxResults = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *ListAvailableResourceDimensionsInput) SetMetrics(v []*string) *ListAvailableResourceDimensionsInput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableResourceDimensionsInput) SetNextToken(v string) *ListAvailableResourceDimensionsInput {
	s.NextToken = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *ListAvailableResourceDimensionsInput) SetServiceType(v string) *ListAvailableResourceDimensionsInput {
	s.ServiceType = &v
	return s
}

type ListAvailableResourceDimensionsOutput struct {
	_ struct{} `type:"structure"`

	// The dimension information returned for requested metric types.
	MetricDimensions []*MetricDimensionGroups `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableResourceDimensionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableResourceDimensionsOutput) GoString() string {
	return s.String()
}

// SetMetricDimensions sets the MetricDimensions field's value.
func (s *ListAvailableResourceDimensionsOutput) SetMetricDimensions(v []*MetricDimensionGroups) *ListAvailableResourceDimensionsOutput {
	s.MetricDimensions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableResourceDimensionsOutput) SetNextToken(v string) *ListAvailableResourceDimensionsOutput {
	s.NextToken = &v
	return s
}

type ListAvailableResourceMetricsInput struct {
	_ struct{} `type:"structure"`

	// An immutable identifier for a data source that is unique within an Amazon
	// Web Services Region. Performance Insights gathers metrics from this data
	// source. To use an Amazon RDS DB instance as a data source, specify its DbiResourceId
	// value. For example, specify db-ABCDEFGHIJKLMNOPQRSTU1VWZ.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The maximum number of items to return. If the MaxRecords value is less than
	// the number of existing items, the response includes a pagination token.
	MaxResults *int64 `type:"integer"`

	// The types of metrics to return in the response. Valid values in the array
	// include the following:
	//
	//    * os (OS counter metrics) - All engines
	//
	//    * db (DB load metrics) - All engines except for Amazon DocumentDB
	//
	//    * db.sql.stats (per-SQL metrics) - All engines except for Amazon DocumentDB
	//
	//    * db.sql_tokenized.stats (per-SQL digest metrics) - All engines except
	//    for Amazon DocumentDB
	//
	// MetricTypes is a required field
	MetricTypes []*string `type:"list" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Web Services service for which Performance Insights returns metrics.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableResourceMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableResourceMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAvailableResourceMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAvailableResourceMetricsInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.MetricTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricTypes"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *ListAvailableResourceMetricsInput) SetIdentifier(v string) *ListAvailableResourceMetricsInput {
	s.Identifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAvailableResourceMetricsInput) SetMaxResults(v int64) *ListAvailableResourceMetricsInput {
	s.MaxResults = &v
	return s
}

// SetMetricTypes sets the MetricTypes field's value.
func (s *ListAvailableResourceMetricsInput) SetMetricTypes(v []*string) *ListAvailableResourceMetricsInput {
	s.MetricTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableResourceMetricsInput) SetNextToken(v string) *ListAvailableResourceMetricsInput {
	s.NextToken = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *ListAvailableResourceMetricsInput) SetServiceType(v string) *ListAvailableResourceMetricsInput {
	s.ServiceType = &v
	return s
}

type ListAvailableResourceMetricsOutput struct {
	_ struct{} `type:"structure"`

	// An array of metrics available to query. Each array element contains the full
	// name, description, and unit of the metric.
	Metrics []*ResponseResourceMetric `type:"list"`

	// A pagination token that indicates the response didn’t return all available
	// records because MaxRecords was specified in the previous request. To get
	// the remaining records, specify NextToken in a separate request with this
	// value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableResourceMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableResourceMetricsOutput) GoString() string {
	return s.String()
}

// SetMetrics sets the Metrics field's value.
func (s *ListAvailableResourceMetricsOutput) SetMetrics(v []*ResponseResourceMetric) *ListAvailableResourceMetricsOutput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableResourceMetricsOutput) SetNextToken(v string) *ListAvailableResourceMetricsOutput {
	s.NextToken = &v
	return s
}

type ListPerformanceAnalysisReportsInput struct {
	_ struct{} `type:"structure"`

	// An immutable identifier for a data source that is unique for an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source.
	// In the console, the identifier is shown as ResourceID. When you call DescribeDBInstances,
	// the identifier is returned as DbiResourceId.
	//
	// To use a DB instance as a data source, specify its DbiResourceId value. For
	// example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// Specifies whether or not to include the list of tags in the response.
	ListTags *bool `type:"boolean"`

	// The maximum number of items to return in the response. If more items exist
	// than the specified MaxResults value, a pagination token is included in the
	// response so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Web Services service for which Performance Insights returns metrics.
	// Valid value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPerformanceAnalysisReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPerformanceAnalysisReportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPerformanceAnalysisReportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPerformanceAnalysisReportsInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *ListPerformanceAnalysisReportsInput) SetIdentifier(v string) *ListPerformanceAnalysisReportsInput {
	s.Identifier = &v
	return s
}

// SetListTags sets the ListTags field's value.
func (s *ListPerformanceAnalysisReportsInput) SetListTags(v bool) *ListPerformanceAnalysisReportsInput {
	s.ListTags = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPerformanceAnalysisReportsInput) SetMaxResults(v int64) *ListPerformanceAnalysisReportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPerformanceAnalysisReportsInput) SetNextToken(v string) *ListPerformanceAnalysisReportsInput {
	s.NextToken = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *ListPerformanceAnalysisReportsInput) SetServiceType(v string) *ListPerformanceAnalysisReportsInput {
	s.ServiceType = &v
	return s
}

type ListPerformanceAnalysisReportsOutput struct {
	_ struct{} `type:"structure"`

	// List of reports including the report identifier, start and end time, creation
	// time, and status.
	AnalysisReports []*AnalysisReportSummary `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPerformanceAnalysisReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPerformanceAnalysisReportsOutput) GoString() string {
	return s.String()
}

// SetAnalysisReports sets the AnalysisReports field's value.
func (s *ListPerformanceAnalysisReportsOutput) SetAnalysisReports(v []*AnalysisReportSummary) *ListPerformanceAnalysisReportsOutput {
	s.AnalysisReports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPerformanceAnalysisReportsOutput) SetNextToken(v string) *ListPerformanceAnalysisReportsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Lists all the tags for the Amazon RDS Performance Insights resource. This
	// value is an Amazon Resource Name (ARN). For information about creating an
	// ARN, see Constructing an RDS Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// List the tags for the Amazon Web Services service for which Performance Insights
	// returns metrics. Valid value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *ListTagsForResourceInput) SetServiceType(v string) *ListTagsForResourceInput {
	s.ServiceType = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The metadata assigned to an Amazon RDS resource consisting of a key-value
	// pair.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The available dimension information for a metric type.
type MetricDimensionGroups struct {
	_ struct{} `type:"structure"`

	// The available dimension groups for a metric type.
	Groups []*DimensionGroupDetail `type:"list"`

	// The metric type to which the dimension information belongs.
	Metric *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDimensionGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDimensionGroups) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *MetricDimensionGroups) SetGroups(v []*DimensionGroupDetail) *MetricDimensionGroups {
	s.Groups = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *MetricDimensionGroups) SetMetric(v string) *MetricDimensionGroups {
	s.Metric = &v
	return s
}

// A time-ordered series of data points, corresponding to a dimension of a Performance
// Insights metric.
type MetricKeyDataPoints struct {
	_ struct{} `type:"structure"`

	// An array of timestamp-value pairs, representing measurements over a period
	// of time.
	DataPoints []*DataPoint `type:"list"`

	// The dimensions to which the data points apply.
	Key *ResponseResourceMetricKey `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricKeyDataPoints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricKeyDataPoints) GoString() string {
	return s.String()
}

// SetDataPoints sets the DataPoints field's value.
func (s *MetricKeyDataPoints) SetDataPoints(v []*DataPoint) *MetricKeyDataPoints {
	s.DataPoints = v
	return s
}

// SetKey sets the Key field's value.
func (s *MetricKeyDataPoints) SetKey(v *ResponseResourceMetricKey) *MetricKeyDataPoints {
	s.Key = v
	return s
}

// A single query to be processed. You must provide the metric to query and
// append an aggregate function to the metric. For example, to find the average
// for the metric db.load you must use db.load.avg. Valid values for aggregate
// functions include .avg, .min, .max, and .sum. If no other parameters are
// specified, Performance Insights returns all data points for the specified
// metric. Optionally, you can request that the data points be aggregated by
// dimension group (GroupBy), and return only those data points that match your
// criteria (Filter).
type MetricQuery struct {
	_ struct{} `type:"structure"`

	// One or more filters to apply in the request. Restrictions:
	//
	//    * Any number of filters by the same dimension, as specified in the GroupBy
	//    parameter.
	//
	//    * A single filter for any other dimension in this dimension group.
	Filter map[string]*string `type:"map"`

	// A specification for how to aggregate the data points from a query result.
	// You must specify a valid dimension group. Performance Insights will return
	// all of the dimensions within that group, unless you provide the names of
	// specific dimensions within that group. You can also request that Performance
	// Insights return a limited number of values for a dimension.
	GroupBy *DimensionGroup `type:"structure"`

	// The name of a Performance Insights metric to be measured.
	//
	// Valid values for Metric are:
	//
	//    * db.load.avg - A scaled representation of the number of active sessions
	//    for the database engine.
	//
	//    * db.sampledload.avg - The raw number of active sessions for the database
	//    engine.
	//
	//    * The counter metrics listed in Performance Insights operating system
	//    counters (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS)
	//    in the Amazon Aurora User Guide.
	//
	//    * The counter metrics listed in Performance Insights operating system
	//    counters (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS)
	//    in the Amazon RDS User Guide.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the
	// number of active sessions is greater than the internal threshold, Performance
	// Insights samples the active sessions, with db.load.avg showing the scaled
	// values, db.sampledload.avg showing the raw values, and db.sampledload.avg
	// less than db.load.avg. For most use cases, you can query db.load.avg only.
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricQuery"}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.GroupBy != nil {
		if err := s.GroupBy.Validate(); err != nil {
			invalidParams.AddNested("GroupBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *MetricQuery) SetFilter(v map[string]*string) *MetricQuery {
	s.Filter = v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *MetricQuery) SetGroupBy(v *DimensionGroup) *MetricQuery {
	s.GroupBy = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *MetricQuery) SetMetric(v string) *MetricQuery {
	s.Metric = &v
	return s
}

// The user is not authorized to perform this request.
type NotAuthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) GoString() string {
	return s.String()
}

func newErrorNotAuthorizedException(v protocol.ResponseMetadata) error {
	return &NotAuthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotAuthorizedException) Code() string {
	return "NotAuthorizedException"
}

// Message returns the exception's message.
func (s *NotAuthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotAuthorizedException) OrigErr() error {
	return nil
}

func (s *NotAuthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotAuthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotAuthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This data type helps to determine Performance Insights metric to render for
// the insight.
type PerformanceInsightsMetric struct {
	_ struct{} `type:"structure"`

	// A dimension map that contains the dimensions for this partition.
	Dimensions map[string]*string `type:"map"`

	// The Performance Insights metric name.
	DisplayName *string `min:"1" type:"string"`

	// The Performance Insights metric.
	Metric *string `min:"1" type:"string"`

	// The value of the metric. For example, 9 for db.load.avg.
	Value *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerformanceInsightsMetric) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *PerformanceInsightsMetric) SetDimensions(v map[string]*string) *PerformanceInsightsMetric {
	s.Dimensions = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *PerformanceInsightsMetric) SetDisplayName(v string) *PerformanceInsightsMetric {
	s.DisplayName = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *PerformanceInsightsMetric) SetMetric(v string) *PerformanceInsightsMetric {
	s.Metric = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PerformanceInsightsMetric) SetValue(v float64) *PerformanceInsightsMetric {
	s.Value = &v
	return s
}

// The list of recommendations for the insight.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The recommendation details to help resolve the performance issue. For example,
	// Investigate the following SQLs that contributed to 100% of the total DBLoad
	// during that time period: sql-id
	//
	// RecommendationDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Recommendation's
	// String and GoString methods.
	RecommendationDescription *string `type:"string" sensitive:"true"`

	// The unique identifier for the recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) GoString() string {
	return s.String()
}

// SetRecommendationDescription sets the RecommendationDescription field's value.
func (s *Recommendation) SetRecommendationDescription(v string) *Recommendation {
	s.RecommendationDescription = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *Recommendation) SetRecommendationId(v string) *Recommendation {
	s.RecommendationId = &v
	return s
}

// If PartitionBy was specified in a DescribeDimensionKeys request, the dimensions
// are returned in an array. Each element in the array specifies one dimension.
type ResponsePartitionKey struct {
	_ struct{} `type:"structure"`

	// A dimension map that contains the dimensions for this partition.
	//
	// Dimensions is a required field
	Dimensions map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponsePartitionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponsePartitionKey) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *ResponsePartitionKey) SetDimensions(v map[string]*string) *ResponsePartitionKey {
	s.Dimensions = v
	return s
}

// An object that contains the full name, description, and unit of a metric.
type ResponseResourceMetric struct {
	_ struct{} `type:"structure"`

	// The description of the metric.
	Description *string `min:"1" type:"string"`

	// The full name of the metric.
	Metric *string `type:"string"`

	// The unit of the metric.
	Unit *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseResourceMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseResourceMetric) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ResponseResourceMetric) SetDescription(v string) *ResponseResourceMetric {
	s.Description = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *ResponseResourceMetric) SetMetric(v string) *ResponseResourceMetric {
	s.Metric = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *ResponseResourceMetric) SetUnit(v string) *ResponseResourceMetric {
	s.Unit = &v
	return s
}

// An object describing a Performance Insights metric and one or more dimensions
// for that metric.
type ResponseResourceMetricKey struct {
	_ struct{} `type:"structure"`

	// The valid dimensions for the metric.
	Dimensions map[string]*string `type:"map"`

	// The name of a Performance Insights metric to be measured.
	//
	// Valid values for Metric are:
	//
	//    * db.load.avg - A scaled representation of the number of active sessions
	//    for the database engine.
	//
	//    * db.sampledload.avg - The raw number of active sessions for the database
	//    engine.
	//
	//    * The counter metrics listed in Performance Insights operating system
	//    counters (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS)
	//    in the Amazon Aurora User Guide.
	//
	//    * The counter metrics listed in Performance Insights operating system
	//    counters (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS)
	//    in the Amazon RDS User Guide.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the
	// number of active sessions is greater than the internal threshold, Performance
	// Insights samples the active sessions, with db.load.avg showing the scaled
	// values, db.sampledload.avg showing the raw values, and db.sampledload.avg
	// less than db.load.avg. For most use cases, you can query db.load.avg only.
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseResourceMetricKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseResourceMetricKey) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *ResponseResourceMetricKey) SetDimensions(v map[string]*string) *ResponseResourceMetricKey {
	s.Dimensions = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *ResponseResourceMetricKey) SetMetric(v string) *ResponseResourceMetricKey {
	s.Metric = &v
	return s
}

// Metadata assigned to an Amazon RDS resource consisting of a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be from 1 to
	// 128 Unicode characters in length and can't be prefixed with aws: or rds:.
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A value is the optional value of the tag. The string value can be from 1
	// to 256 Unicode characters in length and can't be prefixed with aws: or rds:.
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS Performance Insights resource that the tags are added to.
	// This value is an Amazon Resource Name (ARN). For information about creating
	// an ARN, see Constructing an RDS Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The Amazon Web Services service for which Performance Insights returns metrics.
	// Valid value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`

	// The metadata assigned to an Amazon RDS resource consisting of a key-value
	// pair.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *TagResourceInput) SetServiceType(v string) *TagResourceInput {
	s.ServiceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS Performance Insights resource that the tags are added to.
	// This value is an Amazon Resource Name (ARN). For information about creating
	// an ARN, see Constructing an RDS Amazon Resource Name (ARN) (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// List the tags for the Amazon Web Services service for which Performance Insights
	// returns metrics. Valid value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`

	// The metadata assigned to an Amazon RDS Performance Insights resource consisting
	// of a key-value pair.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *UntagResourceInput) SetServiceType(v string) *UntagResourceInput {
	s.ServiceType = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

const (
	// AcceptLanguageEnUs is a AcceptLanguage enum value
	AcceptLanguageEnUs = "EN_US"
)

// AcceptLanguage_Values returns all elements of the AcceptLanguage enum
func AcceptLanguage_Values() []string {
	return []string{
		AcceptLanguageEnUs,
	}
}

const (
	// AnalysisStatusRunning is a AnalysisStatus enum value
	AnalysisStatusRunning = "RUNNING"

	// AnalysisStatusSucceeded is a AnalysisStatus enum value
	AnalysisStatusSucceeded = "SUCCEEDED"

	// AnalysisStatusFailed is a AnalysisStatus enum value
	AnalysisStatusFailed = "FAILED"
)

// AnalysisStatus_Values returns all elements of the AnalysisStatus enum
func AnalysisStatus_Values() []string {
	return []string{
		AnalysisStatusRunning,
		AnalysisStatusSucceeded,
		AnalysisStatusFailed,
	}
}

const (
	// ContextTypeCausal is a ContextType enum value
	ContextTypeCausal = "CAUSAL"

	// ContextTypeContextual is a ContextType enum value
	ContextTypeContextual = "CONTEXTUAL"
)

// ContextType_Values returns all elements of the ContextType enum
func ContextType_Values() []string {
	return []string{
		ContextTypeCausal,
		ContextTypeContextual,
	}
}

const (
	// DetailStatusAvailable is a DetailStatus enum value
	DetailStatusAvailable = "AVAILABLE"

	// DetailStatusProcessing is a DetailStatus enum value
	DetailStatusProcessing = "PROCESSING"

	// DetailStatusUnavailable is a DetailStatus enum value
	DetailStatusUnavailable = "UNAVAILABLE"
)

// DetailStatus_Values returns all elements of the DetailStatus enum
func DetailStatus_Values() []string {
	return []string{
		DetailStatusAvailable,
		DetailStatusProcessing,
		DetailStatusUnavailable,
	}
}

const (
	// FeatureStatusEnabled is a FeatureStatus enum value
	FeatureStatusEnabled = "ENABLED"

	// FeatureStatusDisabled is a FeatureStatus enum value
	FeatureStatusDisabled = "DISABLED"

	// FeatureStatusUnsupported is a FeatureStatus enum value
	FeatureStatusUnsupported = "UNSUPPORTED"

	// FeatureStatusEnabledPendingReboot is a FeatureStatus enum value
	FeatureStatusEnabledPendingReboot = "ENABLED_PENDING_REBOOT"

	// FeatureStatusDisabledPendingReboot is a FeatureStatus enum value
	FeatureStatusDisabledPendingReboot = "DISABLED_PENDING_REBOOT"

	// FeatureStatusUnknown is a FeatureStatus enum value
	FeatureStatusUnknown = "UNKNOWN"
)

// FeatureStatus_Values returns all elements of the FeatureStatus enum
func FeatureStatus_Values() []string {
	return []string{
		FeatureStatusEnabled,
		FeatureStatusDisabled,
		FeatureStatusUnsupported,
		FeatureStatusEnabledPendingReboot,
		FeatureStatusDisabledPendingReboot,
		FeatureStatusUnknown,
	}
}

const (
	// FineGrainedActionDescribeDimensionKeys is a FineGrainedAction enum value
	FineGrainedActionDescribeDimensionKeys = "DescribeDimensionKeys"

	// FineGrainedActionGetDimensionKeyDetails is a FineGrainedAction enum value
	FineGrainedActionGetDimensionKeyDetails = "GetDimensionKeyDetails"

	// FineGrainedActionGetResourceMetrics is a FineGrainedAction enum value
	FineGrainedActionGetResourceMetrics = "GetResourceMetrics"
)

// FineGrainedAction_Values returns all elements of the FineGrainedAction enum
func FineGrainedAction_Values() []string {
	return []string{
		FineGrainedActionDescribeDimensionKeys,
		FineGrainedActionGetDimensionKeyDetails,
		FineGrainedActionGetResourceMetrics,
	}
}

const (
	// PeriodAlignmentEndTime is a PeriodAlignment enum value
	PeriodAlignmentEndTime = "END_TIME"

	// PeriodAlignmentStartTime is a PeriodAlignment enum value
	PeriodAlignmentStartTime = "START_TIME"
)

// PeriodAlignment_Values returns all elements of the PeriodAlignment enum
func PeriodAlignment_Values() []string {
	return []string{
		PeriodAlignmentEndTime,
		PeriodAlignmentStartTime,
	}
}

const (
	// ServiceTypeRds is a ServiceType enum value
	ServiceTypeRds = "RDS"

	// ServiceTypeDocdb is a ServiceType enum value
	ServiceTypeDocdb = "DOCDB"
)

// ServiceType_Values returns all elements of the ServiceType enum
func ServiceType_Values() []string {
	return []string{
		ServiceTypeRds,
		ServiceTypeDocdb,
	}
}

const (
	// SeverityLow is a Severity enum value
	SeverityLow = "LOW"

	// SeverityMedium is a Severity enum value
	SeverityMedium = "MEDIUM"

	// SeverityHigh is a Severity enum value
	SeverityHigh = "HIGH"
)

// Severity_Values returns all elements of the Severity enum
func Severity_Values() []string {
	return []string{
		SeverityLow,
		SeverityMedium,
		SeverityHigh,
	}
}

const (
	// TextFormatPlainText is a TextFormat enum value
	TextFormatPlainText = "PLAIN_TEXT"

	// TextFormatMarkdown is a TextFormat enum value
	TextFormatMarkdown = "MARKDOWN"
)

// TextFormat_Values returns all elements of the TextFormat enum
func TextFormat_Values() []string {
	return []string{
		TextFormatPlainText,
		TextFormatMarkdown,
	}
}
