/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/FirJvmOverridesBackwardCompatibilityHelper;", "Lorg/jetbrains/kotlin/fir/analysis/FirOverridesBackwardCompatibilityHelper;", "()V", "additionalCheck", "", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Ljava/lang/Boolean;", "checkers.jvm"})
public final class FirJvmOverridesBackwardCompatibilityHelper
extends FirOverridesBackwardCompatibilityHelper {
    @NotNull
    public static final FirJvmOverridesBackwardCompatibilityHelper INSTANCE = new FirJvmOverridesBackwardCompatibilityHelper();

    private FirJvmOverridesBackwardCompatibilityHelper() {
    }

    @Override
    @Nullable
    protected Boolean additionalCheck(@NotNull FirCallableDeclaration member2) {
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        if (!DeclarationUtilsKt.isJavaOrEnhancement(member2)) {
            return false;
        }
        Object object = ClassMembersKt.containingClassLookupTag(member2);
        if (object == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null || (object = ((ClassId)object).asSingleFqName()) == null || (object = ((FqName)object).toUnsafe()) == null) {
            return false;
        }
        Object containingClassName = object;
        if (JavaToKotlinClassMap.INSTANCE.mapKotlinToJava((FqNameUnsafe)containingClassName) != null) {
            return true;
        }
        return null;
    }
}

