/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.ChangingOutputsContext;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.work.InputChanges;

public class ExecuteStep<C extends ChangingOutputsContext>
implements Step<C, Result> {
    private final BuildOperationExecutor buildOperationExecutor;

    public ExecuteStep(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Result execute(final UnitOfWork work, final C context) {
        final Class<?> workType = work.getClass();
        final UnitOfWork.Identity identity = ((IdentityContext)context).getIdentity();
        return (Result)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Result>(){

            public Result call(BuildOperationContext operationContext) {
                Result result = ExecuteStep.executeInternal(work, context);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Executing " + work.getDisplayName())).details((Object)new Operation.Details(){

                    @Override
                    public Class<?> getWorkType() {
                        return workType;
                    }

                    @Override
                    public UnitOfWork.Identity getIdentity() {
                        return identity;
                    }
                });
            }
        });
    }

    private static Result executeInternal(UnitOfWork work, final InputChangesContext context) {
        UnitOfWork.WorkOutput workOutput;
        UnitOfWork.ExecutionRequest executionRequest = new UnitOfWork.ExecutionRequest(){

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<InputChangesInternal> getInputChanges() {
                return context.getInputChanges();
            }

            @Override
            public Optional<ImmutableSortedMap<String, FileSystemSnapshot>> getPreviouslyProducedOutputs() {
                return context.getPreviousExecutionState().map(ExecutionOutputState::getOutputFilesProducedByWork);
            }
        };
        Timer timer = Time.startTimer();
        try {
            workOutput = work.execute(executionRequest);
        }
        catch (Throwable t) {
            return Result.failed(t, Duration.ofMillis(timer.getElapsedMillis()));
        }
        Duration duration = Duration.ofMillis(timer.getElapsedMillis());
        ExecutionEngine.ExecutionOutcome mode = ExecuteStep.determineOutcome(context, workOutput);
        return Result.success(duration, new ExecutionResultImpl(mode, workOutput));
    }

    private static ExecutionEngine.ExecutionOutcome determineOutcome(InputChangesContext context, UnitOfWork.WorkOutput workOutput) {
        switch (workOutput.getDidWork()) {
            case DID_NO_WORK: {
                return ExecutionEngine.ExecutionOutcome.UP_TO_DATE;
            }
            case DID_WORK: {
                return context.getInputChanges().filter(InputChanges::isIncremental).map(Functions.constant((Object)((Object)ExecutionEngine.ExecutionOutcome.EXECUTED_INCREMENTALLY))).orElse(ExecutionEngine.ExecutionOutcome.EXECUTED_NON_INCREMENTALLY);
            }
        }
        throw new AssertionError();
    }

    private static final class ExecutionResultImpl
    implements ExecutionEngine.Execution {
        private final ExecutionEngine.ExecutionOutcome mode;
        private final UnitOfWork.WorkOutput workOutput;

        public ExecutionResultImpl(ExecutionEngine.ExecutionOutcome mode, UnitOfWork.WorkOutput workOutput) {
            this.mode = mode;
            this.workOutput = workOutput;
        }

        @Override
        public ExecutionEngine.ExecutionOutcome getOutcome() {
            return this.mode;
        }

        @Override
        public Object getOutput(File workspace) {
            return this.workOutput.getOutput(workspace);
        }

        @Override
        public boolean canStoreOutputsInCache() {
            return this.workOutput.canStoreInCache();
        }
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public Class<?> getWorkType();

            public UnitOfWork.Identity getIdentity();
        }
    }
}

