//-------------------------------------------------------------------------
/*
Copyright (C) EDuke32 developers and contributors

This file is part of EDuke32.

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
//-------------------------------------------------------------------------

#ifndef dnames_h_
#define dnames_h_

#include "compat.h"
#include "hash.h"

#include <inttypes.h>

#define USE_DNAMES

struct dynitem
{
    const char *str;
    int16_t *dynvalptr;
    const int16_t staticval;
};

extern struct dynitem g_dynSoundList[];
extern struct dynitem g_dynTileList[];

constexpr int16_t KICK_HIT__            = 0;
constexpr int16_t PISTOL_RICOCHET__     = 1;
constexpr int16_t PISTOL_BODYHIT__      = 2;
constexpr int16_t PISTOL_FIRE__         = 3;
constexpr int16_t EJECT_CLIP__          = 4;
constexpr int16_t INSERT_CLIP__         = 5;
constexpr int16_t CHAINGUN_FIRE__       = 6;
constexpr int16_t RPG_SHOOT__           = 7;
constexpr int16_t POOLBALLHIT__         = 8;
constexpr int16_t RPG_EXPLODE__         = 9;
constexpr int16_t CAT_FIRE__            = 10;
constexpr int16_t SHRINKER_FIRE__       = 11;
constexpr int16_t PIPEBOMB_BOUNCE__     = 13;
constexpr int16_t PIPEBOMB_EXPLODE__    = 14;
constexpr int16_t LASERTRIP_ONWALL__    = 15;
constexpr int16_t LASERTRIP_ARMING__    = 16;
constexpr int16_t LASERTRIP_EXPLODE__   = 17;
constexpr int16_t VENT_BUST__           = 18;
constexpr int16_t GLASS_BREAKING__      = 19;
constexpr int16_t GLASS_HEAVYBREAK__    = 20;
constexpr int16_t SHORT_CIRCUIT__       = 21;
constexpr int16_t ITEM_SPLASH__         = 22;
constexpr int16_t DUKE_GASP__           = 25;
constexpr int16_t SLIM_RECOG__          = 26;
constexpr int16_t DUKE_URINATE__        = 28;
constexpr int16_t ENDSEQVOL3SND2__      = 29;
constexpr int16_t ENDSEQVOL3SND3__      = 30;
constexpr int16_t DUKE_CRACK__          = 33;
constexpr int16_t SLIM_ATTACK__         = 34;
constexpr int16_t SOMETHINGHITFORCE__   = 35;
constexpr int16_t DUKE_DRINKING__       = 36;
constexpr int16_t DUKE_GRUNT__          = 38;
constexpr int16_t DUKE_HARTBEAT__       = 39;
constexpr int16_t DUKE_ONWATER__        = 40;
constexpr int16_t DUKE_LAND__           = 42;
constexpr int16_t DUKE_WALKINDUCTS__    = 43;
constexpr int16_t DUKE_UNDERWATER__     = 48;
constexpr int16_t DUKE_JETPACK_ON__     = 49;
constexpr int16_t DUKE_JETPACK_IDLE__   = 50;
constexpr int16_t DUKE_JETPACK_OFF__    = 51;
constexpr int16_t DUKETALKTOBOSS__      = 56;
constexpr int16_t SQUISHED__            = 69;
constexpr int16_t TELEPORTER__          = 70;
constexpr int16_t ELEVATOR_ON__         = 71;
constexpr int16_t ELEVATOR_OFF__        = 73;
constexpr int16_t SUBWAY__              = 75;
constexpr int16_t SWITCH_ON__           = 76;
constexpr int16_t FLUSH_TOILET__        = 79;
constexpr int16_t EARTHQUAKE__          = 81;
constexpr int16_t END_OF_LEVEL_WARN__   = 83;
constexpr int16_t WIND_AMBIENCE__       = 91;
constexpr int16_t SOMETHING_DRIPPING__  = 92;
constexpr int16_t BOS1_RECOG__          = 97;
constexpr int16_t BOS2_RECOG__          = 102;
constexpr int16_t DUKE_GETWEAPON2__     = 107;
constexpr int16_t SHOTGUN_FIRE__        = 109;
constexpr int16_t PRED_RECOG__          = 111;
constexpr int16_t CAPT_RECOG__          = 117;
constexpr int16_t PIG_RECOG__           = 121;
constexpr int16_t RECO_ROAM__           = 125;
constexpr int16_t RECO_RECOG__          = 126;
constexpr int16_t RECO_ATTACK__         = 127;
constexpr int16_t RECO_PAIN__           = 128;
constexpr int16_t DRON_RECOG__          = 131;
constexpr int16_t COMM_RECOG__          = 136;
constexpr int16_t OCTA_RECOG__          = 141;
constexpr int16_t TURR_RECOG__          = 146;
constexpr int16_t SLIM_DYING__          = 149;
constexpr int16_t BOS3_RECOG__          = 151;
constexpr int16_t BOS1_WALK__           = 156;
constexpr int16_t THUD__                = 158;
constexpr int16_t WIERDSHOT_FLY__       = 160;
constexpr int16_t SLIM_ROAM__           = 163;
constexpr int16_t SHOTGUN_COCK__        = 169;
constexpr int16_t GENERIC_AMBIENCE17__  = 177;
constexpr int16_t BONUS_SPEECH1__       = 195;
constexpr int16_t BONUS_SPEECH2__       = 196;
constexpr int16_t BONUS_SPEECH3__       = 197;
constexpr int16_t BONUS_SPEECH4__       = 199;
constexpr int16_t DUKE_LAND_HURT__      = 200;
constexpr int16_t DUKE_SEARCH2__        = 207;
constexpr int16_t DUKE_CRACK2__         = 208;
constexpr int16_t DUKE_SEARCH__         = 209;
constexpr int16_t DUKE_GET__            = 210;
constexpr int16_t DUKE_LONGTERM_PAIN__  = 211;
constexpr int16_t MONITOR_ACTIVE__      = 212;
constexpr int16_t NITEVISION_ONOFF__    = 213;
constexpr int16_t DUKE_CRACK_FIRST__    = 215;
constexpr int16_t DUKE_USEMEDKIT__      = 216;
constexpr int16_t DUKE_TAKEPILLS__      = 217;
constexpr int16_t DUKE_PISSRELIEF__     = 218;
constexpr int16_t SELECT_WEAPON__       = 219;
constexpr int16_t JIBBED_ACTOR5__       = 226;
constexpr int16_t JIBBED_ACTOR6__       = 227;
constexpr int16_t DUKE_GOTHEALTHATLOW__ = 229;
constexpr int16_t BOSSTALKTODUKE__      = 230;
constexpr int16_t WAR_AMBIENCE2__       = 232;
constexpr int16_t EXITMENUSOUND__       = 243;
constexpr int16_t FLY_BY__              = 244;
constexpr int16_t DUKE_SCREAM__         = 245;
constexpr int16_t SHRINKER_HIT__        = 246;
constexpr int16_t RATTY__               = 247;
constexpr int16_t BONUSMUSIC__          = 249;
constexpr int16_t DUKE_GETWEAPON6__     = 264;
constexpr int16_t ALIEN_SWITCH1__       = 272;
constexpr int16_t RIPHEADNECK__         = 284;
constexpr int16_t ENDSEQVOL3SND4__      = 288;
constexpr int16_t ENDSEQVOL3SND5__      = 289;
constexpr int16_t ENDSEQVOL3SND6__      = 290;
constexpr int16_t ENDSEQVOL3SND7__      = 291;
constexpr int16_t ENDSEQVOL3SND8__      = 292;
constexpr int16_t ENDSEQVOL3SND9__      = 293;
constexpr int16_t WHIPYOURASS__         = 294;
constexpr int16_t ENDSEQVOL2SND1__      = 295;
constexpr int16_t ENDSEQVOL2SND2__      = 296;
constexpr int16_t ENDSEQVOL2SND3__      = 297;
constexpr int16_t ENDSEQVOL2SND4__      = 298;
constexpr int16_t ENDSEQVOL2SND5__      = 299;
constexpr int16_t ENDSEQVOL2SND6__      = 300;
constexpr int16_t ENDSEQVOL2SND7__      = 301;
constexpr int16_t SOMETHINGFROZE__      = 303;
constexpr int16_t WIND_REPEAT__         = 308;
constexpr int16_t BOS4_RECOG__          = 342;
constexpr int16_t LIGHTNING_SLAP__      = 351;
constexpr int16_t THUNDER__             = 352;
constexpr int16_t INTRO4_1__            = 363;
constexpr int16_t INTRO4_2__            = 364;
constexpr int16_t INTRO4_3__            = 365;
constexpr int16_t INTRO4_4__            = 366;
constexpr int16_t INTRO4_5__            = 367;
constexpr int16_t INTRO4_6__            = 368;
constexpr int16_t BOSS4_DEADSPEECH__    = 370;
constexpr int16_t BOSS4_FIRSTSEE__      = 371;
constexpr int16_t VOL4ENDSND1__         = 384;
constexpr int16_t VOL4ENDSND2__         = 385;
constexpr int16_t EXPANDERSHOOT__       = 388;
constexpr int16_t INTRO4_B__            = 392;
constexpr int16_t BIGBANG__             = 393;
constexpr int16_t FLAMETHROWER_INTRO__  = 398;
constexpr int16_t FLAMETHROWER_LOOP__   = 399;
constexpr int16_t FLAMETHROWER_END__    = 400;
constexpr int16_t E5L7_DUKE_QUIT_YOU__  = 401;


constexpr int16_t SECTOREFFECTOR__      = 1;
constexpr int16_t ACTIVATOR__           = 2;
constexpr int16_t TOUCHPLATE__          = 3;
constexpr int16_t ACTIVATORLOCKED__     = 4;
constexpr int16_t MUSICANDSFX__         = 5;
constexpr int16_t LOCATORS__            = 6;
constexpr int16_t CYCLER__              = 7;
constexpr int16_t MASTERSWITCH__        = 8;
constexpr int16_t RESPAWN__             = 9;
constexpr int16_t GPSPEED__             = 10;
constexpr int16_t FOF__                 = 13;
constexpr int16_t ARROW__               = 20;
constexpr int16_t FIRSTGUNSPRITE__      = 21;
constexpr int16_t CHAINGUNSPRITE__      = 22;
constexpr int16_t RPGSPRITE__           = 23;
constexpr int16_t FREEZESPRITE__        = 24;
constexpr int16_t SHRINKERSPRITE__      = 25;
constexpr int16_t HEAVYHBOMB__          = 26;
constexpr int16_t TRIPBOMBSPRITE__      = 27;
constexpr int16_t SHOTGUNSPRITE__       = 28;
constexpr int16_t DEVISTATORSPRITE__    = 29;
constexpr int16_t HEALTHBOX__           = 30;
constexpr int16_t AMMOBOX__             = 31;
constexpr int16_t GROWSPRITEICON__      = 32;
constexpr int16_t INVENTORYBOX__        = 33;
constexpr int16_t FREEZEAMMO__          = 37;
constexpr int16_t AMMO__                = 40;
constexpr int16_t BATTERYAMMO__         = 41;
constexpr int16_t DEVISTATORAMMO__      = 42;
constexpr int16_t RPGAMMO__             = 44;
constexpr int16_t GROWAMMO__            = 45;
constexpr int16_t CRYSTALAMMO__         = 46;
constexpr int16_t HBOMBAMMO__           = 47;
constexpr int16_t AMMOLOTS__            = 48;
constexpr int16_t SHOTGUNAMMO__         = 49;
constexpr int16_t COLA__                = 51;
constexpr int16_t SIXPAK__              = 52;
constexpr int16_t FIRSTAID__            = 53;
constexpr int16_t SHIELD__              = 54;
constexpr int16_t STEROIDS__            = 55;
constexpr int16_t AIRTANK__             = 56;
constexpr int16_t JETPACK__             = 57;
constexpr int16_t HEATSENSOR__          = 59;
constexpr int16_t ACCESSCARD__          = 60;
constexpr int16_t BOOTS__               = 61;
constexpr int16_t MIRRORBROKE__         = 70;
constexpr int16_t CLOUDYOCEAN__         = 78;
constexpr int16_t CLOUDYSKIES__         = 79;
constexpr int16_t MOONSKY1__            = 80;
constexpr int16_t BIGORBIT1__           = 84;
constexpr int16_t LA__                  = 89;
constexpr int16_t ATOMICHEALTH__        = 100;
constexpr int16_t TECHLIGHT2__          = 120;
constexpr int16_t TECHLIGHTBUST2__      = 121;
constexpr int16_t TECHLIGHT4__          = 122;
constexpr int16_t TECHLIGHTBUST4__      = 123;
constexpr int16_t WALLLIGHT4__          = 124;
constexpr int16_t WALLLIGHTBUST4__      = 125;
constexpr int16_t ACCESSSWITCH__        = 130;
constexpr int16_t SLOTDOOR__            = 132;
constexpr int16_t LIGHTSWITCH__         = 134;
constexpr int16_t SPACEDOORSWITCH__     = 136;
constexpr int16_t SPACELIGHTSWITCH__    = 138;
constexpr int16_t FRANKENSTINESWITCH__  = 140;
constexpr int16_t NUKEBUTTON__          = 142;
constexpr int16_t MULTISWITCH__         = 146;
constexpr int16_t DOORTILE5__           = 150;
constexpr int16_t DOORTILE6__           = 151;
constexpr int16_t DOORTILE1__           = 152;
constexpr int16_t DOORTILE2__           = 153;
constexpr int16_t DOORTILE3__           = 154;
constexpr int16_t DOORTILE4__           = 155;
constexpr int16_t DOORTILE7__           = 156;
constexpr int16_t DOORTILE8__           = 157;
constexpr int16_t DOORTILE9__           = 158;
constexpr int16_t DOORTILE10__          = 159;
constexpr int16_t DOORSHOCK__           = 160;
constexpr int16_t DIPSWITCH__           = 162;
constexpr int16_t DIPSWITCH2__          = 164;
constexpr int16_t TECHSWITCH__          = 166;
constexpr int16_t DIPSWITCH3__          = 168;
constexpr int16_t ACCESSSWITCH2__       = 170;
constexpr int16_t FLOORSLIME__          = 200;
constexpr int16_t BIGFORCE__            = 230;
constexpr int16_t MASKWALL9__           = 255;
constexpr int16_t SCREENBREAK1__        = 263;
constexpr int16_t SCREENBREAK2__        = 264;
constexpr int16_t SCREENBREAK3__        = 265;
constexpr int16_t SCREENBREAK4__        = 266;
constexpr int16_t SCREENBREAK5__        = 267;
constexpr int16_t SCREENBREAK6__        = 268;
constexpr int16_t SCREENBREAK7__        = 269;
constexpr int16_t SCREENBREAK8__        = 270;
constexpr int16_t SCREENBREAK9__        = 271;
constexpr int16_t SCREENBREAK10__       = 272;
constexpr int16_t SCREENBREAK11__       = 273;
constexpr int16_t SCREENBREAK12__       = 274;
constexpr int16_t SCREENBREAK13__       = 275;
constexpr int16_t MASKWALL1__           = 285;
constexpr int16_t W_TECHWALL1__         = 293;
constexpr int16_t W_TECHWALL2__         = 297;
constexpr int16_t W_TECHWALL15__        = 299;
constexpr int16_t W_TECHWALL3__         = 301;
constexpr int16_t W_TECHWALL4__         = 305;
constexpr int16_t W_TECHWALL10__        = 306;
constexpr int16_t W_TECHWALL16__        = 307;
constexpr int16_t WATERTILE2__          = 336;
constexpr int16_t BPANNEL1__            = 341;
constexpr int16_t PANNEL1__             = 342;
constexpr int16_t PANNEL2__             = 343;
constexpr int16_t STATIC__              = 351;
constexpr int16_t W_SCREENBREAK__       = 357;
constexpr int16_t W_HITTECHWALL3__      = 360;
constexpr int16_t W_HITTECHWALL4__      = 361;
constexpr int16_t W_HITTECHWALL2__      = 362;
constexpr int16_t W_HITTECHWALL1__      = 363;
constexpr int16_t MASKWALL10__          = 387;
constexpr int16_t MASKWALL11__          = 391;
constexpr int16_t DOORTILE22__          = 395;
constexpr int16_t FANSPRITE__           = 407;
constexpr int16_t FANSPRITEBROKE__      = 411;
constexpr int16_t FANSHADOW__           = 412;
constexpr int16_t FANSHADOWBROKE__      = 416;
constexpr int16_t DOORTILE18__          = 447;
constexpr int16_t DOORTILE19__          = 448;
constexpr int16_t DOORTILE20__          = 449;
constexpr int16_t VIEWSCREEN2__         = 499;
constexpr int16_t VIEWSCREEN__          = 502;
constexpr int16_t GLASS__               = 503;
constexpr int16_t GLASS2__              = 504;
constexpr int16_t STAINGLASS1__         = 510;
constexpr int16_t MASKWALL5__           = 514;
constexpr int16_t SATELITE__            = 516;
constexpr int16_t FUELPOD__             = 517;
constexpr int16_t CRACK1__              = 546;
constexpr int16_t CRACK2__              = 547;
constexpr int16_t CRACK3__              = 548;
constexpr int16_t CRACK4__              = 549;
constexpr int16_t FOOTPRINTS__          = 550;
constexpr int16_t DOMELITE__            = 551;
constexpr int16_t CAMERAPOLE__          = 554;
constexpr int16_t CHAIR1__              = 556;
constexpr int16_t CHAIR2__              = 557;
constexpr int16_t BROKENCHAIR__         = 559;
constexpr int16_t MIRROR__              = 560;
constexpr int16_t WATERFOUNTAIN__       = 563;
constexpr int16_t WATERFOUNTAINBROKE__  = 567;
constexpr int16_t FEMMAG1__             = 568;
constexpr int16_t TOILET__              = 569;
constexpr int16_t STALL__               = 571;
constexpr int16_t STALLBROKE__          = 573;
constexpr int16_t FEMMAG2__             = 577;
constexpr int16_t REACTOR2__            = 578;
constexpr int16_t REACTOR2BURNT__       = 579;
constexpr int16_t REACTOR2SPARK__       = 580;
constexpr int16_t GRATE1__              = 595;
constexpr int16_t BGRATE1__             = 596;
constexpr int16_t SOLARPANNEL__         = 602;
constexpr int16_t NAKED1__              = 603;
constexpr int16_t ANTENNA__             = 607;
constexpr int16_t MASKWALL12__          = 609;
constexpr int16_t TOILETBROKE__         = 615;
constexpr int16_t PIPE2__               = 616;
constexpr int16_t PIPE1B__              = 617;
constexpr int16_t PIPE3__               = 618;
constexpr int16_t PIPE1__               = 619;
constexpr int16_t CAMERA1__             = 621;
constexpr int16_t PIPE2B__              = 633;
constexpr int16_t BOLT1__               = 634;
constexpr int16_t W_NUMBERS__           = 640;
constexpr int16_t WATERDRIP__           = 660;
constexpr int16_t WATERBUBBLE__         = 661;
constexpr int16_t WATERBUBBLEMAKER__    = 662;
constexpr int16_t W_FORCEFIELD__        = 663;
constexpr int16_t VACUUM__              = 669;
constexpr int16_t FOOTPRINTS2__         = 672;
constexpr int16_t FOOTPRINTS3__         = 673;
constexpr int16_t FOOTPRINTS4__         = 674;
constexpr int16_t EGG__                 = 675;
constexpr int16_t SCALE__               = 678;
constexpr int16_t CHAIR3__              = 680;
constexpr int16_t CAMERALIGHT__         = 685;
constexpr int16_t MOVIECAMERA__         = 686;
constexpr int16_t IVUNIT__              = 689;
constexpr int16_t POT1__                = 694;
constexpr int16_t POT2__                = 695;
constexpr int16_t POT3__                = 697;
constexpr int16_t PIPE3B__              = 700;
constexpr int16_t WALLLIGHT3__          = 701;
constexpr int16_t WALLLIGHTBUST3__      = 702;
constexpr int16_t WALLLIGHT1__          = 703;
constexpr int16_t WALLLIGHTBUST1__      = 704;
constexpr int16_t WALLLIGHT2__          = 705;
constexpr int16_t WALLLIGHTBUST2__      = 706;
constexpr int16_t LIGHTSWITCH2__        = 712;
constexpr int16_t WAITTOBESEATED__      = 716;
constexpr int16_t DOORTILE14__          = 717;
constexpr int16_t STATUE__              = 753;
constexpr int16_t MIKE__                = 762;
constexpr int16_t VASE__                = 765;
constexpr int16_t SUSHIPLATE1__         = 768;
constexpr int16_t SUSHIPLATE2__         = 769;
constexpr int16_t SUSHIPLATE3__         = 774;
constexpr int16_t SUSHIPLATE4__         = 779;
constexpr int16_t DOORTILE16__          = 781;
constexpr int16_t SUSHIPLATE5__         = 792;
constexpr int16_t OJ__                  = 806;
constexpr int16_t MASKWALL13__          = 830;
constexpr int16_t HURTRAIL__            = 859;
constexpr int16_t POWERSWITCH1__        = 860;
constexpr int16_t LOCKSWITCH1__         = 862;
constexpr int16_t POWERSWITCH2__        = 864;
constexpr int16_t ATM__                 = 867;
constexpr int16_t STATUEFLASH__         = 869;
constexpr int16_t ATMBROKE__            = 888;
constexpr int16_t STRIPEBALL__          = 901;
constexpr int16_t QUEBALL__             = 902;
constexpr int16_t POCKET__              = 903;
constexpr int16_t WOODENHORSE__         = 904;
constexpr int16_t TREE1__               = 908;
constexpr int16_t TREE2__               = 910;
constexpr int16_t CACTUS__              = 911;
constexpr int16_t MASKWALL2__           = 913;
constexpr int16_t MASKWALL3__           = 914;
constexpr int16_t MASKWALL4__           = 915;
constexpr int16_t FIREEXT__             = 916;
constexpr int16_t TOILETWATER__         = 921;
constexpr int16_t NEON1__               = 925;
constexpr int16_t NEON2__               = 926;
constexpr int16_t CACTUSBROKE__         = 939;
constexpr int16_t BOUNCEMINE__          = 940;
constexpr int16_t BROKEFIREHYDRENT__    = 950;
constexpr int16_t BOX__                 = 951;
constexpr int16_t BULLETHOLE__          = 952;
constexpr int16_t BOTTLE1__             = 954;
constexpr int16_t BOTTLE2__             = 955;
constexpr int16_t BOTTLE3__             = 956;
constexpr int16_t BOTTLE4__             = 957;
constexpr int16_t FEMPIC5__             = 963;
constexpr int16_t FEMPIC6__             = 964;
constexpr int16_t FEMPIC7__             = 965;
constexpr int16_t HYDROPLANT__          = 969;
constexpr int16_t OCEANSPRITE1__        = 971;
constexpr int16_t OCEANSPRITE2__        = 972;
constexpr int16_t OCEANSPRITE3__        = 973;
constexpr int16_t OCEANSPRITE4__        = 974;
constexpr int16_t OCEANSPRITE5__        = 975;
constexpr int16_t GENERICPOLE__         = 977;
constexpr int16_t CONE__                = 978;
constexpr int16_t HANGLIGHT__           = 979;
constexpr int16_t HYDRENT__             = 981;
constexpr int16_t MASKWALL14__          = 988;
constexpr int16_t TIRE__                = 990;
constexpr int16_t PIPE5__               = 994;
constexpr int16_t PIPE6__               = 995;
constexpr int16_t PIPE4__               = 996;
constexpr int16_t PIPE4B__              = 997;
constexpr int16_t BROKEHYDROPLANT__     = 1003;
constexpr int16_t PIPE5B__              = 1005;
constexpr int16_t NEON3__               = 1007;
constexpr int16_t NEON4__               = 1008;
constexpr int16_t NEON5__               = 1009;
constexpr int16_t BOTTLE5__             = 1012;
constexpr int16_t BOTTLE6__             = 1013;
constexpr int16_t BOTTLE8__             = 1014;
constexpr int16_t SPOTLITE__            = 1020;
constexpr int16_t MASKWALL15__          = 1024;
constexpr int16_t BOTTLE7__             = 1025;
constexpr int16_t HORSEONSIDE__         = 1026;
constexpr int16_t GLASSPIECES__         = 1031;
constexpr int16_t NEON6__               = 1046;
constexpr int16_t MASKWALL6__           = 1059;
constexpr int16_t RUBBERCAN__           = 1062;
constexpr int16_t PLUG__                = 1069;
constexpr int16_t OOZFILTER__           = 1079;
constexpr int16_t FLOORPLASMA__         = 1082;
constexpr int16_t REACTOR__             = 1088;
constexpr int16_t REACTORSPARK__        = 1092;
constexpr int16_t REACTORBURNT__        = 1096;
constexpr int16_t DOORTILE15__          = 1102;
constexpr int16_t HANDSWITCH__          = 1111;
constexpr int16_t CIRCLEPANNEL__        = 1113;
constexpr int16_t CIRCLEPANNELBROKE__   = 1114;
constexpr int16_t PULLSWITCH__          = 1122;
constexpr int16_t MASKWALL8__           = 1124;
constexpr int16_t BIGHOLE__             = 1141;
constexpr int16_t ALIENSWITCH__         = 1142;
constexpr int16_t DOORTILE21__          = 1144;
constexpr int16_t HANDPRINTSWITCH__     = 1155;
constexpr int16_t BOTTLE10__            = 1157;
constexpr int16_t BOTTLE11__            = 1158;
constexpr int16_t BOTTLE12__            = 1159;
constexpr int16_t BOTTLE13__            = 1160;
constexpr int16_t BOTTLE14__            = 1161;
constexpr int16_t BOTTLE15__            = 1162;
constexpr int16_t BOTTLE16__            = 1163;
constexpr int16_t BOTTLE17__            = 1164;
constexpr int16_t BOTTLE18__            = 1165;
constexpr int16_t BOTTLE19__            = 1166;
constexpr int16_t DOORTILE17__          = 1169;
constexpr int16_t MASKWALL7__           = 1174;
constexpr int16_t DOORTILE11__          = 1178;
constexpr int16_t DOORTILE12__          = 1179;
constexpr int16_t VENDMACHINE__         = 1212;
constexpr int16_t COLAMACHINE__         = 1215;
constexpr int16_t CRANEPOLE__           = 1221;
constexpr int16_t CRANE__               = 1222;
constexpr int16_t BARBROKE__            = 1225;
constexpr int16_t BLOODPOOL__           = 1226;
constexpr int16_t NUKEBARREL__          = 1227;
constexpr int16_t NUKEBARRELDENTED__    = 1228;
constexpr int16_t NUKEBARRELLEAKED__    = 1229;
constexpr int16_t CANWITHSOMETHING__    = 1232;
constexpr int16_t MONEY__               = 1233;
constexpr int16_t BANNER__              = 1236;
constexpr int16_t EXPLODINGBARREL__     = 1238;
constexpr int16_t EXPLODINGBARREL2__    = 1239;
constexpr int16_t FIREBARREL__          = 1240;
constexpr int16_t SEENINE__             = 1247;
constexpr int16_t SEENINEDEAD__         = 1248;
constexpr int16_t STEAM__               = 1250;
constexpr int16_t CEILINGSTEAM__        = 1255;
constexpr int16_t PIPE6B__              = 1260;
constexpr int16_t TRANSPORTERBEAM__     = 1261;
constexpr int16_t RAT__                 = 1267;
constexpr int16_t TRASH__               = 1272;
constexpr int16_t FEMPIC1__             = 1280;
constexpr int16_t FEMPIC2__             = 1289;
constexpr int16_t BLANKSCREEN__         = 1293;
constexpr int16_t PODFEM1__             = 1294;
constexpr int16_t FEMPIC3__             = 1298;
constexpr int16_t FEMPIC4__             = 1306;
constexpr int16_t FEM1__                = 1312;
constexpr int16_t FEM2__                = 1317;
constexpr int16_t FEM3__                = 1321;
constexpr int16_t FEM5__                = 1323;
constexpr int16_t BLOODYPOLE__          = 1324;
constexpr int16_t FEM4__                = 1325;
constexpr int16_t FEM6__                = 1334;
constexpr int16_t FEM6PAD__             = 1335;
constexpr int16_t FEM8__                = 1336;
constexpr int16_t HELECOPT__            = 1346;
constexpr int16_t FETUSJIB__            = 1347;
constexpr int16_t HOLODUKE__            = 1348;
constexpr int16_t SPACEMARINE__         = 1353;
constexpr int16_t INDY__                = 1355;
constexpr int16_t FETUS__               = 1358;
constexpr int16_t FETUSBROKE__          = 1359;
constexpr int16_t MONK__                = 1352;
constexpr int16_t LUKE__                = 1354;
constexpr int16_t COOLEXPLOSION1__      = 1360;
constexpr int16_t WATERSPLASH2__        = 1380;
constexpr int16_t FIREVASE__            = 1390;
constexpr int16_t FEM7__                = 1395;
constexpr int16_t APLAYERTOP__          = 1400;
constexpr int16_t APLAYER__             = 1405;
constexpr int16_t PLAYERONWATER__       = 1420;
constexpr int16_t DUKELYINGDEAD__       = 1518;
constexpr int16_t DUKETORSO__           = 1520;
constexpr int16_t DUKEGUN__             = 1528;
constexpr int16_t DUKELEG__             = 1536;
constexpr int16_t SHARK__               = 1550;
constexpr int16_t BLOOD__               = 1620;
constexpr int16_t FIRELASER__           = 1625;
constexpr int16_t TRANSPORTERSTAR__     = 1630;
constexpr int16_t SPIT__                = 1636;
constexpr int16_t LOOGIE__              = 1637;
constexpr int16_t FIST__                = 1640;
constexpr int16_t FREEZEBLAST__         = 1641;
constexpr int16_t SHRINKSPARK__         = 1646;
constexpr int16_t TONGUE__              = 1647;
constexpr int16_t MORTER__              = 1650;
constexpr int16_t SHRINKEREXPLOSION__   = 1656;
constexpr int16_t RADIUSEXPLOSION__     = 1670;
constexpr int16_t FORCERIPPLE__         = 1671;
constexpr int16_t LIZTROOP__            = 1680;
constexpr int16_t LIZTROOPRUNNING__     = 1681;
constexpr int16_t LIZTROOPSTAYPUT__     = 1682;
constexpr int16_t LIZTROOPSHOOT__       = 1715;
constexpr int16_t LIZTROOPJETPACK__     = 1725;
constexpr int16_t LIZTROOPONTOILET__    = 1741;
constexpr int16_t LIZTROOPJUSTSIT__     = 1742;
constexpr int16_t LIZTROOPDUCKING__     = 1744;
constexpr int16_t HEADJIB1__            = 1768;
constexpr int16_t ARMJIB1__             = 1772;
constexpr int16_t LEGJIB1__             = 1776;
constexpr int16_t OCTABRAIN__           = 1820;
constexpr int16_t OCTABRAINSTAYPUT__    = 1821;
constexpr int16_t INNERJAW__            = 1860;
constexpr int16_t DRONE__               = 1880;
constexpr int16_t EXPLOSION2__          = 1890;
constexpr int16_t COMMANDER__           = 1920;
constexpr int16_t COMMANDERSTAYPUT__    = 1921;
constexpr int16_t RECON__               = 1960;
constexpr int16_t TANK__                = 1975;
constexpr int16_t PIGCOP__              = 2000;
constexpr int16_t PIGCOPSTAYPUT__       = 2001;
constexpr int16_t PIGCOPDIVE__          = 2045;
constexpr int16_t LIZMAN__              = 2120;
constexpr int16_t LIZMANSTAYPUT__       = 2121;
constexpr int16_t LIZMANSPITTING__      = 2150;
constexpr int16_t LIZMANFEEDING__       = 2160;
constexpr int16_t LIZMANJUMP__          = 2165;
constexpr int16_t FECES__               = 2200;
constexpr int16_t LIZMANHEAD1__         = 2201;
constexpr int16_t LIZMANARM1__          = 2205;
constexpr int16_t LIZMANLEG1__          = 2209;
constexpr int16_t EXPLOSION2BOT__       = 2219;
constexpr int16_t JIBS1__               = 2245;
constexpr int16_t JIBS2__               = 2250;
constexpr int16_t JIBS3__               = 2255;
constexpr int16_t JIBS4__               = 2260;
constexpr int16_t JIBS5__               = 2265;
constexpr int16_t BURNING__             = 2270;
constexpr int16_t FIRE__                = 2271;
constexpr int16_t JIBS6__               = 2286;
constexpr int16_t BLOODSPLAT1__         = 2296;
constexpr int16_t BLOODSPLAT3__         = 2297;
constexpr int16_t BLOODSPLAT2__         = 2298;
constexpr int16_t BLOODSPLAT4__         = 2299;
constexpr int16_t OOZ__                 = 2300;
constexpr int16_t OOZ2__                = 2309;
constexpr int16_t WALLBLOOD1__          = 2301;
constexpr int16_t WALLBLOOD2__          = 2302;
constexpr int16_t WALLBLOOD3__          = 2303;
constexpr int16_t WALLBLOOD4__          = 2304;
constexpr int16_t WALLBLOOD5__          = 2305;
constexpr int16_t WALLBLOOD7__          = 2307;
constexpr int16_t WALLBLOOD8__          = 2308;
constexpr int16_t BURNING2__            = 2310;
constexpr int16_t FIRE2__               = 2311;
constexpr int16_t CRACKKNUCKLES__       = 2324;
constexpr int16_t SMALLSMOKE__          = 2329;
constexpr int16_t FLOORFLAME__          = 2333;
constexpr int16_t ROTATEGUN__           = 2360;
constexpr int16_t GREENSLIME__          = 2370;
constexpr int16_t WATERDRIPSPLASH__     = 2380;
constexpr int16_t SCRAP6__              = 2390;
constexpr int16_t SCRAP1__              = 2400;
constexpr int16_t SCRAP2__              = 2404;
constexpr int16_t SCRAP3__              = 2408;
constexpr int16_t SCRAP4__              = 2412;
constexpr int16_t SCRAP5__              = 2416;
constexpr int16_t ORGANTIC__            = 2420;
constexpr int16_t BETAVERSION__         = 2440;
constexpr int16_t SELECTDIR__           = 2444;
constexpr int16_t F1HELP__              = 2445;
constexpr int16_t GROWSPARK__           = 2448;
constexpr int16_t MENUSCREEN__          = 2456;
constexpr int16_t MENUBAR__             = 2457;
constexpr int16_t KILLSICON__           = 2458;
constexpr int16_t FIRSTAID_ICON__       = 2460;
constexpr int16_t HEAT_ICON__           = 2461;
constexpr int16_t BOTTOMSTATUSBAR__     = 2462;
constexpr int16_t BOOT_ICON__           = 2463;
constexpr int16_t FRAGBAR__             = 2465;
constexpr int16_t JETPACK_ICON__        = 2467;
constexpr int16_t AIRTANK_ICON__        = 2468;
constexpr int16_t STEROIDS_ICON__       = 2469;
constexpr int16_t HOLODUKE_ICON__       = 2470;
constexpr int16_t ACCESS_ICON__         = 2471;
constexpr int16_t DIGITALNUM__          = 2472;
constexpr int16_t DUKECAR__             = 2491;
constexpr int16_t CAMCORNER__           = 2482;
constexpr int16_t CAMLIGHT__            = 2484;
constexpr int16_t SLIDEBAR__            = 2489;
constexpr int16_t DREALMS__             = 2492;
constexpr int16_t BETASCREEN__          = 2493;
constexpr int16_t WINDOWBORDER1__       = 2494;
constexpr int16_t TEXTBOX__             = 2495;
constexpr int16_t WINDOWBORDER2__       = 2496;
constexpr int16_t DUKENUKEM__           = 2497;
constexpr int16_t THREEDEE__            = 2498;
constexpr int16_t INGAMEDUKETHREEDEE__  = 2499;
constexpr int16_t TENSCREEN__           = 2500;
constexpr int16_t PLUTOPAKSPRITE__      = 2501;
constexpr int16_t DEVISTATOR__          = 2510;
constexpr int16_t KNEE__                = 2521;
constexpr int16_t CROSSHAIR__           = 2523;
constexpr int16_t FIRSTGUN__            = 2524;
constexpr int16_t FIRSTGUNRELOAD__      = 2528;
constexpr int16_t SHELL__               = 2533;
constexpr int16_t SHOTGUNSHELL__        = 2535;
constexpr int16_t CHAINGUN__            = 2536;
constexpr int16_t RPGGUN__              = 2544;
constexpr int16_t FREEZE__              = 2548;
constexpr int16_t SHRINKER__            = 2556;
constexpr int16_t HANDHOLDINGLASER__    = 2563;
constexpr int16_t TRIPBOMB__            = 2566;
constexpr int16_t LASERLINE__           = 2567;
constexpr int16_t HANDHOLDINGACCESS__   = 2568;
constexpr int16_t HANDREMOTE__          = 2570;
constexpr int16_t HANDTHROW__           = 2573;
constexpr int16_t TIP__                 = 2576;
constexpr int16_t SCUBAMASK__           = 2581;
constexpr int16_t FORCESPHERE__         = 2590;
constexpr int16_t SHOTSPARK1__          = 2595;
constexpr int16_t RPG__                 = 2605;
constexpr int16_t LASERSITE__           = 2612;
constexpr int16_t SHOTGUN__             = 2613;
constexpr int16_t BOSS1__               = 2630;
constexpr int16_t BOSS1STAYPUT__        = 2631;
constexpr int16_t BOSS1SHOOT__          = 2660;
constexpr int16_t BOSS1LOB__            = 2670;
constexpr int16_t BOSSTOP__             = 2696;
constexpr int16_t BOSS2__               = 2710;
constexpr int16_t BOSS3__               = 2760;
constexpr int16_t SPINNINGNUKEICON__    = 2813;
constexpr int16_t SMALLFNTCURSOR__      = 2821;
constexpr int16_t STARTALPHANUM__       = 2822;
constexpr int16_t ENDALPHANUM__         = 2915;
constexpr int16_t BIGALPHANUM__         = 2940;
constexpr int16_t BIGPERIOD__           = 3002;
constexpr int16_t BIGCOMMA__            = 3003;
constexpr int16_t BIGX__                = 3004;
constexpr int16_t BIGQ__                = 3005;
constexpr int16_t BIGSEMI__             = 3006;
constexpr int16_t BIGCOLIN__            = 3007;
constexpr int16_t THREEBYFIVE__         = 3010;
constexpr int16_t BIGAPPOS__            = 3022;
constexpr int16_t MINIFONT__            = 3072;
constexpr int16_t RESPAWNMARKERRED__    = 3190;
constexpr int16_t RESPAWNMARKERYELLOW__ = 3200;
constexpr int16_t RESPAWNMARKERGREEN__  = 3210;
constexpr int16_t BONUSSCREEN__         = 3240;
constexpr int16_t VIEWBORDER__          = 3250;
constexpr int16_t VICTORY1__            = 3260;
constexpr int16_t ORDERING__            = 3270;
constexpr int16_t TEXTSTORY__           = 3280;
constexpr int16_t LOADSCREEN__          = 3281;
constexpr int16_t BORNTOBEWILDSCREEN__  = 3370;
constexpr int16_t BLIMP__               = 3400;
constexpr int16_t FEM9__                = 3450;
constexpr int16_t FRAMEEFFECT1_13__     = 3999;
constexpr int16_t FRAMEEFFECT1__        = 4095;
constexpr int16_t PANNEL3__             = 4099;
constexpr int16_t SCREENBREAK14__       = 4120;
constexpr int16_t SCREENBREAK15__       = 4123;
constexpr int16_t SCREENBREAK19__       = 4125;
constexpr int16_t SCREENBREAK16__       = 4127;
constexpr int16_t SCREENBREAK17__       = 4128;
constexpr int16_t SCREENBREAK18__       = 4129;
constexpr int16_t W_TECHWALL11__        = 4130;
constexpr int16_t W_TECHWALL12__        = 4131;
constexpr int16_t W_TECHWALL13__        = 4132;
constexpr int16_t W_TECHWALL14__        = 4133;
constexpr int16_t W_TECHWALL5__         = 4134;
constexpr int16_t W_TECHWALL6__         = 4136;
constexpr int16_t W_TECHWALL7__         = 4138;
constexpr int16_t W_TECHWALL8__         = 4140;
constexpr int16_t W_TECHWALL9__         = 4142;
constexpr int16_t BPANNEL3__            = 4100;
constexpr int16_t W_HITTECHWALL16__     = 4144;
constexpr int16_t W_HITTECHWALL10__     = 4145;
constexpr int16_t W_HITTECHWALL15__     = 4147;
constexpr int16_t W_MILKSHELF__         = 4181;
constexpr int16_t W_MILKSHELFBROKE__    = 4203;
constexpr int16_t PURPLELAVA__          = 4240;
constexpr int16_t TARGET__              = 4359;
constexpr int16_t DUCK__                = 4361;
constexpr int16_t PUKE__                = 4389;
constexpr int16_t DOORTILE23__          = 4391;
constexpr int16_t SPEAKER__             = 4397;
constexpr int16_t MAIL__                = 4410;
constexpr int16_t HOTMEAT__             = 4427;
constexpr int16_t TRIPODCAMERA__        = 4444;
constexpr int16_t PAPER__               = 4460;
constexpr int16_t GENERICPOLE2__        = 4465;
constexpr int16_t XXXSTACY__            = 4470;
constexpr int16_t LETTER__              = 4502;
constexpr int16_t SIDEBOLT1__           = 4525;
constexpr int16_t FOODOBJECT16__        = 4545;
constexpr int16_t TAMPON__              = 4557;
constexpr int16_t CANWITHSOMETHING2__   = 4580;
constexpr int16_t CANWITHSOMETHING3__   = 4581;
constexpr int16_t CANWITHSOMETHING4__   = 4582;
constexpr int16_t DOLPHIN1__            = 4591;
constexpr int16_t DOLPHIN2__            = 4592;
constexpr int16_t NEWBEAST__            = 4610;
constexpr int16_t NEWBEASTSTAYPUT__     = 4611;
constexpr int16_t BOSS4__               = 4740;
constexpr int16_t BOSS4STAYPUT__        = 4741;
constexpr int16_t FEM10__               = 4864;
constexpr int16_t TOUGHGAL__            = 4866;
constexpr int16_t MAN__                 = 4871;
constexpr int16_t MAN2__                = 4872;
constexpr int16_t WOMAN__               = 4874;
constexpr int16_t NATURALLIGHTNING__    = 4890;
constexpr int16_t WEATHERWARN__         = 4893;
constexpr int16_t DUKETAG__             = 4900;
constexpr int16_t SIGN1__               = 4909;
constexpr int16_t SIGN2__               = 4912;
constexpr int16_t JURYGUY__             = 4943;
constexpr int16_t WIDESCREENSTATUSBAR__ = 5120;
constexpr int16_t RPGGUNWIDE__          = 5121;
constexpr int16_t FIRSTGUNRELOADWIDE__  = 5122;
constexpr int16_t FREEZEWIDE__          = 5123;
constexpr int16_t FREEZEFIREWIDE__      = 5124;
constexpr int16_t SHRINKERWIDE__        = 5127;
constexpr int16_t CRACKKNUCKLESWIDE__   = 5129;
constexpr int16_t FLAMETHROWERSPRITE__  = 5134;
constexpr int16_t FLAMETHROWERAMMO__    = 5135;
constexpr int16_t FLAMETHROWER__        = 5138;
constexpr int16_t FLAMETHROWERFIRE__    = 5139;
constexpr int16_t FLAMETHROWERFLAME__   = 1891;
constexpr int16_t FLAMETHROWERPILOT__   = 5174;
constexpr int16_t FIREBALL__            = 5163;
constexpr int16_t ONFIRE__              = 5152;
constexpr int16_t ONFIRESMOKE__         = 5143;
constexpr int16_t BURNEDCORPSE__        = 5173;
constexpr int16_t WHISPYSMOKE__         = 5268;
constexpr int16_t FIREFLY__             = 5180;
constexpr int16_t FIREFLYSHRINKEFFECT__ = 5360;
constexpr int16_t FIREFLYGROWEFFECT__   = 5367;
constexpr int16_t FIREFLYFLYINGEFFECT__ = 5296;
constexpr int16_t BOSS5__               = 5310;
constexpr int16_t BOSS5STAYPUT__        = 5311;
constexpr int16_t LAVAPOOL__            = 5304;
constexpr int16_t LAVASPLASH__          = 5371;
constexpr int16_t LAVAPOOLBUBBLE__      = 5207;
constexpr int16_t BOSS2STAYPUT__        = 2711;
constexpr int16_t BOSS3STAYPUT__        = 2761;
constexpr int16_t E32_TILE5736__        = 5736;
constexpr int16_t E32_TILE5737__        = 5737;
constexpr int16_t E32_TILE5846__        = 5846;

extern inthashtable_t h_dsound;
extern inthashtable_t h_dynamictilemap;

void G_InitDynamicNames(void);

#define TILEMAPSIZE 6144

#ifdef USE_DNAMES

void G_ProcessDynamicNameMapping(const char *szLabel, struct dynitem *list, int16_t lValue);

void inithashnames(void);
void freehashnames(void);

extern int16_t ALIEN_SWITCH1;
extern int16_t BIGBANG;
extern int16_t BONUS_SPEECH1;
extern int16_t BONUS_SPEECH2;
extern int16_t BONUS_SPEECH3;
extern int16_t BONUS_SPEECH4;
extern int16_t BONUSMUSIC;
extern int16_t BOS1_RECOG;
extern int16_t BOS1_WALK;
extern int16_t BOS2_RECOG;
extern int16_t BOS3_RECOG;
extern int16_t BOS4_RECOG;
extern int16_t BOSS4_DEADSPEECH;
extern int16_t BOSS4_FIRSTSEE;
extern int16_t BOSSTALKTODUKE;
extern int16_t CAPT_RECOG;
extern int16_t CAT_FIRE;
extern int16_t CHAINGUN_FIRE;
extern int16_t COMM_RECOG;
extern int16_t DRON_RECOG;
extern int16_t DUKE_CRACK;
extern int16_t DUKE_CRACK_FIRST;
extern int16_t DUKE_CRACK2;
extern int16_t DUKE_DRINKING;
extern int16_t DUKE_GASP;
extern int16_t DUKE_GET;
extern int16_t DUKE_GETWEAPON2;
extern int16_t DUKE_GETWEAPON6;
extern int16_t DUKE_GOTHEALTHATLOW;
extern int16_t DUKE_GRUNT;
extern int16_t DUKE_HARTBEAT;
extern int16_t DUKE_JETPACK_IDLE;
extern int16_t DUKE_JETPACK_OFF;
extern int16_t DUKE_JETPACK_ON;
extern int16_t DUKE_LAND;
extern int16_t DUKE_LAND_HURT;
extern int16_t DUKE_LONGTERM_PAIN;
extern int16_t DUKE_ONWATER;
extern int16_t DUKE_PISSRELIEF;
extern int16_t DUKE_SCREAM;
extern int16_t DUKE_SEARCH;
extern int16_t DUKE_SEARCH2;
extern int16_t DUKE_TAKEPILLS;
extern int16_t DUKE_UNDERWATER;
extern int16_t DUKE_URINATE;
extern int16_t DUKE_USEMEDKIT;
extern int16_t DUKE_WALKINDUCTS;
extern int16_t DUKETALKTOBOSS;
extern int16_t EARTHQUAKE;
extern int16_t EJECT_CLIP;
extern int16_t ELEVATOR_OFF;
extern int16_t ELEVATOR_ON;
extern int16_t END_OF_LEVEL_WARN;
extern int16_t ENDSEQVOL2SND1;
extern int16_t ENDSEQVOL2SND2;
extern int16_t ENDSEQVOL2SND3;
extern int16_t ENDSEQVOL2SND4;
extern int16_t ENDSEQVOL2SND5;
extern int16_t ENDSEQVOL2SND6;
extern int16_t ENDSEQVOL2SND7;
extern int16_t ENDSEQVOL3SND2;
extern int16_t ENDSEQVOL3SND3;
extern int16_t ENDSEQVOL3SND4;
extern int16_t ENDSEQVOL3SND5;
extern int16_t ENDSEQVOL3SND6;
extern int16_t ENDSEQVOL3SND7;
extern int16_t ENDSEQVOL3SND8;
extern int16_t ENDSEQVOL3SND9;
extern int16_t EXITMENUSOUND;
extern int16_t EXPANDERSHOOT;
extern int16_t FLUSH_TOILET;
extern int16_t FLY_BY;
extern int16_t GENERIC_AMBIENCE17;
extern int16_t GLASS_BREAKING;
extern int16_t GLASS_HEAVYBREAK;
extern int16_t INSERT_CLIP;
extern int16_t INTRO4_1;
extern int16_t INTRO4_2;
extern int16_t INTRO4_3;
extern int16_t INTRO4_4;
extern int16_t INTRO4_5;
extern int16_t INTRO4_6;
extern int16_t INTRO4_B;
extern int16_t ITEM_SPLASH;
extern int16_t JIBBED_ACTOR5;
extern int16_t JIBBED_ACTOR6;
extern int16_t KICK_HIT;
extern int16_t LASERTRIP_ARMING;
extern int16_t LASERTRIP_EXPLODE;
extern int16_t LASERTRIP_ONWALL;
extern int16_t LIGHTNING_SLAP;
extern int16_t MONITOR_ACTIVE;
extern int16_t NITEVISION_ONOFF;
extern int16_t OCTA_RECOG;
extern int16_t PIG_RECOG;
extern int16_t PIPEBOMB_BOUNCE;
extern int16_t PIPEBOMB_EXPLODE;
extern int16_t PISTOL_BODYHIT;
extern int16_t PISTOL_FIRE;
extern int16_t PISTOL_RICOCHET;
extern int16_t POOLBALLHIT;
extern int16_t PRED_RECOG;
extern int16_t RATTY;
extern int16_t RECO_ATTACK;
extern int16_t RECO_PAIN;
extern int16_t RECO_RECOG;
extern int16_t RECO_ROAM;
extern int16_t RIPHEADNECK;
extern int16_t RPG_EXPLODE;
extern int16_t RPG_SHOOT;
extern int16_t SELECT_WEAPON;
extern int16_t SHORT_CIRCUIT;
extern int16_t SHOTGUN_COCK;
extern int16_t SHOTGUN_FIRE;
extern int16_t SHRINKER_FIRE;
extern int16_t SHRINKER_HIT;
extern int16_t SLIM_ATTACK;
extern int16_t SLIM_DYING;
extern int16_t SLIM_RECOG;
extern int16_t SLIM_ROAM;
extern int16_t SOMETHING_DRIPPING;
extern int16_t SOMETHINGFROZE;
extern int16_t SOMETHINGHITFORCE;
extern int16_t SQUISHED;
extern int16_t SUBWAY;
extern int16_t SWITCH_ON;
extern int16_t TELEPORTER;
extern int16_t THUD;
extern int16_t THUNDER;
extern int16_t TURR_RECOG;
extern int16_t VENT_BUST;
extern int16_t VOL4ENDSND1;
extern int16_t VOL4ENDSND2;
extern int16_t WAR_AMBIENCE2;
extern int16_t WHIPYOURASS;
extern int16_t WIERDSHOT_FLY;
extern int16_t WIND_AMBIENCE;
extern int16_t WIND_REPEAT;
extern int16_t FLAMETHROWER_INTRO;
extern int16_t FLAMETHROWER_LOOP;
extern int16_t FLAMETHROWER_END;
extern int16_t E5L7_DUKE_QUIT_YOU;


extern int16_t ACCESS_ICON;
extern int16_t ACCESSCARD;
extern int16_t ACCESSSWITCH;
extern int16_t ACCESSSWITCH2;
extern int16_t ACTIVATOR;
extern int16_t ACTIVATORLOCKED;
extern int16_t AIRTANK;
extern int16_t AIRTANK_ICON;
extern int16_t ALIENSWITCH;
extern int16_t AMMO;
extern int16_t AMMOBOX;
extern int16_t AMMOLOTS;
extern int16_t ANTENNA;
extern int16_t APLAYER;
extern int16_t APLAYERTOP;
extern int16_t ARMJIB1;
extern int16_t ARROW;
extern int16_t ATM;
extern int16_t ATMBROKE;
extern int16_t ATOMICHEALTH;
extern int16_t BANNER;
extern int16_t BARBROKE;
extern int16_t BATTERYAMMO;
extern int16_t BETASCREEN;
extern int16_t BETAVERSION;
extern int16_t BGRATE1;
extern int16_t BIGALPHANUM;
extern int16_t BIGAPPOS;
extern int16_t BIGCOLIN;
extern int16_t BIGCOMMA;
extern int16_t BIGFORCE;
extern int16_t BIGHOLE;
extern int16_t BIGORBIT1;
extern int16_t BIGPERIOD;
extern int16_t BIGQ;
extern int16_t BIGSEMI;
extern int16_t BIGX_;
extern int16_t BLANKSCREEN;
extern int16_t BLIMP;
extern int16_t BLOOD;
extern int16_t BLOODPOOL;
extern int16_t BLOODSPLAT1;
extern int16_t BLOODSPLAT2;
extern int16_t BLOODSPLAT3;
extern int16_t BLOODSPLAT4;
extern int16_t BLOODYPOLE;
extern int16_t BOLT1;
extern int16_t BONUSSCREEN;
extern int16_t BOOT_ICON;
extern int16_t BOOTS;
extern int16_t BORNTOBEWILDSCREEN;
extern int16_t BOSS1;
extern int16_t BOSS1LOB;
extern int16_t BOSS1SHOOT;
extern int16_t BOSS1STAYPUT;
extern int16_t BOSS2;
extern int16_t BOSS3;
extern int16_t BOSS4;
extern int16_t BOSS4STAYPUT;
extern int16_t BOSSTOP;
extern int16_t BOTTLE1;
extern int16_t BOTTLE10;
extern int16_t BOTTLE11;
extern int16_t BOTTLE12;
extern int16_t BOTTLE13;
extern int16_t BOTTLE14;
extern int16_t BOTTLE15;
extern int16_t BOTTLE16;
extern int16_t BOTTLE17;
extern int16_t BOTTLE18;
extern int16_t BOTTLE19;
extern int16_t BOTTLE2;
extern int16_t BOTTLE3;
extern int16_t BOTTLE4;
extern int16_t BOTTLE5;
extern int16_t BOTTLE6;
extern int16_t BOTTLE7;
extern int16_t BOTTLE8;
extern int16_t BOTTOMSTATUSBAR;
extern int16_t BOUNCEMINE;
extern int16_t BOX;
extern int16_t BPANNEL1;
extern int16_t BPANNEL3;
extern int16_t BROKEFIREHYDRENT;
extern int16_t BROKEHYDROPLANT;
extern int16_t BROKENCHAIR;
extern int16_t BULLETHOLE;
extern int16_t BURNING;
extern int16_t BURNING2;
extern int16_t CACTUS;
extern int16_t CACTUSBROKE;
extern int16_t CAMCORNER;
extern int16_t CAMERA1;
extern int16_t CAMERALIGHT;
extern int16_t CAMERAPOLE;
extern int16_t CAMLIGHT;
extern int16_t CANWITHSOMETHING;
extern int16_t CANWITHSOMETHING2;
extern int16_t CANWITHSOMETHING3;
extern int16_t CANWITHSOMETHING4;
extern int16_t CEILINGSTEAM;
extern int16_t CHAINGUN;
extern int16_t CHAINGUNSPRITE;
extern int16_t CHAIR1;
extern int16_t CHAIR2;
extern int16_t CHAIR3;
extern int16_t CIRCLEPANNEL;
extern int16_t CIRCLEPANNELBROKE;
extern int16_t CLOUDYOCEAN;
extern int16_t CLOUDYSKIES;
extern int16_t COLA;
extern int16_t COLAMACHINE;
extern int16_t COMMANDER;
extern int16_t COMMANDERSTAYPUT;
extern int16_t CONE;
extern int16_t COOLEXPLOSION1;
extern int16_t CRACK1;
extern int16_t CRACK2;
extern int16_t CRACK3;
extern int16_t CRACK4;
extern int16_t CRACKKNUCKLES;
extern int16_t CRANE;
extern int16_t CRANEPOLE;
extern int16_t CROSSHAIR;
extern int16_t CRYSTALAMMO;
extern int16_t CYCLER;
extern int16_t DEVISTATOR;
extern int16_t DEVISTATORAMMO;
extern int16_t DEVISTATORSPRITE;
extern int16_t DIGITALNUM;
extern int16_t DIPSWITCH;
extern int16_t DIPSWITCH2;
extern int16_t DIPSWITCH3;
extern int16_t DOLPHIN1;
extern int16_t DOLPHIN2;
extern int16_t DOMELITE;
extern int16_t DOORSHOCK;
extern int16_t DOORTILE1;
extern int16_t DOORTILE10;
extern int16_t DOORTILE11;
extern int16_t DOORTILE12;
extern int16_t DOORTILE14;
extern int16_t DOORTILE15;
extern int16_t DOORTILE16;
extern int16_t DOORTILE17;
extern int16_t DOORTILE18;
extern int16_t DOORTILE19;
extern int16_t DOORTILE2;
extern int16_t DOORTILE20;
extern int16_t DOORTILE21;
extern int16_t DOORTILE22;
extern int16_t DOORTILE23;
extern int16_t DOORTILE3;
extern int16_t DOORTILE4;
extern int16_t DOORTILE5;
extern int16_t DOORTILE6;
extern int16_t DOORTILE7;
extern int16_t DOORTILE8;
extern int16_t DOORTILE9;
extern int16_t DREALMS;
extern int16_t DRONE;
extern int16_t DUCK;
extern int16_t DUKECAR;
extern int16_t DUKEGUN;
extern int16_t DUKELEG;
extern int16_t DUKELYINGDEAD;
extern int16_t DUKENUKEM;
extern int16_t DUKETAG;
extern int16_t DUKETORSO;
extern int16_t EGG;
extern int16_t ENDALPHANUM;
extern int16_t EXPLODINGBARREL;
extern int16_t EXPLODINGBARREL2;
extern int16_t EXPLOSION2;
extern int16_t EXPLOSION2BOT;
extern int16_t F1HELP;
extern int16_t FANSHADOW;
extern int16_t FANSHADOWBROKE;
extern int16_t FANSPRITE;
extern int16_t FANSPRITEBROKE;
extern int16_t FECES;
extern int16_t FEM1;
extern int16_t FEM10;
extern int16_t FEM2;
extern int16_t FEM3;
extern int16_t FEM4;
extern int16_t FEM5;
extern int16_t FEM6;
extern int16_t FEM6PAD;
extern int16_t FEM7;
extern int16_t FEM8;
extern int16_t FEM9;
extern int16_t FEMMAG1;
extern int16_t FEMMAG2;
extern int16_t FEMPIC1;
extern int16_t FEMPIC2;
extern int16_t FEMPIC3;
extern int16_t FEMPIC4;
extern int16_t FEMPIC5;
extern int16_t FEMPIC6;
extern int16_t FEMPIC7;
extern int16_t FETUS;
extern int16_t FETUSBROKE;
extern int16_t FETUSJIB;
extern int16_t FIRE;
extern int16_t FIRE2;
extern int16_t FIREBARREL;
extern int16_t FIREEXT;
extern int16_t FIRELASER;
extern int16_t FIREVASE;
extern int16_t FIRSTAID;
extern int16_t FIRSTAID_ICON;
extern int16_t FIRSTGUN;
extern int16_t FIRSTGUNRELOAD;
extern int16_t FIRSTGUNSPRITE;
extern int16_t FIST;
extern int16_t FLOORFLAME;
extern int16_t FLOORPLASMA;
extern int16_t FLOORSLIME;
extern int16_t FOF;
extern int16_t FOODOBJECT16;
extern int16_t FOOTPRINTS;
extern int16_t FOOTPRINTS2;
extern int16_t FOOTPRINTS3;
extern int16_t FOOTPRINTS4;
extern int16_t FORCERIPPLE;
extern int16_t FORCESPHERE;
extern int16_t FRAGBAR;
extern int16_t FRAMEEFFECT1;
extern int16_t FRAMEEFFECT1_13;
extern int16_t FRANKENSTINESWITCH;
extern int16_t FREEZE;
extern int16_t FREEZEAMMO;
extern int16_t FREEZEBLAST;
extern int16_t FREEZESPRITE;
extern int16_t FUELPOD;
extern int16_t GENERICPOLE;
extern int16_t GENERICPOLE2;
extern int16_t GLASS;
extern int16_t GLASS2;
extern int16_t GLASSPIECES;
extern int16_t GPSPEED;
extern int16_t GRATE1;
extern int16_t GREENSLIME;
extern int16_t GROWAMMO;
extern int16_t GROWSPARK;
extern int16_t GROWSPRITEICON;
extern int16_t HANDHOLDINGACCESS;
extern int16_t HANDHOLDINGLASER;
extern int16_t HANDPRINTSWITCH;
extern int16_t HANDREMOTE;
extern int16_t HANDSWITCH;
extern int16_t HANDTHROW;
extern int16_t HANGLIGHT;
extern int16_t HBOMBAMMO;
extern int16_t HEADJIB1;
extern int16_t HEALTHBOX;
extern int16_t HEAT_ICON;
extern int16_t HEATSENSOR;
extern int16_t HEAVYHBOMB;
extern int16_t HELECOPT;
extern int16_t HOLODUKE;
extern int16_t HOLODUKE_ICON;
extern int16_t HORSEONSIDE;
extern int16_t HOTMEAT;
extern int16_t HURTRAIL;
extern int16_t HYDRENT;
extern int16_t HYDROPLANT;
extern int16_t INDY;
extern int16_t INGAMEDUKETHREEDEE;
extern int16_t INNERJAW;
extern int16_t INVENTORYBOX;
extern int16_t IVUNIT;
extern int16_t JETPACK;
extern int16_t JETPACK_ICON;
extern int16_t JIBS1;
extern int16_t JIBS2;
extern int16_t JIBS3;
extern int16_t JIBS4;
extern int16_t JIBS5;
extern int16_t JIBS6;
extern int16_t JURYGUY;
extern int16_t KILLSICON;
extern int16_t KNEE;
extern int16_t LA;
extern int16_t LASERLINE;
extern int16_t LASERSITE;
extern int16_t LEGJIB1;
extern int16_t LETTER;
extern int16_t LIGHTSWITCH;
extern int16_t LIGHTSWITCH2;
extern int16_t LIZMAN;
extern int16_t LIZMANARM1;
extern int16_t LIZMANFEEDING;
extern int16_t LIZMANHEAD1;
extern int16_t LIZMANJUMP;
extern int16_t LIZMANLEG1;
extern int16_t LIZMANSPITTING;
extern int16_t LIZMANSTAYPUT;
extern int16_t LIZTROOP;
extern int16_t LIZTROOPDUCKING;
extern int16_t LIZTROOPJETPACK;
extern int16_t LIZTROOPJUSTSIT;
extern int16_t LIZTROOPONTOILET;
extern int16_t LIZTROOPRUNNING;
extern int16_t LIZTROOPSHOOT;
extern int16_t LIZTROOPSTAYPUT;
extern int16_t LOADSCREEN;
extern int16_t LOCATORS;
extern int16_t LOCKSWITCH1;
extern int16_t LOOGIE;
extern int16_t LUKE;
extern int16_t MAIL;
extern int16_t MAN;
extern int16_t MAN2;
extern int16_t MASKWALL1;
extern int16_t MASKWALL10;
extern int16_t MASKWALL11;
extern int16_t MASKWALL12;
extern int16_t MASKWALL13;
extern int16_t MASKWALL14;
extern int16_t MASKWALL15;
extern int16_t MASKWALL2;
extern int16_t MASKWALL3;
extern int16_t MASKWALL4;
extern int16_t MASKWALL5;
extern int16_t MASKWALL6;
extern int16_t MASKWALL7;
extern int16_t MASKWALL8;
extern int16_t MASKWALL9;
extern int16_t MASTERSWITCH;
extern int16_t MENUBAR;
extern int16_t MENUSCREEN;
extern int16_t MIKE;
extern int16_t MINIFONT;
extern int16_t MIRROR;
extern int16_t MIRRORBROKE;
extern int16_t MONEY;
extern int16_t MONK;
extern int16_t MOONSKY1;
extern int16_t MORTER;
extern int16_t MOVIECAMERA;
extern int16_t MULTISWITCH;
extern int16_t MUSICANDSFX;
extern int16_t NAKED1;
extern int16_t NATURALLIGHTNING;
extern int16_t NEON1;
extern int16_t NEON2;
extern int16_t NEON3;
extern int16_t NEON4;
extern int16_t NEON5;
extern int16_t NEON6;
extern int16_t NEWBEAST;
extern int16_t NEWBEASTSTAYPUT;
extern int16_t NUKEBARREL;
extern int16_t NUKEBARRELDENTED;
extern int16_t NUKEBARRELLEAKED;
extern int16_t NUKEBUTTON;
extern int16_t OCEANSPRITE1;
extern int16_t OCEANSPRITE2;
extern int16_t OCEANSPRITE3;
extern int16_t OCEANSPRITE4;
extern int16_t OCEANSPRITE5;
extern int16_t OCTABRAIN;
extern int16_t OCTABRAINSTAYPUT;
extern int16_t OJ;
extern int16_t OOZ;
extern int16_t OOZ2;
extern int16_t OOZFILTER;
extern int16_t ORDERING;
extern int16_t ORGANTIC;
extern int16_t PANNEL1;
extern int16_t PANNEL2;
extern int16_t PANNEL3;
extern int16_t PAPER;
extern int16_t PIGCOP;
extern int16_t PIGCOPDIVE;
extern int16_t PIGCOPSTAYPUT;
extern int16_t PIPE1;
extern int16_t PIPE1B;
extern int16_t PIPE2;
extern int16_t PIPE2B;
extern int16_t PIPE3;
extern int16_t PIPE3B;
extern int16_t PIPE4;
extern int16_t PIPE4B;
extern int16_t PIPE5;
extern int16_t PIPE5B;
extern int16_t PIPE6;
extern int16_t PIPE6B;
extern int16_t PLAYERONWATER;
extern int16_t PLUG;
extern int16_t PLUTOPAKSPRITE;
extern int16_t POCKET;
extern int16_t PODFEM1;
extern int16_t POT1;
extern int16_t POT2;
extern int16_t POT3;
extern int16_t POWERSWITCH1;
extern int16_t POWERSWITCH2;
extern int16_t PUKE;
extern int16_t PULLSWITCH;
extern int16_t PURPLELAVA;
extern int16_t QUEBALL;
extern int16_t RADIUSEXPLOSION;
extern int16_t RAT;
extern int16_t REACTOR;
extern int16_t REACTOR2;
extern int16_t REACTOR2BURNT;
extern int16_t REACTOR2SPARK;
extern int16_t REACTORBURNT;
extern int16_t REACTORSPARK;
extern int16_t RECON;
extern int16_t RESPAWN;
extern int16_t RESPAWNMARKERGREEN;
extern int16_t RESPAWNMARKERRED;
extern int16_t RESPAWNMARKERYELLOW;
extern int16_t ROTATEGUN;
extern int16_t RPG;
extern int16_t RPGAMMO;
extern int16_t RPGGUN;
extern int16_t RPGSPRITE;
extern int16_t RUBBERCAN;
extern int16_t SATELITE;
extern int16_t SCALE;
extern int16_t SCRAP1;
extern int16_t SCRAP2;
extern int16_t SCRAP3;
extern int16_t SCRAP4;
extern int16_t SCRAP5;
extern int16_t SCRAP6;
extern int16_t SCREENBREAK1;
extern int16_t SCREENBREAK10;
extern int16_t SCREENBREAK11;
extern int16_t SCREENBREAK12;
extern int16_t SCREENBREAK13;
extern int16_t SCREENBREAK14;
extern int16_t SCREENBREAK15;
extern int16_t SCREENBREAK16;
extern int16_t SCREENBREAK17;
extern int16_t SCREENBREAK18;
extern int16_t SCREENBREAK19;
extern int16_t SCREENBREAK2;
extern int16_t SCREENBREAK3;
extern int16_t SCREENBREAK4;
extern int16_t SCREENBREAK5;
extern int16_t SCREENBREAK6;
extern int16_t SCREENBREAK7;
extern int16_t SCREENBREAK8;
extern int16_t SCREENBREAK9;
extern int16_t SCUBAMASK;
extern int16_t SECTOREFFECTOR;
extern int16_t SEENINE;
extern int16_t SEENINEDEAD;
extern int16_t SELECTDIR;
extern int16_t SHARK;
extern int16_t SHELL;
extern int16_t SHIELD;
extern int16_t SHOTGUN;
extern int16_t SHOTGUNAMMO;
extern int16_t SHOTGUNSHELL;
extern int16_t SHOTGUNSPRITE;
extern int16_t SHOTSPARK1;
extern int16_t SHRINKER;
extern int16_t SHRINKEREXPLOSION;
extern int16_t SHRINKERSPRITE;
extern int16_t SHRINKSPARK;
extern int16_t SIDEBOLT1;
extern int16_t SIGN1;
extern int16_t SIGN2;
extern int16_t SIXPAK;
extern int16_t SLIDEBAR;
extern int16_t SLOTDOOR;
extern int16_t SMALLFNTCURSOR;
extern int16_t SMALLSMOKE;
extern int16_t SOLARPANNEL;
extern int16_t SPACEDOORSWITCH;
extern int16_t SPACELIGHTSWITCH;
extern int16_t SPACEMARINE;
extern int16_t SPEAKER;
extern int16_t SPINNINGNUKEICON;
extern int16_t SPIT;
extern int16_t SPOTLITE;
extern int16_t STAINGLASS1;
extern int16_t STALL;
extern int16_t STALLBROKE;
extern int16_t STARTALPHANUM;
extern int16_t STATIC;
extern int16_t STATUE;
extern int16_t STATUEFLASH;
extern int16_t STEAM;
extern int16_t STEROIDS;
extern int16_t STEROIDS_ICON;
extern int16_t STRIPEBALL;
extern int16_t SUSHIPLATE1;
extern int16_t SUSHIPLATE2;
extern int16_t SUSHIPLATE3;
extern int16_t SUSHIPLATE4;
extern int16_t SUSHIPLATE5;
extern int16_t TAMPON;
extern int16_t TANK;
extern int16_t TARGET;
extern int16_t TECHLIGHT2;
extern int16_t TECHLIGHT4;
extern int16_t TECHLIGHTBUST2;
extern int16_t TECHLIGHTBUST4;
extern int16_t TECHSWITCH;
extern int16_t TENSCREEN;
extern int16_t TEXTBOX;
extern int16_t TEXTSTORY;
extern int16_t THREEBYFIVE;
extern int16_t THREEDEE;
extern int16_t TIP;
extern int16_t TIRE;
extern int16_t TOILET;
extern int16_t TOILETBROKE;
extern int16_t TOILETWATER;
extern int16_t TONGUE;
extern int16_t TOUCHPLATE;
extern int16_t TOUGHGAL;
extern int16_t TRANSPORTERBEAM;
extern int16_t TRANSPORTERSTAR;
extern int16_t TRASH;
extern int16_t TREE1;
extern int16_t TREE2;
extern int16_t TRIPBOMB;
extern int16_t TRIPBOMBSPRITE;
extern int16_t TRIPODCAMERA;
extern int16_t VACUUM;
extern int16_t VASE;
extern int16_t VENDMACHINE;
extern int16_t VICTORY1;
extern int16_t VIEWBORDER;
extern int16_t VIEWSCREEN;
extern int16_t VIEWSCREEN2;
extern int16_t W_FORCEFIELD;
extern int16_t W_HITTECHWALL1;
extern int16_t W_HITTECHWALL10;
extern int16_t W_HITTECHWALL15;
extern int16_t W_HITTECHWALL16;
extern int16_t W_HITTECHWALL2;
extern int16_t W_HITTECHWALL3;
extern int16_t W_HITTECHWALL4;
extern int16_t W_MILKSHELF;
extern int16_t W_MILKSHELFBROKE;
extern int16_t W_NUMBERS;
extern int16_t W_SCREENBREAK;
extern int16_t W_TECHWALL1;
extern int16_t W_TECHWALL10;
extern int16_t W_TECHWALL11;
extern int16_t W_TECHWALL12;
extern int16_t W_TECHWALL13;
extern int16_t W_TECHWALL14;
extern int16_t W_TECHWALL15;
extern int16_t W_TECHWALL16;
extern int16_t W_TECHWALL2;
extern int16_t W_TECHWALL3;
extern int16_t W_TECHWALL4;
extern int16_t W_TECHWALL5;
extern int16_t W_TECHWALL6;
extern int16_t W_TECHWALL7;
extern int16_t W_TECHWALL8;
extern int16_t W_TECHWALL9;
extern int16_t WAITTOBESEATED;
extern int16_t WALLBLOOD1;
extern int16_t WALLBLOOD2;
extern int16_t WALLBLOOD3;
extern int16_t WALLBLOOD4;
extern int16_t WALLBLOOD5;
extern int16_t WALLBLOOD7;
extern int16_t WALLBLOOD8;
extern int16_t WALLLIGHT1;
extern int16_t WALLLIGHT2;
extern int16_t WALLLIGHT3;
extern int16_t WALLLIGHT4;
extern int16_t WALLLIGHTBUST1;
extern int16_t WALLLIGHTBUST2;
extern int16_t WALLLIGHTBUST3;
extern int16_t WALLLIGHTBUST4;
extern int16_t WATERBUBBLE;
extern int16_t WATERBUBBLEMAKER;
extern int16_t WATERDRIP;
extern int16_t WATERDRIPSPLASH;
extern int16_t WATERFOUNTAIN;
extern int16_t WATERFOUNTAINBROKE;
extern int16_t WATERSPLASH2;
extern int16_t WATERTILE2;
extern int16_t WEATHERWARN;
extern int16_t WINDOWBORDER1;
extern int16_t WINDOWBORDER2;
extern int16_t WOMAN;
extern int16_t WOODENHORSE;
extern int16_t XXXSTACY;
extern int16_t WIDESCREENSTATUSBAR;
extern int16_t RPGGUNWIDE;
extern int16_t FIRSTGUNRELOADWIDE;
extern int16_t FREEZEWIDE;
extern int16_t FREEZEFIREWIDE;
extern int16_t SHRINKERWIDE;
extern int16_t CRACKKNUCKLESWIDE;
extern int16_t FLAMETHROWERSPRITE;
extern int16_t FLAMETHROWERAMMO;
extern int16_t FLAMETHROWER;
extern int16_t FLAMETHROWERFIRE;
extern int16_t FLAMETHROWERFLAME;
extern int16_t FLAMETHROWERPILOT;
extern int16_t FIREBALL;
extern int16_t ONFIRE;
extern int16_t ONFIRESMOKE;
extern int16_t BURNEDCORPSE;
extern int16_t WHISPYSMOKE;
extern int16_t FIREFLY;
extern int16_t FIREFLYSHRINKEFFECT;
extern int16_t FIREFLYGROWEFFECT;
extern int16_t FIREFLYFLYINGEFFECT;
extern int16_t BOSS5;
extern int16_t BOSS5STAYPUT;
extern int16_t LAVAPOOL;
extern int16_t LAVASPLASH;
extern int16_t LAVAPOOLBUBBLE;
extern int16_t BOSS2STAYPUT;
extern int16_t BOSS3STAYPUT;
extern int16_t E32_TILE5736;
extern int16_t E32_TILE5737;
extern int16_t E32_TILE5846;

static FORCE_INLINE int soundGetMapping(int const Soundnum)
{
    int const found = inthash_find(&h_dsound, Soundnum);
    return found != -1 ? found : Soundnum;
}

static FORCE_INLINE void soundSetMapping(int const sound1, int const sound2)
{
    inthash_add(&h_dsound, sound1, sound2, true);
}

static FORCE_INLINE int tileGetMapping(int const tile)
{
    int const found = inthash_find(&h_dynamictilemap, tile);
    return found != -1 ? found : tile;
}

static FORCE_INLINE void tileSetMapping(int const tile1, int const tile2)
{
    inthash_add(&h_dynamictilemap, tile1, tile2, true);
}


#else  /* if !defined USE_DNAMES */

#define G_ProcessDynamicNameMapping(x, y) ((void)(0))

#define initsoundhashnames() ((void)0)
#define inithashnames() ((void)0)
#define freehashnames() ((void)0)

#include "soundefs.h"
#include "names.h"
#undef SPACESHUTTLE
#undef CANNON
#undef CANNONBALLS

#define soundGetMapping(Soundnum) (Soundnum)
#define tileGetMapping(Tilenum) (Tilenum)

#endif

#endif // dnames_h_
