// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/paymentgateway/issuerswitch/v1/rules.proto

package issuerswitch

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of metadata.
type RuleMetadata_Type int32

const (
	// Unspecified type.
	RuleMetadata_TYPE_UNSPECIFIED RuleMetadata_Type = 0
	// List type. Indicates that the metadata contains a list of values which
	// the rule requires for execution.
	RuleMetadata_LIST RuleMetadata_Type = 1
)

// Enum value maps for RuleMetadata_Type.
var (
	RuleMetadata_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "LIST",
	}
	RuleMetadata_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"LIST":             1,
	}
)

func (x RuleMetadata_Type) Enum() *RuleMetadata_Type {
	p := new(RuleMetadata_Type)
	*p = x
	return p
}

func (x RuleMetadata_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RuleMetadata_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_enumTypes[0].Descriptor()
}

func (RuleMetadata_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_enumTypes[0]
}

func (x RuleMetadata_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RuleMetadata_Type.Descriptor instead.
func (RuleMetadata_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{1, 0}
}

// A rule that is executed by the issuer switch while processing an
// API transaction.
type Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for this resource.
	// Format: projects/{project}/rules/{rule}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The description of the rule.
	RuleDescription string `protobuf:"bytes,2,opt,name=rule_description,json=ruleDescription,proto3" json:"rule_description,omitempty"`
	// The API Type for which this rule gets executed. A value of
	// `API_TYPE_UNSPECIFIED` indicates that the rule is executed for all API
	// transactions.
	ApiType ApiType `protobuf:"varint,3,opt,name=api_type,json=apiType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.ApiType" json:"api_type,omitempty"`
	// The transaction type for which this rule gets executed. A value of
	// `TRANSACTION_TYPE_UNSPECIFIED` indicates that the rule is executed for
	// all transaction types.
	TransactionType TransactionType `protobuf:"varint,4,opt,name=transaction_type,json=transactionType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionType" json:"transaction_type,omitempty"`
}

func (x *Rule) Reset() {
	*x = Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule.ProtoReflect.Descriptor instead.
func (*Rule) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{0}
}

func (x *Rule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Rule) GetRuleDescription() string {
	if x != nil {
		return x.RuleDescription
	}
	return ""
}

func (x *Rule) GetApiType() ApiType {
	if x != nil {
		return x.ApiType
	}
	return ApiType_API_TYPE_UNSPECIFIED
}

func (x *Rule) GetTransactionType() TransactionType {
	if x != nil {
		return x.TransactionType
	}
	return TransactionType_TRANSACTION_TYPE_UNSPECIFIED
}

// The metadata associated with a rule. This defines data that are used by the
// rule during execution.
type RuleMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for this resource.
	// Format: projects/{project}/rules/{rule}/metadata/{metadata}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The description of the rule metadata.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Type of rule metadata.
	Type RuleMetadata_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.RuleMetadata_Type" json:"type,omitempty"`
}

func (x *RuleMetadata) Reset() {
	*x = RuleMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuleMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleMetadata) ProtoMessage() {}

func (x *RuleMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleMetadata.ProtoReflect.Descriptor instead.
func (*RuleMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{1}
}

func (x *RuleMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RuleMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RuleMetadata) GetType() RuleMetadata_Type {
	if x != nil {
		return x.Type
	}
	return RuleMetadata_TYPE_UNSPECIFIED
}

// Represent a single value in a rule's metadata.
type RuleMetadataValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier for this resource.
	// Format: projects/{project}/rules/{rule}/metadata/{metadata}/values/{value}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the resource which could be of type string or
	// AccountReference. The metadata values for rules
	// BlockedPayeeAccountReqPayDebitRule, BlockedPayerAccountReqPayDebitRule,
	// BlockedPayeeAccountReqPayCreditRule and BlockedPayerAccountReqPayCreditRule
	// should be of type AccountReference. For all other rules, metadata values
	// should be of type string.
	//
	// The length of the `value` field depends on the type of
	// the value being used for the rule metadata. The following are the minimum
	// and maximum lengths for the different types of values.
	//
	// Value Type | Minimum Length | Maximum Length |
	// -------- | -------- | -------- |
	// Bank account IFSC   | 11   | 11   |
	// Bank account number   | 1   | 255  |
	// Device identifier   | 1   | 255   |
	// Mobile number   | 12   | 12  |
	// Virtual private address (VPA)   | 3   | 255   |
	//
	// Types that are assignable to Value:
	//	*RuleMetadataValue_Id
	//	*RuleMetadataValue_AccountReference
	Value isRuleMetadataValue_Value `protobuf_oneof:"value"`
}

func (x *RuleMetadataValue) Reset() {
	*x = RuleMetadataValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuleMetadataValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleMetadataValue) ProtoMessage() {}

func (x *RuleMetadataValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleMetadataValue.ProtoReflect.Descriptor instead.
func (*RuleMetadataValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{2}
}

func (x *RuleMetadataValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *RuleMetadataValue) GetValue() isRuleMetadataValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *RuleMetadataValue) GetId() string {
	if x, ok := x.GetValue().(*RuleMetadataValue_Id); ok {
		return x.Id
	}
	return ""
}

func (x *RuleMetadataValue) GetAccountReference() *AccountReference {
	if x, ok := x.GetValue().(*RuleMetadataValue_AccountReference); ok {
		return x.AccountReference
	}
	return nil
}

type isRuleMetadataValue_Value interface {
	isRuleMetadataValue_Value()
}

type RuleMetadataValue_Id struct {
	// The value for string metadata.
	Id string `protobuf:"bytes,2,opt,name=id,proto3,oneof"`
}

type RuleMetadataValue_AccountReference struct {
	// The value for account reference metadata.
	AccountReference *AccountReference `protobuf:"bytes,3,opt,name=account_reference,json=accountReference,proto3,oneof"`
}

func (*RuleMetadataValue_Id) isRuleMetadataValue_Value() {}

func (*RuleMetadataValue_AccountReference) isRuleMetadataValue_Value() {}

// Request body for the `ListRules` method.
type ListRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource must have the format of `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of rules to return. The service may return fewer
	// than this value. If unspecified or if the specified value is less than 50,
	// at most 50 rules will be returned. The maximum value is 1000; values above
	// 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListRulesRequest` call.
	// Specify this parameter to retrieve the next page of rules.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRulesRequest) Reset() {
	*x = ListRulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRulesRequest) ProtoMessage() {}

func (x *ListRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRulesRequest.ProtoReflect.Descriptor instead.
func (*ListRulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{3}
}

func (x *ListRulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response body for the `ListRules` method.
type ListRulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of rules satisfying the specified filter criteria.
	Rules []*Rule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	// Pass this token in a subsequent `ListRulesRequest` call to continue to list
	// results. If all results have been returned, this field is an empty string
	// or not present in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of rules matching request criteria across all pages.
	TotalSize int64 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListRulesResponse) Reset() {
	*x = ListRulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRulesResponse) ProtoMessage() {}

func (x *ListRulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRulesResponse.ProtoReflect.Descriptor instead.
func (*ListRulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{4}
}

func (x *ListRulesResponse) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *ListRulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRulesResponse) GetTotalSize() int64 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request body for the `ListRuleMetadata` method.
type ListRuleMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource. The format is `projects/{project}/rules/{rule}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of rule metadata to return. The service may return fewer
	// than this value. If unspecified or if the specified value is less than 50,
	// at most 50 rule metadata will be returned. The maximum value is 1000;
	// values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListRuleMetadataRequest` call.
	// Specify this parameter to retrieve the next page of rule metadata.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRuleMetadataRequest) Reset() {
	*x = ListRuleMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuleMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuleMetadataRequest) ProtoMessage() {}

func (x *ListRuleMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuleMetadataRequest.ProtoReflect.Descriptor instead.
func (*ListRuleMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{5}
}

func (x *ListRuleMetadataRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRuleMetadataRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRuleMetadataRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response body for the `ListRuleMetadata` method.
type ListRuleMetadataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of rule metadata associated with the rule.
	RuleMetadata []*RuleMetadata `protobuf:"bytes,1,rep,name=rule_metadata,json=ruleMetadata,proto3" json:"rule_metadata,omitempty"`
	// Pass this token in a subsequent `ListRuleMetadataRequest` call to continue
	// to list results. If all results have been returned, this field is an empty
	// string or not present in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of rule metadata matching request criteria across all pages.
	TotalSize int64 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListRuleMetadataResponse) Reset() {
	*x = ListRuleMetadataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuleMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuleMetadataResponse) ProtoMessage() {}

func (x *ListRuleMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuleMetadataResponse.ProtoReflect.Descriptor instead.
func (*ListRuleMetadataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{6}
}

func (x *ListRuleMetadataResponse) GetRuleMetadata() []*RuleMetadata {
	if x != nil {
		return x.RuleMetadata
	}
	return nil
}

func (x *ListRuleMetadataResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRuleMetadataResponse) GetTotalSize() int64 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request body for the `ListRuleMetadataValues` method.
type ListRuleMetadataValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource. The format is
	// `projects/{project}/rules/{rule}/metadata/{metadata}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of metadata values to return. The service may return
	// fewer than this value. If unspecified or if the specified value is less
	// than 1, at most 50 rule metadata values will be returned. The maximum
	// value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token received from a previous `ListRuleMetadataValuesRequest`
	// call. Specify this parameter to retrieve the next page of rule metadata
	// values.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRuleMetadataValuesRequest) Reset() {
	*x = ListRuleMetadataValuesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuleMetadataValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuleMetadataValuesRequest) ProtoMessage() {}

func (x *ListRuleMetadataValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuleMetadataValuesRequest.ProtoReflect.Descriptor instead.
func (*ListRuleMetadataValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{7}
}

func (x *ListRuleMetadataValuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRuleMetadataValuesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRuleMetadataValuesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response body for ListRuleMetadataValues. Contains a List of values for a
// given rule metadata resource.
type ListRuleMetadataValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of values for a given rule metadata resource identifier.
	RuleMetadataValues []*RuleMetadataValue `protobuf:"bytes,1,rep,name=rule_metadata_values,json=ruleMetadataValues,proto3" json:"rule_metadata_values,omitempty"`
	// Pass this token in a subsequent `ListRuleMetadataValuesRequest` call to
	// continue to list results. If all results have been returned, this field is
	// an empty string or not present in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRuleMetadataValuesResponse) Reset() {
	*x = ListRuleMetadataValuesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuleMetadataValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuleMetadataValuesResponse) ProtoMessage() {}

func (x *ListRuleMetadataValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuleMetadataValuesResponse.ProtoReflect.Descriptor instead.
func (*ListRuleMetadataValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{8}
}

func (x *ListRuleMetadataValuesResponse) GetRuleMetadataValues() []*RuleMetadataValue {
	if x != nil {
		return x.RuleMetadataValues
	}
	return nil
}

func (x *ListRuleMetadataValuesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request body for the `BatchCreateRuleMetadataValues` method.
type BatchCreateRuleMetadataValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource shared by all ruleMetadataValue being created. The
	// format is `projects/{project}/rules/{rule}/metadata/{metadata}`. The
	// [CreateRuleMetadataValueRequest.parent][google.cloud.paymentgateway.issuerswitch.v1.CreateRuleMetadataValueRequest.parent] field in the
	// [CreateRuleMetadataValueRequest][google.cloud.paymentgateway.issuerswitch.v1.CreateRuleMetadataValueRequest] messages contained in this request must
	// match this field.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message specifying the resources to create.
	// A maximum of 1000 RuleMetadataValues can be created in a batch.
	Requests []*CreateRuleMetadataValueRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateRuleMetadataValuesRequest) Reset() {
	*x = BatchCreateRuleMetadataValuesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateRuleMetadataValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateRuleMetadataValuesRequest) ProtoMessage() {}

func (x *BatchCreateRuleMetadataValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateRuleMetadataValuesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateRuleMetadataValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{9}
}

func (x *BatchCreateRuleMetadataValuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateRuleMetadataValuesRequest) GetRequests() []*CreateRuleMetadataValueRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response body for the `BatchCreateRuleMetadataValues` method.
type BatchCreateRuleMetadataValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of RuleMetadataValue created.
	RuleMetadataValue []*RuleMetadataValue `protobuf:"bytes,1,rep,name=rule_metadata_value,json=ruleMetadataValue,proto3" json:"rule_metadata_value,omitempty"`
}

func (x *BatchCreateRuleMetadataValuesResponse) Reset() {
	*x = BatchCreateRuleMetadataValuesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateRuleMetadataValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateRuleMetadataValuesResponse) ProtoMessage() {}

func (x *BatchCreateRuleMetadataValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateRuleMetadataValuesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateRuleMetadataValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{10}
}

func (x *BatchCreateRuleMetadataValuesResponse) GetRuleMetadataValue() []*RuleMetadataValue {
	if x != nil {
		return x.RuleMetadataValue
	}
	return nil
}

// Request for creating a single `RuleMetadataValue`.
type CreateRuleMetadataValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this RuleMetadataValue will be created. The
	// format is `projects/{project}/rules/{rule}/metadata/{metadata}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The rule metadata value to create or add to a list.
	RuleMetadataValue *RuleMetadataValue `protobuf:"bytes,2,opt,name=rule_metadata_value,json=ruleMetadataValue,proto3" json:"rule_metadata_value,omitempty"`
}

func (x *CreateRuleMetadataValueRequest) Reset() {
	*x = CreateRuleMetadataValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRuleMetadataValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRuleMetadataValueRequest) ProtoMessage() {}

func (x *CreateRuleMetadataValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRuleMetadataValueRequest.ProtoReflect.Descriptor instead.
func (*CreateRuleMetadataValueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{11}
}

func (x *CreateRuleMetadataValueRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRuleMetadataValueRequest) GetRuleMetadataValue() *RuleMetadataValue {
	if x != nil {
		return x.RuleMetadataValue
	}
	return nil
}

// Request body for the `BatchDeleteRuleMetadataValues` method.
type BatchDeleteRuleMetadataValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource shared by all RuleMetadataValues being deleted. The
	// format is `projects/{project}/rules/{rule}/metadata/{metadata}`. If this is
	// set, the parent of all of the RuleMetadataValues specified in the
	// list of names must match this field.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names of the rule metadata values to delete.
	// A maximum of 1000 RuleMetadataValue can be deleted in a batch.
	// Format: projects/{project}/rules/{rule}/metadata/{metadata}/values/{value}
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchDeleteRuleMetadataValuesRequest) Reset() {
	*x = BatchDeleteRuleMetadataValuesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteRuleMetadataValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteRuleMetadataValuesRequest) ProtoMessage() {}

func (x *BatchDeleteRuleMetadataValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteRuleMetadataValuesRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteRuleMetadataValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP(), []int{12}
}

func (x *BatchDeleteRuleMetadataValuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteRuleMetadataValuesRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

var File_google_cloud_paymentgateway_issuerswitch_v1_rules_proto protoreflect.FileDescriptor

var file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc7, 0x02, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x72, 0x75, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4f, 0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x69, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x61, 0x70, 0x69, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x67, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x46, 0xea, 0x41, 0x43, 0x0a, 0x20,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x1f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x75, 0x6c, 0x65,
	0x7d, 0x22, 0xa4, 0x02, 0x0a, 0x0c, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x26, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49,
	0x53, 0x54, 0x10, 0x01, 0x3a, 0x62, 0xea, 0x41, 0x5f, 0x0a, 0x28, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x33, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x72,
	0x75, 0x6c, 0x65, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x7b, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x7d, 0x22, 0xad, 0x02, 0x0a, 0x11, 0x52, 0x75, 0x6c,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x02, 0x69, 0x64, 0x12, 0x6c, 0x0a, 0x11, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x10, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x3a, 0x76, 0xea, 0x41, 0x73, 0x0a, 0x2d, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x42, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x75, 0x6c, 0x65, 0x7d, 0x2f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x7d,
	0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x2f, 0x7b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d, 0x42,
	0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x47, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a,
	0x65, 0x22, 0x9f, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xc1, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5e, 0x0a, 0x0d, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0c, 0x72, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x12, 0x2d, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xba, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x70, 0x0a, 0x14, 0x72, 0x75, 0x6c, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x72, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xe0, 0x01, 0x0a, 0x24, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x12,
	0x2d, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x22, 0x97, 0x01, 0x0a, 0x25, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6e,
	0x0a, 0x13, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x72, 0x75, 0x6c,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe4,
	0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x73, 0x0a, 0x13, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x72, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x24, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x05, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x0a, 0x2d, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x32, 0xf2, 0x09, 0x0a, 0x11, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xba, 0x01,
	0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1f, 0x12, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xda, 0x01, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf5, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x2a, 0x7d, 0x2f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x99, 0x02, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42,
	0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xdd, 0x01, 0x0a, 0x1d,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x51, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42,
	0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x1a, 0x4f, 0xca, 0x41, 0x1b,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa6, 0x02, 0x0a,
	0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x42, 0x0a, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x57,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0xaa, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x5c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x3a, 0x3a, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescOnce sync.Once
	file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescData = file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDesc
)

func file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescGZIP() []byte {
	file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescOnce.Do(func() {
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescData)
	})
	return file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDescData
}

var file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_goTypes = []interface{}{
	(RuleMetadata_Type)(0),                        // 0: google.cloud.paymentgateway.issuerswitch.v1.RuleMetadata.Type
	(*Rule)(nil),                                  // 1: google.cloud.paymentgateway.issuerswitch.v1.Rule
	(*RuleMetadata)(nil),                          // 2: google.cloud.paymentgateway.issuerswitch.v1.RuleMetadata
	(*RuleMetadataValue)(nil),                     // 3: google.cloud.paymentgateway.issuerswitch.v1.RuleMetadataValue
	(*ListRulesRequest)(nil),                      // 4: google.cloud.paymentgateway.issuerswitch.v1.ListRulesRequest
	(*ListRulesResponse)(nil),                     // 5: google.cloud.paymentgateway.issuerswitch.v1.ListRulesResponse
	(*ListRuleMetadataRequest)(nil),               // 6: google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataRequest
	(*ListRuleMetadataResponse)(nil),              // 7: google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataResponse
	(*ListRuleMetadataValuesRequest)(nil),         // 8: google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataValuesRequest
	(*ListRuleMetadataValuesResponse)(nil),        // 9: google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataValuesResponse
	(*BatchCreateRuleMetadataValuesRequest)(nil),  // 10: google.cloud.paymentgateway.issuerswitch.v1.BatchCreateRuleMetadataValuesRequest
	(*BatchCreateRuleMetadataValuesResponse)(nil), // 11: google.cloud.paymentgateway.issuerswitch.v1.BatchCreateRuleMetadataValuesResponse
	(*CreateRuleMetadataValueRequest)(nil),        // 12: google.cloud.paymentgateway.issuerswitch.v1.CreateRuleMetadataValueRequest
	(*BatchDeleteRuleMetadataValuesRequest)(nil),  // 13: google.cloud.paymentgateway.issuerswitch.v1.BatchDeleteRuleMetadataValuesRequest
	(ApiType)(0),                                  // 14: google.cloud.paymentgateway.issuerswitch.v1.ApiType
	(TransactionType)(0),                          // 15: google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	(*AccountReference)(nil),                      // 16: google.cloud.paymentgateway.issuerswitch.v1.AccountReference
	(*emptypb.Empty)(nil),                         // 17: google.protobuf.Empty
}
var file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_depIdxs = []int32{
	14, // 0: google.cloud.paymentgateway.issuerswitch.v1.Rule.api_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ApiType
	15, // 1: google.cloud.paymentgateway.issuerswitch.v1.Rule.transaction_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	0,  // 2: google.cloud.paymentgateway.issuerswitch.v1.RuleMetadata.type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RuleMetadata.Type
	16, // 3: google.cloud.paymentgateway.issuerswitch.v1.RuleMetadataValue.account_reference:type_name -> google.cloud.paymentgateway.issuerswitch.v1.AccountReference
	1,  // 4: google.cloud.paymentgateway.issuerswitch.v1.ListRulesResponse.rules:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Rule
	2,  // 5: google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataResponse.rule_metadata:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RuleMetadata
	3,  // 6: google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataValuesResponse.rule_metadata_values:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RuleMetadataValue
	12, // 7: google.cloud.paymentgateway.issuerswitch.v1.BatchCreateRuleMetadataValuesRequest.requests:type_name -> google.cloud.paymentgateway.issuerswitch.v1.CreateRuleMetadataValueRequest
	3,  // 8: google.cloud.paymentgateway.issuerswitch.v1.BatchCreateRuleMetadataValuesResponse.rule_metadata_value:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RuleMetadataValue
	3,  // 9: google.cloud.paymentgateway.issuerswitch.v1.CreateRuleMetadataValueRequest.rule_metadata_value:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RuleMetadataValue
	4,  // 10: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.ListRules:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ListRulesRequest
	6,  // 11: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.ListRuleMetadata:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataRequest
	8,  // 12: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.ListRuleMetadataValues:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataValuesRequest
	10, // 13: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.BatchCreateRuleMetadataValues:input_type -> google.cloud.paymentgateway.issuerswitch.v1.BatchCreateRuleMetadataValuesRequest
	13, // 14: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.BatchDeleteRuleMetadataValues:input_type -> google.cloud.paymentgateway.issuerswitch.v1.BatchDeleteRuleMetadataValuesRequest
	5,  // 15: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.ListRules:output_type -> google.cloud.paymentgateway.issuerswitch.v1.ListRulesResponse
	7,  // 16: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.ListRuleMetadata:output_type -> google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataResponse
	9,  // 17: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.ListRuleMetadataValues:output_type -> google.cloud.paymentgateway.issuerswitch.v1.ListRuleMetadataValuesResponse
	11, // 18: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.BatchCreateRuleMetadataValues:output_type -> google.cloud.paymentgateway.issuerswitch.v1.BatchCreateRuleMetadataValuesResponse
	17, // 19: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules.BatchDeleteRuleMetadataValues:output_type -> google.protobuf.Empty
	15, // [15:20] is the sub-list for method output_type
	10, // [10:15] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_init() }
func file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_init() {
	if File_google_cloud_paymentgateway_issuerswitch_v1_rules_proto != nil {
		return
	}
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuleMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuleMetadataValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuleMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuleMetadataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuleMetadataValuesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuleMetadataValuesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateRuleMetadataValuesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateRuleMetadataValuesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRuleMetadataValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteRuleMetadataValuesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*RuleMetadataValue_Id)(nil),
		(*RuleMetadataValue_AccountReference)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_goTypes,
		DependencyIndexes: file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_depIdxs,
		EnumInfos:         file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_enumTypes,
		MessageInfos:      file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_msgTypes,
	}.Build()
	File_google_cloud_paymentgateway_issuerswitch_v1_rules_proto = out.File
	file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_rawDesc = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_goTypes = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_rules_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IssuerSwitchRulesClient is the client API for IssuerSwitchRules service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IssuerSwitchRulesClient interface {
	// List all rules that are applied on transactions by the issuer switch. Rules
	// can be filtered on API type and transaction type.
	ListRules(ctx context.Context, in *ListRulesRequest, opts ...grpc.CallOption) (*ListRulesResponse, error)
	// List all rule metadata for a given rule identifier.
	ListRuleMetadata(ctx context.Context, in *ListRuleMetadataRequest, opts ...grpc.CallOption) (*ListRuleMetadataResponse, error)
	// List all metadata values for a rule metadata identifier.
	ListRuleMetadataValues(ctx context.Context, in *ListRuleMetadataValuesRequest, opts ...grpc.CallOption) (*ListRuleMetadataValuesResponse, error)
	// Create (add) multiple values to the list of values under the specified rule
	// metadata resource.
	BatchCreateRuleMetadataValues(ctx context.Context, in *BatchCreateRuleMetadataValuesRequest, opts ...grpc.CallOption) (*BatchCreateRuleMetadataValuesResponse, error)
	// Delete (remove) multiple values from the list of values under the specified
	// rules metadata resource.
	BatchDeleteRuleMetadataValues(ctx context.Context, in *BatchDeleteRuleMetadataValuesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type issuerSwitchRulesClient struct {
	cc grpc.ClientConnInterface
}

func NewIssuerSwitchRulesClient(cc grpc.ClientConnInterface) IssuerSwitchRulesClient {
	return &issuerSwitchRulesClient{cc}
}

func (c *issuerSwitchRulesClient) ListRules(ctx context.Context, in *ListRulesRequest, opts ...grpc.CallOption) (*ListRulesResponse, error) {
	out := new(ListRulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/ListRules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchRulesClient) ListRuleMetadata(ctx context.Context, in *ListRuleMetadataRequest, opts ...grpc.CallOption) (*ListRuleMetadataResponse, error) {
	out := new(ListRuleMetadataResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/ListRuleMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchRulesClient) ListRuleMetadataValues(ctx context.Context, in *ListRuleMetadataValuesRequest, opts ...grpc.CallOption) (*ListRuleMetadataValuesResponse, error) {
	out := new(ListRuleMetadataValuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/ListRuleMetadataValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchRulesClient) BatchCreateRuleMetadataValues(ctx context.Context, in *BatchCreateRuleMetadataValuesRequest, opts ...grpc.CallOption) (*BatchCreateRuleMetadataValuesResponse, error) {
	out := new(BatchCreateRuleMetadataValuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/BatchCreateRuleMetadataValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchRulesClient) BatchDeleteRuleMetadataValues(ctx context.Context, in *BatchDeleteRuleMetadataValuesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/BatchDeleteRuleMetadataValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IssuerSwitchRulesServer is the server API for IssuerSwitchRules service.
type IssuerSwitchRulesServer interface {
	// List all rules that are applied on transactions by the issuer switch. Rules
	// can be filtered on API type and transaction type.
	ListRules(context.Context, *ListRulesRequest) (*ListRulesResponse, error)
	// List all rule metadata for a given rule identifier.
	ListRuleMetadata(context.Context, *ListRuleMetadataRequest) (*ListRuleMetadataResponse, error)
	// List all metadata values for a rule metadata identifier.
	ListRuleMetadataValues(context.Context, *ListRuleMetadataValuesRequest) (*ListRuleMetadataValuesResponse, error)
	// Create (add) multiple values to the list of values under the specified rule
	// metadata resource.
	BatchCreateRuleMetadataValues(context.Context, *BatchCreateRuleMetadataValuesRequest) (*BatchCreateRuleMetadataValuesResponse, error)
	// Delete (remove) multiple values from the list of values under the specified
	// rules metadata resource.
	BatchDeleteRuleMetadataValues(context.Context, *BatchDeleteRuleMetadataValuesRequest) (*emptypb.Empty, error)
}

// UnimplementedIssuerSwitchRulesServer can be embedded to have forward compatible implementations.
type UnimplementedIssuerSwitchRulesServer struct {
}

func (*UnimplementedIssuerSwitchRulesServer) ListRules(context.Context, *ListRulesRequest) (*ListRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRules not implemented")
}
func (*UnimplementedIssuerSwitchRulesServer) ListRuleMetadata(context.Context, *ListRuleMetadataRequest) (*ListRuleMetadataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuleMetadata not implemented")
}
func (*UnimplementedIssuerSwitchRulesServer) ListRuleMetadataValues(context.Context, *ListRuleMetadataValuesRequest) (*ListRuleMetadataValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuleMetadataValues not implemented")
}
func (*UnimplementedIssuerSwitchRulesServer) BatchCreateRuleMetadataValues(context.Context, *BatchCreateRuleMetadataValuesRequest) (*BatchCreateRuleMetadataValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateRuleMetadataValues not implemented")
}
func (*UnimplementedIssuerSwitchRulesServer) BatchDeleteRuleMetadataValues(context.Context, *BatchDeleteRuleMetadataValuesRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteRuleMetadataValues not implemented")
}

func RegisterIssuerSwitchRulesServer(s *grpc.Server, srv IssuerSwitchRulesServer) {
	s.RegisterService(&_IssuerSwitchRules_serviceDesc, srv)
}

func _IssuerSwitchRules_ListRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchRulesServer).ListRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/ListRules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchRulesServer).ListRules(ctx, req.(*ListRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchRules_ListRuleMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRuleMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchRulesServer).ListRuleMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/ListRuleMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchRulesServer).ListRuleMetadata(ctx, req.(*ListRuleMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchRules_ListRuleMetadataValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRuleMetadataValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchRulesServer).ListRuleMetadataValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/ListRuleMetadataValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchRulesServer).ListRuleMetadataValues(ctx, req.(*ListRuleMetadataValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchRules_BatchCreateRuleMetadataValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateRuleMetadataValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchRulesServer).BatchCreateRuleMetadataValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/BatchCreateRuleMetadataValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchRulesServer).BatchCreateRuleMetadataValues(ctx, req.(*BatchCreateRuleMetadataValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchRules_BatchDeleteRuleMetadataValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteRuleMetadataValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchRulesServer).BatchDeleteRuleMetadataValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules/BatchDeleteRuleMetadataValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchRulesServer).BatchDeleteRuleMetadataValues(ctx, req.(*BatchDeleteRuleMetadataValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IssuerSwitchRules_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchRules",
	HandlerType: (*IssuerSwitchRulesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRules",
			Handler:    _IssuerSwitchRules_ListRules_Handler,
		},
		{
			MethodName: "ListRuleMetadata",
			Handler:    _IssuerSwitchRules_ListRuleMetadata_Handler,
		},
		{
			MethodName: "ListRuleMetadataValues",
			Handler:    _IssuerSwitchRules_ListRuleMetadataValues_Handler,
		},
		{
			MethodName: "BatchCreateRuleMetadataValues",
			Handler:    _IssuerSwitchRules_BatchCreateRuleMetadataValues_Handler,
		},
		{
			MethodName: "BatchDeleteRuleMetadataValues",
			Handler:    _IssuerSwitchRules_BatchDeleteRuleMetadataValues_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/paymentgateway/issuerswitch/v1/rules.proto",
}
