/*
 * Copyright (C) 2014 Jared Boone, ShareBrained Technology, Inc.
 *
 * This file is part of PortaPack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __SPI_PP_H__
#define __SPI_PP_H__

#include <cstdint>

#include "ch.h"
#include "hal.h"

class SPI {
public:
	constexpr SPI(SPIDriver* const driver) :
		_driver(driver) {
	}

	void start(const SPIConfig& config) {
		spiStart(_driver, &config);
	}

	void stop() {
		spiStop(_driver);
	}

	void transfer(void* const data, const size_t count) {
		spiAcquireBus(_driver);
		spiSelect(_driver);
		spiExchange(_driver, count, data, data);
		spiUnselect(_driver);
		spiReleaseBus(_driver);
	}

private:
	SPIDriver* const _driver;
};

#endif/*__SPI_PP_H__*/
