/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng.classfile;

import org.argouml.language.java.reveng.classfile.ClassifierNotFoundException;
import org.argouml.language.java.reveng.classfile.Context;
import org.argouml.model.Model;

class OuterClassifierContext
extends Context {
    private Object mClassifier;
    private Object mPackage;
    private String namePrefix;
    private String packageJavaName;

    public OuterClassifierContext(Context base, Object theClassifier, Object thePackage, String theNamePrefix) {
        super(base);
        this.mClassifier = theClassifier;
        this.mPackage = thePackage;
        this.namePrefix = theNamePrefix;
        this.packageJavaName = this.getJavaName(thePackage);
    }

    public Object getInterface(String name) throws ClassifierNotFoundException {
        return this.get(name, true);
    }

    public Object get(String name) throws ClassifierNotFoundException {
        return this.get(name, false);
    }

    public Object get(String name, boolean interfacesOnly) throws ClassifierNotFoundException {
        Object iClassifier = Model.getFacade().lookupIn(this.mClassifier, name);
        if (iClassifier == null) {
            Class<?> classifier;
            String clazzName = this.namePrefix + name;
            if (!Model.getFacade().isAModel(this.mPackage)) {
                clazzName = this.packageJavaName + "." + this.namePrefix + name;
            }
            if ((classifier = this.findClass(clazzName, interfacesOnly)) != null) {
                iClassifier = classifier.isInterface() ? Model.getCoreFactory().buildInterface(name, this.mClassifier) : Model.getCoreFactory().buildClass(name, this.mClassifier);
            }
        }
        if (iClassifier == null && this.getContext() != null) {
            iClassifier = this.getContext().get(name, interfacesOnly);
        }
        return iClassifier;
    }
}

