/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.model.AttributeChangeEvent;
import org.argouml.model.Model;
import org.argouml.model.UmlChangeEvent;
import org.argouml.ui.UndoableAction;
import org.argouml.ui.targetmanager.TargetManager;

class UMLCallActionOperationComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = 7752478921939209157L;

    public UMLCallActionOperationComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected void buildModelList() {
        Object target = TargetManager.getInstance().getModelTarget();
        ArrayList<Object> ops = new ArrayList<Object>();
        if (Model.getFacade().isACallAction(target)) {
            Object ns = Model.getFacade().getModelElementContainer(target);
            while (!Model.getFacade().isAPackage(ns) && (ns = Model.getFacade().getModelElementContainer(ns)) != null) {
            }
            if (Model.getFacade().isANamespace(ns)) {
                Collection c = Model.getModelManagementHelper().getAllModelElementsOfKind(ns, Model.getMetaTypes().getClassifier());
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    ops.addAll(Model.getFacade().getOperations(i.next()));
                }
            }
            Object current = Model.getFacade().getOperation(target);
            if (Model.getFacade().isAOperation(current) && !ops.contains(current)) {
                ops.add(current);
            }
        }
        this.setElements(ops);
    }

    protected Object getSelectedModelElement() {
        Object target = TargetManager.getInstance().getModelTarget();
        if (Model.getFacade().isACallAction(target)) {
            return Model.getFacade().getOperation(target);
        }
        return null;
    }

    protected boolean isValidElement(Object element) {
        Object target = TargetManager.getInstance().getModelTarget();
        if (Model.getFacade().isACallAction(target)) {
            return element == Model.getFacade().getOperation(target);
        }
        return false;
    }

    public void modelChanged(UmlChangeEvent evt) {
        if (evt instanceof AttributeChangeEvent && evt.getPropertyName().equals("operation") && evt.getSource() == this.getTarget() && this.getChangedElement((PropertyChangeEvent)evt) != null) {
            Object elem = this.getChangedElement((PropertyChangeEvent)evt);
            this.setSelectedItem(elem);
        }
    }

    public Action getAction() {
        return new SetActionOperationAction();
    }

    private class SetActionOperationAction
    extends UndoableAction {
        private static final long serialVersionUID = -3574312020866131632L;

        public SetActionOperationAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object source = e.getSource();
            Object selected = ((UMLComboBox)source).getSelectedItem();
            Object target = UMLCallActionOperationComboBoxModel.this.getTarget();
            if (Model.getFacade().isACallAction(target) && Model.getFacade().isAOperation(selected) && Model.getFacade().getOperation(target) != selected) {
                Model.getCommonBehaviorHelper().setOperation(target, selected);
            }
        }
    }
}

