/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;

class UMLCallEventOperationComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = 2793208767387711088L;

    public UMLCallEventOperationComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected void buildModelList() {
        Object target = this.getTarget();
        ArrayList ops = new ArrayList();
        if (Model.getFacade().isACallEvent(target)) {
            Object ns = Model.getFacade().getNamespace(target);
            if (Model.getFacade().isAClassifier(ns)) {
                ns = Model.getFacade().getNamespace(ns);
            }
            Collection classifiers = Model.getModelManagementHelper().getAllModelElementsOfKind(ns, Model.getMetaTypes().getClassifier());
            for (Object classifier : classifiers) {
                ops.addAll(Model.getFacade().getOperations(classifier));
            }
            for (Object importedElem : Model.getModelManagementHelper().getAllImportedElements(ns)) {
                if (!Model.getFacade().isAClassifier(importedElem)) continue;
                ops.addAll(Model.getFacade().getOperations(importedElem));
            }
        }
        this.setElements(ops);
    }

    protected Object getSelectedModelElement() {
        Object target = this.getTarget();
        if (Model.getFacade().isACallEvent(target)) {
            return Model.getFacade().getOperation(target);
        }
        return null;
    }

    protected boolean isValidElement(Object element) {
        Object target = this.getTarget();
        if (Model.getFacade().isACallEvent(target)) {
            return element == Model.getFacade().getOperation(target);
        }
        return false;
    }

    public Action getAction() {
        return new SetAction();
    }

    private class SetAction
    extends UndoableAction {
        public SetAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object source = e.getSource();
            if (source instanceof UMLComboBox) {
                Object selected = ((UMLComboBox)source).getSelectedItem();
                Object target = ((UMLComboBox)source).getTarget();
                if (Model.getFacade().isACallEvent(target) && Model.getFacade().isAOperation(selected) && Model.getFacade().getOperation(target) != selected) {
                    Model.getCommonBehaviorHelper().setOperation(target, selected);
                }
            }
        }
    }
}

