/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.argouml.model.Model;

abstract class UMLExpressionModel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(UMLExpressionModel.class);
    private Object target;
    private String propertyName;
    private Object rememberExpression;
    private static final String EMPTYSTRING = "";
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;

    public UMLExpressionModel(Object target, String name) {
        this.target = target;
        this.propertyName = name;
        this.startListeningForModelChanges();
    }

    protected void startListeningForModelChanges() {
        if (Model.getFacade().isAUMLElement(this.target)) {
            Model.getPump().addModelEventListener((PropertyChangeListener)this, this.target, this.propertyName);
        }
        LOG.debug((Object)">>Start listening for UML changes...");
    }

    protected void stopListeningForModelChanges() {
        if (Model.getFacade().isAUMLElement(this.target)) {
            Model.getPump().removeModelEventListener((PropertyChangeListener)this, this.target, this.propertyName);
        }
        LOG.debug((Object)">>Stop listening for UML changes...");
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.propertyName.equals(e.getPropertyName())) {
            if (this.rememberExpression != e.getNewValue()) {
                this.fireStateChanged();
                LOG.debug((Object)">>UML expression changed.");
            } else {
                LOG.debug((Object)">>Got an event for a modelchange that we inflicted ourselves...");
            }
        }
    }

    protected Object getTarget() {
        return this.target;
    }

    public abstract Object getExpression();

    public abstract void setExpression(Object var1);

    public abstract Object newExpression(String var1, String var2);

    public String getLanguage() {
        Object expression = this.getExpression();
        if (expression == null) {
            return EMPTYSTRING;
        }
        String language = null;
        try {
            language = Model.getDataTypesHelper().getLanguage(expression);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return language;
    }

    public String getBody() {
        Object expression = this.getExpression();
        if (expression == null) {
            return EMPTYSTRING;
        }
        return Model.getFacade().getBody(expression).toString();
    }

    public void setLanguage(String lang) {
        String oldValue;
        Object expression = this.getExpression();
        boolean mustChange = true;
        if (expression != null && (oldValue = Model.getDataTypesHelper().getLanguage(expression)) != null && oldValue.equals(lang)) {
            mustChange = false;
        }
        if (mustChange) {
            String body = EMPTYSTRING;
            if (expression != null && Model.getDataTypesHelper().getBody(expression) != null) {
                body = Model.getDataTypesHelper().getBody(expression);
            }
            this.setExpression(lang, body);
        }
    }

    public void setBody(String body) {
        String oldValue;
        Object expression = this.getExpression();
        boolean mustChange = true;
        if (expression != null && (oldValue = Model.getFacade().getBody(expression).toString()) != null && oldValue.equals(body)) {
            mustChange = false;
        }
        if (mustChange) {
            String lang = null;
            if (expression != null) {
                lang = Model.getDataTypesHelper().getLanguage(expression);
            }
            if (lang == null) {
                lang = EMPTYSTRING;
            }
            this.setExpression(lang, body);
        }
    }

    private void setExpression(String lang, String body) {
        assert (lang != null);
        assert (body != null);
        this.rememberExpression = this.getExpression();
        this.stopListeningForModelChanges();
        if (this.rememberExpression != null) {
            Model.getUmlFactory().delete(this.rememberExpression);
        }
        this.rememberExpression = lang.length() == 0 && body.length() == 0 ? null : this.newExpression(lang, body);
        this.setExpression(this.rememberExpression);
        this.startListeningForModelChanges();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
        LOG.debug((Object)">>Add listener");
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
        LOG.debug((Object)">>Remove listener");
    }

    protected void fireStateChanged() {
        LOG.debug((Object)">>Fire state changed to listeners.");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

