/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.deployment2.diagram;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.argouml.deployment2.diagram.DeploymentDiagramGraphModel;
import org.argouml.deployment2.diagram.FigNode;
import org.argouml.deployment2.diagram.FigPort;
import org.argouml.i18n.Translator;
import org.argouml.model.DeleteInstanceEvent;
import org.argouml.model.DeploymentDiagram;
import org.argouml.model.Model;
import org.argouml.ui.CmdCreateNode;
import org.argouml.uml.diagram.ArgoDiagram;
import org.argouml.uml.diagram.DiagramElement;
import org.argouml.uml.diagram.DiagramFactory;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.deployment.ui.DeploymentDiagramRenderer;
import org.argouml.uml.diagram.deployment.ui.FigComponent;
import org.argouml.uml.diagram.deployment.ui.FigObject;
import org.argouml.uml.diagram.static_structure.ui.FigClass;
import org.argouml.uml.diagram.static_structure.ui.FigComment;
import org.argouml.uml.diagram.static_structure.ui.FigInterface;
import org.argouml.uml.diagram.ui.ActionSetAddAssociationMode;
import org.argouml.uml.diagram.ui.ActionSetMode;
import org.argouml.uml.diagram.ui.FigNodeModelElement;
import org.argouml.uml.diagram.ui.RadioAction;
import org.argouml.uml.diagram.ui.UMLDiagram;
import org.argouml.uml.diagram.use_case.ui.FigActor;
import org.argouml.util.ToolBarUtility;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.LayerPerspectiveMutable;
import org.tigris.gef.base.ModeCreatePolyEdge;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;

public class UMLDeploymentDiagram
extends UMLDiagram
implements DeploymentDiagram {
    private static final List acceptList = Arrays.asList(Model.getMetaTypes().getActor(), Model.getMetaTypes().getAssociation(), Model.getMetaTypes().getUMLClass(), Model.getMetaTypes().getComment(), Model.getMetaTypes().getComponent(), Model.getMetaTypes().getInterface(), Model.getMetaTypes().getNode(), Model.getMetaTypes().getObject(), Model.getMetaTypes().getPort());

    public UMLDeploymentDiagram(String name, Object namespace) {
        super(name, namespace, (GraphModel)new DeploymentDiagramGraphModel());
        if (name == null || name.trim().length() == 0) {
            name = this.getLabelName() + Model.getFacade().getName(namespace);
            try {
                this.setName(name);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.initialize(namespace);
    }

    public void initialize(Object o) {
        this.setNamespace(o);
        DeploymentDiagramGraphModel gm = this.createGraphModel();
        gm.setHomeModel(this.namespace);
        DeploymentDiagramRenderer rend = new DeploymentDiagramRenderer();
        LayerPerspectiveMutable lay = new LayerPerspectiveMutable(Model.getFacade().getName(this.namespace), (MutableGraphModel)gm);
        lay.setGraphNodeRenderer((GraphNodeRenderer)rend);
        lay.setGraphEdgeRenderer((GraphEdgeRenderer)rend);
        this.setLayer((LayerPerspective)lay);
        Model.getPump().addModelEventListener((PropertyChangeListener)((Object)this), this.namespace, new String[]{"remove"});
    }

    private DeploymentDiagramGraphModel createGraphModel() {
        if (this.getGraphModel() instanceof DeploymentDiagramGraphModel) {
            return (DeploymentDiagramGraphModel)this.getGraphModel();
        }
        return new DeploymentDiagramGraphModel();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.namespace && evt instanceof DeleteInstanceEvent) {
            Model.getPump().removeModelEventListener((PropertyChangeListener)((Object)this), this.namespace, new String[]{"remove"});
            if (this.getProject() != null) {
                this.getProject().moveToTrash((Object)this);
            } else {
                DiagramFactory.getInstance().removeDiagram((ArgoDiagram)this);
            }
        }
    }

    protected Object[] getUmlActions() {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(this.getNodeAction(Model.getMetaTypes().getNode()));
        actions.add(this.getNodeAction(Model.getMetaTypes().getPort()));
        actions.add(this.getNodeAction(Model.getMetaTypes().getComponent()));
        actions.add(this.getEdgeAction(Model.getMetaTypes().getGeneralization()));
        actions.add(this.getEdgeAction(Model.getMetaTypes().getAbstraction()));
        actions.add(this.getEdgeAction(Model.getMetaTypes().getDependency()));
        actions.add(this.getAssociationActions());
        actions.add(this.getNodeAction(Model.getMetaTypes().getObject()));
        actions.add(this.getEdgeAction(Model.getMetaTypes().getLink()));
        return actions.toArray();
    }

    private Object[] getAssociationActions() {
        Object[] actions = new Object[]{this.getAssociationActions(Model.getAggregationKind().getNone()), this.getAssociationActions(Model.getAggregationKind().getAggregate()), this.getAssociationActions(Model.getAggregationKind().getComposite())};
        ToolBarUtility.manageDefault((Object[])actions, (String)"diagram.deployment.association");
        return actions;
    }

    public String getLabelName() {
        return Translator.localize((String)"label.deployment-diagram");
    }

    private Action getNodeAction(Object metaType) {
        String label = this.getLabel(metaType);
        return new RadioAction((Action)new CmdCreateNode(metaType, label));
    }

    protected Action[] getAssociationActions(Object aggregation) {
        return new Action[]{this.getAssociationAction(aggregation, false), this.getAssociationAction(aggregation, true)};
    }

    protected Action getAssociationAction(Object aggregation, boolean unidirectional) {
        String label = Model.getAggregationKind().getComposite() == aggregation ? "composition" : (Model.getAggregationKind().getAggregate() == aggregation ? "aggregation" : "association");
        if (unidirectional) {
            label = "uni" + label;
        }
        label = "button.new-" + label;
        return new RadioAction((Action)new ActionSetAddAssociationMode(Model.getAggregationKind().getNone(), unidirectional, label));
    }

    private Action getEdgeAction(Object metaType) {
        String label = this.getLabel(metaType);
        return new RadioAction((Action)new ActionSetMode(ModeCreatePolyEdge.class, "edgeClass", metaType, label));
    }

    private String getLabel(Object metaType) {
        return "button.new-" + Model.getMetaTypes().getName(metaType).toLowerCase();
    }

    public boolean relocate(Object base) {
        return false;
    }

    public void encloserChanged(org.tigris.gef.presentation.FigNode enclosed, org.tigris.gef.presentation.FigNode oldEncloser, org.tigris.gef.presentation.FigNode newEncloser) {
    }

    public boolean doesAccept(Object objectToAccept) {
        for (Object element : acceptList) {
            if (!Model.getFacade().isA(Model.getMetaTypes().getName(objectToAccept), element)) continue;
            return true;
        }
        return false;
    }

    public DiagramElement createDiagramElement(Object modelElement, Rectangle bounds) {
        FigNodeModelElement figNode = null;
        DiagramSettings settings = this.getDiagramSettings();
        if (Model.getFacade().isANode(modelElement)) {
            figNode = new FigNode(modelElement, bounds, settings);
        } else if (Model.getFacade().isAPort(modelElement)) {
            figNode = new FigPort(modelElement, bounds, settings);
        } else if (Model.getFacade().isAAssociation(modelElement)) {
            figNode = this.createNaryAssociationNode(modelElement, bounds, settings);
        } else if (Model.getFacade().isAComponent(modelElement)) {
            figNode = new FigComponent(modelElement, bounds, settings);
        } else if (Model.getFacade().isAClass(modelElement)) {
            figNode = new FigClass(modelElement, bounds, settings);
        } else if (Model.getFacade().isAInterface(modelElement)) {
            figNode = new FigInterface(modelElement, bounds, settings);
        } else if (Model.getFacade().isAObject(modelElement)) {
            figNode = new FigObject(modelElement, bounds, settings);
        } else if (Model.getFacade().isAActor(modelElement)) {
            figNode = new FigActor(modelElement, bounds, settings);
        } else if (Model.getFacade().isAComment(modelElement)) {
            figNode = new FigComment(modelElement, bounds, settings);
        }
        return figNode;
    }

    public boolean isRelocationAllowed(Object base) {
        return false;
    }

    public Collection getRelocationCandidates(Object root) {
        return null;
    }
}

