/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class CutAction
extends UndoableAction {
    private static final long serialVersionUID = -5008218014474881077L;

    public CutAction(String name) {
        this(name, false);
    }

    public CutAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public CutAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public CutAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        System.out.println("[CmdCut] doIt");
        Editor ce = Globals.curEditor();
        SelectionManager selectionManager = ce.getSelectionManager();
        Vector copiedElements = selectionManager.selections();
        Vector<Fig> figs = new Vector<Fig>();
        Enumeration copies = copiedElements.elements();
        while (copies.hasMoreElements()) {
            Selection s = (Selection)copies.nextElement();
            Fig f = s.getContent();
            if (f instanceof FigEdge) continue;
            f = (Fig)f.clone();
            figs.addElement(f);
        }
        Globals.clipBoard = figs;
        selectionManager.removeFromGraph();
    }
}

