/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import org.tigris.gef.di.GraphElement;
import org.tigris.gef.graph.ConnectionConstrainer;
import org.tigris.gef.graph.GraphEvent;
import org.tigris.gef.graph.GraphListener;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;

public abstract class MutableGraphSupport
implements MutableGraphModel,
Serializable {
    private Vector _graphListeners;
    private ConnectionConstrainer connectionConstrainer;
    private static Action saveAction;

    public MutableGraphSupport() {
    }

    public MutableGraphSupport(ConnectionConstrainer cc) {
        this.connectionConstrainer = cc;
    }

    public List getGraphListeners() {
        return this._graphListeners;
    }

    public Object createNode(String name, Hashtable args) {
        Object newNode;
        try {
            newNode = Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
        catch (InstantiationException ignore) {
            return null;
        }
        if (newNode instanceof GraphNodeHooks) {
            ((GraphNodeHooks)newNode).initialize(args);
        }
        return newNode;
    }

    protected ConnectionConstrainer getConnectionConstrainer() {
        return this.connectionConstrainer;
    }

    public void setConnectionConstrainer(ConnectionConstrainer cc) {
        this.connectionConstrainer = cc;
    }

    public boolean canDragNode(Object node) {
        return false;
    }

    public void dragNode(Object node) {
    }

    public boolean canChangeConnectedNode(Object newNode, Object oldNode, Object edge) {
        return false;
    }

    public boolean canConnect(Object fromPort, Object toPort, Object edgeType) {
        boolean canConnect = false;
        canConnect = this.connectionConstrainer != null ? this.connectionConstrainer.isConnectionValid(edgeType, fromPort, toPort) : this.canConnect(fromPort, toPort);
        return canConnect;
    }

    public boolean canConnect(Object fromPort, Object toPort, Class edgeClass) {
        boolean canConnect = false;
        canConnect = this.connectionConstrainer != null ? this.connectionConstrainer.isConnectionValid(edgeClass, fromPort, toPort) : this.canConnect(fromPort, toPort);
        return canConnect;
    }

    public void changeConnectedNode(Object newNode, Object oldNode, Object edge, boolean isSource) {
    }

    public Object connect(Object fromPort, Object toPort, Object edgeClass) {
        return this.connect(fromPort, toPort);
    }

    public Object connect(Object fromPort, Object toPort, Object edgeType, Map styleAttributes) {
        return this.connect(fromPort, toPort);
    }

    public boolean containsNode(Object node) {
        List nodes = this.getNodes();
        return nodes.contains(node);
    }

    public boolean containsEdge(Object edge) {
        List edges = this.getEdges();
        return edges.contains(edge);
    }

    public boolean containsNodePort(Object port) {
        List nodes = this.getNodes();
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            List ports = this.getPorts(nodes.get(i));
            if (ports == null || !ports.contains(port)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEdgePort(Object port) {
        List edges = this.getNodes();
        if (edges == null) {
            return false;
        }
        for (int i = 0; i < edges.size(); ++i) {
            List ports = this.getPorts(edges.get(i));
            if (ports == null || !ports.contains(port)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPort(Object port) {
        return this.containsNodePort(port) || this.containsEdgePort(port);
    }

    public void addGraphEventListener(GraphListener listener) {
        if (this._graphListeners == null) {
            this._graphListeners = new Vector();
        }
        this._graphListeners.addElement(listener);
    }

    public void removeGraphEventListener(GraphListener listener) {
        if (this._graphListeners == null) {
            return;
        }
        this._graphListeners.removeElement(listener);
    }

    public void fireNodeAdded(Object node) {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, node);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.nodeAdded(ge);
        }
    }

    public void fireNodeRemoved(Object node) {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, node);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.nodeRemoved(ge);
        }
    }

    public void fireEdgeAdded(Object edge) {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, edge);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.edgeAdded(ge);
        }
    }

    public void fireEdgeRemoved(Object edge) {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, edge);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.edgeRemoved(ge);
        }
    }

    public void fireGraphChanged() {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, null);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.graphChanged(ge);
        }
    }

    public static void setSaveAction(Action action) {
        saveAction = action;
    }

    public static void enableSaveAction() {
        if (saveAction != null) {
            saveAction.setEnabled(true);
        }
    }

    public void removeNode(Object node) {
        this.fireNodeRemoved(node);
    }

    public void addNode(Object node) {
        this.fireNodeAdded(node);
    }

    public void addEdge(Object edge) {
        this.fireEdgeAdded(edge);
    }

    public void removeEdge(Object edge) {
        this.fireEdgeRemoved(edge);
    }

    public void removeFig(Fig fig) {
        if (fig instanceof GraphElement) {
            throw new IllegalArgumentException("Use removeEdge or removeNode to remove a complex Fig");
        }
        fig.removeFromDiagram();
        this.fireGraphChanged();
    }

    public void removeAllNodes() {
        this.fireGraphChanged();
    }

    public void removeAllEdges() {
        this.fireGraphChanged();
    }

    public void removeAll() {
        this.fireGraphChanged();
    }

    public boolean isEnclosable(Object handle, Object encloser) {
        return true;
    }
}

