/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.xmlresolver.ResourceCache;

public class CatalogResult {
    private static Logger logger = Logger.getLogger("org.xmlresolver");
    private String origURI = null;
    private String uri = null;
    private String contentType = null;
    private long cacheTime = -1L;
    private ResourceCache cache = null;
    private Element entry = null;

    public CatalogResult(String origURI, String uri) {
        this.uri = uri;
        this.origURI = origURI;
    }

    public CatalogResult(String origURI, String uri, Element entry, ResourceCache cache) {
        this.uri = uri;
        this.origURI = origURI;
        this.entry = entry;
        if (entry.hasAttributeNS("http://xmlresolver.org/ns/catalog", "time")) {
            this.cacheTime = Long.parseLong(entry.getAttributeNS("http://xmlresolver.org/ns/catalog", "time"));
        }
        if (entry.hasAttributeNS("http://xmlresolver.org/ns/catalog", "contentType")) {
            this.contentType = entry.getAttributeNS("http://xmlresolver.org/ns/catalog", "contentType");
        }
        if (this.cacheTime >= 0L) {
            this.cache = cache;
        }
    }

    public String uri() {
        return this.uri;
    }

    public String externalURI() {
        return this.origURI;
    }

    public String contentType() {
        return this.contentType;
    }

    public boolean cached() {
        return this.cache != null;
    }

    public InputStream body() throws MalformedURLException, IOException {
        InputStream body = null;
        URL url = new URL(this.uri);
        URLConnection connection = url.openConnection();
        connection.connect();
        body = connection.getInputStream();
        return body;
    }

    public boolean expired() {
        if (this.origURI == null || this.cache == null || !this.origURI.startsWith("http:")) {
            return false;
        }
        return this.cache.expired(this.origURI, this.uri, this.entry);
    }
}

