# 1 "matcher/lexer.mll"
 
  open Expect_test_common
  open Sexplib0.Sexp_conv

  let escaped s =
    let unescaped = Scanf.unescaped s in
    (* [test/test_matcher.ml] tests the behavior of [Scanf.unescaped] on newlines. *)
    if String.contains unescaped '\n'
    then
      failwith "(escaped) strings can't contain escaped newlines";
    Fmt.Literal unescaped

# 15 "matcher/lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\001\000\250\255\002\000\251\255\004\000\006\000\008\000\
    \011\000\013\000\015\000\018\000\047\000\020\000\052\000\054\000\
    \056\000\058\000\255\255\061\000\063\000\068\000\073\000\101\000\
    \115\000\117\000\254\255\119\000\126\000\128\000\133\000\152\000\
    \162\000\253\255\166\000\180\000\176\000\171\000\252\255\178\000\
    \191\000\215\000\219\000\204\000\233\000\240\000\243\000\019\001\
    \056\001\030\001\062\001\065\001\067\001\072\001\076\001\100\001\
    \081\001\113\001\115\001\127\001\154\001\129\001\178\001\191\001\
    \189\001\196\001\202\001\207\001\228\001\016\001\005\000\254\255\
    \023\001\255\255\025\001\133\001\113\000\187\000\235\001\140\001\
    \253\255\175\001\193\001\241\001\244\001\248\001\253\001\251\255\
    \252\255\023\000\255\001\004\002\018\002\023\002\028\002\036\002\
    \043\002\060\002\255\255\031\000\064\002\070\002\075\002\077\002\
    \080\002\085\002\088\002\096\002\044\000\109\002\112\002\115\002\
    \121\002\125\002\127\002\133\002\136\002\151\002\153\002\171\002\
    \139\002\142\002\199\002\079\000\202\002\207\002\210\002\255\255\
    \213\002\215\002\254\255\217\002\089\000\007\000\253\255\254\255\
    \075\003\255\255\121\003";
  Lexing.lex_backtrk =
   "\006\000\006\000\255\255\006\000\255\255\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\255\255\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\255\255\006\000\006\000\006\000\006\000\006\000\
    \006\000\255\255\006\000\006\000\006\000\006\000\255\255\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\002\000\002\000\255\255\
    \002\000\255\255\002\000\002\000\000\000\255\255\255\255\255\255\
    \255\255\001\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\002\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \001\000\255\255\255\255";
  Lexing.lex_default =
   "\003\000\001\000\000\000\003\000\000\000\039\000\003\000\003\000\
    \003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
    \003\000\003\000\000\000\003\000\003\000\003\000\003\000\003\000\
    \003\000\003\000\000\000\003\000\003\000\003\000\003\000\003\000\
    \003\000\000\000\003\000\003\000\003\000\003\000\000\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\072\000\070\000\000\000\
    \072\000\000\000\075\000\075\000\255\255\255\255\079\000\079\000\
    \000\000\255\255\079\000\079\000\079\000\079\000\079\000\000\000\
    \000\000\089\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \097\000\097\000\000\000\099\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\107\000\107\000\108\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\122\000\122\000\123\000\255\255\126\000\126\000\000\000\
    \255\255\126\000\000\000\255\255\132\000\135\000\000\000\000\000\
    \255\255\000\000\255\255";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\005\000\001\000\005\000\001\000\005\000\
    \001\000\005\000\001\000\000\000\005\000\001\000\005\000\001\000\
    \005\000\001\000\000\000\005\000\001\000\005\000\001\000\000\000\
    \000\000\087\000\005\000\000\000\005\000\000\000\005\000\000\000\
    \005\000\098\000\006\000\005\000\040\000\005\000\006\000\005\000\
    \006\000\000\000\005\000\006\000\005\000\006\000\098\000\006\000\
    \005\000\001\000\006\000\000\000\006\000\005\000\001\000\005\000\
    \001\000\005\000\001\000\005\000\001\000\000\000\005\000\001\000\
    \005\000\001\000\000\000\000\000\000\000\005\000\001\000\005\000\
    \000\000\000\000\005\000\001\000\005\000\000\000\005\000\006\000\
    \005\000\098\000\005\000\000\000\006\000\005\000\006\000\005\000\
    \006\000\017\000\006\000\131\000\005\000\006\000\000\000\006\000\
    \000\000\005\000\000\000\010\000\006\000\007\000\005\000\001\000\
    \027\000\006\000\009\000\000\000\034\000\012\000\019\000\000\000\
    \008\000\000\000\077\000\076\000\005\000\001\000\005\000\001\000\
    \005\000\001\000\011\000\136\000\014\000\005\000\000\000\005\000\
    \001\000\005\000\001\000\000\000\000\000\006\000\005\000\001\000\
    \013\000\077\000\000\000\005\000\000\000\005\000\000\000\005\000\
    \000\000\015\000\016\000\006\000\025\000\006\000\005\000\006\000\
    \005\000\005\000\001\000\000\000\021\000\005\000\006\000\000\000\
    \006\000\000\000\023\000\005\000\001\000\006\000\000\000\005\000\
    \001\000\020\000\000\000\000\000\005\000\001\000\022\000\000\000\
    \005\000\005\000\001\000\005\000\001\000\005\000\001\000\000\000\
    \006\000\032\000\005\000\000\000\077\000\076\000\005\000\000\000\
    \005\000\001\000\006\000\005\000\000\000\000\000\006\000\000\000\
    \005\000\024\000\005\000\006\000\005\000\005\000\001\000\000\000\
    \006\000\037\000\040\000\077\000\006\000\000\000\028\000\005\000\
    \005\000\001\000\000\000\029\000\005\000\001\000\000\000\040\000\
    \000\000\000\000\000\000\000\000\005\000\000\000\000\000\000\000\
    \000\000\000\000\005\000\001\000\040\000\031\000\000\000\005\000\
    \030\000\005\000\001\000\005\000\005\000\001\000\000\000\040\000\
    \002\000\255\255\004\000\040\000\255\255\255\255\004\000\134\000\
    \004\000\005\000\000\000\004\000\000\000\004\000\000\000\004\000\
    \005\000\040\000\004\000\005\000\004\000\035\000\036\000\088\000\
    \040\000\069\000\070\000\040\000\005\000\001\000\000\000\088\000\
    \074\000\070\000\074\000\070\000\044\000\000\000\041\000\005\000\
    \001\000\000\000\000\000\043\000\088\000\000\000\000\000\004\000\
    \069\000\042\000\000\000\005\000\004\000\052\000\004\000\074\000\
    \004\000\074\000\018\000\040\000\000\000\004\000\005\000\004\000\
    \059\000\005\000\001\000\065\000\004\000\000\000\040\000\005\000\
    \001\000\004\000\005\000\001\000\005\000\001\000\000\000\088\000\
    \000\000\005\000\001\000\046\000\047\000\005\000\001\000\000\000\
    \005\000\130\000\005\000\001\000\045\000\000\000\005\000\000\000\
    \040\000\005\000\000\000\005\000\000\000\004\000\040\000\051\000\
    \005\000\040\000\000\000\040\000\005\000\005\000\001\000\000\000\
    \040\000\005\000\000\000\004\000\040\000\026\000\000\000\004\000\
    \000\000\040\000\005\000\001\000\005\000\001\000\004\000\000\000\
    \004\000\000\000\050\000\048\000\005\000\004\000\000\000\000\000\
    \005\000\001\000\005\000\001\000\040\000\000\000\074\000\070\000\
    \000\000\005\000\000\000\005\000\000\000\089\000\087\000\000\000\
    \004\000\040\000\058\000\040\000\000\000\049\000\000\000\005\000\
    \000\000\005\000\033\000\005\000\001\000\074\000\004\000\040\000\
    \000\000\040\000\000\000\038\000\089\000\054\000\000\000\000\000\
    \004\000\000\000\004\000\000\000\004\000\000\000\000\000\053\000\
    \124\000\124\000\005\000\005\000\001\000\057\000\055\000\004\000\
    \000\000\000\000\040\000\000\000\000\000\056\000\005\000\001\000\
    \005\000\001\000\082\000\081\000\004\000\005\000\001\000\124\000\
    \000\000\000\000\005\000\005\000\001\000\000\000\000\000\004\000\
    \005\000\001\000\040\000\004\000\000\000\005\000\000\000\005\000\
    \000\000\082\000\000\000\000\000\005\000\040\000\060\000\040\000\
    \064\000\004\000\005\000\000\000\040\000\005\000\001\000\005\000\
    \004\000\000\000\040\000\004\000\082\000\081\000\000\000\040\000\
    \068\000\062\000\089\000\087\000\000\000\089\000\087\000\061\000\
    \000\000\089\000\087\000\000\000\005\000\000\000\089\000\087\000\
    \089\000\087\000\000\000\082\000\040\000\089\000\087\000\000\000\
    \071\000\089\000\000\000\004\000\089\000\000\000\000\000\073\000\
    \089\000\255\255\000\000\089\000\087\000\089\000\004\000\089\000\
    \089\000\087\000\063\000\000\000\089\000\089\000\087\000\086\000\
    \084\000\083\000\000\000\000\000\067\000\089\000\087\000\115\000\
    \000\000\109\000\089\000\066\000\089\000\087\000\000\000\089\000\
    \004\000\090\000\000\000\091\000\089\000\000\000\004\000\000\000\
    \092\000\018\000\000\000\004\000\096\000\099\000\098\000\000\000\
    \004\000\089\000\087\000\089\000\004\000\000\000\093\000\089\000\
    \087\000\004\000\000\000\094\000\089\000\087\000\089\000\087\000\
    \095\000\089\000\087\000\000\000\099\000\000\000\089\000\087\000\
    \089\000\089\000\087\000\000\000\004\000\000\000\089\000\085\000\
    \000\000\108\000\098\000\089\000\000\000\089\000\000\000\000\000\
    \089\000\004\000\000\000\026\000\100\000\106\000\089\000\087\000\
    \089\000\089\000\087\000\000\000\089\000\087\000\000\000\004\000\
    \108\000\004\000\089\000\087\000\000\000\073\000\089\000\087\000\
    \089\000\098\000\000\000\000\000\088\000\089\000\089\000\087\000\
    \089\000\089\000\087\000\089\000\089\000\087\000\000\000\089\000\
    \087\000\089\000\004\000\000\000\000\000\089\000\000\000\089\000\
    \089\000\087\000\089\000\087\000\000\000\089\000\000\000\000\000\
    \089\000\000\000\110\000\121\000\000\000\111\000\089\000\080\000\
    \112\000\000\000\004\000\000\000\089\000\087\000\113\000\089\000\
    \000\000\089\000\114\000\000\000\101\000\033\000\000\000\004\000\
    \000\000\080\000\102\000\116\000\004\000\000\000\117\000\103\000\
    \000\000\104\000\004\000\089\000\105\000\000\000\000\000\004\000\
    \123\000\098\000\000\000\124\000\124\000\118\000\000\000\119\000\
    \129\000\128\000\000\000\132\000\131\000\000\000\128\000\128\000\
    \129\000\128\000\131\000\131\000\038\000\000\000\000\000\123\000\
    \000\000\120\000\124\000\080\000\000\000\000\000\000\000\129\000\
    \000\000\088\000\132\000\000\000\088\000\128\000\000\000\129\000\
    \088\000\131\000\000\000\000\000\000\000\088\000\000\000\088\000\
    \000\000\000\000\000\000\000\000\088\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\088\000\000\000\000\000\000\000\000\000\088\000\
    \000\000\000\000\000\000\000\000\088\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\088\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\088\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\088\000\000\000\000\000\000\000\
    \088\000\000\000\000\000\000\000\000\000\000\000\088\000\000\000\
    \000\000\000\000\000\000\088\000\000\000\088\000\000\000\000\000\
    \088\000\000\000\000\000\000\000\000\000\088\000\000\000\000\000\
    \088\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \088\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\088\000\000\000\000\000\
    \088\000\000\000\000\000\088\000\000\000\000\000\000\000\000\000\
    \000\000\088\000\000\000\000\000\000\000\088\000\000\000\088\000\
    \000\000\000\000\000\000\000\000\000\000\088\000\000\000\000\000\
    \088\000\000\000\000\000\088\000\000\000\000\000\088\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\088\000\
    \000\000\088\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\138\000\088\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\138\000\138\000\000\000\088\000\
    \137\000\000\000\080\000\000\000\000\000\000\000\000\000\127\000\
    \000\000\000\000\130\000\000\000\000\000\127\000\000\000\127\000\
    \138\000\130\000\138\000\138\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\000\000\000\000\137\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\003\000\003\000\005\000\005\000\006\000\
    \006\000\007\000\007\000\255\255\008\000\008\000\009\000\009\000\
    \010\000\010\000\255\255\011\000\011\000\013\000\013\000\255\255\
    \000\000\089\000\003\000\255\255\005\000\255\255\006\000\255\255\
    \007\000\099\000\003\000\008\000\005\000\009\000\006\000\010\000\
    \007\000\255\255\011\000\008\000\013\000\009\000\108\000\010\000\
    \012\000\012\000\011\000\255\255\013\000\014\000\014\000\015\000\
    \015\000\016\000\016\000\017\000\017\000\255\255\019\000\019\000\
    \020\000\020\000\255\255\255\255\255\255\021\000\021\000\012\000\
    \255\255\255\255\022\000\022\000\014\000\255\255\015\000\012\000\
    \016\000\123\000\017\000\255\255\014\000\019\000\015\000\020\000\
    \016\000\016\000\017\000\132\000\021\000\019\000\255\255\020\000\
    \255\255\022\000\255\255\006\000\021\000\006\000\023\000\023\000\
    \008\000\022\000\006\000\255\255\007\000\011\000\009\000\255\255\
    \006\000\255\255\076\000\076\000\024\000\024\000\025\000\025\000\
    \027\000\027\000\010\000\133\000\013\000\023\000\255\255\028\000\
    \028\000\029\000\029\000\255\255\255\255\023\000\030\000\030\000\
    \012\000\076\000\255\255\024\000\255\255\025\000\255\255\027\000\
    \255\255\014\000\015\000\024\000\024\000\025\000\028\000\027\000\
    \029\000\031\000\031\000\255\255\020\000\030\000\028\000\255\255\
    \029\000\255\255\022\000\032\000\032\000\030\000\255\255\034\000\
    \034\000\019\000\255\255\255\255\037\000\037\000\021\000\255\255\
    \031\000\036\000\036\000\039\000\039\000\035\000\035\000\255\255\
    \031\000\031\000\032\000\255\255\077\000\077\000\034\000\255\255\
    \040\000\040\000\032\000\037\000\255\255\255\255\034\000\255\255\
    \036\000\023\000\039\000\037\000\035\000\043\000\043\000\255\255\
    \036\000\036\000\039\000\077\000\035\000\255\255\027\000\040\000\
    \041\000\041\000\255\255\028\000\042\000\042\000\255\255\040\000\
    \255\255\255\255\255\255\255\255\043\000\255\255\255\255\255\255\
    \255\255\255\255\044\000\044\000\043\000\030\000\255\255\041\000\
    \029\000\045\000\045\000\042\000\046\000\046\000\255\255\041\000\
    \000\000\001\000\003\000\042\000\005\000\070\000\006\000\133\000\
    \007\000\044\000\255\255\008\000\255\255\009\000\255\255\010\000\
    \045\000\044\000\011\000\046\000\013\000\034\000\035\000\089\000\
    \045\000\069\000\069\000\046\000\047\000\047\000\255\255\099\000\
    \072\000\072\000\074\000\074\000\040\000\255\255\040\000\049\000\
    \049\000\255\255\255\255\040\000\108\000\255\255\255\255\012\000\
    \069\000\040\000\255\255\047\000\014\000\043\000\015\000\072\000\
    \016\000\074\000\017\000\047\000\255\255\019\000\049\000\020\000\
    \042\000\048\000\048\000\041\000\021\000\255\255\049\000\050\000\
    \050\000\022\000\051\000\051\000\052\000\052\000\255\255\123\000\
    \255\255\053\000\053\000\045\000\046\000\054\000\054\000\255\255\
    \048\000\132\000\056\000\056\000\044\000\255\255\050\000\255\255\
    \048\000\051\000\255\255\052\000\255\255\023\000\050\000\050\000\
    \053\000\051\000\255\255\052\000\054\000\055\000\055\000\255\255\
    \053\000\056\000\255\255\024\000\054\000\025\000\255\255\027\000\
    \255\255\056\000\057\000\057\000\058\000\058\000\028\000\255\255\
    \029\000\255\255\049\000\047\000\055\000\030\000\255\255\255\255\
    \059\000\059\000\061\000\061\000\055\000\255\255\075\000\075\000\
    \255\255\057\000\255\255\058\000\255\255\079\000\079\000\255\255\
    \031\000\057\000\057\000\058\000\255\255\048\000\255\255\059\000\
    \255\255\061\000\032\000\060\000\060\000\075\000\034\000\059\000\
    \255\255\061\000\255\255\037\000\079\000\053\000\255\255\255\255\
    \036\000\255\255\039\000\255\255\035\000\255\255\255\255\052\000\
    \081\000\081\000\060\000\062\000\062\000\056\000\054\000\040\000\
    \255\255\255\255\060\000\255\255\255\255\055\000\064\000\064\000\
    \063\000\063\000\082\000\082\000\043\000\065\000\065\000\081\000\
    \255\255\255\255\062\000\066\000\066\000\255\255\255\255\041\000\
    \067\000\067\000\062\000\042\000\255\255\064\000\255\255\063\000\
    \255\255\082\000\255\255\255\255\065\000\064\000\059\000\063\000\
    \063\000\044\000\066\000\255\255\065\000\068\000\068\000\067\000\
    \045\000\255\255\066\000\046\000\078\000\078\000\255\255\067\000\
    \067\000\061\000\083\000\083\000\255\255\084\000\084\000\060\000\
    \255\255\085\000\085\000\255\255\068\000\255\255\086\000\086\000\
    \090\000\090\000\255\255\078\000\068\000\091\000\091\000\255\255\
    \069\000\083\000\255\255\047\000\084\000\255\255\255\255\072\000\
    \085\000\074\000\255\255\092\000\092\000\086\000\049\000\090\000\
    \093\000\093\000\062\000\255\255\091\000\094\000\094\000\078\000\
    \078\000\078\000\255\255\255\255\066\000\095\000\095\000\083\000\
    \255\255\084\000\092\000\065\000\096\000\096\000\255\255\093\000\
    \048\000\086\000\255\255\090\000\094\000\255\255\050\000\255\255\
    \091\000\051\000\255\255\052\000\095\000\097\000\097\000\255\255\
    \053\000\100\000\100\000\096\000\054\000\255\255\092\000\101\000\
    \101\000\056\000\255\255\093\000\102\000\102\000\103\000\103\000\
    \094\000\104\000\104\000\255\255\097\000\255\255\105\000\105\000\
    \100\000\106\000\106\000\255\255\055\000\255\255\101\000\078\000\
    \255\255\107\000\107\000\102\000\255\255\103\000\255\255\255\255\
    \104\000\057\000\255\255\058\000\085\000\105\000\109\000\109\000\
    \106\000\110\000\110\000\255\255\111\000\111\000\255\255\059\000\
    \107\000\061\000\112\000\112\000\255\255\075\000\113\000\113\000\
    \114\000\114\000\255\255\255\255\079\000\109\000\115\000\115\000\
    \110\000\116\000\116\000\111\000\120\000\120\000\255\255\121\000\
    \121\000\112\000\060\000\255\255\255\255\113\000\255\255\114\000\
    \117\000\117\000\118\000\118\000\255\255\115\000\255\255\255\255\
    \116\000\255\255\109\000\120\000\255\255\110\000\121\000\081\000\
    \111\000\255\255\062\000\255\255\119\000\119\000\112\000\117\000\
    \255\255\118\000\113\000\255\255\100\000\064\000\255\255\063\000\
    \255\255\082\000\101\000\115\000\065\000\255\255\116\000\102\000\
    \255\255\103\000\066\000\119\000\104\000\255\255\255\255\067\000\
    \122\000\122\000\255\255\124\000\124\000\117\000\255\255\118\000\
    \125\000\125\000\255\255\126\000\126\000\255\255\128\000\128\000\
    \129\000\129\000\131\000\131\000\068\000\255\255\255\255\122\000\
    \255\255\119\000\124\000\078\000\255\255\255\255\255\255\125\000\
    \255\255\083\000\126\000\255\255\084\000\128\000\255\255\129\000\
    \085\000\131\000\255\255\255\255\255\255\086\000\255\255\090\000\
    \255\255\255\255\255\255\255\255\091\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\092\000\255\255\255\255\255\255\255\255\093\000\
    \255\255\255\255\255\255\255\255\094\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\095\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\096\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\097\000\255\255\255\255\255\255\
    \100\000\255\255\255\255\255\255\255\255\255\255\101\000\255\255\
    \255\255\255\255\255\255\102\000\255\255\103\000\255\255\255\255\
    \104\000\255\255\255\255\255\255\255\255\105\000\255\255\255\255\
    \106\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \107\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\109\000\255\255\255\255\
    \110\000\255\255\255\255\111\000\255\255\255\255\255\255\255\255\
    \255\255\112\000\255\255\255\255\255\255\113\000\255\255\114\000\
    \255\255\255\255\255\255\255\255\255\255\115\000\255\255\255\255\
    \116\000\255\255\255\255\120\000\255\255\255\255\121\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\117\000\
    \255\255\118\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\136\000\119\000\136\000\136\000\136\000\136\000\
    \136\000\136\000\136\000\136\000\136\000\136\000\136\000\136\000\
    \136\000\136\000\136\000\136\000\136\000\136\000\136\000\136\000\
    \136\000\136\000\136\000\136\000\136\000\136\000\255\255\122\000\
    \136\000\255\255\124\000\255\255\255\255\255\255\255\255\125\000\
    \255\255\255\255\126\000\255\255\255\255\128\000\255\255\129\000\
    \138\000\131\000\138\000\138\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\138\000\138\000\138\000\138\000\
    \138\000\138\000\138\000\138\000\255\255\255\255\138\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255";
  Lexing.lex_base_code =
   "\000\000\000\000\000\000\002\000\000\000\004\000\006\000\008\000\
    \011\000\013\000\015\000\018\000\047\000\020\000\052\000\054\000\
    \056\000\058\000\137\000\061\000\063\000\068\000\073\000\101\000\
    \115\000\117\000\140\000\119\000\126\000\128\000\133\000\152\000\
    \162\000\143\000\166\000\180\000\176\000\171\000\146\000\178\000\
    \191\000\215\000\219\000\204\000\225\000\240\000\019\001\243\000\
    \030\001\025\001\062\001\065\001\068\001\072\001\078\001\082\001\
    \097\001\114\001\111\001\125\001\129\001\132\001\135\001\149\001\
    \176\001\178\001\189\001\191\001\202\001\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\113\000\016\001\
    \000\000\000\000\023\001\138\001\185\001\204\001\217\001\140\000\
    \137\000\228\001\235\001\241\001\244\001\246\001\248\001\252\001\
    \000\002\003\002\000\000\005\002\017\002\029\002\031\002\034\002\
    \037\002\041\002\043\002\045\002\047\002\049\002\061\002\074\002\
    \076\002\078\002\080\002\085\002\089\002\091\002\094\002\109\002\
    \118\002\121\002\124\002\127\002\000\000\130\002\133\002\000\000\
    \000\000\135\002\160\000\000\000\137\002\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_backtrk_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_default_code =
   "\001\000\000\000\000\000\001\000\000\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\000\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\000\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\000\000\001\000\001\000\001\000\001\000\000\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\149\000\149\000\
    \000\000\000\000\149\000\149\000\149\000\149\000\149\000\000\000\
    \000\000\149\000\149\000\149\000\149\000\149\000\149\000\149\000\
    \149\000\149\000\000\000\149\000\149\000\149\000\149\000\149\000\
    \149\000\149\000\149\000\149\000\149\000\149\000\149\000\149\000\
    \149\000\149\000\149\000\149\000\149\000\149\000\149\000\149\000\
    \149\000\149\000\149\000\149\000\000\000\154\000\154\000\000\000\
    \000\000\154\000\000\000\000\000\154\000\000\000\000\000\000\000\
    \000\000\000\000\000\000";
  Lexing.lex_trans_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\000\
    \000\000\081\000\000\000\000\000\095\000\000\000\109\000\000\000\
    \123\000\000\000\000\000\123\000\000\000\123\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\019\000\000\000\
    \081\000\000\000\010\000\095\000\010\000\109\000\028\000\123\000\
    \084\000\000\000\123\000\098\000\123\000\112\000\000\000\126\000\
    \123\000\000\000\126\000\000\000\126\000\123\000\000\000\123\000\
    \000\000\123\000\000\000\123\000\000\000\000\000\109\000\000\000\
    \109\000\000\000\000\000\000\000\000\000\109\000\000\000\123\000\
    \000\000\000\000\109\000\000\000\123\000\000\000\123\000\126\000\
    \123\000\000\000\123\000\000\000\126\000\109\000\126\000\109\000\
    \126\000\045\000\126\000\000\000\109\000\112\000\000\000\112\000\
    \000\000\109\000\000\000\045\000\112\000\054\000\109\000\000\000\
    \072\000\112\000\063\000\000\000\054\000\045\000\063\000\000\000\
    \072\000\000\000\000\000\000\000\109\000\000\000\109\000\000\000\
    \095\000\000\000\045\000\000\000\045\000\109\000\000\000\095\000\
    \000\000\095\000\000\000\000\000\000\000\112\000\095\000\000\000\
    \045\000\000\000\000\000\109\000\000\000\109\000\000\000\095\000\
    \000\000\045\000\045\000\112\000\063\000\112\000\095\000\098\000\
    \095\000\095\000\000\000\000\000\063\000\095\000\098\000\000\000\
    \098\000\000\000\063\000\095\000\000\000\098\000\000\000\081\000\
    \000\000\063\000\000\000\000\000\081\000\000\000\063\000\000\000\
    \095\000\081\000\000\000\000\000\000\000\081\000\000\000\000\000\
    \098\000\072\000\095\000\000\000\000\000\000\000\081\000\000\000\
    \019\000\000\000\098\000\081\000\000\000\000\000\084\000\000\000\
    \081\000\063\000\000\000\084\000\081\000\109\000\000\000\000\000\
    \084\000\054\000\010\000\000\000\084\000\000\000\072\000\019\000\
    \081\000\000\000\000\000\072\000\095\000\000\000\000\000\028\000\
    \000\000\000\000\123\000\000\000\109\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\112\000\072\000\000\000\081\000\
    \072\000\123\000\000\000\095\000\123\000\000\000\000\000\084\000\
    \000\000\123\000\000\000\098\000\000\000\000\000\000\000\000\000\
    \000\000\126\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \123\000\000\000\000\000\123\000\000\000\054\000\054\000\000\000\
    \126\000\000\000\000\000\126\000\123\000\000\000\000\000\000\000\
    \000\000\000\000\123\000\000\000\045\000\000\000\054\000\123\000\
    \000\000\000\000\000\000\063\000\000\000\000\000\000\000\000\000\
    \000\000\072\000\000\000\123\000\000\000\063\000\000\000\000\000\
    \000\000\123\000\000\000\126\000\000\000\000\000\123\000\000\000\
    \072\000\126\000\000\000\054\000\000\000\000\000\126\000\123\000\
    \000\000\000\000\123\000\000\000\000\000\109\000\000\000\000\000\
    \000\000\109\000\000\000\045\000\045\000\000\000\000\000\109\000\
    \000\000\000\000\000\000\109\000\000\000\000\000\123\000\000\000\
    \000\000\123\000\000\000\045\000\109\000\000\000\126\000\045\000\
    \109\000\126\000\109\000\000\000\112\000\000\000\109\000\000\000\
    \112\000\000\000\109\000\000\000\045\000\000\000\112\000\000\000\
    \109\000\000\000\112\000\109\000\000\000\045\000\000\000\000\000\
    \000\000\109\000\000\000\045\000\000\000\000\000\095\000\000\000\
    \000\000\112\000\095\000\000\000\000\000\095\000\000\000\109\000\
    \095\000\000\000\109\000\000\000\000\000\000\000\000\000\112\000\
    \000\000\000\000\112\000\063\000\000\000\095\000\095\000\000\000\
    \000\000\095\000\000\000\000\000\095\000\098\000\000\000\095\000\
    \000\000\098\000\000\000\000\000\098\000\063\000\000\000\098\000\
    \000\000\000\000\000\000\063\000\000\000\095\000\000\000\000\000\
    \063\000\095\000\000\000\081\000\000\000\098\000\072\000\000\000\
    \063\000\000\000\000\000\000\000\000\000\000\000\081\000\000\000\
    \081\000\000\000\000\000\000\000\000\000\063\000\000\000\000\000\
    \095\000\000\000\081\000\081\000\000\000\000\000\000\000\000\000\
    \098\000\000\000\084\000\000\000\000\000\081\000\000\000\081\000\
    \000\000\000\000\000\000\000\000\072\000\084\000\072\000\084\000\
    \054\000\000\000\081\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\084\000\000\000\000\000\000\000\000\000\072\000\
    \000\000\000\000\000\000\000\000\072\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\054\000\
    \000\000\054\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\157\000\000\000\000\000\000\000\000\000\
    \157\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\157\000\000\000\000\000\000\000\000\000\157\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000";
  Lexing.lex_check_code =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\003\000\003\000\005\000\005\000\006\000\
    \006\000\007\000\007\000\255\255\008\000\008\000\009\000\009\000\
    \010\000\010\000\255\255\011\000\011\000\013\000\013\000\255\255\
    \000\000\255\255\003\000\255\255\005\000\255\255\006\000\255\255\
    \007\000\255\255\003\000\008\000\005\000\009\000\006\000\010\000\
    \007\000\255\255\011\000\008\000\013\000\009\000\255\255\010\000\
    \012\000\012\000\011\000\255\255\013\000\014\000\014\000\015\000\
    \015\000\016\000\016\000\017\000\017\000\255\255\019\000\019\000\
    \020\000\020\000\255\255\255\255\255\255\021\000\021\000\012\000\
    \255\255\255\255\022\000\022\000\014\000\255\255\015\000\012\000\
    \016\000\255\255\017\000\255\255\014\000\019\000\015\000\020\000\
    \016\000\016\000\017\000\255\255\021\000\019\000\255\255\020\000\
    \255\255\022\000\255\255\006\000\021\000\006\000\023\000\023\000\
    \008\000\022\000\006\000\255\255\007\000\011\000\009\000\255\255\
    \006\000\255\255\078\000\078\000\024\000\024\000\025\000\025\000\
    \027\000\027\000\010\000\255\255\013\000\023\000\255\255\028\000\
    \028\000\029\000\029\000\255\255\255\255\023\000\030\000\030\000\
    \012\000\078\000\255\255\024\000\255\255\025\000\255\255\027\000\
    \255\255\014\000\015\000\024\000\024\000\025\000\028\000\027\000\
    \029\000\031\000\031\000\255\255\020\000\030\000\028\000\255\255\
    \029\000\255\255\022\000\032\000\032\000\030\000\255\255\034\000\
    \034\000\019\000\255\255\255\255\037\000\037\000\021\000\255\255\
    \031\000\036\000\036\000\039\000\039\000\035\000\035\000\255\255\
    \031\000\031\000\032\000\255\255\255\255\255\255\034\000\255\255\
    \040\000\040\000\032\000\037\000\255\255\255\255\034\000\255\255\
    \036\000\023\000\039\000\037\000\035\000\043\000\043\000\255\255\
    \036\000\036\000\039\000\255\255\035\000\255\255\027\000\040\000\
    \041\000\041\000\255\255\028\000\042\000\042\000\255\255\040\000\
    \255\255\255\255\044\000\044\000\043\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\043\000\030\000\255\255\041\000\
    \029\000\045\000\045\000\042\000\047\000\047\000\255\255\041\000\
    \000\000\044\000\003\000\042\000\005\000\255\255\006\000\255\255\
    \007\000\044\000\255\255\008\000\255\255\009\000\255\255\010\000\
    \045\000\255\255\011\000\047\000\013\000\034\000\035\000\255\255\
    \045\000\079\000\079\000\047\000\046\000\046\000\255\255\255\255\
    \082\000\082\000\049\000\049\000\040\000\255\255\040\000\048\000\
    \048\000\255\255\255\255\040\000\255\255\255\255\255\255\012\000\
    \079\000\040\000\255\255\046\000\014\000\043\000\015\000\082\000\
    \016\000\049\000\017\000\046\000\255\255\019\000\048\000\020\000\
    \042\000\049\000\255\255\041\000\021\000\255\255\048\000\050\000\
    \050\000\022\000\051\000\051\000\255\255\052\000\052\000\255\255\
    \255\255\053\000\053\000\045\000\044\000\255\255\255\255\054\000\
    \054\000\255\255\255\255\055\000\055\000\255\255\050\000\255\255\
    \255\255\051\000\255\255\047\000\052\000\023\000\050\000\050\000\
    \053\000\051\000\056\000\056\000\052\000\255\255\054\000\255\255\
    \053\000\078\000\055\000\024\000\046\000\025\000\054\000\027\000\
    \058\000\058\000\055\000\057\000\057\000\049\000\028\000\255\255\
    \029\000\056\000\255\255\048\000\255\255\030\000\059\000\059\000\
    \255\255\056\000\060\000\060\000\255\255\061\000\061\000\058\000\
    \062\000\062\000\057\000\083\000\083\000\255\255\255\255\058\000\
    \031\000\255\255\057\000\057\000\255\255\059\000\063\000\063\000\
    \255\255\060\000\032\000\255\255\061\000\059\000\034\000\062\000\
    \255\255\060\000\083\000\037\000\061\000\053\000\255\255\062\000\
    \036\000\255\255\039\000\055\000\035\000\063\000\255\255\255\255\
    \052\000\064\000\064\000\065\000\065\000\063\000\063\000\040\000\
    \054\000\255\255\084\000\084\000\255\255\255\255\066\000\066\000\
    \067\000\067\000\255\255\255\255\043\000\056\000\255\255\255\255\
    \064\000\255\255\065\000\068\000\068\000\085\000\085\000\041\000\
    \064\000\084\000\065\000\042\000\255\255\066\000\255\255\067\000\
    \255\255\044\000\086\000\086\000\059\000\066\000\060\000\067\000\
    \067\000\255\255\068\000\255\255\085\000\089\000\089\000\255\255\
    \045\000\255\255\068\000\047\000\090\000\090\000\255\255\062\000\
    \255\255\086\000\091\000\091\000\061\000\092\000\092\000\093\000\
    \093\000\094\000\094\000\255\255\089\000\095\000\095\000\255\255\
    \255\255\096\000\096\000\090\000\097\000\097\000\099\000\099\000\
    \079\000\091\000\255\255\046\000\092\000\255\255\093\000\082\000\
    \094\000\049\000\100\000\100\000\095\000\255\255\048\000\066\000\
    \096\000\065\000\255\255\097\000\255\255\099\000\101\000\101\000\
    \102\000\102\000\255\255\103\000\103\000\255\255\104\000\104\000\
    \255\255\100\000\105\000\105\000\106\000\106\000\107\000\107\000\
    \108\000\108\000\109\000\109\000\255\255\101\000\050\000\102\000\
    \255\255\051\000\103\000\255\255\052\000\104\000\110\000\110\000\
    \053\000\105\000\255\255\106\000\255\255\107\000\054\000\108\000\
    \255\255\109\000\055\000\111\000\111\000\112\000\112\000\113\000\
    \113\000\114\000\114\000\255\255\255\255\110\000\115\000\115\000\
    \255\255\056\000\116\000\116\000\117\000\117\000\255\255\118\000\
    \118\000\255\255\111\000\255\255\112\000\255\255\113\000\058\000\
    \114\000\255\255\057\000\255\255\255\255\115\000\119\000\119\000\
    \255\255\116\000\255\255\117\000\255\255\059\000\118\000\120\000\
    \120\000\060\000\121\000\121\000\061\000\122\000\122\000\062\000\
    \123\000\123\000\083\000\125\000\125\000\119\000\126\000\126\000\
    \129\000\129\000\132\000\132\000\255\255\063\000\120\000\255\255\
    \255\255\121\000\255\255\255\255\122\000\255\255\255\255\123\000\
    \255\255\255\255\125\000\255\255\255\255\126\000\255\255\129\000\
    \255\255\132\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \064\000\255\255\065\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\084\000\255\255\255\255\255\255\066\000\255\255\067\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\068\000\255\255\085\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\086\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\089\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\090\000\255\255\255\255\255\255\255\255\
    \255\255\091\000\255\255\255\255\092\000\255\255\093\000\255\255\
    \094\000\255\255\255\255\255\255\095\000\255\255\255\255\255\255\
    \096\000\255\255\255\255\097\000\255\255\099\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\100\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\101\000\255\255\102\000\
    \255\255\255\255\103\000\255\255\255\255\104\000\255\255\255\255\
    \255\255\105\000\255\255\106\000\255\255\107\000\255\255\108\000\
    \255\255\109\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\110\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\111\000\255\255\112\000\255\255\113\000\255\255\
    \114\000\255\255\255\255\255\255\255\255\115\000\255\255\255\255\
    \255\255\116\000\255\255\117\000\255\255\255\255\118\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\119\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\120\000\255\255\
    \255\255\121\000\255\255\255\255\122\000\255\255\255\255\123\000\
    \255\255\255\255\125\000\255\255\255\255\126\000\255\255\129\000\
    \255\255\132\000";
  Lexing.lex_code =
   "\255\004\255\003\255\002\255\001\255\255\008\255\007\255\006\255\
    \005\255\255\004\008\003\007\002\006\001\005\255\004\008\003\007\
    \002\006\001\005\008\255\007\255\006\255\005\255\255\005\255\004\
    \255\003\255\002\255\255\008\255\003\255\002\255\001\255\255\006\
    \255\004\255\003\255\001\255\255\007\255\004\255\002\255\001\255\
    \255\004\008\255\004\008\008\255\007\255\006\255\005\255\255\003\
    \007\255\003\007\008\255\007\255\006\255\005\255\255\002\006\255\
    \002\006\008\255\007\255\006\255\005\255\255\001\005\255\001\005\
    \008\255\007\255\006\255\005\255\255\000\001\255\000\002\255\000\
    \003\255\000\004\255\002\255\001\255\255\003\255\255\002\255\255\
    \001\003\000\002\255";
}

let rec pretty_line lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 9 (-1); __ocaml_lex_pretty_line_rec lexbuf 0
and __ocaml_lex_pretty_line_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 24 "matcher/lexer.mll"
                            s
# 673 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0) in
# 24 "matcher/lexer.mll"
                                                     ( escaped s  )
# 677 "matcher/lexer.ml"

  | 1 ->
let
# 25 "matcher/lexer.mll"
                            s
# 683 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0) in
# 25 "matcher/lexer.mll"
                                                     ( Literal s  )
# 687 "matcher/lexer.ml"

  | 2 ->
let
# 26 "matcher/lexer.mll"
                            s
# 693 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0) in
# 26 "matcher/lexer.mll"
                                                     ( Regexp  s  )
# 697 "matcher/lexer.ml"

  | 3 ->
let
# 27 "matcher/lexer.mll"
                            s
# 703 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0) in
# 27 "matcher/lexer.mll"
                                                     ( Glob    s  )
# 707 "matcher/lexer.ml"

  | 4 ->
let
# 28 "matcher/lexer.mll"
                            s
# 713 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 28 "matcher/lexer.mll"
                                                     ( Literal s  )
# 717 "matcher/lexer.ml"

  | 5 ->
# 29 "matcher/lexer.mll"
                                                     ( Literal "" )
# 722 "matcher/lexer.ml"

  | 6 ->
let
# 30 "matcher/lexer.mll"
          s
# 728 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 30 "matcher/lexer.mll"
            ( Printf.ksprintf invalid_arg "Lexer.pretty_line %S" s )
# 732 "matcher/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_pretty_line_rec lexbuf __ocaml_lex_state

and pretty_line_no_output_patterns lexbuf =
   __ocaml_lex_pretty_line_no_output_patterns_rec lexbuf 69
and __ocaml_lex_pretty_line_no_output_patterns_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 33 "matcher/lexer.mll"
                            s
# 745 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 33 "matcher/lexer.mll"
                                  ( Fmt.Literal s  )
# 749 "matcher/lexer.ml"

  | 1 ->
# 34 "matcher/lexer.mll"
                                  ( Literal "" )
# 754 "matcher/lexer.ml"

  | 2 ->
let
# 35 "matcher/lexer.mll"
          s
# 760 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 35 "matcher/lexer.mll"
            ( Printf.ksprintf invalid_arg
                "Lexer.pretty_line_no_output_patterns %S" s )
# 765 "matcher/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_pretty_line_no_output_patterns_rec lexbuf __ocaml_lex_state

and leading_spaces lexbuf =
   __ocaml_lex_leading_spaces_rec lexbuf 76
and __ocaml_lex_leading_spaces_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 39 "matcher/lexer.mll"
                      s
# 778 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 39 "matcher/lexer.mll"
                        ( s )
# 782 "matcher/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_leading_spaces_rec lexbuf __ocaml_lex_state

and lines_with_identation acc lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 3 (-1); __ocaml_lex_lines_with_identation_rec acc lexbuf 78
and __ocaml_lex_lines_with_identation_rec acc lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 42 "matcher/lexer.mll"
                       c
# 795 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos (lexbuf.Lexing.lex_curr_pos + -1) in
# 43 "matcher/lexer.mll"
    ( let line = Cst.Line.Conflict_marker c in
      lines_with_identation (line :: acc) lexbuf
    )
# 801 "matcher/lexer.ml"

  | 1 ->
let
# 46 "matcher/lexer.mll"
              sp
# 807 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos (lexbuf.Lexing.lex_curr_pos + -1) in
# 47 "matcher/lexer.mll"
    ( let line = Cst.Line.Blank sp in
      lines_with_identation (line :: acc) lexbuf
    )
# 813 "matcher/lexer.ml"

  | 2 ->
let
# 50 "matcher/lexer.mll"
                       tr
# 819 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 51 "matcher/lexer.mll"
    ( (List.rev acc,
       (* Add the newline that was consumed by the previous line. Since
          [lines_with_identation] is never called on blank strings, we know there is such
          a line. *)
       "\n" ^ tr) )
# 827 "matcher/lexer.ml"

  | 3 ->
let
# 56 "matcher/lexer.mll"
                            s
# 833 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 56 "matcher/lexer.mll"
                                         tr
# 838 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 57 "matcher/lexer.mll"
    ( let line =
        Cst.Line.Not_blank
          { orig = s
          ; data = ()
          ; trailing_blanks = ""
          }
      in
      (List.rev (line :: acc), tr)
    )
# 850 "matcher/lexer.ml"

  | 4 ->
let
# 66 "matcher/lexer.mll"
                            s
# 856 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 66 "matcher/lexer.mll"
                                         tr
# 861 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) (lexbuf.Lexing.lex_curr_pos + -1) in
# 67 "matcher/lexer.mll"
    ( let line =
        Cst.Line.Not_blank
          { orig = s
          ; data = ()
          ; trailing_blanks = tr
          }
      in
      lines_with_identation (line :: acc) lexbuf
    )
# 873 "matcher/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_lines_with_identation_rec acc lexbuf __ocaml_lex_state

and strip_surrounding_whitespaces lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 4 (-1);(* L=1 [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_strip_surrounding_whitespaces_rec lexbuf 125
and __ocaml_lex_strip_surrounding_whitespaces_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 78 "matcher/lexer.mll"
                           s
# 888 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 79 "matcher/lexer.mll"
    ( Cst.Empty s )
# 892 "matcher/lexer.ml"

  | 1 ->
let
# 80 "matcher/lexer.mll"
               leading
# 898 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 80 "matcher/lexer.mll"
                                          s
# 903 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 80 "matcher/lexer.mll"
                                                                 trailing
# 908 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(1) lexbuf.Lexing.lex_curr_pos in
# 81 "matcher/lexer.mll"
    ( Cst.Single_line
        { leading_blanks  = leading
        ; trailing_spaces = trailing
        ; orig            = s
        ; data            = ()
        }
    )
# 918 "matcher/lexer.ml"

  | 2 ->
# 89 "matcher/lexer.mll"
    ( let leading_spaces = leading_spaces lexbuf in
      let lines, trailing_spaces = lines_with_identation [] lexbuf in
      let indentation, lines = Cst.extract_indentation lines in
      Cst.Multi_lines
        { trailing_spaces
        ; leading_spaces
        ; indentation
        ; lines
        }
    )
# 932 "matcher/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_strip_surrounding_whitespaces_rec lexbuf __ocaml_lex_state

and quoted_string_terminators acc lexbuf =
   __ocaml_lex_quoted_string_terminators_rec acc lexbuf 133
and __ocaml_lex_quoted_string_terminators_rec acc lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 101 "matcher/lexer.mll"
                       s
# 945 "matcher/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) (lexbuf.Lexing.lex_curr_pos + -1) in
# 101 "matcher/lexer.mll"
                              ( quoted_string_terminators (s :: acc) lexbuf )
# 949 "matcher/lexer.ml"

  | 1 ->
# 102 "matcher/lexer.mll"
                              ( quoted_string_terminators       acc  lexbuf )
# 954 "matcher/lexer.ml"

  | 2 ->
# 103 "matcher/lexer.mll"
                              ( acc )
# 959 "matcher/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_quoted_string_terminators_rec acc lexbuf __ocaml_lex_state

;;

# 105 "matcher/lexer.mll"
 
  let strip_surrounding_whitespaces s =
    let lexbuf = Lexing.from_string s in
    let contents = strip_surrounding_whitespaces lexbuf in
    Cst.invariant ignore contents;
    contents

  let parse_pretty_line ~allow_output_patterns s =
    let lexbuf = Lexing.from_string s in
    if allow_output_patterns then
      pretty_line lexbuf
    else
      pretty_line_no_output_patterns lexbuf

  let parse_pretty ~allow_output_patterns s =
    let res =
      Cst.map (strip_surrounding_whitespaces s)
        ~f:(fun s () ->
          parse_pretty_line ~allow_output_patterns s)
    in
    (match Ppx_inline_test_lib.testing with
    | `Testing `Am_test_runner ->
      let cst = Cst.to_string res in
      if not (String.equal cst s)
      then
        failwith (Printf.sprintf "ppx_expect internal error: expected: %S, got: %S" s cst)
    | `Testing `Am_child_of_test_runner | `Not_testing -> ());
    res

  let parse_body ~allow_output_patterns body =
    Expectation.Body.map_pretty body ~f:(parse_pretty ~allow_output_patterns)

  let extract_quoted_string_terminators s =
    quoted_string_terminators [] (Lexing.from_string s)

# 1002 "matcher/lexer.ml"
