/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.trace;

import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.NodeHandler;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.trace.TraceListener;

public class SimpleTraceListener
implements TraceListener {
    String indent = "";

    public void open() {
        System.err.println("<trace>");
    }

    public void close() {
        System.err.println("</trace>");
    }

    public void toplevel(NodeInfo nodeInfo) {
        StyleElement styleElement = (StyleElement)nodeInfo;
        System.err.println("<Top-level element=\"" + styleElement.getDisplayName() + "\" line=\"" + styleElement.getLineNumber() + "\" file=\"" + styleElement.getSystemId() + "\" precedence=\"" + styleElement.getPrecedence() + "\"/>");
    }

    public void enterSource(NodeHandler nodeHandler, Context context) {
        NodeInfo nodeInfo = context.getContextNodeInfo();
        System.err.println(this.indent + "<Source node=\"" + Navigator.getPath(nodeInfo) + "\" line=\"" + nodeInfo.getLineNumber() + "\" mode=\"" + this.getModeName(context) + "\">");
        this.indent = this.indent + " ";
    }

    public void leaveSource(NodeHandler nodeHandler, Context context) {
        this.indent = this.indent.substring(0, this.indent.length() - 1);
        System.err.println(this.indent + "</Source><!-- " + Navigator.getPath(context.getContextNodeInfo()) + " -->");
    }

    public void enter(NodeInfo nodeInfo, Context context) {
        if (nodeInfo.getNodeType() == 1) {
            System.err.println(this.indent + "<Instruction element=\"" + nodeInfo.getDisplayName() + "\" line=\"" + nodeInfo.getLineNumber() + "\">");
            this.indent = this.indent + " ";
        }
    }

    public void leave(NodeInfo nodeInfo, Context context) {
        if (nodeInfo.getNodeType() == 1) {
            this.indent = this.indent.substring(0, this.indent.length() - 1);
            System.err.println(this.indent + "</Instruction> <!-- " + nodeInfo.getDisplayName() + " -->");
        }
    }

    String getModeName(Context context) {
        Mode mode = context.getMode();
        if (mode == null) {
            return "#none";
        }
        int n = mode.getNameCode();
        if (n == -1) {
            return "#default";
        }
        return context.getController().getNamePool().getDisplayName(n);
    }
}

