/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Average
extends Aggregate {
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType base = Atomizer.getAtomizedItemType(this.argument[0], false, th);
        if (base.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return BuiltInAtomicType.DOUBLE;
        }
        if (base.getPrimitiveType() == 533) {
            return BuiltInAtomicType.DECIMAL;
        }
        return base;
    }

    public int computeCardinality() {
        if (!Cardinality.allowsZero(this.argument[0].getCardinality())) {
            return 16384;
        }
        return super.computeCardinality();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return Average.average(this.argument[0].iterate(context), context, this);
    }

    public static AtomicValue average(SequenceIterator iter, XPathContext context, SourceLocator location) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        int count = 0;
        AtomicValue item = (AtomicValue)iter.next();
        if (item == null) {
            return null;
        }
        ++count;
        if (item instanceof UntypedAtomicValue) {
            try {
                item = item.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
            }
            catch (XPathException e) {
                e.maybeSetLocation(location);
                throw e;
            }
        }
        if (item instanceof NumericValue) {
            AtomicValue next;
            do {
                if ((next = (AtomicValue)iter.next()) == null) {
                    return ArithmeticExpression.compute(item, 3, new Int64Value(count), context);
                }
                ++count;
                if (next instanceof UntypedAtomicValue) {
                    try {
                        next = next.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
                    }
                    catch (XPathException e) {
                        e.maybeSetLocation(location);
                        throw e;
                    }
                } else {
                    if (next instanceof NumericValue) continue;
                    XPathException err = new XPathException("Input to avg() contains a mix of numeric and non-numeric values");
                    err.setXPathContext(context);
                    err.setErrorCode("FORG0006");
                    err.setLocator(location);
                    throw err;
                }
            } while (!(item = ArithmeticExpression.compute(item, 0, next, context)).isNaN() || !(item instanceof DoubleValue));
            return item;
        }
        if (item instanceof DurationValue) {
            while (true) {
                AtomicValue next;
                if ((next = (AtomicValue)iter.next()) == null) {
                    return ((DurationValue)item).multiply(1.0 / (double)count);
                }
                ++count;
                if (!(next instanceof DurationValue)) {
                    XPathException err = new XPathException("Input to avg() contains a mix of duration and non-duration values");
                    err.setXPathContext(context);
                    err.setErrorCode("FORG0006");
                    err.setLocator(location);
                    throw err;
                }
                item = ((DurationValue)item).add((DurationValue)next);
            }
        }
        XPathException err = new XPathException("Input to avg() contains a value that is neither numeric, nor a duration");
        err.setXPathContext(context);
        err.setErrorCode("FORG0006");
        err.setLocator(location);
        throw err;
    }
}

