/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.KeyDefinition;
import com.icl.saxon.KeyManager;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLKey
extends StyleElement {
    private int fingerprint;
    private Pattern match;
    private Expression use;

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        String string3 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n);
            } else if (n3 == standardNames.USE) {
                string3 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.MATCH) {
                string2 = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        if (!Name.isQName(string)) {
            this.compileError("Name of key must be a valid QName");
            return;
        }
        try {
            this.fingerprint = this.makeNameCode(string, false) & 0xFFFFF;
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        if (string2 == null) {
            this.reportAbsence("match");
        } else {
            this.match = this.makePattern(string2);
        }
        if (string3 == null) {
            this.reportAbsence("use");
        } else {
            this.use = this.makeExpression(string3);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.checkEmpty();
    }

    public void preprocess() throws TransformerConfigurationException {
        KeyManager keyManager = this.getPrincipalStyleSheet().getKeyManager();
        keyManager.setKeyDefinition(new KeyDefinition(this.fingerprint, this.match, this.use));
    }

    public void process(Context context) throws TransformerException {
    }

    public Binding bindVariable(int n) throws XPathException {
        throw new XPathException("The expressions in xsl:key may not contain references to variables");
    }
}

