// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['fs/model/status/StatusRestoreRoutes',
        'hp/core/Router',
        'fs/view/status/StatusStatePages'],
function (statusRestoreRoutes, router, statusStatePages) { "use strict";

    var StatusRoutes = ( function() {

        var CONTAINER = '#hp-page-container';

        function StatusRoutes() {

            var registered = false;
            var lastGoodLocation = null;
            var useLastGoodLocation = false;
            var statusLocationContext = '/';

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('status', '^/status$', {
                    menu: {
                        simpleBanner: true
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/status/index.html',
                                 'fs/view/status/StatusView'],
                        function (page, view) {
                            result.load(page, view);
                            view.setLocationContext(statusLocationContext);
                        });
                    }
                });

                router.filter('status filter', '^.*', {
                    check: function (location, result) {
                        require(['fs/presenter/status/StatusPresenter'],
                        function (statusPresenter) {
                            statusPresenter.getViewForServerStatus(function(view) {
                                if (view) {
                                    useLastGoodLocation = true;
                                    statusLocationContext = location;
                                    result.replaceWith('/status');
                                } else {
                                    if (useLastGoodLocation && lastGoodLocation) {
                                        result.redirectTo(lastGoodLocation);
                                        useLastGoodLocation = false;
                                    } else {
                                        useLastGoodLocation = false;
                                        lastGoodLocation = location;
                                        result.proceed();
                                    }
                                }
                            });
                        });
                    }
                });
                
                // If a restore failed, this shows a restore error before login 
                statusRestoreRoutes.register();
            };
            
 
        }

        return new StatusRoutes();
    }());

    return StatusRoutes;
});
