// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['fs/services/tasks/TasksService',
    'hp/core/EventDispatcher'], 
function(service, EventDispatcher) {"use strict";

    var ActivityTaskPresenter = ( function() {

        /**
         * @constructor
         * @type {ActivityPresenter}
         */
        function ActivityTaskPresenter() {

            var dispatcher = new EventDispatcher();

            /**
             * @public
             */
            this.init = function () {
            };
            
            /**
             * @public
             * Add a listener for a specified event.
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function (eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function (eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new ActivityTaskPresenter();
    }());

    return ActivityTaskPresenter;
});
