// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define([ 'hp/services/REST','jquery'],
function(REST) {"use strict";

    var BackupStatusService = (function() {

        /**
         * @constructor Service for retrieval of backup status
         * @type {BackupService}
         */
        function BackupStatusService() {

            /**
             * Gets a simple paginated collection which contains a backup resource
             * with the status of the last backup(if any).
             *
             * @param {{success:function(SimplePaginatedCollection):void, error:function(ErrorMessage):void}
             *     handlers Handler functions for success and error conditions.
             */
            this.getLastBackupStatus = function(handlers) {
                REST.getURI('/rest/backups', handlers);
            };
            
        }

        return new BackupStatusService();
    }());

    return BackupStatusService;
});