// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.

define(['hp/services/REST', 'jquery'], function(REST) { "use strict";

    var TasksService = (function() {
        
        var API_VERSION = 2,
            OPTS = {apiVersion: API_VERSION};
        
        function TasksService() {
            /**
             * Retrieves the event resource with the given uri
             * @param The unique identifier for a given event
             * @param {Object} handlers success and error handlers to call upon success or failure
             *          of the REST request.
             */
            this.getTaskByUri = function(uri, handlers) {
                REST.getURI(uri, handlers, OPTS);
            };
            
            
            /**
             * Retrieves a list of tasks based on the filters passed in
             * @param filters the filters used to retrieve the specific set of tasks
             * @param count the number of tasks to retrieve
             * @param sort an array containing the order the tasks should be sorted
             * @param {Object} handlers success and error handlers to call upon success or failure
             *  of the REST request.
             */
            this.getTasksByFilter = function(filters, count, sort, handlers) {
                var uri = "/rest/tasks?start=0&";

                // check if count was passed in
                if (count !== null && count !== undefined) {
                    uri = uri + "count=" + count;
                }

                // iterate through the filters and add them to the uri
                for(var i = 0;i<filters.length;i++) {
                    uri = uri + "&filter=\"" + filters[i] + "\"";
                }

                // check if the sort parameter was passed in
                if (sort !== null && sort !== undefined) {
                    uri = uri + "&sort=";
                    // iterate through the sort parameters and append them to the uri
                    for (var j = 0;j<sort.length;j++) {
                        uri = uri + sort[j];

                        if (j !== (sort.length-1)) {
                            uri = uri + "%2C";
                        }
                    }
                }

                REST.getURI(uri, handlers, OPTS);
            };
        }
        return new TasksService();
    }());
    return TasksService;
});
