// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['fs/presenter/settings/NetworkSetupPresenter',
        'hp/core/Notifications',
        'hp/view/FormStateView',
        'hp/core/Localizer',
        'jquery', 
        'lib/jquery.validate',
        'hp/lib/jquery.hpProgressBar',
        'hp/lib/jquery.hpToggle',
        'hp/lib/jquery.hpStackedPanels',
        'lib/jquery.selectBox',
        'hp/lib/jquery.hpTimestamp'],
function(presenter, notifications, FormStateView, localizer ) {"use strict";

    return ( function() {
        var HOSTNAME = '#cic-network-hostname', 
            IPV4ADDRSELECT = '#cic-network-ipv4',
            IPV6ADDRSELECT = '#cic-network-ipv6-selector',
            TWO_NODE_IPV6_LABEL = '#cic-network-two-node-ipv6-label', 
            DHCP_IPV4_WARNING = '#cic-network-DHCP-ipv4-warning', 
            DHCP_IPV6_WARNING = '#cic-network-DHCP-ipv6-warning',  
            DHCP_IPV4_DISALLOWED = '#cic-network-DHCP-ipv4-disallowed', 
            DHCP_IPV6_DISALLOWED = '#cic-network-DHCP-ipv6-disallowed',              
            GATEWAY_IPV4_WARNING = '#cic-network-GATEWAY-ipv4-warning', 
            GATEWAY_IPV6_WARNING = '#cic-network-GATEWAY-ipv6-warning',
            IPV4IPADDR = '#cic-network-ip-ipv4', 
            IPV4_2_IPADDR = '#cic-network-ip-ipv4-2',
            IPV4FLOATADDR = '#cic-network-cluster-ipv4', 
            IPV6FLOATADDR = '#cic-network-cluster-ipv6', 
            IPV6IPADDR = '#cic-network-ip-ipv6', 
            IPV6_2_IPADDR = '#cic-network-ip-ipv6-2',
            IPV4ADDRERRS = '#cic-network-ip-ipv4-errors', 
            IPV42_ADDRERRS = '#cic-network-ip-ipv4-2-errors',
            IPV6ADDRERRS = '#cic-network-ip-ipv6-errors', 
            IPV62_ADDRERRS = '#cic-network-ip-ipv6-2-errors',            
            IPV4FLOATADDRERRS = '#cic-network-floating-ip-ipv4-errors', 
            IPV6FLOATADDRERRS = '#cic-network-floating-ip-ipv6-errors', 
            IPV4MASK = '#cic-network-mask-ipv4', 
            IPV6MASK = '#cic-network-mask-ipv6', 
            IPV4_MASKERRS = '#cic-network-mask-ipv4-errors', 
            IPV6_MASKERRS = '#cic-network-mask-ipv6-errors', 
            IPV4GATEWAY = '#cic-network-gateway-ipv4', 
            IPV6GATEWAY = '#cic-network-gateway-ipv6', 
            IPV4_GATEWAYERRS = '#cic-network-gateway-ipv4-errors', 
            IPV6_GATEWAYERRS = '#cic-network-gateway-ipv6-errors', 
            NODE1_IPV4 = '#cic-network-node1-ipv4', 
            NODE1_IPV6 = '#cic-network-node1-ipv6', 
            NODE1_IPV4_ERRS = '#cic-network-node1-ipv4-errors', 
            NODE1_IPV6_ERRS = '#cic-network-node1-ipv6-errors', 
            NODE2_IPV4 = '#cic-network-node2-ipv4', 
            NODE2_IPV6 = '#cic-network-node2-ipv6', 
            NODE2_IPV4_ERRS = '#cic-network-node2-ipv4-errors', 
            NODE2_IPV6_ERRS = '#cic-network-node2-ipv6-errors', 
            DNS1 = '#cic-network-dns1', 
            DNS2 = '#cic-network-dns2',
            SPLASH_DIALOG_BASE = '#cic-network-splash-dialog',             
            SPLASH_PROGRESS_BASE = '#cic-network-splash-progress', 
            SPLASH_ESTIMATE_BASE = '#cic-network-splash-estimate', 
            SPLASH_BROWSER_WARNING = '#cic-network-splash-browserwarn',
            FLOATING_IPTYPE_LABEL = '#cic-network-floating-iptype-label',  
            SPINNER = '#cic-network-spinner', 
            HAS_ERROR = '#cic-network-form input.hp-error', 
            NOTIFY_MSG = ".hp-details-notify-message", 
            NOTIFICATION_COLOR_PREFIX = "hp-details-notify-", 
            IPV6_SWITCH = "#cic-network-ipv6-switch",
            HOSTNAME_LABEL = '#cic-selfsigned-label-comma-list-explain',
            IPv4_1_LABEL = '#cic-ip-selfsigned-label-comma-list-explain',
            AFFECTS_LAYOUT = '.cic-network-affects-layout', 
            IPV4FIELDS = '.cic-network-ipv4', 
            IPV6FIELDS = '.cic-network-ipv6', 
            DNSFIELDS = '.cic-network-dns', 
            IPV6_NONDHCP_FIELDS = ".cic-nonDHCP-ipv6", 
            ONE_NODE_LAYOUT = '.cic-one-node-layout', 
            TWO_NODE_LAYOUT = '.cic-two-node-layout';

        var DISABLED = 'disabled', 
            REQUIRED = 'required', 
            ADD = 'add', 
            REMOVE = 'remove', 
            FQDN = 'fqdn', 
            IPV4 = 'ipv4', 
            IPV6 = 'ipv6', 
            MASKV4 = 'maskv4', 
            MASKV6 = 'maskv6', 
            SIZE = 'size', 
            IPV6_SIZE = '45', 
            IPV4_SIZE = '15', 
            INVALID_PARAMETER_ERROR_CODE = 'INVALID_PARAMETER', 
            HIDDEN = "-hidden";

        var firstTimeFlag = false, 
            notifyResultFlag = true, 
            formStateView = new FormStateView(), routePrefix, form,
            fieldValueChangedFlag = false;


        var CLASS_IPV6_DISABLE = '.cic-fsnetwork-ipv6-remove', 
            CLASS_IPV4_DHCP_FIELDS = '.fs-network-IPv4-DHCP', 
            CLASS_IPV6_DHCP_FIELDS = '.fs-network-IPv6-DHCP', 
            CLASS_IPV4_CLUSTER_ADDR_DHCP = '.fs-network-IPv4-cluster-IP-DHCP', 
            CLASS_IPV6_CLUSTER_ADDR_DHCP = '.fs-network-IPv6-cluster-IP-DHCP', 
            CLASS_IPV4_NON_DHCP_ERRORS = '.ipv4-non-DHCP-errors', 
            CLASS_IPV6_NON_DHCP_ERRORS = '.ipv6-non-DHCP-errors',
            CLASS_SECOND_IP = '.cic-second-ip',
            CLASS_DHCP_SELECTOR = '.cic-dhcp-allowed',
            CLASS_IPV6_INPUT_FIELDS = '.cic-ipv6-fields',
            SPLASH_DIALOG, SPLASH_PROGRESS, SPLASH_ESTIMATE;
            
         var DNS_FROM_DHCP='.fs-network-dns-DHCP';
         
         var AUTOGENERATED_PREFIX='ci-';
         
         var HOSTNAME_ORIGINAL = '';
      
            

        function NetworkEditViewBase() {

            // The notification div to display notifications in.
            var notifyElement;

            // The validator for the form.
            var validator;

            // ID of the local node.
            var localNodeID;

            // Flag whether we are showing two-node (vs. one-node) configuration.
            var isTwoNode;

            // Network object to validate and apply.
            var networkObject;
            
            // original configuration
            
            var originalConfig;

            // Result of the validation call.
            var addressChangeInfo;

            // Splash dialog timer
            var splashTimer;
            
            // Is second IP configured
            
            var secondIPConfigured;
            
            // switching from manual to DHCP 
            var manualToDhcp = false;

            /**
             * @private Formats error information from a REST request
             * @param errorInfo {object} Rest request error information
             * @returns {String} Formatted error information to display
             */
            function formatNotificationDetails(errorInfo) {
             
                var resolution = (errorInfo.resolution && errorInfo.resolution !== '?') ? '</br>' + errorInfo.resolution : '';
                var message = (errorInfo.message && errorInfo.message !== '?') ? '</br>' + errorInfo.message : '';
               
                // we can't say that we were unable to apply network since most likely the settings were applied but we cannot
                // reach new network settings, hence instead of "Unable to apply netowrk settings" we say that "Appliance is no 
                //longer reachable"
                var failureNotificationDetails = ( (errorInfo.errorCode == presenter.REACHABLE_ERROR) || 
                                              (errorInfo.errorCode == presenter.MANUAL_TO_DHCP_ERROR) ) ? "</br>" + resolution :
                                               "</br>" + message + resolution;
                return failureNotificationDetails;
            }



            /**
             * @private Displays the  warning notification as well as details about the warnings
             * @param {string} message Message containing high level error message
             * @param {string} details Message containing error details
             * @param {string} messageType indicates the type of notification such as error
             */
            function displayTaskNotifications() {
                if (notifyResultFlag) {
                    var notif = {
                      sourceName: localizer.getString('fs.settings.network.notify.sourceName'),
                      summary: localizer.getString('fs.settings.network.notify.set.warning'),
                        status : 'error',
                        details : localizer.getString('fs.settings.network.notify.set.warning_resolution')

                   };
                    formStateView.setMessage(notif);
                    notifyResultFlag = false;

                }
            }
            /**
             * @private Displays an error notification as well as details about the error
             * @param {string} message Message containing high level error message
             * @param {string} details Message containing error details
             * @param {string} messageType indicates the type of notification such as error
             */
            function displayNotifications(message, details, type) {
                if (notifyResultFlag) {
                    var notif = {
                        sourceName: localizer.getString('fs.settings.network.notify.sourceName'),
                        summary : message,
                        status : 'error',
                        details : details
                    };
                    formStateView.setMessage(notif);
                
                    notifications.add(notif, true);
                    notifyResultFlag = false;
                }
            }


            /**
             * When the setNetworkConfiguration completes successfully,  notify the caller of success. 
             * The caller will dismiss the dialog
             * If we're supposed to redirect, give the caller a method to call to do that.
             */
            function onSetConfigSuccess(redirect, handlers) {
                
               // occasionaly the timeouts are set twice resulting this function being called twice on success
               // this causes duplicate messages in the notificication bar. The flag is to workaround this problem.
               // TODO : when doing two nodes revisit the timeouts resets
                                         
                if (notifyResultFlag) { 
                    var notif = {
                        sourceName: localizer.getString('fs.settings.network.notify.sourceName'),
                        summary : localizer.getString('fs.settings.network.notify.set.success'),
                        status : 'ok'
                    };
                    notifications.add(notif, true);
                    formStateView.setMessage(notif);   
                    notifyResultFlag = false;                  
                }
                
                if(redirect) {
                    handlers.success(function() {  
                        window.location.href = 'https://' + redirect;                       
                        return true;
                    });
                } else {  
                    handlers.success(null);
                }
            }

            /**
             * When the setNetworkConfiguration call returns success, indicating that the asynchronous change has started,
             * raise the splash dialog.
             */
            function onSetConfigRunning(timeout) {
                $(SPLASH_ESTIMATE).text(localizer.getString('fs.settings.network.dialog.redirect', [timeout / 1000]));
                if (presenter.shouldRedirect()){
                    $(SPLASH_BROWSER_WARNING).text(localizer.getString('fs.settings.network.dialog.browserwarn'));
                }
                $(SPLASH_DIALOG).dialog({
                    modal : true,
                    position : "center",
                    draggable : false,
                    resizable : false,
                    show : 'fade',
                    dialogClass : 'hp-splash-dialog', 
                    width : 400
                });

                // update progress
                $(SPLASH_PROGRESS).hpProgressBar(0);
                var done = 0;
                splashTimer = setInterval(function() {
                    done += 1000;
                    $(SPLASH_PROGRESS).hpProgressBar((done * 100) / timeout);
                }, 1000);
            }

           /**
             * Dismiss dialog with teh spiiner
           */            
            function dismissDialogWindow () {
          
                if(splashTimer) {
                    clearTimeout(splashTimer);
                    splashTimer = null;                    
                    $(SPLASH_DIALOG).dialog('destroy');
                     
 
                }


             }
            /**
             * @private Add a server side error to the list of errors that the validator will display
             * @param {object} validatorErrors The list of errors that the validator will display
             * @param {object} errorFromServer The error from a REST response body to add to the list
             */
            function addValidatorError(validatorErrors, errorFromServer) {
                var errorMessage = errorFromServer.message;
                var sourceId = errorFromServer.errorSource;
                var handled = true;

                // first check for any sourceIds  containing 'hostname' keyword  as fts added new keywords
                // for possible future multiple hostnames taht are associated with the hostname field
                // TOD: narrow down to the fields only pertinent to GUI ad falg all others as invalid parameters
                // will do it when fts solidifies their design

                if(/hostName/.test(sourceId)) {
                    $.extend(validatorErrors, {
                        'hostname' : errorMessage
                    });


                    return handled;
                }
                switch (sourceId) {

                    case 'domainName':
                        // fts has change the logic where they return two separate erros : one for the hostname
                        // and one for the domain. Need to concatenate these message to display them next to
                        // hostname field
                        var s1 = validatorErrors.hostname;
                        if(s1 == undefined) {
                            $.extend(validatorErrors, {
                                'hostname' : errorMessage
                            });
                        } else {
                            validatorErrors.hostname = s1 + "<br>" + errorMessage;
                        }
                        break;

                    case 'app1Ipv4Addr' :
                        if(isTwoNode) {
                            validatorErrors['node1-ipv4'] = errorMessage;
                        } else if(localNodeID == 1) {
                            $.extend(validatorErrors, {
                                'ip-ipv4' : errorMessage
                            });
                        } else {
                            handled = false;
                        }
                        break;
                    case 'app1Ipv6Addr' :
                        if(isTwoNode) {
                            validatorErrors['node1-ipv6'] = errorMessage;
                        } else if(localNodeID == 1) {
                            $.extend(validatorErrors, {
                                'ip-ipv6' : errorMessage
                            });
                        } else {
                            handled = false;
                        }
                        break;
                    case 'app2Ipv4Addr' :
                        if(isTwoNode) {
                            validatorErrors['node2-ipv4'] = errorMessage;
                        } else if(localNodeID == 2) {
                            $.extend(validatorErrors, {
                                'ip-ipv4' : errorMessage
                            });
                        } else {
                            handled = false;
                        }
                        break;
                    case 'app2Ipv6Addr' :
                        if(isTwoNode) {
                            validatorErrors['node2-ipv6'] = errorMessage;
                        } else if(localNodeID == 2) {
                            $.extend(validatorErrors, {
                                'ip-ipv6' : errorMessage
                            });
                        } else {
                            handled = false;
                        }
                        break;
                    case 'virtIpv4Addr' :
                        if(isTwoNode) {
                            validatorErrors['ip-ipv4'] = errorMessage;
                        } else {
                            handled = false;
                        }
                        break;
                    case 'virtIpv6Addr' :
                        if(isTwoNode) {
                            validatorErrors['ip-ipv6'] = errorMessage;
                        } else {
                            handled = false;
                        }
                        break;
                    case 'ipv4Subnet' :
                        $.extend(validatorErrors, {
                            'mask-ipv4' : errorMessage
                        });
                        break;
                    case 'ipv6Subnet' :
                        $.extend(validatorErrors, {
                            'mask-ipv6' : errorMessage
                        });
                        break;
                    case 'ipv4Gateway' :
                        $.extend(validatorErrors, {
                            'gateway-ipv4' : errorMessage
                        });
                        break;
                    case 'ipv6Gateway' :
                        $.extend(validatorErrors, {
                            'gateway-ipv6' : errorMessage
                        });
                        break;

                    case 'nameServer1' :
                        $.extend(validatorErrors, {
                            'dns1' : errorMessage
                        });
                        break;
                    case 'nameServer2' :
                        $.extend(validatorErrors, {
                            'dns2' : errorMessage
                        });
                        break;
                    case 'app1Ipv4Alias' :
                        $.extend(validatorErrors, {
                            'ip-ipv4-2' : errorMessage
                        });
                        break;
                    case 'app1Ipv6Alias' :
                        $.extend(validatorErrors, {
                            'ip-ipv6-2' : errorMessage
                        });
                        break;

                    default:
                        handled = false;
                        break;
                }
                return handled;
            }


            /**
             * @private Display invalid parameter errors from the server
             * @param {object} errorInfo The response body generated by a server exception
             */
            function handleParameterErrorsFromServer(errorInfo) {
                var validatorErrors = {};
                var serverErrorList = errorInfo.nestedErrors;
                var serverError;
                var handled = true;
                for(serverError in serverErrorList) {
                    if(!addValidatorError(validatorErrors, serverErrorList[serverError])) {
                        handled = false;
                    }
                }
                validator.showErrors(validatorErrors);

                return handled;
            }
            /**
             * @private Display invalid parameter warnings from the server
             * @param {object} errorInfo The response body generated by a server exception
             */
            function handleTaskErrors(errorInfo) {
                var validatorErrors = {};
                var serverErrorList = errorInfo;
                var serverError;
                var handled = true;
                for(serverError in serverErrorList) {
                    if(!addValidatorError(validatorErrors, serverErrorList[serverError])) {
                        handled = false;
                    }
                }
                validator.showErrors(validatorErrors);
                return handled;
            }

            /**
             * @public Handle failed validation by printing error messages
             * @param {object} errorInfo The response body generated by a server exception
             */
            function onSetConfigError(errorInfo) {


                dismissDialogWindow();
                // handle the Backend warnings returned from taskt
                if(errorInfo instanceof Array ){
                    handleTaskErrors(errorInfo);
                     displayTaskNotifications();
                  }else{
                      if(errorInfo.errorCode == INVALID_PARAMETER_ERROR_CODE) {
                          handleParameterErrorsFromServer(errorInfo);
                      }
                      var applyErrorMsg = ( (errorInfo.errorCode == presenter.MANUAL_TO_DHCP_ERROR) ||
                              (errorInfo.errorCode == presenter.REACHABLE_ERROR) ) ? errorInfo.message :
                              localizer.getString('fs.settings.network.notify.set.error');
                          var failureNotificationDetails = formatNotificationDetails(errorInfo);

                          displayNotifications(applyErrorMsg, failureNotificationDetails, 'error');
                  }
            }

            /**
             * @public Handle failed validation by printing error messages
             * @param {object} errorInfo The response body generated by a server exception
             */
            function onSetConfigValidationError(errorInfo) {

                dismissDialogWindow();

                if(errorInfo.errorCode == INVALID_PARAMETER_ERROR_CODE) {
                    handleParameterErrorsFromServer(errorInfo);
                }

                var applyErrorMsg = ( (errorInfo.errorCode == presenter.MANUAL_TO_DHCP_ERROR) ||
                    (errorInfo.errorCode == presenter.REACHABLE_ERROR) ) ? errorInfo.message :
                    localizer.getString('fs.settings.network.notify.set.error');
                var failureNotificationDetails = formatNotificationDetails(errorInfo);

                displayNotifications(applyErrorMsg, failureNotificationDetails, 'error');


            }


            /**
             * @public Handle successful validation by applying the settings
             * @param {object} response The response body from request to
             *        validate the network configuration
             */
            function onValidateConfigSuccess(response, handlers) {
                addressChangeInfo = response;
                var progressMsg = localizer.getString('fs.settings.network.notify.set.start');
                formStateView.setMessage({
                    summary : progressMsg
                });
                presenter.setNetworkConfiguration(networkObject, {
                    running : onSetConfigRunning,
                    success : function(data) {
                        onSetConfigSuccess(data, handlers);
                    },
                    error : function(errorInfo) {
                        onSetConfigError(errorInfo);
                        handlers.error(errorInfo);
                    }
                });
            }

            /**
             * Override the placement of error messages for the IP address lines.
             *
             * @param {Element} error The error label generated by the validator.
             * @param {Element} element The form element that failed validation.
             */
            function errorPlacementMethod(error, element) {
                switch (element.attr('name')) {
                    case 'ip-ipv4':
                        error.appendTo($(IPV4ADDRERRS));
                        break;
                    case 'ip-ipv4-2':
                        error.appendTo($(IPV42_ADDRERRS));
                        break;
                    case 'ip-ipv6':
                        error.appendTo($(IPV6ADDRERRS));
                        break;
                     case 'ip-ipv6-2':
                        error.appendTo($(IPV62_ADDRERRS));
                        break;
                    case 'floating-ip-ipv4':
                        error.appendTo($(IPV4FLOATADDRERRS));
                        break;
                    case 'floating-ip-ipv6':
                        error.appendTo($(IPV6FLOATADDRERRS));
                        break;
                    case 'node1-ipv4':
                        error.appendTo($(NODE1_IPV4_ERRS));
                        break;
                    case 'node1-ipv6':
                        error.appendTo($(NODE1_IPV6_ERRS));
                        break;
                    case 'node2-ipv4':
                        error.appendTo($(NODE2_IPV4_ERRS));
                        break;
                    case 'node2-ipv6':
                        error.appendTo($(NODE2_IPV6_ERRS));
                        break;
                    case 'mask-ipv4':
                        error.appendTo($(IPV4_MASKERRS));
                        break;
                    case 'mask-ipv6':
                        error.appendTo($(IPV6_MASKERRS));
                        break;
                    case 'gateway-ipv4':
                        error.appendTo($(IPV4_GATEWAYERRS));
                        break;
                    case 'gateway-ipv6':
                        error.appendTo($(IPV6_GATEWAYERRS));
                        break;
                    default:
                        error.insertAfter(element);
                        break;
                }
            }

             /*
              * set dnsFromDHCP reflecting how user specified DNS servers
              * 
              */
             function getDnsFromDHCPFlag() {
   
                
                // if a user selects static address , set the flag to false
                if ( ($(IPV4ADDRSELECT).val() == 'STATIC') || secondIPConfigured)  {
                     return false;
                 }            
                // if a user specified DHCP and no DNS servers , return true
                 if( ($(IPV4ADDRSELECT).val() == 'DHCP') &&
                     ((!$(DNS1).val()) && (!$(DNS2).val())) )  {
                     return true;     
                 } 
   
                 //if a user specified  DHCP and DNS servers , return false
                 if  ( $(DNS1).val()  ||  $(DNS2).val() ) {
                     // DHCP -> DHCP case
                     if ( (originalConfig.priDns ==  $(DNS1).val() ) &&   
                         (originalConfig.altDns ==  $(DNS2).val() ) ) {
                             // if the values did not change 
                         return true;
                     } else {
                         // a user typed in new vlaues
                         return false;
                     }             
                 } else {
                     return false;
                 }
                 // otherwise leave the flag untouched
                 return(originalConfig.dnsFromDHCP);
             }
             
            /**
             * @private Read the form data into an object understood by the presenter.
             * @return {Object} the network data
             */
            function marshalFormData(allowTransientValidationErrors) {
                // Fill in the basic fields.
                var networkObject = {
                    ipv4Type : secondIPConfigured ? presenter.STATIC : $(IPV4ADDRSELECT).val(),
                    ipv6Type : $(IPV6_SWITCH).is(':checked') ? $(IPV6ADDRSELECT).val() : presenter.UNCONFIGURE,
                    hostname : $(HOSTNAME).val(),
                    domainName : presenter.getDomainName($(HOSTNAME).val(), $(DNS1).val(), $(DNS2).val()),
                    priDns : $(DNS1).val(),
                    altDns : $(DNS2).val(),
                    localNodeID : localNodeID,
                    confOneNode : !isTwoNode,
                    allowTransientValidationErrors:allowTransientValidationErrors,
                    addrs : {
                        node1 : {},
                        node2 : {},
                        cluster : {}
                    }
                };
                
               networkObject.dnsFromDHCP = getDnsFromDHCPFlag();
               if (secondIPConfigured) {
                   networkObject.ipv6Type = $(IPV6_SWITCH).is(':checked') ? presenter.STATIC : presenter.UNCONFIGURE;
               } else {
                    networkObject.ipv6Type = $(IPV6_SWITCH).is(':checked') ? $(IPV6ADDRSELECT).val() : presenter.UNCONFIGURE;
               }
                // Update the address types based on the two-node selectors.

               if(isTwoNode) {
                    networkObject.addrs.cluster.ipv4 = $(IPV4FLOATADDR).val();
               } else if(networkObject.ipv4Type == presenter.STATIC) {
                    networkObject.addrs["node" + localNodeID].ipv4 = $(IPV4IPADDR).val();
                    if (secondIPConfigured) {
                       networkObject.addrs["node" + localNodeID].ipv4_2 = $(IPV4_2_IPADDR).val();                      
                    }
               }
             
               networkObject.ipv4Subnet = $(IPV4MASK).val();
               networkObject.ipv4Gateway = $(IPV4GATEWAY).val() || null;
            


               if(isTwoNode) {
                 networkObject.addrs.node1.ipv4 = $(NODE1_IPV4).val();
                 networkObject.addrs.node2.ipv4 = $(NODE2_IPV4).val();
               }
                if($(IPV6_SWITCH).is(':checked') === true) {
                    if(isTwoNode) {
                        networkObject.addrs.cluster.ipv6 = $(IPV6FLOATADDR).val();
                    } else {
                        networkObject.addrs["node" + localNodeID].ipv6 = $(IPV6IPADDR).val();
                        if (secondIPConfigured) {
                            networkObject.addrs["node" + localNodeID].ipv6_2 = $(IPV6_2_IPADDR).val();  
                        }
                    }
                   networkObject.ipv6Subnet = $(IPV6MASK).val();
                   networkObject.ipv6Gateway = $(IPV6GATEWAY).val() || null;

                   if (isTwoNode) {
                    networkObject.addrs.node1.ipv6 = $(NODE1_IPV6).val();
                    networkObject.addrs.node2.ipv6 = $(NODE2_IPV6).val();
                   }
                }
                 return networkObject;
            }

            /**
             * @private Revise the validation rules on the hostname field.
             * @param {Object} networkData The current network data.
             */
            function updateHostname(networkData) {
                $(HOSTNAME).rules(REMOVE);
                if(presenter.fqdnRequired(networkData)) {
                    var message = localizer.getString('fs.settings.network.validator.hostname.fqdn_required');
                    $(HOSTNAME).rules(ADD, {
                      readCert : [],
                        hostAddress : FQDN,
                        required : true,
                        messages : {
                            hostAddress : message,
                            required : message
                        }
                    });
                } else {
                    $(HOSTNAME).rules(ADD, {
                      readCert : [],
                        hostAddress : ['hostname', FQDN],
                        messages : {
                          hostAddress : localizer.getString('fs.settings.network.validator.hostname.fqdn_optional')
                        }
                    });
                }
            }
            
            /**
             * Rule for HOSTNAME field
             */
            $.validator.addMethod("readCert", function(
                value, element, param) {

              // field is not required
                if (!value) {
                    return true;
                }
                presenter.getCertificate({

                  success: function(certObject) {
                        var cn = certObject.commonName;
                        var issuer = certObject.issuer;
                        var message;
                        /*
                         * check if certificate is self signed or CA signed and display warning message based on that
                         */
                        if (cn === HOSTNAME_ORIGINAL)
                        {
                            if (issuer === cn)
                            {
                                //self signed
                                message=localizer.getString('fs.settings.certificate.hostname_regen_cert_warn');
                            }
                            else
                            {
                                // ca signed
                              message=localizer.getString('fs.settings.certificate.hostname_regen_cert_warn_csr');
                            }
                         }
                         else
                         {
                           /*
                            * if hostname doesn't match the cn, display warning message appropriately
                            */
                             if (issuer === cn)
                             {
                                 //self signed
                               message=localizer.getString('fs.settings.certificate.hostname_cn_mistmatch');
                             }
                             else
                             {
                                 // ca signed
                               message=localizer.getString('fs.settings.certificate.hostname_cn_mistmatch_csr');
                             }
                         }
                        $(HOSTNAME_LABEL).text(message);
                    },
                
                    error: function onGetCertError(errorInfo) {
                      //show common warning
                        $(HOSTNAME_LABEL).text(localizer.getString('fs.settings.certificate.hostname_regen_cert_warn'));

                    }
                    
                });
                return true;
                        
            }, '');
            
            /**
             * Rule for IPV4 field
             */
            $.validator.addMethod("readCertIP", function(
                value, element, param) {
                // field is not required
                if (!value) {
                    return true;
                }
                if($(IPV4ADDRSELECT).val() == 'STATIC') 
                {
                    $(IPv4_1_LABEL).text(localizer.getString('fs.settings.certificate.ipaddress_regen_cert_warn'));
                }
                else
                {
                    $(IPv4_1_LABEL).text("");
                }
                
                return true;
                
            }, '');
            
            /**
             * @private Show or hide the DHCP warning based on whether DHCP is selected.
             * @param {Object} networkData The current network data.
             */
            function updateDHCPWarning(networkData) {

                if(presenter.dhcpIPv4Used(networkData)) {
                    $(DHCP_IPV4_WARNING).show();
                } else {
                    $(DHCP_IPV4_WARNING).hide();
                }

                if($(IPV6_SWITCH).is(':checked') === true) {
                    if(presenter.dhcpIPv6Used(networkData)) {
                        $(DHCP_IPV6_WARNING).show();
                    } else {
                        $(DHCP_IPV6_WARNING).hide();
                    }
                } else {
                    $(DHCP_IPV6_WARNING).hide();
                }
            }
            
            
            /**
             * @private Show or hide the Gateway warning based on whether updated network of appliance
             *  is different from previous one.
             * @param {Object} networkData The current network data.
             */
            function updateGatewayWarning(networkData){
                
                if(!presenter.dhcpIPv4Used(networkData)){
                    $(GATEWAY_IPV4_WARNING).show();
                } else {
                    $(GATEWAY_IPV4_WARNING).hide();
                }
            
                if($(IPV6_SWITCH).is(':checked') === true) {
                    if(!presenter.dhcpIPv6Used(networkData)) {
                        $(GATEWAY_IPV6_WARNING).show();
                    } else {
                        $(GATEWAY_IPV6_WARNING).hide();
                    }
                } else {
                    $(GATEWAY_IPV6_WARNING).hide();
                }
            }
            /**
             * @private Save IPv4 fields values when a user switches to DHCP .
             */
            function saveIPV4fields() {

                if(isTwoNode) {
                    $(NODE1_IPV4 + HIDDEN).val($(NODE1_IPV4).val());
                    $(NODE2_IPV4 + HIDDEN).val($(NODE2_IPV4).val());

                } else {
                    $(IPV4IPADDR + HIDDEN).val($(IPV4IPADDR).val());
                }

                $(IPV4MASK + HIDDEN).val($(IPV4MASK).val());
                $(IPV4GATEWAY + HIDDEN).val($(IPV4GATEWAY).val());
                $(DNS1 + HIDDEN).val($(DNS1).val());
                $(DNS2 + HIDDEN).val($(DNS2).val());
            }

            /**
             * @private Restore previously saved  IPv4 fields values when a user switches back
             * from DHCP to Manual .
             */
            function restoreIPV4fields() {
                
                if(isTwoNode) {
                    $(NODE1_IPV4).val($(NODE1_IPV4 + HIDDEN).val());
                    $(NODE2_IPV4).val($(NODE2_IPV4 + HIDDEN).val());

                } else {
                    $(IPV4IPADDR).val($(IPV4IPADDR + HIDDEN).val());
                }

                $(IPV4MASK).val($(IPV4MASK + HIDDEN).val());
                $(IPV4GATEWAY).val($(IPV4GATEWAY + HIDDEN).val());
                $(DNS1).val($(DNS1 + HIDDEN).val());
                $(DNS2).val($(DNS2 + HIDDEN).val());
            }

            /**
             * @private Save IPv6 fields values when a user switches to DHCP .
             */
            function saveIPV6fields() {

                if(isTwoNode) {
                    $(NODE1_IPV6 + HIDDEN).val($(NODE1_IPV6).val());
                    $(NODE2_IPV6 + HIDDEN).val($(NODE2_IPV6).val());

                } else {
                    $(IPV6IPADDR + HIDDEN).val($(IPV6IPADDR).val());
                }

                $(IPV6MASK + HIDDEN).val($(IPV6MASK).val());
                $(IPV6GATEWAY + HIDDEN).val($(IPV6GATEWAY).val());

            }

            /**
             * @private Restore previously saved IPv6 fields values when a user switches back
             * from DHCP to Manual .
             */
            function restoreIPV6fields() {

                if(isTwoNode) {
                    $(NODE1_IPV6).val($(NODE1_IPV6 + HIDDEN).val());
                    $(NODE2_IPV6).val($(NODE2_IPV6 + HIDDEN).val());

                } else {
                    $(IPV6IPADDR).val($(IPV6IPADDR + HIDDEN).val());
                }

                $(IPV6MASK).val($(IPV6MASK + HIDDEN).val());
                $(IPV6GATEWAY).val($(IPV6GATEWAY + HIDDEN).val());

            }

            /**
             * @private Revise the validation rules and enabled state of the IPv4 address fields.
             * @param {Object} networkData The current network data.
             */
            function updateIPv4Fields(networkData) {
                
                if(presenter.ipv4DataRequired(networkData)) {// static
                   
                    $(CLASS_IPV4_CLUSTER_ADDR_DHCP).hide();
                    $(CLASS_IPV4_DHCP_FIELDS).hide();
               
                    $(CLASS_IPV4_NON_DHCP_ERRORS).show();
                    $(IPV4MASK).rules(ADD, REQUIRED);
                    if(isTwoNode) {
                        $(IPV4FLOATADDR).rules(ADD, REQUIRED);
                        $(NODE1_IPV4).rules(ADD, REQUIRED);
                        $(NODE2_IPV4).rules(ADD, REQUIRED);
                    } else {
                        $(IPV4IPADDR).rules(ADD, REQUIRED);
                        $(IPV4IPADDR).rules(ADD, {
                          readCertIP : []
                        });
                        
                    }
                    $(IPV4FIELDS).removeAttr(DISABLED);

                } else {//DHCP
                    $(IPV4MASK).rules(REMOVE, REQUIRED);
                    $(IPV4FIELDS).attr(DISABLED, DISABLED);
                    // if we switched from manual to DHCP , blank out the fields
                    if (manualToDhcp) {
                      $(IPV4FIELDS).val('');
                    }
                    $(CLASS_IPV4_DHCP_FIELDS).show();
                    $(CLASS_IPV4_CLUSTER_ADDR_DHCP).show();
                    $(CLASS_IPV4_NON_DHCP_ERRORS).hide();
 
                    
                    if(isTwoNode) {// DHCP, two-node
                        $(IPV4IPADDR).rules(ADD, REQUIRED);
                        $(IPV4FLOATADDR).rules(ADD, REQUIRED);
                        $(IPV4IPADDR).removeAttr(DISABLED);
                        $(NODE1_IPV4).rules(REMOVE, REQUIRED);
                        $(NODE2_IPV4).rules(REMOVE, REQUIRED);
                        $(IPV4MASK).rules(REMOVE, REQUIRED);
                        $(CLASS_IPV4_DHCP_FIELDS).show();
                    } else {// DHCP, one-node
                        $(IPV4IPADDR).rules(REMOVE, REQUIRED);
                    }
                }
            }

            /**
             * @private Revise the validation rules, visibility, and enabled state of the IPv6 address fields.
             * @param {Object} networkData The current network data.
             */
            function updateIPv6Fields(networkData) {

                if($(IPV6_SWITCH).is(':checked') === false) {
                    //$(IPV6FIELDS).rules();
                    $(IPV6FIELDS).hide();
                    // keep the values if any
                    $(IPV6ADDRSELECT).parent().hide();

                    $(IPV6MASK).rules(REMOVE, REQUIRED);
                    $(IPV6IPADDR).rules(REMOVE, REQUIRED);
                    $(IPV6IPADDR).rules(REMOVE, 'ip-ipv6');
                    $(DHCP_IPV6_DISALLOWED).hide();
                    
                    return;
                }
                $(IPV6FIELDS).show();
                if (secondIPConfigured) {
                    $(DHCP_IPV6_DISALLOWED).show();
                }
                if(isTwoNode) {
                    $(ONE_NODE_LAYOUT).hide();
                    $(TWO_NODE_LAYOUT).show();
                } else {
                    $(TWO_NODE_LAYOUT).hide();
                    $(ONE_NODE_LAYOUT).show();
                }
                $(IPV6ADDRSELECT).parent().show();

                if(presenter.ipv6DataRequired(networkData)) {// static
                    $(CLASS_IPV6_DHCP_FIELDS).hide();
                    $(CLASS_IPV6_CLUSTER_ADDR_DHCP).hide();
                    $(CLASS_IPV6_NON_DHCP_ERRORS).show();
                    $(IPV6IPADDR).rules(ADD, REQUIRED);
                    $(IPV6MASK).rules(ADD, REQUIRED);
                    $(IPV6_NONDHCP_FIELDS).removeAttr(DISABLED);
                } else {
                    $(CLASS_IPV6_NON_DHCP_ERRORS).hide();
                    $(CLASS_IPV6_DHCP_FIELDS).show();
                    if(!firstTimeFlag) {
                        $(CLASS_IPV6_CLUSTER_ADDR_DHCP).show();
                    }
                    $(IPV6_NONDHCP_FIELDS).attr(DISABLED, DISABLED);

                    $(IPV6MASK).rules(REMOVE, REQUIRED);
                    $(IPV6FIELDS).val('');
                    if(isTwoNode) {// DHCP, two-node    
                        $(TWO_NODE_IPV6_LABEL).show();
                        $(NODE1_IPV6).rules(REMOVE, REQUIRED);    
                        $(NODE2_IPV6).rules(REMOVE, REQUIRED);  
                        $(IPV6MASK).rules(REMOVE, REQUIRED);  
                    } else {// DHCP, one-node
                        $(IPV6IPADDR).rules(REMOVE, REQUIRED);
                    }
                }
            }

            /**
             * @private Revise the validation rules and size of the DNS fields.
             * @param {Object} networkData The current network data.
             */
            function updateDNSFields(networkData) {
                var message;
                if(presenter.ipv6Used(networkData)) {
                    message = localizer.getString('fs.settings.network.validator.dns.ipv4_ipv6');
                    $(DNS1).rules(ADD, {
                        hostAddress : [IPV4, IPV6],
                        messages : {
                            hostAddress : message
                        }
                    });
                    $(DNS2).rules(ADD, {
                        hostAddress : [IPV4, IPV6],
                        messages : {
                            hostAddress : message
                        }
                    });
                } else {
                    message = localizer.getString('fs.settings.network.validator.dns.ipv4_only');
                    $(DNS1).rules(ADD, {
                        hostAddress : IPV4,
                        messages : {
                            hostAddress : message
                        }
                    });
                    $(DNS2).rules(ADD, {
                        hostAddress : IPV4,
                        messages : {
                            hostAddress : message
                        }
                    });
                }
                if(presenter.ipv6DNS(networkData)) {
                    $(DNSFIELDS).attr(SIZE, IPV6_SIZE);
                } else {
                    $(DNSFIELDS).attr(SIZE, IPV4_SIZE);
                }
   
                $(DNS_FROM_DHCP).toggle(Boolean(networkData.dnsFromDHCP));
            }

            /**
             * @private Re-validate the fields that are showing errors; leave the fields without errors alone (so that we don't
             * display errors in them prematurely).
             */
            function resetFailures() {
                $(HAS_ERROR).each(function() {
                    validator.element(this);
                });
            }
             /**
             * @public Reset the dynamic aspects of the form based on the current data in it.
             */
            function updateForm() {
                var networkData = marshalFormData(false);
                updateHostname(networkData);
                updateDHCPWarning(networkData);
                updateGatewayWarning(networkData);
                updateIPv4Fields(networkData);
                if(!presenter.iPv6Disabled()) {
                    updateIPv6Fields(networkData);
                }
                updateDNSFields(networkData);
                resetFailures();
            }
            
            function setInitialHostname (configuration) {
                
              var hostname = configuration.hostname;
              
               // check to see whether we have an intitial  non-FQDN hostname
              // and it is not autogenerated one, i.e. it does not start with "ci-"
              if (firstTimeFlag && (hostname.indexOf('.') == -1) && (hostname.indexOf(AUTOGENERATED_PREFIX) != 0) &&
                  (configuration.domainName || configuration.searchDomainName ))  {
                var suffix =  (configuration.domainName) ?  configuration.domainName : configuration.searchDomainName ;   
                hostname = hostname + '.' + suffix;      
              } 
                
             $(HOSTNAME).val(hostname);
             HOSTNAME_ORIGINAL = hostname;
             
            }

            /**
             * Displays IPv4 configuration settings
             * @param {object} configuration Configuration returned by first time setup
             */
            function setInitialIpv4Info(configuration) {
                
                manualToDhcp = false; // rest the flag on entering the page
                setInitialHostname(configuration);             
                
                if(firstTimeFlag ) {
                    if (!secondIPConfigured) {
                        $(IPV4ADDRSELECT).selectBox('value', presenter.STATIC);  
                    }                  
                    if(isTwoNode) {
                        $(IPV4FLOATADDR).val('');
                    } else {
                        $(IPV4IPADDR).val('');
                    }
                } else {
                     if (!secondIPConfigured) {
                        $(IPV4ADDRSELECT).selectBox('value', configuration.ipv4Type);
                    } 
                }
              
                if (!manualToDhcp) { // display DHCP values unless we are going from manual -> DHCP 
                    if(isTwoNode) {
                        if (firstTimeFlag &&(configuration.ipv4Type != presenter.STATIC))
                        {
                            $(IPV4FLOATADDR).val('');
                        } else {
                            $(IPV4FLOATADDR).val(configuration.addrs.cluster.ipv4);
                        }
                        $(NODE1_IPV4).val(configuration.addrs.node1.ipv4);
                        $(NODE2_IPV4).val(configuration.addrs.node2.ipv4);
                    } else {
                        if (firstTimeFlag && (configuration.ipv4Type != presenter.STATIC))
                        {
                            $(IPV4IPADDR).val('');
                        } else {
                            $(IPV4IPADDR).val(configuration.addrs.node1.ipv4);
                            $(IPV4_2_IPADDR).val(configuration.addrs.node1.ipv4_2);
                        }
                    }
                    $(IPV4MASK).val(configuration.ipv4Subnet);
                    $(IPV4GATEWAY).val(configuration.ipv4Gateway);
                    if (configuration.ipv4Type == presenter.DHCP) {
                       $(CLASS_IPV4_DHCP_FIELDS).show();  // the values are from DHCP
                    } else {
                       $(CLASS_IPV4_DHCP_FIELDS).hide();   
                       $(CLASS_IPV4_CLUSTER_ADDR_DHCP).hide();              
                    }
                } else {
                    $(CLASS_IPV4_DHCP_FIELDS).show();
                    $(CLASS_IPV4_CLUSTER_ADDR_DHCP).show();
                }

            }

            /**
             * Displays IPv6 configuration settings
             * @param {object} configuration Configuration returned by first time setup
             */
            function setInitialIpv6Info(configuration) {
                
                if (presenter.iPv6Disabled()) {
                    return;
                }
                
                if(configuration.ipv6Type == presenter.UNCONFIGURE) {
                    // clear the IPv6 fields in case we re-enter the page from previous cancellation                    
                    $(IPV6_SWITCH).attr('checked', false).trigger('change');
                    $(IPV6ADDRSELECT).selectBox('value', presenter.STATIC);
                    $(CLASS_IPV6_INPUT_FIELDS).val('');
                    return;
                }
                $(IPV6_SWITCH).attr('checked', true).trigger('change');
                if(firstTimeFlag) {
                    $(IPV6ADDRSELECT).selectBox('value', presenter.STATIC);
                    if(isTwoNode) {
                        $(IPV6FLOATADDR).val('');
                    } else {
                        $(IPV6IPADDR).val('');
                    }
                } else {
                    $(IPV6ADDRSELECT).selectBox('value', configuration.ipv6Type);
                }
                if(firstTimeFlag || (configuration.ipv6Type == presenter.STATIC)) {
                    if(isTwoNode) {
                        $(IPV6FLOATADDR).val(configuration.addrs.cluster.ipv6);
                        $(NODE1_IPV6).val(configuration.addrs.node1.ipv6);
                        $(NODE2_IPV6).val(configuration.addrs.node2.ipv6);
                    } else {
                        $(IPV6IPADDR).val(configuration.addrs.node1.ipv6);
                        if (secondIPConfigured) {
                           $(IPV6_2_IPADDR).val(configuration.addrs.node1.ipv6_2);
                        }
                    }
                    $(IPV6MASK).val(configuration.ipv6Subnet);
                    $(IPV6GATEWAY).val(configuration.ipv6Gateway);
                    if (configuration.ipv6Type == presenter.DHCP) {
                       $(CLASS_IPV6_DHCP_FIELDS).show();  // the values are from DHCP
                    }
                } else {
                    $(CLASS_IPV6_DHCP_FIELDS).show();
                }

            }

            /**
             * Displays name server configuration settings
             * @param {object} configuration Configuration returned by first time setup
             */
            function setInitialNameServerInfo(configuration) {
                $(DNS1).val(configuration.priDns);
                $(DNS2).val(configuration.altDns);
                if (originalConfig.dnsFromDHCP && !firstTimeFlag) {
                   $(DNS1).val('');
                   $(DNS2).val('');                    
                   $(DNS_FROM_DHCP).show();
                }
            }

            /**
             * Set the form for either single node or two node.
             *
             * @param {boolean} isTwoNode Flag whether the appliance is two-node capable.
             * @param {string} message (optional) Warning message why the appliance is not two-node capable.
             */
            function onShowTwoNode(isTwoNodeArg, message) {
                isTwoNode = isTwoNodeArg;
                if(message) {
                    $(NOTIFY_MSG, notifyElement).append(message);
                    notifyElement.addClass(NOTIFICATION_COLOR_PREFIX + 'warning');
                    notifyElement.slideDown('slow');
                }
                if(isTwoNode) {

                    $(ONE_NODE_LAYOUT).hide();
                    $(TWO_NODE_LAYOUT).show();
                } else {
                    $(FLOATING_IPTYPE_LABEL).text(localizer.getString('fs.settings.network.fields.iptype.one-node'));
                    $(TWO_NODE_LAYOUT).hide();
                    $(ONE_NODE_LAYOUT).show();

                    $(IPV4ADDRSELECT + ' [value="DHCP"]').show();
                    $(IPV6ADDRSELECT + ' [value="DHCP"]').show();
                    $(IPV4ADDRSELECT).selectBox('reset');
                    $(IPV6ADDRSELECT).selectBox('reset');
                }
                //              updateForm();
                $(SPINNER).hide();
                $(form).show();
            }

            function setIPV6Display() {
                if(presenter.iPv6Disabled()) {
                    $(CLASS_IPV6_DISABLE).remove();
                }
            }
            
            function setSecondIPDisplay(config) {
                secondIPConfigured = presenter.isSecondIPUsed();    // ipv4 IP will always be configured for second IP
                if (secondIPConfigured) {
                    // remove DHCP box selectors
                    $(CLASS_DHCP_SELECTOR).remove();
                    //only show the warning if the curent configruation is DHCP
                    if (config.ipv4Type != presenter.STATIC) {
                        $(DHCP_IPV4_DISALLOWED).show();
                     }
                } else {  // remove all the elements associated with the second IP
                    $(CLASS_SECOND_IP).remove();
                }
            }

            /**
             * Reset the errors and notifications
             */
            this.resetForm = function(form) {
                validator.resetForm();
                formStateView.reset();
            };

            this.displayParameterError = function() {
                formStateView.setMessage({
                    status : 'error',
                    summary : localizer.getString('fs.settings.network.notify.set.parameterError')
                });
            };

            /**
             * Apply the network configuration.  (Validate should be called first.)
             */
           function applyNetwork(handlers) {
                notifyResultFlag = true;
                formStateView.setMessage({
                    summary : localizer.getString('fs.settings.network.notify.set.verify')
                });
                // validate Network . On Success Apply the network 
                presenter.validateNetworkConfiguration(networkObject, {
                    success : function(data) {
                        onValidateConfigSuccess(data, handlers);
                    },
                    error : function(errorInfo) {
                      onSetConfigValidationError(errorInfo);
                        handlers.error(errorInfo);


                    }
                });
            }
            /**
             * Apply the network configuration.  (Validate should be called first. and then the backend validatiion will be checked 
             * after applying the network)
             */
            this.apply = function(handlers) {
              networkObject = marshalFormData(false);
              applyNetwork(handlers);
              fieldValueChangedFlag=false;
            };



            /**
             *
             *
             *
             */
            this.applyNetworkWithWarnings = function(handlers) {

                notifyResultFlag = true;
                formStateView.setMessage({
                    summary : localizer.getString('fs.settings.network.notify.set.verify')
                });
                networkObject = marshalFormData(true);
                presenter.setNetworkConfiguration(networkObject, {
                    running : onSetConfigRunning,
                    success : function(data) {
                        onSetConfigSuccess(data, handlers);
                    },
                    error : function(errorInfo) {

                        onSetConfigError(errorInfo);
                        handlers.error(errorInfo);
                    }
                });
            };



            /**
             * Add the necessary options to the form validator for our form fields.
             */
            this.addValidatorOptions = function(options) {
                $.extend(true, options, {
                    ignore : ":hidden",
                    rules : {
                        'ip-ipv4' : {
                            hostAddress : IPV4
                        },
                         'ip-ipv4-2' : {
                            hostAddress : IPV4
                        },
                        'ip-ipv6' : {
                            hostAddress : IPV6
                        },
                        'floating-ip-ipv4' : {
                            hostAddress : IPV4
                        },
                        'floating-ip-ipv6' : {
                            hostAddress : IPV6
                        },
                        'node1-ipv4' : {
                            hostAddress : IPV4
                        },
                        'node1-ipv6' : {
                            hostAddress : IPV6
                        },
                        'node2-ipv4' : {
                            hostAddress : IPV4
                        },
                        'node2-ipv6' : {
                            hostAddress : IPV6
                        },
                        'mask-ipv4' : {
                            hostAddress : MASKV4
                        },
                        'mask-ipv6' : {
                            hostAddress : MASKV6
                        },
                        'gateway-ipv4' : {
                            hostAddress : IPV4
                        },
                        'gateway-ipv6' : {
                            hostAddress : IPV6
                        }

                        // The other fields, and the required flag for the above
                        // fields, are handled in updateForm().
                    },
                    messages : {
                        'ip-ipv4' : localizer.getString('fs.settings.network.validator.ipv4'),
                        'ip-ipv4-2' : localizer.getString('fs.settings.network.validator.ipv4'),
                        'ip-ipv6' : localizer.getString('fs.settings.network.validator.ipv6'),
                        'node1-ipv4' : localizer.getString('fs.settings.network.validator.ipv4'),
                        'node1-ipv6' : localizer.getString('fs.settings.network.validator.ipv6'),
                        'node2-ipv4' : localizer.getString('fs.settings.network.validator.ipv4'),
                        'node2-ipv6' : localizer.getString('fs.settings.network.validator.ipv6'),
                        'mask-ipv4' : localizer.getString('fs.settings.network.validator.mask-ipv4'),
                        'mask-ipv6' : localizer.getString('fs.settings.network.validator.mask-ipv6'),
                        'gateway-ipv4' : localizer.getString('fs.settings.network.validator.gateway-ipv4'),
                        'gateway-ipv6' : localizer.getString('fs.settings.network.validator.gateway-ipv6')
                        // The messages for the other validators are set in
                        // updateForm() since they vary.
                    },
                    errorClass : 'hp-error',
                    errorPlacement : errorPlacementMethod
                });
                return options;
            };
            /**
             * Set the form layout based on the network configuration.
             */
            this.setFormLayout = function(config) {
                localNodeID = config.localNodeID;
                presenter.showTwoNode(onShowTwoNode);
                setSecondIPDisplay(config);
            };
            /*
             * Indicates we are on the initial network set-up page
             */
            this.setFirstTime = function(firstTime) {
                firstTimeFlag = firstTime;
                var suffix;
                if (firstTime) {
                   suffix='-init';
                 } else {
                   suffix='-edit'; 
                 }                    
                 SPLASH_DIALOG = SPLASH_DIALOG_BASE + suffix;
                 SPLASH_PROGRESS = SPLASH_PROGRESS_BASE + suffix;
                 SPLASH_ESTIMATE = SPLASH_ESTIMATE_BASE + suffix;
  
            };

            this.fillFields = function(config) {
                originalConfig = config;
                setInitialIpv4Info(config);
                setInitialIpv6Info(config);
                setInitialNameServerInfo(config);
                updateForm();
                formStateView.reset();
                     
            };
            
            this.dismissDialog = function() {
                dismissDialogWindow();
            };
      
            /**
             * Initialize the view.
             */
            this.init = function(route_prefix, edit_form) {

                form = edit_form;
                routePrefix = route_prefix;
                setIPV6Display();
 
                
                  // some DHCP prep
               $(IPV4ADDRSELECT).change(function() {
                  if($(IPV4ADDRSELECT).val() == 'DHCP') {
                        saveIPV4fields();
                        $(DNS1).val('');
                        $(DNS2).val('');
                        manualToDhcp = true;
                        $(IPv4_1_LABEL).text("");
                  } else {
                         restoreIPV4fields();
                         manualToDhcp = false;
                         $(IPv4_1_LABEL).text(localizer.getString('fs.settings.certificate.ipaddress_regen_cert_warn'));
                  }
               });

               $(IPV6ADDRSELECT).change(function() {
                   if($(IPV6ADDRSELECT).val() == 'DHCP') {
                       saveIPV6fields();
                   } else {
                      restoreIPV6fields();
                   }
               });
                  
               $(IPV4ADDRSELECT).selectBox({
                         autoWidth : false
                    });
                    $(IPV6ADDRSELECT).selectBox({
                        autoWidth : false
               });


                $(AFFECTS_LAYOUT).change(updateForm);
                $(SPLASH_PROGRESS).hpProgressBar();
                $(SPLASH_PROGRESS).hpProgressBar(0);

                $(IPV6_SWITCH).hpToggle({
                    checked : localizer.getString('fs.settings.network.fields.ipv6state.on'),
                    unchecked : localizer.getString('fs.settings.network.fields.ipv6state.off')
                });

                $(IPV6_SWITCH).change(function() {
                    var networkData = marshalFormData(false);
                    updateIPv6Fields(networkData);
                    updateDHCPWarning(networkData);
                    updateGatewayWarning(networkData);
                });
                
                formStateView.init({
                    form : form,
                    routePattern : routePrefix + '.*',
                    autoTrack : true
                });  
        
            };
            formStateView.on('change', function (idElem,labelElem,valueElem) {
                fieldValueChangedFlag=true;
              });
           /*
            * Set the notification div.
            */
           this.setNotifyElement = function(elm) {
               notifyElement = elm;
           };
           /**
            * Set the validator for the view.
            */
           this.setValidator = function(v) {
               validator = v;
           };
           
           
           this.onError = function() {
               $(SPINNER).hide();
               notifyResultFlag = true;            
               displayNotifications(localizer.getString('fs.settings.network.error.get.msg'),
                                    localizer.getString('fs.settings.network.error.get.res'));
           };
           /**
            * get the  instance of formstate view initialised here.
            */
           this.getFormStateViewInstance = function() {
               return formStateView;
           };
           /**
            * 
            * Flag to check if any field value has changed. Used with formstateview change event
            */
           this.isFieldValueChanged = function(){
             return fieldValueChangedFlag;
             };
        }
        


        return NetworkEditViewBase;
    }());
});
