// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(
        [],
        function() {
            "use strict";

            var AuthNProviders = (function() {

                function sortByName(a,b){
                    return (a.name.toUpperCase() > b.name.toUpperCase()) ? 1 : ((b.name.toUpperCase() > a.name.toUpperCase()) ? -1 : 0);
                }

                function AuthNProviders() {
                    var providerConfigs = [];
                    var deletedProviderConfigs = [];

                    this.addProviderConfig = function(config) {
                        if (config) {
                            if (config.loginDomain === "") {
                                // newly created provider
                                providerConfigs.push(config);
                                return true;
                            } else {
                                if (this.getIndexByConfigId(config.loginDomain) === null) {
                                    providerConfigs.push(config);
                                    return true;
                                }
                            }
                            return false;
                        }
                    };

                    this.deleteProviderConfig = function (config, index) {
                        //only set a provider to delete if it had been created already
                        if(config.loginDomain !== ""){
                            deletedProviderConfigs.push(config);
                        }
                        providerConfigs[index] = null;
                    };

                    this.undoDeleteProviderConfig = function(config, delIndex,addAtIndex){
                        //remove from the deletedProviderConfig List
                        deletedProviderConfigs.splice(delIndex, 1);
                        //add back to the providerConfigs List
                        providerConfigs[addAtIndex] = config;
                    };

                    this.deleteServerFromProvider = function(config, serverToRemove) {
                        var servers = this.getProviderConfigById(config.loginDomain).servers;
                        var serverIndex = $.inArray(serverToRemove, servers);
                        if (serverIndex > -1) {
                            servers.splice(serverIndex, 1);
                        }
                    };

                    this.setProviderConfigs = function(value) {
                        providerConfigs = value;
                    };

                    this.getProviderConfigs = function(value) {
                        return providerConfigs;
                    };

                    this.sortProviderConfigsByName = function(){
                        providerConfigs.sort(sortByName);
                        return providerConfigs;
                    };

                    this.getDeletedProviderConfigs = function(value) {
                        return deletedProviderConfigs;
                    };

                    this.getProviderConfigById = function(loginDomain) {
                        if (providerConfigs !== null) {
                            for ( var i = 0; i < providerConfigs.length; i++) {
                                if (providerConfigs[i] !== null &&
                                    providerConfigs[i].loginDomain === loginDomain) {
                                    return providerConfigs[i];
                                }
                            }
                        }
                        return null;
                    };

                    this.getProviderConfigByIndex = function(index) {
                        if (providerConfigs !== null) {
                            return providerConfigs[index];
                        }
                        return null;
                    };

                    this.getIndexByConfigId = function(loginDomain) {
                        if (providerConfigs !== null) {
                            for ( var i = 0; i < providerConfigs.length; i++) {
                                if (providerConfigs[i].loginDomain === loginDomain) {
                                    return i;
                                }
                            }
                        }
                        return null;
                    };

                    this.getIndexByName = function(name) {
                        if (providerConfigs !== null) {
                            for ( var i = 0; i < providerConfigs.length; i++) {
                                if (providerConfigs[i].name === name) {
                                    return i;
                                }
                            }
                        }
                        return null;
                    };

                    this.clearDeletedProviderConfigs = function() {
                        deletedProviderConfigs = [];
                    };

                    this.clear = function() {

                        providerConfigs = [];
                        deletedProviderConfigs = [];
                    };



                }

                return new AuthNProviders();

            }());

            return AuthNProviders;

        });
