//(C) Copyright 2010-2013 Hewlett-Packard Development Company, L.P.
/**
 * This entire file deals with timeDto. The timeDto format is
 timeDto = {
     dateTime : null,
     timezone : null,
     ntpServers : null,
     pollingInterval : null
 };
 */
define(['fs/services/settings/DateTimeSetupService',
        'hp/core/EventDispatcher',
        'hp/model/Resource'],
function (dateTimeSetupService, EventDispatcher, Resource) { "use strict";
    var DateTimeSetupPresenter = (function () {
        /**
         * @constructor Presentation logic for the Appliance panel on the Settings Overview page.
         */
        function DateTimeSetupPresenter() {

            var dispatcher = new EventDispatcher();

            /**
             * Retrieve the version information for the appliance.
             *
             * @param {Object} handlers The success and error handler methods.
             */
            this.on = function (eventName, callback){
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };
            /**
             * This function updates the timezone field
             * timezoneData contains timezone which is retrieved from the appliance.
             * @param timezoneData
             */
            function updateTimezone(timezoneData){
                dispatcher.fire("timezoneChange",timezoneData);
            }
            /**
             * This function updates the ntp servers field
             * ntpData contains ntp servers list which is retrieved from the appliance.
             * @param ntpData
             */
            function updateNTPservers(ntpData){
                dispatcher.fire("ntpServersChange",ntpData);
            }
            /**
             * This function updates the locale field
             * localeData contains locale info which is retrieved from the appliance.
             * @param localeData
             */
            function updateLocale(localeData){
                dispatcher.fire("localeChange",localeData);
            }
            /**
             * This function get the date and time info from the service layer and updates the dateTime field.
             * @param data
             */
            this.getDateTime = function (handlers) {
                dateTimeSetupService.getDateTime({
                    success : function (data) {
                        dispatcher.fire("dateAndTimeChange",data.dateTime);
                    },
                    error: function(error) {}
                });
            };
            /**
             * This function get the timezone info from the service layer and update the timezone field.
             */
            this.getTimezone = function () {
                dateTimeSetupService.getTimezone({
                    success: updateTimezone,
                    error: function(error) {}
                });
            };
            /**
             * This function gets the ntp servers list from the service layer and updates the ntp servers field.
             */
            this.getNTPservers = function () {
                dateTimeSetupService.getNTPservers({
                    success: updateNTPservers,
                    error: function(error) {}
                });
            };
            /**
             * This function gets the locale info from the service layer and updates the locale field.
             */
            this.getLocale = function () {
                dateTimeSetupService.getLocale({
                    success: updateLocale,
                    error: function(error) {}
                });
            };
            /**
             * This function set the user selected date and time on the appliance through service layer.
             * data contains the date and time
             * @param data
             */
            this.setDateTime = function(data,handlers){
                dateTimeSetupService.setDateTime(data, {
                    success: function() {
                      handlers.success.call(this,data);
                    },
                    error: function(errorInfo) {
                      handlers.error(errorInfo);
                    }
                });
            };
            /**
             * This function sets the user entered ntp server on the appliance through service layer.
             * data contains the ntp server details.
             * @param data
             * 
             */
           this.setNTPservers = function(data,handlers){
                dateTimeSetupService.setNTPservers(data, {
                    success: function() {
                      handlers.success.call(this,data);
                    },
                    error: function(errorInfo) {
                       handlers.error(errorInfo);
                    }
                });
            };
            /**
             * This function sets the user selected timezone through service layer.
             * data contains the timezone info.
             * @param data
             */
            this.setTimezone = function (data,handlers){
                dateTimeSetupService.setTimezone(data, {
                    success: function() {
                      handlers.success.call(this,data);
                    },
                    error: function(errorInfo) {
                      handlers.error(errorInfo);
                    }
                });
            };
            /**
             * This function sets the user selected locale through service layer.
             * data contains the locale info.
             * @param data
             */
            this.setLocale = function (data,handlers){
                dateTimeSetupService.setLocale(data, {
                    success: function() {
                      handlers.success.call(this,data);
                    },
                    error: function(errorInfo) {
                      handlers.error(errorInfo);
                    }
                });
            };
            /**
             * This function retrieves all the available list of timezone's from the appliance.
             * @param handlers
             */
            this.getTimeZones = function(handlers)
            {
                dateTimeSetupService.getTimeZones({
                    success: function(timezones) {
                        handlers.success(timezones);
                    },
                    error: handlers.error
                });
            };
            /**
             * This function retrieves all the available list of locale's from the appliance.
             * @param handlers
             */
            this.getLocales = function(handlers)
            {
                dateTimeSetupService.getLocales({
                    success: function(locales) {
                        handlers.success(locales);
                    },
                    error: handlers.error
                });
            };
            /**
             *
             * This function parses the date and time in Non UTC format .
             * @param data
             */
            this.parseDateTime = function(data)
            {
                /*
                * Currently date.js supports only UTC format and need is to display the
                * appliance date time in the same format it was saved .As date.js cannot
                * be used we borrowed the same logic from parseISOString .Here we parse
                * the incoming date format (yyy-MM-dd:HH:mm:ss.sss) and convert it to
                * required display format for date time.
                * Going forward it can be reconsidered putting this in date.js script
                */
                var ms = (data.length > 20) ? parseFloat(data.slice(19,23)) * 1000 : 0;
                var dateVal = new Date(parseInt(data.slice(0,4), 10),
                   parseInt(data.slice(5,7), 10) - 1,
                   parseInt(data.slice(8,10), 10),
                   parseInt(data.slice(11,13), 10),
                   parseInt(data.slice(14,16), 10),
                   parseInt(data.slice(17,19), 10),
                   ms);
                   return dateVal;
            };
        }

        return new DateTimeSetupPresenter();

    }());

    return DateTimeSetupPresenter;

});