// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {HelpMenu}
 */
define(['hp/model/Session',
    'hp/core/UrlFragment',
    'hp/core/Sidebar',
    'hp/services/Log',
    'hp/core/Localizer',
    'text!hpPages/core/help_menu.html',
    'jquery',
    'hp/lib/jquery.hpTooltip'],
function (session, urlFragment, sidebar, Log, localizer, helpMenuHtml) { "use strict";

    var CONTROL = '#hp-help-control';
    var FLYOUT = '#hp-help-flyout';
    var CURRENT_ANCHOR = '.hp-help-current';
    var INDEX_ANCHOR = '.hp-help-index';
    var ACTIONS = '#hp-help-actions';
    var ACTION = ACTIONS + ' a';
    var SCREENCASTS = '#hp-help-screencasts';
    var ACTIVE = 'hp-active';
    var SELECTED = 'hp-selected';

    var HelpMenu = (function () {

        var initialized = false;
        var banner = null;
        var contents = null;
        var productBook = null;
        
        function HelpMenu() {
          
            /**
             * Completely hide flyout.
             */
            function hideSidebar(remove) {
                if ($(FLYOUT).hasClass(ACTIVE)) {
                    $(FLYOUT).removeClass(ACTIVE);
                    $(CONTROL).removeClass(SELECTED);
                    if (remove) {
                        sidebar.remove($(FLYOUT));
                    }
                }
            }
            
            /**
             * Put the flyout into the sidebar.
             */
            function showSidebar() {
                if (! $(FLYOUT).hasClass(ACTIVE)) {
                    $(FLYOUT).addClass(ACTIVE);
                    $(CONTROL).addClass(SELECTED);
                    sidebar.add($(FLYOUT));
                }
            }
            
            function onSidebarRemove(element) {
                if (element.attr('id') === $(FLYOUT).attr('id')) {
                    hideSidebar();
                }
            }
            
            function onSidebarAdd(element) {
                if (element.attr('id') === $(FLYOUT).attr('id')) {
                    showSidebar();
                }
            }

            this.init = function (bannerArg) {

                if (! initialized) {
                    banner = bannerArg;
                    initialized = true;
                    contents = $(helpMenuHtml);
                    localizer.localizeDom(contents);
                    $(ACTIONS, contents).hide();
                    $(SCREENCASTS, contents).hide();

                    // Make help anchors target the help window
                    // NOTE: keep aligned with LinkTargetBuilder.makeLink()
                    $(CURRENT_ANCHOR, contents).attr('target', 'hphelp');
                    $(INDEX_ANCHOR, contents).attr('target', 'hphelp')
                        .attr('href', '/doc#/' + (productBook ? productBook : ''));
                    
                    $(FLYOUT, banner).append(contents);
                    $(CONTROL, banner).attr('tooltip',
                        localizer.getString('core.help.control.tooltip')).
                        hpTooltip();

                    $(CONTROL, banner).click(function (ev) {
                        if (!$(CONTROL).hasClass(SELECTED)) {
                            showSidebar();
                        } else {
                            hideSidebar(true);
                        }
                    });
                    
                    sidebar.on('sidebarAdd', onSidebarAdd);
                    sidebar.on('sidebarRemove', onSidebarRemove);
                }
            };
            
            this.pin = function () {
                showSidebar();
            };
            
            this.unpin = function () {
                hideSidebar(true);
            };

            this.addAction = function (label, location) {
                this.init();
                if (location.substring(0,4) === 'doc#') {
                    $(ACTIONS + ' > ol', contents).
                        append('<li><a href="' + location + '" target="hphelp">' +
                            label + '</a></li>');
                }
                else {
                    $(ACTIONS + ' > ol', contents).
                        append('<li><a href="#' + location + '">' + label + '</a></li>');
                }
                $(ACTIONS, contents).show();
            };
            
            this.removeAction = function (location) {
                $(ACTION + '[href$="' + location + '"]', contents).
                    parent().remove();
                if ($('.hp-done', contents).length === 0) {
                    $(ACTIONS).removeClass('hp-has-indicators');
                }
                if ($(ACTION, contents).length === 0) {
                    $(ACTIONS, contents).hide();
                }
            };
            
            this.updateActionLabel = function (label, location) {
                $(ACTION + '[href$="' + location + '"]', contents).
                    html(label);
            };

            this.markActionDone = function (location) {
                $(ACTIONS, contents).addClass('hp-has-indicators');
                $(ACTION + '[href$="' + location + '"]', contents).
                    parent().addClass('hp-done');
            };
            
            this.markActionNotDone = function (location) {
                $(ACTION + '[href$="' + location + '"]', contents).
                    parent().removeClass('hp-done');
                if ($('.hp-done', contents).length === 0) {
                    $(ACTIONS).removeClass('hp-has-indicators');
                }
            };

            this.addScreencast = function (label, location) {
                this.init();
                $(SCREENCASTS + ' > ol', contents).
                    append('<li><a href="#' + location + '">' + label + '</a></li>');
                $(SCREENCASTS, contents).show();
            };

            this.setLocation = function (location) {
                var helpUrl;
                // update help link
                helpUrl = '/doc#/' + (productBook ? productBook + '/' : '') +
                    urlFragment.getPage(location) +
                    '/' + urlFragment.getView(location);
                $(CURRENT_ANCHOR, contents).attr('href', helpUrl);
                // handle add/edit forms
                $(CURRENT_ANCHOR).attr('href', helpUrl).
                    attr('target', 'hphelp');
            };
            
            this.setProductBook = function(book) {
                productBook = book;
            };
        }

        return new HelpMenu();
    }());

    return HelpMenu;
});
