// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(['hp/services/REST', 'hp/services/Log', 'jquery'],
function(REST, log) { "use strict";

    var ResourceService = (function() {

        function ResourceService() {

            var defaultParameterMap = {
                    'properties' : function(name, value, params) {
                        $.each(value, function (property, propertyValue) {
                            if ('array' === $.type(propertyValue)) {
                                $.each(propertyValue, function (index, val) {
                                    params.push('filter="' + property + '=\'' + val + '\'"');
                                });
                            } else {
                                params.push('filter="' + property + '=\'' + propertyValue + '\'"');
                            }
                        });
                    },
                    'terms' : function(name, value, params) {
                        if (value.length > 0) {
                            params.push('query=' + value.join(' AND '));
                        }
                    },
                    'userQuery' : function(name, value, params) {
                        // ignore userQuery
                    },
                    'category' : function(name, value, params) {
                        // ignore category
                    }
                };
            
            function getFilteredUri(uri, filter, parameterMap) {
                var paramMap = parameterMap ? parameterMap : defaultParameterMap,
                    params = [],
                    filteredUri = uri;
                
                if (filter && filter.data) {
                    $.each(filter.data, function (name, value) {
                        if (paramMap.hasOwnProperty(name)) {
                            paramMap[name](name, value, params);
                        }
                        else if ('array' === $.type(value)) {
                            $.each(value, function (index, val) {
                                params.push(name + '=' + val);
                            });
                        } else {
                            params.push(name + '=' + value);
                        }
                    });
                    
                    if (params.length > 0) {
                        filteredUri = uri + ((uri.indexOf('?') === -1) ? '?' : '&') + params.join('&');
                    }
                }
                return filteredUri;
            }
            
            this.getFilteredUri = getFilteredUri;
            
            this.defaultParameterMap = defaultParameterMap;
            
            this.getFilteredResources = function (uri, filter, handlers) {
                var filteredUri = getFilteredUri(uri, filter);

                REST.getURI(filteredUri, handlers);
            };
        }
        return new ResourceService();
    }());
    
    return ResourceService;
});

