// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['hp/core/EventDispatcher',
        'fs/services/alerts/AlertsService'],
function(EventDispatcher, alertsService) { "use strict";
    var AlertPanelResource = (function() {
        var NUM_ALERTS_SHOWN = 5;

        function AlertPanelResource() {
            // Derive from EventDispatcher
            EventDispatcher.call(this);

            var self = this,
                alerts = null,
                alertCount = null,
                sort = ["severity:descending", "created:descending"],
                uri = null;

            function setAlerts(newAlerts){
                alerts = newAlerts;
                self.fire("alertChange", newAlerts);
            }

            function setAlertCount(count){
               alertCount = count;
            }

            function setUri(newUri) {
                    uri = newUri;

                    if (uri){
                        // Get associated alert data
                        alertsService.getAlertsByFilter(["resourceUri='" + newUri + "'",
                          "alertState!='Cleared'","lifeCycle='false'"], true, NUM_ALERTS_SHOWN, sort, {
                            success: function(alerts){
                                if (alerts === null){ // There are no alerts
                                    alerts={"members":[],"alertSeverityCounts":{"criticalCount":0,
                                      "warningCount":0,"okCount":0,"unknownCount":0,"disabledCount":0}};
                                }
                                setAlertCount(alerts.alertSeverityCounts);
                                setAlerts(alerts.members);
                            },
                            error : function (errorInfo) {
                                self.fire("itemError", errorInfo.errorMessage);
                            }
                        });
                    }
            }

            this.getAlerts = function () {
                return alerts;
            };

            this.getAlertCount = function () {
                return alertCount;
            };

            this.setUri = setUri;

        }

        return AlertPanelResource;
    }());
    return AlertPanelResource;
});
