// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

if (!hp) {
    var hp = {};
}
//function from jquery.localize
hp.normaliseLang = function(lang) {
    lang = lang.replace(/_/, '-').toLowerCase();
    if(lang.length > 3) {
        lang = lang.substring(0, 3) + lang.substring(3).toUpperCase();
    }
    return lang;
};
//var normally $.defaultLanguage from jquery.localize
if (!hp.defaultLanguage) {
    hp.defaultLanguage = hp.normaliseLang(navigator.language || navigator.userLanguage);
}

// hp.getLang can be overridden by the application's shell-require.js to choose the current locale.
// For example, put something like this at the very top of shell-require.js, before the require() call:
// if (!hp) {
//     var hp = {};
// }
// hp.getLang = function() {
//    // choose the language here and return it
// }

if (!hp.getLang) {
    hp.getLang = function() {
        //TODO use session for this at some point?
        switch(hp.defaultLanguage.toLowerCase()) {
        case 'es':
        case 'es-es':
            //spanish
            return 'es';
        case 'en':
        case 'en-us':
        case 'en_us':
            //english
            return 'en';
        case 'ja_jp':
        case 'ja-jp':
        case 'ja':
              return 'ja';
        case 'zh_cn':
        case 'zh-cn':
        case 'zh':
        case 'cn':
              return 'cn';
        default:
            //english
            return 'en';
        }
    };
}
//problem, the above defines a global hp with getLang, defaultLanguage, and normalizseLang functions

define(['lang/' + hp.getLang()], function(bundle) {"use strict";
    var Language = ( function() {

        /**
         * @type {AvailableLanguages}
         * @constructor
         */
        function Language() {

            this.getBundle = function(lang) {
                /*
                 * TODO can/should I add logic here to see if lang != getLang above?
                 * And then throw an exception? catch it in Localizer and d
                 */
                return bundle;
            };
        }

        return new Language();
    }());
    return Language;
});
