// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type {SessionRoutes}
 */
define(['hp/core/Router'],
function (router) { "use strict";

    var SessionRoutes = ( function() {

        var CONTAINER = '#hp-page-container',
        CHANGE_CONTAINER = '#hp-change-page-container';

        function SessionRoutes() {

            var registered = false;
            var loginLocationContext = '/';
            var isEulaNeeded = true;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                // Check any attempts to go to /login to see if EULA needs to be done first.
                /*router.filter('eula filter', '^/login(/.*|$)', {
                    check: function (location, result) {
                        if (isEulaNeeded)
                        {
                            require(['hp/services/EulaService'],
                            function (eulaService) {
                                eulaService.isEulaRequired({
                                    success: function(data) {
                                        if (true == data) {
                                            result.redirectTo('/eula');
                                        }
                                        else
                                        {
                                            isEulaNeeded = false;
                                            result.proceed();
                                        }
                                    },
                                    error: function (errorInfo){
                                        result.proceed();
                                    }
                                });
                            });
                        }
                        else
                        {
                            result.proceed();
                        }
                    }
                });

                router.map('eula', '^/eula(/.*|$)', {
                    menu: {
                        noBanner: true
                    },
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/login/eula.html',
                            'hp/view/login/EulaView',
                            'hp/services/EulaService'],
                        function (page, view, eulaService) {
                            eulaService.isEulaRequired({
                                success: function(data) {
                                    if (true == data) {
                                        result.load(page, view);
                                    }
                                    else
                                    {
                                        result.redirectTo('/settings/show/license/eulapage');
                                    }
                                },
                                error: function (errorInfo){
                                    result.load(page, view);
                                }
                            });
                        });
                    }
                });*/

                router.map('login', '^/login(/.*|$)', {
                    menu: {
                        noBanner: true
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['hp/model/Session',
                            'text!hpPages/login/index.html',
                            'hp/view/login/LoginView'],
                        function (session, page, view) {
                            if (session.getToken()) {
                                result.redirectTo('/');
                            }
                            else
                            {
                                result.load(page, view);
                                view.setLocationContext(loginLocationContext);
                            }
                        });
                    }
                });

                router.map('initial password', '^/initialPassword(/.*|$)', {
                    menu: {
                        noBanner: true
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/login/initial-password.html',
                            'hp/view/login/InitialPasswordView'],
                        function (page, view) {
                            result.load(page, view);
                            view.setLocationContext(loginLocationContext);
                        });
                    }
                });

                router.filter('session filter', '^.*', {
                    check: function (location, result) {
                        require(['hp/model/Session', 'hp/services/authz', 'hp/core/UrlFragment'],
                        function (session, authz, urlFragment) {
                            if (! session.getToken()) {
                                loginLocationContext = location;
                                result.redirectTo('/login');
                            } else {
                                $('#hp-body-div').addClass('hp-sessioned');
                                loginLocationContext = '/';
                                if (session.getAuthorizations().length > 0) {
                                    result.proceed();
                                } else {
                                    // load authorizations
                                    authz.getAll({
                                        success: function(authorizations) {
                                            session.saveAuthorizations(authorizations.members);
                                            result.proceed();
                                        },
                                        error: function(errorInfo) {
                                            session.eraseAll();
                                            result.redirectTo('/login');
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            };
        }

        return new SessionRoutes();
    }());

    return SessionRoutes;
});
