// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['hp/core/EventDispatcher',
    'hp/services/IndexService',
    'hp/model/map/Map',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/services/Log'], 
function(EventDispatcher, indexService, Map, router, urlFragment, log) {"use strict";

    var MapPresenter = ( function() {

        /**
         * @constructor
         * @type {MapPresenter}
         */
        function MapPresenter() {

            var dispatcher = new EventDispatcher();
            var history = []; // {name: name, uri: uri}
            
            function onTreeResult(data) {
                var map = new Map();
                map.init(data);
                //history.push({uri: data.rootResource.uri,
                //    name: data.rootResource.name});
                history.push({uri: data.resource.uri,
                    name: data.resource.name});
                dispatcher.fire("mapChange", map);
            }
            
            function onTreeError(error) {
                log.log(error);
            }
            
            function routeChange(locationArg) {
                var uris = urlFragment.getUris(locationArg);
                if (uris && uris.length > 0) {
                    dispatcher.fire("mapChanging");
                    indexService.getParentAndChildrenAssociations({
                        uri: uris,
                        handlers: {
                            success: onTreeResult,
                            error: onTreeError
                        }
                    });
                }
            }
            
            this.getHistory = function () {
                return history.slice(0, -1); // don't include current
            };

            /**
             * @public
             */
            this.init = function (route) {
                router.watch('map presenter', route + '($|/.*)',
                    {change: routeChange});
            };
            
            /**
             * @public
             * Add a listener for a specified event.
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function (eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function (eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new MapPresenter();
    }());

    return MapPresenter;
});
