// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define([ 'hp/core/EventDispatcher', 'hp/core/Localizer',
        'hp/services/settings/FactoryResetService'],        
function(EventDispatcher, localizer, service) {
    "use strict";

    var FactoryResetPresenter = (function() {
        
        function FactoryResetPresenter() {
            
            var dispatcher = new EventDispatcher();
  
            this.startFactoryReset = function(option, handlers) {
  
                // Start the actual configuration change.
                service.startFactoryReset(option, handlers);
            };

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
             };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };

            /**
             * Returns current state of Factory Reset Action Availability
             */
            this.factoryResetDisabled = function() {
                return service.getFactoryResetDisabled();
            };

            this.init = function() {

            };
        }

        return new FactoryResetPresenter();

    }());

    return FactoryResetPresenter;
});
