// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/enclosure/EnclosurePresenter',
    'hp/core/UrlFragment',
    'jquery'],
function(presenter, urlFragment) { "use strict";

    var EnclosureShowOverviewMultiView = (function() {
      
        var ROOT = '#tour-enclosure-show-overview-multi';
      
        /**
         * Constructor
         */
        function EnclosureShowOverviewMultiView() {
          
            function onAggregateChange(aggregate) {
                $.each(['error', 'warning', 'ok', 'unknown', 'disabled'], function (index, status) {
                    var context = $(ROOT + ' .hp-status-count-' + status);
                    $('.hp-status-count', context).html(aggregate.status[status]);
                    if (aggregate.status[status]) {
                        $('.hp-status', context).removeClass('hp-unset');
                    } else {
                        $('.hp-status', context).addClass('hp-unset');
                    }
                });
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
            }
          
            /**
             * @public
             */
            this.resume = function() {
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("aggregateChange", onAggregateChange);
            };
            
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("aggregateChange", onAggregateChange);
            };
             
            this.init = function() {
                $(ROOT + ' .hp-status').hpStatus();
                this.resume();
            };
        }

        return new EnclosureShowOverviewMultiView();
    }());
    
    return EnclosureShowOverviewMultiView;
});
