#!/bin/sh
#set -x

datetime=`date +"%m-%d-%Y_%H-%M-%S"`
tarName="HPSUM_Logs_${datetime}.tar"
tmpFile=".directory_listing.txt"

#determine which zip program to use, or none
gzip=`which gzip`
compress=`which compress`

if [ "x$gzip" != "x" ]; then
	zipper=$gzip
else
	if [ "x$compress" != "x" ]; then
		zipper=$compress
	else
		#no zip
		zipper="touch"
	fi
fi

echo "Gathering HPSUM logs..."
found=0

#listing of current dir and sub dir, usually dir running HPSUM, to capture files, dates/times
ls -l * > $tmpFile
tar -cf $tarName $tmpFile
rm $tmpFile

#HPSUM directory listing 
ls -Rl /tmp/HPSUM > "hpsum_directory_listing.txt"
tar -rf $tarName "hpsum_directory_listing.txt"
rm "hpsum_directory_listing.txt"

#debug logs
if [ -d /tmp/HPSUM ]; then
  find /tmp/HPSUM -name "*.txt" -o -name "*.log" -o -name "*.xml" -o -name "*.trace" -o -name "*.pdb*" -o -name "*.ini" |
  while read file; do
    tar -rf $tarName $file
  done
  found=1
fi

#user logs
if [ -d /var/hp/log ]; then
  tar -rf $tarName /var/hp/log/*
  found=1
fi

#system logs
tail -10000 /var/adm/syslog/syslog.log > syslog.log 2>/dev/null
if [ -f syslog.log ]; then
	tar -rf $tarName syslog.log
	rm syslog.log
fi

tail -10000 /var/adm/syslog/OLDsyslog.log > OLDsyslog.log 2>/dev/null
if [ -f OLDsyslog.log ]; then
	tar -rf $tarName OLDsyslog.log
	rm OLDsyslog.log
fi

#zip if possible
if [ $found -eq 1 ]; then
  $zipper $tarName
  newName=`ls -1 $tarName*`
  echo "HPSUM logs are in $newName"
  exit 0
fi

rm $tarName
echo "No HPSUM logs found"
exit -1
