// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['hp/services/Log', 
    'hp/model/Session', 
    'hp/core/Localizer', 
    'jquery'], 
function(Log, session, Localizer) {"use strict";
    var NotAuthorizedView = ( function() {

        var DESCRIPTION = '#hp-unauthorized-description';
        var CLOSE = '#hp-unauthorized-close';

        function NotAuthorizedView() {
            var notAuthDesc;
            var location;

            function putUserInDetail() {
                var closeLocation;
                var msg = (notAuthDesc) ? 
                        notAuthDesc : 
                        Localizer.getString('core.notAuthorized.detail_user', [session.getUser()]);
                $(DESCRIPTION).html(msg);
                
                if (location) {
                    // determine where to go. for example:
                    // /network/add -> /network
                    closeLocation = location.split('/')[1];
                    $(CLOSE).attr('href', '#/' + closeLocation);
                }
            }


            this.setDescription = function(desc) {
                notAuthDesc = desc;
            };
            
            this.setLocation = function (locationArg) {
                location = locationArg;
            };
            
            this.init = function() {
                putUserInDetail();
            };

            this.resume = function() {
                putUserInDetail();
            };
        }

        return new NotAuthorizedView();
    }());

    return NotAuthorizedView;
});
