// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/switch/SwitchPresenter',
    'hp/core/Router',
    'hp/view/FlyoutView',
    'hpsum/view/switch/SwitchUtilizationFlyoutView',
    'text!hpsumpages/switch/utilization_flyout.html',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpPlot',
    'lib/jquery.dateFormat',
    'hp/lib/date'],
function(presenter, router, FlyoutView, utilizationFlyoutView, utilizationFlyoutHtml, localizer) { "use strict";

    var SwitchMoreView = (function() {
      
        var VIEW = '#tour-switch-show';
        var PANELS = '#tour-switch-more-panels';
        var PANEL_SELECTOR = '#tour-switch-panel-selector';
        var ROUTE_PATHS = '(general|connectivity)';
        var ROUTE_PREFIX = '/switch/show/' + ROUTE_PATHS;
      
        /**
         * Constructor
         */
        function SwitchMoreView() {
            
            var flyoutView;
          
            function onAssociationsChange(tree) {
                var devices;
                if (tree.parents.DEVICE_TO_SWITCH) {
                    devices = tree.parents.DEVICE_TO_SWITCH;
                }
                
                if (devices) {
                    $('#tour-switch-devices').attr('href', '#/type/show?' +
                        'f_euri=' + tree.resource.uri +
                        '&f_an=DEVICE_TO_SWITCH').
                        text(devices.length + ' devices');
                } else {
                    $('#tour-switch-devices').attr('href', '').text('');
                }
            }
            
            function onItemChange(item) {
                if (item) {
                    $('.hp-switch-context > .hp-switch > .hp-device > label').html(item.name);
                    $('.hp-switch-context > .hp-switch > .hp-device > .hp-status').hpStatus(item.status, item.changing);
                } else {
                }
            }

            function onItemError(errorMessage) {
            }
            
            function changeLocation(location) {
                $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
            }
            
            function deltaTick(tick, axis) {
                if (0 === tick) {
                    return 'now';
                } else {
                    return tick + ' m';
                }
            }
            
            function initStatistics(container) {
                var deltas = [0, -5, -10, -15, -20, -25];
                var data1 = [[-25, 2], [-20, 1], [-15, 3], [-10, 5], [-5, 4], [0, 6]];
                var data2 = [[-25, 3], [-20, 2], [-15, 1], [-10, 4], [-5, 3], [0, 2]];
                $('.hp-statistic', container).each(function(index, elem) {
                    var statistic = $(elem);
                    $.hpPlot($(".tour-uplink-plot", statistic), [
                            {label: localizer.getString('hpsum.switchUI.transmitted'), data: data1},
                            {label: localizer.getString('hpsum.switchUI.received'), data: data2}
                        ], {
                            xaxis: {ticks: deltas, tickFormatter: deltaTick},
                            yaxis: {min: 0.0, max: 10.0},
                            legend: { show: true, container: $('.tour-uplink-plot-legend', statistic) }
                        });

                    $('.tour-uplink-plot-legend table', statistic).
                        prepend('<thead><tr><th></th><th></th><th class="hp-sidebar">' + localizer.getString('hpsum.switchUI.average') + '</th></tr></thead>');
                    $('.tour-uplink-plot-legend table tbody tr', statistic).each(function (index, row) {
                        $(row).append('<td>4.3 Gb/s</td>');
                    });
                });
            }
            
            function onExpand() {
                if ($(this).hasClass('tour-statistics') &&
                    $('.hp-plot', this).children().length === 0) {
                    initStatistics($(this));
                }
            }
            
            function toggleExpansion(row) {
                if (row.hasClass('hp-expanded')) {
                    $('> td > .hp-collapser', row).removeClass('hp-active');
                    row.removeClass('hp-expanded');
                    row.next().hide();
                } else {
                    $('> td > .hp-collapser', row).addClass('hp-active');
                    row.addClass('hp-expanded');
                    if ($('.hp-plot', row.next()).children().length === 0) {
                        initStatistics(row.next());
                    }
                    row.next().show();
                }
            }
            
            /**
             * @public
             */
            this.pause = function () {
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                presenter.off("associationsChange", onAssociationsChange);
            };
            
            this.resume = function () {
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                presenter.on("associationsChange", onAssociationsChange);
            };
            
            this.init = function() {
              
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
              
                router.watch('switch more section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                
                $(VIEW + ' .hp-status').hpStatus();
                $(VIEW + ' .hp-usage').hpUtilizationMeter();
                $(VIEW + ' .hp-usage').hpUtilizationMeter(21,0,100,75);
                $(VIEW + ' .hp-collapsible').hpCollapsible().click(onExpand);
                $(VIEW).on('click', 'td > .hp-collapser', function (ev) {
                    toggleExpansion($(this).parents('tr').first());
                });
                $('#tour-downlinks .tour-downlink-nics .hp-row-details-row').hide();
                
                flyoutView = new FlyoutView($(VIEW + ' .hp-usage'),
                    utilizationFlyoutHtml, utilizationFlyoutView);
                
                this.resume();
            };
            
        }

        return new SwitchMoreView();
    }());
    
    return SwitchMoreView;
});
