//(C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define([], function() {"use strict";
    return {
        menu : "Settings",
        development : {
            title : "Development Settings",
            "short-title" : "Development",
            refresh_interval : "Refresh Interval",
            ms : "milliseconds",
            max_master_items : "Maximum number of items in master pane",
            experimental_features : "Experimental features",
            "routing-log-level" : "Routing log level",
            edit : {
                title : "Edit Development Settings",
                success : "Updated development settings"
            }
        },
        appliance : {
            title : "Appliance",
            overview : {
                hostname: "Host name",
                ipaddr: "IP address",
                ipaddr2: "Second IP address",
                version: "Version",
                model: "Model",
                datetime: "Date/time"
            },
            general: {
                title: "General",
                hostname: "Appliance host name",
                model: "Model number",
                serial: "Serial number",
                version: "Firmware version",
                date: "Firmware date"
            },
            IPv4: {
                title: "IPv4",
                address: {
                    "1node": "IP address",
                    "2node": "Floating IP address"
                },
                address2: {
                    "1node": "Second IP address"
                },
                addrtype: {
                    "1node": "Address assignment",
                    "2node": "Fixed address assignment"
                },
                node1: "Node 1 fixed IP address",
                node2: "Node 2 fixed IP address",
                subnet: "Subnet mask or CIDR",
                gateway: "Gateway address"
            },

            DNS: {
                title: "DNS",
                preferred: "Preferred DNS server",
                alternate: "Alternate DNS server"
            },
            timeandplace: {
                title: "Time and Place",
                currentdatetime: "Current date/time",
                timezone: "Timezone",
                ntpserver: "NTP server",
                locale: "Locale",
                ntpnotconfigured:"not configured"
            },
            backup: {
                title: "Backup",
                created: "Created",
                started: "Started",
                failed: "Failed",
                downloaded: "Downloaded",
                filename: "Filename",
                none: "none",
                never: "never",
                progress: "in progress",
                cancelprogress: "cancel in progress",
                error : "Error",
                resolution : "Resolution",
                by: "{0} by {1}"
            },
            IPv6: {
                title: "IPv6",
                address: {
                    "1node": "IP address",
                    "2node": "Floating IP address"
                },
                 address2: {
                    "1node": "Second IP address"
                },
                addrtype: {
                    "1node": "Address assignment",
                    "2node": "Fixed address assignment"
                },
                node1: "Node 1 fixed IP address",
                node2: "Node 2 fixed IP address",
                subnet: "Subnet mask or CIDR",
                gateway: "Gateway address"
            },
            platform : {
                vm : "virtual machine"
            },
            addrType: {
                STATIC: "Manual",
                DHCP: "DHCP",
                UNCONFIGURE: "Off"
            },
            fromDHCP: "from DHCP",
            updateLink : "Update",
            host : {
                name : "Host name",
                ip : "IP address"
            },
            versionReady : "Version: {0} (Ready to install)",
            fileName : "Source file: {0}",
            version : "Version",
            hardware : "Hardware",
            applianceVersion : "Appliance version",
            update : {
                title : "Update Appliance",
                remove : "Remove",
                usersWarning : "<span id='cic-settings-update-usersWarning'>{0} other users</span> are " +
                               "logged into the appliance.</br>" +
                                "Updating the appliance may cause them to lose any work in progress.",
                cancelUpload : "Cancel upload",
                performUpdate : "Perform update",
                readyToInstall : "{0} (ready to install)",
                timeEstimate : "Estimated time to update: {0} minutes",
                rebootRequired : "Appliance restart required",
                releaseNotes : "Release notes",
                currentStatus: "Current status:",
                updateStatus: "{0}% completed",
                progress : "Updating appliance:",
                failureMessage : "Appliance update failed. The appliance will restart and restore to the original state",
                progressInfo : "The browser will reconnect when the update is complete." +
                        "</br>You can also close this browser and log in again later if you prefer.",
                progressTime : "{0} minutes remaining",
                progressTimeOneMinute : "{0} minute remaining",
                installUpdate : "Install update",
                checktext : "Go to hp.com for latest ",
                check : "updates",
                uploading : "uploading",
                applyWarning : "The update will cause a temporary service interruption, estimated to last {0} minutes.",
                applyWarningOtherUsers : "They will be locked out when the update starts and " +
                                         "may lose their work.",
                applyContinue : "Continue with the update?",
                applyUpdate: "Yes, update",
                applyBoxUsersLoggedIn : "{0} other users are logged in. They will be locked out when the update starts and " +
                                         "may lose their work.",
                applyBoxOneUserLoggedIn : "{0} is logged into the appliance. </br> Updating the appliance may cause "+
                                          "this user to lose any work in progress.",
                applianceReboot : "The appliance is about to restart."
             }
        },
        network : {
            panel: {
                hostname: "General",
                ipv4: "IPv4",
                dns: "DNS",
                ipv6: "IPV6",
                timeandplace: "Time and Place"
            },
            "short-title" : "Network",
            dhcpWarning : "DHCP is not supported for assigning appliance IP addresses unless DHCP reservations"  +
                          " are used. " ,
            datetimeWarning : "Changing the current date and time of the appliance will affect all the logged-in users and current jobs that are running in the appliance, so a restart of the appliance is mandatory after applying the change." ,              
            timezoneWarning : "Time zone changes will be reflected after restarting the appliance." ,
            localeWarning : "Locale changes will be reflected after restarting the appliance." ,
            dhcpDisallowed : "DHCP configuration is not allowed",
            gatewayWarning : "Specify a gateway address if the appliance needs to be accessed from a different subnet." ,
            
            dialog : {
                action : "Applying network settings. Please restart the appliance if the date and time of the appliance was changed manually.",
                certwarn : "Accept certificates if the browser prompts you to.",
                redirect : "Browser will redirect to new settings in {0} seconds or less.",
                browserwarn :"Some browser security settings can interfere with the handling of errors." +
                             " If the appliance becomes unreachable, consult the printed appliance documentation " +
                             "for recovery actions."
            },
            error : {
                get : {
                    msg:  "Unable to retrieve network settings.",
                    res : "Consult the printed appliance documentation for recovery actions."
                },
                set : {
                    timeout : {
                        msg : "The appliance is no longer reachable after changing its network configuration.",
                        res : "Verify connectivity between this browser and the appliance's new network address." +
                                "  Consult the printed appliance documentation for other recovery actions.",
                        resDhcp : "The network configuration has been changed from static to DHCP. The appliance " +
                                "is not reachable via the hostname." +
                                "Verify that the hostname or IP address is reachable, open a new browser " +
                                "and connect to the new hostname or IP address."
                    },
                    unknown : {
                        msg : "Unable to apply network settings.",
                        res : "Restart the appliance. If the network settings are not applied after restarting " +
                              " the appliance, contact HP support."
                    }
                }
            },
            fields : {
                addrselector: {
                    full: "Address assignment",
                    short: "Address"
                },
                ipv6switch : "IPv6",
                ipv6state : {
                    on : "ON",
                    off : "OFF"
                },

                dns1 : {
                    full : "Preferred DNS server",
                    short : "Preferred"
                },
                dns2 : {
                    full : "Alternate DNS server",
                    short : "Alternate"
                },
                manualdatetime : {
                    full : "Set date/time manually"
                },
                syncwithserver : {
                    full : "Synchronize with time server"
                },
                ntpserver : {
                    full : "Network time server"
                },
                currentdatetime : {
                    full : "Current date and time"
                },
                currentdatetimelabel : {
                    full : "Current date and time"
                },
                timezone : {
                    full : "Time zone"
                },
                locale : {
                    full : "Default language / locale"
                },
                gateway : {
                    both : "Gateways",
                    full : "Gateway address",
                    short : "Gateway"
                },
                hostname : {
                    full : "Appliance host name",
                    short : "Name"
                },
                ipaddr : {
                    short : "IP address",
                    fromDHCP : "from DHCP",
                    node1 : {
                        full : "Node 1 fixed IP address",
                        short : "Node 1"
                    },
                    node2 : {
                        full : "Node 2 fixed IP address",
                        short : "Node 2"
                    },
                    "one-node" : {
                        both : "IP addresses",
                        full : "IP address",
                        short : "IP address"
                    },
                    "two-node" : {
                        both : "Floating IP addresses",
                        full : "Appliance floating IP address",
                        short : "Floating IP address"
                    }
                },
                ipaddr2 : {
                    short : "Second IP address",
                    node1 : {
                        full : "Node 1 Second fixed IP address"
                    },
                    node2 : {
                        full : "Node 2 Second fixed IP address"
                    }
                },
                iptype : {
                    ipv4 : "IPv4 configuration",
                    ipv6 : "IPv6 configuration",
                    "one-node" : " ",
                    short : "Configuration",
                    "two-node" : {
                        fixed : "Fixed IP address assignment",
                        floating : "Floating IP address assignment"
                    }
                },
                proxy : {
                    short : "Web proxy"
                },
                slaac : "SLAAC IP address",
                subnet : {
                    both : "Subnets",
                    full : "Subnet mask or CIDR",
                    short : "Subnet"
                }
            },
            headings : {
                appliance : "Appliance",
                dns : "DNS",
                ha : "High Availability",
                ipv6 : "IPv6"
            },
            iptype : {
                dhcp : "DHCP",
                manual : "Manual",
                off : "Off"
            },
            notify : {
                sourceName : "Appliance Network",
                set : {
                    parameterError : "Invalid Parameters. Correct any errors before proceeding.",
                    verify : "Verifying network settings...",
                    start : "Applying network settings. Please restart the appliance if the date and time of the appliance was changed manually.",
                    success : "Configuration saved.",
                    error : "Unable to apply settings.",
                    warning :"Warnings encountered during validation.",
                    warning_resolution:"Click OK to proceed anyway." 
                }
            },
            "slaac-ip-address" : "SLAAC IP address",
            title : "Appliance Networking",
            "dns-info" : "DNS",
            validator : {
                dns : {
                    ipv4_only : "Enter a valid IPv4 address of a DNS server.",
                    ipv4_ipv6 : "Enter a valid IPv4 or IPv6 address of a DNS server."
                },
                "gateway-ipv4" : "Enter a valid IPv4 gateway address.",
                "gateway-ipv6" : "Enter a valid IPv6 gateway address.",
                hostname : {
                    fqdn_optional : "Enter a valid hostname or fully qualified domain name.",
                    fqdn_required : "Enter a valid, fully qualified domain name."
                },
                ntpserver : {
                    ntp_fqdn_required : "Enter a valid, fully qualified domain name of the NTP server.",
                    set_date_time_manually : "Set date/time manually"
                },
                currentdatetime : {
                    datetime_required : "Select a valid Date and time using the date picker.",
                    datetime_format_resolution : "Ensure that the date/time is formatted as yyyy-mm-dd hh:mm:ss."
               },
                timezone : {
                     timezone_required : "Select a valid Timezone."
                },
                locale : {
                    locale_required : "Select a valid locale."

               },
                ipv4 : "Enter a valid IPv4 address.",
                ipv6 : "Enter a valid IPv6 address.",
                "mask-ipv4" : "Enter a valid IPv4 network mask, or a CIDR bit count between 0 and 32.",
                "mask-ipv6" : "Enter a valid IPv6 network mask, or a CIDR bit count between 0 and 128."
            },
            edit : {
              title : "Edit Appliance"
            }
        },
        authn : {
            title : "Authentication",
            "short-title" : "Authentication",
            allow_local : "Allow local login",
            default_provider : "Default directory",
            providers : "Providers",
            get_failed : "Failed to retrieve one or more authentication settings.",
            providers_not_set : "not set",
            enabled : "Enabled",
            disabled : "Disabled",
            local : "Local",
            default_directory : " (default)",
            failed_get_global_settings : "Failed to retrieve global settings.",
            failed_set_default_provider : "Failed to set the default provider.",
            refresh_and_verify_provider : "Refresh the page and verify that the provider you are looking for exists.",
            auth_settings_error : "Authentication settings error:",
            failed_get_provider_info : "Failed to get the  provider info",
            plus_more : "plus {0} more",
            enable_local_login : "Enabled",
            explain_login_provider : "To disable Local login you must log in using another authentication service.",
            edit : {
              title : "Edit Authentication",
              success : "Updated authentication settings",
              add_authn_service : "Add directory",
              service_name : "Directory name",
              remove : "Remove",
              verify : "Verify Authentication",
              protocol : "Protocol",
              baseDN : "Base DN",
              directory_servers : "Directory servers",
              add_server : "Add server",
              host_name : "Host name",
              default_dir_error : "Local login is not allowed. Choose an option other than LOCAL for default directory.",
              default_dir_delete_error : "Cannot remove default directory. Change the default directory and try again.",
              default_dir_delete_error2 : "Cannot delete a directory and have the same set as default directory!",
              directory_server_required_error : "At least one directory server is required.",
              baseDN_required_error : "All three values are required.",
              host_name_error : "Provide a host name.",
              save_failure : "The Add operation could not be completed because one or more required entries are " +
                  "either missing or invalid. Enter the missing data and try again.",
              failure_resolution : "Fix the errors and try again.",
              directory_server_duplicate_error : "Directory service names cannot be duplicated."
            },
            addDirectory : {
                title : "Add Directory",
                directory_name : "Directory",
                directory_type : "Directory type",
                search_context : "Search context",
                search_context_uid : "Search context (UID)",
                search_context_org : "Search context (Organization)",
                search_context_top : "Search context (Top Level Domain)",
                credentials_title : "Credentials (used to verify server connection and will not be saved)",
                username : "User name",
                password : "Password",
                directory_servers : "Directory servers",
                add_directory_server : "Add directory server",
                success_notification : "Update Directories",
                add_success : "Add directory {0}",
                remove_server_success : "Removed {0}",
                invalid_naming_attribute : "Incorrect value. " +
                    "Enter CN or UID depending upon AD/LDAP server configuration."
            },
            addServer : {
                title : "Add Directory Server",
                host_name : "IP address or host name",
                ssl_port : "Directory server port",
                certificate : "Directory server certificate",
                success : "Change : Directory servers to {0}",
                table_column_server : "Server",
                table_column_certificate : "Certificate",
                certificate_state_yes : "Yes",
                duplicate_host : "Duplicate host name or IP address. Specify a different directory server.",
                invalid_host : "Invalid host name or IP address.",
                invalid_port : "Invalid port number - has to be a numeric value.",
                invalid_port_range : "Invalid port number range. (Range: 0 to 65535.) ",
                invalid_certificate : "The certificate entered does not appear to be X.509 certificate. " +
                    "Enter valid AD/LDAP server certificate."
            }
        },
        overview : {
            title : "Settings"
        },
        auditlogs : {
            download : "Download audit logs"
        },
        edit : {
            title : "Edit Settings",
            saved : "Settings have been saved."
                },
        supportdump : {
            title : "Create Support Dump",
            error_creating_dump : "Error Creating Dump",
            createtitle : "Create support dump",
            create_button : "Yes, create",
            creating_dump : "Create support dump",
            create_dump : "Creating a support dump may take a few minutes after which the file download " +
                          "will begin automatically. Meanwhile, you can continue to use the UI normally. ",
            dump_created : "Successfully Created Dump",
            create_prompt : "Do you want to create a support dump now?"

        },
        factoryReset: {
            title: "Reset Appliance to Factory Defaults",
            factoryResetAction : "Factory Reset",
            warning: "This operation will erase all data, logs and settings on the appliance.",
            partialResetOption : "Reset to factory defaults while preserving appliance network settings",
            paritalResetInfo : "Useful when reusing the appliance in the same environment with the same " +
                "appliance network settings.",
            fullResetOption : "Full appliance factory reset to defaults",
            fullResetInfo : "Useful when repurposing the appliance in another environment with different network settings.",
            fullResetWarning : "If the network settings change as a result of the factory reset, the browser could " +
                "lose connectivity to the appliance. If this occurs, open a new browser to connect to the appliance's " +
                "new address, or alternatively use the kiosk interface on the appliance console. ",
            startFailure : " Factory Reset failed to start.",
            ok: "OK"
        },
        shutdown: {
            title:"Shutdown Appliance",
            shutdownAction: "Shut down",
            warning:"Shutdown will cause all users to be logged out and all ongoing tasks to be cancelled.",
            start_prompt : "Continue shutdown?",            
            ok: "Yes, shut down." ,
            errorMsg : "Unable to perform shutdown."
        },
        restart: {
            title:"Restart Appliance",
            shutdownAction: "Restart",
            warning:"Restart will cause all users to be logged out and all ongoing tasks to be cancelled.",
            start_prompt : "Continue restart?",
            ok: "Yes, restart." ,
            errorMsg : "Unable to perform restart."
        },
        restore: {
            title: "Restore from Backup",
            restoreAction : "Restore from backup",
            backupFileTitle : "Backup file",
            restoreFromBackup : "Restore from backup",
            fileName : "Name: {0}",
            createDate: "Created: {0}",
            version : "Version: {0}.{1}.{2}.{3}",
            backupTooBigErrMsg : "Backup is too large to upload.",
            backupTooBigResolutionMsg : "Select a backup smaller than {0} bytes.",
            applyWarning : "Restore will delete and replace all your data. Click the \"Restore from Backup\" button " + 
                           "to start the restore. Click the \"Cancel\" button to cancel.",
            applyBoxUsersLoggedIn : "{0} other users are logged in. They will be locked out when the restore starts and " +
                                         "may lose their work.",
            applyBoxOneUserLoggedIn : "{0} is logged into the appliance. </br> Starting a restore may cause "+
                                          "this user to lose any work in progress.",
            restoreStarted : "Restoring from backup ..."                               
        },
        backup: {
            backupAction : "Create backup",
            backupDownloadAction: "Download backup",
            backupDownloadLinkLabel: "Download most recent backup",
            unableToStartBackup: "Unable to start backup.",
            backupDidNotComplete: "The backup did not complete.",
            errorGettingBackupProgress: "Unable to get backup progress information.",
            unableToDownloadBackup: "Unable to download backup.",
            noBackup: "No backup exists.",
            backupInProgress: "A backup is already in progress.",
            waitForBackupToComplete: "Wait until the backup completes, and then retry the operation.",
            createBackupAndRetry: "Create a backup, and then retry the operation.",
            errorCancellingBackup: "Unable to cancel backup.",
            backupCreateDetails: "Backup started by {0}.",
            backupDownloadSummary: "Download backup",
            backupDownloadDetails: "Backup {0} download requested by {1}.",
            completedDetails: "Backup completed and ready to download.</br></br>Backup {0} was created by {1}.",
            canceledDetails: "Backup {0} canceled.",
            backupSourceName: "Appliance"
        },
        security : {
          title : "Security",
          overview : {
            cert_title : "Certificate",
            common_name : "Cert common name (CN)",
            valid_until : "Valid until",
            expires_in : "(expires in {0} days)",
            expires_message : "Appliance certificate expires in {0} days.",
            expires_detail_message : "Certificate expires on {0}, {1} days from now." +
                        "</br></br>Resolution: Import a new certificate using {2} " +
                        "or {3}.",
            auth_title : "Authentication",
            local_login : "Local login",
            default_directory : "Default directory",
            directories : "Directories",
            add_directory : "Add directory"
            },
            publickey : {
                title : "Key",
                download_location_msg : "The latest HP public key is available from {0}.",
                uploaded : "Uploaded HP Public Key",
                display_content : "Display Content",
                paste_message : "Paste Key Here",
                key_message : "This key is used to validate the authenticity of all patches " +
                              " and updates."
            },
            edit_security_title: "Edit Security",
            panel: {
                authentication : "Authentication",
                hp_public_key : "HP Public Key"
            },
            more :{
                directories : "Directories",
            authn :{
              active_directory : "Active Directory",
              open_ldap : "OpenLDAP",
                directory_type : "Directory type",
                naming_attribute: "Naming attribute",
                search_context : "Search context",
                directory_servers : "Directory servers",
                no_directories : "No directories"
             }
            },
            edit_authn : {
              edit_directory_title : "Edit Directory",
              edit_directoryserver_title : "Edit Directory Server",
              delete_title : "Delete {0}",
              delete_message : "Are you sure you want to delete {0}?"+
                                "<br/><br/>Continue with delete?",
              delete_yes :"Yes, delete"
            }
        },
        certificate : {
            title : "Certificate Settings",
            selfsigned : {
              create_action_title : "Create self-signed certificate",
              create_title : "Create Self-Signed Certificate",
              required_information : "Required Information",
              optional_information : "Optional Information",
              create_success : "Self-signed certificate created.",
              create_error : "Unable to create self-signed certificate.",
              get_error : "Unable to retrieve current self-signed certificate.",
              update_button : "Yes, update",
              cancel_button : "Cancel",
              dialog : {
              title : "Update Certificate",  
                update : "Applying update...",
                certwarn : "You may need to accept browser certificates warnings when the browser refreshes.",
                restartwarn : "Warning: Updates to the certificate will require the appliance web server to be " +
                            "restarted. There will be a temporary service interruption estimated to last 30 seconds.",
                reconnectmsg :"You will automatically be reconnected when the system is available again.",
                continue_update : "Continue with the update?",
                usersLoggedIn : "{0} other users are logged in",
                oneUserLoggedIn : "1 other user is logged in",
                remaining : "{0} seconds remaining"
              },
              error : {
                timeout : {
                  msg : "The appliance is no longer reachable after restarting the web server.",
                  res : "Verify connectivity between this browser and the appliance's network address." +
                         "  Consult the printed appliance documentation for other recovery actions."
                },
                unknown : {
                    msg : "Unable to create self-signed certificate.",
                    res : "Restart the appliance. If unable to create a self-signed certificate after restarting " +
                          " the appliance, contact HP support."
                },
                support_dump_link : "Create a support dump",
                support_dump_link_message : "If the issue persists, {0} and contact your authorized support " +
                             "representative for assistance."
              }
            },
            country : "Country (C)",
            state : "State or province (ST)",
            locality : "City or locality (L)",
            org : "Organization name (O)",
            cn : "Common name (CN)",
            ou : "Organizational unit",
            alt_name : "Alternative name",
            contact : "Contact person",
            email : "Email address",
            surname : "Surname",
            given_name : "Given name",
            initials : "Initials",
            dn : "DN qualifier",
            explain_comma_list : "Enter a comma separated list of alternate names (such as hostname, IP address).  " +
                                 "The CN is a required alternative name and will be added automatically if not supplied here.",
            hostname_regen_cert_warn    : "Changing the hostname requires generating a new SSL certificate " +
                                 "for secure communications with your browser. ",
            hostname_regen_cert_warn_csr    : "Changing the hostname requires generating a new SSL certificate " +
                                 "for secure communications with your browser. " +
                                 "This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",
            ipaddress_regen_cert_warn    : "Changing the IP address requires generating a new SSL certificate " +
                                 "for secure communications with your browser. ",
            ipaddress_regen_cert_warn_csr    : "Changing the IP address requires generating a new SSL certificate " +
                                 "for secure communications with your browser. " +
                                 "This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",
            hostname_cn_mistmatch    : "Host name and common name of the certificate are different. This requires generating a new SSL certificate " +
                                 "for secure communications with your browser. ",
            hostname_cn_mistmatch_csr    : "Host name and common name of the certificate are different. This requires generating a new SSL certificate " +
                                 "for secure communications with your browser. " +
                                 "This also requires generating another CSR and getting a new signed SSL certificate and importing it to the appliance.",
            validator : {
              host_or_ip_required : "Specify valid hostnames or IP addresses.",
              max_length : "Enter no more than {0} characters.",
              max_length_no_cn : "The CN is automatically added to this field, but doing so will exceed the " +
                                 "max size limit of {0}. Allow enough space to account for the CN.",
              matchpasswd : "Passwords must match.",
              passwdvalidation : "Password should not contain any of < > ; , \" ' & \\ / | + : = and space."

            },
            more_title : "Certificate",
            required_information : "Required Information",
            optional_information : "Optional Information",
            common_name : "Cert common name (CN)",
            issued_by : "Issued by",
            valid_from : "Valid from",
            valid_until : "Valid until",
            serial_number : "Serial number",
            version : "Version",
            md5_fingerprint : "MD5 fingerprint",
            sha1_fingerprint : "SHA1 fingerprint",
            cert_sign_req_attr : "Certificate Signing Request Attributes",
            unstructured_name : "Unstructured name",
            csr : {
              create_action_title : "Create certificate signing request",
              create_title : "Create Certificate Signing Request",
              required_information : "Required Information",
              optional_information : "Optional Information",
              create_success : "Certificate signing request created.",
              create_error : "Unable to create certificate signing request.",
              get_error : "Unable to retrieve current certificate.",
              ok_button : "OK",
                cancel_button : "Cancel",
                challenge_password : "Challenge password",
                confirm_password : "Confirm password",
                dialog : {
                  base64_save : "The following base64 encoded data may be used to request a certificate from a " +
                              "certificate server. Copy the data below and use it to make a certificate request. " +
                              "Once you receive your certificate, import it using the \"Actions->Import certificate\" " +
                              "menu item in the Settings page."
                },
                error : {
                  support_dump_link : "Create a support dump",
                  support_dump_link_message : "If the issue persists, {0} and contact your authorized support " +
                               "representative for assistance."
                }
            },
            signedimport : {
              import_success : "Appliance certificate Imported.",
              import_action_title : "Import certificate",
              import_title : "Import Certificate",
              import_paste : "Paste a certificate to import it into the appliance.",
              certificate : "Certificate",
              dialog : {
                  importing : "Importing certificate...",
                  certwarn : "You may need to accept browser certificates warnings when the browser refreshes.",
                  restartwarn : "Warning:  Importing a new certificate will require the appliance web server to be " +
                              "restarted. There will be a temporary service interruption estimated to last 30 seconds.",
                  reconnectmsg :"You will automatically be reconnected when the system is available again.",
                  usersLoggedIn : "{0} other users are logged in",
                  oneUserLoggedIn : "1 other user is logged in",
                  remaining : "{0} seconds remaining"
              },
              error : {
                unknown : {
                  msg : "Unable to import signed certificate.",
                  res : "Restart the appliance. If unable to import a signed certificate after restarting " +
                        " the appliance, contact HP support."
                }
              }
            }
        },
        eula : {
            config : {
                appliance_name : "Virtual Appliance",
                end_user_title : "License",
                eula_title : "End-User license agreement",
                agree_button : "Agree",
                disagree_button : "Disagree",
                yesdisagree_button : "Yes, disagree",
                confirmation_dialog_advice : "If you disagree with the terms of the End-User License agreement, you cannot proceed.",
                end_user_support_title : "support",
                application_support : "Application Support",
                warning : "warning",
                written_offer : "Written offer",
                enabled : "Enabled",
                disabled : "Disabled",
                support : "Support",
                license : "License",
                support_access_enabled : "HP Support Access",
                edit_appliance_support_access : "Edit support access"
            }
        }
    };
});