// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router'],
function (router) { "use strict";

    var SupportDumpRoutes = ( function() {

        var CONFIRM_CONTAINER = '#hp-dialog-container';
        var AUTH_CATEGORY = 'appliance';

        function SupportDumpRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings support dump', '/settings/support/createSupportDump(/.*|$)', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/settings/support/create.html',
                            'hp/view/settings/support/SupportDumpCreateView'],
                        function (page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new SupportDumpRoutes();
    }());

    return SupportDumpRoutes;
});
